TITAN_CRITLINEDMG_ID = "CritlineDmg";
----------------------------------------------------------------
function TitanPanelCritlineDmgButton_OnLoad()
	this.registry = {
		id = TITAN_CRITLINEDMG_ID,
		category = "Combat",
		version = CRITLINE_VERSION,
		menuText = "Critline Damage",
		buttonTextFunction = "TitanPanelCritlineDmgButton_GetButtonText", 
		tooltipTitle = "Critline Damage", 
		tooltipTextFunction = "TitanPanelCritlineDmgButton_GetTooltipText",
		icon = "Interface\\AddOns\\Critline\\Icons\\CritlineDmg",	
		iconWidth = 16,
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			ShowColoredText = 1,
		}
	};
	--Subscribe to Critline_OnUpdate event.
	Critline_OnUpdateRegister(TitanPanelCritlineDmgButton_OnUpdate);
end
----------------------------------------------------------------
function TitanPanelCritlineDmgButton_OnClick(button)
	if CritlineSettings_Frame:IsVisible() then
		CritlineSettings_Frame:Hide();
	else
		CritlineSettings_Frame:Show();
	end
end
----------------------------------------------------------------
function TitanPanelCritlineDmgButton_GetButtonText(id)
	labelText = "D: ";
	local amountcrit = Critline_Color(HEADER_TEXT_COLOR,Critline_GetHighest("DMG", "CRIT"));
	local amountnorm = Critline_Color(HEADER_TEXT_COLOR,Critline_GetHighest("DMG", "NORM"));
	rtfText = amountnorm.."/"..amountcrit;
	return labelText, rtfText;
end
----------------------------------------------------------------
function TitanPanelCritlineDmgButton_GetTooltipText()
    return Critline_GetSummaryRichText("DMG");
end
----------------------------------------------------------------
function TitanPanelRightClickMenu_PrepareCritlineDmgMenu()
	TitanPanelRightClickMenu_AddTitle(TitanPlugins[TITAN_CRITLINEDMG_ID].menuText);
	TitanPanelRightClickMenu_AddToggleIcon(TITAN_CRITLINEDMG_ID);
	TitanPanelRightClickMenu_AddToggleLabelText(TITAN_CRITLINEDMG_ID);
	TitanPanelRightClickMenu_AddToggleColoredText(TITAN_CRITLINEDMG_ID);
	
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand("Settings", TITAN_CRITLINEDMG_ID, "CritlineSettings_ShowSettings");
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, TITAN_CRITLINEDMG_ID, TITAN_PANEL_MENU_FUNC_HIDE);
end
----------------------------------------------------------------
--This is the callback method Critline_OnUpdate will call when Critline DB has been updated.
function TitanPanelCritlineDmgButton_OnUpdate()
	TitanPanelButton_UpdateButton(TITAN_CRITLINEDMG_ID)
end