--[[ addon functions ]]

function CritlineSettings_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");
	CritlineSettings_Localize();

	SlashCmdList["CRITLINESETTINGS"] = function(msg)
		if (CritlineSettings_Frame:IsVisible()) then
			CritlineSettings_Frame:Hide();
		else
			CritlineSettings_ShowSettings();
		end
	end
	
	SLASH_CRITLINESETTINGS1 = "/critline"

	
end

function CritlineSettings_OnEvent()
	if (event == "VARIABLES_LOADED") then
		CritlineSettings_LoadSettings();
	end
end
function CritlineSettings_LoadSettings()
	
	--Basic Frame
	CritlineSettings_FrameBasic_Option1Text:SetText(CL_OPTION_RECORD_DMG_TEXT);
	CritlineSettings_FrameBasic_Option1.HelpText = CL_OPTION_RECORD_DMG_HELPTEXT;
	CritlineSettings_FrameBasic_Option1.Setting = "DMG";
	if (CL_SETTINGS["DMG"] == "1") then
		CritlineSettings_FrameBasic_Option1:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option2Text:SetText(CL_OPTION_RECORD_HEAL_TEXT);
	CritlineSettings_FrameBasic_Option2.HelpText = CL_OPTION_RECORD_HEAL_HELPTEXT;
	CritlineSettings_FrameBasic_Option2.Setting = "HEAL";
	if (CL_SETTINGS["HEAL"] == "1") then
		CritlineSettings_FrameBasic_Option2:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option3Text:SetText(CL_OPTION_RECORD_PET_TEXT);
	CritlineSettings_FrameBasic_Option3.HelpText = CL_OPTION_RECORD_PET_HELPTEXT;
	CritlineSettings_FrameBasic_Option3.Setting = "PET";
	if (CL_SETTINGS["PET"] == "1") then
		CritlineSettings_FrameBasic_Option3:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option4Text:SetText(CL_OPTION_PVPONLY_TEXT);
	CritlineSettings_FrameBasic_Option4.HelpText = CL_OPTION_PVPONLY_HELPTEXT;
	CritlineSettings_FrameBasic_Option4.Setting = "PVPONLY";
	if (CL_SETTINGS["PVPONLY"] == "1") then
		CritlineSettings_FrameBasic_Option4:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option5Text:SetText(CL_OPTION_PLAYSOUNDS_TEXT);
	CritlineSettings_FrameBasic_Option5.HelpText = CL_OPTION_PLAYSOUNDS_HELPTEXT;
	CritlineSettings_FrameBasic_Option5.Setting = "PLAYSOUND";
	if (CL_SETTINGS["PLAYSOUND"] == "1") then
		CritlineSettings_FrameBasic_Option5:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option6Text:SetText(CL_OPTION_SCREENCAP_TEXT);
	CritlineSettings_FrameBasic_Option6.HelpText = CL_OPTION_SCREENCAP_HELPTEXT;
	CritlineSettings_FrameBasic_Option6.Setting = "SNAPSHOT";
	if (CL_SETTINGS["SNAPSHOT"] == "1") then
		CritlineSettings_FrameBasic_Option6:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option7Text:SetText(CL_OPTION_DETAILED_TEXT);
	CritlineSettings_FrameBasic_Option7.HelpText = CL_OPTION_DETAILED_HELPTEXT;
	CritlineSettings_FrameBasic_Option7.Setting = "DETAILED";
	if (CL_SETTINGS["DETAILED"] == "1") then
		CritlineSettings_FrameBasic_Option7:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option8Text:SetText(CL_OPTION_SHOWDMG_TEXT);
	CritlineSettings_FrameBasic_Option8.HelpText = CL_OPTION_SHOWDMG_HELPTEXT;
	CritlineSettings_FrameBasic_Option8.Setting = "SHOWDMG";
	if (CL_SETTINGS["SHOWDMG"] == "1") then
		CritlineSettings_FrameBasic_Option8:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option9Text:SetText(CL_OPTION_SHOWHEAL_TEXT);
	CritlineSettings_FrameBasic_Option9.HelpText = CL_OPTION_SHOWHEAL_HELPTEXT;
	CritlineSettings_FrameBasic_Option9.Setting = "SHOWHEAL";
	if (CL_SETTINGS["SHOWHEAL"] == "1") then
		CritlineSettings_FrameBasic_Option9:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option10Text:SetText(CL_OPTION_SHOWPET_TEXT);
	CritlineSettings_FrameBasic_Option10.HelpText = CL_OPTION_SHOWPET_HELPTEXT;
	CritlineSettings_FrameBasic_Option10.Setting = "SHOWPET";
	if (CL_SETTINGS["SHOWPET"] == "1") then
		CritlineSettings_FrameBasic_Option10:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option11Text:SetText(CL_OPTION_SUPPRESSMC_TEXT);
	CritlineSettings_FrameBasic_Option11.HelpText = CL_OPTION_SUPPRESSMC_HELPTEXT;
	CritlineSettings_FrameBasic_Option11.Setting = "SUPPRESSMC";
	if (CL_SETTINGS["SUPPRESSMC"] == "1") then
		CritlineSettings_FrameBasic_Option11:SetChecked(true);
	end
	
	CritlineSettings_FrameBasic_Slider1:SetValue(tonumber(CL_SETTINGS["LVLADJ"]));
	
	--TODO: ADD BIG BUTTONS TO GENERIC TEMPLATE
	
	--Advanced Frame
	CritlineSettings_FrameAdvanced_Option1Text:SetText(CL_OPTION_SHOWMINIMAP_TEXT);
	CritlineSettings_FrameAdvanced_Option1.HelpText = CL_OPTION_SHOWMINIMAP_HELPTEXT;
	CritlineSettings_FrameAdvanced_Option1.Setting = "SHOWMINIMAP";
	if (CL_SETTINGS["SHOWMINIMAP"] == "1") then
		CritlineSettings_FrameAdvanced_Option1:SetChecked(true);
	end

	CritlineSettings_FrameAdvanced_Option2Text:SetText(CL_OPTION_SPLASH_TEXT);
	CritlineSettings_FrameAdvanced_Option2.HelpText = CL_OPTION_SPLASH_HELPTEXT;
	CritlineSettings_FrameAdvanced_Option2.Setting = "SPLASH";
	if (CL_SETTINGS["SPLASH"] == "1") then
		CritlineSettings_FrameAdvanced_Option2:SetChecked(true);
	end

	CritlineSettings_FrameAdvanced_Option3Text:SetText(CL_OPTION_MOVESPLASH_TEXT);
	CritlineSettings_FrameAdvanced_Option3.HelpText = CL_OPTION_MOVESPLASH_HELPTEXT;
	CritlineSettings_FrameAdvanced_Option3.Setting = "MOVESPLASH";
	CritlineSettings_FrameAdvanced_Option3:SetChecked(false);

	CritlineSettings_FrameAdvanced_Option4Text:SetText(CL_OPTION_INVERTDMG_TEXT);
	CritlineSettings_FrameAdvanced_Option4.HelpText = CL_OPTION_INVERTDMG_HELPTEXT;
	CritlineSettings_FrameAdvanced_Option4.Setting = "INVERTDMG";
	if (CL_SETTINGS["INVERTDMG"] == "1") then
		CritlineSettings_FrameAdvanced_Option4:SetChecked(true);
	end
	
	CritlineSettings_FrameAdvanced_Option5Text:SetText(CL_OPTION_INVERTHEAL_TEXT);
	CritlineSettings_FrameAdvanced_Option5.HelpText = CL_OPTION_INVERTHEAL_HELPTEXT;
	CritlineSettings_FrameAdvanced_Option5.Setting = "INVERTHEAL";
	if (CL_SETTINGS["INVERTHEAL"] == "1") then
		CritlineSettings_FrameAdvanced_Option5:SetChecked(true);
	end

	CritlineSettings_FrameAdvanced_Option6Text:SetText(CL_OPTION_INVERTPET_TEXT);
	CritlineSettings_FrameAdvanced_Option6.HelpText = CL_OPTION_INVERTPET_HELPTEXT;
	CritlineSettings_FrameAdvanced_Option6.Setting = "INVERTPET";
	if (CL_SETTINGS["INVERTPET"] == "1") then
		CritlineSettings_FrameAdvanced_Option6:SetChecked(true);
	end

	CritlineSettings_FrameAdvanced_Slider1:SetValue(tonumber(CL_SETTINGS["SCALE"]));
	CritlineSettings_FrameAdvanced_Slider2:SetValue(tonumber(CL_SETTINGS["SPLASHSCALE"]));
	CritlineSettings_FrameAdvanced_Slider3:SetValue(tonumber(CL_SETTINGS["SPLASHTIMER"]));

	local swatch = getglobal("CritlineSettings_FrameAdvancedColor1Swatch")
	swatch.r = CL_SETTINGS["SPELLCOLOR"]["r"]
	swatch.g = CL_SETTINGS["SPELLCOLOR"]["g"]
	swatch.b = CL_SETTINGS["SPELLCOLOR"]["b"]
	swatch:SetVertexColor(swatch.r, swatch.g, swatch.b)
	CritlineSettings_FrameAdvancedColor1.HelpText = CL_OPTION_SPLASHSPELLCOLOR_HELPTEXT;

	CritlineSettings_FrameAdvancedLabel1Label:SetText("Spell Color");
	CritlineSettings_FrameAdvancedLabel1.HelpText = CritlineSettings_FrameAdvancedColor1.HelpText
	
	local swatch = getglobal("CritlineSettings_FrameAdvancedColor2Swatch")
	swatch.r = CL_SETTINGS["AMOUNTCOLOR"]["r"]
	swatch.g = CL_SETTINGS["AMOUNTCOLOR"]["g"]
	swatch.b = CL_SETTINGS["AMOUNTCOLOR"]["b"]
	swatch:SetVertexColor(swatch.r, swatch.g, swatch.b)
	CritlineSettings_FrameAdvancedColor2.HelpText = CL_OPTION_SPLASHAMOUNTCOLOR_HELPTEXT;
	
	CritlineSettings_FrameAdvancedLabel2Label:SetText("Amount Color");
	CritlineSettings_FrameAdvancedLabel2.HelpText = CritlineSettings_FrameAdvancedColor2.HelpText

end

function CritlineSettings_ShowSettings()
	CritlineSettings_Frame:Show();
end

function CritlineSettings_CloseSettings()
	CritlineSettings_Frame:Hide();
end

function CritlineSettings_ResetRecords()
	Critline_DataReset();
end

--MOUSE ENTER / LEAVE OPTION
function CritlineSettings_ShowHelp(button)
	GameTooltip:SetOwner(this, "ANCHOR_NONE");
	GameTooltip:SetPoint("TOPLEFT", button:GetName(), "BOTTOMLEFT", -10, -4);
	GameTooltip:SetText(this.HelpText);
	GameTooltip:Show();
end
function CritlineSettings_HideHelp(button)
	GameTooltip:Hide();
end
function CritlineSettings_Button_OnClick(button)
	Critline_Debug(button.Setting.." toggled");
	if (button.Setting == "MOVESPLASH") then --temporary setting....not to be saved
		if button:GetChecked() then
			CritlineSplashFrame.locked = false
			CritlineSplashFrame:EnableMouse(1)
		else
			CritlineSplashFrame.locked = true
			CritlineSplashFrame:EnableMouse(0)
			CritlineSplashFrame:Clear();
		end
	else
		if ( button:GetChecked() ) then
			CL_SETTINGS[button.Setting] = "1";
		else
			CL_SETTINGS[button.Setting] = "0";
		end
		if (button.Setting == "SHOWDMG" or button.Setting == "SHOWHEAL" or button.Setting == "SHOWPET") then
			CritlineDisplay_UpdateTree(strsub(button.Setting,5),button:GetChecked());
		end
		if (button.Setting == "DETAILED") or (button.Setting == "INVERTDMG") or (button.Setting == "INVERTHEAL") or (button.Setting == "INVERTPET") then
			Critline_RebuildAllTooltips();
		end
		if (button.Setting == "SHOWMINIMAP") then
			if (button:GetChecked()) then
				CritlineMinimap_Frame:Show();
			else
				CritlineMinimap_Frame:Hide();
			end
		end
	end
end

local CritlineSettings_CancelFunc = {
	[1] = function(x) CritlineSettings_CancelColor(1, x) end,
	[2] = function(x) CritlineSettings_CancelColor(2, x) end,
	[3] = function(x) CritlineSettings_CancelColor(3, x) end,
	[4] = function(x) CritlineSettings_CancelColor(4, x) end,
	[5] = function(x) CritlineSettings_CancelColor(5, x) end,
	[6] = function(x) CritlineSettings_CancelColor(6, x) end
}

local CritlineSettings_SetColorFunc = {
	[1] = function() CritlineSettings_SetColor(1) end,
	[2] = function() CritlineSettings_SetColor(2) end,
	[3] = function() CritlineSettings_SetColor(3) end,
	[4] = function() CritlineSettings_SetColor(4) end,
	[5] = function() CritlineSettings_SetColor(5) end,
	[6] = function() CritlineSettings_SetColor(6) end
}

function CritlineSettings_ColorPicker(id)
	CloseMenus()
	local texture = getglobal("CritlineSettings_FrameAdvancedColor"..id.."Swatch")
	if not texture.a then
		texture.a = 1;
	end
	ColorPickerFrame.func = CritlineSettings_SetColorFunc[id]
	ColorPickerFrame:SetColorRGB(texture.r, texture.g, texture.b)
	ColorPickerFrame.previousValues = {r = texture.r, g = texture.g, b = texture.b, opacity =texture.a}
	ColorPickerFrame.cancelFunc = CritlineSettings_CancelFunc[id]
	ColorPickerFrame.hasOpacity = false
	
	ColorPickerFrame:Show()
end

function CritlineSettings_SetColor(id)
	local r, g, b = ColorPickerFrame:GetColorRGB()
	local texture = getglobal("CritlineSettings_FrameAdvancedColor"..id.."Swatch")
	--SHTSetOpacity(id)
	texture:SetVertexColor(r, g, b)
	texture.r = r
	texture.g = g
	texture.b = b
	if id == 1 then
		CL_SETTINGS["SPELLCOLOR"]["r"] = r;
		CL_SETTINGS["SPELLCOLOR"]["g"] = g;
		CL_SETTINGS["SPELLCOLOR"]["b"] = b;
	elseif id == 2 then
		CL_SETTINGS["AMOUNTCOLOR"]["r"] = r;
		CL_SETTINGS["AMOUNTCOLOR"]["g"] = g;
		CL_SETTINGS["AMOUNTCOLOR"]["b"] = b;
	end
end

function CritlineSettings_CancelColor(id, prev)
	local texture = getglobal("CritlineSettings_FrameAdvancedColor"..id.."Swatch")
	local r = prev.r
	local g = prev.g
	local b = prev.b
	local a = prev.opacity
	texture:SetVertexColor(r, g, b)
	texture:SetAlpha( a )
	texture.r = r
	texture.g = g
	texture.b = b
	texture.a = a
end

function CritlineSettings_Localize()
	CritlineSettings_Frame_HeaderText:SetText(SETTINGS);
	CritlineSettings_FrameBasic_Button1:SetText(FILTERS);
	CritlineSettings_FrameBasic_Button2:SetText(CL_ANNOUNCE_TEXT);
	CritlineSettings_FrameBasic_ButtonAdvanced:SetText(ADVANCED_OPTIONS);
	CritlineSettings_FrameAdvanced_Button1:SetText(CL_SETTINGS_RESETRECORDS_TEXT);
	CritlineSettings_FrameAdvanced_ButtonBasic:SetText(BASIC_LABEL);

	end
