function CritlineMinimap_OnTooltip(v1,v2)
	GameTooltip:SetOwner(this,"ANCHOR_LEFT")
	GameTooltip:AddLine(v1)
	GameTooltip:AddLine(v2,.8,.8,.8,1)
	GameTooltip:Show()
end

function CritlineMinimap_OnEvent(event)
	if (event=="VARIABLES_LOADED") then
		if CL_SETTINGS["SHOWMINIMAP"]=="1" then
			CritlineMinimap_Frame:Show();
		else
			CritlineMinimap_Frame:Hide();
		end 
		CritlineMinimap_MoveMinimap();
	end
end

function CritlineMinimap_OnUpdate()
	if CritlineMinimap_Dragging then
		local xpos,ypos = GetCursorPosition()
		local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom()

		xpos = xmin-xpos/Minimap:GetEffectiveScale()+70
		ypos = ypos/Minimap:GetEffectiveScale()-ymin-70

		CL_SETTINGS["MINIMAPPOS"] = math.deg(math.atan2(ypos,xpos))
		CritlineMinimap_MoveMinimap()
	end
end

function CritlineMinimap_MoveMinimap()

	local xpos,ypos
	local angle = CL_SETTINGS["MINIMAPPOS"]

	xpos = 80*cos(angle)
	ypos = 80*sin(angle)

	CritlineMinimap_Frame:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-xpos,ypos-52)

end

function CritlineMinimap_OnClick(button)
	if (button=="LeftButton") then
		if Critline_Display:IsVisible() then
			Critline_Display:Hide()
		else
			if (CL_SETTINGS["SHOWDMG"] == "0" and CL_SETTINGS["SHOWHEAL"] == "0" and CL_SETTINGS["SHOWPET"] == "0") then
				CL_SETTINGS["FIRSTLOAD"] = "1"
				CritlineDisplay_OnEvent("VARIABLES_LOADED") --if all tree are hidden when minimap is called to show, reload by class
			else
				Critline_Display:Show()
			end

		end
	elseif (button=="RightButton") then
		if CritlineSettings_Frame:IsVisible() then
			CritlineSettings_Frame:Hide()
		else
			CritlineSettings_Frame:Show()
		end
	end
end
