CLF_tree = "DMG"

function CritlineFilters_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");

	CLF_Pre_SpellButton_OnModifiedClick = SpellButton_OnModifiedClick;
	SpellButton_OnModifiedClick = CLF_SpellButton_OnModifiedClick;

	CritlineFilters_Localize();
	CritlineFilters_TreeInitialize();
end

function CLF_SpellButton_OnModifiedClick(drag)
	if ( IsShiftKeyDown() ) then
		if (Critline_Filters:IsVisible()) then
			local spellId = SpellBook_GetSpellID(this:GetID());
			if ( spellId > MAX_SPELLS ) then
				return;
			end
			local spellName, spellRank = GetSpellName( spellId, SpellBookFrame.bookType );
			CritlineFilters_AddSpell(spellName,CLF_tree);
			return;
		end
    end
    CLF_Pre_SpellButton_OnModifiedClick(drag);
end

function CritlineFilters_ShowFilters()
	Critline_Filters:Show()
	CritlineSettings_Frame:Hide();
end

function CritlineFilters_AddTarget()
	local targetName = UnitName("target");
	if (targetName) then
		if not CritlineFilters_IsMobInFilter(targetName) then
			tinsert(CL_MOBFILTERS["mobs"],targetName);
			CLFMobScrollBar_Update()
		end
	end
end

function CLFMobScrollBar_Update()
	local line -- 1 through 10 of our window to scroll
	local lineplusoffset -- an index into our data calculated from the scroll offset
	local size = nil;
	if CL_MOBFILTERS["mobs"] then
		size = table.getn( CL_MOBFILTERS["mobs"] );
	end
	if not size then
		size = 0;
	end
	FauxScrollFrame_Update(CLFMobScrollBar,size,10,16)
	for line=1,10 do
		lineplusoffset = line + FauxScrollFrame_GetOffset(CLFMobScrollBar)
		if( lineplusoffset <= size ) then
			getglobal("CLFMobButton"..line):SetText(CL_MOBFILTERS["mobs"][lineplusoffset])
			getglobal("CLFMobButton"..line):Show()
		else
			getglobal("CLFMobButton"..line):Hide()
		end
	end
end

function CLFSpellScrollBar_Update()
	local line -- 1 through 10 of our window to scroll
	local lineplusoffset -- an index into our data calculated from the scroll offset
	local CL_SPELLS = {}

	if CL_FILTERS[CLF_tree] then
		for k,v in pairs(CL_FILTERS[CLF_tree]) do
			tinsert(CL_SPELLS,v);
		end
		for k,v in pairs(CL_DATABASE[CLF_tree]) do
			if type(k) == "number" then
				CL_DATABASE[CLF_tree][k] = nil; -- need to get rid of old 113 errors...they are stored as numbers and cause errors when compared with string names
			elseif not CritlineFilters_IsSpellInFilter(k,CLF_tree) then
				tinsert(CL_SPELLS,k);
			end
		end
	end

	table.sort(CL_SPELLS);
	local size = table.getn( CL_SPELLS )
	FauxScrollFrame_Update(CLFSpellScrollBar,size,7,16)
	for line=1,7 do
		lineplusoffset = line + FauxScrollFrame_GetOffset(CLFSpellScrollBar)
		if( lineplusoffset <= size ) then
			getglobal("CLFSpellButton"..line.."Text"):SetText(CL_SPELLS[lineplusoffset])
			if CritlineFilters_IsSpellInFilter(CL_SPELLS[lineplusoffset],CLF_tree) then
				getglobal("CLFSpellButton"..line):SetChecked(true);
			else
				getglobal("CLFSpellButton"..line):SetChecked(false);
			end
			getglobal("CLFSpellButton"..line):Show()
		else
			getglobal("CLFSpellButton"..line):Hide()
		end
	end
end
 
 function CritlineFilters_TreeInitialize()
	UIDropDownMenu_Initialize(Critline_FiltersTree, function()
	local tex1 = { text = DAMAGE,
				  value = 1,
				  func = function()
					UIDropDownMenu_SetSelectedValue(Critline_FiltersTree, 1);
					CLA_SelectedSpells = {};
					FauxScrollFrame_SetOffset(CLFSpellScrollBar,0);
					CLF_tree = "DMG"
					CLFSpellScrollBar_Update();
					end }
	
	local tex2 = { text = HEALS,
				  value = 2,
				  func = function()
					UIDropDownMenu_SetSelectedValue(Critline_FiltersTree, 2);
					CLA_SelectedSpells = {};
					FauxScrollFrame_SetOffset(CLFSpellScrollBar,0);
					CLF_tree = "HEAL"
					CLFSpellScrollBar_Update();
				  end }
	
	local tex3 = { text = PET,
				  value = 3,
				  func = function()
					UIDropDownMenu_SetSelectedValue(Critline_FiltersTree, 3);
					CLF_SelectedSpells = {};
					FauxScrollFrame_SetOffset(CLFSpellScrollBar,0);
					CLF_tree = "PET"
					CLFSpellScrollBar_Update();
				  end }

	UIDropDownMenu_AddButton(tex1);
	UIDropDownMenu_AddButton(tex2);
	UIDropDownMenu_AddButton(tex3);
	end);
	UIDropDownMenu_SetWidth(120, Critline_FiltersTree);

end

function CritlineFilters_DeleteTarget()
	if( CLFMobScrollBar.selected ) then
		table.remove( CL_MOBFILTERS["mobs"], CLFMobScrollBar.selected )
		CLFMobScrollBar.selected = nil
		CLFMobScrollBar_Update()
	end
end

function CritlineFilters_DeleteSpell(spellname,tree)
	for k,v in pairs(CL_FILTERS[tree]) do
		if v == spellname then
			table.remove( CL_FILTERS[tree], k )
			do break end;
		end
	end
	CLFSpellScrollBar_Update()
	Critline_RebuildAllTooltips();
end

function CritlineFilters_AddSpell(spellname, tree)
	if (spellname) then
		if not CritlineFilters_IsSpellInFilter(spellname,tree) then
			tinsert(CL_FILTERS[tree],spellname);
			CLFSpellScrollBar_Update();
			Critline_RebuildAllTooltips();
		end
	end
end

function CritlineFilters_IsMobInFilter(mobname)
	local returnvalue = false;
	for k, v in pairs(CL_MOBFILTERS["mobs"]) do
		if ( v == mobname ) then
			Critline_Debug("Name of Mob ("..mobname..") is in Filter ...");
			returnvalue = true;
			do break end;
		end
	end
	if not returnvalue then
		Critline_Debug("Name of Mob ("..mobname..") is NOT in Filter ...");
	end
	return returnvalue;
end

function CritlineFilters_IsSpellInFilter(spellname,tree)
	local returnvalue = false;
	for k, v in pairs(CL_FILTERS[tree]) do
		if ( v == spellname ) then
			Critline_Debug("Name of Spell ("..spellname..") is in Filter ...");
			returnvalue = true;
			do break end;
		end
	end
	if not returnvalue then
		Critline_Debug("Name of Spell ("..spellname..") is NOT in Filter ...");
	end
	return returnvalue;
end

function CritlineFilters_IsSpellInSpellbook(spellname)
	local numspells = 1
	while( GetSpellName(numspells, BOOKTYPE_SPELL) ) do --find the top rank of every spell
		local name = GetSpellName( numspells, BOOKTYPE_SPELL )
		if name == spellname then
			return true;
		end
		numspells = numspells + 1
	end
	return false;

end

function CritlineFiltersButton_OnClick()
	this:LockHighlight()
	if( string.match(this:GetName(), "Mob") ) then
		CLFMobScrollBar.selected = this:GetID() + FauxScrollFrame_GetOffset(CLFMobScrollBar)
	else
		CLFSpellScrollBar.selected = this:GetID() + FauxScrollFrame_GetOffset(CLFSpellScrollBar)
	end
end

function CritlineSettings_SpellButton_OnClick(id)
	if this:GetChecked() then
		CritlineFilters_AddSpell(getglobal("CLFSpellButton"..id.."Text"):GetText(),CLF_tree)
	else
		CritlineFilters_DeleteSpell(getglobal("CLFSpellButton"..id.."Text"):GetText(),CLF_tree)
	end
end

function CritlineFilters_Localize()
	Critline_FiltersTitleString:SetText(CL_FILTERS_TEXT);
	CritlineFilters_MobTitle:SetText(CL_MOBFILTER_TEXT);
	CritlineFilters_SpellTitle:SetText(CL_SPELLFILTER_TEXT);
	CritlineFilters_AddSpellText:SetText(CL_ADDSPELL_TEXT);
	Critline_FiltersButton4:SetText(CL_ADDTARGET_TEXT);
	Critline_FiltersButton1:SetText(CL_DELETEMOB_TEXT);
	
end