
CLA_tree = "DMG"
CLA_mode = "Announce"
CLA_SelectedSpells = {}

function CritlineAnnounce_ShowAnnounce()
	CLA_SelectedSpells = {}
	Critline_Announce:Show()
	CritlineSettings_Frame:Hide();
end

function CritlineAnnounce_CreateChannel(curValue, curText)
	local tex1 = { text = curText,
				  value = curValue,
				  func = function()
					UIDropDownMenu_SetSelectedValue(Critline_AnnounceChannel, curValue);
					if curValue == 15 then
						Critline_AnnouncePlayer:Show();
						Critline_AnnouncePlayer:SetFocus();
					else
						Critline_AnnouncePlayer:Hide();
					end
				  end }
	UIDropDownMenu_AddButton(tex1);

end

function CritlineAnnounce_SendAnnounce()
	local norm
	local crit
	local normcrit
	local mychanID = UIDropDownMenu_GetSelectedValue(Critline_AnnounceChannel);
	if mychanID == 0  or mychanID == nil then
		Critline_Message("Critline Announce: "..CL_ANNOUNCE_MISSINGCHANNEL_TEXT..".");
		return;
	end 
	local mychan
	if mychanID == 11 then
		mychan = "GUILD"
	elseif mychanID == 12 then
		mychan = "PARTY"
	elseif mychanID == 13 then
		mychan = "RAID"
	elseif mychanID == 14 then
		mychan = "SAY"
	elseif mychanID == 15 then
		mychan = "WHISPER"
		mychanID = Critline_AnnouncePlayer:GetText();
		if mychanID == "" then
			Critline_Message("Critline Announce: "..CL_ANNOUNCE_BADPLAYER_TEXT..".");
			return;
		end
	else
		mychan = "CHANNEL"
	end
	
	for i=1,table.getn(CLA_SelectedSpells) do
		norm = nil
		crit = nil
		if CL_DATABASE[CLA_tree][CLA_SelectedSpells[i]]["NORM"] then
			norm = CL_DATABASE[CLA_tree][CLA_SelectedSpells[i]]["NORM"]["Amount"]
		end
		if CL_DATABASE[CLA_tree][CLA_SelectedSpells[i]]["CRIT"] then
			crit = CL_DATABASE[CLA_tree][CLA_SelectedSpells[i]]["CRIT"]["Amount"]
		end
		if norm and crit then
			normcrit = CL_NORMAL_TEXT..":"..norm.." "..CL_CRIT_TEXT..":"..crit
		elseif norm then
			normcrit = CL_NORMAL_TEXT..":"..norm.." "..CL_CRIT_TEXT..":0"
		elseif crit then
			normcrit = CL_NORMAL_TEXT..":0 "..CL_CRIT_TEXT..":"..crit
		end
		SendChatMessage(CLA_SelectedSpells[i].." - "..normcrit, mychan,nil,mychanID);
	end

	
	Critline_AnnouncePlayer:ClearFocus();

end

function CritlineAnnounce_ResetRecords()
	local mytree = UIDropDownMenu_GetSelectedValue(Critline_AnnounceTree);
	local n = 1;
	if Critline_AnnounceAllButton:GetChecked() then
		CL_DATABASE[CLA_tree] = {};
		Critline_AnnounceAllButton:SetChecked(false)
	else
		for i=1,table.maxn(CLA_SelectedSpells) do
			norm = nil
			crit = nil
			for v,_ in pairs(CL_DATABASE[CLA_tree]) do
				if v == CLA_SelectedSpells[i] then
					CL_DATABASE[CLA_tree][CLA_SelectedSpells[i]] = nil;
					do break end;
				end
				n = n + 1;
			end
		end
	end

	CLASpellScrollBar_Update();
	Critline_RebuildAllTooltips();
	
end

function CritlineAnnounce_LoadChannels()

	if IsInGuild() then
		CritlineAnnounce_CreateChannel(11,GUILD);
	end
	if GetNumPartyMembers() > 0 then
		CritlineAnnounce_CreateChannel(12,PARTY);
	end
	if GetNumRaidMembers() > 0 then
		CritlineAnnounce_CreateChannel(13,RAID);
	end
	
	CritlineAnnounce_CreateChannel(14,SAY);
	CritlineAnnounce_CreateChannel(15,PLAYER);

	id1, name1, id2, name2, id3, name3, id4, name4, id5, name5, id6, name6, id7, name7, id8, name8, id9, name9, id10, name10 = GetChannelList();
	
	if id1 then
		CritlineAnnounce_CreateChannel(id1,name1);
	end
	if id2 then
		CritlineAnnounce_CreateChannel(id2,name2);
	end
	if id3 then
		CritlineAnnounce_CreateChannel(id3,name3);
	end
	if id4 then
		CritlineAnnounce_CreateChannel(id4,name4);
	end
	if id5 then
		CritlineAnnounce_CreateChannel(id5,name5);
	end
	if id6 then
		CritlineAnnounce_CreateChannel(id6,name6);
	end
	if id7 then
		CritlineAnnounce_CreateChannel(id7,name7);
	end
	if id8 then
		CritlineAnnounce_CreateChannel(id8,name8);
	end
	if id9 then
		CritlineAnnounce_CreateChannel(id9,name9);
	end
	if id10 then
		CritlineAnnounce_CreateChannel(id10,name10);
	end

end

function CritlineAnnounce_ChannelInitialize()
	UIDropDownMenu_Initialize(Critline_AnnounceChannel, CritlineAnnounce_LoadChannels);
	UIDropDownMenu_SetWidth(120, Critline_AnnounceChannel);
end

function CritlineAnnounce_TreeInitialize()
	UIDropDownMenu_Initialize(Critline_AnnounceTree, function()
	local tex1 = { text = DAMAGE,
				  value = 1,
				  func = function()
					UIDropDownMenu_SetSelectedValue(Critline_AnnounceTree, 1);
					CLA_SelectedSpells = {};
					FauxScrollFrame_SetOffset(CLASpellScrollBar,0);
					CLA_tree = "DMG"
					CLASpellScrollBar_Update();
					end }
	
	local tex2 = { text = HEALS,
				  value = 2,
				  func = function()
					UIDropDownMenu_SetSelectedValue(Critline_AnnounceTree, 2);
					CLA_SelectedSpells = {};
					FauxScrollFrame_SetOffset(CLASpellScrollBar,0);
					CLA_tree = "HEAL"
					CLASpellScrollBar_Update();
				  end }
	
	local tex3 = { text = PET,
				  value = 3,
				  func = function()
					UIDropDownMenu_SetSelectedValue(Critline_AnnounceTree, 3);
					CLA_SelectedSpells = {};
					FauxScrollFrame_SetOffset(CLASpellScrollBar,0);
					CLA_tree = "PET"
					CLASpellScrollBar_Update();
				  end }

	UIDropDownMenu_AddButton(tex1);
	UIDropDownMenu_AddButton(tex2);
	UIDropDownMenu_AddButton(tex3);
	end);
	UIDropDownMenu_SetWidth(120, Critline_AnnounceTree);

end

function CritlineAnnounce_SpellButton_OnClick(id)
	if this:GetChecked() then
		PlaySound("igMainMenuOptionCheckBoxOn");
		tinsert(CLA_SelectedSpells,getglobal("CLASpellButton"..id.."Text"):GetText());
	else
		PlaySound("igMainMenuOptionCheckBoxOff");
		for i=1,table.getn(CLA_SelectedSpells) do
			if CLA_SelectedSpells[i] == getglobal("CLASpellButton"..id.."Text"):GetText() then
				table.remove(CLA_SelectedSpells,i);
				return;
			end
		end
	end
end

function CLASpellScrollBar_Update()
	local line -- 1 through 10 of our window to scroll
	local lineplusoffset -- an index into our data calculated from the scroll offset
	local CLA_SPELLS = {}
	local norm
	local crit
	local normcrit

	for k,v in pairs(CL_DATABASE[CLA_tree]) do
		if type(k) == "number" then
			CL_DATABASE[CLA_tree] = nil; -- need to get rid of old 113 errors...they are stored as numbers and cause errors when compared with string names
		else
			tinsert(CLA_SPELLS,k);
		end
	end
	table.sort(CLA_SPELLS);
	local size = table.getn( CLA_SPELLS )
	FauxScrollFrame_Update(CLASpellScrollBar,size,16,16)
	for line=1,16 do
		norm = 0
		crit = 0
		lineplusoffset = line + FauxScrollFrame_GetOffset(CLASpellScrollBar)
		if( lineplusoffset <= size ) then
			getglobal("CLASpellButton"..line.."Text"):SetText(CLA_SPELLS[lineplusoffset])
			if CL_DATABASE[CLA_tree][CLA_SPELLS[lineplusoffset]]["NORM"] then
				norm = CL_DATABASE[CLA_tree][CLA_SPELLS[lineplusoffset]]["NORM"]["Amount"]
			end
			if CL_DATABASE[CLA_tree][CLA_SPELLS[lineplusoffset]]["CRIT"] then
				crit = CL_DATABASE[CLA_tree][CLA_SPELLS[lineplusoffset]]["CRIT"]["Amount"]
			end
			if norm and crit then
				normcrit = HIGHLIGHT_FONT_COLOR_CODE..norm..FONT_COLOR_CODE_CLOSE.."/"..GREEN_FONT_COLOR_CODE..crit..FONT_COLOR_CODE_CLOSE
			elseif norm then
				normcrit = HIGHLIGHT_FONT_COLOR_CODE..norm..FONT_COLOR_CODE_CLOSE
			elseif crit then
				normcrit = GREEN_FONT_COLOR_CODE..crit..FONT_COLOR_CODE_CLOSE
			end
			getglobal("CLASpellButtonText"..line):SetText("["..normcrit.."] ")
			if CLA_SelectedSpells[CLA_SPELLS[lineplusoffset]] then
				getglobal("CLASpellButton"..line):SetChecked(true);
			else
				getglobal("CLASpellButton"..line):SetChecked(false);
			end
			getglobal("CLASpellButton"..line):Show()
			getglobal("CLASpellButtonText"..line):Show();
		else
			getglobal("CLASpellButton"..line):Hide()
			getglobal("CLASpellButtonText"..line):Hide();
		end
	end
end

--xml function calls
function CLASpellScrollBar_OnVerticalScroll()
	FauxScrollFrame_OnVerticalScroll(16, CLASpellScrollBar_Update);
end

function CritlineAnnounce_AllButton_OnClick()
	if ( this:GetChecked() ) then
		PlaySound("igMainMenuOptionCheckBoxOn");
	else
		PlaySound("igMainMenuOptionCheckBoxOff");
	end
end

function CritlineAnnounce_Button1_OnClick()
	PlaySound("gsTitleOptionOK");
	if CLA_mode == "Announce" then
		CritlineAnnounce_SendAnnounce();
	else
		CritlineAnnounce_ResetRecords();
	end
end

function CritlineAnnounce_OnShow()
	if CLA_mode == "Announce" then
		Critline_Announce_Button1:SetText(CL_ANNOUNCE_TEXT)
		Critline_AnnounceAllButton:Hide();
		Critline_AnnounceTitleString:SetText(CL_ANNOUNCE_TITLE_TEXT);
		Critline_AnnounceChannel:Show();
	else
		Critline_AnnounceChannel:Hide();
		Critline_AnnounceAllButton:Show();
		Critline_Announce_Button1:SetText(RESET)
		Critline_AnnounceTitleString:SetText(CL_RESET_TITLE_TEXT);
	end
	CLA_tree = "DMG";
	CLASpellScrollBar_Update();
	Critline_AnnouncePlayer:SetAutoFocus(false);
	Critline_AnnouncePlayer:Hide();
	CritlineAnnounce_ChannelInitialize();
	UIDropDownMenu_SetText(SAY, Critline_AnnounceChannel);
	UIDropDownMenu_SetSelectedValue(Critline_AnnounceChannel, 14);
	CritlineAnnounce_TreeInitialize();
	UIDropDownMenu_SetText(DAMAGE, Critline_AnnounceTree);
	UIDropDownMenu_SetSelectedValue(Critline_AnnounceTree, 1);
end

function CritlineAnnounce_OnHide()
	CritlineSettings_Frame:Show();
end

function CritlineAnnounce_OnLoad()
	this:RegisterForDrag("LeftButton")
	CritlineAnnounce_Localize();
end

function CritlineAnnounce_OnDragStart()
	this:StartMoving();
end

function CritlineAnnounce_OnDragStop()
	this:StopMovingOrSizing();
end

function CritlineAnnounce_Localize()
	Critline_AnnounceAllButtonText:SetText(CL_RESETBUTTON_TEXT);
	CritlineAnnounce_SpellTitle:SetText(CL_ANNOUNCESPELLTITLE_TEXT);
end
