CL_DEBUG = false; -- for internal testing only, leave it set to false!

--[[ global addon variables ]]
CRITLINE_ID =  "Critline";
CRITLINE_VERSION = "v5.2.4";

HEADER_TEXT_COLOR  = "|cffffffff";
SUBHEADER_TEXT_COLOR  = "|cffCEA208";
BODY_TEXT_COLOR  = "|cffffffff";
HINT_TEXT_COLOR  = "|cff00ff00";

Critline_Loaded = false;
CL_MOBFILTER = {};
Critline_UpdateTimer = 0;
Critline_OutOfControl = false;
Critline_MindControlled = false;

-----------------------------------------------------------------------------
function Critline_DataReset()
	CL_DATABASE = {};
	Critline_Summary = {["DMG"]="",["HEAL"]="",["PET"]=""};
	Critline_Initialize();
end
-----------------------------------------------------------------------------
function Critline_SettingsReset()
	CL_SETTINGS = {};
	Critline_Initialize();
end
-----------------------------------------------------------------------------
function Critline_ResetAll()
	CL_SETTINGS = {};
	CL_DATABASE = {};
	Critline_Summary = {["DMG"]="",["HEAL"]="",["PET"]=""};
	Critline_Initialize();
end
-----------------------------------------------------------------------------
function Critline_GetHighest(tree, hittype)
	--hittype is 'NORM' or 'CRIT'
	--tree is 'DMG', 'PET' or 'HEAL'
	
	local hidmg = 0;
	local spell = "n/a";
	
	tree = string.upper(tree);
	if (CL_DATABASE == nil) then 
		return hidmg, spell;
	end

	if (CL_DATABASE[tree] == nil) then 
		return hidmg, spell;
	end

	for k,v in pairs (CL_DATABASE[tree]) do
		if ( CL_DATABASE[tree][k]["Filter"] == "0" ) then
			if ( CL_DATABASE[tree][k][hittype] ~= nil ) then
				if ( CL_DATABASE[tree][k][hittype]["Amount"] > hidmg ) then
					Critline_ProcessSpell = false;
					if (CL_SETTINGS["INVERT"..tree] == "0" and (not CritlineFilters_IsSpellInFilter(k,tree))) then --not filtered and filter not inverted
						Critline_ProcessSpell = true;
					elseif (CL_SETTINGS["INVERT"..tree] == "1" and CritlineFilters_IsSpellInFilter(k,tree)) then --filtered and filter inverted
						Critline_ProcessSpell = true;
					end
					if (Critline_ProcessSpell) then
						hidmg = CL_DATABASE[tree][k][hittype]["Amount"];
						spell = k;
					end
				end
			end
		end
	end
	return hidmg, spell;
end
-----------------------------------------------------------------------------
function Critline_RebuildAllTooltips()
	Critline_Summary = {["DMG"]="",["HEAL"]="",["PET"]=""}; --have to rebuild cached data when a spell is filtered to update tooltips
	Critline_GetSummaryRichText("DMG") 
	Critline_GetSummaryRichText("HEAL")
	Critline_GetSummaryRichText("PET")
	Critline_DoUpdate();
end
-----------------------------------------------------------------------------
Critline_Summary = {["DMG"]="",["HEAL"]="",["PET"]=""};
function Critline_GetSummaryRichText(tree)
--	This is for code optimization. We only build the rich summary when a new record is hit.
--	When a new record is recorded, the engine will blank out the Critline_Summary[tree]
-- 	This causes the tree to be rebuilt when this function is called.
	--tree is 'DMG', 'PET' or 'HEAL'
	
	tree = string.upper(tree);
	if (Critline_Summary[tree] == "") then
		Critline_Summary[tree] = Critline_BuildSummaryRichText(tree);
	end
	return Critline_Summary[tree];
end
-----------------------------------------------------------------------------
function Critline_BuildSummaryRichText(tree)
	--tree is 'DMG', 'PET' or 'HEAL'
	
	tree = string.upper(tree);
	local hicrit = Critline_GetHighest(tree, "CRIT");
	local hidmg = Critline_GetHighest(tree, "NORM");
	local rtfAttack="";

	if (CL_DATABASE[tree] == nil) then 
		return SUBHEADER_TEXT_COLOR..CL_NORECORDS_TEXT..FONT_COLOR_CODE_CLOSE;
	end
	
	local crit_name = "";
	local crit_level = "";
	local crit_amount = "";
	local crit_date = "";
	
	local norm_name = "";
	local norm_level = "";
	local norm_amount = "";
	local norm_date = "";

	local formatted_entry = "";
	local summaryformat;
	
	table.sort(CL_DATABASE[tree]);

--$sn = Spell name

--$nn = Target's Name for the Normal Damage Record
--$nl = Target's Level for the Normal Damage Record
--$na = Amount of damage for the Normal spell.
--$nd = Date of Normal spell record.
--$nc = Number of times this spells has hit normal.

--$cn = Target's Name for the Crit Damage Record
--$cl = Target's Level for the Crit Damage Record
--$ca = Amount of damage for the Crit spell.
--$cd = Date of Crit spell record.
--$cc = Number of times this spells has hit Crit.
	if (CL_SETTINGS["DETAILED"] == "0") then
		--I would like these vales to be in a user editable on the settings menu (Advanced Settings)
		--BUG:14
		summaryformat = "$sn\t[$na/$ca]\n";
	else
		summaryformat = "$sn\n   Norm: $nn ($nl)\t $na\n   Crit: $cn ($cl)\t $ca\n";  --feyde...had to add brackets around damage for parsing in Fubar tooltip
	end
	
	Critline_FuBar_Tooltip = {}; --always reset on each call
	
	for spell_name,v in pairs (CL_DATABASE[tree]) do
		Critline_ProcessSpell = false;
		if type(spell_name) == "number" then -- need to get rid of old 113 errors...they are stored as numbers and cause errors when compared with string names
			CL_DATABASE[tree][spell_name] = nil;
		elseif (CL_SETTINGS["INVERT"..tree] == "0" and (not CritlineFilters_IsSpellInFilter(spell_name,tree))) then --not filtered and filter not inverted
			Critline_ProcessSpell = true;
		elseif (CL_SETTINGS["INVERT"..tree] == "1" and CritlineFilters_IsSpellInFilter(spell_name,tree)) then --filtered and filter inverted
			Critline_ProcessSpell = true;
		end
		if (Critline_ProcessSpell) then
			--get norm_amount
			if (CL_DATABASE[tree][spell_name]["NORM"] ~= nil) then
				if ( CL_DATABASE[tree][spell_name]["NORM"]["Amount"] == hidmg ) then
					norm_amount = GREEN_FONT_COLOR_CODE..CL_DATABASE[tree][spell_name]["NORM"]["Amount"]..FONT_COLOR_CODE_CLOSE;
				else
					norm_amount = HIGHLIGHT_FONT_COLOR_CODE..CL_DATABASE[tree][spell_name]["NORM"]["Amount"]..FONT_COLOR_CODE_CLOSE;
				end
				norm_name = CL_DATABASE[tree][spell_name]["NORM"]["Target"];
				norm_level = CL_DATABASE[tree][spell_name]["NORM"]["Level"];
				norm_date = CL_DATABASE[tree][spell_name]["NORM"]["Date"];
				norm_count = CL_DATABASE[tree][spell_name]["NORM"]["Count"];
			else
				norm_name = "";
				norm_level = "";
				norm_amount = HIGHLIGHT_FONT_COLOR_CODE.."0"..FONT_COLOR_CODE_CLOSE;
				norm_date = "";
				norm_count = "";
			end

			--get crit_amount
			if (CL_DATABASE[tree][spell_name]["CRIT"] ~= nil) then
				if ( CL_DATABASE[tree][spell_name]["CRIT"]["Amount"] == hicrit ) then
					crit_amount = GREEN_FONT_COLOR_CODE..CL_DATABASE[tree][spell_name]["CRIT"]["Amount"]..FONT_COLOR_CODE_CLOSE;
				else
					crit_amount = HIGHLIGHT_FONT_COLOR_CODE..CL_DATABASE[tree][spell_name]["CRIT"]["Amount"]..FONT_COLOR_CODE_CLOSE;
				end
				crit_name = CL_DATABASE[tree][spell_name]["CRIT"]["Target"];
				crit_level = CL_DATABASE[tree][spell_name]["CRIT"]["Level"];
				crit_date = CL_DATABASE[tree][spell_name]["CRIT"]["Date"];
				crit_count = CL_DATABASE[tree][spell_name]["CRIT"]["Count"];
			else
				crit_name = "";
				crit_level = "";
				crit_amount = HIGHLIGHT_FONT_COLOR_CODE.."0"..FONT_COLOR_CODE_CLOSE;
				crit_date = "";
				crit_count = "";
			end

			formatted_entry = summaryformat;

			formatted_entry = string.gsub(formatted_entry,"$sn",spell_name);

			formatted_entry = string.gsub(formatted_entry,"$nn",norm_name);
			formatted_entry = string.gsub(formatted_entry,"$nl",norm_level);
			formatted_entry = string.gsub(formatted_entry,"$na",norm_amount);
			formatted_entry = string.gsub(formatted_entry,"$nd",norm_date);
			formatted_entry = string.gsub(formatted_entry,"$nc",norm_count);

			formatted_entry = string.gsub(formatted_entry,"$cn",crit_name);
			formatted_entry = string.gsub(formatted_entry,"$cl",crit_level);
			formatted_entry = string.gsub(formatted_entry,"$ca",crit_amount);
			formatted_entry = string.gsub(formatted_entry,"$cd",crit_date);
			formatted_entry = string.gsub(formatted_entry,"$cc",crit_count);

			rtfAttack = rtfAttack..formatted_entry;
			
			--below we will build a table for the FuBar tooltip
			--it has been formatted the same as the summaryformat above.  if summaryformat changes, then this will need to change as well
			--i am using "!!" as a left and right separator
			if Critline_FuBar_Active then --feyde..only active when ANY Critline FuBar plugin is loaded
				if CL_SETTINGS["DETAILED"] == "0" then
					tinsert(Critline_FuBar_Tooltip,spell_name.."!!["..norm_amount.."/"..crit_amount.."]");
				else
					tinsert(Critline_FuBar_Tooltip,spell_name);
					tinsert(Critline_FuBar_Tooltip,"   "..CL_NORMAL_TEXT..": "..norm_name.." ("..norm_level..")!!"..norm_amount);
					tinsert(Critline_FuBar_Tooltip,"   "..CL_CRIT_TEXT..": "..crit_name.." ("..crit_level..")!!"..crit_amount);
				end
			end
		end
	end

	if ( rtfAttack == "" ) then
		tinsert(Critline_FuBar_Tooltip,SUBHEADER_TEXT_COLOR..CL_NORECORDS_TEXT..FONT_COLOR_CODE_CLOSE); --feyde...insert into  FuBar tooltip table
		return SUBHEADER_TEXT_COLOR..CL_NORECORDS_TEXT..FONT_COLOR_CODE_CLOSE;
	end
	
	rtfAttack = strsub(rtfAttack,1,string.len(rtfAttack)-1);
	return rtfAttack;
end
-----------------------------------------------------------------------------
function Critline_OnEvent(event,...)
	if event=="ADDON_LOADED" then
		if arg1 == "Critline" then
			Critline_Initialize();
			CritlineSplashFrame:EnableMouse(0)
			CritlineSplashFrame:Clear();
			Critline_Loaded = true;
		end
	elseif event=="PLAYER_CONTROL_LOST" then
		if not Critline_Loaded then
			return;
		end
		--this covers fear, taxi, mind control, and others
		Critline_OutOfControl = true;
	elseif event=="PLAYER_CONTROL_GAINED" then
		if not Critline_Loaded then
			return
		end
		Critline_OutOfControl = false;
		Critline_MindControlled = false;
	elseif event=="COMBAT_LOG_EVENT_UNFILTERED" then
		if not Critline_Loaded then
			return;
		end
		
		
		local timestamp, eventType, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags = ...
		local isPet = false;
		-- we seem to get events with standard arguments equal to nil, so they need to be ignored
		if (timestamp == nil) or (eventType == nil) then
			Critline_Debug("nil errors on start");
			return
		end

		--if we don't have a destName (who we hit or healed) and we don't have a sourceName(us or our pets) then we leave
		if destName == nil and sourceName == nil then
			Critline_Debug("nil source/dest");
			return;
		end
		
		local myGUID = UnitGUID("player");
		Critline_Debug("myGUID:"..myGUID);
		local myPetGUID = UnitGUID("pet");
		
		
		--if sourceGUID  is not us or our pet, we leave
		if sourceGUID ~= myGUID then
			if myPetGUID then
				Critline_Debug("myPetGUID:"..myPetGUID);
				if sourceGUID ~= myPetGUID then
					Critline_Debug("sourceGUID("..sourceGUID..") not us("..myGUID..") or our pet("..myPetGUID..")");
					return;
				end
			else
				Critline_Debug("sourceGUID("..sourceGUID..") not us("..myGUID..")");
				return;
			end
		end
		
		if sourceGUID == myPetGUID then
			isPet = true;
		end

		if Critline_MindControlled and tonumber(CL_SETTINGS["SUPPRESSMC"]) ~= 0 then
			--we are suppressing mind control events, time to leave
			Critline_Debug("Mind Control suppressed");
			return;
		end
		
		local amount, school, resisted, blocked, absorbed, critical, glancing, crushing, missType, enviromentalType
		local spellId, spellName, spellSchool, powerType, extraAmount, extraSpellId, extraSpellName, extraSpellSchool, auraType
		local schoolName, powerName, extraSchoolName -- we translate the school number and the power type number to a localized name
		local hitword, damageType
		if (eventType =="SPELL_CAST_START") or (eventType == "SPELL_CAST_FAILED") or (eventType == "SPELL_CAST_SUCCESS") or (eventType == "SWING_DAMAGE") then
			if Critline_OutOfControl then
				--if we are out of control and casting spells and/or attacking, we are mind controlled
				Critline_MindControlled = true;
			end
		end

		if (eventType == "SWING_DAMAGE") then
			-- can be non-Physical damage (e.g. Melee that hits as Shadow damage)
			amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...)
			if amount and (amount == 0) then
				return;
			end
			if (CritlineFilters_IsMobInFilter(destName)) then --feyde..check for mob in filter
				return;
			end
			Critline_HitHandle(sourceName, destName, "Melee", false, critical, amount, isPet, destGUID);
		elseif (eventType == "RANGE_DAMAGE") then
			-- for a wand the spellSchool is Physical but the school is e.g. Shadow, so don't check whether they differ
			spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...)
			if amount and (amount == 0) then
				return;
			end
			if (CritlineFilters_IsMobInFilter(destName)) then --feyde..check for mob in filter
				return;
			end
			Critline_HitHandle(sourceName, destName, spellName, false, critical, amount, isPet, destGUID);

		elseif (eventType == "SPELL_DAMAGE") or (eventType == "SPELL_PERIODIC_DAMAGE") or (eventType == "DAMAGE_SPLIT") or (eventType == "DAMAGE_SHIELD") then
			-- implication is that PERIODIC damage could be critical, glancing, or crushing, but I've not seen that
			spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...)
			if amount and (amount == 0) then
				return
			end
			if (CritlineFilters_IsMobInFilter(destName)) then --feyde..check for mob in filter
				return;
			end
			Critline_HitHandle(sourceName, destName, spellName, false, critical, amount, isPet, destGUID);
		-- healing events
		elseif (eventType == "SPELL_HEAL") or (eventType == "SPELL_PERIODIC_HEAL") then
			spellId, spellName, spellSchool, amount, critical = select(9, ...)
			if amount and (amount == 0) then
				return
			end
			if (CritlineFilters_IsMobInFilter(destName)) then --feyde..check for mob in filter
				return;
			end
			Critline_HitHandle(sourceName, destName, spellName, true, critical, amount, isPet, destGUID);
		end
	
	end
end
-----------------------------------------------------------------------------
function Critline_OnLoad()
	this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("PLAYER_CONTROL_LOST");
	this:RegisterEvent("PLAYER_CONTROL_GAINED");
end
-----------------------------------------------------------------------------
function Critline_Initialize()
	Critline_Debug("Initializing...");

	--settings
	if (CL_SETTINGS == nil) then
		CL_SETTINGS = {};
	end
	if ( CL_SETTINGS["MINIMAPPOS"] == nil ) then
		CL_SETTINGS["MINIMAPPOS"] = "0";
	end
	if ( CL_SETTINGS["SHOWMINIMAP"] == nil ) then
		CL_SETTINGS["SHOWMINIMAP"] = "1";
	end
	if (CL_SETTINGS["SUPPRESSMC"]) == nil then
		CL_SETTINGS["SUPPRESSMC"] = "0";
	end
	if (CL_SETTINGS["VERSION"] == nil) then
		CL_SETTINGS["VERSION"] = CL_VERSION;
	end
	if (CL_SETTINGS["LVLADJ"] == nil) then
		CL_SETTINGS["LVLADJ"] = "0";
	end
	if (CL_SETTINGS["SCALE"] == nil) then
		CL_SETTINGS["SCALE"] = "1";
	end
	if (CL_SETTINGS["SPLASHSCALE"] == nil) then
		CL_SETTINGS["SPLASHSCALE"] = "1";
	end
	if (CL_SETTINGS["SPLASH"] == nil) then
		CL_SETTINGS["SPLASH"] = "1";
	end
	if (CL_SETTINGS["PVPONLY"] == nil) then
		CL_SETTINGS["PVPONLY"] = "0";
	end
	if (CL_SETTINGS["PLAYSOUND"] == nil) then
		CL_SETTINGS["PLAYSOUND"] = "1";
	end
	if (CL_SETTINGS["SNAPSHOT"] == nil) then
		CL_SETTINGS["SNAPSHOT"] = "0";
	end
	if ( CL_SETTINGS["DMG"] == nil ) then
		CL_SETTINGS["DMG"] = "1";
	end
	if ( CL_SETTINGS["HEAL"] == nil ) then
		CL_SETTINGS["HEAL"] = "1";
	end
	if ( CL_SETTINGS["PET"] == nil ) then
		CL_SETTINGS["PET"] = "1";
	end
	if ( CL_SETTINGS["SHOWDMG"] == nil ) then
		CL_SETTINGS["SHOWDMG"] = "1";
	end
	if ( CL_SETTINGS["SHOWHEAL"] == nil ) then
		CL_SETTINGS["SHOWHEAL"] = "1";
	end
	if ( CL_SETTINGS["SHOWPET"] == nil ) then
		CL_SETTINGS["SHOWPET"] = "1";
	end
	if ( CL_SETTINGS["INVERTDMG"] == nil ) then
		CL_SETTINGS["INVERTDMG"] = "0";
	end
	if ( CL_SETTINGS["INVERTHEAL"] == nil ) then
		CL_SETTINGS["INVERTHEAL"] = "0";
	end
	if ( CL_SETTINGS["INVERTPET"] == nil ) then
		CL_SETTINGS["INVERTPET"] = "0";
	end
	if ( CL_SETTINGS["DETAILED"] == nil ) then
		CL_SETTINGS["DETAILED"] = "0";
	end
	if ( CL_SETTINGS["FIRSTLOAD"] == nil ) then --feyde..default FIRSTLOAD to on so CritlineDisplay_OnEvent can turn on trees by class 
		CL_SETTINGS["FIRSTLOAD"] = "1";
	end
	if ( CL_SETTINGS["SPLASHTIMER"] == nil ) then
		CL_SETTINGS["SPLASHTIMER"] = "2";
	end
	if ( CL_SETTINGS["SPELLCOLOR"] == nil ) then
		CL_SETTINGS["SPELLCOLOR"] = {};
		CL_SETTINGS["SPELLCOLOR"]["r"] = 1;
		CL_SETTINGS["SPELLCOLOR"]["g"] = 1;
		CL_SETTINGS["SPELLCOLOR"]["b"] = 0;
	end
	if ( CL_SETTINGS["AMOUNTCOLOR"] == nil ) then
		CL_SETTINGS["AMOUNTCOLOR"] = {};
		CL_SETTINGS["AMOUNTCOLOR"]["r"] = 1;
		CL_SETTINGS["AMOUNTCOLOR"]["g"] = 1;
		CL_SETTINGS["AMOUNTCOLOR"]["b"] = 1;
	end
	if ( CL_SETTINGS["SPLASHFRAME"] == nil ) then
		CL_SETTINGS["SPLASHFRAME"] = {};
	end
	if ( CL_SETTINGS["SPLASHFRAME"]["point"] ) then
		CritlineSplashFrame:ClearAllPoints();
		CritlineSplashFrame:SetPoint(CL_SETTINGS["SPLASHFRAME"]["point"], CL_SETTINGS["SPLASHFRAME"]["x"], CL_SETTINGS["SPLASHFRAME"]["y"]);
	end
	
	--database
	if (CL_DATABASE == nil) then
		CL_DATABASE = {};
	end
	if (CL_DATABASE["DMG"] == nil) then
		CL_DATABASE["DMG"] = {};
	end
	if (CL_DATABASE["HEAL"] == nil) then
		CL_DATABASE["HEAL"] = {};
	end
	if (CL_DATABASE["PET"] == nil) then
		CL_DATABASE["PET"] = {};
	end
	
	--filters
	if (CL_FILTERS == nil) then
		CL_FILTERS = {};
		Critline_Debug("filters created");
	end
	if (CL_MOBFILTERS == nil) then
		CL_MOBFILTERS = {};
	end
	if (CL_MOBFILTERS["mobs"] == nil) then
		CL_MOBFILTERS["mobs"] = {};
		if CL_FILTERS["mobs"] then
			--CL_MOBFILTERS is an account wide database
			--if we have mobs in CL_FILTERS (which is character based) they need to be moved into CL_MOBFILTERS
			--since CL_MOBFILTERS did not exist before, we can do a direct transfer
			CL_MOBFILTERS["mobs"] = CL_FILTERS["mobs"]
			CL_FILTERS["mobs"] = nil;
		end
		Critline_Debug("mobs created");
	else
		if CL_FILTERS["mobs"] then
			--as we load each character, we need to check to see if there are mobs in CL_FILTERS and move them into CL_MOBFILTERS
			--since CL_MOBFILTERS exists (created when a different character was loaded), we need to check the mobs in CL_FILTERS one by one and copy them if necessary
			for k,v in pairs(CL_FILTERS["mobs"]) do
				local mobfound = false;
				for k1,v1 in pairs(CL_MOBFILTERS["mobs"]) do
					if v == v1 then
						--we dont' want to add mobs to CL_MOBFILTERS if they already exist.
						mobfound = true;
					end
				end
				if mobfound == false then
					--we do not have this mob, need to add
					tinsert(CL_MOBFILTERS["mobs"],v);
				end
			end
			--after any or all mobs have been moved from CL_FILTERS to CL_MOBFILTERS, destroy CL_FILTERS because we are no longer storing mobs per character
			CL_FILTERS["mobs"] = nil;
		end
	end
	if (CL_FILTERS["DMG"] == nil) then
		CL_FILTERS["DMG"] = {};
		CL_FILTERS["HEAL"] = {};
		CL_FILTERS["PET"] = {};
		Critline_Debug("spells created");
	end

	CritlineSplashFrame:SetTimeVisible(tonumber(CL_SETTINGS["SPLASHTIMER"]));
	
	Critline_RebuildAllTooltips();
	Critline_Debug("Initialization Complete.");
	Critline_Message("Critline loaded.");
	
end

function Critline_UnitLevel(destGUID)
		
		CritlineTooltip:SetHyperlink("unit:"..destGUID);
		local level = UnitLevel("player"); --by default, all mobs are fair game
		local IsPlayer = false; --by default we are fighting a mob
		for i=1,CritlineTooltip:NumLines() do
			local mytext = getglobal("CritlineTooltipTextLeft" .. i)
			local text = mytext:GetText()
			if text then
				if string.find(text,LEVEL) then --our destGUID has the world Level in it.
					_,_,level = string.find(text,"(%d+)");  -- find the level
					if level then  --if we found the level, break from the for loop
						level = tonumber(level);
					else
						--well, the word Level is in this tooltip, but we could not find the level
						--either the destGUID is at least 10 levels higher than us, or we just couldn't find it.
						level = UnitLevel("player");  --like I said, by default, all mobs are fair game
					end
				end
				if string.find(text,PLAYER) then --our destGUID has the word Player in it.
					--we are fighting another Player, this is used for PvP flag
					IsPlayer = true;
				end
			end
		end	
		return level, IsPlayer;

end
-----------------------------------------------------------------------------
function Critline_HitHandle(attacker, target, spell, isheal, iscrit, amount, isPet, destGUID)
	
	if (amount == nil) then
		Critline_Debug("No Damage! exiting...");
		return;
	end
	
	local targetlvl, isPlayer = Critline_UnitLevel(destGUID)

	if ( CL_SETTINGS["FILTER_MOBS"] == "1" ) then
		if ( Critline_IsMobInFilter(target) ) then
			return;
		end
	end

	if (( not isPlayer ) and (CL_SETTINGS["PVPONLY"] == "1") ) then
		Critline_Debug("Target !=player and PvPOnly enabled, exiting...");
		return;
	end

	local leveldiff = 0;
	if targetlvl < UnitLevel("player") then
		leveldiff = (UnitLevel("player") - targetlvl);
	end
	Critline_Debug("Level difference: "..leveldiff);
	if ( (tonumber(CL_SETTINGS["LVLADJ"]) ~= 0) and (tonumber(CL_SETTINGS["LVLADJ"]) < leveldiff) ) then
		Critline_Debug("Target level too low and LvlAdj enabled, exiting...");
		return;
	end

	if (CL_DATABASE == nil) then
		Critline_Debug("CL_DATABASE should not be nil at this point!");
		Critline_Initialize();
	end

	if isPet then
		tree = "PET";
	elseif isheal then
		tree = "HEAL";
	else
		tree = "DMG";
	end

	--exit if not recording type dmg.
	if ( CL_SETTINGS[tree] == "0" ) then
		return;
	end
	
	local hitype = "NORM";
	if (iscrit) then
		hitype = "CRIT";
	end

	if (CL_DATABASE[tree] == nil) then
		Critline_Debug("Creating CL_DATABASE["..tree.."]["..spell.."]...");
		CL_DATABASE[tree] = {};
	end
	if (CL_DATABASE[tree][spell] == nil) then
		Critline_Debug("Creating CL_DATABASE["..tree.."]["..spell.."]...");
		CL_DATABASE[tree][spell] = {};
	end
	if ( CL_DATABASE[tree][spell]["Filter"] == nil ) then
		Critline_Debug("Creating CL_DATABASE["..tree.."]["..spell.."][Filter]...");
		CL_DATABASE[tree][spell]["Filter"] = "0";
	end
	if (CL_DATABASE[tree][spell][hitype] == nil) then
		Critline_Debug("Creating CL_DATABASE["..tree.."]["..spell.."]["..hitype.."]...");
		CL_DATABASE[tree][spell][hitype] = {};
	end

	if ( CL_DATABASE[tree][spell][hitype]["Amount"] == nil ) then
		Critline_Debug("Creating CL_DATABASE["..tree.."]["..spell.."]["..hitype.."][Amount]...");
		CL_DATABASE[tree][spell][hitype]["Amount"] = 0;
	end
	if ( CL_DATABASE[tree][spell][hitype]["Count"] == nil ) then
		Critline_Debug("Creating CL_DATABASE["..tree.."]["..spell.."]["..hitype.."][Count]...");
		CL_DATABASE[tree][spell][hitype]["Count"] = 0;
	end

	CL_DATABASE[tree][spell][hitype]["Count"] = CL_DATABASE[tree][spell][hitype]["Count"] + 1;


	if ( CL_DATABASE[tree][spell][hitype]["Amount"] == nil or CL_DATABASE[tree][spell][hitype]["Amount"] < amount ) then
		CL_DATABASE[tree][spell][hitype]["Amount"] = amount;
		CL_DATABASE[tree][spell][hitype]["Target"] = target;
		CL_DATABASE[tree][spell][hitype]["Level"] = targetlvl;
		CL_DATABASE[tree][spell][hitype]["Date"] = date();
		Critline_Summary[tree] = "";
		if (not CritlineFilters_IsSpellInFilter(spell,tree)) then
			Critline_DisplayNewRecord(spell, amount, iscrit);
		end
	end
end
-----------------------------------------------------------------------------
function Critline_DisplayNewRecord(spell, amount, iscrit)

	splash_msg = CL_NEW_RECORD_MSG;
	if(CL_SETTINGS["SPLASH"] == "1") then
		CritlineSplashFrame:AddMessage(amount, CL_SETTINGS["AMOUNTCOLOR"]["r"], CL_SETTINGS["AMOUNTCOLOR"]["g"],CL_SETTINGS["AMOUNTCOLOR"]["b"], 1);
		CritlineSplashFrame:AddMessage(format(splash_msg, spell), CL_SETTINGS["SPELLCOLOR"]["r"], CL_SETTINGS["SPELLCOLOR"]["g"], CL_SETTINGS["SPELLCOLOR"]["b"], 1);
		if iscrit then
			CritlineSplashFrame:AddMessage("! ".. strupper(TEXT_MODE_A_STRING_RESULT_CRITICAL).." !", 1,0,0, 1);
		end
	end
	if(CL_SETTINGS["PLAYSOUND"] == "1") then 
		PlaySound("LEVELUP", 1, 1, 0, 1, 3); 
	end
	if(CL_SETTINGS["SNAPSHOT"] == "1") then 
		--To avoid protection issues, you could substitute SetAlpha(0) and SetAlpha(100) for Hide() and Show(), respectively.
		--if UIParent:IsShown() 
		--UIParent:Hide() --SetAlpha(0)
		TakeScreenshot(); 
		--UIParent:Show() --SetAlpha(100)
	end
	Critline_RebuildAllTooltips(); --feyde...since Tooltips are now cached, we have to reset them to update the new record data.
end


-----------------------------------------------------------------------------
function Critline_GetAboutRichText()
	return Critline_Color(HEADER_TEXT_COLOR, CRITLINE_ID.." "..CRITLINE_VERSION).."\n"..
		Critline_Color(SUBHEADER_TEXT_COLOR, "Lead Developer:").."\n"..
		Critline_Color(BODY_TEXT_COLOR, "Greenleaves (Blackhand) formally Uggh (Eredar)").."\n"..
		Critline_Color(SUBHEADER_TEXT_COLOR, "Developers:").."\n"..
		Critline_Color(BODY_TEXT_COLOR, "Feyde (Bloodhoof)").."\n"..
		Critline_Color(SUBHEADER_TEXT_COLOR, "Want to contribute to Critline?:").."\n"..
		Critline_Color(BODY_TEXT_COLOR, "visit http://wow-en.curse-gaming.com/downloads/addons/action-bars/critline-5-0/").."\n";
end
-----------------------------------------------------------------------------
CLOU_Handles = {};
function Critline_DoUpdate()
	for k, v in pairs(CLOU_Handles) do
		v();
	end
end
-----------------------------------------------------------------------------
function Critline_OnUpdateRegister(newhandler)
	table.insert(CLOU_Handles, newhandler);
end
-----------------------------------------------------------------------------
--[[ misc help functions ]]
function Critline_Color(color, msg)
	if ( msg == nil ) then
		return;
	end
	return color..msg..FONT_COLOR_CODE_CLOSE;
end
-----------------------------------------------------------------------------
function Critline_Debug(message)
	if (CL_DEBUG and DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage("CL_DEBUG: "..message);
	end
end
-----------------------------------------------------------------------------
function Critline_Message(msg)
	if ( msg == nil ) then
		msg = "Critline_Message passed a nil value.";
	end
	if (DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage(msg);
	end
end
-----------------------------------------------------------------------------

--xml function calls
function CritlineSplashFrame_OnLoad()
	this.update = 1;
	this.locked = true;
	this:RegisterForDrag("LeftButton")
end
-----------------------------------------------------------------------------
function CritlineSplashFrame_OnUpdate()
	if not Critline_Loaded then
		return;
	end

	if ( not this.locked ) then
		CritlineSplashFrame:AddMessage(CL_SPLASHFRAME_UNLOCKED_TEXT, CL_SETTINGS["AMOUNTCOLOR"]["r"], CL_SETTINGS["AMOUNTCOLOR"]["g"], CL_SETTINGS["AMOUNTCOLOR"]["b"], 1);
		CritlineSplashFrame:AddMessage(CL_SPLASHFRAME_DRAGTOMOVE_TEXT, CL_SETTINGS["SPELLCOLOR"]["r"], CL_SETTINGS["SPELLCOLOR"]["g"], CL_SETTINGS["SPELLCOLOR"]["b"], 1);
	end
end
-----------------------------------------------------------------------------
function CritlineSplashFrame_OnDragStart()
	if ( not this.locked ) then
		this:StartMoving();
	end
end
-----------------------------------------------------------------------------
function CritlineSplashFrame_OnDragStop()
	this:StopMovingOrSizing();
	point, relativeTo, relativePoint, xOfs, yOfs = CritlineSplashFrame:GetPoint()
	CL_SETTINGS["SPLASHFRAME"]["point"] = point;
	CL_SETTINGS["SPLASHFRAME"]["x"] = xOfs;
	CL_SETTINGS["SPLASHFRAME"]["y"] = yOfs;
	
end

