--[[ addon functions ]]

function CritlineSettings_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");
	CritlineSettings_Localize();

	SlashCmdList["CRITLINESETTINGS"] = function(msg)
		if (CritlineSettings_Frame:IsVisible()) then
			CritlineSettings_Frame:Hide();
		else
			CritlineSettings_ShowSettings();
		end
	end
	
	SLASH_CRITLINESETTINGS1 = "/critline";
	SLASH_CRITLINESETTINGS2 = "/cl";
	SLASH_CRITLINESETTINGS3 = "/clb";
end

function CritlineSettings_OnEvent()
	if (event == "VARIABLES_LOADED") then
		CritlineSettings_LoadSettings();
	end
end
function CritlineSettings_LoadSettings()
	
	--Basic Frame
	CritlineSettings_FrameBasic_Option1Text:SetText(CL_OPTION_RECORD_DMG_TEXT);
	CritlineSettings_FrameBasic_Option1.HelpText = CL_OPTION_RECORD_DMG_HELPTEXT;
	CritlineSettings_FrameBasic_Option1.Setting = "DMG";
	if (CL_SETTINGS["DMG"] == "1") then
		CritlineSettings_FrameBasic_Option1:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option2Text:SetText(CL_OPTION_RECORD_HEAL_TEXT);
	CritlineSettings_FrameBasic_Option2.HelpText = CL_OPTION_RECORD_HEAL_HELPTEXT;
	CritlineSettings_FrameBasic_Option2.Setting = "HEAL";
	if (CL_SETTINGS["HEAL"] == "1") then
		CritlineSettings_FrameBasic_Option2:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option3Text:SetText(CL_OPTION_RECORD_PET_TEXT);
	CritlineSettings_FrameBasic_Option3.HelpText = CL_OPTION_RECORD_PET_HELPTEXT;
	CritlineSettings_FrameBasic_Option3.Setting = "PET";
	if (CL_SETTINGS["PET"] == "1") then
		CritlineSettings_FrameBasic_Option3:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option4Text:SetText(CL_OPTION_PVPONLY_TEXT);
	CritlineSettings_FrameBasic_Option4.HelpText = CL_OPTION_PVPONLY_HELPTEXT;
	CritlineSettings_FrameBasic_Option4.Setting = "PVPONLY";
	if (CL_SETTINGS["PVPONLY"] == "1") then
		CritlineSettings_FrameBasic_Option4:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option5Text:SetText(CL_OPTION_PLAYSOUNDS_TEXT);
	CritlineSettings_FrameBasic_Option5.HelpText = CL_OPTION_PLAYSOUNDS_HELPTEXT;
	CritlineSettings_FrameBasic_Option5.Setting = "PLAYSOUND";
	if (CL_SETTINGS["PLAYSOUND"] == "1") then
		CritlineSettings_FrameBasic_Option5:SetChecked(true);
	end
	
	--[[ skal fjernes som feature
	CritlineSettings_FrameBasic_Option6Text:SetText(CL_OPTION_SCREENCAP_TEXT);
	CritlineSettings_FrameBasic_Option6.HelpText = CL_OPTION_SCREENCAP_HELPTEXT;
	CritlineSettings_FrameBasic_Option6.Setting = "SNAPSHOT";
	if (CL_SETTINGS["SNAPSHOT"] == "1") then
		CritlineSettings_FrameBasic_Option6:SetChecked(true);
	end
	]]
--[[
	CritlineSettings_FrameBasic_Option7Text:SetText(CL_OPTION_DETAILED_TEXT);
	CritlineSettings_FrameBasic_Option7.HelpText = CL_OPTION_DETAILED_HELPTEXT;
	CritlineSettings_FrameBasic_Option7.Setting = "DETAILED";
	if (CL_SETTINGS["DETAILED"] == "1") then
		CritlineSettings_FrameBasic_Option7:SetChecked(true);
	end
]]

	CritlineSettings_FrameBasic_Option8Text:SetText(CL_OPTION_SHOWDMG_TEXT);
	CritlineSettings_FrameBasic_Option8.HelpText = CL_OPTION_SHOWDMG_HELPTEXT;
	CritlineSettings_FrameBasic_Option8.Setting = "SHOWDMG";
	if (CL_SETTINGS["SHOWDMG"] == "1") then
		CritlineSettings_FrameBasic_Option8:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option9Text:SetText(CL_OPTION_SHOWHEAL_TEXT);
	CritlineSettings_FrameBasic_Option9.HelpText = CL_OPTION_SHOWHEAL_HELPTEXT;
	CritlineSettings_FrameBasic_Option9.Setting = "SHOWHEAL";
	if (CL_SETTINGS["SHOWHEAL"] == "1") then
		CritlineSettings_FrameBasic_Option9:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option10Text:SetText(CL_OPTION_SHOWPET_TEXT);
	CritlineSettings_FrameBasic_Option10.HelpText = CL_OPTION_SHOWPET_HELPTEXT;
	CritlineSettings_FrameBasic_Option10.Setting = "SHOWPET";
	if (CL_SETTINGS["SHOWPET"] == "1") then
		CritlineSettings_FrameBasic_Option10:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option11Text:SetText("Show on Slidebar");
	CritlineSettings_FrameBasic_Option11.HelpText = "Only works if Slidebar is installed";
	CritlineSettings_FrameBasic_Option11.Setting = "SHOWSLIDEICON";
	if (CL_SETTINGS["SHOWSLIDEICON"] == "1" and LibStub) then
		CritlineSettings_FrameBasic_Option11:SetChecked(true);
	end
	--	DEFAULT_CHAT_FRAME:AddMessage("test");
	CritlineSettings_FrameBasic_Option12Text:SetText(CL_OPTION_SHOWMINIMAP_TEXT);
	CritlineSettings_FrameBasic_Option12.HelpText = CL_OPTION_SHOWMINIMAP_HELPTEXT;
	CritlineSettings_FrameBasic_Option12.Setting = "SHOWMINIMAP";
	if (CL_SETTINGS["SHOWMINIMAP"] == "1") then
		CritlineSettings_FrameBasic_Option12:SetChecked(true);
	end
	
	CritlineSettings_FrameBasic_Option13Text:SetText(CL_OPTION_SPLASH_TEXT);
	CritlineSettings_FrameBasic_Option13.HelpText = CL_OPTION_SPLASH_HELPTEXT;
	CritlineSettings_FrameBasic_Option13.Setting = "SPLASH";
	if (CL_SETTINGS["SPLASH"] == "1") then
		CritlineSettings_FrameBasic_Option13:SetChecked(true);
	end

	CritlineSettings_FrameBasic_Option14Text:SetText(CL_OPTION_MOVESPLASH_TEXT);
	CritlineSettings_FrameBasic_Option14.HelpText = CL_OPTION_MOVESPLASH_HELPTEXT;
	CritlineSettings_FrameBasic_Option14.Setting = "MOVESPLASH";
	CritlineSettings_FrameBasic_Option14:SetChecked(false);		

	-- sliders
	CritlineSettings_FrameBasic_Slider1:SetValue(tonumber(CL_SETTINGS["LVLADJ"]));
	CritlineSettings_FrameBasic_Slider2:SetValue(tonumber(CL_SETTINGS["SPLASHSCALE"]));	
	CritlineSettings_FrameBasic_Slider4:SetValue(tonumber(CL_SETTINGS["SCALE"]));	
	
end

function CritlineSettings_ShowSettings()
	CritlineSettings_Frame:Show();
end

function CritlineSettings_CloseSettings()
	CritlineSettings_Frame:Hide();
end

function CritlineSettings_ResetRecords()
	Critline_DataReset();
end


--MOUSE ENTER / LEAVE OPTION
function CritlineSettings_ShowHelp(button)
	GameTooltip:SetOwner(this, "ANCHOR_NONE");
	GameTooltip:SetPoint("TOPLEFT", button:GetName(), "BOTTOMLEFT", -10, -4);
	GameTooltip:SetText(this.HelpText);
	GameTooltip:Show();
end
function CritlineSettings_HideHelp(button)
	GameTooltip:Hide();
end
function CritlineSettings_Button_OnClick(button)
	if (button.Setting == "MOVESPLASH") then --temporary setting....not to be saved
		if button:GetChecked() then
			CritlineSplashFrame.locked = false
			CritlineSplashFrame:EnableMouse(1)
		else
			CritlineSplashFrame.locked = true
			CritlineSplashFrame:EnableMouse(0)
			CritlineSplashFrame:Clear();
		end
	else
		if ( button:GetChecked() ) then
			CL_SETTINGS[button.Setting] = "1";
		else
			CL_SETTINGS[button.Setting] = "0";
		end
		if (button.Setting == "SHOWDMG" or button.Setting == "SHOWHEAL" or button.Setting == "SHOWPET") then
			CritlineDisplay_UpdateTree(strsub(button.Setting,5),button:GetChecked());
		end		
		if (button.Setting == "SHOWMINIMAP") then
			if (button:GetChecked()) then
				CritlineMinimap_Frame:Show();
			else
				CritlineMinimap_Frame:Hide();
			end
		end
		if (button.Setting == "SHOWSLIDEICON") then
			if (button:GetChecked()) then
				CritlineMinimap_addSlideIcon();	
			else
				CritlineMinimap_removeSlideIcon();
				--removeSlideIcon("CritlineBasic");
			end
		end
	end
end

function CritlineSettings_Localize()
	CritlineSettings_Frame_HeaderText:SetText("Critline Basic "..SETTINGS);
	CritlineSettings_FrameBasic_ButtonReset:SetText(CL_SETTINGS_RESETRECORDS_TEXT);
end
