function CritlineMinimap_OnTooltip(v1,v2)
	GameTooltip:SetOwner(this,"ANCHOR_LEFT")
	GameTooltip:AddLine(v1)
	GameTooltip:AddLine(v2,.8,.8,.8,1)
	GameTooltip:Show()
end

function CritlineMinimap_OnEvent(event)
	if (event=="VARIABLES_LOADED") then
		if CL_SETTINGS["SHOWMINIMAP"]=="1" then
			CritlineMinimap_Frame:Show();
		else
			CritlineMinimap_Frame:Hide();
		end 
		CritlineMinimap_MoveMinimap();
		if (CL_SETTINGS["SHOWSLIDEICON"] == "1") then
			CritlineMinimap_addSlideIcon();
		end
	end
end

function CritlineMinimap_OnUpdate()
	if CritlineMinimap_Dragging then
		local xpos,ypos = GetCursorPosition()
		local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom()

		xpos = xmin-xpos/Minimap:GetEffectiveScale()+70
		ypos = ypos/Minimap:GetEffectiveScale()-ymin-70

		CL_SETTINGS["MINIMAPPOS"] = math.deg(math.atan2(ypos,xpos))
		CritlineMinimap_MoveMinimap()
	end
end

function CritlineMinimap_MoveMinimap()

	local xpos,ypos
	local angle = CL_SETTINGS["MINIMAPPOS"]

	xpos = 80*cos(angle)
	ypos = 80*sin(angle)

	CritlineMinimap_Frame:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-xpos,ypos-52)

end

function CritlineMinimap_OnClick(obj, button)
	if (button=="LeftButton") then
		if Critline_Display:IsVisible() then
			Critline_Display:Hide()
		else
			if (CL_SETTINGS["SHOWDMG"] == "0" and CL_SETTINGS["SHOWHEAL"] == "0" and CL_SETTINGS["SHOWPET"] == "0") then
				CL_SETTINGS["FIRSTLOAD"] = "1"
				CritlineDisplay_OnEvent("VARIABLES_LOADED") --if all tree are hidden when minimap is called to show, reload by class
			else
				Critline_Display:Show()
			end

		end
	elseif (button=="RightButton") then
		if CritlineSettings_Frame:IsVisible() then
			CritlineSettings_Frame:Hide()
		else
			CritlineSettings_Frame:Show()
		end		
	end
end

--[[
function CritlineMinimap_addSlideIcon()

	local tip = {
		"Critline Basic",
		"Critline Basic records your high normal and critical hits.",			
		"{{Click}} to hide or show the main UI.",
		"{{Right-click}} to edit the configuration."
	}
		addSlideIcon("CritlineBasic", "Interface\\AddOns\\critlinebasic\\icons\\CritlineDmg", CritlineMinimap_OnClick, tip);
end
]]
function CritlineMinimap_addSlideIcon()
	local sideIcon
	if LibStub then
		local SlideBar = LibStub:GetLibrary("SlideBar", true)
		if SlideBar then
			sideIcon = SlideBar.AddButton("CritlineBasic", "Interface\\AddOns\\critlinebasic\\icons\\CritlineDmg")
			sideIcon:RegisterForClicks("LeftButtonUp","RightButtonUp")
			sideIcon:SetScript("OnClick", CritlineMinimap_OnClick)
			sideIcon.tip = {
				"Critline Basic",
				"Critline Basic records your high normal and critical hits.",			
				"{{Click}} to hide or show the main UI.",
				"{{Right-click}} to edit the configuration."
			}
		else
			DEFAULT_CHAT_FRAME:AddMessage("Critline Basic: You don't have Slidebar installed or activated, so you can't use 'show on slidebar'.");
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("Critline Basic: You don't have Slidebar installed or activated, so you can't use 'show on slidebar'.");
	end	
end

function CritlineMinimap_removeSlideIcon()
	if LibStub then
		local SlideBar = LibStub:GetLibrary("SlideBar", true)
		if SlideBar then
			SlideBar.RemoveButton("CritlineBasic");
		end
	end
end
