﻿
function CL_ToggleMod()
	if (CL_SETTINGS["ON"] == "1") then
		CritlineDisplay_UpdateTree("DMG",false);
		CritlineDisplay_UpdateTree("HEAL",false);
		CritlineDisplay_UpdateTree("PET",false);
	else
		CritlineDisplay_UpdateTree("DMG",true);
		CritlineDisplay_UpdateTree("HEAL",true);
		CritlineDisplay_UpdateTree("PET",true);
	end
end

function CritlineDisplay_UpdateTree(tree, enabled)
	local mytree = _G["Critline_Display"..tree];
	local mybutton = _G["Critline_Display"..tree.."Button"];
	local visiblebuttoncount = 0;
	
	if (enabled) then
		CL_SETTINGS["SHOW"..tree] = "1";
		Critline_Display:Show();
		if (tree == "DMG") then
			CritlineSettings_FrameBasic_Option8:SetChecked(true);
		end
		if (tree == "HEAL") then
			CritlineSettings_FrameBasic_Option9:SetChecked(true);
		end
		if (tree == "PET") then
			CritlineSettings_FrameBasic_Option10:SetChecked(true);
		end
		mybutton:Show();
		mytree:Show();
	else
		CL_SETTINGS["SHOW"..tree] = "0";
		if (tree == "DMG") then
			CritlineSettings_FrameBasic_Option8:SetChecked(false);
		end
		if (tree == "HEAL") then
			CritlineSettings_FrameBasic_Option9:SetChecked(false);
		end
		if (tree == "PET") then
			CritlineSettings_FrameBasic_Option10:SetChecked(false);
		end
		mybutton:Hide();
		mytree:Hide();
	end
	
	--check for anchors
	myDMGButton = _G["Critline_DisplayDMGButton"];
	myHEALButton = _G["Critline_DisplayHEALButton"];
	myPETButton = _G["Critline_DisplayPETButton"];
	
	if myDMGButton:IsVisible() then
		visiblebuttoncount = visiblebuttoncount + 1;
	end
	if myHEALButton:IsVisible() then
		visiblebuttoncount = visiblebuttoncount + 1;
	end
	if myPETButton:IsVisible() then
		visiblebuttoncount = visiblebuttoncount + 1;
	end
	
	if visiblebuttoncount == 1 then
		Critline_Display:SetHeight(30);
	elseif visiblebuttoncount == 2 then
		Critline_Display:SetHeight(52);
	elseif visiblebuttoncount == 3 then
		Critline_Display:SetHeight(74);
	end	
	
	if myHEALButton:IsVisible() then
		myHEALButton:ClearAllPoints();
		if myDMGButton:IsVisible() then
			myHEALButton:SetPoint("TOP", "Critline_DisplayDMGButton", "BOTTOM", 0, -2);
			--Anchor HEAL to DMG
		else
			myHEALButton:SetPoint("TOPLEFT", 5, -5);
			--Anchor HEAL to Parent
		end
	end
	if myPETButton:IsVisible() then
		myPETButton:ClearAllPoints();
		if myHEALButton:IsVisible() then
			myPETButton:SetPoint("TOP", "Critline_DisplayHEALButton", "BOTTOM", 0, -2);
			--Anchor PET to HEAL
		elseif myDMGButton:IsVisible() then
			myPETButton:SetPoint("TOP", "Critline_DisplayDMGButton", "BOTTOM", 0, -2);
			--Anchor PET to DMG
		else
			myPETButton:SetPoint("TOPLEFT", 5, -5);
			--Anchor PET to Parent
		end
	end	
	
	
	if (CL_SETTINGS["SHOWDMG"] == "0" and CL_SETTINGS["SHOWHEAL"] == "0" and CL_SETTINGS["SHOWPET"] == "0") then
		if CL_SETTINGS["SHOWMINIMAP"]=="0" then
			Critline_Message(CL_DISPLAYHIDDEN_TEXT);
		end
		Critline_Display:Hide();
	end
end

function CritlineDisplay_OnLoad()
	
	this:RegisterEvent("VARIABLES_LOADED");
	Critline_OnUpdateRegister(CritlineDisplay_OnUpdate);
end

function CritlineDisplay_OnEvent(event)
	if (event == "VARIABLES_LOADED") then
		CritlineDisplay_OnUpdate();		

		local _,myClass = UnitClass("player");
		if (CL_SETTINGS["FIRSTLOAD"] == "1" or CL_SETTINGS["FIRSTLOAD"] == nil) then --by default on first time load, all trees are on
			if (myClass == "DEATH KNIGHT") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",true);
				CritlineDisplay_UpdateTree("PET",true);
			end 
			if (myClass == "DRUID") then -- by class we override the defaults
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",true);
				CritlineDisplay_UpdateTree("PET",false);
			end 
			if (myClass == "HUNTER") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",false);
				CritlineDisplay_UpdateTree("PET",true);
			end 
			if (myClass == "MAGE") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",false);
				CritlineDisplay_UpdateTree("PET",true);
			end 
			if (myClass == "PALADIN") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",true);
				CritlineDisplay_UpdateTree("PET",false);
			end 
			if (myClass == "PRIEST") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",true);
				CritlineDisplay_UpdateTree("PET",false);
			end 
			if (myClass == "ROGUE") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",false);
				CritlineDisplay_UpdateTree("PET",false);
			end 
			if (myClass == "SHAMAN") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",true);
				CritlineDisplay_UpdateTree("PET",false);
			end 
			if (myClass == "WARLOCK") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",false);
				CritlineDisplay_UpdateTree("PET",true);
			end 
			if (myClass == "WARRIOR") then
				CritlineDisplay_UpdateTree("DMG",true);
				CritlineDisplay_UpdateTree("HEAL",false);
				CritlineDisplay_UpdateTree("PET",false);
			end 
			CL_SETTINGS["FIRSTLOAD"] = "0"
		else --not a first time load, so use user settings to update trees which are still defaulted to on in the CritlineDisplay.xml
			if CL_SETTINGS["SHOWDMG"] == "0" then
				CritlineDisplay_UpdateTree("DMG",false);
			end
			if CL_SETTINGS["SHOWHEAL"] == "0" then
				CritlineDisplay_UpdateTree("HEAL",false);
			end
			if CL_SETTINGS["SHOWPET"] == "0" then
				CritlineDisplay_UpdateTree("PET",false);
			end
			-- gwiz665: fixes the bug where all three trees overlapped when loaded.
			if CL_SETTINGS["SHOWPET"] == "1" and CL_SETTINGS["SHOWHEAL"] == "1" and CL_SETTINGS["SHOWDMG"] == "1" then				
				CritlineDisplay_UpdateTree("PET",true);
			end
			
		end
	end 
end

function CritlineDisplay_OnUpdate()
	local amountcrit = CLB_GetHighest("DMG", "CRIT");
	amountcrit = amountcrit.."      "; --addes 6 spaces to end of crit
	amountcrit = strsub(amountcrit,1,6); --left 6 chars forcing amountcrit to be 6 chars long
	local amountnorm = CLB_GetHighest("DMG", "NORM");
	amountnorm = "      "..amountnorm; --addes 6 spaces to beginning of norm
	amountnorm = strsub(amountnorm,-6); --right 6 chars forcing amountnorm to be 6 chars long
	rtfText = amountnorm.."/"..amountcrit; --rtfText will always be 13 chars long with / in the middle..this keeps all numbers aligned
	mybutton = _G["Critline_DisplayDMG"];
	mybutton:SetText(rtfText);	


	amountcrit = CLB_GetHighest("HEAL", "CRIT");
	amountcrit = amountcrit.."      ";
	amountcrit = strsub(amountcrit,1,6);
	amountnorm = CLB_GetHighest("HEAL", "NORM");
	amountnorm = "      "..amountnorm;
	amountnorm = strsub(amountnorm,-6);
	rtfText = amountnorm.."/"..amountcrit;
	mybutton = _G["Critline_DisplayHEAL"];
	mybutton:SetText(rtfText);

	
	amountcrit = CLB_GetHighest("PET", "CRIT");
	amountcrit = amountcrit.."      ";
	amountcrit = strsub(amountcrit,1,6);
	amountnorm = CLB_GetHighest("PET", "NORM");
	amountnorm = "      "..amountnorm;
	amountnorm = strsub(amountnorm,-6);
	rtfText = amountnorm.."/"..amountcrit;
	mybutton = _G["Critline_DisplayPET"];
	mybutton:SetText(rtfText);
end

function Critline_AddTooltipText(text)
	if ( text ) then
		-- Append a "\n" to the end 
		if ( string.sub(text, -1, -1) ~= "\n" ) then
			text = text.."\n";
		end
		for text1, text2 in string.gmatch(text, "([^\t\n]*)\t?([^\t\n]*)\n") do
			if ( text2 ~= "" ) then
				GameTooltip:AddDoubleLine(text1, text2);
			elseif ( text1 ~= "" ) then
				GameTooltip:AddLine(text1);
			else
				GameTooltip:AddLine("\n");
			end			
		end
		GameTooltip:Show();
	end
end
