CL_DEBUG = false; -- for internal testing only, leave it set to false!

--[[ global addon variables ]]
CRITLINE_ID =  "CritlineBasic";
CRITLINE_VERSION = "BETA 10";

HEADER_TEXT_COLOR  = "|cffffffff";
SUBHEADER_TEXT_COLOR  = "|cffCEA208";
BODY_TEXT_COLOR  = "|cffffffff";
HINT_TEXT_COLOR  = "|cff00ff00";

Critline_Loaded = false;

Critline_UpdateTimer = 0;
Critline_OutOfControl = false;
Critline_MindControlled = false;

-----------------------------------------------------------------------------
function Critline_DataReset()
	CL_DATABASE = {};	
	CLB_SORTED_DB = {};
	Critline_Summary = {["DMG"]="",["HEAL"]="",["PET"]=""};
	Critline_Initialize();
end
-----------------------------------------------------------------------------
function Critline_SettingsReset()
	CL_SETTINGS = {};
	Critline_Initialize();
end
-----------------------------------------------------------------------------
function Critline_ResetAll()
	CL_SETTINGS = {};
	CL_DATABASE = {};
	CLB_DB_SORTED = {};
	Critline_Summary = {["DMG"]="",["HEAL"]="",["PET"]=""};
	Critline_Initialize();
end
-----------------------------------------------------------------------------
--new
-----------------------------------------------------------------------------
function CLB_GetHighest(tree, hittype)
	--hittype is 'NORM' or 'CRIT'
	--tree is 'DMG', 'PET' or 'HEAL'
	
	local hidmg = 0;
	local spellName = "n/a";
	
	tree = string.upper(tree);
	if (CLB_SORTED_DB == nil) then
		return hidmg, spell;
	end

	if (CLB_SORTED_DB[tree] == nil) then
		return hidmg, spell;
	end
	
	for index, spell in ipairs (CLB_SORTED_DB[tree]) do
		if (spell[hittype] > hidmg ) then
			hidmg = spell[hittype];
			spellName = spell["name"];
		end	
	end	
	return hidmg, spellName;
end
-----------------------------------------------------------------------------
-- new 
-----------------------------------------------------------------------------
function CLB_RebuildAllTooltips()
	Critline_Summary = {["DMG"]="",["HEAL"]="",["PET"]=""}; --have to rebuild cached data when a spell is filtered to update tooltips
	CLB_GetSummaryRichText("DMG")
	CLB_GetSummaryRichText("HEAL")
	CLB_GetSummaryRichText("PET")
	Critline_DoUpdate();
end
-----------------------------------------------------------------------------
-- new
-----------------------------------------------------------------------------
Critline_Summary = {["DMG"]="",["HEAL"]="",["PET"]=""}; -- hvorfor er denne her?
function CLB_GetSummaryRichText(tree)
--	This is for code optimization. We only build the rich summary when a new record is hit.
--	When a new record is recorded, the engine will blank out the Critline_Summary[tree]
-- 	This causes the tree to be rebuilt when this function is called.
	--tree is 'DMG', 'PET' or 'HEAL'
	
	tree = string.upper(tree);
	if (Critline_Summary[tree] == "") then
		Critline_Summary[tree] = CLB_BuildSummaryRichText(tree);
	end
	if (Critline_Summary[tree] == "") then
		return CL_NORECORDS_TEXT;
	end
	return Critline_Summary[tree];
end
-----------------------------------------------------------------------------
-- New function for the sorted DB
-----------------------------------------------------------------------------
function CLB_BuildSummaryRichText(tree)
	--tree is 'DMG', 'PET' or 'HEAL'
	
	tree = string.upper(tree);
	local hicrit = CLB_GetHighest(tree, "CRIT"); 
	local hidmg = CLB_GetHighest(tree, "NORM");
	local rtfAttack="";

	if (CLB_SORTED_DB[tree] == nil) then
		return SUBHEADER_TEXT_COLOR..CL_NORECORDS_TEXT..FONT_COLOR_CODE_CLOSE;
	end
	
	local crit_amount = "";
	local norm_amount = "";

	local formatted_entry = "";
	local summaryformat;	
	
--$sn = Spell name
--$na = Amount of damage for the Normal spell.
--$ca = Amount of damage for the Crit spell.
		summaryformat = "$sn\t[$na/$ca]\n";
	
	for index,spell in ipairs (CLB_SORTED_DB[tree]) do
		--get norm_amount
		if (CLB_SORTED_DB[tree][index]["NORM"] == hidmg ) then
			norm_amount = GREEN_FONT_COLOR_CODE..CLB_SORTED_DB[tree][index]["NORM"]..FONT_COLOR_CODE_CLOSE;
		else
			norm_amount = HIGHLIGHT_FONT_COLOR_CODE..CLB_SORTED_DB[tree][index]["NORM"]..FONT_COLOR_CODE_CLOSE;
		end
		--get crit_amount
		if ( CLB_SORTED_DB[tree][index]["CRIT"] == hicrit ) then
				crit_amount = GREEN_FONT_COLOR_CODE..CLB_SORTED_DB[tree][index]["CRIT"]..FONT_COLOR_CODE_CLOSE;
		else
				crit_amount = HIGHLIGHT_FONT_COLOR_CODE..CLB_SORTED_DB[tree][index]["CRIT"]..FONT_COLOR_CODE_CLOSE;
		end
		
		formatted_entry = summaryformat;

		formatted_entry = string.gsub(formatted_entry,"$sn",spell["name"]);		
		formatted_entry = string.gsub(formatted_entry,"$na",norm_amount);		
		formatted_entry = string.gsub(formatted_entry,"$ca",crit_amount);
		
		rtfAttack = rtfAttack..formatted_entry;		
	end
	rtfAttack = strsub(rtfAttack,1,string.len(rtfAttack)-1);
	return rtfAttack;
end	
-----------------------------------------------------------------------------
--New
-----------------------------------------------------------------------------
function CLB_OnEvent(event,...)
	if event=="ADDON_LOADED" then
		if arg1 == "CritlineBasic" then
			Critline_Initialize();
			CritlineSplashFrame:EnableMouse(0)
			CritlineSplashFrame:Clear();
			Critline_Loaded = true;
		end
	elseif event=="PLAYER_CONTROL_LOST" then
		if not Critline_Loaded then
			return;
		end
		--this covers fear, taxi, mind control, and others
		Critline_OutOfControl = true;
	elseif event=="PLAYER_CONTROL_GAINED" then
		if not Critline_Loaded then
			return;
		end
		Critline_OutOfControl = false;
		Critline_MindControlled = false;
	elseif event=="COMBAT_LOG_EVENT_UNFILTERED" then
		if not Critline_Loaded then
			return;
		end
		
		
		local timestamp, eventType, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags = ...
		local isPet = false;
		-- we seem to get events with standard arguments equal to nil, so they need to be ignored
		if (timestamp == nil) or (eventType == nil) then			
			return;
		end

		--if we don't have a destName (who we hit or healed) and we don't have a sourceName(us or our pets) then we leave
		if destName == nil and sourceName == nil then			
			return;
		end
		
		local myGUID = UnitGUID("player");		
		local myPetGUID = UnitGUID("pet");
		
		
		--if sourceGUID  is not us or our pet, we leave
		if sourceGUID ~= myGUID then
			if myPetGUID then
				if sourceGUID ~= myPetGUID then					
					return;
				end
			else				
				return;
			end
		end
		
		if sourceGUID == myPetGUID then
			isPet = true;
		end

		if Critline_MindControlled then
			-- critline basic always suppress MC events			
			return;
		end
		
		local amount, overkill, overhealing, school, resisted, blocked, absorbed, critical, glancing, crushing, missType, enviromentalType
		local spellId, spellName, spellSchool, powerType, extraAmount, extraSpellId, extraSpellName, extraSpellSchool, auraType
		local schoolName, powerName, extraSchoolName -- we translate the school number and the power type number to a localized name
		local hitword, damageType
		if (eventType =="SPELL_CAST_START") or (eventType == "SPELL_CAST_FAILED") or (eventType == "SPELL_CAST_SUCCESS") or (eventType == "SWING_DAMAGE") then
			if Critline_OutOfControl then
				--if we are out of control and casting spells and/or attacking, we are mind controlled
				Critline_MindControlled = true;
			end
		end

		if (eventType == "SWING_DAMAGE") then
			-- can be non-Physical damage (e.g. Melee that hits as Shadow damage)
			--local amount, overkill, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...)
			amount, overkill, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...)
			if amount and (amount == 0) then
				return;
			end
			
			CLB_HitHandle(sourceName, destName, "Melee", false, critical, amount, isPet, destGUID);
			
		elseif (eventType == "RANGE_DAMAGE") then
			-- for a wand the spellSchool is Physical but the school is e.g. Shadow, so don't check whether they differ
			spellId, spellName, spellSchool, amount, overkill, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...)
			if amount and (amount == 0) then
				return;
			end

			CLB_HitHandle(sourceName, destName, spellName, false, critical, amount, isPet, destGUID);

		elseif (eventType == "SPELL_DAMAGE") or (eventType == "SPELL_PERIODIC_DAMAGE") or (eventType == "DAMAGE_SPLIT") or (eventType == "DAMAGE_SHIELD") then
			-- implication is that PERIODIC damage could be critical, glancing, or crushing, but I've not seen that
			spellId, spellName, spellSchool, amount, overkill, school, resisted, blocked, absorbed, critical, glancing, crushing = select(9, ...)
			if amount and (amount == 0) then
				return
			end			
			CLB_HitHandle(sourceName, destName, spellName, false, critical, amount, isPet, destGUID);
		-- healing events
		elseif (eventType == "SPELL_HEAL") or (eventType == "SPELL_PERIODIC_HEAL") then
			spellId, spellName, spellSchool, amount, overhealing, critical = select(9, ...)
			if amount and (amount == 0) then
				return
			end
			CLB_HitHandle(sourceName, destName, spellName, true, critical, amount, isPet, destGUID);
		end
	
	end
end
-----------------------------------------------------------------------------

function Critline_OnLoad()
	this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("PLAYER_CONTROL_LOST");
	this:RegisterEvent("PLAYER_CONTROL_GAINED");
end
-----------------------------------------------------------------------------
function Critline_Initialize()
	--settings
	if (CL_SETTINGS == nil) then
		CL_SETTINGS = {};
	end
	if ( CL_SETTINGS["MINIMAPPOS"] == nil ) then
		CL_SETTINGS["MINIMAPPOS"] = "0";
	end
	if ( CL_SETTINGS["SHOWMINIMAP"] == nil ) then
		CL_SETTINGS["SHOWMINIMAP"] = "1";
	end
		if ( CL_SETTINGS["SHOWSLIDEICON"] == nil ) then
		CL_SETTINGS["SHOWSLIDEICON"] = "0";
	end
	if (CL_SETTINGS["SUPPRESSMC"]) == nil then
		CL_SETTINGS["SUPPRESSMC"] = "1";
	end
	if (CL_SETTINGS["VERSION"] == nil) then
		CL_SETTINGS["VERSION"] = CL_VERSION;
	end
	if (CL_SETTINGS["LVLADJ"] == nil) then
		CL_SETTINGS["LVLADJ"] = "0";
	end
	if (CL_SETTINGS["SCALE"] == nil) then
		CL_SETTINGS["SCALE"] = "1";
	end
	if (CL_SETTINGS["SPLASHSCALE"] == nil) then
		CL_SETTINGS["SPLASHSCALE"] = "1";
	end
	if (CL_SETTINGS["SPLASH"] == nil) then
		CL_SETTINGS["SPLASH"] = "1";
	end
	if (CL_SETTINGS["PVPONLY"] == nil) then
		CL_SETTINGS["PVPONLY"] = "0";
	end
	if (CL_SETTINGS["PLAYSOUND"] == nil) then
		CL_SETTINGS["PLAYSOUND"] = "1";
	end
	if (CL_SETTINGS["SNAPSHOT"] == nil) then
		CL_SETTINGS["SNAPSHOT"] = "0";
	end
	if ( CL_SETTINGS["DMG"] == nil ) then
		CL_SETTINGS["DMG"] = "1";
	end
	if ( CL_SETTINGS["HEAL"] == nil ) then
		CL_SETTINGS["HEAL"] = "1";
	end
	if ( CL_SETTINGS["PET"] == nil ) then
		CL_SETTINGS["PET"] = "1";
	end
	if ( CL_SETTINGS["SHOWDMG"] == nil ) then
		CL_SETTINGS["SHOWDMG"] = "1";
	end
	if ( CL_SETTINGS["SHOWHEAL"] == nil ) then
		CL_SETTINGS["SHOWHEAL"] = "1";
	end
	if ( CL_SETTINGS["SHOWPET"] == nil ) then
		CL_SETTINGS["SHOWPET"] = "1";	
	end
	if ( CL_SETTINGS["FIRSTLOAD"] == nil ) then --feyde..default FIRSTLOAD to on so CritlineDisplay_OnEvent can turn on trees by class
		CL_SETTINGS["FIRSTLOAD"] = "1";
	end
	if ( CL_SETTINGS["SPLASHTIMER"] == nil ) then
		CL_SETTINGS["SPLASHTIMER"] = "2";
	end
	if ( CL_SETTINGS["SPELLCOLOR"] == nil ) then
		CL_SETTINGS["SPELLCOLOR"] = {};
		CL_SETTINGS["SPELLCOLOR"]["r"] = 1;
		CL_SETTINGS["SPELLCOLOR"]["g"] = 1;
		CL_SETTINGS["SPELLCOLOR"]["b"] = 0;
	end
	if ( CL_SETTINGS["AMOUNTCOLOR"] == nil ) then
		CL_SETTINGS["AMOUNTCOLOR"] = {};
		CL_SETTINGS["AMOUNTCOLOR"]["r"] = 1;
		CL_SETTINGS["AMOUNTCOLOR"]["g"] = 1;
		CL_SETTINGS["AMOUNTCOLOR"]["b"] = 1;
	end
	if ( CL_SETTINGS["SPLASHFRAME"] == nil ) then
		CL_SETTINGS["SPLASHFRAME"] = {};
	end
	if ( CL_SETTINGS["SPLASHFRAME"]["point"] ) then
		CritlineSplashFrame:ClearAllPoints();
		CritlineSplashFrame:SetPoint(CL_SETTINGS["SPLASHFRAME"]["point"], CL_SETTINGS["SPLASHFRAME"]["x"], CL_SETTINGS["SPLASHFRAME"]["y"]);
	end
	
	--database
	if (CL_DATABASE == nil) then
		CL_DATABASE = {};
	end
	if (CL_DATABASE["DMG"] == nil) then
		CL_DATABASE["DMG"] = {};
	end
	if (CL_DATABASE["HEAL"] == nil) then
		CL_DATABASE["HEAL"] = {};
	end
	if (CL_DATABASE["PET"] == nil) then
		CL_DATABASE["PET"] = {};
	end	

	
	-- sorted database
		if (CLB_SORTED_DB == nil) then
		CLB_SORTED_DB = {};
	end
	if (CLB_SORTED_DB["DMG"] == nil) then
		CLB_SORTED_DB["DMG"] = {};
	end
	if (CLB_SORTED_DB["HEAL"] == nil) then
		CLB_SORTED_DB["HEAL"] = {};
	end
	if (CLB_SORTED_DB["PET"] == nil) then
		CLB_SORTED_DB["PET"] = {};
	end	
	CritlineSplashFrame:SetTimeVisible(2);
	--Critline_RebuildAllTooltips();	
	CLB_RebuildAllTooltips();	
	Critline_Message("Critline Basic loaded.");
	
end
-----------------------------------------------------------------------------
--Isn't there a better way than this?
function Critline_UnitLevel(destGUID)
		
		CritlineTooltip:SetHyperlink("unit:"..destGUID);
		local level = UnitLevel("player"); --by default, all mobs are fair game
		local IsPlayer = false; --by default we are fighting a mob
		for i=1,CritlineTooltip:NumLines() do
			local mytext = _G["CritlineTooltipTextLeft" .. i]
			local text = mytext:GetText()
			if text then
				if string.find(text,LEVEL) then --our destGUID has the world Level in it.
					_,_,level = string.find(text,"(%d+)");  -- find the level
					if level then  --if we found the level, break from the for loop
						level = tonumber(level);
					else
						--well, the word Level is in this tooltip, but we could not find the level
						--either the destGUID is at least 10 levels higher than us, or we just couldn't find it.
						level = UnitLevel("player");  --like I said, by default, all mobs are fair game
					end
				end
				if string.find(text,PLAYER) then --our destGUID has the word Player in it.
					--we are fighting another Player, this is used for PvP flag
					IsPlayer = true;
				end
			end
		end	
		return level, IsPlayer;

end
-----------------------------------------------------------------------------
--New function for the sorted table
-----------------------------------------------------------------------------
function CLB_HitHandle(attacker, target, spell, isheal, iscrit, amount, isPet, destGUID)
	
	if (amount == nil) then		
		return;
	end
	
	local targetlvl, isPlayer = Critline_UnitLevel(destGUID)

	if (( not isPlayer ) and (CL_SETTINGS["PVPONLY"] == "1") ) then
		return;
	end

	local leveldiff = 0;
	if targetlvl < UnitLevel("player") then
		leveldiff = (UnitLevel("player") - targetlvl);
	end
	
	if ( (tonumber(CL_SETTINGS["LVLADJ"]) ~= 0) and (tonumber(CL_SETTINGS["LVLADJ"]) < leveldiff) ) then
		return;
	end

	if (CLB_SORTED_DB == nil) then
		Critline_Initialize();
	end

	if isPet then
		tree = "PET";
	elseif isheal then
		tree = "HEAL";
	else
		tree = "DMG";
	end

	--exit if not recording type dmg.
	if ( CL_SETTINGS[tree] == "0" ) then
		return;
	end
	
	local hitype = "NORM";
	if (iscrit) then
		hitype = "CRIT";
	end


	if (CLB_SORTED_DB[tree] == nil) then
		CLB_SORTED_DB[tree] ={};
	end
	
	--Laver en "tom" plads til spellen, hvis den ikke eksisterer.
	local spellIndex = findSpellIndex(spell, tree);
	
	if (spellIndex == -1) then
		table.insert(CLB_SORTED_DB[tree], {name=spell, NORM = 0, CRIT = 0});
		spellIndex = #CLB_SORTED_DB[tree];	
	end
	
	-- indstter hvis der er givet mere skade end der allerede er gemt
	if (CLB_SORTED_DB[tree][spellIndex][hitype] < amount ) then
		CLB_SORTED_DB[tree][spellIndex][hitype] = amount;
		Critline_Summary[tree] = ""; -- viser at tooltippet skal gendannes
		CLB_DisplayNewRecord(spell, amount, iscrit);
		table.sort(CLB_SORTED_DB[tree], function(a,b) return a["NORM"] > b["NORM"] end); -- skal skiftes til en dynamisk udgave, hvor man har valget mellem norm/crit
	end
end
-----------------------------------------------------------------------------
--new
-----------------------------------------------------------------------------
function CLB_DisplayNewRecord(spell, amount, iscrit)

	splash_msg = CL_NEW_RECORD_MSG;
	if(CL_SETTINGS["SPLASH"] == "1") then
		CritlineSplashFrame:AddMessage(amount, CL_SETTINGS["AMOUNTCOLOR"]["r"], CL_SETTINGS["AMOUNTCOLOR"]["g"],CL_SETTINGS["AMOUNTCOLOR"]["b"], 1);
		CritlineSplashFrame:AddMessage(format(splash_msg, spell), CL_SETTINGS["SPELLCOLOR"]["r"], CL_SETTINGS["SPELLCOLOR"]["g"], CL_SETTINGS["SPELLCOLOR"]["b"], 1);
		if iscrit then
			CritlineSplashFrame:AddMessage("! ".. strupper(TEXT_MODE_A_STRING_RESULT_CRITICAL).." !", 1,0,0, 1);
		end
	end
	if(CL_SETTINGS["PLAYSOUND"] == "1") then
		PlaySound("LEVELUP", 1, 1, 0, 1, 3);
	end
	CLB_RebuildAllTooltips(); --feyde...since Tooltips are now cached, we have to reset them to update the new record data.
end
-----------------------------------------------------------------------------
CLOU_Handles = {};
function Critline_DoUpdate()
	for k, v in pairs(CLOU_Handles) do
		v();
	end
end
-----------------------------------------------------------------------------
function Critline_OnUpdateRegister(newhandler)
	table.insert(CLOU_Handles, newhandler);
end
-----------------------------------------------------------------------------
--[[ misc help functions ]]
function Critline_Color(color, msg)
	if ( msg == nil ) then
		return;
	end
	return color..msg..FONT_COLOR_CODE_CLOSE;
end
-----------------------------------------------------------------------------
function Critline_Message(msg)
	if ( msg == nil ) then
		msg = "Critline_Message passed a nil value.";
	end
	if (DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage(msg);
	end
end
-----------------------------------------------------------------------------
function findSpellIndex(spell_name, tree)	
	local spellIndex = -1;
	for index, spell in ipairs(CLB_SORTED_DB[tree]) do
		if (spell["name"] == spell_name) then
			spellIndex = index;
		end	
	end	
	return spellIndex;
end

-----------------------------------------------------------------------------
--[[ xml function calls ]]
function CritlineSplashFrame_OnLoad()
	this.update = 1;
	this.locked = true;
	this:RegisterForDrag("LeftButton")
end
-----------------------------------------------------------------------------
function CritlineSplashFrame_OnUpdate()
	if not Critline_Loaded then
		return;
	end

	if ( not this.locked ) then
		CritlineSplashFrame:AddMessage(CL_SPLASHFRAME_UNLOCKED_TEXT, CL_SETTINGS["AMOUNTCOLOR"]["r"], CL_SETTINGS["AMOUNTCOLOR"]["g"], CL_SETTINGS["AMOUNTCOLOR"]["b"], 1);
		CritlineSplashFrame:AddMessage(CL_SPLASHFRAME_DRAGTOMOVE_TEXT, CL_SETTINGS["SPELLCOLOR"]["r"], CL_SETTINGS["SPELLCOLOR"]["g"], CL_SETTINGS["SPELLCOLOR"]["b"], 1);
	end
end
-----------------------------------------------------------------------------
function CritlineSplashFrame_OnDragStart()
	if ( not this.locked ) then
		this:StartMoving();
	end
end
-----------------------------------------------------------------------------
function CritlineSplashFrame_OnDragStop()
	this:StopMovingOrSizing();
	point, relativeTo, relativePoint, xOfs, yOfs = CritlineSplashFrame:GetPoint()
	CL_SETTINGS["SPLASHFRAME"]["point"] = point;
	CL_SETTINGS["SPLASHFRAME"]["x"] = xOfs;
	CL_SETTINGS["SPLASHFRAME"]["y"] = yOfs;	
end