--[[
	This file provides configuration for Creature Comforts.
	See README.TXT for license and additional information.
--]]

if select(2, UnitClass("player")) ~= "HUNTER" then return end

local CreatureComforts = CreatureComforts
local ADDON_NAME = GetAddOnMetadata("CreatureComforts", "Title")

local CreateCheckbox = LibStub("tekKonfig-Checkbox").new
local CreateDropdown = LibStub("PhanxConfig-Dropdown").new
local CreateSlider = LibStub("PhanxConfig-Slider").new

local dev = UnitName("player") == "Ghinjo" and GetRealmName() == "Sargeras"

local panel = CreateFrame("Frame", nil, UIParent)
panel.name = ADDON_NAME
panel:Hide()
panel:SetScript("OnShow", function(self)
	local L = CreatureComforts.L
	local db = CreatureComforts.db

	local title, subtitle = LibStub("tekKonfig-Heading").new(self, ADDON_NAME, GetAddOnMetadata("CreatureComforts", "Notes"))

	--
	--	Macro creator button
	--

	local button = LibStub("tekKonfig-Button").new(self, "TOPLEFT", subtitle, "BOTTOMLEFT", -2, -8)
	button.tiptext = L["Create a character macro for one-button pet care"]
	button:SetText(L["Create Macro"])
	button:SetWidth(button:GetWidth() * 1.5)
	button:SetScript("OnClick", function(self)
		if InCombatLockdown() then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaad372Creature Comforts:|r You cannot create macros while in combat.")
		elseif select(2, GetNumMacros()) >= 18 then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaad372Creature Comforts:|r All character macro slots are in use.")
		else
			CreateMacro("AutoPet", 1, "", 1, 1)
			CreatureComforts:Scan()
		end
	end)

	--
	--	Macro option checkboxes
	--

	local feedhappy = CreateCheckbox(self, nil, L["Feed when happy"], "TOPLEFT", button, "BOTTOMLEFT", 0, -16)
	local checksound = feedhappy:GetScript("OnClick")
	feedhappy.tiptext = L["Automatically use food even when your pet is already happy"]
	feedhappy:SetScript("OnClick", function(self) checksound(self); CreatureComforts.db.feedHappy = not CreatureComforts.db.feedHappy; CreatureComforts:Edit() end)
	feedhappy:SetChecked(CreatureComforts.db.feedHappy)

	local showicon = CreateCheckbox(self, nil, L["Show item icon"], "TOPLEFT", feedhappy, "BOTTOMLEFT", -2, -8)
	showicon.tiptext = L["Show the icon of the food that will be fed to your pet, instead of the Feed Pet spell icon"]
	showicon:SetScript("OnClick", function(self) checksound(self); CreatureComforts.db.showFood = not CreatureComforts.db.showFood; CreatureComforts:BAG_UPDATE() end)
	showicon:SetChecked(CreatureComforts.db.showFood)

	--
	--	Food type checkboxes
	--

	local usebonus = CreateCheckbox(self, nil, L["Use bonus foods"], "TOPLEFT", showicon, "BOTTOMLEFT", -2, -16)
	usebonus.tiptext = L["Include foods which provide stat bonuses when eaten in your pet's diet"]
	local checksound = usebonus:GetScript("OnClick")
	usebonus:SetScript("OnClick", function(self) checksound(self); CreatureComforts.db.useBonus = not CreatureComforts.db.useBonus; CreatureComforts:Diet() end)
	usebonus:SetChecked(CreatureComforts.db.useBonus)

	local usecombo = CreateCheckbox(self, nil, L["Use combo foods"], "TOPLEFT", usebonus, "BOTTOMLEFT", 0, -8)
	usecombo.tiptext = L["Include foods which restore both health and mana in your pet's diet"]
	usecombo:SetScript("OnClick", function(self) checksound(self); CreatureComforts.db.useCombo = not CreatureComforts.db.useCombo; CreatureComforts:Diet() end)
	usecombo:SetChecked(CreatureComforts.db.useCombo)

	local useconjured = CreateCheckbox(self, nil, L["Use conjured foods"], "TOPLEFT", usecombo, "BOTTOMLEFT", 0, -8)
	useconjured.tiptext = L["Include foods conjured by mages in your pet's diet"]
	useconjured:SetScript("OnClick", function(self) checksound(self); CreatureComforts.db.useConjured = not CreatureComforts.db.useConjured; CreatureComforts:Diet() end)
	useconjured:SetChecked(CreatureComforts.db.useConjured)

	local useraw = CreateCheckbox(self, nil, L["Use raw foods"], "TOPLEFT", useconjured, "BOTTOMLEFT", 0, -8)
	useraw.tiptext = L["Include raw foods which may be usable by the Cooking profession in your pet's diet"]
	useraw:SetScript("OnClick", function(self) checksound(self); CreatureComforts.db.useRaw = not CreatureComforts.db.useRaw; CreatureComforts:Diet() end)
	useraw:SetChecked(CreatureComforts.db.useRaw)

	--
	--	General dropdown stuff
	--

	local info = {}
	local function AddItem(text, value, func, checked, disabled)
		info.text = text
		info.value = value
		info.func = func
		info.checked = checked
		info.disabled = disabled
		UIDropDownMenu_AddButton(info)
	end

	local modrev = { ["alt"] = L["Alt"], ["ctrl"] = L["Ctrl"], ["shift"] = L["Shift"] }

	--
	--	Dismiss modifier key
	--

	local dismiss, dismisstext, dismisslabel = CreateDropdown(self, L["Dismiss key"], "RIGHT", subtitle, "BOTTOMRIGHT", 2, -(button:GetHeight() + 8 + 16 + (feedhappy:GetHeight() / 2)))
	dismisstext:SetText(db.dismissModifier)
	dismiss.tiptext = L["Use this modifier key to Dismiss your pet"]

	local function Dismiss_OnClick()
		UIDropDownMenu_SetSelectedValue(dismiss, this.value)
		dismisstext:SetText(modrev[this.value])
		db.dismissModifier = this.value
		CreatureComforts:Edit()
	end

	local function Dismiss_Initialize()
		local selected = db.dismissModifier
		local other = db.mendModifier

		AddItem(L["Alt"], "alt", Dismiss_OnClick, "alt" == selected, "alt" == other)
		AddItem(L["Ctrl"], "ctrl", Dismiss_OnClick, "ctrl" == selected, "ctrl" == other)
		AddItem(L["Shift"], "shift", Dismiss_OnClick, "shift" == selected, "shift" == other)
	end

	UIDropDownMenu_Initialize(dismiss, Dismiss_Initialize)
	UIDropDownMenu_SetSelectedValue(dismiss, db.dismissModifier)

	--
	--	Out-of-combat Mend modifier key
	--

	local mend, mendtext, mendlabel = CreateDropdown(self, L["Mend/Revive key"], "TOPRIGHT", dismiss, "BOTTOMRIGHT", 0, -16)
	mendtext:SetText(db.mendModifier)
	mend.tiptext = L["Use this modifier key to Mend your pet out of combat, or Revive it during combat if it's despawned"]

	local function Mend_OnClick()
		UIDropDownMenu_SetSelectedValue(mend, this.value)
		mendtext:SetText(modrev[this.value])
		db.mendModifier = this.value
		CreatureComforts:Edit()
	end

	local function Mend_Initialize()
		local selected = db.mendModifier
		local other = db.dismissModifier

		AddItem(L["Alt"], "alt", Mend_OnClick, "alt" == selected, "alt" == other)
		AddItem(L["Ctrl"], "ctrl", Mend_OnClick, "ctrl" == selected, "ctrl" == other)
		AddItem(L["Shift"], "shift", Mend_OnClick, "shift" == selected, "shift" == other)
	end

	UIDropDownMenu_Initialize(mend, Mend_Initialize)
	UIDropDownMenu_SetSelectedValue(mend, db.mendModifier)
	mend:SetScript("OnShow", Mend_OnShow)

	--
	--	Out-of-combat Mend health threshold
	--
if dev then
	local mendthreshold = CreateSlider(self, "Mend Threshold", 0, 1, 0.05, true, "TOPRIGHT", mend, "BOTTOMRIGHT", 0, -8)
	mendthreshold.tip = L["Mend your pet out of combat by default when its health is below this threshold"]
	mendthreshold.set = function(self)
		db.mendThreshold = self.value
		CreatureComforts:UNIT_HEALTH("pet")
	end
	mendthreshold:SetValue(db.mendThreshold)
end
	--
	--	Enable and disable the "create macro" button as needed
	--

	local function Refresh(self)
		if GetMacroIndexByName("AutoPet", 1) == 0 then button:Enable() else button:Disable() end
		self:RegisterEvent("UPDATE_MACROS")
	end

	self:SetScript("OnEvent", Refresh)
	self:SetScript("OnShow", Refresh)
	self:SetScript("OnHide", function(self) self:UnregisterEvent("UPDATE_MACROS") end)
	Refresh(self)
end)

InterfaceOptions_AddCategory(panel)
LibStub("tekKonfig-AboutPanel").new(ADDON_NAME, "CreatureComforts")

SLASH_CREATURECOMFORTS1 = "/creaturecomforts"
SLASH_CREATURECOMFORTS2 = "/cc"
SlashCmdList.CREATURECOMFORTS = function()
	InterfaceOptionsFrame_OpenToFrame(panel)
end