--[[
	PhanxConfig-Slider
	Based on AceGUI-3.0-Slider
--]]

local lib = LibStub:NewLibrary("PhanxConfig-Slider", 1)
if not lib then return end

local slider_bg = {
	bgFile = "Interface\\Buttons\\UI-SliderBar-Background",
	edgeFile = "Interface\\Buttons\\UI-SliderBar-Border", edgeSize = 8,
	tile = true, tileSize = 8, insets = { left = 3, right = 3, top = 6, bottom = 6 }
}

local function UpdateText(self)
	if self.ispercent then
		self.editbox:SetText((math.floor(self.value * 1000 + 0.5) / 10).."%")
	else
		self.editbox:SetText(math.floor(self.value * 100 + 0.5) / 100)
	end
end

local function SetDisabled(self, disabled)
	self.disabled = disabled
	if disabled then
		self.slider:EnableMouse(false)
		self.label:SetTextColor(.5,.5,.5)
		self.hightext:SetTextColor(.5,.5,.5)
		self.lowtext:SetTextColor(.5,.5,.5)
		self.editbox:SetTextColor(.5,.5,.5)
		self.editbox:EnableMouse(false)
		self.editbox:ClearFocus()
	else
		self.slider:EnableMouse(true)
		self.label:SetTextColor(1,.82,0)
		self.hightext:SetTextColor(1,1,1)
		self.lowtext:SetTextColor(1,1,1)
		self.editbox:SetTextColor(1,1,1)
		self.editbox:EnableMouse(true)
	end
end

local function SetValue(self, value)
	self.locked = true
	self.value = value
	self.slider:SetValue(value)
	UpdateText(self)
	self.locked = nil
end

local function OnEnter(self)
	if self.tip then
		GameTooltip:SetOwner(self)
		GameTooltip:SetText(self.tip)
		GameTooltip:Show()
	end
end

local function OnLeave()
	GameTooltip:Hide()
end

local function Slider_OnMouseWheel(self, delta)
	if not self.disabled then
		local value = self.value
		if delta > 0 then
			value = math.min(value + (self.step or 1), self.max)
		else
			value = math.max(value - (self.step or 1), self.min)
		end
		self.slider:SetValue(value)
		UpdateText(self)
	end
end

local function Slider_OnValueChanged(self)
	local parent = self:GetParent()
	if not parent.locked then
		local newvalue = self:GetValue()
		if newvalue ~= parent.value and not parent.disabled then
			parent.value = newvalue
			if parent.set then
				parent.set(parent, newvalue)
			end
		end
		if self.value then
			UpdateText(parent)
		end
	end
end

local function EditBox_OnEnterPressed(self)
	local value = self:GetText()
	local parent = self:GetParent()
	if parent.ispercent then
		value = value:gsub("%%", "")
		value = tonumber(value) / 100
	else
		value = tonumber(value)
	end
	SetValue(parent, value)
	if parent.set then
		parent.set(parent, value)
	end
end

local function EditBox_OnEscapePressed(self)
	self:ClearFocus()
end

function lib.new(parent, label, min, max, step, ispercent, ...)
	local frame = CreateFrame("Frame", nil, parent)
	frame.SetDisabled = SetDisabled
	frame.SetValue = SetValue

	local slider = CreateFrame("Slider", nil, frame)
	slider:EnableMouse(true)
	slider:SetBackdrop(slider_bg)
	slider:SetHitRectInsets(0, 0, -10, -10)
	slider:SetOrientation("HORIZONTAL")
	slider:SetThumbTexture("Interface\\Buttons\\UI-SliderBar-Button-Horizontal")
	slider:SetMinMaxValues(min, max)
	slider:SetValueStep(step)
	slider:SetScript("OnEnter", OnEnter)
	slider:SetScript("OnLeave", OnLeave)
	slider:SetScript("OnMouseWheel", Slider_OnMouseWheel)
	slider:SetScript("OnValueChanged", Slider_OnValueChanged)
	frame.slider = slider

	local label = frame:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
	label:SetPoint("TOPLEFT", slider, "TOPLEFT", 2, 0)
	label:SetPoint("TOPRIGHT", slider, "TOPRIGHT", -2, 0)
	label:SetJustifyH("CENTER")
	label:SetHeight(15)
	label:SetText(label)
	frame.label = label
	
	local lowtext = frame:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
	lowtext:SetPoint("TOPLEFT", slider, "BOTTOMLEFT", 2, 3)
	lowtext:SetText(ispercent and ((min * 100).."%") or min)
	frame.lowtext = lowtext
	
	local hightext = frame:CreateFontString(nil, "OVERLAY", "GameFontNormalSmall")
	hightext:SetPoint("TOPRIGHT", slider, "BOTTOMRIGHT", -2, -3)
	hightext:SetText(ispercent and ((max * 100).."%") or max)
	frame.hightext = hightext
	
	local editbox = CreateFrame("EditBox", nil, frame)
	editbox:SetAutoFocus(false)
	editbox:SetFontObject(GameFontHighlightSmall)
	editbox:SetPoint("TOP", slider, "BOTTOM", -2, 0)
	editbox:SetHeight(14)
	editbox:SetWidth(70)
	editbox:SetJustifyH("CENTER")
	editbox:EnableMouse(true)
	editbox:SetScript("OnEscapePressed", EditBox_OnEscapePressed)
	editbox:SetScript("OnEnterPressed", EditBox_OnEnterPressed)
	frame.editbox = editbox
	
	local bg = editbox:CreateTexture(nil, "BACKGROUND")
	bg:SetTexture("Interface\\ChatFrame\\ChatFrameBackground")
	bg:SetVertexColor(0, 0, 0, 0.25)
	bg:SetAllPoints(editbox)

	frame:SetWidth(200) frame:SetHeight(44)
	slider:SetPoint("TOP", labeltext, "BOTTOM",0, 0)
	slider:SetPoint("LEFT", frame, "LEFT", 3, 0)
	slider:SetPoint("RIGHT", frame, "RIGHT", -3, 0)
	if select(1, ...) then frame:SetPoint(...) end

	return frame
end