--[[
	PhanxConfig-Dropdown
	Based on tekKonfig-Dropdown and Tuller's dropdown implementation in Dominos
--]]

local lib, oldminor = LibStub:NewLibrary("PhanxConfig-Dropdown", 1)
if not lib then return end

local function Dropdown_OnEnter(self)
	if self.tiptext then
		GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
		GameTooltip:SetText(self.tiptext, nil, nil, nil, nil, true)
	end
end

local function Dropdown_OnLeave()
	GameTooltip:Hide()
end

local function Dropdown_OnClick()
	ToggleDropDownMenu()
	PlaySound("igMainMenuOptionCheckBoxOn")
end

local function Dropdown_OnHide()
	CloseDropDownMenus()
end

function lib.new(parent, label, ...)
	local name = "PhanxConfigDropdown"..(GetTime()*1000)

	local f = CreateFrame("Frame", name, parent)
	f:SetWidth(149) f:SetHeight(32)
	if select(1, ...) then f:SetPoint(...) end
	f:EnableMouse(true)
	f:SetScript("OnHide", Dropdown_OnHide)
	f:SetScript("OnEnter", Dropdown_OnEnter)
	f:SetScript("OnLeave", Dropdown_OnLeave)

	local ltex = f:CreateTexture(name.."Left", "ARTWORK")
	ltex:SetWidth(25) ltex:SetHeight(64)
	ltex:SetPoint("TOPLEFT", 0, 17)
	ltex:SetTexture("Interface\\Glues\\CharacterCreate\\CharacterCreate-LabelFrame")
	ltex:SetTexCoord(0, 0.1953125, 0, 1)

	local mtex = f:CreateTexture(nil, "ARTWORK")
	mtex:SetWidth(115) mtex:SetHeight(64)
	mtex:SetPoint("LEFT", ltex, "RIGHT")
	mtex:SetTexture("Interface\\Glues\\CharacterCreate\\CharacterCreate-LabelFrame")
	mtex:SetTexCoord(0.1953125, 0.8046875, 0, 1)

	local rtex = f:CreateTexture(nil, "ARTWORK")
	rtex:SetWidth(25) rtex:SetHeight(64)
	rtex:SetPoint("LEFT", mtex, "RIGHT")
	rtex:SetTexture("Interface\\Glues\\CharacterCreate\\CharacterCreate-LabelFrame")
	rtex:SetTexCoord(0.8046875, 1, 0, 1)

	local text = f:CreateFontString(name.."Text", "ARTWORK", "GameFontHighlightSmall")
--	text:SetWidth(0) text:SetHeight(10)
	text:SetPoint("RIGHT", rtex, -43, 2)
	text:SetJustifyH("RIGHT")
	
	local ltext = f:CreateFontString(nil, "BACKGROUND", "GameFontNormal")
	ltext:SetPoint("BOTTOMLEFT", f, "TOPLEFT", 16, 3)
	ltext:SetText(label)

	local button = CreateFrame("Button", nil, f)
	button:SetWidth(24) button:SetHeight(24)
	button:SetPoint("TOPRIGHT", rtex, -16, -18)
	button:SetNormalTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollDown-Up")
	button:SetPushedTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollDown-Down")
	button:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight")
	button:SetDisabledTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollDown-Disabled")
	button:GetHighlightTexture():SetBlendMode("ADD")
	button:SetScript("OnClick", Dropdown_OnClick)

	return f, text, label
end

--[[
TestDD = lib.new(UIParent, "Test", "CENTER")

--]]