--[[--------------------------------------------------------------------
	Creature Comforts
	Easy hunter pet care
	by Phanx < addons AT phanx net >

	See the included README.TXT file for more information.

	You MAY NOT include this addon in compilations or otherwise redistribute
	it without the express prior consent of its author.

	You MAY freely distribute modified or derivitave versions of this addon,
	provided that the name of your version does not include the name of this
	addon or its author.
----------------------------------------------------------------------]]

if select(2, UnitClass("player")) ~= "HUNTER" then
	return DisableAddOn("CreatureComforts")
end

if not GetLocale():match("^en") and not CreatureComfortsLocale then
	-- no translations for this locale, we can't continue
	return DEFAULT_CHAT_FRAME:AddMessage("|cffff0000WARNING!|r Creature Comforts does not have the translations it needs to work in your locale. To find out how you can help, see the README.TXT file in the addon's folder.")
end

local L = setmetatable(CreatureComfortsLocale or {}, {
	__index = function(t, k)
		if type(k) ~= "string" then
			return ""
		end
		rawset(t, k, k)
		return k
	end
})

local debugstr = "|cFFFF7F7FCreature Comforts:|r "
local function Debug(level, message, ...)
	if level > 0 then return end
	if select(1, ...) then
		message = message:format(...)
	end
	DEFAULT_CHAT_FRAME:AddMessage(debugstr..message)
end

local printstr = "|cFFABD473Creature Comforts:|r "
local function Print(message, ...)
	if select(1, ...) then
		message = message:format(...)
	end
	DEFAULT_CHAT_FRAME:AddMessage(printstr..message)
end

local data = {
	[L["Bread"]] = {
		["Basic"] = {4540,4541,4542,4544,4601,8950,16169,19696,20857,23160,24072,27855,28486,29394,29449,30816,38428},
		["Bonus"] = {2683,3666,17197},
		["Combo"] = {13724,19301,34780},
		["Conjured"] = {1113,1114,1487,5349,8075,8076,22895,22019,34062},
	},
	[L["Cheese"]] = {
		["Basic"] = {2070,414,17406,422,1707,3927,8932,27857,29448,30458},
		["Bonus"] = {3665,12218},
	},
	[L["Fish"]] = {
		["Basic"] = {787,1326,4592,4593,4594,5095,6290,6299,6316,6887,8364,8957,8959,12238,13546,13930,13933,13935,16170,16766,19996,21552,27661,27858,29452,33048,35285},
		["Bonus"] = {5525,5527,5476,6038,12216,13927,13928,13929,13932,13934,16971,21072,21217,27662,27663,27664,27665,27666,27667,30155,33052,33867},
		["Combo"] = {2682,21071,21153,33053},
		["Raw"] 	= {2675,4603,4655,5468,5503,5504,6289,6291,6303,6308,6317,6361,6362,7974,8365,12206,13754,13755,13756,13758,13759,13760,13888,13889,13893,21071,21153,24477,27422,27425,27429,27435,27437,27438,27439,33823,33824},
	},
	[L["Fruit"]] = {
		["Basic"] = {4536,4537,4538,4539,4602,4656,5057,8953,11415,16168,19994,21030,21031,21033,22324,27856,29393,29450},
		["Bonus"] = {11584,11950,13810,20516,24009,32721},
		["Combo"] = {20031,28112},
	},
	[L["Fungus"]] = {
		["Basic"] = {4604,4605,4606,4607,4608,8948,18255,27859,29453,30355},
		["Bonus"] = {18254,24008,24539},
		["Combo"] = {3448},
	},
	[L["Meat"]] = {
		["Basic"] = {117,2287,2679,2681,2685,3770,3771,4599,6890,7097,8952,9681,9681,11444,17119,17407,17408,19223,19224,19304,19305,19306,19995,21235,23495,27854,29451,30610,32685,32686,33254},
		["Bonus"] = {1017,2680,2684,2687,2888,3220,3662,3726,3727,3728,4457,5472,5474,5479,5480,12209,12210,12213,12224,13851,17222,18045,20452,21023,24105,27635,27636,22645,27651,27655,27657,27658,27659,27660,29292,31672,31673,33872,34410,35563,35565},
		["Raw"] = {729,769,1015,1080,1081,2251,2672,2763,2677,2924,3173,3404,3667,3712,3730,3731,5051,5465,5467,5469,5470,5471,12037,12184,12202,12203,12204,12205,12208,12223,20424,21024,22644,23676,24477,27668,27669,27671,27674,27677,27678,27681,27682,31670,31671,35562}
	}
}

local CALL_PET = GetSpellInfo(883)
local DISMISS_PET = GetSpellInfo(2641)
local FEED_PET = GetSpellInfo(6991)
local FEED_PET_EFFECT = GetSpellInfo(1539)
local MEND_PET = GetSpellInfo(136)
local REVIVE_PET = GetSpellInfo(982)

local combat, dead, dirty, debuffed, feeding, happy, improved, mending, pet, wounded, warned
local ids, best, conj, diet = LibStub("tekIDmemo"), {}, {}, {}

CreatureComforts = CreateFrame("Frame")
CreatureComforts.title = GetAddOnMetadata("CreatureComforts", "Title")
CreatureComforts.version = tonumber(string.match(GetAddOnMetadata("CreatureComforts", "Version"), "%d+%.%d+%.%d+%.(.+)")) or 0
CreatureComforts:SetScript("OnEvent", function(self, event, ...) if self[event] then return self[event](self, ...) end end)
CreatureComforts:RegisterEvent("ADDON_LOADED")

function CreatureComforts:ADDON_LOADED(addon)
	if addon ~= "CreatureComforts" then return end
	Debug(1, "ADDON_LOADED")

	local defaults = {
		dismissModifier = "ctrl",
		feedHappy = false,
		mendModifier = "shift",
		mendThreshold = 0.75,
		showFood = true,
		useBonus = false,
		useCombo = false,
		useConjured = true,
		useRaw = false,
	}

	if not CreatureComfortsDB then
		CreatureComfortsDB = defaults
		CreatureComfortsDB.version = self.version
--	elseif CreatureComfortsDB.version ~= self.version then
	else
		local temp = defaults
		for k, v in pairs(CreatureComfortsDB) do
			if defaults[k] then
				temp[k] = v
			end
		end
		temp.version = self.version
		CreatureComfortsDB = temp
	end
	self.db = CreatureComfortsDB
	self.L = L

	self:UnregisterEvent("ADDON_LOADED")
	self.ADDON_LOADED = nil

	if IsLoggedIn() then
		self:PLAYER_LOGIN(true)
	else
		self:RegisterEvent("PLAYER_LOGIN")
	end
end

function CreatureComforts:PLAYER_LOGIN(delayed)
	Debug(1, "PLAYER_LOGIN")

	warned = GetTime()

	self:RegisterEvent("BAG_UPDATE")
	self:RegisterEvent("CHARACTER_POINTS_CHANGED")
	self:RegisterEvent("PLAYER_ALIVE")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_UNGHOST")
	self:RegisterEvent("UI_ERROR_MESSAGE")
	self:RegisterEvent("UNIT_HEALTH")
	self:RegisterEvent("UNIT_PET")
	
	if not InCombatLockdown() then
		self:RegisterEvent("UNIT_AURA")
		self:RegisterEvent("UNIT_HAPPINESS")
	end

	if delayed then
		self:UNIT_PET("player")
		self:BAG_UPDATE()
	end

	self:CHARACTER_POINTS_CHANGED()

	self:UnregisterEvent("PLAYER_LOGIN")
	self.PLAYER_LOGIN = nil
end

function CreatureComforts:BAG_UPDATE()
	Debug(3, "BAG_UPDATE")

	dirty = true
	if not InCombatLockdown() then
		self:Scan()
	end
end

function CreatureComforts:CHARACTER_POINTS_CHANGED()
	Debug(1, "PLAYER_LOGIN")

	improved = select(5, GetTalentInfo(1, 10)) > 0
	Debug(3, improved and "Improved Mend Pet? YES" or "Improved Mend Pet? NO")
end

function CreatureComforts:PLAYER_ALIVE()
	if UnitIsGhost("player") then return end
	Debug(1, "PLAYER_ALIVE")

	self:Edit()
end
CreatureComforts.PLAYER_UNGHOST = CreatureComforts.PLAYER_ALIVE

function CreatureComforts:PLAYER_REGEN_DISABLED()
	Debug(1, "PLAYER_REGEN_DISABLED")

	self:UnregisterEvent("UNIT_AURA")
	self:UnregisterEvent("UNIT_HAPPINESS")

	combat = true
	self:Edit()
end

function CreatureComforts:PLAYER_REGEN_ENABLED()
	Debug(1, "PLAYER_REGEN_ENABLED")

	self:RegisterEvent("UNIT_AURA")
	self:RegisterEvent("UNIT_HAPPINESS")

	combat = false
	self:UNIT_AURA("pet")
	self:UNIT_HAPPINESS("pet")
	self:UNIT_HEALTH("pet")
	self:Edit()
end

function CreatureComforts:UI_ERROR_MESSAGE(message)
	Debug(5, "UI_ERROR_MESSAGE")

	if message == ERR_PET_SPELL_DEAD then
		Debug(1, "Pet dead")
		dead = true
		self:Edit()
	end
end

local i, name
function CreatureComforts:UNIT_AURA(unit)
	if unit ~= "pet" then return end
	Debug(2, "PLAYER_ALIVE")

	local wasFeeding, wasMending
	i, feeding, mending = 1, false, false
	while true do
		name = UnitBuff("pet", i)
		if not name then
			do break end
		elseif name == FEED_PET_EFFECT then
			feeding = i
		elseif name == MEND_PET then
			mending = i
		end
		i = i + 1
	end
	if wasFeeding and not feeding then
		self:UNIT_HAPPINESS("pet")
		self:Edit()
	end
	if wasMending and not mending then
		self:UNIT_HEALTH("pet")
		self:Edit()
	end

	if improved then
		if UnitDebuff("pet", 1, 1) then
			if not debuffed then
				debuffed = true
				self:Edit()
			end
		else
			if debuffed then
				debuffed = false
				self:Edit()
			end
		end
	end
end

function CreatureComforts:UNIT_HAPPINESS(unit)
	if unit ~= "pet" then return end
	Debug(3, "UNIT_HAPPINESS")

	if dead then return end
	if feeding then
		local timeleft = select(6, UnitBuff("pet", feeding))
		if timeleft and timeleft > 2 then return end
	end

	local happiness = GetPetHappiness()
	if not happiness then return end
	if happiness == 1 and GetTime() - warned > 60 then
		Print(L["%s is very hungry!"], UnitName("pet"))
	elseif happiness == 2 and GetTime() - warned > 120 then
		Print(L["%s is hungry."], UnitName("pet"))
	end

	if not happy then
		happy = happiness
		self:Edit()
	elseif happy ~= happiness then
		self:Edit()
	end
end

function CreatureComforts:UNIT_HEALTH(unit)
	if unit ~= "pet" then return end
	Debug(2, "UNIT_HEALTH")

	local hp, maxhp = UnitHealth("pet"), UnitHealthMax("pet")
	if not dead and hp <= 0 then
		Debug(1, "Pet dead")
		dead = true
		self:Edit()
	elseif dead and hp > 0 then
		Debug(1, "Pet alive")
		dead = false
		self:Edit()
	elseif not wounded and hp / maxhp <= self.db.mendThreshold then
		Debug(2, "Pet wounded")
		wounded = true
		self:Edit()
	elseif wounded and hp / maxhp > self.db.mendThreshold then
		Debug(2, "Pet not wounded")
		wounded = false
		self:Edit()
	end
end

function CreatureComforts:UNIT_PET(unit)
	if unit ~= "player" then return end
	Debug(1, "UNIT_PET")

	local family = UnitCreatureFamily("pet")
	if family and select(2, HasPetUI()) then
		Debug(1, "UNIT_PET, exists, "..family)
		if family ~= pet then
			Debug(1, "New pet type %s, previously %s", family, tostring(pet))
			pet = family
			self:Diet()
		else
			local count = 0
			for k in pairs(diet) do
				count = count + 1
			end
			if count == 0 then
				Debug(1, "Missing diet for pet type "..family)
				self:Diet()
			end
		end
		self:UNIT_HEALTH("pet")
		if not InCombatLockdown() then
			self:Scan()
		else
			self:BAG_UPDATE()
		end
	else
		Debug(1, "UNIT_PET, noexists")
		self:Edit()
	end
end

function CreatureComforts:Diet()
	local foods = { GetPetFoodTypes() }
	if #foods == 0 then
		Debug(1, "Diet aborted; GetPetFoodTypes returned nothing!")
		return
	end

	Debug(1, "Updating diet...")

	-- clear previous diet list
	for k, v in pairs(diet) do diet[k] = nil end

	-- fill diet list with edible foods from database
	for i, v in ipairs(foods) do
		Debug(1, "Adding %s...", v)
		local raw = false
		if v == L["Raw Fish"] then
			v = L["Fish"]
			raw = true
		end
		if v == L["Raw Meat"] then
			v = L["Meat"]
			raw = true
		end
		if self.db.useRaw and data[v]["Raw"] then
			Debug(2, "Adding Raw %s...", v)
			for j, id in ipairs(data[v]["Raw"]) do
				diet[id] = true
			end
		end
		if not raw then
			Debug(2, "Adding Basic %s...", v)
			for j, id in ipairs(data[v]["Basic"]) do
				diet[id] = true
			end
			if self.db.useBonus and data[v]["Bonus"] then
				Debug(2, "Adding Bonus %s...", v)
				for j, id in ipairs(data[v]["Bonus"]) do
					diet[id] = true
				end
			end
			if self.db.useCombo and data[v]["Combo"] then
				Debug(2, "Adding Combo %s...", v)
				for j, id in ipairs(data[v]["Bonus"]) do
					diet[id] = true
				end
			end
			if self.db.useConjured then
				if data[v]["Conjured"] then
					Debug(2, "Adding Conjured %s...", v)
					for j, id in ipairs(data[v]["Conjured"]) do
						diet[id] = true
						conj[id] = true
					end
				end
			else
				for id in pairs(conj) do
					conj[id] = nil
				end
			end
		end
	end

	-- add custom foods
	if self.db.includes then
		for i, food in pairs(foods) do
			local extra = self.db.include[food:lower():gsub(" ", "")]
			if extra then
				for j, id in ipairs(extra) do
					if not diet[id] then
						Debug(1, "Adding %s to diet...", GetItemInfo(id) or ("item:"..id))
						diet[id] = true
					end
				end
			end
		end
	end

	-- remove custom excluded foods
	if self.db.excludes then
		for i, id in ipairs(self.db.exclude) do
			if diet[id] then
				Debug(1, "Removing %s from diet...", GetItemInfo(id) or ("item:"..id))
				diet[id] = nil
			end
		end
	end

	Debug(1, "Done updating diet.")
end

local BAGTYPE_AMMO = select(7, GetAuctionItemClasses())
local BAGTYPE_CONTAINER = select(3, GetAuctionItemClasses())
local BAGTYPE_SUBTYPE = select(1, GetAuctionItemSubClasses(3))

local function IsSpecialBag(bag)
	if bag <= 0 then return end
	local link = GetInventoryItemLink("player", ContainerIDToInventoryID(bag))
	if link then
		local type, subtype = select(6, GetItemInfo(link))
		return (type == BAGTYPE_AMMO) or (type == BAGTYPE_CONTAINER and subtype ~= BAGTYPE_SUBTYPE)
	end
end

function CreatureComforts:Scan()
	Debug(3, "Scanning bags...")
	local petlvl = UnitLevel("pet")
	if petlvl and petlvl > 0 then
		if diet == {} then
			self:Diet()
		end
		for k, v in pairs(best) do best[k] = nil end
		for bag = 0, 4 do
			Debug(4, "Scanning bag %d...", bag)
			if bag == 0 or not IsSpecialBag(bag) then
				for slot = 1, GetContainerNumSlots(bag) do
					local link = GetContainerItemLink(bag, slot)
					local id = link and ids[link]
					local name = link and GetItemInfo(link) or "Unknown"
					if link then Debug(5, "Scanning item %s...", name) end
					if id and diet[id] then
						local lvl = select(4, GetItemInfo(link)) or 0
						if lvl < (petlvl - 30) then
							Debug(3, "Removing %s from diet; item level too low.", name)
							diet[id] = nil
						else
							Debug(5, "Considering %s...", name)
							local qty = select(2, GetContainerItemInfo(bag, slot))
							local cat = math.floor(((petlvl - lvl) / 10) + 0.5)
							if cat < 1 then cat = 1 end
							if (not best.id) or (cat < best.cat) or (conj[id]) or (lvl < best.lvl and qty - best.qty <= 5) or (qty < best.qty) then
								Debug(4, "Accepted %s.", name)
								best.id = id; best.lvl = lvl; best.cat = cat; best.qty = qty; best.bag = bag; best.slot = slot
							end
						end
					end
				end
			end
		end
		if not best.id and UnitName("pet") ~= "Unknown" and GetTime() - warned > 240 then
			Print(L["You don't have any food for %s."], UnitName("pet"))
			warned = GetTime()
		end
		self:Edit()
	else
		Debug(3, "Scan aborted; no pet")
	end
end

function CreatureComforts:Edit()
	if InCombatLockdown() then return end
	Debug(1, "Edit")

	local macroID = GetMacroIndexByName("AutoPet")
	if not macroID then
		Debug(2, "Edit aborted; macro not found")
		return
	end

	local body = "#show"
	if UnitAffectingCombat("player") then
		Debug(2, "In combat")
		body = body.."\n/cast [target=pet,dead][nopet,mod:"..self.db.mendModifier.."] "..REVIVE_PET.."; [nopet] "..CALL_PET.."; [mod:"..self.db.dismissModifier.."] "..DISMISS_PET.."; "..MEND_PET
	elseif dead then
		Debug(2, "Pet dead")
		body = body.."\n/cast "..REVIVE_PET
	elseif not pet or not select(2, HasPetUI()) then
		Debug(2, "Pet despawned, assumed alive")
		body = body.."\n/cast [target=pet,dead][mod:"..self.db.mendModifier.."] "..REVIVE_PET.."; "..CALL_PET
	elseif (debuffed and not (improved or mending)) or (wounded and not mending) then
		Debug(2, "Pet wounded or debuffed")
		body = body.."\n/cast [mod:"..self.db.dismissModifier.."] "..DISMISS_PET.."; "..MEND_PET
	else
		Debug(2, "Pet alive")
		local happiness = GetPetHappiness() or 0
		Debug(2, "Feed Happy? %s. Happiness: %d.", self.db.feedHappy and "YES" or "NO", happiness)
		if best.id and self.db.showFood and (happiness < 3 or self.db.feedHappy) then
			body = body.." [mod:"..self.db.dismissModifier.."] "..DISMISS_PET.."; [mod:"..self.db.mendModifier.."] "..MEND_PET.."; item:"..best.id
		end
		body = body.."\n/cast [mod:"..self.db.dismissModifier.."] "..DISMISS_PET.."; [mod:"..self.db.mendModifier.."] "..MEND_PET.."; "..FEED_PET
		if best.bag and best.slot and (happiness < 3 or self.db.feedHappy) then
			body = body.."\n/use [nomod] "..best.bag.." "..best.slot
		end
	end

	EditMacro(macroID, "AutoPet", 1, body, 1, 1)
end