CraftList2 = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "AceHook-2.1")
local L = AceLibrary("AceLocale-2.2"):new("CraftList2")
local G = LibStub:GetLibrary("LibGratuity-3.0")
local waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0")
local abacus = LibStub:GetLibrary("LibAbacus-3.0")
local self=CraftList2
local MINOR_VERSION = tonumber(("$Revision: 76214 $"):match("%d+"))
self.version="2.0 r"..MINOR_VERSION

local prefix_ench = "!enchant"
local prefix_gem = "!gem"
local prefix_other = "!craft"
local prefix_answers = "cL2>"

local mem_search={}
local mem_next={}
local mem_trigger={}

local enchant_localtest=""
local gem_localtest=""
local craft_localtest=""

local enchant_send=""
local gem_send=""
local craft_send=""

local queuedprocesses={}

local function tcount(tab)
	local n=0
	for _ in pairs(tab) do
		n=n+1
	end
	return n
 end

local function Respond(message,sender)
	if not sender then return end
	if message:find("^%s%S+>") then
		ChatThrottleLib:SendChatMessage("NORMAL", prefix_answers, message, "WHISPER", nil, sender)
	else
		ChatThrottleLib:SendChatMessage("NORMAL", prefix_answers, format("%s %s",prefix_answers,message), "WHISPER", nil, sender)
	end
end


local function GetArgs(text, separator)
	local args = {}
	local i = 0
	for value in string.gmatch(text, "[^"..separator.."]+") do
		i = i + 1
		args[i] = value
	end	
	return args
end


local function RecomposeLink(argument)
	local message=argument
	for k,v in pairs(message) do
		if strfind(v,"|cff") then
				if strfind(v,"|h|r") then return message
				else 
					message[k]=v.." "..message[k+1]
					table.remove(message,k+1)
					return RecomposeLink(message)
				end
		end
	end
	return message
end

local function RecomposeQuotedText(argument)
	local message=argument
	for k,v in pairs(message) do
		if string.sub(v,1,1)== "\"" then
				if string.sub(v,string.len(v),string.len(v))=="\"" then return message
				else 
					message[k]=v.." "..message[k+1]
					table.remove(message,k+1)
					return RecomposeQuotedText(message)
				end
		end
	end
	return message
end

local function ScanCraft(craftname)
	if not self.db.realm.data[UnitName("player")] then self.db.realm.data[UnitName("player")] = {} end
	if not self.db.realm.data[UnitName("player")][craftname] then self.db.realm.data[UnitName("player")][craftname] = {} end
	local craftdata = {}
	for i=1,GetNumCrafts() do
		local skillname, craftSubSpellName, skilltype = GetCraftInfo(i)
		if skilltype~="header" and skillname then
			local craftinfo = {}
			--local link = GetCraftItemLink(i)
			local link = GetCraftRecipeLink(i)
			
			local desc = GetCraftDescription(i)
			if desc == nil then desc = "" end
			craftinfo.name=skillname
			craftinfo.link = link
			craftinfo.desc = desc
			for k,v in pairs(self.db.realm.data[UnitName("player")][craftname]) do
				if v.name==skillname then 
					if v.ignored then craftinfo.ignored=true else craftinfo.ignored=false end
					if v.comment and type(v.comment)=="string" then craftinfo.comment=v.comment end
				end
			end
			table.insert(craftdata,craftinfo)
		end	
	end
	
	if #self.db.realm.data[UnitName("player")][craftname] <= #craftdata then
		self.db.realm.data[UnitName("player")][craftname] = craftdata
	end
end

local function ScanTS(tsname)
	if not self.db.realm.data[UnitName("player")] then self.db.realm.data[UnitName("player")] = {} end
	if not self.db.realm.data[UnitName("player")][tsname] then self.db.realm.data[UnitName("player")][tsname] = {} end
	local tsdata = {}
	for i=1,GetNumTradeSkills() do
		local skillname, skilltype, numAvailable, isExpanded = GetTradeSkillInfo(i)
		if skilltype ~= "header" then
			local tsinfo = {}
			local itemlink = GetTradeSkillItemLink(i)
			local recipelink = GetTradeSkillRecipeLink(i)
			local reg = {}
			local timer=GetTradeSkillCooldown(i)
			for j=1,GetTradeSkillNumReagents(i) do
				table.insert(reg,GetTradeSkillReagentItemLink(i,j))
			end
			tsinfo.name=skillname
			tsinfo.itemlink = itemlink
			tsinfo.recipelink = recipelink
			tsinfo.reg= reg
			if timer then tsinfo.timer = time() + timer end
			for k,v in pairs(self.db.realm.data[UnitName("player")][tsname]) do
				if v.name==skillname then 
					if v.ignored then tsinfo.ignored=true else tsinfo.ignored=false end
					if v.comment and type(v.comment)=="string" then tsinfo.comment=v.comment end
				end
			end
			if skillname then table.insert(tsdata,tsinfo) end
		end	
	end
		
	local temp={}
	for n,_ in pairs(tsdata) do table.insert(temp,n) end
	table.sort(temp, function(a,b)
		if tsdata[a]==nil then return false end
		if tsdata[b]==nil then return true end
		if tsdata[a].itemlink==nil then return false end
		if tsdata[b].itemlink==nil then return true end
		local rarity_a=select(3,GetItemInfo(tsdata[a].itemlink))
		local rarity_b=select(3,GetItemInfo(tsdata[b].itemlink))
		if rarity_a==nil then return false end
		if rarity_b==nil then return true end
		return (rarity_a > rarity_b)
	end
	)
	local temp2={}
	for i,n in ipairs(temp) do 
		table.insert(temp2,i,tsdata[n])
	end
	tsdata=temp2
	if #self.db.realm.data[UnitName("player")][tsname] <= #tsdata then
		self.db.realm.data[UnitName("player")][tsname] = tsdata
	end
end

function CraftList2:CRAFT_SHOW()
	local craftname= GetCraftName()
	ScanCraft(craftname)
end

function CraftList2:TRADE_SKILL_SHOW()
	local tsname= GetTradeSkillLine()
	ScanTS(tsname)
end

local function TableToString(table)
	if #table==0 then return end
	local result=table[1]
	if #table > 1 then
		for i=2,#table do
			result=result.." "..table[i]
		end
	end
	return result
end

local function SendResults(searchresult,sender,source)
	if not searchresult then return end
	if #searchresult == 0 and source=="whisper" then 
		Respond(L["Nothing found."],sender) 
		if self.db.realm.summary then self:Print((L["Summary: %s result(s) for \"%s\" from %s"]):format(#searchresult,mem_trigger[sender].." "..TableToString(mem_search[sender]),sender)) end
		return 
	end
	
	if source=="guild" and self.db.realm.shortguild and #searchresult>2 then
		local charstrings=0
		for i=1,#searchresult do
			if string.sub(searchresult[i],1,string.len(L["Results for "]))==L["Results for "] then charstrings=charstrings+1 end
		end
		Respond((L["%d result(s)."]):format(#searchresult-charstrings).." "..L["Whisper me the same command to get the actual results."] ,sender)
		if self.db.realm.summary then self:Print((L["Summary: %s result(s) for \"%s\" from %s"]):format((#searchresult-charstrings),mem_trigger[sender].." "..TableToString(mem_search[sender]),sender)) end
	
	else
		if mem_next[sender] and mem_next[sender] > 0 then 
			for i=1,mem_next[sender] do
				table.remove(searchresult,1)
			end
		end
		
		local max = self.db.realm.maxresults
		local endstring
		if #searchresult < max  or max == 0 then 
			max = #searchresult 
			local charstrings=0
			for i=1,max do
				if string.sub(searchresult[i],1,string.len(L["Results for "]))==L["Results for "] then charstrings=charstrings+1 end
			end
			if source=="whisper" then
				endstring=(L["%d result(s)."]):format(#searchresult - charstrings)
			end
		else
			endstring=(L["Maximum results exceeded, be more specific or use '%s next' to get next results (%d result(s) remaining)."]):format(mem_trigger[sender],#searchresult-max)
		end

		for i=1,max do
			Respond(searchresult[i],sender)
		end
		if endstring then
			Respond(endstring,sender)
		end
		if self.db.realm.summary and mem_next[sender]==0 then 
			local charstrings=0
			for i=1,max do
				if string.sub(searchresult[i],1,string.len(L["Results for "]))==L["Results for "] then charstrings=charstrings+1 end
			end
			self:Print((L["Summary: %s result(s) for \"%s\" from %s"]):format((#searchresult-charstrings),mem_trigger[sender].." "..TableToString(mem_search[sender]),sender)) 
		end
	end
end


-- Tooltip scanner with garbage collectable cache
local emptytable = {}
local ToolTips = {}
local ToolTips_mt = {
	__mode = "v",
	__index = function(t,k)
		if not k then return emptytable end
		G:SetHyperlink(k)
		if G:NumLines()<1 then
			t[k] = emptytable
			return emptytable
		end
		local tt = {}
		t[k] = tt
		for l=1,G:NumLines() do
			local pouet=G:GetLine(l,true)
			if pouet then tt[l] = string.lower(G:GetLine(l)).." "..string.lower(pouet)
			else tt[l] = string.lower(G:GetLine(l))
			end
		end
		return tt
	end
}
setmetatable(ToolTips, ToolTips_mt)


local function HandleEnchant(argum,sender,source)
	if #argum == 0 then 
		if source=="whisper" then
			Respond(L["Usage: !enchant <any combination of keywords and itemlinks>"],sender) 
			Respond(L["Usage: example: !enchant [Ashbringer] 35 heal"],sender)
		end
		return 
	end

	-- replace an itemlink with the piece of armor 
	for k,v in pairs(argum) do
		if strfind(argum[k],"|cff") and strfind(argum[k],"|h|r") then
			local sName, sLink, iRarity, iLevel, iMinLevel, sType, sSubType, iStackCount, iel = GetItemInfo(argum[k])
			if sType == L["Armor"] then 
				local b=0
				if iel=="INVTYPE_CHEST" then b=L["Chest"]
				elseif iel=="INVTYPE_ROBE" then b=L["Chest"]
				elseif iel=="INVTYPE_FEET" then b=L["Boots"]
				elseif iel=="INVTYPE_WRIST" then b=L["Bracer"]
				elseif iel=="INVTYPE_HAND" then b=L["Gloves"]
				elseif iel=="INVTYPE_CLOAK" then b=L["Cloak"]
				elseif iel=="INVTYPE_SHIELD" then b=L["Shield"]
				elseif iel=="INVTYPE_FINGER" then b=L["Ring"]
				else Respond(L["Error! Cannot enchant that."],sender) return end
				argum[k]=b
			elseif sType==L["Weapon"] then 
				local b=0
				if iel=="INVTYPE_2HWEAPON" then b=L["Weapon"]
				elseif iel=="INVTYPE_WEAPONMAINHAND" then b=L["Enchant Weapon"]
				elseif iel=="INVTYPE_WEAPONOFFHAND" then b=L["Enchant Weapon"]
				elseif iel=="INVTYPE_WEAPON" then b=L["Enchant Weapon"]
				else Respond(L["Error! Cannot enchant that."],sender) return end
				argum[k]=b
			end
		end
	end
	-- done replacing
	
	-- building the results
	local searchresult={}
	if self.db.realm.data=={} then Respond(L["Database is currently empty."],sender) return end
	
	for character, tradeskill in pairs(self.db.realm.data) do
		if ( not self.db.realm.currentcharonly ) or ( self.db.realm.currentcharonly and character==UnitName("player")  ) then
			if source=="whisper" then
				table.insert(searchresult,L["Results for "]..character..":")
			end
			if not self.db.realm.ignored_crafts[character] then self.db.realm.ignored_crafts[character] = {} end
			if tradeskill[GetSpellInfo(7411)] and not self.db.realm.ignored_crafts[character][GetSpellInfo(7411)] then
				for nb,info in pairs(tradeskill[GetSpellInfo(7411)]) do
					local match=0
					local enchantname=string.lower(info.name)
					local enchantdesc=string.lower(info.desc)
					for j=1,#argum do
						local negflag=false
						local word=argum[j]
						if string.sub(word,1,1) =="~" or string.sub(word,1,1) =="!" or string.sub(word,1,1) =="-" then 
							negflag=true 
							word = string.sub(word,2)
						end
						
						if strfind(enchantname, string.lower(word),1,true) then if negflag then match = match - 1 else match=match+1 end
						elseif strfind(enchantdesc, string.lower(word),1,true) then if negflag then match = match - 1 else match=match+1 end
						elseif negflag then match = match + 1
						end
					end 
					local cooldownstring=""
					local time=time()
					if info.timer and ( info.timer-time >= 0 ) then cooldownstring= " " .. abacus:FormatDurationExtended(info.timer-time,false,true) end
					local commentstring=""
					if info.comment then commentstring= " " .. info.comment end
					if match==#argum and not info.ignored then table.insert(searchresult," "..character.."> "..(info.link or "")..cooldownstring..commentstring) end	
				end	
			end
			if searchresult[#searchresult]==L["Results for "]..character..":" then table.remove(searchresult,#searchresult) end
		end
	end
	return searchresult
end

local function HandleGem(argum,sender,source)
	if #argum == 0 then 
		if source=="whisper" then
			Respond(L["Usage: !gem <any combination of color/stat/reagent/text>"],sender) 
			Respond(L["Usage: example: !gem red, !gem [Talasite], !gem 5 strength"],sender)
		end
		return 
	end
	
	local searchresult={}
	if self.db.realm.data=={} then Respond(L["Database is currently empty."],sender) return end
	
	
	for k,v in pairs(argum) do
		if strfind(argum[k],"|cff") and strfind(argum[k],"|h|r") then
			local sName, sLink, iRarity, iLevel, iMinLevel, sType, sSubType, iStackCount, iel = GetItemInfo(argum[k])
			argum[k] = sName
		elseif argum[k]== L["orange"] then 
			argum[k]=L["red"]
			table.insert(argum,L["yellow"])
		elseif argum[k]== L["purple"] then 
			argum[k]=L["red"]
			table.insert(argum,L["blue"])
		elseif argum[k]== L["green"] then 
			argum[k]=L["yellow"]
			table.insert(argum,L["blue"])
		end
	end


	for character, tradeskill in pairs(self.db.realm.data) do
		if ( not self.db.realm.currentcharonly ) or ( self.db.realm.currentcharonly and character==UnitName("player")  ) then
			if source=="whisper" then
				table.insert(searchresult,L["Results for "]..character..":")
			end
			if not self.db.realm.ignored_crafts[character] then self.db.realm.ignored_crafts[character] = {} end
			if tradeskill[GetSpellInfo(25229)] and not self.db.realm.ignored_crafts[character][GetSpellInfo(25229)] then
				for nb,info in pairs(tradeskill[GetSpellInfo(25229)]) do
					if info.itemlink then
						local sName, sLink, iRarity, iLevel, iMinLevel, sType, sSubType, iStackCount, iel = GetItemInfo(info.itemlink)
						if sType== L["Gem"] then
							local match=0
							local gemname=string.lower(info.name)
							G:SetHyperlink(info.itemlink)
							local gemdesc=string.lower(G:GetLine(2))
							local gemcolor=string.lower(G:GetLine(G:NumLines()) )
							local gemrarity
							
							if iRarity==0 then gemrarity = string.lower(L["Poor"])
							elseif iRarity==1 then gemrarity=string.lower(L["Common"])
							elseif iRarity==2 then gemrarity=string.lower(L["Uncommon"])
							elseif iRarity==3 then gemrarity=string.lower(L["Rare"])
							elseif iRarity==4 then gemrarity=string.lower(L["Epic"])
							elseif iRarity==5 then gemrarity=string.lower(L["Legendary"])
							end
							
							local reg = info.reg
							for j=1,#argum do
							
								local negflag=false
								local word=argum[j]
								if string.sub(word,1,1) =="~" or string.sub(word,1,1) =="!" or string.sub(word,1,1) =="-" then 
									negflag=true 
									word = string.sub(word,2)
								end
							
								if strfind(gemname, string.lower(word),1,true) then if negflag then match = match - 1 else match=match+1 end
								elseif strfind(gemdesc, string.lower(word),1,true) and word~="red" then if negflag then match = match - 1 else match=match+1 end
								elseif strfind(gemcolor,string.lower(word),1,true) then if negflag then match = match - 1 else match=match+1 end
								elseif gemrarity and strfind(gemrarity,string.lower(word),1,true) then if negflag then match = match - 1 else match=match+1 end
								else 
									local matchfor=false
									for k,v in pairs(reg) do
										if strfind(v,word,1,true) then matchfor=true end
									end
									if matchfor then if negflag then match = match - 1 else match=match+1 end
									elseif negflag then match = match+1
									end
								end
							end 
							local cooldownstring=""
							local time=time()
							if info.timer and ( info.timer-time >= 0 ) then cooldownstring= " " .. abacus:FormatDurationExtended(info.timer-time,false,true) end
							local commentstring=""
							if info.comment then commentstring= " " .. info.comment end
							if match==#argum and not info.ignored then table.insert(searchresult," "..character.."> "..(info.itemlink or "")..cooldownstring..commentstring) end	
						end
					end
				end	
			end
			if searchresult[#searchresult]==L["Results for "]..character..":" then table.remove(searchresult,#searchresult) end
		end
	end

	return searchresult
end

local function HandleCraft(argum,sender,source)
	if #argum == 0 then 
		if source=="whisper" then
			Respond(L["Usage: !craft <any combination of reagent/text>"],sender) 
			Respond(L["Usage: example: !craft belt of blasting, !craft belt [Primal Fire]"], sender)
		end
		return 
	end
	
	local searchresult={}
	if self.db.realm.data=={} then Respond(L["Database is currently empty."],sender) return end
	
	local negs = {}
	for k,v in pairs(argum) do
		local tmp = string.match(v, "^[~!-](.*)")
		if tmp then 
			v = tmp
			negs[k] = true
		end
		if strfind(v,"|cff") and strfind(v,"|h|r") then
			local sName, sLink, iRarity, iLevel, iMinLevel, sType, sSubType, iStackCount, iel = GetItemInfo(v)
			if sName then argum[k] = string.lower(sName) end
		else
			argum[k] = string.lower(v)
		end
	end

	local tiplines = {}
	
	for character, tradeskill in pairs(self.db.realm.data) do
		if ( not self.db.realm.currentcharonly ) or ( self.db.realm.currentcharonly and character==UnitName("player")  ) then
			if source=="whisper" then
				table.insert(searchresult,L["Results for "]..character..":")
			end
			if not self.db.realm.ignored_crafts[character] then self.db.realm.ignored_crafts[character] = {} end
			for ts,tsinfo in pairs(tradeskill) do
				if not self.db.realm.ignored_crafts[character][ts] then
					for nb,info in pairs(tsinfo) do
						if info and info.name and not info.ignored then
							local allmatched=true
							local craftname=string.lower(info.name)
							local reg = info.reg
							
							for j=1,#argum do
								local word=argum[j]
								
								local match = strfind(craftname, word,1,true)
								
								for k,v in ipairs(ToolTips[info.itemlink]) do
									match = match or strfind(v, word,1,true)
								end
									
								if reg then
									for k,v in pairs(reg) do
										match = match or string.find(string.lower(v),word,1,true)
									end
								end
								
								if (negs[j] and match) or (not match) then
									allmatched = false
									break;
								end
							end 
							if allmatched then 
								local cooldownstring=""
								if info.timer and info.timer-time()>=0 then cooldownstring= " " .. abacus:FormatDurationExtended(info.timer-time(),false,true) end
								local commentstring=""
								if info.comment then commentstring= " " .. info.comment end
								table.insert(searchresult," "..character.."> "..(info.recipelink or info.link or "")..cooldownstring..commentstring) 
							end	
						end
					end
				end
			end
			if searchresult[#searchresult]==L["Results for "]..character..":" then table.remove(searchresult,#searchresult) end
		end
	end

	return searchresult
end


local function QueueProcess(arg1,arg2,arg6,source)
	local t={}
	t.arg1=arg1
	t.arg2=arg2
	t.arg6=arg6
	t.source=source
	table.insert(queuedprocesses,t)
end


local function QueryProcess(arg1,arg2,arg6,source)
	local argum = GetArgs(arg1," ")
	local sender = arg2
	local firstword = argum[1]
	table.remove(argum,1)
	argum=RecomposeLink(argum)

	local handler
	
	
	if firstword == prefix_ench and self.db.realm.trigger_ench then handler=HandleEnchant
	elseif firstword == prefix_gem and self.db.realm.trigger_gem then handler=HandleGem
	elseif firstword == prefix_other and self.db.realm.trigger_other then handler=HandleCraft
	end
	
	if not handler then return end
	
	if InCombatLockdown() and self.db.realm.combat then 
		Respond(L["In combat, queued, please wait ..."],arg2)
		QueueProcess(arg1,arg2,arg6,source)
		return
	end
	
	if not argum[1] and source~="whisper" then return; end  -- suppress usage message on public queries
	
	argum=RecomposeQuotedText(argum)
	
	for k,v in pairs(argum) do
		if string.sub(v,string.len(v),string.len(v))=="\"" and string.sub(v,1,1)=="\"" then argum[k]=string.gsub(v,"\"","") end
	end
	
	mem_trigger[sender] = firstword
	if argum[1] and argum[1]=="next" then
		if mem_search[sender]==nil then return end
		mem_next[sender]=mem_next[sender]+self.db.realm.maxresults
		argum=mem_search[sender]
	else
		mem_search[sender]=argum
		mem_next[sender]=0
	end

	if arg6==L["AFK"] or arg6==L["DND"] then 
		self.filterafkdnd[sender] = true 
		self:ScheduleEvent(function() self.filterafkdnd[sender] = false return end, 1)
	end
	
	SendResults(handler(argum,sender,source),sender,source)
end

function CraftList2:CHAT_MSG_GUILD()
	if self.db.realm.guildactive then 
		QueryProcess(arg1,arg2,arg6,"guild")
	end
end
function CraftList2:CHAT_MSG_WHISPER()
	if self.db.realm.whispactive then 
		QueryProcess(arg1,arg2,arg6,"whisper") 
	end
end

function CraftList2:PLAYER_REGEN_ENABLED()
	if #queuedprocesses ==0 then return end
	for k,v in pairs(queuedprocesses) do
		QueryProcess(v.arg1,v.arg2,v.arg6,v.source)
	end
	queuedprocesses={}
end



function CraftList2:OnInitialize()
	CraftList2:RegisterDB("CraftList2DB")
	CraftList2:RegisterDefaults("realm", {
		data = {},
		ignored_crafts={},
		maxresults=10,
		showrequests=true,
		showanswers=true,
		trigger_ench=true,
		trigger_gem=true,
		trigger_other=true,
		guildactive=true,
		whispactive=true,
		shortguild=true,
		currentcharonly=false,
		summary=true,
		combat=true,
		}
	)  
end
local function BuildOpts()
	local cl2opt={
		type="group",
		name="CraftList2",
		desc="CraftList2",
		args = {
			inc= {
				type="toggle",
				name=L["Show incoming requests"],
				desc=L["Show incoming requests"],
				get=function() return self.db.realm.showrequests end,
				set=function(v) self.db.realm.showrequests = v end,
				order=2,
			},
			out= {
				type="toggle",
				name=L["Show your replies"],
				desc=L["Show your replies"],
				get=function() return self.db.realm.showanswers end,
				set=function(v) self.db.realm.showanswers = v end,
				order=3,
			},
			summary= {
				type="toggle",
				name=L["Summary"],
				desc=L["Print a summary locally after a query"],
				get=function() return self.db.realm.summary end,
				set=function(v) self.db.realm.summary = v end,
				order=4,
			},
			maxresults= {
				type="range",
				name=L["Maximum results"],
				desc=L["Maximum of results sent to someone (0=no limit)"],
				get=function() return self.db.realm.maxresults end,
				set=function(v) self.db.realm.maxresults = v end,
				min=0,
				max=100,
				step=1,
				order=1,
			},
			guildchat= {
				type="toggle",
				name=L["Monitor Guildchat"],
				desc=L["Monitor Guildchat (results are whispered back)"],
				get=function() return self.db.realm.guildactive end,
				set=function(v) self.db.realm.guildactive = v end,
				order=5,
			},
			whispers= {
				type="toggle",
				name=L["Monitor Whispers"],
				desc=L["Monitor Whispers (results are whispered back)"],
				get=function() return self.db.realm.whispactive end,
				set=function(v) self.db.realm.whispactive = v end,
				order=5,
			},
			shortguild= {
				type="toggle",
				name=L["Short Guildchat answer"],
				desc=L["Only whispers # of results instead of the actual results when queried on guildchat"],
				disabled=function() return not self.db.realm.guildactive end,
				get=function() return self.db.realm.shortguild end,
				set=function(v) self.db.realm.shortguild = v end,
				order=6,
			},
			reset={
				type="execute",
				name=L["Reset all data"],
				desc=L["Reset all stored data for all characters"],
				order=7,
				confirm=true,
				func=function() 
					self.db.realm.data={}
					self.db.realm.ignored_crafts={}
					waterfall:Close('CraftList2')
					return
					end,
			},
			limit={
				type="toggle",
				name=L["Only current character"],
				desc=L["Limit search to the connected character's known crafts"],
				get=function() return self.db.realm.currentcharonly end,
				set=function(v) self.db.realm.currentcharonly = v end,
				order=8,
			},
			combat={
				type="toggle",
				name=L["Queue while in combat"],
				desc=L["Process queries when exiting combat mode"],
				get=function() return self.db.realm.combat end,
				set=function(v) self.db.realm.combat = v end,
				order=9,
			},
			localtest={
				type="group",
				name=L["Local Test"],
				desc=L["Print locally results of a query"],
				order=4,
				args=	{
					ench={
						type="text",
						name=prefix_ench,
						desc=(L["Arguments for %s"]):format(prefix_ench),
						order=1,
						get=function() return enchant_localtest end,
						set=function(v) 
							if v and v ~= "" then
								enchant_localtest=v
								local argum = GetArgs(v," ")
								local result=HandleEnchant(argum,nil)
								self:Print((L["Local test for %s"]):format(v))
								if #result==0 then self:Print(L["Nothing found."])
								else
									for i=1,#result or self.db.realm.maxresults do
										self:Print(result[i])
									end
								end
							end
						end,
					},
					gem={
						type="text",
						name=prefix_gem,
						desc=(L["Arguments for %s"]):format(prefix_gem),
						order=2,
						get=function() return gem_localtest end,
						set=function(v) 
							if v and v ~= "" then
								gem_localtest=v
								local argum = GetArgs(v," ")
								local result=HandleGem(argum,nil)
								self:Print((L["Local test for %s"]):format(v))
								if #result==0 then self:Print(L["Nothing found."])
								else
									for i=1,#result or self.db.realm.maxresults do
										self:Print(result[i])
									end
								end
							end
						end,
					},
					craft={
						type="text",
						name=prefix_other,
						desc=(L["Arguments for %s"]):format(prefix_other),
						order=3,
						get=function() return craft_localtest end,
						set=function(v) 
							if v and v ~= "" then
								craft_localtest=v
								local argum = GetArgs(v," ")
								local result=HandleCraft(argum,nil)
								self:Print((L["Local test for %s"]):format(v))
								if #result==0  then self:Print(L["Nothing found."])
								else
									for i=1,#result or self.db.realm.maxresults do
										self:Print(result[i])
									end
								end
							end
						end,
					},
				},
			},
			send={
				type="group",
				name=L["Send"],
				desc=L["Send a list to a player"],
				order=4,
				args={
					enchant={
						name=prefix_ench,
						type="text",
						order=3,
						desc=L["playername query"],
						get=function() return enchant_send end,
						set=function(v) 
							enchant_send=v
							local argum = GetArgs(v, " ")
							sender=argum[1]
							table.remove(argum,1)
							local args=""
							for k,v in pairs(argum) do
								args=args.." "..v
							end
							mem_search[sender]=argum
							mem_next[sender]=0
							QueryProcess(prefix_ench.." "..args,sender,nil,"whisper")
							end				
					},
					gem={
						name=prefix_gem,
						type="text",
						order=4,
						desc=L["playername query"],
						get=function() return gem_send end,
						set=function(v) 
							gem_send=v
							local argum = GetArgs(v, " ")
							sender=argum[1]
							table.remove(argum,1)
							local args=""
							for k,v in pairs(argum) do
								args=args.." "..v
							end
							mem_search[sender]=argum
							mem_next[sender]=0
							QueryProcess(prefix_gem.." "..args,sender,nil,"whisper")
							end		
					},
					craft={
						name=prefix_other,
						type="text",
						order=5,
						desc=L["playername query"],
						get=function() return craft_send end,
						set=function(v) 
							craft_send=v
							local argum = GetArgs(v, " ")
							sender=argum[1]
							table.remove(argum,1)
							local args=""
							for k,v in pairs(argum) do
								args=args.." "..v
							end
							mem_search[sender]=argum
							mem_next[sender]=0
							QueryProcess(prefix_other.." "..args,sender,nil,"whisper")
							end	
					},
				},
			},
			triggers={
				type="group",
				name=L["Triggers"],
				desc=L["Triggers"],
				order=5,
				args={ 
					ench={
						type="toggle",
						name=prefix_ench,
						desc=prefix_ench,
						get=function()
							return self.db.realm.trigger_ench
							end,
						set=function(v)
							self.db.realm.trigger_ench = not self.db.realm.trigger_ench 
							end,
					},
					gem={
						type="toggle",
						name=prefix_gem,
						desc=prefix_gem,
						get=function()
							return self.db.realm.trigger_gem
							end,
						set=function(v)
							self.db.realm.trigger_gem = not self.db.realm.trigger_gem 
							end,
					},
					other={
						type="toggle",
						name=prefix_other,
						desc=prefix_other,
						get=function()
							return self.db.realm.trigger_other
							end,
						set=function(v)
							self.db.realm.trigger_other = not self.db.realm.trigger_other 
							end,
					},
				},
			},
			active= {
				type="group",
				name=L["Active Professions"],
				desc=L["Check here what professions you want to track"],
				args = {},
				order=6,
			},
			ignored = {
				type="group",
				name=L["Active Crafts"],
				desc=L["Uncheck here crafts you want to be ignored"],
				args = {},
				order=7,
			},
			comments = {
				type="group",
				name=L["Comments"],
				desc=L["Add a comment for a craft"],
				args = {},
				order=8,
			}
		}
	}
	
	local j=1
	local k=1
	for character, tradeskill in pairs(self.db.realm.data) do
		cl2opt.args.ignored.args[j] = 
			{
				type="group",
				name=character,
				desc=character,
				args={},
			}
		cl2opt.args.comments.args[j] = 
			{
				type="group",
				name=character,
				desc=character,
				args={},
			}
		local l=1
		for ts,tsinfo in pairs(tradeskill) do
			cl2opt.args.active.args[k] = 
			{
				type="toggle",
				name=character.." - "..ts,
				desc=character.." - "..ts,
				get=function() 
					if not self.db.realm.ignored_crafts[character] then self.db.realm.ignored_crafts[character] = {} end
					return not self.db.realm.ignored_crafts[character][ts] 
					end,
				set=function(v) 
					if not self.db.realm.ignored_crafts[character] then self.db.realm.ignored_crafts[character] = {} end
					self.db.realm.ignored_crafts[character][ts] = not self.db.realm.ignored_crafts[character][ts] 
					end,
			}
			k=k+1
			cl2opt.args.ignored.args[j].args[l] = 
				{
					type="group",
					name=ts,
					desc=ts,
					args={},
					disabled=function() 
					if not self.db.realm.ignored_crafts[character] then self.db.realm.ignored_crafts[character] = {} end
					return self.db.realm.ignored_crafts[character][ts] 
					end,
				}
			cl2opt.args.comments.args[j].args[l] = 
				{
					type="group",
					name=ts,
					desc=ts,
					args={},
					disabled=function() 
					if not self.db.realm.ignored_crafts[character] then self.db.realm.ignored_crafts[character] = {} end
					return self.db.realm.ignored_crafts[character][ts] 
					end,
				}
	
			cl2opt.args.ignored.args[j].args[l].args[1] = 
			{
				type="execute",
				name=L["Check all"],
				desc=L["Check all"],
				order=1,
				func=function() 
					for nb,info in pairs(tsinfo) do
						info.ignored=false
					end
				end,
			}
			cl2opt.args.ignored.args[j].args[l].args[2] = 
			{
				type="execute",
				name=L["Uncheck all"],
				desc=L["Uncheck all"],
				order=2,
				func=function() 
					for nb,info in pairs(tsinfo) do
						info.ignored=true
					end
				end,
			} 
			cl2opt.args.ignored.args[j].args[l].args[3] = 
			{
				type="execute",
				name=L["Delete profession"],
				desc=L["Delete this profession from the CraftList2 database"],
				order=3,
				confirm=true,
				func=function() 
					self.db.realm.data[character][ts]=nil
					waterfall:Close('CraftList2')
				end,
			} 
			local m=4
			local m2=1
			for nb,info in pairs(tsinfo) do
				local desc = info.desc
				if not desc and info.itemlink then 
					desc=G:GetLine(1)
					if desc then
						G:SetHyperlink(info.itemlink)
						for i=2,G:NumLines() do
							local pouet=G:GetLine(i,true)
							if pouet then desc=desc.."\n"..G:GetLine(i).." "..pouet
							else desc=desc.."\n"..G:GetLine(i)
							end
						end
					else desc=""
					end
				end
				local t=0
				local t2=0
				cl2opt.args.ignored.args[j].args[l+t].args[m] = 
				{
					type="toggle",
					name=info.name,
					desc= desc,
					order=4,
					get=function()
						return not info.ignored end,
					set=function(v)
						info.ignored = not info.ignored
						end,
				}
				cl2opt.args.comments.args[j].args[l+t2].args[m2] = 
				{
					type="text",
					name=info.name,
					desc=desc,
					order=4,
					get=function()
						return info.comment end,
					set=function(v)
						info.comment = v
						end,
				}
				m=m+1
				m2=m2+1
			end
			l=l+1
			if doublecat then l=l+1 end
		end
		j=j+1
	end
	return cl2opt
end

local function filter_whisper(arg1)
	if (not self.db.realm.showrequests) then
		if (string.sub(arg1,1,string.len(prefix_ench))==prefix_ench and not self.db.realm.showrequests and self.db.realm.trigger_ench) then return true end
		if (string.sub(arg1,1,string.len(prefix_gem))==prefix_gem and not self.db.realm.showrequests and self.db.realm.trigger_gem) then return true end
		if (string.sub(arg1,1,string.len(prefix_other))==prefix_other and not self.db.realm.showrequests and self.db.realm.trigger_other) then return true end
	end
	return false, nil
end

local function filter_whisper_inform(arg1)
	if (not self.db.realm.showanswers) then
		if (string.sub(arg1,1,string.len(prefix_answers))==prefix_answers and not self.db.realm.showanswers) then return true end
		for char, _ in pairs(self.db.realm.data) do
			if (string.sub(arg1,2,string.len(char)+1)==char and not self.db.realm.showanswers) then return true end
		end
	end
	return false, nil
end

function CraftList2:OnEnable()
	ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER", filter_whisper)
	ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER_INFORM", filter_whisper_inform)
	self:RegisterEvent("CHAT_MSG_WHISPER")
	self:RegisterEvent("CRAFT_SHOW")
	self:RegisterEvent("TRADE_SKILL_SHOW")
	self:RegisterEvent("CHAT_MSG_GUILD")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:Hook("ChatFrame_OnEvent", function()
		local author = arg2
			if ( event == "CHAT_MSG_AFK" or event == "CHAT_MSG_DND") then
				if self.filterafkdnd[author] then return end
			end
		return self.hooks["ChatFrame_OnEvent"](event)
		end, 
		true)
	self.filterafkdnd={}
	
	local options={
		type="group",
		args = {
			menu={
				name=L["Menu"],
				desc=L["Menu"],
				type ='execute',
				order=1,
				func = function()
					if not waterfall then self:Print("Requires Waterfall-1.0") return end
					if waterfall:IsRegistered('CraftList2') then waterfall:UnRegister('CraftList2') end
					waterfall:Register('CraftList2', 
						'aceOptions',BuildOpts(),
						'title','CraftList2',
						'colorR',0.1,
						'colorG',0.1,
						'colorB',0.9,
						'controlLimit',5000
					)
					waterfall:Open('CraftList2')
					end
			},
			header={
				name=L["Send a list to a player"],
				type="header",
				order=2,
			},
			enchant={
				name=prefix_ench,
				desc=L["Send a list to a player"],
				type="text",
				order=3,
				usage=L["playername query"],
				get=false,
				set=function(v) 
					local argum = GetArgs(v, " ")
					sender=argum[1]
					table.remove(argum,1)
					local args=""
					for k,v in pairs(argum) do
						args=args.." "..v
					end
					mem_search[sender]=argum
					mem_next[sender]=0
					QueryProcess(prefix_ench.." "..args,sender,nil,"whisper")
					end				
			},
			gem={
				name=prefix_gem,
				desc=L["Send a list to a player"],
				type="text",
				order=4,
				usage=L["playername query"],
				get=false,
				set=function(v) 
					local argum = GetArgs(v, " ")
					sender=argum[1]
					table.remove(argum,1)
					local args=""
					for k,v in pairs(argum) do
						args=args.." "..v
					end
					mem_search[sender]=argum
					mem_next[sender]=0
					QueryProcess(prefix_gem.." "..args,sender,nil,"whisper")
					end		
			},
			craft={
				name=prefix_other,
				desc=L["Send a list to a player"],
				type="text",
				order=5,
				usage=L["playername query"],
				get=false,
				set=function(v) 
					local argum = GetArgs(v, " ")
					sender=argum[1]
					table.remove(argum,1)
					local args=""
					for k,v in pairs(argum) do
						args=args.." "..v
					end
					mem_search[sender]=argum
					mem_next[sender]=0
					QueryProcess(prefix_other.." "..args,sender,nil,"whisper")
					end	
			},
		},
	}
	
	self:RegisterChatCommand('/clist', '/craftlist', '/clist2', '/craftlist2', options)
end

function CraftList2:OnDisable()
	ChatFrame_RemoveMessageEventFilter("CHAT_MSG_WHISPER", filter_whisper)
	ChatFrame_RemoveMessageEventFilter("CHAT_MSG_WHISPER_INFORM", filter_whisper_inform)
	self:UnregisterEvent("CHAT_MSG_WHISPER")
	self:UnregisterEvent("CRAFT_SHOW")
	self:UnregisterEvent("TRADE_SKILL_SHOW")
	self:UnregisterEvent("CHAT_MSG_GUILD")
	self:UnregisterEvent("PLAYER_REGEN_ENABLED")
	self:UnhookAll()
end
