﻿local PLAYER,REALM,XREALM = 1,2,3
local FACTION,FACTIONLESS = true,false
local WELCOME,HELP,HELP_MAT,HELP_NOK,HELP_TOO_MANY = 1,2,3,4,5
local DEFAULT_LANGUAGE = GetDefaultLanguage("player")
local WHISPER_EXPIRY_TIME = 60
local MIN_LEVEL, MAX_LEVEL, DIFF_LEVEL = 0, 70, 5

local isWIM = false
local isOnlyBot = true
local isDebug = false
local isScanning = true
local ORG_ChatFrame_Hook = nil
local outgoingWhispers = {}
local defaultItem = "Mooncloth"
local defaultReagent = "Felcloth"
local professionsTitle = ""
local currPlayerIndex = 0
local clipBoardText = ""
local selectedDDMIndex = 0

CraftBot_On = true
CraftBot_Search_Mode = REALM
CraftBot_Search_Mode_Faction = FACTION
CraftBot_Data = {}
CraftBot_Limit = 10
CraftBot_Silent = true
CraftBot_RefineReagents = false
CraftBot_Messages = {
	{"CRAFTBOT_WELCOME",CRAFTBOT_WELCOME},
	{"CRAFTBOT_HELP",CRAFTBOT_HELP},
	{"CRAFTBOT_HELP_MAT",CRAFTBOT_HELP_MAT},
	{"CRAFTBOT_HELP_NOK",CRAFTBOT_HELP_NOK},
	{"CRAFTBOT_HELP_TOO_MANY",CRAFTBOT_HELP_TOO_MANY},
}
CraftBot_IgnoredProfessions = {}
CraftBot_MM = {
	["visible"] = true,
	["position"] = 0,
	["square"] = false,
}

function CraftBot_OnLoad()
	CraftBot:RegisterEvent("ADDON_LOADED")
	CraftBot:RegisterEvent("PLAYER_LOGIN")
end

function CraftBot_OnEvent(frame,event,arg_1,arg_2)
	if event == "CHAT_MSG_WHISPER" then
		CraftBot_OnWhisper(arg_1,arg_2)
	elseif event == "TRADE_SKILL_UPDATE" then
		CraftBot_Scan()
	elseif event == "ADDON_LOADED" and arg_1 == "CraftBot" then
		SlashCmdList["CRAFTBOT"] = CraftBot_SlashHandler
		SLASH_CRAFTBOT1 = "/craftbot"
		SLASH_CRAFTBOT2 = "/cb"
		CraftBot_Init()
		CraftBot_Activate(CraftBot_On)
		if CraftBot_MM.visible then
			CraftBot_MM_Toggle(true)
		else
			CraftBot_MM_Toggle(false)
		end
	elseif event == "PLAYER_LOGIN" then
		isScanning = false
		ORG_ChatFrame_Hook = ChatFrame_MessageEventHandler
		ChatFrame_MessageEventHandler = CraftBot_Message_Hook
		if IsAddOnLoaded("WIM") then
			isWIM = true
			CraftBot_WIM_OnLoad()
		end
		if IsAddOnLoaded("EnchantBot") then
			isOnlyBot = false
		end
		if IsAddOnLoaded("CraftBotFu") then
			isFuPlugin = true
		end
	end
end

function CraftBot_Init()
	local name = UnitName("player")
	local realm = GetRealmName()
	local _,localFac = UnitFactionGroup("player")
	if #(CraftBot_Data) > 0 then
		for i=1,#(CraftBot_Data) do
			if CraftBot_Data[i].name == name and CraftBot_Data[i].realm == realm then
				currPlayerIndex = i
				break
			end
		end
	end
	if currPlayerIndex == 0 then
		local playerData = {}
		playerData.name = name
		playerData.realm = realm
		playerData.faction = localFac
		playerData.skills = {}
		tinsert(CraftBot_Data,playerData)
		currPlayerIndex = #(CraftBot_Data)
	else
		if CraftBot_Data[currPlayerIndex].faction == nil then
			CraftBot_Data[currPlayerIndex].faction = localFac
		end
	end
end

function CraftBot_Activate(state)
	if (state) then
		CraftBot:RegisterEvent("CHAT_MSG_WHISPER")
		CraftBot:RegisterEvent("TRADE_SKILL_UPDATE")
		CraftBot_On = true
		CraftBot_Print(CRAFTBOT_ON)
		CraftBot_SetShoppeProfessions()
	else
		CraftBot:UnregisterEvent("CHAT_MSG_WHISPER")
		CraftBot:UnregisterEvent("TRADE_SKILL_UPDATE")
		CraftBot_On = false
		CraftBot_Print(CRAFTBOT_OFF)
	end
	if isFuPlugin then
		CraftBotFu:Update()
	end
end

function CraftBot_SlashHandler(msg)
	local words = CraftBot_Split(msg," ")
	if #(words) > 0 then
		local cmd = words[1]
		if cmd == "on" then
			CraftBot_Activate(true)
		elseif cmd == "off" then
			CraftBot_Activate(false)
		elseif cmd == "scan" then
			CraftBot_ManualScan()
		elseif cmd == "send" or cmd == "s" then
			if #(words) > 2 then
				local user = CraftBot_GetPlayer(words[2])
				local craftIndex = CraftBot_Strip(msg,cmd.." "..words[2].." ")
				if craftIndex ~= nil and craftIndex ~= "" then
					CraftBot_SendReagents(craftIndex,user)
				end
			end
		elseif cmd == "sendl" or cmd == "sl" then
			if #(words) > 2 then
				local user = CraftBot_GetPlayer(words[2])
				local craftIndex = CraftBot_Strip(msg,cmd.." "..words[2].." ")
				if craftIndex ~= nil and craftIndex ~= "" then
					local found,tempText,minLevel,maxLevel = CraftBot_GetLevelReq(craftIndex)
					if found then
						CraftBot_Search(tempText,user,minLevel,maxLevel)
					else
						CraftBot_Search(craftIndex,user)
					end
				end
			end
		elseif cmd == "sendr" or cmd == "sr" then
			if #(words) > 2 then
				local user = CraftBot_GetPlayer(words[2])
				local craftIndex = CraftBot_Strip(msg,cmd.." "..words[2].." ")
				if craftIndex ~= nil and craftIndex ~= "" then
					CraftBot_SendRecipe(craftIndex,user)
				end
			end
		elseif cmd == "who" or cmd == "w" then
			if #(words) > 2 then
				local craftIndex = CraftBot_Strip(msg,cmd.." ")
				CraftBot_Who(craftIndex)
			end
		elseif cmd == "minimap" or cmd == "mm" then
			local param = words[2]
			if param == "on" then
				CraftBot_MM_Toggle(true)
			elseif param == "off" then
				CraftBot_MM_Toggle(false)
			end
		elseif cmd == "faction" or cmd == "f" then
			local param = words[2]
			if param == "on" then
				CraftBot_Search_Mode_Change("FACTION")
			elseif param == "off" then
				CraftBot_Search_Mode_Change("FACTIONLESS")
			end
		elseif cmd == "refine" or cmd == "r" then
			local param = words[2]
			if param == "on" then
				CraftBot_Refine_Mode_Change(true)
			elseif param == "off" then
				CraftBot_Refine_Mode_Change(false)
			end
		elseif cmd == "limit" or cmd == "l" then
			if words[2] and tonumber(words[2]) then
				CraftBot_Set_Limit(tonumber(words[2]))
			end
		elseif cmd == "search" then
			if words[2] then
				CraftBot_Search_Mode_Change(strupper(words[2]))
			end
		elseif cmd == "option" or cmd == "o" then
			CraftBot_ToggleOptions()
		elseif cmd == "silent" then
			local param = strlower(words[2])
			if param == "on" then
				CraftBot_Silent_Mode_Change(true)
			elseif param == "off" then
				CraftBot_Silent_Mode_Change(false)
			end
		elseif cmd == "debug" then
			local param = strlower(words[2])
			if param == "on" then
				isDebug = true
			elseif param == "off" then
				isDebug = false
			end
		elseif cmd == "id" then
			if #(words) > 1 then
				local text = CraftBot_Strip(msg,cmd.." ")
				if text ~= nil and text ~= "" then
					local id = CraftBot_GetItemID(text)
					if id ~= 0 then
						CraftBot_Print(format(CRAFTBOT_ID,id))
					end
				end
 			end
		elseif cmd == "link" then
			if #(words) > 1 then
				local text = CraftBot_Strip(msg,cmd.." ")
				if text ~= nil and text ~= "" and tonumber(text) then
					local name,link = GetItemInfo(tonumber(text))
					if name then
						CraftBot_Print(format(CRAFTBOT_LINK,link))
					end
				end
 			end
		elseif cmd == "reset" then
			CraftBot_Reset(1)
		elseif cmd == "resetall" then
			CraftBot_Reset(2)
		elseif cmd == "resetmsg" then
			CraftBot_Reset(3)
		elseif cmd == "help" or cmd == "?" then
			CraftBot_Help_Toggle()
		end
	else
		CraftBot_Activate(not CraftBot_On)
	end
end

function CraftBot_ManualScan()
	local skillName,currentLevel,maxLevel = GetTradeSkillLine()
	if skillName == nil or skillName == "" or skillName == "UNKNOWN" then
		CraftBot_Print(CRAFTBOT_SCAN_FORCE_UNKNOWN)
		return
	elseif CraftBot_IsIgnoredProfession(skillName) then
		CraftBot_Print(format(CRAFTBOT_SCAN_FORCE_IGNORED,skillName))
		return
	end
	local skillIndex = CraftBox_GetSkillIndex(skillName)
	local categories = #(CraftBot_Split(BuildListString(GetTradeSkillSubClasses()),",")) or 0
	local craftNum = GetNumTradeSkills() or 0
	if (craftNum - categories) <= 0 or isScanning then
		return
	end
	CraftBot_Data[currPlayerIndex].skills[skillIndex].data = {}
	CraftBot_Print(format(CRAFTBOT_SCAN_FORCE,skillName))
	CraftBot_Scan()
end

function CraftBot_Scan()
	local skillName,currentLevel,maxLevel = GetTradeSkillLine()
	if skillName == nil or skillName == "" or skillName == "UNKNOWN" or CraftBot_IsIgnoredProfession(skillName) then
		return
	end
	local skillIndex = CraftBox_GetSkillIndex(skillName)
	local category = ""
	local categories = #(CraftBot_Split(BuildListString(GetTradeSkillSubClasses()),",")) or 0
	local craftNum = GetNumTradeSkills() or 0
	if (craftNum - categories) <= #(CraftBot_Data[currPlayerIndex].skills[skillIndex].data) or isScanning then
		return
	end
	isScanning = true
	CraftBot_Data[currPlayerIndex].skills[skillIndex].data = {}
	local numErrors = 0
	for i=1,craftNum do
		if GetTradeSkillItemLink(i) then
			local craftName,skillType,numAvailable,isExpanded = GetTradeSkillInfo(i)
			local craftData = {}
			craftData.craftName = craftName
			craftData.craftLink = GetTradeSkillItemLink(i)
			craftData.recipeLink = GetTradeSkillRecipeLink(i)
			local itemstats = BuildListString(GetTradeSkillItemStats(i)) or ""
			-- adapted from Styler
			-- scanning tooltip for items that did not return a usable ItemDescription
			-- by calling GetTradeSkillItemStats(). This is mainly needed for gems
			if itemstats == "" or not strfind(itemstats,",",1,true) then
				local desc = CraftBot_GetItemDescriptionFromTooltip(craftData.craftLink)
				if (desc ~= "") then
					itemstats = itemstats..", "..desc
				end
			end
			craftData.craftDesc = itemstats
			craftData.category = category
			craftData.qty = {}
			craftData.qty.min,craftData.qty.max = GetTradeSkillNumMade(i)
			if strfind(itemstats,ITEM_BIND_ON_PICKUP) then
				craftData.ignore = true
			end
			craftData.reagents = {}
			local numReagents = GetTradeSkillNumReagents(i) or 0
			if numReagents > 0 then
				for m=1,numReagents,1 do
					local reagentLink = GetTradeSkillReagentItemLink(i,m) or nil
					if reagentLink then
						local _,_,reagentCount,_ = GetTradeSkillReagentInfo(i,m)
						tinsert(craftData.reagents,{ CraftBot_GetItemID(reagentLink),reagentCount })
					else
						numErrors = numErrors + 1
					end
				end
			end
			tinsert(CraftBot_Data[currPlayerIndex].skills[skillIndex].data,craftData)
		else
			category,_,_,_ = GetTradeSkillInfo(i)
			if not category then
				category = ""
			end
		end
	end
	isScanning = false
	if numErrors > 0 then
		CraftBot_Print(format(CRAFTBOT_SCAN_ERROR,numErrors))
	else
		CraftBot_Print(CRAFTBOT_SCAN_COMPLETE)
	end
	CraftBot_SetShoppeProfessions()
	if isFuPlugin then
		CraftBotFu:Update()
	end
end

function CraftBot_OnWhisper(text,user)
	local temp = CraftBot_Strip(text,CRAFTBOT_WHISPERCMD_SEARCH.." ")
	if temp == nil then
		temp = CraftBot_Strip(text,CRAFTBOT_WHISPERCMD_USE.." ")
		if temp == nil then
			if CraftBot_Strip(text,CRAFTBOT_WHISPERCMD) then
				CraftBot_CheckHolidays(user)
				CraftBot_SendChat(user,format(CraftBot_Messages[WELCOME][2],UnitName("player"),professionsTitle))
				CraftBot_SendChat(user,format(CraftBot_Messages[HELP][2],defaultItem,defaultReagent))
				CraftBot_Print(format(CRAFTBOT_RESULTS_HELP,text,user,user))
			end
		else
			CraftBot_SendReagents(temp,user)
		end
	else
		local found,tempText,minLevel,maxLevel = CraftBot_GetLevelReq(temp)
		if found then
			CraftBot_Search(tempText,user,minLevel,maxLevel)
		else
			CraftBot_Search(temp,user)
		end
	end
end

--
-- List all toons that can make craftables using multi keyword AND search 
-- mechanics with level filtering via matching with:
-- name, link, desc, category
-- 
function CraftBot_Who(msg)
	local orgMsg = msg
	msg = strlower(msg)
	local CountIt = 0
	local isLink = false
	for i=1,#(CraftBot_Data) do
		if CraftBot_Searchable(i) then
			for x=1,#(CraftBot_Data[i].skills) do
				for y=1,#(CraftBot_Data[i].skills[x].data) do
					if not CraftBot_Data[i].skills[x].data[y].ignore then
						local craft = CraftBot_Data[i].skills[x].data[y]
						local craftName,craftLink,craftDesc,craftMin,craftMax,craftCategory = craft.craftName,craft.craftLink,craft.craftDesc,craft.qty.min,craft.qty.max,craft.category
						local recipeLink = craft.recipeLink or craftLink
						local foo = nil
						if foo == nil and strfind(orgMsg,"|Hitem:",1,true) then
							isLink = true
							-- Adapted from Styler
							if CraftBot_GetItemID(craftLink) == CraftBot_GetItemID(orgMsg) then
								foo = true
							end
						end
						if foo == nil and strfind(orgMsg,"|Henchant:",1,true) then
							isLink = true
							if CraftBot_GetEnchantID(recipeLink) == CraftBot_GetEnchantID(orgMsg) then
								foo = true
							end
						end
						if isLink == false and foo == nil then
							-- So that multikeywords can span both craft names and descriptions
							local craftText = craftName..", "..craftLink
							if recipeLink ~= nil and recipeLink ~= craftLink then
								craftText = craftText..", "..recipeLink
							end
							if craftDesc ~= nil and craftDesc ~= "" then
								craftText = craftText..", "..craftDesc
							end
							if craftCategory ~= nil and craftCategory ~= "" then
								craftText = craftText..", "..craftCategory
							end
							foo = CraftBot_MatchStrings(strlower(craftText),gsub(gsub(msg," ",","),",,",","),",")
						end
						if foo ~= nil then
							CountIt = CountIt + 1
							CraftBot_Print("["..CountIt.."] "..CraftBot_Data[i].name..", "..CraftBot_Data[i].faction..", "..CraftBot_Data[i].realm.."")
						end
					end
				end
			end
			if CraftBot_Search_Mode == PLAYER then
				break
			end
		end
	end
end

--
-- Searches craftables using multi keyword AND search mechanics with level 
-- filtering via matching with
-- name, link, desc, category
-- 
function CraftBot_Search(msg,user,minLevel,maxLevel)
	if #(CraftBot_Data) == 0 or user == nil then
		return
	end
	local orgMsg = msg
	local found = {}
	msg = strlower(msg)
	local CountIt = 0
	local exceedLimit = false
	local isLink = false
	for i=1,#(CraftBot_Data) do
		if CraftBot_Searchable(i) then
			for x=1,#(CraftBot_Data[i].skills) do
				for y=1,#(CraftBot_Data[i].skills[x].data) do
					if not CraftBot_Data[i].skills[x].data[y].ignore then
						local craft = CraftBot_Data[i].skills[x].data[y]
						local craftName,craftLink,craftDesc,craftMin,craftMax,craftCategory = craft.craftName,craft.craftLink,craft.craftDesc,craft.qty.min,craft.qty.max,craft.category
						local recipeLink = craft.recipeLink or craftLink
						local craftLevel = CraftBot_GetItemLevel(craftLink)
						local foo = nil
						if foo == nil and strfind(orgMsg,"|Hitem:",1,true) then
							isLink = true
							-- Adapted from Styler
							if CraftBot_GetItemID(craftLink) == CraftBot_GetItemID(orgMsg) then
								foo = true
							end
						end
						if foo == nil and strfind(orgMsg,"|Henchant:",1,true) then
							isLink = true
							if CraftBot_GetEnchantID(recipeLink) == CraftBot_GetEnchantID(orgMsg) then
								foo = true
							end
						end
						local skip = false
						if foo == nil and craftLevel >= 0 and minLevel and maxLevel then
							if minLevel == maxLevel then
								if craftLevel ~= minLevel and minLevel ~= 0 then
									skip = true 
								end
							elseif minLevel == 0 then
								if craftLevel > maxLevel then
									skip = true 
								end
							elseif maxLevel == 0 then
								if craftLevel < minLevel then
									skip = true 
								end
							else
								if craftLevel < minLevel or craftLevel > maxLevel then
									skip = true 
								end
							end
						end
						if not skip then
							if isLink == false and foo == nil then
								-- So that multikeywords can span both craft names and descriptions
								local craftText = craftName..", "..craftLink
								if recipeLink ~= nil and recipeLink ~= craftLink then
									craftText = craftText..", "..recipeLink
								end
								if craftDesc ~= nil and craftDesc ~= "" then
									craftText = craftText..", "..craftDesc
								end
								if craftCategory ~= nil and craftCategory ~= "" then
									craftText = craftText..", "..craftCategory
								end
								foo = CraftBot_MatchStrings(strlower(craftText),gsub(gsub(msg," ",","),",,",","),",")
							end
							if foo ~= nil then
								local duplicate = false
								for z=1,#(found) do
									if found[z] == craftName then
										duplicate = true
										break
									end
								end
								if not duplicate then
									CountIt = CountIt + 1
									if CraftBot_Limit > 0 and CountIt > CraftBot_Limit then
										exceedLimit = true
										break
									end
									if craftMin == 1 and craftMax == 1 then
										CraftBot_SendChat(user,format(CRAFTBOT_RESULT,i,x,y,recipeLink))
									else
										if craftMin == craftMax then
											CraftBot_SendChat(user,format(CRAFTBOT_RESULT_QTY,i,x,y,recipeLink,craftMin))
										else
											CraftBot_SendChat(user,format(CRAFTBOT_RESULT_QTY2,i,x,y,recipeLink,craftMin,craftMax))
										end
									end
									tinsert(found,craftName)
								end
							end
						end
					end
				end
				if exceedLimit then
					break
				end
			end
			if CraftBot_Search_Mode == PLAYER or exceedLimit then
				break
			end
		end
	end
	local statusMsg = ""
	if CountIt > 0 then
		if exceedLimit then
			CountIt = CraftBot_Limit
			CraftBot_SendChat(user,format(CraftBot_Messages[HELP_TOO_MANY][2],CraftBot_Limit))
		end
		CraftBot_SendChat(user,CraftBot_Messages[HELP_MAT][2])
		statusMsg = format(CRAFTBOT_RESULTS_OK,orgMsg,user,user,CountIt)
	else
		CraftBot_SendChat(user,CraftBot_Messages[HELP_NOK][2])
		statusMsg = format(CRAFTBOT_RESULTS_NOK,orgMsg,user,user)
	end
	if minLevel and maxLevel then
		statusMsg = statusMsg .. format(CRAFTBOT_RESULTS_LEVEL,minLevel,maxLevel)
	end
	CraftBot_Print(statusMsg)
end

function CraftBot_SendReagents(msg,user)
	if #(CraftBot_Data) == 0 or user == nil then
		return
	end
	-- playerIndex.skillIndex.craftIndex format
	local playerIndex,skillIndex,craftIndex = 0,0,0
	local isDotFormat = false
	if strfind(msg,".") then
		local tmp = CraftBot_Split(msg,".")
		if #(tmp) == 3 then
			playerIndex,skillIndex,craftIndex = tonumber(tmp[1]),tonumber(tmp[2]),tonumber(tmp[3])
			if playerIndex ~= nil and skillIndex ~= nil and craftIndex ~= nil and CraftBot_Data[playerIndex] ~= nil and CraftBot_Data[playerIndex].skills[skillIndex] ~= nil and CraftBot_Data[playerIndex].skills[skillIndex].data[craftIndex] ~= nil then
				isDotFormat = true
			end
		end
	end
	if not isDotFormat then
		isDotFormat,playerIndex,skillIndex,craftIndex = CraftBot_GetDotFormat(msg)
	end
	if isDotFormat then
		local reagentsData = {}
		local recipeLink = CraftBot_Data[playerIndex].skills[skillIndex].data[craftIndex].recipeLink or CraftBot_Data[playerIndex].skills[skillIndex].data[craftIndex].craftLink
		if recipeLink then
			if CraftBot_RefineReagents then
				reagentsData = CraftBot_GetAllReagents(CraftBot_Data[playerIndex].skills[skillIndex].data[craftIndex].reagents)
			else
				if CraftBot_Data[playerIndex].skills[skillIndex].data[craftIndex].recipeLink then
				else
					reagentsData = CraftBot_Data[playerIndex].skills[skillIndex].data[craftIndex].reagents
				end
			end
			if #(reagentsData) ~= 0 then
				if CraftBot_IsClipboard(user) then
					local reagents = " "
					local rtmp = nil
					CraftBot_SendChat(user,recipeLink..":")
					for m=1,#(reagentsData) do
						local reagentName = GetItemInfo(reagentsData[m][1])
						local reagentCount = reagentsData[m][2]
						rtmp = reagents.." "..reagentCount.." x "..reagentName
						if strlen(rtmp) > 255 then
							CraftBot_SendChat(user,reagents)
							rtmp = " "..reagentCount.." x "..reagentName
							reagents = rtmp
						end
						reagents = rtmp
					end
					CraftBot_SendChat(user,reagents)
				else
					CraftBot_SendChat(user,format(CRAFTBOT_MAT_LIST,recipeLink))
				end
				CraftBot_Print(format(CRAFTBOT_MAT_OK,recipeLink,user,user))
				return true
			else
				CraftBot_SendChat(user,recipeLink)
				CraftBot_Print(format(CRAFTBOT_MAT_OK,recipeLink,user,user))
				return true
			end
		end
	end
	CraftBot_Print(format(CRAFTBOT_MAT_NOK,msg,user,user))
	return false
end

function CraftBot_SendRecipe(reagent,user)
	if #(CraftBot_Data) == 0 or user == nil then
		return
	end
	local orgreagent = reagent
	reagent = strlower(reagent)
	local itemName = nil
	if strfind(reagent,"|hitem:") then
		itemName,_,_,_,_,_,_,_,_,_ = GetItemInfo(reagent)
	else
		itemName = reagent
	end
	if itemName ~= nil then
		local CountIt = 0
		local exceedLimit = false
		for i=1,#(CraftBot_Data) do
			if CraftBot_Searchable(i) then
				for x=1,#(CraftBot_Data[i].skills) do
					for y=1,#(CraftBot_Data[i].skills[x].data) do
						local reagentsData = CraftBot_Data[i].skills[x].data[y].reagents
						for m=1,#(reagentsData) do
							local reagentID = reagentsData[m][1]
							local _,reagentLink = GetItemInfo(reagentID)
							-- Adapted from Styler
							if strfind(strlower(reagentLink),reagent,1,true) or reagentID == CraftBot_GetItemID(orgreagent) then
								CountIt = CountIt + 1
								if CraftBot_Limit > 0 and CountIt > CraftBot_Limit then
									exceedLimit = true
									break
								end
								CraftBot_SendChat(user,format(CRAFTBOT_RESULT,i,x,y,CraftBot_Data[i].skills[x].data[y].recipeLink))
								break
							end
						end
						if exceedLimit then
							break
						end
					end
					if exceedLimit then
						break
					end
				end
				if CraftBot_Search_Mode == PLAYER or exceedLimit then
					break
				end
			end
		end
		if CountIt > 0 then
			if exceedLimit then
				CountIt = CraftBot_Limit
				CraftBot_SendChat(user,format(CraftBot_Messages[HELP_TOO_MANY][2],CraftBot_Limit))
			end
			CraftBot_SendChat(user,CraftBot_Messages[HELP_MAT][2])
			CraftBot_Print(format(CRAFTBOT_RESULTS2_OK,orgreagent,user,user,CountIt))
			return true
		end
		CraftBot_Print(format(CRAFTBOT_RESULTS2_NOK,orgreagent,user,user))
		return false
	end
	CraftBot_Print(format(CRAFTBOT_RESULTS2_NOK,"nil",user,user))
	return false
end

-- =============================================================================
-- BAR PLUGIN FUNCTIONS 
-- =============================================================================

function CraftBot_GetTooltipText()
	local realm = GetRealmName()
	local text = ""
	for i=1,#(CraftBot_Data) do
		if CraftBot_Searchable(i) then
			local craftNum = #(CraftBot_Data[i].skills)
			if craftNum > 0 then
				if text ~= "" then
					text = text.."\n"
				end
				if CraftBot_Data[i].realm == realm then
					text = text.."|cffffffff"..CraftBot_Data[i].name.."|r\n"
				else
					text = text.."|cffffffff"..CraftBot_Data[i].name.." ("..realm..")|r\n"
				end
				for x=1,craftNum do
					text = text..format(CRAFTBOT_TOOLTIP_SKILL,CraftBot_Data[i].skills[x].name,#(CraftBot_Data[i].skills[x].data))
					if x ~= craftNum then
						text = text.."\n"
					end
				end
			end
			if CraftBot_Search_Mode == PLAYER then
				break
			end
		end
	end
	if isDebug then
		text = text.."\nOutgoing Whispers: "..#(outgoingWhispers)
	end
	return text
end

function CraftBot_GetButtonText()
	if (CraftBot_On == false) then
		return CRAFTBOT_SMODE_OFF
	else
		if CraftBot_Search_Mode == PLAYER then
			return CRAFTBOT_SMODE_PLAYER
		elseif CraftBot_Search_Mode == REALM then
			return CRAFTBOT_SMODE_REALM
		elseif CraftBot_Search_Mode == XREALM then
			return CRAFTBOT_SMODE_XREALM
		end
	end
	return ""
end

-- =============================================================================
-- OPTION FUNCTIONS 
-- =============================================================================

function CraftBot_Reset(x)
	if x == 1 then
		CraftBot_Data[currPlayerIndex].skills = {}
		CraftBot_Print(CRAFTBOT_RESET)
	elseif x == 2 then
		currPlayerIndex = 0
		CraftBot_Data = {}
		CraftBot_Init()
		CraftBot_Print(CRAFTBOT_RESET_ALL)
	elseif x == 3 then
		CraftBot_Messages = {
			{"CRAFTBOT_WELCOME",CRAFTBOT_WELCOME},
			{"CRAFTBOT_HELP",CRAFTBOT_HELP},
			{"CRAFTBOT_HELP_MAT",CRAFTBOT_HELP_MAT},
			{"CRAFTBOT_HELP_NOK",CRAFTBOT_HELP_NOK},
			{"CRAFTBOT_HELP_TOO_MANY",CRAFTBOT_HELP_TOO_MANY},
		}
		CraftBot_Print(CRAFTBOT_RESET_MSG)
	end
end

function CraftBot_Set_Limit(x)
	if x >= 0 and x ~= CraftBot_Limit then
		CraftBot_Limit = x
		CraftBot_Print(format(CRAFTBOT_LIMIT,CraftBot_Limit))
	else
		CraftBot_Limit = 10
		CraftBot_Print(format(CRAFTBOT_LIMIT,CraftBot_Limit))
	end
end

function CraftBot_Refine_Mode_Change(mode)
	if mode ~= CraftBot_RefineReagents then
		if mode then
			CraftBot_RefineReagents = true
			CraftBot_Print(CRAFTBOT_SMODE_REFINE_LABEL..CRAFTBOT_SMODE_ON)
		else
			CraftBot_RefineReagents = false
			CraftBot_Print(CRAFTBOT_SMODE_REFINE_LABEL..CRAFTBOT_SMODE_OFF)
		end
		if isFuPlugin then
			CraftBotFu:Update()
		end
	end
end

function CraftBot_Silent_Mode_Change(mode)
	if mode ~= CraftBot_Silent then
		if mode then
			CraftBot_Silent = true
			CraftBot_Print(CRAFTBOT_SMODE_SILENT_LABEL..CRAFTBOT_SMODE_ON)
		else
			CraftBot_Silent = false
			CraftBot_Print(CRAFTBOT_SMODE_SILENT_LABEL..CRAFTBOT_SMODE_OFF)
		end
		if isFuPlugin then
			CraftBotFu:Update()
		end
	end
end

function CraftBot_Search_Mode_Change(mode)
	if (mode == "PLAYER" or mode == "P") and CraftBot_Search_Mode ~= PLAYER then
		CraftBot_Search_Mode = PLAYER
		CraftBot_Print(CRAFTBOT_SMODE_LABEL..CRAFTBOT_SMODE_PLAYER)
	elseif (mode == "REALM" or mode == "R") and CraftBot_Search_Mode ~= REALM then
		CraftBot_Search_Mode = REALM
		CraftBot_Print(CRAFTBOT_SMODE_LABEL..CRAFTBOT_SMODE_REALM)
	elseif (mode == "XREALM" or mode == "XR") and CraftBot_Search_Mode ~= XREALM then
		CraftBot_Search_Mode = XREALM
		CraftBot_Print(CRAFTBOT_SMODE_LABEL..CRAFTBOT_SMODE_XREALM)
	elseif mode == "FACTION" and CraftBot_Search_Mode_Faction ~= FACTION then
		CraftBot_Search_Mode_Faction = FACTION
		CraftBot_Print(CRAFTBOT_SMODE_FACTION_LABEL..CRAFTBOT_SMODE_ON)
	elseif mode == "FACTIONLESS" and CraftBot_Search_Mode_Faction ~= FACTIONLESS then
		CraftBot_Search_Mode_Faction = FACTIONLESS
		CraftBot_Print(CRAFTBOT_SMODE_FACTION_LABEL..CRAFTBOT_SMODE_OFF)
	end
	if isFuPlugin then
		CraftBotFu:Update()
	end
end

function CraftBot_SetShoppeProfessions()
	local setDefaults = false
	for i=1,#(CraftBot_Data) do
		if CraftBot_Searchable(i) then
			for x=1,#(CraftBot_Data[i].skills) do
				if strfind(professionsTitle,CraftBot_Data[i].skills[x].name,1,true) then
				else
					if x ~= #(CraftBot_Data[i].skills) then
						professionsTitle = professionsTitle..CraftBot_Data[i].skills[x].name.."/"
					else
						professionsTitle = professionsTitle..CraftBot_Data[i].skills[x].name
					end
				end
				if  i == currPlayerIndex and not setDefaults then
					for y=1,#(CraftBot_Data[i].skills[x].data),1 do
						local craftName = CraftBot_Data[i].skills[x].data[y].craftName
						if craftName ~= nil and (not CraftBot_Data[i].skills[x].data[y].ignore) and #(CraftBot_Data[i].skills[x].data[y].reagents) > 0 then
							local reagentName = GetItemInfo(CraftBot_Data[i].skills[x].data[y].reagents[1][1])
							if reagentName ~= nil then
								if (strlen(CraftBot_Messages[HELP][2]) + strlen(craftName) + strlen(reagentName) - 4) <= 255 then
									defaultItem = craftName
									defaultReagent = reagentName
									setDefaults = true
									break
								end
							end
						end
					end
				end
			end
			if CraftBot_Search_Mode == PLAYER then
				return
			end
		end
	end
end

-- =============================================================================
-- OPTION UI FUNCTIONS 
-- =============================================================================

function CraftBot_Options_OnShow()
	PlaySound("igCharacterInfoOpen")
	CraftBotOptionFrameHeaderText:SetText(CRAFTBOT_LABEL_HEADER)
	CraftBotOptionFrameLabelLocalization:SetText(CRAFTBOT_LABEL_LOCALIZATION)
	CraftBotOptionFrameLabelIgnoredProfessions:SetText(CRAFTBOT_LABEL_IGNORED_PROFESSIONS)
	CraftBotOptionFrameLabelLimit:SetText(CRAFTBOT_LABEL_LIMIT)
	CraftBotOptionFrameLabelSearch:SetText(CRAFTBOT_LABEL_SEARCH)
	CraftBotOptionFrameLimit:SetText(CraftBot_Limit)
	CraftBot_GetIgnoredProfessions()
end

function CraftBot_Options_OnHide()
	PlaySound("igCharacterInfoClose")
end

function CraftBot_ToggleOptions()
	if CraftBotOptionFrame:IsVisible() then
		CraftBotOptionFrame:Hide()
	else
		CraftBotOptionFrame:Show()
	end
end

function CraftBot_SetOptionValue(button)
	local name = button:GetParent():GetName()
	local checked = false
	if button:GetChecked() then
		checked = true
	end
	if name == "CraftBotOptionFrameSearchXR" then
		if checked then
			CraftBot_Search_Mode_Change("XR")
			CraftBotOptionFrameSearchR_Button:SetChecked(false)
			CraftBotOptionFrameSearchP_Button:SetChecked(false)
		else
			button:SetChecked(true)
		end
	elseif name == "CraftBotOptionFrameSearchR" then
		if checked then
			CraftBot_Search_Mode_Change("R")
			CraftBotOptionFrameSearchXR_Button:SetChecked(false)
			CraftBotOptionFrameSearchP_Button:SetChecked(false)
		else
			button:SetChecked(true)
		end
	elseif name == "CraftBotOptionFrameSearchP" then
		if checked then
			CraftBot_Search_Mode_Change("P")
			CraftBotOptionFrameSearchXR_Button:SetChecked(false)
			CraftBotOptionFrameSearchR_Button:SetChecked(false)
		else
			button:SetChecked(true)
		end
	elseif name == "CraftBotOptionFrameFaction" then
		if checked then
			CraftBot_Search_Mode_Change("FACTION")
		else
			CraftBot_Search_Mode_Change("FACTIONLESS")
		end
	elseif name == "CraftBotOptionFrameSilent" then
		if checked then
			CraftBot_Silent_Mode_Change(true)
		else
			CraftBot_Silent_Mode_Change(false)
		end
	elseif name == "CraftBotOptionFrameRefine" then
		if checked then
			CraftBot_Refine_Mode_Change(true)
		else
			CraftBot_Refine_Mode_Change(false)
		end
	elseif name == "CraftBotOptionFrameMM" then
		if checked then
			CraftBot_MM_Toggle(true)
		else
			CraftBot_MM_Toggle(false)
		end
	end
end

function CraftBot_GetOptionValue(button)
	local name = button:GetName()
	local fontString = getglobal(button:GetName().."_Text")
	local radioButton = getglobal(button:GetName().."_Button")
	if name == "CraftBotOptionFrameSearchXR" then
		if CraftBot_Search_Mode == XREALM then
			radioButton:SetChecked(true)
		else
			radioButton:SetChecked(false)
		end
		fontString:SetText(CRAFTBOT_SMODE_XREALM)
	elseif name == "CraftBotOptionFrameSearchR" then
		if CraftBot_Search_Mode == REALM then
			radioButton:SetChecked(true)
		else
			radioButton:SetChecked(false)
		end
		fontString:SetText(CRAFTBOT_SMODE_REALM)
	elseif name == "CraftBotOptionFrameSearchP" then
		if CraftBot_Search_Mode == PLAYER then
			radioButton:SetChecked(true)
		else
			radioButton:SetChecked(false)
		end
		fontString:SetText(CRAFTBOT_SMODE_PLAYER)
	elseif name == "CraftBotOptionFrameFaction" then
		if CraftBot_Search_Mode_Faction == FACTION then
			radioButton:SetChecked(true)
		else
			radioButton:SetChecked(false)
		end
		fontString:SetText(CRAFTBOT_SMODE_FACTION)
	elseif name == "CraftBotOptionFrameSilent" then
		if CraftBot_Silent then
			radioButton:SetChecked(true)
		else
			radioButton:SetChecked(false)
		end
		fontString:SetText(CRAFTBOT_SMODE_SILENT)
	elseif name == "CraftBotOptionFrameRefine" then
		if CraftBot_RefineReagents then
			radioButton:SetChecked(true)
		else
			radioButton:SetChecked(false)
		end
		fontString:SetText(CRAFTBOT_SMODE_REFINE)
	elseif name == "CraftBotOptionFrameMM" then
		if CraftBot_MM.visible then
			radioButton:SetChecked(true)
		else
			radioButton:SetChecked(false)
		end
		fontString:SetText(CRAFTBOT_SMODE_MM)
	end
end

function CraftBot_Localization_DDM_OnLoad()
	UIDropDownMenu_Initialize(this:GetParent(),CraftBot_Localization_DDM_Init)
	UIDropDownMenu_SetAnchor(0,0,this:GetParent(),"TOPRIGHT",this:GetName(),"BOTTOMRIGHT")
end

function CraftBot_Localization_DDM_Init()
	local info = {}
	for i=1,#(CraftBot_Messages) do
		info = {
			text = CraftBot_Messages[i][1],
			value = i,
			func = CraftBot_Localization_DDM_Select
		}
		if i == selectedDDMIndex then 
			info.checked = 1
		end
		UIDropDownMenu_AddButton(info)
	end
end

function CraftBot_Localization_DDM_Select()
	if this.value then
		local text = strtrim(CraftBotOptionFrameLocalization:GetText())
		selectedDDMIndex = this.value
		CraftBotOptionFrameLocalization:SetText(CraftBot_Messages[this.value][2])
	end
end

function CraftBot_SetLocalization(text)
	local x = strtrim(text)
	if x ~= "" and selectedDDMIndex > 0 and CraftBot_Messages[selectedDDMIndex][2] ~= x then
		CraftBot_Messages[selectedDDMIndex][2] = x
		CraftBot_Print(CraftBot_Messages[selectedDDMIndex][1]..": "..x)
	end
end

function CraftBot_ShowCustomTooltip(x,y)
	if x then
		if y == "Localization" then
			GameTooltip:SetOwner(CraftBotOptionFrameLocalization,"ANCHOR_BOTTOMRIGHT",CraftBotOptionFrameLocalization:GetWidth()*-1,0)
			GameTooltip:ClearLines()
			for i=1,#(CRAFTBOT_TOOLTIP_LOCALIZATION) do
				GameTooltip:AddLine(CRAFTBOT_TOOLTIP_LOCALIZATION[i][1],CRAFTBOT_TOOLTIP_LOCALIZATION[i][2],CRAFTBOT_TOOLTIP_LOCALIZATION[i][3],CRAFTBOT_TOOLTIP_LOCALIZATION[i][4])
			end
	 		GameTooltip:Show()
		elseif y == "Limit" then
			GameTooltip:SetOwner(CraftBotOptionFrameLimit,"ANCHOR_BOTTOMRIGHT",CraftBotOptionFrameLimit:GetWidth()*-1,0)
			GameTooltip:ClearLines()
			for i=1,#(CRAFTBOT_TOOLTIP_LIMIT) do
				GameTooltip:AddLine(CRAFTBOT_TOOLTIP_LIMIT[i][1],CRAFTBOT_TOOLTIP_LIMIT[i][2],CRAFTBOT_TOOLTIP_LIMIT[i][3],CRAFTBOT_TOOLTIP_LIMIT[i][4])
			end
	 		GameTooltip:Show()
		elseif y == "IgnoredProfessions" then
			GameTooltip:SetOwner(CraftBotOptionFrameIgnoredProfessions,"ANCHOR_BOTTOMRIGHT",CraftBotOptionFrameIgnoredProfessions:GetWidth()*-1,0)
			GameTooltip:ClearLines()
			for i=1,#(CRAFTBOT_TOOLTIP_IGNOREDPROFESSIONS) do
				GameTooltip:AddLine(CRAFTBOT_TOOLTIP_IGNOREDPROFESSIONS[i][1],CRAFTBOT_TOOLTIP_IGNOREDPROFESSIONS[i][2],CRAFTBOT_TOOLTIP_IGNOREDPROFESSIONS[i][3],CRAFTBOT_TOOLTIP_IGNOREDPROFESSIONS[i][4])
			end
	 		GameTooltip:Show()
		end
	else
		GameTooltip:Hide()
	end
end

-- =============================================================================
-- REFINE FUNCTIONS 
-- =============================================================================

function CraftBot_GetAllReagents(reagentData)
	if #(CraftBot_Data) then
		repeat
			local refine = false
			local newReagentData = {}
			for i=1,#(reagentData) do
				local _,reagentLink = GetItemInfo(reagentData[i][1])
				local tmpReagentData = CraftBot_GetReagentReagentData(reagentLink)
				if #(tmpReagentData) > 0 then
					for j=1,#(tmpReagentData) do
						local id = tmpReagentData[j][1]
						local qty = tmpReagentData[j][2] * reagentData[i][2]
						tinsert(newReagentData,{ id,qty })
					end
					refine = true
				else
					tinsert(newReagentData,reagentData[i])
				end
			end
			reagentData = newReagentData
		until not refine
	end
	return reagentData
end

function CraftBot_GetReagentReagentData(link)
	for i=1,#(CraftBot_Data) do
		if CraftBot_Searchable(i) then
			for x=1,#(CraftBot_Data[i].skills) do
				for y=1,#(CraftBot_Data[i].skills[x].data) do
					if CraftBot_Data[i].skills[x].data[y].craftLink == link then
						return CraftBot_Data[i].skills[x].data[y].reagents
					end
				end
			end
			if CraftBot_Search_Mode == PLAYER then
				break
			end
		end
	end
	return {}
end

-- =============================================================================
-- IGNORE FUNCTIONS 
-- =============================================================================

function CraftBot_IsIgnoredProfession(x)
	local profession = strupper(x)
	for i=1,#(CraftBot_IgnoredProfessions) do
		if CraftBot_IgnoredProfessions[i] == profession then
			return true
		end
	end
	return false
end

function CraftBot_SetIgnoredProfessions(x)
	CraftBot_IgnoredProfessions = {}
	if strtrim(x) ~= "" then
		x = strupper(strtrim(x))
		local delimiter = ","
		if strfind(x,delimiter) then
			local tmp = CraftBot_Split(x,delimiter)
			for i=1,#(tmp) do
				CraftBot_AddIgnoredProfession(tmp[i])
			end
		else
			CraftBot_AddIgnoredProfession(x)
		end
	end
	CraftBot_SetShoppeProfessions()
end

function CraftBot_GetIgnoredProfessions()
	local x = ""
	if #(CraftBot_IgnoredProfessions) > 0 then
		for i=1,#(CraftBot_IgnoredProfessions) do
			if i == 1 then
				x = CraftBot_IgnoredProfessions[i]
			else
				x = x..","..CraftBot_IgnoredProfessions[i]
			end
		end
	end
	CraftBotOptionFrameIgnoredProfessions:SetText(x)
end

function CraftBot_AddIgnoredProfession(x)
	if x and strtrim(x) ~= "" then
		local profession = strtrim(x)
		for i=1,#(CraftBot_IgnoredProfessions) do
			if CraftBot_IgnoredProfessions[i] == profession then
				return
			end
		end
		tinsert(CraftBot_IgnoredProfessions,profession)
		CraftBot_Print(format(CRAFTBOT_IGNOREPROFESSIONS,profession))
		for i=1,#(CraftBot_Data) do
			local skillIndex = 0
			if #(CraftBot_Data[i].skills) then
				for y=1,#(CraftBot_Data[i].skills) do
					if strupper(CraftBot_Data[i].skills[y].name) == profession then
						tremove(CraftBot_Data[i].skills,y)
						break
					end
				end
			end
		end
	end
end

-- =============================================================================
-- WHISPER FILTERING FUNCTIONS 
--
-- all whispers are stored in a temporary outgoingWhispers queue 
-- and are assigned a expiry time.
-- =============================================================================

function CraftBot_Message_Hook(event)
	if CraftBot_On and CraftBot_Silent then
		local whisper = arg1
		if event == "CHAT_MSG_WHISPER_INFORM" and CraftBot_IsOutgoingWhisper(whisper) then
			return true
		elseif event == "CHAT_MSG_WHISPER" and CraftBot_Strip(whisper,CRAFTBOT_WHISPERCMD) then
			return true
		end
	end
	return ORG_ChatFrame_Hook(event)
end

function CraftBot_IsOutgoingWhisper(text)
	-- check if input whisper is in queue
	for i=1,#(outgoingWhispers) do
		-- filter and remove matching whisper
		if outgoingWhispers[i].text == text then
			tremove(outgoingWhispers,i)
			return true
		end
	end
	return false
end

-- =============================================================================
-- WIM SUPPORT FUNCTIONS 
-- =============================================================================

function CraftBot_WIM_GetVersion()
	local version = CraftBot_Split(WIM_VERSION,".")
	return tonumber(version[1]),tonumber(version[2]),tonumber(version[3])
end

function CraftBot_WIM_OnLoad()
	local major,minor,build = CraftBot_WIM_GetVersion()
	if major == 2 and minor >= 1 then
		CraftBot_WIM_Plugin_OnLoad()
	end
end

function CraftBot_WIM_GetPlayer()
	if isWIM then
		for key,_ in pairs(WIM_Windows) do
			if WIM_Windows[key].is_visible then
				return key
			end
		end
		return nil
	end
	return nil
end

-- =============================================================================
-- WIM 2.1 PLUGIN SUPPORT FUNCTIONS 
--
-- http://www.wimaddon.com/wiki/WIM:Plugin_API
-- =============================================================================

function CraftBot_WIM_Plugin_OnLoad()
	CraftBotWIMPlugin = {
		version = "1.0.1",
		interceptInboundFunction = "CraftBot_WIM_InterceptIncoming",
		interceptOutboundFunction = "CraftBot_WIM_InterceptOutgoing"
	}
	WIM_RegisterPlugin("CraftBot Filter",CraftBotWIMPlugin,"2.1.0")
end

function CraftBot_WIM_InterceptIncoming(theUser,theMSG)
	if not (CraftBot_On and CraftBot_Silent and CraftBot_Strip(theMSG,CRAFTBOT_WHISPERCMD)) then
		WIM_PassIncomingMessage(theUser,theMSG)
	end
	return true
end

function CraftBot_WIM_InterceptOutgoing(theUser,theMSG)
	if not(CraftBot_On and CraftBot_Silent and CraftBot_IsOutgoingWhisper(theMSG)) then
		WIM_PassOutgoingMessage(theUser, theMSG)
	end
	return true
end

-- =============================================================================
-- MINIMAP FUNCTIONS 
-- =============================================================================

function CraftBot_MM_OnLoad()
	this:RegisterForClicks("LeftButtonUp","RightButtonUp")
	this:RegisterForDrag("LeftButton")
	CraftBot_MM_Move()
end

function CraftBot_MM_OnEnter()
	GameTooltip:SetOwner(Minimap,"ANCHOR_TOPRIGHT")
	GameTooltip:AddLine(CRAFTBOT_MENU.." v"..CRAFTBOT_VERSION,1,1,0)
	GameTooltip:AddLine(CraftBot_GetTooltipText(),1,1,1)
	GameTooltip:Show()
end

function CraftBot_MM_OnLeave()
	GameTooltip:Hide()
end

function CraftBot_MM_Move()
	local mmbutton = getglobal("CraftBotMiniIcon")
	if (mmbutton) then
		local xpos,ypos
		xpos = 80*cos(CraftBot_MM.position or 0)
		ypos = 80*sin(CraftBot_MM.position or 0)
		mmbutton:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-xpos,ypos-52)
	end
end

function CraftBot_MM_Drag()
	if (this.isMoving) then
		local xpos,ypos = GetCursorPosition()
		local xmin,ymin = Minimap:GetLeft() or 400, Minimap:GetBottom() or 400
		xpos = xmin-xpos/Minimap:GetEffectiveScale()+70
		ypos = ypos/Minimap:GetEffectiveScale()-ymin-70
		CraftBot_MM.position = math.deg(math.atan2(ypos,xpos))
		CraftBot_MM_Move()
	end
end

function CraftBot_MM_Moving(x)
	if (x) then
		this:StartMoving()
		this.isMoving = true
	else
		this:StopMovingOrSizing()
		this.isMoving = false
	end
end

function CraftBot_MM_Toggle(show)
	local mmbutton = getglobal("CraftBotMiniIcon")
	if (mmbutton) then
		if show then
			mmbutton:Show()
		else
			mmbutton:Hide()
		end
		CraftBot_MM.visible = show
	end
end

-- =============================================================================
-- HELP UI FUNCTIONS 
-- =============================================================================

function CraftBot_Help_Toggle()
	local f = getglobal("CraftBotHelpFrame")
	if f then
		if f:IsVisible() then
			f:Hide()
		else
			CraftBotHelpFrameScrollFrameScrollChildText:SetText(CRAFTBOT_HELP_DIALOG)
			CraftBotHelpFrameScrollFrameScrollBar:SetValue(0)
			CraftBotHelpFrameScrollFrame:UpdateScrollChildRect()
			f:Show()
		end
	end
end

-- =============================================================================
-- CLIPBOARD FUNCTIONS 
-- =============================================================================

function CraftBot_ClipBoard_Append(text)
	if clipBoardText == "" then
		clipBoardText = text
	else
		clipBoardText = clipBoardText .. "\n" .. text
	end
	CraftBotClipBoardFrameScrollFrameText:SetText(clipBoardText)
	CraftBotClipBoardFrame:Show()
	CraftBotClipBoardFrameScrollFrameText:HighlightText(0)
end

function CraftBot_ClipBoard_Clear()
	clipBoardText = ""
	CraftBotClipBoardFrameScrollFrameText:SetText("")
end

-- =============================================================================
-- MISC FUNCTIONS 
-- =============================================================================
function CraftBot_GetPlayer(user)
	local tmp = user
	if strupper(user) == "WIM" or strupper(user) == "W" then
		user = CraftBot_WIM_GetPlayer()
		if user ~= nil then
			return user
		end
	elseif strupper(user) == "TARGET" or strupper(user) == "T" then
		user = UnitName("playertarget")
		if user ~= nil then
			return user
		end
	end
	return tmp
end

function CraftBox_GetSkillIndex(skillName)
	local skillIndex = 0
	if #(CraftBot_Data[currPlayerIndex].skills) then
		for i=1,#(CraftBot_Data[currPlayerIndex].skills) do
			if CraftBot_Data[currPlayerIndex].skills[i].name == skillName then
				skillIndex = i
				CraftBot_Data[currPlayerIndex].skills[i].level = currentLevel
				break
			end
		end
	end
	if skillIndex == 0 then
		local skillNew = {
			["name"] = skillName,
			["level"] = currentLevel,
			["data"] = {}
		}
		tinsert(CraftBot_Data[currPlayerIndex].skills,skillNew)
		skillIndex = #(CraftBot_Data[currPlayerIndex].skills)
	end
	return skillIndex
end

function CraftBot_CheckHolidays(user)
	local day,month = tonumber(date("%d")),tonumber(date("%m"))
	for i=1,#(CraftBot_Holidays) do
		for x = 1,#(CraftBot_Holidays[i].dates) do
			if month == CraftBot_Holidays[i].dates[x][1] and day == CraftBot_Holidays[i].dates[x][2] then
				CraftBot_SendChat(user,CraftBot_Holidays[i].greetings)
				return
			end
		end
	end
end

function CraftBot_GetDotFormat(msg)
	if strfind(msg,"|Hitem:") then
		for i=1,#(CraftBot_Data) do
			if CraftBot_Searchable(i) then
				for x=1,#(CraftBot_Data[i].skills) do
					for y=1,#(CraftBot_Data[i].skills[x].data) do
						if CraftBot_GetItemID(CraftBot_Data[i].skills[x].data[y].craftLink) == CraftBot_GetItemID(msg) then
							return true,i,x,y
						end
					end
				end
				if CraftBot_Search_Mode == PLAYER then
					break
				end
			end
		end
	elseif strfind(msg,"|Henchant:") then
		for i=1,#(CraftBot_Data) do
			if CraftBot_Searchable(i) then
				for x=1,#(CraftBot_Data[i].skills) do
					for y=1,#(CraftBot_Data[i].skills[x].data) do
						if CraftBot_GetEnchantID(CraftBot_Data[i].skills[x].data[y].recipeLink) == CraftBot_GetEnchantID(msg) then
							return true,i,x,y
						end
					end
				end
				if CraftBot_Search_Mode == PLAYER then
					break
				end
			end
		end
	else
		for i=1,#(CraftBot_Data) do
			if CraftBot_Searchable(i) then
				for x=1,#(CraftBot_Data[i].skills) do
					for y=1,#(CraftBot_Data[i].skills[x].data) do
						local craftText,craftDesc = CraftBot_Data[i].skills[x].data[y].craftName..",".. CraftBot_Data[i].skills[x].data[y].craftLink,CraftBot_Data[i].skills[x].data[y].craftDesc
						if craftDesc ~= nil and craftDesc ~= "" then
							craftText = craftText..", "..craftDesc
						end
						if CraftBot_MatchStrings(strlower(craftText),gsub(gsub(msg," ",","),",,",","),",") then
							return true,i,x,y
						end
					end
				end
				if CraftBot_Search_Mode == PLAYER then
					break
				end
			end
		end
	end
	return false
end

function CraftBot_Searchable(i)
	local _,localFac = UnitFactionGroup("player")
	if CraftBot_Search_Mode == REALM and CraftBot_Data[i].realm == GetRealmName() then
		if not CraftBot_Search_Mode_Faction or (CraftBot_Search_Mode_Faction and CraftBot_Data[i].faction == localFac) then
			return true
		end
	elseif CraftBot_Search_Mode == PLAYER and i == currPlayerIndex then
		return true
	elseif CraftBot_Search_Mode == XREALM then
		if not CraftBot_Search_Mode_Faction or (CraftBot_Search_Mode_Faction and CraftBot_Data[i].faction == localFac) then
			return true
		end
	end
	return false
end

function CraftBot_IsClipboard(user)
	local destination = strlower(user)
	if destination == "clipboard" or destination == "c" then
		return true
	end
	return false
end

function CraftBot_SendChat(user,text)
	local destination = strlower(user)
	local channel = "WHISPER"
	if (not isDebug) and destination == strlower(UnitName("player")) then
		CraftBot_Print(text)
	elseif CraftBot_IsClipboard(destination) then
		CraftBot_ClipBoard_Append(text)
	else
		if destination == "guild" or destination == "g" then
			channel = "guild"
		elseif destination == "say" or destination == "s" then
			channel = "say"
		elseif destination == "yell" or destination == "y" then
			channel = "yell"
		elseif destination == "party" or destination == "p" then
			channel = "party"
		elseif destination == "raid" or destination == "r" then
			channel = "raid"
		elseif destination == "officer" or destination == "o" then
			channel = "officer"
		end
		local messages = CraftBot_SplitLongMessage(text,255)
		if channel ~= "WHISPER" then
			destination = nil
		end
		for i=1,#(messages) do
			if CraftBot_Silent then
				local whisper = {}
				whisper.time = GetTime() + WHISPER_EXPIRY_TIME
				whisper.text = messages[i]
				tinsert(outgoingWhispers,whisper)
			end
			ChatThrottleLib:SendChatMessage("BULK",CRAFTBOT_MENU,messages[i],channel,DEFAULT_LANGUAGE,destination)
		end
	end
end

function CraftBot_Strip(x,y)
	if x and y then
		local temp = strtrim(x)
		local p,n = strfind(strlower(temp),strlower(y),1,true)
		if p and p == 1 and n then
			return strtrim(strsub(temp,n+1,strlen(temp)))
		end
	end
	return nil
end

-- Functions from Styler
-- returns the ItemID from an intemLink
function CraftBot_GetItemID(itemLink)
	if itemLink ~= nil and itemLink ~= "" then
		local found,_,itemString = strfind(itemLink,"^|%x+|H(.+)|h%[.+%]")
		if found ~= nil then
			local found,_,itemId = strfind(itemString,"^item:(%d+):(%d+):(%d+):(%d+):(%d+):(%d+):(%-?%d+):(%-?%d+)")
			if found ~= nil then
				return tonumber(itemId)
			end
		end
	end
	return 0
end

function CraftBot_GetEnchantID(x)
	if x ~= nil and x ~= "" then
		local found,_,y = strfind(x,"^|%x+|H(.+)|h%[.+%]")
		if found ~= nil then
			local found,_,enchantId = strfind(y,"^enchant:(%d+)")
			if found ~= nil then
				return tonumber(enchantId)
			end
		end
	end
	return 0
end

function CraftBot_GetItemLevel(x)
	if x ~= nil and x ~= "" then
		local itemName,_,_,_,itemMinLevel = GetItemInfo(x) 
		if itemName then
			return tonumber(itemMinLevel) or 0
		end
	end
	return -1
end

function CraftBot_GetLevelReq(text)
	local found,_,l1,l2 = strfind(text,"[L|l](%d+)\-(%d+)")
	if not found then
		found,_,l1 = strfind(text,"[L|l](%d+)\+")
		if not found then
			found,_,l2 = strfind(text,"[L|l](%d+)\-")
			if not found then
				found,_,l2 = strfind(text,"[L|l](%d+)")
				if found then
					text = strtrim(gsub(text,"[L|l](%d+)",""))
				end
			else
				text = strtrim(gsub(text,"[L|l](%d+)\-",""))
			end
		else
			text = strtrim(gsub(text,"[L|l](%d+)\+",""))
		end
	else
		text = strtrim(gsub(text,"[L|l](%d+)\-(%d+)",""))
	end
	if found then
		l2 = tonumber(l2)
		l1 = tonumber(l1)
		if l1 and l2 then
			if l1 > l2 then
				return true,text,l2,l1
			else
				return true,text,l1,l2
			end
		elseif l1 then
			return true,text,l1,MAX_LEVEL
		elseif l2 then
			if l2 >= DIFF_LEVEL then
				l1 = l2 - DIFF_LEVEL
			else
				l1 = MIN_LEVEL
			end
			return true,text,l1,l2
		end
	end
	return false,text,0,0
end

function CraftBot_GetItemDescriptionFromTooltip(itemlink)
	local desc = {}
	local found,_,itemString = strfind(itemlink,"^|%x+|H(.+)|h%[.+%]")
	if (found) then
		CrafBotScanningTooltip:SetOwner(CraftBot,"ANCHOR_NONE")
		CrafBotScanningTooltip:ClearLines()
		CrafBotScanningTooltip:SetHyperlink(itemString)
		if (CrafBotScanningTooltip:NumLines() >= 3) then
			for l=2,CrafBotScanningTooltip:NumLines(),1 do
				local tttext = getglobal("CrafBotScanningTooltipTextLeft"..l):GetText()
				if (tttext ~= "") then tinsert(desc,tttext) end
			end
		end
	end
	return table.concat(desc,", ")
end

function CraftBot_MatchStrings(haystack,needle,sep)
	local found = true
	local needleArray = CraftBot_Split(needle,sep)
	if strfind(haystack,sep,1,true) then
		local needleArray = CraftBot_Split(needle,sep)
		for i=1,#(needleArray),1 do
			if not strfind(haystack,strtrim(needleArray[i]),1,true) then
				return nil
			end
		end
	else
		found = strfind(haystack,needle,1,true)
	end
	return found
end

-- Split a string into an array of strings by specified delimiter
function CraftBot_Split(text,separator)
	if type(text) ~= "string" or text == "" then
		return {}
	else
		if strfind(text,separator) then
			return { strsplit(separator,text) }
		else
			return { text }
		end
	end
end

-- Split a string into an array of strings no longer then specified length
function CraftBot_SplitLongMessage(text,length)
	if type(text) ~= "string" or text == "" then
		return {}
	else
		local messages = {}
		while text ~= "" do
			local textLength = strlen(text)
			if textLength > length then
				tinsert(messages,strsub(text,1,length))
				text = strsub(text,length + 1,strlen(text))
			else
				tinsert(messages,text)
				text = ""
			end
		end
		return messages
	end
end

function CraftBot_Print(x)
	if not isOnlyBot then
		x = "|cFFFFFF99"..CRAFTBOT_MENU..":|r "..x
	end
	DEFAULT_CHAT_FRAME:AddMessage(x)
end

function CraftBot_Debug(x)
	if isDebug then
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFF0000Debug:|r "..x)
	end
end
