local ControlArena, self = ControlArena, ControlArena
local SharedMedia = Rock("LibSharedMedia-3.0")
local LC = Rock("LibBabble-Class-3.0"):GetUnstrictLookupTable()
local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("ControlArena")
local new, del =  Rock:GetRecyclingFunctions("ControlArena", "newList", "del")

local function newHealthBar(i, parent)
	local unit = CreateFrame("Frame", "ctaf"..i, parent)
    -- set values
    unit.values = new()
    unit.values.class = ""
    unit.values.name = ""
    unit.values.health = 100
    unit.values.status = ""
    unit.values.energy = 100
    unit.values.powertype = 0
    
    -- class icon
    local portraitType = self.db.profile.layout.class_icon.portrait
    if portraitType == "class" then
        local class = CreateFrame("Button", "ctaf"..i.."class", unit, "SecureActionButtonTemplate")
        class:EnableMouse(true)
        class:RegisterForClicks("LeftButtonUp")
        class:SetAttribute("type1", "macro")
        class:SetNormalTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes")
        class:SetPushedTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes")
        class:SetHighlightTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes")
        unit.class = class
    elseif portraitType == "2D" then
        local class = CreateFrame("Button", "ctaf"..i.."class", unit, "SecureActionButtonTemplate")
        unit.class = class
        class:EnableMouse(true)
        class:RegisterForClicks("LeftButtonUp")
        class:SetAttribute("type1", "macro")
        class:SetNormalTexture("Interface\\CharacterFrame\\INV_Misc_QuestionMark")
        
        local portraitBG = class:CreateTexture(nil, "BACKGROUND")
        unit.class.bg = portraitBG
        portraitBG:SetTexture(0, 0, 0, 1)
		portraitBG:SetAllPoints(class)        
    elseif portraitType == "3D" then
        local class = CreateFrame("Button", "ctaf"..i.."class", unit, "SecureActionButtonTemplate")
        unit.class = class
        class:EnableMouse(true)
        class:RegisterForClicks("LeftButtonUp")
        class:SetAttribute("type1", "macro")
        
        local classportrait = CreateFrame("PlayerModel", "ctap"..i.."p", class)
        unit.class.classportrait = classportrait
        classportrait:SetAllPoints(class)
        
		local portraitBG = classportrait:CreateTexture(nil, "BACKGROUND")
		unit.class.bg = portraitBG
		portraitBG:SetTexture(0, 0, 0, 1)
		portraitBG:SetAllPoints(classportrait)
    end
    
    -- healthbar
    local healthbar = CreateFrame("StatusBar", "ctaf"..i.."h", unit)
	unit.healthbar = healthbar
	healthbar:SetMinMaxValues(0, 100)
	texture = SharedMedia:Fetch('statusbar', self.db.profile.layout.health_bar.texture)
	healthbar:SetStatusBarTexture(texture)
    r, g, b = unpack(self.colors.alive)
	healthbar:SetStatusBarColor(r, g, b, 1)
	
	local healthBG = healthbar:CreateTexture("ctaf"..i.."hTexture", "BACKGROUND")
	unit.healthbar.bg = healthBG
	healthBG:SetTexture(texture)
    r, g, b = unpack(self.colors.vertex)
	healthBG:SetVertexColor(r, g, b, 1)
    
    -- manabar
    local manabar = CreateFrame("StatusBar", "ctaf"..i.."m", unit)
	unit.manabar = manabar
	manabar:SetMinMaxValues(0, 100)
	local texture = SharedMedia:Fetch('statusbar', self.db.profile.layout.mana_bar.texture)
	manabar:SetStatusBarTexture(texture)
    r, g, b = unpack(self.colors.rage)
	manabar:SetStatusBarColor(r, g, b, 1)
	
	local manabarBG = manabar:CreateTexture("ctaf"..i.."mTexture", "BACKGROUND")
	unit.manabar.bg = manabarBG
	manabarBG:SetTexture(texture)
    r, g, b = unpack(self.colors.vertex)
	manabarBG:SetVertexColor(r, g, b, 1)
    
    local font
    
    -- name
    local mana = manabar:CreateFontString(nil, "OVERLAY")
	unit.mananame = mana
    mana:SetFontObject(GameFontHighlightSmall)
    if self.db.profile.layout.mana_bar.font and self.db.profile.layout.mana_bar.font ~= "" then
        font = SharedMedia:Fetch('font', self.db.profile.layout.mana_bar.font)
        mode = self.db.profile.layout.mana_bar.fontmode
        mana:SetFont(font, self.db.profile.layout.mana_bar.fontsize * 1.5, mode)
    end
	mana:SetPoint("RIGHT", unit.manabar, "RIGHT", -5, 0)
	mana:SetJustifyH("RIGHT")
    
    -- castingbar
    local castingbar = CreateFrame("StatusBar", "ctaf"..i.."c", unit)
	unit.castingbar = castingbar
	castingbar:SetMinMaxValues(0, 1)
    castingbar:SetValue(0)
	local texture = SharedMedia:Fetch('statusbar', self.db.profile.layout.cast_bar.texture)
	castingbar:SetStatusBarTexture(texture)
    r, g, b = unpack(self.colors.casting.casting)
	castingbar:SetStatusBarColor(r, g, b, 1)
	
	local castingbarBG = castingbar:CreateTexture("ctaf"..i.."cTexture", "BACKGROUND")
	unit.castingbar.bg = castingbarBG
	castingbarBG:SetTexture(texture)
    r, g, b = unpack(self.colors.vertex)
	castingbarBG:SetVertexColor(r, g, b, 1)
    
    local castname = castingbar:CreateFontString(nil, "OVERLAY")
	unit.castname = castname
    castname:SetFontObject(GameFontHighlightSmall)
    if self.db.profile.layout.cast_bar.font and self.db.profile.layout.cast_bar.font ~= "" then
        font = SharedMedia:Fetch('font', self.db.profile.layout.cast_bar.font)
        mode = self.db.profile.layout.cast_bar.fontmode
        castname:SetFont(font, self.db.profile.layout.cast_bar.fontsize * 1.5, mode)
    end
	castname:SetPoint("LEFT", unit.castingbar, "LEFT", 5, 0)
	castname:SetJustifyH("LEFT")
    
    local casticon = CreateFrame("Button", "ctaf"..i.."casticon", unit)
    casticon:SetNormalTexture("Interface\\Icons\\INV_Misc_QuestionMark")
    unit.castingicon = casticon
    
    -- name
    local name = healthbar:CreateFontString(nil, "OVERLAY")
	unit.name = name
    name:SetFontObject(GameFontHighlightSmall)
    if self.db.profile.layout.health_bar.font and self.db.profile.layout.health_bar.font ~= "" then
        font = SharedMedia:Fetch('font', self.db.profile.layout.health_bar.font)
        mode = self.db.profile.layout.health_bar.fontmode
        name:SetFont(font, self.db.profile.layout.health_bar.fontsize * 1.5, mode)
    end
	name:SetPoint("LEFT", unit.healthbar, "LEFT", 5, 0)
	name:SetJustifyH("LEFT")
	
	local overlay = CreateFrame("Button", "ctaf"..i.."overlay", unit.healthbar, "SecureActionButtonTemplate")
	overlay:EnableMouse(true)
	overlay:RegisterForClicks("LeftButtonUp")
	overlay:SetAttribute("type1", "macro")
	unit.overlay = overlay
    
    local combat_text = overlay:CreateFontString(nil, "OVERLAY")
	unit.combat_text = combat_text
    combat_text:SetFontObject(GameFontHighlightSmall)
    if self.db.profile.layout.combat_text.font and self.db.profile.layout.combat_text.font ~= "" then
        font = SharedMedia:Fetch('font', self.db.profile.layout.combat_text.font)
        mode = self.db.profile.layout.combat_bar.fontmode
        combat_text:SetFont(font, self.db.profile.layout.combat_text.fontsize * 1.5, mode)
    end
	combat_text:SetPoint("CENTER", unit.overlay, "CENTER", 0, 0)
	combat_text:SetJustifyH("CENTER")
    combat_text:SetText("plop")
    combat_text:Hide()
	
	local btn = CreateFrame("Button", "ctaf"..i.."btn", unit, "SecureActionButtonTemplate")
	unit.button = btn
	btn:EnableMouse(true)
	btn:RegisterForClicks("LeftButtonUp", "RightButtonUp")
	btn:SetAttribute("*type*", "macro")
    
    unit:SetAlpha(0)
    
    return unit
end

local function getSize(fw, fh, fx, fy, w, h, x, y)
    if fw < x + w then
        fw = x + w
    end
    if fh < math.abs(y) + h then
        fh = math.abs(y) + h
    end
    if fx > x then
        fx = x
    end
    if fy > y then
        fy = y
    end
    
    return fw, fh, fx, fy
end

local function refreshHealthBar(index)
    local options = self.db.profile.layout

    local frame = self.frame.frames[index]
    
    local fx, fy, fw, fh = 0, 0, 0, 0        
    local x, y, w, h
    
    if options.class_icon.enabled then
        x, y, w, h = options.class_icon.x, options.class_icon.y, options.class_icon.w, options.class_icon.h
        
        frame.class:ClearAllPoints()
        frame.class:SetPoint("TOPLEFT", frame, "TOPLEFT", x, y)
        frame.class:SetWidth(w)
        frame.class:SetHeight(h)
        frame.class:SetAlpha(1)
        
        fh = math.abs(y) + h
        fw = w + x
        fx = x
        fy = y
    else
        frame.class:SetAlpha(0)
    end
    
    x, y, w, h = options.health_bar.x, options.health_bar.y, options.health_bar.w, options.health_bar.h
    fw, fh, fx, fy = getSize(fw, fh, fx, fy, w, h, x, y)
    
    frame.healthbar:SetWidth(w)
    frame.healthbar:SetHeight(h)
    frame.healthbar.bg:SetWidth(w)
    frame.healthbar.bg:SetHeight(h)
    frame.overlay:ClearAllPoints()
    frame.overlay:SetAllPoints(frame.healthbar)
        
    frame.healthbar:ClearAllPoints()
    frame.healthbar:SetPoint("TOPLEFT", frame, "TOPLEFT", x, y)
    frame.healthbar.bg:ClearAllPoints()
    frame.healthbar.bg:SetAllPoints(frame.healthbar)
    
    -- manabar
    if options.mana_bar.enabled then
        x, y, w, h = options.mana_bar.x, options.mana_bar.y, options.mana_bar.w, options.mana_bar.h
        fw, fh, fx, fy = getSize(fw, fh, fx, fy, w, h, x, y)
        
        frame.manabar:SetWidth(w)
        frame.manabar:SetHeight(h)
        frame.manabar.bg:SetWidth(w)
        frame.manabar.bg:SetHeight(h)
        
        frame.manabar:ClearAllPoints()
        frame.manabar:SetPoint("TOPLEFT", frame, "TOPLEFT", x, y)
        frame.manabar.bg:ClearAllPoints()
        frame.manabar.bg:SetAllPoints(frame.manabar)
        frame.manabar:SetAlpha(1)
    else
        frame.manabar:SetAlpha(0)
    end
    
    -- castbar
    if options.cast_bar.enabled then
        x, y, w, h = options.cast_bar.x, options.cast_bar.y, options.cast_bar.w, options.cast_bar.h
        fw, fh, fx, fy = getSize(fw, fh, fx, fy, w, h, x, y)
        
        local casticonx, castincony, casticonsize = x, y, h
        x = x + h
        w = w - h
        
        frame.castingbar:SetWidth(w)
        frame.castingbar:SetHeight(h)
        frame.castingbar.bg:SetWidth(w)
        frame.castingbar.bg:SetHeight(h)
        
        frame.castingbar:ClearAllPoints()
        frame.castingbar:SetPoint("TOPLEFT", frame, "TOPLEFT", x, y)
        frame.castingbar.bg:ClearAllPoints()
        frame.castingbar.bg:SetAllPoints(frame.castingbar)
        
        frame.castingicon:SetWidth(casticonsize)
        frame.castingicon:SetHeight(casticonsize)
        frame.castingicon:SetPoint("TOPLEFT", frame, "TOPLEFT", casticonx, castincony)
        
        frame.castingbar:Hide()
        frame.castingicon:Hide()
    end
    
    -- button
    if options.spell_icon.enabled and (self.db.profile.macro.left.enabled or self.db.profile.macro.right.enabled) then
        x, y, w, h = options.spell_icon.x, options.spell_icon.y, options.spell_icon.w, options.spell_icon.h
        fw, fh, fx, fy = getSize(fw, fh, fx, fy, w, h, x, y)
    
        frame.button:ClearAllPoints()
        frame.button:SetPoint("TOPLEFT", frame, "TOPLEFT", x, y)
        frame.button:SetWidth(w)
        frame.button:SetHeight(h)
        frame.button:SetAlpha(1)
    else
        frame.button:SetAlpha(0)
    end
    
    frame:SetWidth(fw)
    frame:SetHeight(fh)
    
    return fw, fh, fx, fy
end

function ControlArena:BuildFrame()
    local f = CreateFrame("Frame", "ctaf", UIParent)
	f:SetMovable(true)
	f:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", self.db.profile.size.x, self.db.profile.size.y)
	f:SetClampedToScreen(true)
	self.frame = f
    
    local t = CreateFrame("Button", "ctaft", self.frame)
	t:EnableMouse(true)
	t:SetHeight(16)
	t:SetPoint("TOP", self.frame, "TOP", 0, 0)
	t:SetScript("OnMouseUp", function() 
		if this:GetParent().isMoving then
			this:GetParent():StopMovingOrSizing()
			self.db.profile.size.x = this:GetParent():GetLeft()
			self.db.profile.size.y = this:GetParent():GetTop()
			this:GetParent().isMoving = false
		end
	end)
	t:SetScript("OnMouseDown", function()
		if not self.db.profile.size.lock and arg1 == "LeftButton" and not InCombatLockdown() then
			this:GetParent():StartMoving()
			this:GetParent().isMoving = true
		end
	end)
	self.frame.title = t
	
	local text = t:CreateFontString(nil, "ARTWORK")
    text:SetFontObject(GameFontHighlightSmall)
    if self.db.profile.font.name and self.db.profile.font.name ~= "" then        
        local font = SharedMedia:Fetch('font', self.db.profile.font.name)
        text:SetFont(font, self.db.profile.font.size * 1.5)
    end
	text:SetJustifyH("CENTER")
	text:SetJustifyV("BOTTOM")
	text:SetHeight(12)
	text:SetPoint("TOP", self.frame.title, "TOP", 0, -5)
	self.frame.text = text
	text:SetText(self.name)
    
    if self.db.profile.size.lock then
		t:Hide()
	end

    self.frame.frames = {}
	for i=1, 5 do
		self.frame.frames[i] = newHealthBar(i, self.frame)
	end
    
	self:RefreshFrame()
end

function ControlArena:RefreshFrame()
    if not self.frame then return end
    
    local alignment = self.db.profile.layout.alignment
    
    local w, h
    local n = 0
    for i=1, 5 do
        if self.frame.frames[i] then
            w, h, x, y = refreshHealthBar(i)            
            n = n + 1
            
            if alignment == "VERTICAL" then
                if i == 1 then
                    self.frame.frames[i]:SetPoint("TOPLEFT", self.frame.title, "BOTTOMLEFT", 0, 0)
                else
                    self.frame.frames[i]:SetPoint("TOPLEFT", self.frame.frames[i - 1], "BOTTOMLEFT", 0, -5)
                end
            else
                if i == 1 then
                    self.frame.frames[i]:SetPoint("TOPLEFT", self.frame.title, "BOTTOMLEFT", 0, 0)
                else
                    self.frame.frames[i]:SetPoint("TOPLEFT", self.frame.frames[i - 1], "TOPRIGHT", 5, 0)
                end
            end
        end
    end
    
    if alignment == "VERTICAL" then
        h = (h + 7) * n
    else
        w = (w + 7) * n
    end
    self.frame:SetWidth(w)
    self.frame:SetHeight(h)
    
    self.frame.title:SetWidth(w)
	self.frame.text:SetWidth(w)
    self.frame:SetScale(self.db.profile.size.scale)
end

--[[ create a macro ]]
local function createMacro(t, name, class, db)
    
	local spell = ""
	if db.profile.macro[t].enabled then
		if db.profile.macro[t].is_spell then
			spell = db.profile.macro[t].spell
		elseif db.profile.macro[t].is_spell_class then
			spell = db.profile.macro[t].spell_class[class]
		end
	end

	if spell and spell ~= "" then		
        if db.profile.macro[t].is_macro then
            local macro = string.gsub(string.gsub(string.gsub(spell, "%%n", name), ";", "\n"), "\\n", "\n")
            local spellID = 0
            local texture
            repeat
                spellID = spellID + 1
                spellName = GetSpellName(spellID, BOOKTYPE_SPELL)
                if not spellName then do break end end
                if strfind(macro, spellName) then
                    texture = GetSpellTexture(spellID, BOOKTYPE_SPELL)
                end
            until texture
            
            if not texture then
                texture = [[Interface\Icons\Ability_Rogue_BloodyEye]]
            end
            return macro, texture
        else
            local spellID = 0
            repeat
                spellID = spellID + 1
                spellName = GetSpellName(spellID, BOOKTYPE_SPELL)
                if not spellName then do break end end
            until spellName == spell
            
            local texture = GetSpellTexture(spellID, BOOKTYPE_SPELL)
            local macro = ("/target [target=%s]\n/cast %s"):format(name, spell)
            if db.profile.macro[t].targetlasttarget then
                macro = macro .. "\n/targetlasttarget"
            end
            return macro, texture
        end
	end
end

function ControlArena:ResetHealthBar(index)
	local frame = self.frame.frames[index]

    frame:SetAlpha(0)
	frame.in_combat = nil
    frame.values = new()
    frame.values.class = ""
    frame.values.name = ""
    frame.values.health = 100
    frame.values.status = ""
    frame.values.energy = 100
    frame.values.powertype = 0
    
    frame.castinginfo = nil
    if frame.castingbar and frame.castingbar:IsShown() then
        frame.castingbar:Hide()
    end
    
    frame.have_portrait = nil
end

local function getColorClass(classe)
	if not classe or classe == "" then classe = "PRIEST" end
	return RAID_CLASS_COLORS[strupper(classe)]
end

local function getLocalizedClass(class)
    local c = class:sub(1, 1) .. class:sub(2):lower()
	return LC[c]
end

local function getColorizedText(life, text)
	if not self.db.profile.colorized_life then
		return text
	else
		if life == 0 then
			return ("|cff%02x%02x%02x%s|r"):format(153, 153, 153, text)
		else
			-- code from dogtag
			local minHP = { 1, 0, 0 }
			local midHP = { 1, 1, 0 }
			local maxHP = { 0, 1, 0 }
		
			local perc = life / 100
			local r1, g1, b1
			local r2, g2, b2
			if perc <= 0.5 then
				perc = perc * 2
				r1, g1, b1 = unpack(minHP)
				r2, g2, b2 = unpack(midHP)
			else
				perc = perc * 2 - 1
				r1, g1, b1 = unpack(midHP)
				r2, g2, b2 = unpack(maxHP)
			end
			local r, g, b = r1 + (r2-r1)*perc, g1 + (g2-g1)*perc, b1 + (b2-b1)*perc
			return ("|cff%02x%02x%02x%s|r"):format(r * 255, g * 255, b * 255, text)	
		end
	end
end

local function getColorPowerType(powertype)
    local r, g, b
    if powertype == 1 then
        r, g, b = unpack(self.colors.rage)
    elseif powertype == 3 then
        r, g, b = unpack(self.colors.energy)
    else
        r, g, b = unpack(self.colors.mana)
    end
    return r, g, b
end

local function getUnitTooltipText(index)
    local frame = self.frame.frames[index]
    if not frame then return end
    local values = frame.values

    local name, class = values.name, values.class
    if not name or not class or class == "" then return nil end
    
    local health, status = values.health, values.status
    local infos
    if status == "DEAD" then
        infos = "\n" .. getColorizedText(0, ("%s"):format(L["DEAD"]))
    else
        local energy, powertype = values.energy, values.powertype
        local r, g, b = getColorPowerType(powertyp)
        
        infos = "\n" .. getColorizedText(health, ("%d %%"):format(health)) .. ("\n|cff%02x%02x%02x%d %%|r"):format(r * 255, g * 255, b * 255, energy)
    end
    
    local col = self.classColors[values.class]
    if not col then col = "ffffff" end
    class = LC[class:sub(1, 1) .. class:sub(2):lower()]
    
		local t = ("|cff%s%s|r\n|cff%s%s|r%s"):format(col, name, col, class, infos)
    return t
end

local function updateTooltip(index)
    local frame = self.frame.frames[index]
	if not frame then return end
    
    if GameTooltip:IsShown() and GameTooltip:IsOwned(frame.overlay) then
        local text = getUnitTooltipText(index)
        if text then
            GameTooltip:SetText(text)
        end
    end
end

function ControlArena:RefreshHealthBarOutCombatLock(index)
    local frame = self.frame.frames[index]
	if not frame or not frame.values.name or frame.values.name == "" then return end
    
    guy = frame.values
    frame.have_portrait = nil
    self:AssignHealthBar(index, guy)
end

local function updateManaBar(index, name, energy, powertype)
    if not self.db.profile.layout.mana_bar.enabled then return end
    local frame = self.frame.frames[index]
	if not frame then return end
    
    if frame.values.status and frame.values.status == "DEAD" then
        frame.manabar:SetValue(0)
        if self.db.profile.layout.mana_bar.text then
            local t = getColorizedText(0, ("%d %%"):format(0))
            frame.mananame:SetText(t)
        else
            frame.mananame:SetText("")
        end
        return
    end
    
    frame.values.powertype = powertype
    frame.values.energy = energy
    
    local r, g, b = getColorPowerType(frame.values.powertype)
    frame.manabar:SetStatusBarColor(r, g, b, 1)
    br, bg, bb = (r+0.2)/3, (g+0.2)/3, (b+0.2)/3
	frame.manabar.bg:SetVertexColor(br, bg, bb, 1)	
    
    frame.manabar:SetValue(frame.values.energy)
    
    if self.db.profile.layout.mana_bar.text then
        local t = getColorizedText(frame.values.energy, ("%d %%"):format(frame.values.energy))
        frame.mananame:SetText(t)
    else
        frame.mananame:SetText("")
    end
    
    updateTooltip(index)
end

local function setUnitTooltip(index)
    local frame = self.frame.frames[index]
	if not frame then return end
    
    local i = index
    frame.overlay:SetScript("OnEnter", function()
        local show = self.db.profile.tooltip
        if show == "NEVER" then return end
        
        if show == "ALWAYS" or (show == "OUTOFCOMBAT" and not InCombatLockdown()) then
            GameTooltip:SetOwner(this, "ANCHOR_RIGHT")
            local text = getUnitTooltipText(i)
            if text then
                GameTooltip:SetText(text)
            end
        end
    end)
    frame.overlay:SetScript("OnLeave", function() GameTooltip:Hide() end)
end

local function updateTalentsBar(index, name, talent)
    local frame = self.frame.frames[index]
	if not frame then return end

    frame.values.talent = talent
    updateTooltip(index)
end

local function updateCastingBar(index, cast, status, channeling, startTime, endTime, icon)
    if not self.db.profile.layout.cast_bar.enabled then return end
    local frame = self.frame.frames[index]
	if not frame then return end
        
    if status == "start" then
        local casting = new()
        casting.channeling = channeling
        casting.casting = not channeling
        casting.spell = cast
        casting.startTime = startTime * 0.001
        casting.endTime = endTime * 0.001
        
        if icon then
            frame.castingicon:SetNormalTexture(icon)
        end
        
        frame.castingbar:SetMinMaxValues(casting.startTime, casting.endTime)
        
        if channeling then
            frame.castingbar:SetValue(casting.startTime + casting.endTime - GetTime())
        else
            frame.castingbar:SetValue(GetTime())
        end
        
        frame.castinginfo = casting
        
        local r, g, b
        if channeling then
            r, g, b = unpack(self.colors.casting.channeling)
        else
            r, g, b = unpack(self.colors.casting.casting)
        end
        
        frame.castingbar:SetStatusBarColor(r, g, b, 1)
        br, bg, bb = (r+0.2)/3, (g+0.2)/3, (b+0.2)/3
        frame.castingbar.bg:SetVertexColor(br, bg, bb, 1)
        
        frame.castingbar:Show()
        frame.castingbar:SetAlpha(1)
        
        frame.castingicon:Show()
        frame.castingicon:SetAlpha(1)
    elseif status == "stop" then
        if not frame.castinginfo then return end
        
        if (frame.castinginfo.casting and not channeling) or (frame.castinginfo.channeling and channeling) then
            frame.castinginfo.channeling = nil
            frame.castinginfo.casting = nil
            frame.castinginfo.fadeout = true
            frame.castinginfo.endTime = endTime
            frame.castinginfo.cast = cast
            
            local r, g, b = unpack(self.colors.casting.complete)
            frame.castingbar:SetStatusBarColor(r, g, b, 1)
            br, bg, bb = (r+0.2)/3, (g+0.2)/3, (b+0.2)/3
            frame.castingbar.bg:SetVertexColor(br, bg, bb, 1)
            frame.castingbar:SetMinMaxValues(0.0, 1.0)
            frame.castname:SetText(cast)
        end
    elseif status == "break" then
        if not frame.castinginfo then return end
        
        frame.castinginfo.channeling = nil
        frame.castinginfo.casting = nil
        frame.castinginfo.fadeout = true
        frame.castinginfo.endTime = endTime
        frame.castinginfo.cast = cast
        
        local r, g, b = unpack(self.colors.casting.fail)
        frame.castingbar:SetStatusBarColor(r, g, b, 1)
        br, bg, bb = (r+0.2)/3, (g+0.2)/3, (b+0.2)/3
        frame.castingbar.bg:SetVertexColor(br, bg, bb, 1)
        frame.castingbar:SetMinMaxValues(0.0, 1.0)
        frame.castname:SetText(cast)
    elseif status == "update" then
        if not frame.castinginfo then return end
        
        frame.castinginfo.channeling = channeling
        frame.castinginfo.casting = not channeling
        frame.castinginfo.spell = cast
        frame.castinginfo.startTime = startTime * 0.001
        frame.castinginfo.endTime = endTime * 0.001
        
        frame.castingbar:SetMinMaxValues(frame.castinginfo.startTime, frame.castinginfo.endTime)
    end
end

local function fakeCastingBar(index, spell, channeling, act, max)
    local frame = self.frame.frames[index]
	if not frame then return end
    
    frame.castingbar:SetMinMaxValues(0, max)
    frame.castingbar:SetValue(act)
        
    local r, g, b
    if channeling then
        r, g, b = unpack(self.colors.casting.channeling)
    else
        r, g, b = unpack(self.colors.casting.casting)
    end
        
    frame.castingbar:SetStatusBarColor(r, g, b, 1)
    br, bg, bb = (r+0.2)/3, (g+0.2)/3, (b+0.2)/3
    frame.castingbar.bg:SetVertexColor(br, bg, bb, 1)
    
    if self.db.profile.layout.cast_bar.text then
        frame.castname:SetText(spell)
    end
    
    frame.castingbar:Show()
end

function ControlArena:FakeCastingBar(show, name, spell, channeling, act, max)
    if show then
        for i=1, #self.list do
            if self.list[i] and self.list[i].name == name then
                fakeCastingBar(i, spell, channeling, act, max)
            end
        end
    else
        for i=1, 5 do
            if self.frame.frames[i] and self.frame.frames[i].castingbar:IsShown() then
                self.frame.frames[i].castingbar:Hide()
                self.frame.frames[i].castname:SetText("")
            end
        end
    end
end

local function updateHealthBar(index, name, health, status, force)
    local frame = self.frame.frames[index]
	if not frame then return end
    
    if force and frame.values.status and frame.values.status == "DEAD" then
        frame.values.status = ""
    end
    
    if frame.values.status and frame.values.status == "DEAD" then
        if not frame.manabar:GetValue() == 0 then
            frame.manabar:SetValue(0)
        end
        if not frame.healthbar:GetValue() == 0 then
            frame.healthbar:SetValue(0)
        end
        
        if self.db.profile.layout.health_bar.text then
            local t = getColorizedText(0, ("%s (%d %%) %s"):format(frame.values.name, 0, L["DEAD"]))
            if not frame.name:GetText() == t then
                frame.name:SetText(t)
            end
        end
        
        if frame.blinking then
            frame.blinking = nil
            local col = getColorClass(frame.values.class)
            frame.healthbar:SetStatusBarColor(col.r, col.g, col.b, 1)
        end
        
        return
    end
    
    frame.values.health = health
    frame.values.status = status
    
    frame.healthbar:SetValue(frame.values.health)
    
    if health == 0 then
        frame.values.status = "DEAD"
        frame.manabar:SetValue(0)
    elseif self.db.profile.blinking.enabled then    
        if health <= self.db.profile.blinking.value then
            frame.blinking = true
        else
            frame.blinking = nil
        end
    end
    
    local r, g, b
    if frame.blinking then
        r, g, b = 1, 0, 0
    else
        local col = getColorClass(frame.values.class)
        r, g, b = col.r, col.g, col.b
    end    
    frame.healthbar:SetStatusBarColor(r, g, b, 1)
    
    if self.db.profile.layout.health_bar.text then
        local inc = ""
        if frame.in_combat then
            inc = "[x] "
        end
        local stat = ""
        if frame.values.status and frame.values.status ~= "" then
            stat = L[frame.values.status]
            if not stat then stat = "" end
        end
        local t = getColorizedText(health, ("%s%s (%d %%) %s"):format(inc, frame.values.name, frame.values.health, stat))
        frame.name:SetText(t)
    else
        frame.name:SetText("")
    end
    
    updateTooltip(index)
end

function ControlArena:AssignHealthBar(index, guy, unit)
    local frame = self.frame.frames[index]
	if not frame or not guy then return end
    
    frame.values = guy
    
    local col = getColorClass(frame.values.class)
	frame.healthbar:SetStatusBarColor(col.r, col.g, col.b, 1)
	br, bg, bb = (col.r+0.2)/3, (col.g+0.2)/3, (col.b+0.2)/3
	frame.healthbar.bg:SetVertexColor(br, bg, bb, 1)								
	frame.healthbar:SetValue(frame.values.health)
    
    local r, g, b = getColorPowerType(frame.values.powertype)
    frame.manabar:SetStatusBarColor(r, g, b, 1)
    br, bg, bb = (r+0.2)/3, (g+0.2)/3, (b+0.2)/3
	frame.manabar.bg:SetVertexColor(br, bg, bb, 1)	
    
    frame.manabar:SetValue(frame.values.energy)

	if self.db.profile.layout.class_icon.enabled then
        local portraitType = self.db.profile.layout.class_icon.portrait
        if portraitType == "class" then
            local c1, c2, c3, c4 = unpack(self.classIcons[frame.values.class])
            
            local tex = frame.class:GetNormalTexture()
            tex:SetTexCoord(c1, c2, c3, c4)
            
            tex = frame.class:GetHighlightTexture()
            tex:SetVertexColor(0.2, 0.8, 0.94)
            tex:SetTexCoord(c1, c2, c3, c4)
            
            tex = frame.class:GetPushedTexture()
            tex:SetVertexColor(0, 0.8, 0)
            tex:SetTexCoord(c1, c2, c3, c4)
        elseif portraitType == "2D" then
            if unit and UnitExists(unit) then
                local tex = frame.class:GetNormalTexture()
                tex:SetTexCoord(0, 1, 0, 1)
                SetPortraitTexture(tex, unit)
                frame.have_portrait = true
            else
                --Interface\\CharacterFrame\\TemporaryPortrait-Female-Tauren
            end
        elseif portraitType == "3D" then
            if unit and UnitExists(unit) then
                frame.class.classportrait:SetUnit(unit)
                frame.class.classportrait:SetCamera(0)
                frame.have_portrait = true
            else
                frame.class.classportrait:SetModelScale(4.25)
				frame.class.classportrait:SetPosition(0,0,-1.5)
				frame.class.classportrait:SetModel("Interface\\Buttons\\talktomequestionmark.mdx")
            end
        end
        
		frame.class:SetAlpha(1)
    else
        frame.class:SetAlpha(0)
	end
    
    if not InCombatLockdown() then
        if self.db.profile.layout.class_icon.enabled then
            --local m = ("/clearfocus\n/target %s\n/focus\n/targetlasttarget"):format(frame.values.name)
            local m = ("/clearfocus\n/target %s\n/focus"):format(frame.values.name)
            frame.class:SetAttribute("macrotext", m)
        end
        
		frame.in_combat = nil
		local defaultTexture = ""
		frame.overlay:SetAttribute("macrotext", "/target " .. frame.values.name)
		
		local macro, texture = createMacro("right", frame.values.name, frame.values.class, self.db)
		if macro and texture then
			frame.button:SetAttribute("macrotext2", macro)
			defaultTexture = texture
		end
		macro, texture = createMacro("left", frame.values.name, frame.values.class, self.db)
		if macro and texture then
			frame.button:SetAttribute("macrotext1", macro)
			defaultTexture = texture
		end
		
		if defaultTexture ~= "" then
			frame.button:SetNormalTexture(defaultTexture)
			frame.button:SetPushedTexture(defaultTexture)
			frame.button:SetHighlightTexture(defaultTexture)
			
			local tex = frame.button:GetHighlightTexture()
			tex:SetVertexColor(0.2, 0.8, 0.94)
			frame.button:SetHighlightTexture(tex)
			
			tex = frame.button:GetPushedTexture()
			tex:SetVertexColor(0, 0.8, 0)
			frame.button:SetPushedTexture(tex)
      
			frame.button:SetAlpha(1)
		else
			frame.button:SetAlpha(0)
		end	
	else
		frame.in_combat = true
		frame.button:SetAlpha(0)
	end
    
    setUnitTooltip(index)    
    
    updateHealthBar(index, frame.values.name, frame.values.health, frame.values.status)
    updateManaBar(index, frame.values.name, frame.values.energy, frame.values.powertype)
    frame:SetAlpha(1)
end

local function updateUnitPortrait(index, unit, force)
    local frame = self.frame.frames[index]
	if not frame or not unit then return end
    
    if frame.have_portrait and not force then return end
    
    local portraitType = self.db.profile.layout.class_icon.portrait
    if portraitType == "2D" then
        if UnitExists(unit) then
            local tex = frame.class:GetNormalTexture()
            tex:SetTexCoord(0, 1, 0, 1)
            SetPortraitTexture(tex, unit)
        end
    elseif portraitType == "3D" then
        if UnitExists(unit) then
            frame.class.classportrait:SetUnit(unit)
            frame.class.classportrait:SetCamera(0)
        end
    end
    
    frame.have_portrait = true
end

local schoolColoring = {
    [0] = {a=1.0,r=1.00,g=1.00,b=1.00},
    [1] = {a=1.0,r=1.00,g=1.00,b=0.00},
    [2] = {a=1.0,r=1.00,g=0.90,b=0.50},
    [4] = {a=1.0,r=1.00,g=0.50,b=0.00};
    [8] = {a=1.0,r=0.30,g=1.00,b=0.30},
    [16] = {a=1.0,r=0.50,g=1.00,b=1.00},
    [32] = {a=1.0,r=0.50,g=0.50,b=1.00},
    [64] = {a=1.0,r=1.00,g=0.50,b=1.00},
}
local function updateUnitCombatText(index, name, amount, school, type)
    if not self.db.profile.layout.combat_text.enabled then return end
    
    local frame = self.frame.frames[index]
	if not frame then return end
    
    if type:find("_HEAL") then
        symbol = "+"
        school = 8
    elseif type:find("_MISSED") then
        symbol = ""
    else symbol = "-" end
    
    local r, g, b = schoolColoring[school].r, schoolColoring[school].g, schoolColoring[school].b
    local text = ("|cff%02x%02x%02x%s %s|r"):format(r * 255, g * 255, b * 255, symbol, amount)
    
    frame.combat_text:SetAlpha(1)
	frame.combat_text:Show()
    frame.combat_text:SetText(text)
    frame.combat_texttime = GetTime()
    self:AddRepeatingTimer("ControlArena_combat_text_u", 0.5, "UpdateCombatTextTimer")
end

function ControlArena:UpdateCombatTextTimer()
	local found, elapsedTime, alpha
	local maxalpha = 1
	local frame
	local now = GetTime()
    for i=1, 5 do
        if self.frame.frames[i] then
            --local one = false
            frame = self.frame.frames[i]
            if frame.combat_texttime then
                local time = frame.combat_texttime
                found = true
                elapsedTime = now - time
                if ( elapsedTime < COMBATFEEDBACK_FADEINTIME ) then
                    alpha = maxalpha*(elapsedTime / COMBATFEEDBACK_FADEINTIME)
                    frame.combat_text:SetAlpha(alpha)
                elseif ( elapsedTime < (COMBATFEEDBACK_FADEINTIME + COMBATFEEDBACK_HOLDTIME) ) then
                    frame.combat_text:SetAlpha(maxalpha)
                elseif ( elapsedTime < (COMBATFEEDBACK_FADEINTIME + COMBATFEEDBACK_HOLDTIME + COMBATFEEDBACK_FADEOUTTIME) ) then
                    alpha = maxalpha - maxalpha*((elapsedTime - COMBATFEEDBACK_HOLDTIME - COMBATFEEDBACK_FADEINTIME) / COMBATFEEDBACK_FADEOUTTIME)
                    frame.combat_text:SetAlpha(alpha)
                else
                    frame.combat_text:Hide()
                end
            end
            found = true
        end
	end
	if not found then
		self:RemoveTimer("ControlArena_combat_text_u")
	end
end

local function updateThing(thing, name, ...) --arg1, arg2, arg3, arg4, arg5)
    if not self.list or #self.list == 0 then return end
    if not self.frame then return end
	
	for i=1, #self.list do
		if self.list[i].name == name then
            if thing == "health" then
                health, status, force = select(1, ...) --arg1, arg2, arg3
                updateHealthBar(i, name, health, status, force)
            elseif thing == "mana" then
                energy, powertype= select(1, ...) --arg1, arg2
                updateManaBar(i, name, energy, powertype)
            elseif thing == "talent" then
                talent = select(1, ...) --arg1
                updateTalentsBar(i, name, talent)
            elseif thing == "cast" then
                cast, status, channeling, startTime, endTime, icon = select(1, ...) --arg1, arg2, arg3, arg4, arg5
                updateCastingBar(i, cast, status, channeling, startTime, endTime, icon)
            elseif thing == "combattext" then
                value, school, eventType = select(1, ...) --arg1, arg2, arg3
                updateUnitCombatText(i, name, value, school, eventType)            
            elseif thing == "portrait" then
                unit, force = select(1, ...) --arg1, arg2
                updateUnitPortrait(i, unit, force)
            end
			do return end
		end
	end
end


function ControlArena:UpdateCombatText(name, amount, school, type)
    if not self.db.profile.layout.combat_text.enabled then return end
    updateThing("combattext", name, amount, school, type)
end

function ControlArena:UpdatePortrait(unit, force)
    local n = UnitName(unit)
    updateThing("portrait", n, unit, force)
end

function ControlArena:UpdateTalents(name, talent)
    updateThing("talent", name, talent)
end

function ControlArena:UpdateHealth(name, health, status, force)
	updateThing("health", name, health, status, force)
end

function ControlArena:UpdateMana(name, energy, powertype)
    if not self.db.profile.layout.mana_bar.enabled then return end
    
    updateThing("mana", name, energy, powertype)
end

function ControlArena:UpdateCasting(name, cast, status, channeling, startTime, endTime, icon)
    if not self.db.profile.layout.cast_bar.enabled then return end
    
    updateThing("cast", name, cast, status, channeling, startTime, endTime, icon)
end

function ControlArena:UpdateAllCastingBars()
    if not self.db.profile.layout.cast_bar.enabled then return end
    
    local frame
    for i=1, #self.list do
        frame = self.frame.frames[i]
        if frame.castinginfo then
            local castinginfo = frame.castinginfo
                
            local currentTime = GetTime()
            if castinginfo.channeling then                
                local showTime = currentTime
                local remainingTime = castinginfo.endTime - showTime
                if self.db.profile.layout.cast_bar.text then
                    local t = ("%s (%.1f)"):format(castinginfo.spell, remainingTime)
                    frame.castname:SetText(t)
                end
                
                frame.castingbar:SetValue(castinginfo.startTime + remainingTime)
                
                if currentTime > castinginfo.endTime then
                    frame.castinginfo.fadeout = true
                    frame.castinginfo.channeling = nil
                    frame.castinginfo.endTime = GetTime()
                end                    
            elseif castinginfo.casting then
                local showTime = math.min(currentTime, castinginfo.endTime)
                if self.db.profile.layout.cast_bar.text then
                    local t = ("%s (%.1f)"):format(castinginfo.spell, (castinginfo.endTime - showTime))
                    frame.castname:SetText(t)
                end
                
                frame.castingbar:SetValue(showTime)
                
                if currentTime > castinginfo.endTime then
                    frame.castinginfo.fadeout = true
                    frame.castinginfo.casting = nil
                    frame.castinginfo.endTime = GetTime()
                end
            elseif castinginfo.fadeout then
                local alpha
                if castinginfo.endTime then
                    alpha = castinginfo.endTime - currentTime + 1
                else
                    alpha = 0
                end
                
                if alpha >= 1 then
                    alpha = 1
                end
                if alpha <= 0 then
                    frame.castingbar:Hide()
                    frame.castingbar:SetValue(0)
                    frame.castname:SetText("")
                    
                    frame.castingicon:Hide()
                    
                    frame.castinginfo = del(frame.castinginfo)
                else
                    frame.castingbar:SetAlpha(alpha)
                    frame.castingicon:SetAlpha(alpha)
                end
            end
        end
    end
end

function ControlArena:ChangeTexture(bar_name, s)
	local texture = SharedMedia:Fetch('statusbar', s)
	
	if not self.frame then return end
	for i=1, 5 do
        if bar_name == "health_bar" then
            self.frame.frames[i].healthbar:SetStatusBarTexture(texture)
            self.frame.frames[i].healthbar.bg:SetTexture(texture)
        elseif bar_name == "mana_bar" then        
            self.frame.frames[i].manabar:SetStatusBarTexture(texture)
            self.frame.frames[i].manabar.bg:SetTexture(texture)
        elseif bar_name == "cast_bar" then
            self.frame.frames[i].castingbar:SetStatusBarTexture(texture)
            self.frame.frames[i].castingbar.bg:SetTexture(texture)
        end
	end
end

function ControlArena:ChangeFont(bar_name, font, size, mode)
    if not bar_name then
        self.frame.text:SetFont(font, size * 1.5)
        return
    end
    
	for i=1, 5 do
        if bar_name == "health_bar" then
            self.frame.frames[i].name:SetFont(font, size * 1.5, mode)
        elseif bar_name == "mana_bar" then
            self.frame.frames[i].mananame:SetFont(font, size * 1.5, mode)
        elseif bar_name == "cast_bar" then
            self.frame.frames[i].castname:SetFont(font, size * 1.5, mode)
        elseif bar_name == "combat_text" then
            self.frame.frames[i].combat_text:SetFont(font, size * 1.5, mode)
        end
	end
end

function ControlArena:ToggleTitle()
	if self.frame.title:IsShown() then
		self.frame.title:Hide()
	else
		self.frame.title:Show()
	end
end

--[[local FrameBackdrop = {
	bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	tile = true, tileSize = 16, edgeSize = 16,
	insets = { left = 3, right = 3, top = 3, bottom = 3 }
}

local function createTeamInfoFrame(x, y, scale)
	local frame = CreateFrame("Frame", nil, UIParent)
	frame:SetClampedToScreen(true)
	frame:SetMovable(true)
	frame:SetBackdrop(FrameBackdrop)
	frame:SetBackdropColor(0, 0, 0, 1)
	
	local titleBar = frame:CreateTexture(nil, "BACKGROUND")
	frame.titleBar = titleBar
	local titleBar2 = frame:CreateTexture(nil, "BACKGROUND")
	frame.titleBar2 = titleBar2
	local r,g,b = 134/255, 173/255, 188/255

	titleBar:SetPoint("TOPLEFT", frame, "TOPLEFT", 3, -4)
	titleBar:SetPoint("TOPRIGHT", frame, "TOPRIGHT", -3, -4)
	titleBar:SetHeight(8)

	titleBar2:SetPoint("TOPLEFT", titleBar, "BOTTOMLEFT", 0, 0)
	titleBar2:SetPoint("TOPRIGHT", titleBar, "BOTTOMRIGHT", 0, 0)
	titleBar2:SetHeight(8)

	titleBar:SetGradientAlpha("VERTICAL", r*0.6, g*0.6, b*0.6, 1, r, g, b, 1)
	titleBar:SetTexture(r, g, b, 1)
	titleBar2:SetGradientAlpha("VERTICAL", r*0.9, g*0.9, b*0.9, 1, r*0.6, g*0.6, b*0.6, 1)
	titleBar2:SetTexture(r, g, b, 1)

	local closeButton = CreateFrame("Button", nil, frame, "UIPanelCloseButton")
	frame.closeButton = closeButton
	closeButton:SetFrameLevel(5)
	closeButton:SetScript("OnClick", function(this)
		this:GetParent():Hide()
	end)
    local s = closeButton:GetWidth()
    closeButton:SetWidth(s - 7)
    closeButton:SetHeight(s - 7)
	closeButton:SetPoint("TOPRIGHT", frame, "TOPRIGHT", -1, -1)
	
    local targetButton = CreateFrame("Button", nil, frame, "SecureActionButtonTemplate")
	frame.targetButton = targetButton
	targetButton:SetFrameLevel(5)
	targetButton:EnableMouse(true)
	targetButton:RegisterForClicks("LeftButtonUp")
	targetButton:SetAttribute("type1", "macro")
    targetButton:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up")
    targetButton:SetPushedTexture("Interface\\Buttons\\UI-PlusButton-Down")
    targetButton:SetHighlightTexture("Interface\\Buttons\\UI-PlusButton-Hilight")
    
    targetButton:SetWidth(18)
    targetButton:SetHeight(18)
	targetButton:SetPoint("TOPLEFT", frame, "TOPLEFT", 4, -2)
    
	local title = CreateFrame("Frame", nil, frame)
	frame.title = title
	title:EnableMouse(true)
	title:RegisterForDrag("LeftButton")
	title:SetScript("OnDragStart", function(this)
		this:GetParent():StartMoving()
	end)
    title:SetScript("OnDragStop", function(this)
		this:GetParent():StopMovingOrSizing()
		self.db.profile.info.x = this:GetParent():GetLeft()
		self.db.profile.info.y = this:GetParent():GetTop()
	end)

	title:SetPoint("TOPLEFT", titleBar, "TOPLEFT", 0, 0)
	title:SetPoint("BOTTOMRIGHT", titleBar2, "BOTTOMRIGHT", 0, 0)

	local titleText = title:CreateFontString(nil, "OVERLAY", "QuestTitleFont")
	frame.titleText = titleText
	titleText:SetText("")
	titleText:SetPoint("TOPLEFT", title, "TOPLEFT", 0, 0)
	titleText:SetPoint("TOPRIGHT", title, "TOPRIGHT", 0, 0)
	titleText:SetHeight(16)
	titleText:SetShadowColor(0, 0, 0)
	titleText:SetShadowOffset(1, -1)
	titleText:SetTextColor(1, 1, 1)
	
	local scroll = CreateFrame("ScrollFrame", "scrollframe", frame, "UIPanelScrollFrameTemplate")
	scroll:SetWidth(350)
	scroll:SetHeight(150)
	scroll:SetPoint("TOPLEFT", titleBar2, "BOTTOMLEFT", 0, -3)
	scroll:SetPoint("TOPRIGHT", titleBar2, "BOTTOMRIGHT", -24, -3)
	scroll:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", 0, 4)
	scroll:SetPoint("BOTTOMRIGHT", titleBar2, "BOTTOMRIGHT", -24, 4)
	frame.scroll = scroll
	local panel = CreateFrame("Frame", nil, scroll)
	panel:SetAllPoints(scroll)
	panel:SetWidth(350)
	panel:SetHeight(100)
	scroll:SetScrollChild(panel)
	
	local text = panel:CreateFontString(nil, "ARTWORK", "QuestFont")
	text:SetJustifyH("LEFT")
	text:SetWidth(350)
	text:SetPoint("TOPLEFT", 5, -5)
	frame.text = text
	
    frame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x, y)
	
	frame:SetWidth(350)
	frame:SetHeight(150)
	frame:SetScale(scale)
    frame:Hide()
	return frame
end

local function formatClass(name, template_name, talents, class)
	if not class or not self.classColors[class] then
        return "|cff1eff00".. name .."|r" .. " |cffffffff: " .. talents .. "|r"
	end
	
	local color = self.classColors[class]
	local class = class:sub(1, 1) .. class:sub(2):lower()
	
    return ("|cff%s%s|r |cffffffff:|r |cff%s%s|r   |cffffffff%s|r"):format(color, name, color, class, talents)
end

local getPlayerInfo = ControlArena.getPlayerInfo

function ControlArena:ShowTeamInfo(n, team_name, ranking, rating, team_mates, realm, team_size) --(team_data, r, n, team_name)
    if not self.db.profile.info.enabled then return end
    if self.infoteamframe and self.infoteamframe.hasInfo then return end
    
    local t_mates = { strsplit(",", team_mates) }
    
    local x, y, scale = self.db.profile.info.x, self.db.profile.info.y, self.db.profile.info.scale
    if not self.infoteamframe then
        self.infoteamframe = createTeamInfoFrame(x, y, scale)
    end
    self.infoteamframe.hasInfo = true
    
    self.infoteamframe.titleText:SetText(team_name)    
    local text = L["|cffffffffRating :|r |cfff07902%d|r, |cffffffffRanking :|r |cfff07902%d|r"]:format(tonumber(rating, 36), tonumber(ranking, 36)) .. "|r\n"

    local macro = ""
    for _, k in pairs(t_mates) do
        --if k ~= n then
            macro = macro .. "/target " .. k .. "\n" -- "/whisper Nekia " .. k .. "\n"
            local l = self.ARMORY_DATA["players"][realm][k]
            if l then
                local template_name, talents, class = getPlayerInfo(l)
                text = text .. "\n" .. formatClass(k, template_name, talents, class)
            end
        --end
    end
    
    if not InCombatLockdown() then
        self.infoteamframe.targetButton:SetAttribute("macrotext", macro)
    end
    
    self.infoteamframe.text:SetText(text)
    self.infoteamframe.scroll:UpdateScrollChildRect()
    self.infoteamframe:Show()
end]]
