ControlArena = Rock:NewAddon("ControlArena", "LibRockTimer-1.0", "LibRockEvent-1.0", "LibRockDB-1.0", "LibRockConsole-1.0", "LibRockConfig-1.0", "LibRockComm-1.0")

local ControlArena, self = ControlArena, ControlArena

local SharedMedia = Rock("LibSharedMedia-3.0")
local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("ControlArena")

local LS = LibStub("LibBabble-Spell-3.0"):GetUnstrictLookupTable()
local LC = LibStub("LibBabble-Class-3.0"):GetUnstrictLookupTable()
--local LibSpell = Rock("LibSpell-1.0")
local _G = _G

local inspectName = nil
ControlArena.OnCommReceive = {}
ControlArena:SetDatabase("ControlArenaDB")
ControlArena:SetDatabaseDefaults("profile", {
	size = {
		scale = 1,
		lock = false,												
	},
	info = {
		x = 0,
		y = 0,
		scale = 1,
		enabled = true,
	},
	warnings = {
		enabled = true,
		colors = { r = 1, g = 0.5, b = 0 },
	},
	colorized_life = true,
	testing = false,
	font = {
		size = 12,
		name = "ABF",
	},
	announce = {
		enabled = true,
		channel = "BATTLEGROUND",
	},
	blinking = {
		enabled = true,
		value = 20,
	},
	macro = {
		['**'] = {
			enabled = false,
			is_spell = true,
			spell = "",
			is_spell_class = false,
			is_macro = false,
			targetlasttarget = true,
			spell_class = { WARRIOR = "", ROGUE = "", SHAMAN = "", PRIEST = "", PALADIN = "", HUNTER = "", MAGE = "", WARLOCK = "", DRUID = "" },
		},
		left =  {},
		right =  {},			
	},
	layout = {
		['**'] = { enabled = true, x = 0, y = 0, w = 0, h = 0 },
		alignment = "VERTICAL",
		class_icon = { x = 10, w = 40, h = 40, wh = true, portrait = "class"},
		health_bar = { x = 55, w = 205, h = 25, text = true, texture = "Charcoal", font = "", fontsize = 12, fontmode = "" },
		mana_bar = { w = 205, h = 15, x = 55, y = -25, text = true, texture = "Charcoal", font = "", fontsize = 12, fontmode = "" },
		cast_bar = { w = 295, h = 20, y = -40, x = 10, text = true, texture = "Charcoal", font = "", fontsize = 12, fontmode = ""},
		spell_icon = { x = 265, w = 40, h = 40, wh = true},
		combat_text = { x = -1, w = -1, y = -1, h = -1, text = true, font = "", fontsize = 12, fontmode = "OUTLINE"}
	},
	tooltip = "ALWAYS",
	trackBuff = {
		enabled = true,
		names = {
			[LS["Ice Block"]] = true,
			[LS["Blessing of Protection"]] = true,
			[LS["Divine Shield"]] = true,
		}
	},
	trackRegen = {
		enabled = true,
		names = {
			[LS["Drink"]] = true,
			[LS["Food"]] = true,
			[LS["First Aid"]] = true,
			[LS["Evocation"]] = true,
		}
	},
	trackDebuff = {
		enabled = true,
		names = {
			[LS["Polymorph"]] = true,
			[LS["Cyclone"]] = true,
			[LS["Curse of Tongues"]] = true,
			[LS["Fear"]] = true,
			[LS["Death Coil"]] = true,
			[LS["Psychic Scream"]] = true,
			[LS["Banish"]] = true,
			[LS["Sap"]] = true,
			[LS["Blind"]] = true,
			[LS["Silence"]] = true,
			[LS["Counterspell"]] = true,
		}
	},
	trackSpell = {
		enabled = true,
		names = {
			[LS["Ancestral Spirit"]] = true,
			[LS["Redemption"]] = true,
			[LS["Resurrection"]] = true,
		}
	},
})

ControlArena.classIcons = {
	["WARRIOR"] = {0, 0.25, 0, 0.25},
	["MAGE"] = {0.25, 0.49609375, 0, 0.25},
	["ROGUE"] = {0.49609375, 0.7421875, 0, 0.25},
	["DRUID"] = {0.7421875, 0.98828125, 0, 0.25},
	["HUNTER"] = {0, 0.25, 0.25, 0.5},
	["SHAMAN"] = {0.25, 0.49609375, 0.25, 0.5},
	["PRIEST"] = {0.49609375, 0.7421875, 0.25, 0.5},
	["WARLOCK"] = {0.7421875, 0.98828125, 0.25, 0.5},
	["PALADIN"] = {0, 0.25, 0.5, 0.75},
}
ControlArena.colors = {
	rage = {226/255, 45/255, 75/255},
	energy = {1, 220/255, 25/255},
	mana = {48/255, 113/255, 191/255},
	
	vertex = {11/255, 11/255, 11/255},
	dead = { 0.6, 0.6, 0.6 },
	alive = { 0.2, 0.8, 0.15 },
	
	casting = {
		casting = {1.0, 0.7, 0.0},
		channeling = {0, 1.0, 0},
		complete = {0, 1.0, 0},
		fail = {1.0, 0, 0},
	}
}
ControlArena.classColors = {
	["WARRIOR"] = "c79c6e",
	["MAGE"] = "69ccf0",
	["ROGUE"] = "fff569",
	["DRUID"] = "ff7d0a",
	["HUNTER"] = "abd473",
	["SHAMAN"] = "2459ff",
	["PRIEST"] = "ffffff",
	["WARLOCK"] = "9482ca",
	["PALADIN"] = "f58cba",
}

local new, del =  Rock:GetRecyclingFunctions("ControlArena", "newList", "del")
ControlArena.toggleshow = false
ControlArena.debugging = false

local function ctaDebug(...)
	if ControlArena.debugging then
		self:Print(...)
	end
end

local crafts = {
	-- tradeskill
	LS["Disenchant"], LS["Fishing"], LS["Herbalism"], LS["Mining"], LS["Pick Pocket"],
	LS["Prospecting"], LS["Skinning"], LS["Smelting"], LS["Alchemy"], LS["Armorsmith"], LS["Blacksmithing"],
	LS["Cooking"], LS["Dragonscale Leatherworking"], LS["Elemental Leatherworking"], LS["Elixir Master"],
	LS["Enchanting"], LS["Engineering"], LS["First Aid"], LS["Gnomish Engineering"], LS["Goblin Engineering"],
	LS["Gnomish Engineer"], LS["Goblin Engineer"], LS["Jewelcrafting"], LS["Leatherworking"], LS["Master Axesmith"],
	LS["Master Hammersmith"], LS["Master Swordsmith"], LS["Mooncloth Tailoring"], LS["Poisons"], LS["Potion Master"],
	LS["Shadoweave Tailoring"], LS["Spellfire Tailoring"], LS["Tailoring"], LS["Transmutation Master"],
	LS["Tribal Leatherworking"], LS["Weaponsmith"], LS["Find Herbs"], LS["Find Minerals"], LS["Find Treasure"],
	LS["Basic Campfire"], LS["Herb Gathering"],
	
	-- basic
	LS["Attack"], LS["Cure Disease"], LS["Cure Poison"], 
	
	-- shaman
	LS["Astral Recall"], "Totem", LS["Ghost Wolf"], LS["Far Sight"], " Weapon", LS["Earth Shield"], LS["Water Shield"],
	LS["Lightning Shield"], LS["Nature's Swiftness"]
}
local function isSpellAdd(i, book, spell)
	if IsPassiveSpell(i, book) then
		return false
	else
		for _, k in pairs(self.playerSpells) do
			if k == spell then
				do return false end
			end
		end
		
		if SpellCanTargetUnit("player") then
			return false
		end
		
		for _, k in pairs(crafts) do
			if k == spell or spell:find(k) then
				do return false end
			end
		end
	end
	return true
end
local function getPlayerSpells()
	if not self.playerSpells then
		self.playerSpells = { _G.NONE }
		local n = 2
		local i = 1
		while true do
			local spellName = GetSpellName(i, BOOKTYPE_SPELL)
			if not spellName then do break end end
			
			if isSpellAdd(i, BOOKTYPE_SPELL, spellName) then
				self.playerSpells[n] = spellName
				n = n + 1
			end
			
			i = i + 1
		end
		
		local i = 1
		while true do
			local spellName = GetSpellName(i, BOOKTYPE_PET)
			if not spellName then do break end end
			
			if isSpellAdd(i, BOOKTYPE_PET, spellName) then
				self.playerSpells[n] = spellName
				n = n + 1
			end
			i = i + 1
		end
	end
	return self.playerSpells
end
function ControlArena:OnInitialize()
	Rock("LibRockComm-1.0"):AddAddonVersionReceptor(function(player, addon, version)
		if version then
			if version == true then
				self:Print(L["%s has %s"], player, addon)
			else
				self:Print(L["%s has %s version %s"], player, addon, version)
			end
		else
			self:Print(L["%s does not have %s"], player, addon)
		end
	end)
	local options = {
		type = 'group',
		icon = [[Interface\PvPRankBadges\PvPRank14]],
		name = 'ControlArena',
		desc = L["ControlArena options."],
		args = {
			size = {
				name = L["Display settings"],
				desc = L["Display settings"],
				type = 'group',
				order = 1,
				disabled = InCombatLockdown,
				args = {				
					lock = {
						type = 'boolean',
						name = L["Lock frame"],
						desc = L["Lock the position of the frame"],
						get = function() return self.db.profile.size.lock end,
						set = function() 
							self.db.profile.size.lock = not self.db.profile.size.lock
							if self.frame and self.frame:IsShown() then
								self:ToggleTitle()
							end
						end,
						order = 1,
						--disabled = function() return not self.frame or not self.frame:IsShown() end
					},
					size = {
						type = 'group',
						name = L["Size"],
						desc = L["Size"],
						order = 2,
						groupType = 'inline',
						args = {
							scale = {
								type = 'range',
								name = L["Scale"],
								desc = L["Scale of the frame"],
								get = function() return self.db.profile.size.scale end,
								set = function(s)
									self.db.profile.size.scale = s
									self:RefreshFrame()
								end,
								min = 0.1,
								max = 2,
								step = 0.1,
								order = 3,
							},
						},
					},
					font = {
						type = "group",
						name = L["Font"],
						desc = L["Font settings."],
						groupType = 'inline',
						order = 3,
						args = {
							fonttype = {
								name = L["Type"],
								desc = L["What font face to use."],
								type = 'choice',
								choices = SharedMedia:List('font'),
								choiceFonts = SharedMedia:HashTable('font'),
								get = function()
									return self.db.profile.font.name
								end,
								set = function(s)
									self.db.profile.font.name = s
									if not self.frame then return end
									local font, size = SharedMedia:Fetch('font', s), self.db.profile.font.size
									self:ChangeFont(nil, font, size)
								end,
							},
							fontsize = {
								name = L["Size"],
								desc = L["Font Size."],
								type = 'number',
								get = function()
									return self.db.profile.font.size
								end,
								set = function(s)
									self.db.profile.font.size = s
									if not self.frame or not self.db.profile.font.name or self.db.profile.font.name == "" then return end
									local font = SharedMedia:Fetch('font', self.db.profile.font.name)
									self:ChangeFont(nil, font, s)
								end,
								min = 8,
								max = 32,
								step = 1,
							},
						},
					},
					colors = {
						type = 'group',
						name = L['Colors'],
						desc = L['Colors'],
						order = 4,
						groupType = 'inline',
						args = {
							warnings = {
								type = 'boolean',
								name = L["Show warning messages"],
								desc = L["Show warning messages"],
								get = function() return self.db.profile.warnings.enabled end,
								set = function() self.db.profile.warnings.enabled = not self.db.profile.warnings.enabled end,
								order = 2,
							},
							warningcolor = {
								type = 'color',
								name = L["Warning Color"],
								desc = L["Change the color of the warning messages"],
								get = function() return self.db.profile.warnings.colors.r, self.db.profile.warnings.colors.g, self.db.profile.warnings.colors.b end,
								set = function(r, g, b)
									self.db.profile.warnings.colors.r, self.db.profile.warnings.colors.g, self.db.profile.warnings.colors.b = r, g, b
								end,
								hasAlpha = false,
								order = 3,
								disabled = function() return not self.db.profile.warnings.enabled end,
							},
						},
					},
					min_health = {						
						name = L["Alert"],
						desc = L["Alert"],
						type = 'group',
						groupType = 'inline',
						order = 5,
						args = {
							blink = {
								name = L["Blink"],
								desc = L["Blink"],
								type = 'boolean',
								get = function() return self.db.profile.blinking.enabled end,
								set = function() self.db.profile.blinking.enabled = not self.db.profile.blinking.enabled end,
								order = 1,
							},
							value = {
								name = L["Value"],
								desc = L["Value"],
								type = 'range',
								get = function() return self.db.profile.blinking.value end,
								set = function(s) self.db.profile.blinking.value = s end,
								min = 1,
								max = 100,
								step = 1,
								order = 2,
								disabled = function() return not self.db.profile.blinking.enabled end,
							},
						},
					},
					track = {
						name = L["Track"],
						desc = L["Track"],
						type = 'group',
						groupType = 'inline',
						order = 6,
						args = {
							trackBuffEnabled = {
								name = L["Buffs"],
								desc = L["Track buffs on your enemy"],
								type = 'boolean',
								get = function() return self.db.profile.trackBuff.enabled end,
								set = function() self.db.profile.trackBuff.enabled = not self.db.profile.trackBuff.enabled end,
								order = 1,
							},
							trackBuff = {
								name = L["Buffs"],
								desc = L["Track buffs on your enemy"],
								type = 'multichoice',
								--choices = LibSpell:Gets("buff"),
								choices = {
									LS["Ice Block"],
									LS["Blessing of Protection"],
									LS["Divine Shield"],
									LS["Heroism"],
									LS["Bloodlust"]
								},
								get = function(k)
									return self.db.profile.trackBuff.names[k]
								end,
								set = function(k, s)
									self.db.profile.trackBuff.names[k] = s
								end,
								disabled = function() return not self.db.profile.trackBuff.enabled end,
								order = 2,
							},
							trackDebuffEnabled = {
								name = L["Debuffs"],
								desc = L["Track debuffs on your party"],
								type = 'boolean',
								get = function() return self.db.profile.trackDebuff.enabled end,
								set = function() self.db.profile.trackDebuff.enabled = not self.db.profile.trackDebuff.enabled end,
								order = 3,
							},
							trackDebuff = {
								name = L["Debuffs"],
								desc = L["Track debuffs on your party"],
								type = 'multichoice',
								--choices = LibSpell:Gets("debuff"),
								choices = {
									LS["Polymorph"],
									LS["Cyclone"],
									LS["Curse of Tongues"],
									LS["Fear"],
									LS["Death Coil"],
									LS["Psychic Scream"],
									LS["Banish"],
									LS["Sap"],
									LS["Blind"],
									LS["Silence"],
									LS["Counterspell"],
								},
								get = function(k)
									return self.db.profile.trackDebuff.names[k]
								end,
								set = function(k, s)
									self.db.profile.trackDebuff.names[k] = s
								end,
								disabled = function() return not self.db.profile.trackDebuff.enabled end,
								order = 4,
							},
							trackRegenEnabled = {
								name = L["Regen"],
								desc = L["Track your enemy regen"],
								type = 'boolean',
								get = function() return self.db.profile.trackRegen.enabled end,
								set = function() self.db.profile.trackRegen.enabled = not self.db.profile.trackRegen.enabled end,
								order = 5,
							},
							trackRegen = {
								name = L["Regen"],
								desc = L["Track your enemy regen"],
								type = 'multichoice',
								choices = {
									LS["Drink"],
									LS["Food"],
									LS["First Aid"],
									LS["Evocation"],
								},
								--choices = LibSpell:Gets("food"),
								get = function(k)
									return self.db.profile.trackRegen.names[k]
								end,
								set = function(k, s)
									self.db.profile.trackRegen.names[k] = s
								end,
								disabled = function() return not self.db.profile.trackRegen.enabled end,
								order = 6,
							},
							trackSpellEnabled = {
								name = L["Spells"],
								desc = L["Track your enemy spells"],
								type = 'boolean',
								get = function() return self.db.profile.trackSpell.enabled end,
								set = function() self.db.profile.trackSpell.enabled = not self.db.profile.trackSpell.enabled end,
								order = 7,
							},
							trackSpell = {
								name = L["Spells"],
								desc = L["Track your enemy spells"],
								type = 'multichoice',
								choices = {
									LS["Ancestral Spirit"],
									LS["Redemption"],
									LS["Resurrection"],
									LS["Polymorph"],
								},
								get = function(k)
									return self.db.profile.trackSpell.names[k]
								end,
								set = function(k, s)
									self.db.profile.trackSpell.names[k] = s
								end,
								disabled = function() return not self.db.profile.trackSpell.enabled end,
								order = 8,
							},
						},
					},
					other = {
						name = L["Other"],
						desc = L["Other"],
						type = 'group',
						groupType = 'inline',
						order = 7,
						args = {
							colorized_life = {
								type = 'toggle',
								name = L["Colorize names"],
								desc = L["Colorize names with health value."],
								get = function() return self.db.profile.colorized_life end,
								set = function()
									self.db.profile.colorized_life = not self.db.profile.colorized_life
									self:RefreshFrame()
								end,
								order = 1,
							},		
							--[[display_infos = {
								type = 'boolean',
								name = L["Display info about team"],
								desc = L["Display info about team"],
								get = function() return self.db.profile.info.enabled end,
								set = function()
									self.db.profile.info.enabled = not self.db.profile.info.enabled
								end,
								order = 2,
							},]]
							alignment = {
								type = 'choice',
								name = L["Alignment"],
								desc = L["Alignment"],
								choices = { VERTICAL = L["Vertical"], HORIZONTAL = L["Horizontal"] },
								get = function() return self.db.profile.layout.alignment end,
								set = function(s) 
									self.db.profile.layout.alignment = s
									self:RefreshFrame()
								end,
								validate = SharedMedia:List('statusbar'),
								order = 3,
							},
							tooltip = {
								type = 'choice',
								name = L["Tooltip"],
								desc = L["Tooltip"],
								choices = { ALWAYS = L["Always"], NEVER = L["Never"], OUTOFCOMBAT = L["Out of combat"] },
								get = function() return self.db.profile.tooltip end,
								set = function(s) 
									self.db.profile.tooltip = s
								end,
								order = 4,
							}
						},
					},
					announce = {
						name = L["Announce"],
						desc = L["Announce"],
						type = 'group',
						groupType = 'inline',
						order = 8,
						args = {
							announce = {
								type = 'boolean',
								name = L["Announce"],
								desc = L["Announce ennemies if you are party leader"],
								get = function() return self.db.profile.announce.enabled end,
								set = function() self.db.profile.announce.enabled = not self.db.profile.announce.enabled end,
								order = 1,
							},
							announce_to = {
								type = 'choice',
								name = L["Send announce to"],
								desc = L["Send announce to"],
								usage = "",
								get = function() return self.db.profile.announce.channel end,
								set = function(s) self.db.profile.announce.channel = s end,
								order = 2,
								disabled = function() return not self.db.profile.announce.enabled end,
								choices = { BATTLEGROUND = L["Group"], RAID_WARNING = L["Raid warning"] }
							},
						},
					},
				},
			},
			layout = {
				name = L["Layout"],
				desc = L["Change the layout"],
				order = 2,
				type = "group",
				disabled = InCombatLockdown,				
				args = {
					reset = {
						type = 'execute',
						name = L["Reset layout"],
						desc = L["Return to default layout"],
						func = function()
							self.db.profile.layout.alignment = "VERTICAL"
							
							self.db.profile.layout.class_icon = { enabled = true, y = 0, x = 10, w = 40, h = 40, wh = true }
							self.db.profile.layout.health_bar = { x = 55, w = 205, h = 25, enabled = true, y = 0, wh = false }
							self.db.profile.layout.mana_bar = { w = 205, h = 15, x = 55, y = -25, enabled = true, wh = false }
							self.db.profile.layout.cast_bar = { w = 295, h = 20, y = -40, x = 10, enabled = true, wh = false}
							self.db.profile.layout.spell_icon = { x = 265, w = 40, h = 40, y = 0, wh = true, enabled = true}
							
							self:RefreshFrame()
						end,
						order = 1,
					},
				}
			},
			macro = {
				name = L["Spell"],
				desc = L["Spell to cast"],
				type = 'group',
				disabled = InCombatLockdown,
				args = {
					left = {
						type = 'group',
						name = L["Left click"],
						desc = L["Spell on left click"],
						args = {},
						order = 1,
					},
					right = {
						type = 'group',
						name = L["Right click"],
						desc = L["Spell on right click"],
						args = {},
						order = 2,
					}
				},
				order = 4,
			},
			show = {
				type = 'boolean',
				name = L["Show"],
				desc = L["Show frame with fake ennemy"],
				get = function() return self.toggleshow end,
				set = function(s) 
					self.toggleshow = not self.toggleshow
					self:TestFrame()
				end,
				order = 1,
			},
			version = {
				type = 'execute',
				name = L["Version check"],
				desc = L["Request a version check"],
				func = function() 
					Rock("LibRockComm-1.0"):QueryAddonVersion(self.name, "GROUP")
				end,
				order = 2,
			 },
		}
	}
	
	for k, v in pairs(self.db.profile.layout) do
		local bar_name = k
		
		if k ~= "alignment" then
			tinsert(options.args.layout.args, {
				type = 'group',
				name = L[bar_name],
				desc = L["Change layout for %s"]:format(L[bar_name]),
				args = {
					enable = {
						type = 'boolean',
						name = L["Enable"],
						desc = L["Enable"],
						get = function() return self.db.profile.layout[bar_name].enabled end,
						set = function()
							self.db.profile.layout[bar_name].enabled = not self.db.profile.layout[bar_name].enabled
							self:RefreshFrame()
							if self.toggleshow then
								self.toggleshow = nil
								self:TestFrame()
								self.frame = nil
								self.toggleshow = true
								self:TestFrame()
							end
						end,
						order = 1,
					},
					size = {
						type = "group",
						groupType = "inline",
						name = L["Size"],
						desc = L["Size"],
						order = 2,
						disabled = function()
							return self.db.profile.layout[bar_name].w == -1 and self.db.profile.layout[bar_name].h == -1
						end,
						args = {
							width = {
								type = "number",
								name = L["Width"],
								desc = L["Width"],
								min = 0,
								max = 400,
								step = 1,
								get = function() return self.db.profile.layout[bar_name].w end,
								set = function(v)
									self.db.profile.layout[bar_name].w = v
									if self.db.profile.layout[bar_name].wh then
										self.db.profile.layout[bar_name].h = v
									end
									self:RefreshFrame()
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								order = 1,
							},
							height = {
								type = "number",
								name = L["Height"],
								desc = L["Height"],
								min = 0,
								max = 400,
								step = 1,
								get = function() return self.db.profile.layout[bar_name].h end,
								set = function(v)
									self.db.profile.layout[bar_name].h = v
									if self.db.profile.layout[bar_name].wh then
										self.db.profile.layout[bar_name].w = v
									end
									self:RefreshFrame()
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								order = 2,
							},
						},
					},
					position = {
						type = "group",
						groupType = "inline",
						name = L["Position"],
						desc = L["Position"],
						order = 3,
						disabled = function()
							return self.db.profile.layout[bar_name].x == -1 and self.db.profile.layout[bar_name].y == -1
						end,
						args = {
							x = {
								type = "number",
								name = "x",
								desc = "x",
								min = -400,
								max = 400,
								step = 1,
								get = function() return self.db.profile.layout[bar_name].x end,
								set = function(v)
									self.db.profile.layout[bar_name].x = v
									self:RefreshFrame()
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								order = 1,
							},
							y = {
								type = "number",
								name = "y",
								desc = "y",
								min = -400,
								max = 400,
								step = 1,
								get = function() return self.db.profile.layout[bar_name].y end,
								set = function(v)
									self.db.profile.layout[bar_name].y = v
									self:RefreshFrame()
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								order = 2,
							},
						},
					},
					font = {
						type = "group",
						name = L["Font"],
						desc = L["Font settings."],
						groupType = 'inline',
						disabled = function() return self.db.profile.layout[bar_name].wh end,
						order = 4,
						args = {
							text = {
								type = 'boolean',
								name = L["Text"],
								desc = L["Show text for this bar"],
								usage = L["Text"],
								get = function() return self.db.profile.layout[bar_name].text end,
								set = function(s)
									self.db.profile.layout[bar_name].text = not self.db.profile.layout[bar_name].text
								end,
								onChange = function(s)
									self:RefreshFrame()
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								order = 1,
							},
							fonttype = {
								name = L["Type"],
								desc = L["What font face to use."],
								type = 'choice',
								choices = SharedMedia:List('font'),
								choiceFonts = SharedMedia:HashTable('font'),
								get = function()
									return self.db.profile.layout[bar_name].font
								end,
								set = function(s)
									self.db.profile.layout[bar_name].font = s
									if not self.frame then return end
									local font, size = SharedMedia:Fetch('font', s), self.db.profile.layout[bar_name].fontsize
									local mode = self.db.profile.layout[bar_name].fontmode
									self:ChangeFont(bar_name, font, size, mode)
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								disabled = function() return not self.db.profile.layout[bar_name].text end,
								order = 2,
							},
							fontsize = {
								name = L["Size"],
								desc = L["Font Size."],
								type = 'number',
								get = function()
									return self.db.profile.layout[bar_name].fontsize
								end,
								set = function(s)
									self.db.profile.layout[bar_name].fontsize = s
									if not self.frame or not self.db.profile.layout[bar_name].font or self.db.profile.layout[bar_name].font == "" then return end
									local font = SharedMedia:Fetch('font', self.db.profile.layout[bar_name].font)
									local mode = self.db.profile.layout[bar_name].fontmode
									self:ChangeFont(bar_name, font, s, mode)
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								disabled = function() return not self.db.profile.layout[bar_name].text end,
								min = 8,
								max = 32,
								step = 1,
								order = 3,
							},
							fontmode = {
								name = L["Mode"],
								desc = L["Font mode"],
								type = 'choice',
								choices = {
									[""] = _G.NONE,
									OUTLINE = L["Outline"],
									THICKOUTLINE = L["Thick Outline"]
								},
								get = function() return self.db.profile.layout[bar_name].fontmode end,
								set = function(s)
									self.db.profile.layout[bar_name].fontmode = s
									
									if not self.frame or not self.db.profile.layout[bar_name].font or self.db.profile.layout[bar_name].font == "" then return end
									local font = SharedMedia:Fetch('font', self.db.profile.layout[bar_name].font)
									local size = self.db.profile.layout[bar_name].fontsize
									self:ChangeFont(bar_name, font, size, s)
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								disabled = function() return not self.db.profile.layout[bar_name].text end,
								order = 4,
							}
						},
					},					
					other = {
						name = L["Other"],
						desc = L["Other"],
						type = 'group',
						groupType = 'inline',
						disabled = function() return not self.db.profile.layout[bar_name].texture and not self.db.profile.layout[bar_name].portrait end,
						order = 5,
						args = {
							texture = {
								type = 'choice',
								name = L["Bar texture"],
								desc = L["Set the texture of bar"],
								choices = SharedMedia:List('statusbar'),
								choiceTextures = SharedMedia:HashTable('statusbar'),
								get = function() return self.db.profile.layout[bar_name].texture end,
								set = function(s) 
									self.db.profile.layout[bar_name].texture = s
									self:ChangeTexture(bar_name, s)
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									end
								end,
								validate = SharedMedia:List('statusbar'),
								disabled = function() return not self.db.profile.layout[bar_name].texture end,
								order = 1,
							},
							icone = {
								type = 'choice',
								name = L["Portrait"],
								desc = L["Show portrait"],
								get = function() return self.db.profile.layout[bar_name].portrait end,
								set = function(s)
									self.db.profile.layout[bar_name].portrait = s
									if self.toggleshow then
										self.toggleshow = nil
										self:TestFrame()
										self.frame = nil
										self.toggleshow = true
										self:TestFrame()
									else										
										self.frame = nil
									end
								end,
								choices = {
									class = L["class_icon"],
									["2D"] = "2D",
									["3D"] = "3D",
								},
								order = 3,
								disabled = function() return not self.db.profile.layout[bar_name].portrait end,
							},
						},
					},
				},
			})
		end
	end
	
	local clic = { "left", "right" }
	for _, v in pairs(clic) do
		options.args.macro.args[v].args = {
			enabled = {
				type = 'boolean',
				name = L["Enable"],
				desc = L["Enable"],
				get = function() return self.db.profile.macro[v].enabled end,
				set = function()
					self.db.profile.macro[v].enabled = not self.db.profile.macro[v].enabled
					self:RefreshFrame()
					if self.toggleshow then
						self.toggleshow = nil
						self:TestFrame()
						self.frame = nil
						self.toggleshow = true
						self:TestFrame()
					end
				end,
				order = 1,
			},
			macroOrSpell = {
				type = 'group',
				groupType = 'inline',
				name = L["Macro or spell"],
				desc = L["Use macro or spell"],
				order = 2,
				disabled = function() return not self.db.profile.macro[v].enabled end,
				args = {
					spell = {
						type = 'boolean',
						name = L["Spell"],
						desc = L["Enter the correct spell name to use"],
						get = function() return not self.db.profile.macro[v].is_macro end,
						set = function()
							--self.db.profile.macro[v].is_spell = not self.db.profile.macro[v].is_spell
							self.db.profile.macro[v].is_macro = not self.db.profile.macro[v].is_macro
							
							options.args.macro.args[v].args.singleSpell.args.spell.choices = function()
								if not self.is_logged then return {}
								else return getPlayerSpells() end
							end
							options.args.macro.args[v].args.singleSpell.args.spell.type = 'choice'
							
							for _, k in pairs(options.args.macro.args[v].args.classSpells.args) do
								if k.type ~= 'boolean' then
									k.choices = function()
										if not self.is_logged then return {}
										else return getPlayerSpells() end
									end
									k.type = 'choice'
								end
							end
						end,
						order = 1,
						isRadio = true,
						disabled = function() return not self.db.profile.macro[v].enabled end,
					},
					macro = {
						type = 'boolean',
						name = L["Macro"],
						desc = L["Enter a macro.\nYou can use %n if you want to use the target name.\nUse ; as a line separator"],
						get = function() return self.db.profile.macro[v].is_macro end,
						set = function()
							--self.db.profile.macro[v].is_spell = not self.db.profile.macro[v].is_spell
							self.db.profile.macro[v].is_macro = not self.db.profile.macro[v].is_macro
							
							options.args.macro.args[v].args.singleSpell.args.spell.choices = nil
							options.args.macro.args[v].args.singleSpell.args.spell.type = 'string'
							
							for _, k in pairs(options.args.macro.args[v].args.classSpells.args) do
								if k.type ~= 'boolean' then
									k.choices = nil
									k.type = 'string'
								end
							end
						end,
						order = 2,
						isRadio = true,
						disabled = function() return not self.db.profile.macro[v].enabled end,
					},
					target = {
						type = 'boolean',
						name = L["Target last target"],
						desc = L["Target last target"],
						get = function() return
						self.db.profile.macro[v].targetlasttarget end,
						set = function()
							self.db.profile.macro[v].targetlasttarget = not self.db.profile.macro[v].targetlasttarget
						end,
						order = 3,
						isRadio = true,
						--disabled = function() return not self.db.profile.macro[v].is_macro end,
					},
				}
			},
			singleSpell = {
				name = L["Single spell"],
				desc = L["Single spell"],
				type = 'group',
				groupType = 'inline',
				order = 3,
				args = {
					enabled = {
						type = 'boolean',
						name = L["Single spell"],
						desc = L["Bind a spell for all classes"],
						get = function() return self.db.profile.macro[v].is_spell end,
						set = function()
							self.db.profile.macro[v].is_spell = not self.db.profile.macro[v].is_spell
							self.db.profile.macro[v].is_spell_class = not self.db.profile.macro[v].is_spell_class
						end,
						order = 1,
						isRadio = true,
						disabled = function() return not self.db.profile.macro[v].enabled end,
					},				
					spell = {
						type = 'choice',
						name = L["Spell"],
						desc = L["Spell"],
						usage = format(L["Spell to cast of %s click"], L[v]),
						get = function() 
							local spell = self.db.profile.macro[v].spell
							if spell == "" then spell = _G.NONE end
							return spell
						end,
						set = function(s) 
							if s == _G.NONE then s = "" end
							self.db.profile.macro[v].spell = s
							self:RefreshFrame()
							if self.toggleshow then
								self.toggleshow = nil
								self:TestFrame()
								self.frame = nil
								self.toggleshow = true
								self:TestFrame()
							end
						end,
						choices = function()
							if not self.is_logged then return {}
							else return getPlayerSpells() end
						end,
						order = 4,
						disabled = function()
							return not self.db.profile.macro[v].enabled or not self.db.profile.macro[v].is_spell
						end,
					}
				}
			},
			classSpells = {
				name = L["Class spell"],
				desc = L["Class spell"],
				type = 'group',
				groupType = 'inline',
				order = 4,
				args = {
					class_spell = {
						type = 'boolean',
						name = L["Class spell"],
						desc = L["Bind a spell by class"],
						get = function() return self.db.profile.macro[v].is_spell_class end,
						set = function()
							self.db.profile.macro[v].is_spell = not self.db.profile.macro[v].is_spell
							self.db.profile.macro[v].is_spell_class = not self.db.profile.macro[v].is_spell_class
						end,
						order = 1,
						isRadio = true,
						disabled = function() return not self.db.profile.macro[v].enabled end,
					}
				}
			}
		}
		for k, _ in pairs(self.classColors) do
			local localizedName, dbName = k:sub(1, 1) .. k:sub(2):lower(), k
			local opt = {
				type = 'choice',
				name = LC[localizedName],
				desc = LC[localizedName],
				usage = format(L["Add spell for class '%s' on %s click"], LC[localizedName], L[v]),
				get = function() 
					local spell = self.db.profile.macro[v].spell_class[dbName]
					if spell == "" then spell = _G.NONE end
					return spell
				end,
				set = function(s) 
					if s == _G.NONE then s = "" end
					self.db.profile.macro[v].spell_class[dbName] = s
					self:RefreshFrame()
					if self.toggleshow then
						self.toggleshow = nil
						self:TestFrame()
						self.frame = nil
						self.toggleshow = true
						self:TestFrame()
					end
				end,
				disabled = function()
					return not self.db.profile.macro[v].enabled or not self.db.profile.macro[v].is_spell_class
				end,
				choices = function()
					if not self.is_logged then return {}
					else return getPlayerSpells() end
				end,
			}
			tinsert(options.args.macro.args[v].args.classSpells.args, opt)
			
			if self.db.profile.macro[v].is_macro then
				options.args.macro.args[v].args.singleSpell.args.spell.choices = nil
				options.args.macro.args[v].args.singleSpell.args.spell.type = 'string'
				
				for _, k in pairs(options.args.macro.args[v].args.classSpells.args) do
					if k.type ~= 'boolean' then
						k.choices = nil
						k.type = 'string'
					end
				end
			end
		end
	end

	self:SetConfigTable(options)
	self:SetConfigSlashCommand("/cta")
	
	self:SetCommPrefix("cta")
	self:AddCommListener("cta", "GROUP")
	--self:AddCommListener("cta", "WHISPER")
	self:AddMemoizations {
		"Discover", "UpdateHealth", "Casting", "UpdateMana",
		"DRUID", "HUNTER", "MAGE", "PALADIN", "PRIEST", "ROGUE", "SHAMAN", "WARLOCK", "WARRIOR",
		"start", "stop", "break", "update"
	}
end

local function isInArena()
	local instanceType = select(2, IsInInstance())
	return instanceType == "arena"
end

local function inList(guy)
	for _, k in pairs(self.list) do
		if type(guy) == "table" then
			if k.guid == guy.guid then
				return true
			end
		else
			if k.name == guy then
				return true
			end
		end
	end
	
	return false
end

local function getValuesFor(name)
	if not self.list or #self.list == 0 or not self.frame then return nil end
	
	for i=1, #self.list do
		if self.frame.frames[i] then
			local values = self.frame.frames[i].values
			if values.name == name then
				return values
			end
		end
	end
	
	return nil
end

local function isValid(name)
	-- ugly test to check the first letter is a Upper one
	-- this is usefull to correct a bug.
	--local s = name:sub(1, 1)
	
	return name and strlen(name) >= 2 and not name:find(_G.UNKNOWN)
end
function getLocalizedClass(class)
	local c = class:sub(1, 1) .. class:sub(2):lower()
	return LC[c]
end

local function addGuy(guy, unit)
	if not guy.name or not guy.class or not guy.health then return end
	
	if not inList(guy) and isValid(guy.name) and #self.list < 5 then		
		tinsert(self.list, guy)
		self:AssignHealthBar(#self.list, guy, unit)
	end
end

local function sendComm(func, ...)
	local s = self:SendCommMessage("GROUP", func, ...)
	--local w = self:SendCommMessage("WHISPER", UnitName("player"), func, ...)
	--return s and w
	return s
end

function ControlArena:OnEnable()
	self.list = new()
	self.castinglist = new()

	DEFAULT_CHAT_FRAME:AddMessage(("|cff0099ff%s %s|r |cff00ff00%s|r."):format(self.name, self.version, L["loaded"]))
	DEFAULT_CHAT_FRAME:AddMessage(L["Use /cta for options."])
	
	self:AddEventListener("PLAYER_LOGIN")
	self:AddEventListener("PLAYER_ENTERING_WORLD")
end

local function resetFrame()
	local k, v
	for k, v in pairs(self.list) do
		self.list[k] = del(v)
	end
	
	for k, v in pairs(self.castinglist) do
		self.castinglist[k] = del(v)
	end
	
	if self.db.profile.info.enabled and self.infoteamframe and self.infoteamframe:IsShown() then
		self.infoteamframe:Hide()
		self.infoteamframe.hasInfo = nil
	end
	
	if not self.frame then return end
	
	for i=1, 5 do
		self:ResetHealthBar(i)
	end
	
	self.frame:Hide()
end

local function enterArena()
	if not self.frame then
		self:BuildFrame()
		--self.frame:Hide()	
	end
	-- reset again to correct a strange display bug
	resetFrame()
	self.frame:Show()
	
	self:AddEventListener("UNIT_HEALTH")
	self:AddEventListener("UNIT_AURA")
	self:AddEventListener("UPDATE_MOUSEOVER_UNIT")
	
	self:AddEventListener("PLAYER_TARGET_CHANGED")
	self:AddEventListener("COMBAT_LOG_EVENT_UNFILTERED")
	
	if self.db.profile.layout.mana_bar.enabled then 
		self:AddEventListener("UNIT_MANA")
		self:AddEventListener("UNIT_RAGE", "UNIT_MANA")
		self:AddEventListener("UNIT_ENERGY", "UNIT_MANA")
	end
		
	if self.db.profile.layout.cast_bar.enabled then 
		self:AddRepeatingTimer(0, "UpdateAllCastingBars")
	end
	
	if self.db.profile.layout.class_icon.enabled and self.db.profile.layout.class_icon.portrait ~= "class" then
		self:AddEventListener("UNIT_PORTRAIT_UPDATE")
	end
	
	self:AddEventListener("PLAYER_LEAVE_COMBAT")
	self:AddEventListener("PLAYER_REGEN_ENABLED", "PLAYER_LEAVE_COMBAT")
	
	self:AddRepeatingTimer("CtaPartyScanEvent", 1, "ScanPartyTargets", self)
end

local function leaveArena()
	if self:HasEventListener("COMBAT_LOG_EVENT_UNFILTERED") then self:RemoveEventListener("COMBAT_LOG_EVENT_UNFILTERED") end
	if self:HasEventListener("UPDATE_MOUSEOVER_UNIT") then self:RemoveEventListener("UPDATE_MOUSEOVER_UNIT") end
	if self:HasEventListener("UNIT_HEALTH") then self:RemoveEventListener("UNIT_HEALTH") end
	if self:HasEventListener("PLAYER_TARGET_CHANGED") then self:RemoveEventListener("PLAYER_TARGET_CHANGED") end
	
	if self.db.profile.layout.mana_bar.enabled then
		if self:HasEventListener("UNIT_MANA") then self:RemoveEventListener("UNIT_MANA") end
		if self:HasEventListener("UNIT_RAGE") then self:RemoveEventListener("UNIT_RAGE") end
		if self:HasEventListener("UNIT_ENERGY") then self:RemoveEventListener("UNIT_ENERGY") end
	end
	
	if self:HasEventListener("PLAYER_LEAVE_COMBAT") then self:RemoveEventListener("PLAYER_LEAVE_COMBAT") end
	if self:HasEventListener("PLAYER_REGEN_ENABLED") then self:RemoveEventListener("PLAYER_REGEN_ENABLED") end
	if self:HasEventListener("UNIT_AURA") then self:RemoveEventListener("UNIT_AURA") end
	
	if self:HasTimer("CtaPartyScanEvent") then self:RemoveTimer("CtaPartyScanEvent") end
	if self.db.profile.layout.cast_bar.enabled then 
		if self:HasTimer("UpdateAllCastingBars") then self:RemoveTimer("UpdateAllCastingBars") end
	end
	
	if self.db.profile.layout.class_icon.enabled and self.db.profile.layout.class_icon.portrait ~= "class" then
		if self:HasEventListener("UNIT_PORTRAIT_UPDATE") then self:RemoveEventListener("UNIT_PORTRAIT_UPDATE") end		
	end
	
	resetFrame()
end

function ControlArena:OnDisable()
	if self.frame and self.frame:IsShown() then
		if self.toggleshow then
			self.toggleshow = nil
			self:TestFrame()
		else
			leaveArena()
		end
	end
	
	DEFAULT_CHAT_FRAME:AddMessage(("|cff0099ff%s %s|r |cffff0000%s|r."):format(self.name, self.version, L["disabled"]))
end

function ControlArena:TestFrame()
	if self.toggleshow then	
		enterArena()
		
		local data = new()
		data.name = UnitName("player")
		data.class = select(2, UnitClass("player"))
		data.health = 100
		data.energy = 100
		data.powertype = UnitPowerType("player")
		data.guid = UnitGUID("player")
		addGuy(data, "player")
				
		data = new()
		data.name = "Cocoh"
		data.class = "WARLOCK"
		data.health = 100
		data.energy = 100
		data.powertype = 0
		data.guid = "0125"
		addGuy(data)
		
		data = new()
		data.name = "Yamboo"
		data.class = "PALADIN"
		data.health = 100
		data.energy = 100
		data.powertype = 0
		data.guid = "0126"
		addGuy(data)
		
		data = new()
		data.name = "Gladie"
		data.class = "ROGUE"
		data.health = 100
		data.energy = 100
		data.powertype = 3
		data.guid = "0127"
		addGuy(data)
		
		data = new()
		data.name = "Thalestris"
		data.class = "HUNTER"
		data.health = 100
		data.energy = 100
		data.powertype = 0
		data.guid = "0128"
		addGuy(data)
		
		self:UpdateHealth("Cocoh", 25)
		self:UpdateMana("Cocoh", 45, 0)
		self:UpdateHealth("Gladie", 0, "DEAD")
		self:UpdateMana("Gladie", 35, 3)
		
		self:FakeCastingBar(true, "Cocoh", "Siphon Life (4.4)", true, 4.4, 5)
		self:FakeCastingBar(true, "Yamboo", "Holy Ligth (1.2)", false, 1.2, 2.5)
		
		self.frame:Show()
	else
		leaveArena()
		self:FakeCastingBar(false)
		resetFrame()
	end
end

local function message(msg)
	if not self.db.profile.warnings.enabled then return end
	
	if self.db.profile.announce.enabled and IsPartyLeader() and isInArena() then
		SendChatMessage(msg, self.db.profile.announce.channel)
	end
	
	ctaDebug("Message", msg)
end

local function announce(guy)
	message(guy.name .. " : " .. getLocalizedClass(guy.class))
end

local function refreshPortrait(unit, force)
	if not unit or not UnitExists(unit) then return end
	
	local p = self.db.profile.layout.class_icon.portrait
	if p == "class" then return end
		
	self:UpdatePortrait(unit, force)
end

local function isBuff(name)
	if self.db.profile.trackBuff.enabled then
		for k, v in pairs(self.db.profile.trackBuff.names) do
			if k == name then do return v end end
		end
	end
	return false
end

local function isRegen(name)
	if self.db.profile.trackRegen.enabled then
		for k, v in pairs(self.db.profile.trackRegen.names) do
			if k == name then do return v end end
		end
	end
	return false
end

local function isWarningBuff(name)
	if self.db.profile.trackDebuff.enabled then
		for k, v in pairs(self.db.profile.trackDebuff.names) do
			if k == name then do return v end end
		end
	end
	return false
end

local function callWarningSpell(spell)
	if self.db.profile.trackSpell.enabled then
		for k, v in pairs(self.db.profile.trackSpell.names) do
			if k == name then do return v end end
		end
	end
	return false
end

local lastCheckTime = {}
local function doTime(aura, unitName, timestamp)
	if not lastCheckTime[aura] then
		lastCheckTime[aura] = new()
	end
	
	lastCheckTime[aura][unitName] = timestamp
end
local function checkTime(aura, unitName, timestamp)
	if not lastCheckTime[aura] then
		return true
	end
	if not lastCheckTime[aura][unitName] then
		return true
	end
	if (timestamp - lastCheckTime[aura][unitName]) < 2 then
		return false
	end
	return true
end
local function testAura(type, timestamp, aura, unitName)
	if checkTime(aura, unitName, timestamp) then
		if isBuff(aura) and type == 0 then
			doTime(aura, unitName, timestamp)
			message(L["%s on %s !"]:format(aura, unitName))
		elseif isRegen(aura) and type == 0 then
			doTime(aura, unitName, timestamp)
			message(L["%s regen !"]:format(unitName))
		elseif isWarningBuff(aura) and type == 1 then
			doTime(aura, unitName, timestamp)
			message(L["%s on %s !"]:format(aura, unitName))
		end
	end
end
function ControlArena:UNIT_AURA(ns, event, unit)
	local n = UnitName(unit)
	if inList(n) then
		local i = 1
		while true do
			local buff = UnitBuff(unit, i)
			if not buff then do break end end
			
			if isRegen(buff) and checkTime(buff, n, time()) then
				doTime(buff, n, time())
				message(L["%s regen !"]:format(n))		
				do break end
			end
			
			i = i + 1
		end
	end
end

local function realName(name)
	if name and name:find("-") then
		name = select(1, string.split("-", name))
	end
	
	return name
end

function ControlArena:COMBAT_LOG_EVENT_UNFILTERED(ns, event, timestamp, eventType, sourceGUID,
			sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	
	sourceName = realName(sourceName)
	destName = realName(destName)
	
	ctaDebug("timestamp", date("%H:%M:%S", timestamp), "eventType", eventType)
	ctaDebug("sourceGUID", sourceGUID, "sourceName", sourceName, "sourceFlags", sourceFlags)
	ctaDebug("destGUID", destGUID, "destName", destName, "destFlags", destFlags)
	ctaDebug(...)
	ctaDebug("-------------------------")
	
	if eventType:find("SPELL_") then
		if eventType:find("_CAST_START") or eventType:find("_CAST_SUCCESS") or eventType:find("_CAST_FAILED") then
			if not inList(sourceName) then return end
			
			local spellID = select(1, ...)
			
			if eventType:find("_CAST_START") then
				local spell, _, icon, _, channeled, _, castTime = GetSpellInfo(spellID)
				
				local startTime = GetTime() * 1000
				local endTime = (GetTime() * 1000) + castTime
				self:UpdateCasting(sourceName, spell, "start", channeled, startTime, endTime, icon)	
				sendComm("Casting", sourceName, spell, "start", channeled, startTime, endTime, icon)
				
				if callWarningSpell(spell) then
					if destName and not inList(destName) then
						message(L["%s casting %s on %s !"]:format(n, spell, destName))
					else
						message(L["%s casting %s !"]:format(n, spell))
					end
				end
			elseif eventType:find("_CAST_SUCCESS") then
				sendComm("Casting", sourceName, "", "stop", false, "", GetTime())
				self:UpdateCasting(sourceName, nil, "stop", false, nil, GetTime())
			elseif eventType:find("_CAST_FAILED") then
				sendComm("Casting", sourceName, FAILED, "break", false, "", GetTime())	
				self:UpdateCasting(sourceName, FAILED, "break", false, nil, GetTime())
			end
		elseif eventType:find("_AURA_APPLIED") then
			local aura, auraType = select(2, ...)
			if inList(destName) then
				testAura(0, timestamp, aura, destName)
			else
				testAura(1, timestamp, aura, destName)
			end
		elseif eventType:find("_HEAL") or eventType:find("_DAMAGE") then
			if destName then
				local school, amount = select(3, ...)
				self:UpdateCombatText(destName, amount, school, eventType)
			end
		elseif eventType:find("_MISSED") then
			if destName then
				local school, amount = select(3, ...)
				self:UpdateCombatText(destName, amount, school, eventType)
			end
		end
	elseif eventType:find("SWING_DAMAGE") or eventType:find("SWING_MISSED") then
		if destName then
			local amount = select(1, ...)
			self:UpdateCombatText(destName, amount, 1, eventType)
		end
	elseif eventType:find("RANGE_DAMAGE") or eventType:find("RANGE_MISSED") then
		if destName then
			local amount = select(4, ...)
			self:UpdateCombatText(destName, amount, 1, eventType)
		end
	elseif eventType:find("PARTY_KILL") then
		self:UpdateHealth(destName, 0, "DEAD")
		sendComm("UpdateHealth", destName, 0, "DEAD")
	end
end

function ControlArena:UNIT_PORTRAIT_UPDATE(ns, event, unit)
	local name = UnitName(unit)
	if not name or not inList(name) then return end
	refreshPortrait(unit, true)
end

local function inspectEnergy(unit)
	local manamax = UnitManaMax(unit)
	local mana = UnitMana(unit)
	local powertype = UnitPowerType(unit)
	
	local m
	if maxMana == 100 then
		m = mana
	else
		m = floor(mana / manamax * 100)
	end
	
	return m, powertype
end

function ControlArena:UNIT_MANA()
	if not self.db.profile.layout.mana_bar.enabled then return end
	
	local name = UnitName(arg1)
	if not name or not inList(name) then return end	
	
	local m, powertype = inspectEnergy(arg1)
	refreshPortrait(arg1, false)
	
	local values = getValuesFor(name)
	if values then
		if values.energy ~= m or values.powertype ~= powertype then			
			self:UpdateMana(name, m, powertype)
			sendComm("UpdateMana", name, m, powertype)
		end
		
		if not values.talent or values.talent == "" then
			inspectName = name
			NotifyInspect(arg1)
		end
	end
end

local classes = {
	[1] = "WARRIOR", [2] = "PALADIN",
	[3] = "HUNTER", [4] = "ROGUE",
	[5] = "PRIEST", [7] = "SHAMAN",
	[8] = "MAGE", [9] = "WARLOCK",
	[11] = "DRUID",
}

local function parseUnit(unit)
	local hpmax = UnitHealthMax(unit)
	local hp = UnitHealth(unit)
	local class = select(2, UnitClass(unit))
	local name = UnitName(unit)
	
	local value = 100
	if hpmax == 100 then
		value = hp
	else
		value = floor(hp / hpmax * 100)
	end
	local status = ""
	if hp <= 0 then
		if UnitDebuff(unit, 1) and class == "HUNTER" then
			status = "FD"
		else
			status = "DEAD"
			value = 0
		end
	end
	
	return value, status
end

function ControlArena:UNIT_HEALTH()
	local n = UnitName(arg1)
	if not n then return end
	if inList(n) then
		local value, status = parseUnit(arg1)
		refreshPortrait(arg1, false)
		
		local values = getValuesFor(n)
		if values then
			if values.health ~= value then
				self:UpdateHealth(n, value, status, true)
				sendComm("UpdateHealth", n, value, status)
			end
		end		
	end
end

function ControlArena:PLAYER_LEAVE_COMBAT()
	if not self.frame then return end
	
	for i=1, #self.list do
		if self.frame.frames[i] and self.frame.frames[i].in_combat then
			self:RefreshHealthBarOutCombatLock(i)
		end
	end
end

local function buildNewPlayer(unit)
	local n, r = UnitName(unit)
	
	if inList(n) then return end
	
	if not UnitIsFriend("player", unit) and UnitIsPlayer(unit) then		
		if r == '' then
			r = nil
		end
		r = r or GetRealmName()
		guid = UnitGUID(unit)
		
		local health, status = parseUnit(unit)
		local mana, powertype = inspectEnergy(unit)
		local class = select(2, UnitClass(unit))
			
		if not inList(n) then
			local d = new()
			d.name = n
			d.class = class
			d.health = health
			d.energy = mana
			d.powertype = powertype
			d.guid = guid
			
			addGuy(d, unit)
			
			announce(d)
			sendComm("Discover", d.name, d.class, d.health, d.energy, d.powertype, d.guid)
		end
	end
end

function ControlArena:UPDATE_MOUSEOVER_UNIT()
	local n = UnitName("mouseover")
	if not n then return end
	if inList(n) then
		refreshPortrait("mouseover", false)
	else
		buildNewPlayer("mouseover")
	end
end

function ControlArena:PLAYER_TARGET_CHANGED()
	local n = UnitName("target")
	if not n then return end
	if inList(n) then
		local value, status = parseUnit("target")
		
		local values = getValuesFor(n)
		if values then
			if values.health ~= value then
				local force = false
				if values.status and values.status == "DEAD" and value ~= 0 then
					force = true
				end
				self:UpdateHealth(n, value, status, force)
				sendComm("UpdateHealth", n, value, status)
			end
			
			local m, powertype = inspectEnergy("target")
			if values.energy ~= m or values.powertype ~= powertype then
				self:UpdateMana(n, m, powertype)
				sendComm("UpdateMana", n, m, powertype)
			end
		end
		
		refreshPortrait("target", false)
	else
		buildNewPlayer("target")
	end
end

function ControlArena:PLAYER_ENTERING_WORLD()
	self:AddTimer("inarena", 5, self.InArena)
end

function ControlArena:PLAYER_LOGIN()
	self.is_logged = true
end

--[[ Communications functions ]]
function ControlArena.OnCommReceive:Casting(self, distribution, sender, name, spell, status, channeling, startTime, endTime, icon)
	if not ControlArena.db.profile.layout.cast_bar.enabled then return end
	
	if spell == "" then spell = nil end
	if startTime == "" then startTime = nil end
	
	if not spell then return end
	
	ControlArena:UpdateCasting(name, spell, status, channeling, startTime, endTime, icon)
end

function ControlArena.OnCommReceive:Discover(self, distribution, sender, name, class, health, mana, powertype--[[, talent]], guid)
	local d = new()
	d.name = name
	d.class = class
	d.health = health
	d.energy = mana
	d.powertype = powertype
	d.guid = guid
	
	addGuy(d)
end

function ControlArena.OnCommReceive:UpdateHealth(self, distribution, sender, name, health, status)
	ControlArena:UpdateHealth(name, health, status)
end

function ControlArena.OnCommReceive:UpdateMana(self, distribution, sender, name, mana, powertype)
	if not ControlArena.db.profile.layout.mana_bar.enabled then return end
	
	ControlArena:UpdateMana(name, mana, powertype)
end

function ControlArena:InArena()
	if isInArena() then
		enterArena()
	else
		leaveArena()
	end
end

function ControlArena:ScanPartyTargets(self)
	local unit
	for i=1, GetNumPartyMembers() + 1 do
		unit = "party" .. i .. "target"
		local n = UnitName(unit)
		if UnitExists(unit) then
			if inList(n) then
				refreshPortrait(unit, false)
				
				local values = getValuesFor(n)
				if values then
					local value, status = parseUnit(unit)
					if values.health ~= value then
						self:UpdateHealth(n, value, status)
						sendComm("UpdateHealth", n, value, status)
					end
					
					local m, powertype = inspectEnergy(unit)
					if values.energy ~= m or values.powertype ~= powertype then
						self:UpdateMana(n, m, powertype)
						sendComm("UpdateMana", n, m, powertype)
					end
				end
			else
				buildNewPlayer(unit)
			end
		end
	end
end
