local MAJOR_VERSION = "LibSpell-1.0"
local MINOR_VERSION = 0

if not Rock then error(MAJOR_VERSION .. " requires LibRock-1.0") end

local LibSpell, oldLib = Rock:NewLibrary(MAJOR_VERSION, MINOR_VERSION)
if not LibSpell then
	return
end

local LS = LibStub("LibBabble-Spell-3.0"):GetUnstrictLookupTable()

local newList, del = Rock:GetRecyclingFunctions(MAJOR_VERSION, "newList", "del")
local precondition, postcondition, argCheck = Rock:GetContractFunctions("LibSpell", "precondition", "postcondition", "argCheck")


local spells = {
    talent = {
        LS["Ancestral Knowledge"],
        LS["Aftermath"],
        LS["Aggression"],
        LS["Anger Management"],
        LS["Anticipation"],
        LS["Arcane Concentration"],
        LS["Arcane Focus"],
        LS["Arcane Impact"],        
		LS["Arcane Instability"],
		LS["Arcane Meditation"],
		LS["Arcane Mind"],
		LS["Arcane Potency"],
		LS["Arcane Resistance"],
        LS["Arcane Subtlety"],
        LS["Arctic Reach"],
		LS["Arctic Winds"],
        LS["Avoidance"],
        LS["Balance of Power"],
		LS["Bane"],
        LS["Barrage"],
        LS["Battle Rush"],
		LS["Beast Slaying"],
		LS["Benediction"],
		LS["Berserking"],
		LS["Bestial Discipline"],
		LS["Bestial Swiftness"],
		LS["Blackout"],
        LS["Blade Twisting"],
        LS["Blazing Speed"],
        LS["Blessed Recovery"],
        LS["Blessed Resilience"],
        LS["Blood Craze"],
		LS["Blood Frenzy"],
		LS["Booming Voice"],
        LS["Bow Specialization"],
		LS["Brutal Impact"],
        LS["Burning Soul"],
		LS["Killer Instinct"],
        LS["Gift of Nature"],
        LS["Great Stamina"],
        LS["Grim Reach"],
        LS["Guardian's Favor"],
		LS["Gun Specialization"],
        LS["Quick Recovery"],
		LS["Quickness"],        
		LS["Improved Weapon Totems"],
		LS["Improved Mana Spring Totem"],
		LS["Improved Magma Totem"],
		LS["Improved Fire Totems"],
        LS["Improved Ambush"],
		LS["Improved Arcane Missiles"],
		LS["Improved Arcane Shot"],
		LS["Improved Aspect of the Hawk"],
		LS["Improved Aspect of the Monkey"],
		LS["Improved Backstab"],
		LS["Improved Barrage"],
		LS["Improved Berserker Rage"],
		LS["Improved Blessing of Might"],
		LS["Improved Blessing of Wisdom"],
		LS["Improved Blink"],
		LS["Improved Blizzard"],
		LS["Improved Bloodrage"],
		LS["Improved Chain Heal"],
		LS["Improved Chain Lightning"],
		LS["Improved Challenging Shout"],
		LS["Improved Charge"],
		LS["Improved Cleave"],
		LS["Improved Concentration Aura"],
		LS["Improved Concussive Shot"],
		LS["Improved Cone of Cold"],
		LS["Improved Corruption"],
		LS["Improved Counterspell"],
		LS["Improved Curse of Agony"],
		LS["Improved Curse of Weakness"],
		LS["Improved Demoralizing Shout"],
		LS["Improved Devotion Aura"],
		LS["Improved Disarm"],
		LS["Improved Drain Life"],
		LS["Improved Drain Soul"],
		LS["Improved Enrage"],
		LS["Improved Enslave Demon"],
		LS["Improved Eviscerate"],
		LS["Improved Execute"],
		LS["Improved Expose Armor"],
		LS["Improved Eyes of the Beast"],
		LS["Improved Fade"],
		LS["Improved Feign Death"],
		LS["Improved Fire Blast"],
		LS["Improved Fire Ward"],
		LS["Improved Fireball"],
		LS["Improved Firebolt"],
		LS["Improved Flamestrike"],
		LS["Improved Flash of Light"],
		LS["Improved Frost Nova"],
		LS["Improved Frostbolt"],
		LS["Improved Ghost Wolf"],
		LS["Improved Gouge"],
		LS["Improved Hammer of Justice"],
		LS["Improved Hamstring"],
		LS["Improved Healing"],
		LS["Improved Healing Touch"],
		LS["Improved Healing Wave"],
		LS["Improved Health Funnel"],
		LS["Improved Healthstone"],
		LS["Improved Heroic Strike"],
		LS["Improved Holy Shield"],
		LS["Improved Howl of Terror"],
		LS["Improved Hunter's Mark"],
		LS["Improved Immolate"],
		LS["Improved Imp"],
		LS["Improved Inner Fire"],
		LS["Improved Intercept"],
		LS["Improved Intimidating Shout"],
		LS["Improved Judgement"],
		LS["Improved Kick"],
		LS["Improved Kidney Shot"],
		LS["Improved Lash of Pain"],
		LS["Improved Lay on Hands"],
		LS["Improved Leader of the Pack"],
		LS["Improved Life Tap"],
		LS["Improved Lightning Bolt"],
		LS["Improved Lightning Shield"],
		LS["Improved Mana Burn"],
		LS["Improved Mana Shield"],
		LS["Improved Mark of the Wild"],
		LS["Improved Mend Pet"],
		LS["Improved Mind Blast"],
		LS["Improved Moonfire"],
		LS["Improved Mortal Strike"],
		LS["Improved Nature's Grasp"],
		LS["Improved Overpower"],
		LS["Improved Power Word: Fortitude"],
		LS["Improved Power Word: Shield"],
		LS["Improved Prayer of Healing"],
		LS["Improved Psychic Scream"],
		LS["Improved Regrowth"],
		LS["Improved Reincarnation"],
		LS["Improved Rejuvenation"],
		LS["Improved Rend"],
		LS["Improved Renew"],
		LS["Improved Retribution Aura"],
		LS["Improved Revenge"],
		LS["Improved Revive Pet"],
		LS["Improved Righteous Fury"],
		LS["Improved Rupture"],
		LS["Improved Scorch"],
		LS["Improved Scorpid Sting"],
		LS["Improved Seal of Righteousness"],
		LS["Improved Seal of the Crusader"],
		LS["Improved Searing Pain"],
		LS["Improved Serpent Sting"],
		LS["Improved Shadow Bolt"],
		LS["Improved Shadow Word: Pain"],
		LS["Improved Shield Bash"],
		LS["Improved Shield Block"],
		LS["Improved Shield Wall"],
		LS["Improved Sinister Strike"],
		LS["Improved Slam"],
		LS["Improved Slice and Dice"],
		LS["Improved Sprint"],
		LS["Improved Stings"],
		LS["Improved Succubus"],
		LS["Improved Sunder Armor"],
		LS["Improved Taunt"],
		LS["Improved Thunder Clap"],
		LS["Improved Tranquility"],
		LS["Improved Vampiric Embrace"],
		LS["Improved Vanish"],
		LS["Improved Voidwalker"],
		LS["Improved Whirlwind"],
		LS["Improved Wing Clip"],
		LS["Call of Flame"],
		LS["Call of Thunder"],
		LS["Cataclysm"],
		LS["Celestial Focus"],
		LS["Clever Traps"],
		LS["Call of the Nexus"],
		LS["Cat Form"],
		LS["Clearcasting"],
		LS["Combat Endurance"],
		LS["Command"],  
		LS["Commanding Presence"],      
		LS["Concussion"],
		LS["Concussive Barrage"],
		LS["Contagion"],
		LS["Convection"],
		LS["Conviction"],
		LS["Critical Mass"],
		LS["Cruelty"],
		LS["Crusade"],
		LS["Wand Specialization"],
		LS["Weapon Mastery"],
		LS["Winter's Chill"],
		LS["Wrath of Cenarius"],
		LS["Unbreakable Will"],		
		LS["Unbridled Wrath"],
		LS["Unholy Power"],
		LS["Unleashed Fury"],
		LS["Unleashed Rage"],
		LS["Unyielding Faith"],
		LS["Vigor"],
		LS["Vindication"],
    },
    buff = {
        LS["Adrenaline Rush"],
        LS["Amplify Curse"],
		LS["Amplify Magic"],
		LS["Ancestral Fortitude"],
        LS["Ancestral Healing"],
        LS["Aquatic Form"],
        LS["Arcane Brilliance"],
        LS["Arcane Energy"],
        LS["Arcane Fortitude"],
		LS["Aspect of the Beast"],
		LS["Aspect of the Cheetah"],
		LS["Aspect of the Hawk"],
		LS["Aspect of the Monkey"],
		LS["Aspect of the Pack"],
		LS["Aspect of the Viper"],
		LS["Aspect of the Wild"],
		LS["Blessing of Auchindoun"],
		LS["Blessing of Freedom"],
		LS["Blessing of Kings"],
		LS["Blessing of Light"],
		LS["Blessing of Might"],
		LS["Blessing of Protection"],
		LS["Blessing of Sacrifice"],
		LS["Blessing of Salvation"],
		LS["Blessing of Sanctuary"],
		LS["Blessing of Wisdom"],
		LS["Track Beasts"],
		LS["Track Demons"],
		LS["Track Dragonkin"],
		LS["Track Elementals"],
		LS["Track Giants"],
		LS["Track Hidden"],
		LS["Track Humanoids"],
		LS["Track Undead"],
        LS["Arcane Intellect"],
		LS["Arcane Power"],
        LS["Avenging Wrath"],
        LS["Backlash"],
        LS["Badge of the Swarmguard"],        
		LS["Barkskin"],
		LS["Battle Shout"],
		LS["Battle Stance"],
		LS["Bear Form"],
		LS["Berserker Rage"],
		LS["Berserker Stance"],
        LS["Blade Flurry"],
        LS["Blade Turning"],
		LS["Blood Fury"],
		LS["Blood Pact"],
		LS["Bloodlust"],
		LS["Bloodrage"],
		LS["Bloodthirst"],
		LS["Brittle Armor"],
        LS["Burning Wish"],
        LS["Jom Gabbar"],
		LS["Kiss of the Spider"],
        LS["Ghost Wolf"],
        LS["Gift of Life"],
        LS["Gift of the Naaru"],
        LS["Gift of the Wild"],
        LS["Grace of Air"],
		LS["Greater Blessing of Kings"],
		LS["Greater Blessing of Light"],
		LS["Greater Blessing of Might"],
		LS["Greater Blessing of Salvation"],
		LS["Greater Blessing of Sanctuary"],
		LS["Greater Blessing of Wisdom"],
		LS["Greater Dreamless Sleep"],
        LS["Grounding Totem Effect"],
		LS["Quick Shots"],
		LS["Cold Blood"],
		LS["Combustion"],
		LS["Commanding Shout"],
		LS["Concentration Aura"],
		LS["Crusader Aura"],
		LS["Water Breathing"],
		LS["Water Shield"],
		LS["Water Walking"],
		LS["Well Fed"],
		LS["Will of the Forsaken"],
		LS["Windfury Weapon"],
		LS["Windwall"],
		LS["Wisp Spirit"],
		LS["Underwater Breathing"],
		LS["Unending Breath"],
		LS["Vanished"],
		LS["Victory Rush"],
    },
    debuff = {
        LS["Ancient Hysteria"],
        LS["Arcane Weakness"],
        LS["Banshee Curse"],
		LS["Blind"],
        LS["Burning Adrenaline"],
        LS["Garrote"],
		LS["Garrote - Silence"],
		LS["Gouge"],
		LS["Conflagration"],
		LS["Corruption"],
		LS["Curse of Agony"],
		LS["Curse of Doom"],
		LS["Curse of Doom Effect"],
		LS["Curse of Exhaustion"],
		LS["Curse of Idiocy"],
		LS["Curse of Recklessness"],
		LS["Curse of Shadow"],
		LS["Curse of Tongues"],
		LS["Curse of Weakness"],
		LS["Curse of the Elements"],
		LS["Cyclone"],
		LS["Water Tomb"],
		LS["Watery Grave"],
		LS["Weakened Soul"],
		LS["Unstable Affliction"],
		LS["Vampiric Embrace"],
		LS["Vampiric Touch"],
    },
    totem = {
        LS["Grace of Air Totem"],
		LS["Grounding Totem"],
		LS["Windfury Totem"],
		LS["Windwall Totem"],
		LS["Wrath of Air Totem"],
		LS["Tremor Totem"],
		LS["Tranquil Air Totem"],
		LS["Totem of Wrath"],
		LS["Strength of Earth Totem"],
		LS["Stoneskin Totem"],
		LS["Stoneclaw Totem"],
		LS["Sentry Totem"],
		LS["Searing Totem"],
		LS["Restorative Totems"],
		LS["Poison Cleansing Totem"],
		LS["Nature Resistance Totem"],
		LS["Mana Spring Totem"],
        LS["Magma Totem"],
		LS["Disease Cleansing Totem"],
		LS["Earth Elemental Totem"],
		LS["Earthbind Totem"],
		LS["Fire Elemental Totem"],
		LS["Fire Nova Totem"],
		LS["Fire Resistance Totem"],
		LS["Flametongue Totem"],
		LS["Frost Resistance Totem"],
		LS["Healing Stream Totem"],
		LS["Mana Tide Totem"],
        
        
		LS["Venomous Totem"],
    },
    resurrection = {
        LS["Ancestral Spirit"],
    },
    offensive = {
        LS["Attack"],
        LS["Auto Shot"],
        LS["Activate MG Turret"],
        LS["Aimed Shot"],
		LS["Ambush"],
        LS["Anguish"],
        LS["Arcane Blast"],
        LS["Arcane Explosion"],
        LS["Arcane Shot"],
        LS["Arcane Torrent"],
        LS["Arcane Missiles"],
        LS["Avenger's Shield"],
        LS["Backstab"],
        LS["Banish"],
        LS["Bash"],
		LS["Bestial Wrath"],
		LS["Bite"],
		LS["Blast Wave"],
		LS["Blizzard"],
		LS["Boar Charge"],
		LS["Judgement"],
		LS["Judgement of Blood"],
		LS["Judgement of Command"],
		LS["Judgement of Justice"],
		LS["Judgement of Light"],
		LS["Judgement of Reckoning"],
		LS["Judgement of Righteousness"],
		LS["Judgement of Wisdom"],
		LS["Judgement of the Crusader"],
        LS["Kick"],
		LS["Kick - Silenced"],
		LS["Kidney Shot"],
		LS["Kill Command"],
        LS["Ghostly Strike"],
        LS["Grovel"],
		LS["Growl"],		
		LS["Chain Lightning"],
		LS["Challenging Roar"],
		LS["Challenging Shout"],
		LS["Charge"],
		LS["Charge Stun"],
		LS["Chastise"],
		LS["Cheap Shot"],
		LS["Chilled"],
		LS["Cleave"],
		LS["Cobra Reflexes"],
		LS["Concussion Blow"],
		LS["Concussive Shot"],
		LS["Cone of Cold"],
		LS["Conflagrate"],
		LS["Consecration"],
		LS["Corruption"],
		LS["Counterattack"],
		LS["Counterspell"],
		LS["Counterspell - Silenced"],
		LS["Crusader Aura"],
		LS["Curse of Agony"],
		LS["Curse of Doom"],
		LS["Curse of Doom Effect"],
		LS["Curse of Exhaustion"],
		LS["Curse of Idiocy"],
		LS["Curse of Recklessness"],
		LS["Curse of Shadow"],
		LS["Curse of Tongues"],
		LS["Curse of Weakness"],
		LS["Curse of the Elements"],
		LS["Cyclone"],
		LS["War Stomp"],
		LS["Warp"],
		LS["Waterbolt"],
		LS["Whirlwind"],
		LS["Windfury"],
		LS["Windfury Attack"],
		LS["Wing Clip"],
		LS["Wrath"],
		LS["Wrath of the Astromancer"],
		LS["Wyvern Sting"],
		LS["Unstable Affliction"],
		LS["Vampiric Embrace"],
		LS["Vampiric Touch"],
		LS["Vengeance"],
		LS["Victory Rush"],
		LS["Vile Beam"],
		LS["Viper Sting"],
		LS["Volley"],
    },
    defensive = {
        LS["Abolish Disease"],
		LS["Abolish Poison"],
		LS["Abolish Poison Effect"],
        LS["Binding Heal"],
		LS["Blink"],
        LS["Block"],
        LS["Gift of the Naaru"],
        LS["Greater Heal"],
		LS["Call Pet"],
		LS["Camouflage"],
		LS["Chain Heal"],
		LS["Circle of Healing"],
		LS["Cleanse"],
		LS["Cloak of Shadows"],
		LS["Cold Snap"],
		LS["Consume Magic"],
		LS["Consume Shadows"],
		LS["Cower"],
		LS["Cure Disease"],
		LS["Cure Poison"],
		LS["Vanish"],
    },
    teleport = {    
        LS["Astral Recall"],
		LS["Teleport: Darnassus"],
		LS["Teleport: Exodar"],
		LS["Teleport: Ironforge"],
		LS["Teleport: Moonglade"],
		LS["Teleport: Orgrimmar"],
		LS["Teleport: Shattrath"],
		LS["Teleport: Silvermoon"],
		LS["Teleport: Stormwind"],
		LS["Teleport: Thunder Bluff"],
		LS["Teleport: Undercity"],
		LS["Portal: Darnassus"],
		LS["Portal: Exodar"],
		LS["Portal: Ironforge"],
		LS["Portal: Orgrimmar"],
		LS["Portal: Shattrath"],
		LS["Portal: Silvermoon"],
		LS["Portal: Stormwind"],
		LS["Portal: Thunder Bluff"],
		LS["Portal: Undercity"],
    },
    poison = {    
        LS["Anesthetic Poison"],
		LS["Instant Poison"],
		LS["Instant Poison II"],
		LS["Instant Poison III"],
		LS["Instant Poison IV"],
		LS["Instant Poison V"],
		LS["Instant Poison VI"],
		LS["Instant Poison VII"],
		LS["Wound Poison"],
		LS["Wound Poison II"],
		LS["Wound Poison III"],
		LS["Wound Poison IV"],
		LS["Wound Poison V"],
		LS["Deadly Poison"],
		LS["Deadly Poison II"],
		LS["Deadly Poison III"],
		LS["Deadly Poison IV"],
		LS["Deadly Poison V"],
		LS["Deadly Poison VI"],
		LS["Deadly Poison VII"],
		LS["Crippling Poison"],
		LS["Crippling Poison II"],
		LS["Vile Poisons"],
    },
    food = {    
		LS["Cannibalize"],
    },
    mount = {
        LS["Kodo Riding"],
		LS["Wolf Riding"],
    },
    tradeskill = {
        LS["Alchemy"],
		LS["Armorsmith"],
		LS["Axe Specialization"],
		LS["Basic Campfire"],
		LS["Blacksmithing"],
        LS["Bright Campfire"],
		LS["Jewelcrafting"],    		
		LS["Find Fish"],
		LS["Find Herbs"],
		LS["Find Minerals"],
		LS["Find Treasure"],
		LS["Cooking"],
		LS["Weaponsmith"],
    },
    uncategorized = {        
		LS["Ammunition"],	
		LS["Attacking"],	
		LS["Conjure Food"],
		LS["Conjure Mana Agate"],
		LS["Conjure Mana Citrine"],
		LS["Conjure Mana Emerald"],
		LS["Conjure Mana Jade"],
		LS["Conjure Mana Ruby"],
		LS["Conjure Water"],		
		LS["Arcane Shroud"],
		LS["Armor of Faith"],
		LS["Banker"],
        LS["Battle Stance Passive"],
		LS["BattleMaster"],
        LS["Beast Lore"],
        LS["Beast Training"],
		LS["Berserker Stance Passive"],
        LS["Black Arrow"],
		LS["Blinding Powder"],
        LS["Bows"],
		LS["Create Firestone"],
		LS["Create Firestone (Greater)"],
		LS["Create Firestone (Lesser)"],
		LS["Create Firestone (Major)"],
		LS["Create Healthstone"],
		LS["Create Healthstone (Greater)"],
		LS["Create Healthstone (Lesser)"],
		LS["Create Healthstone (Major)"],
		LS["Create Healthstone (Minor)"],
		LS["Create Soulstone"],
		LS["Create Soulstone (Greater)"],
		LS["Create Soulstone (Lesser)"],
		LS["Create Soulstone (Major)"],
		LS["Create Soulstone (Minor)"],
		LS["Create Spellstone"],
		LS["Create Spellstone (Greater)"],
		LS["Create Spellstone (Major)"],
		LS["Create Spellstone (Master)"],
		LS["Guns"],
		LS["Charge Rage Bonus Effect"],
        LS["Class Trainer"],
		LS["Claw"],
		LS["Closing"],
		LS["Cloth"],
		LS["Coarse Sharpening Stone"],
		LS["Cripple"],
		LS["Crossbows"],
		LS["Cultivation"],
		LS["Wands"],
		LS["Warsong Flag"],
		LS["Unarmed"],
		LS["Undead Horsemanship"],
		LS["Unstable Power"],
		
        -- defensive
		
		-- talent
		
		-- buff	
		
		-- offen
		
		-- debuff
		
		-- trade
		
		-- foodr
		
		-- not yet done
        
        
		LS["Dagger Specialization"],
		LS["Daggers"],
		LS["Dampen Magic"],
		LS["Dark Pact"],
		LS["Darkness"],
		LS["Dash"],
		LS["Dawnstone Crab"],
		LS["Dazed"],
		LS["Deadly Interrupt Effect"],
		LS["Deadly Throw"],
		LS["Death Coil"],
		LS["Death Wish"],
		LS["Deep Wound"],
		LS["Deep Wounds"],
		LS["Defense"],
		LS["Defensive Stance"],
		LS["Defensive Stance Passive"],
		LS["Defiance"],
		LS["Deflection"],
		LS["Delusions of Jin'do"],
		LS["Demon Armor"],
		LS["Demon Skin"],
		LS["Demonic Aegis"],
		LS["Demonic Embrace"],
		LS["Demonic Frenzy"],
		LS["Demonic Knowledge"],
		LS["Demonic Resilience"],
		LS["Demonic Sacrifice"],
		LS["Demonic Tactics"],
		LS["Demoralizing Roar"],
		LS["Demoralizing Shout"],
		LS["Dense Sharpening Stone"],
		LS["Desperate Prayer"],
		LS["Destructive Reach"],
		LS["Detect"],
		LS["Detect Greater Invisibility"],
		LS["Detect Invisibility"],
		LS["Detect Lesser Invisibility"],
		LS["Detect Magic"],
		LS["Detect Traps"],
		LS["Deterrence"],
		LS["Devastate"],
		LS["Devastation"],
		LS["Devotion Aura"],
		LS["Devour Magic"],
		LS["Devour Magic Effect"],
		LS["Devouring Plague"],
		LS["Diplomacy"],
		LS["Dire Bear Form"],
		LS["Dirty Deeds"],
		LS["Dirty Tricks"],
		LS["Disarm"],
		LS["Disarm Trap"],
		LS["Disenchant"],
		LS["Disengage"],
		LS["Dismiss Pet"],
		LS["Dispel Magic"],
		LS["Distract"],
		LS["Distracting Shot"],
		LS["Dive"],
		LS["Divine Favor"],
		LS["Divine Fury"],
		LS["Divine Illumination"],
		LS["Divine Intellect"],
		LS["Divine Intervention"],
		LS["Divine Protection"],
		LS["Divine Shield"],
		LS["Divine Spirit"],
		LS["Divine Strength"],
		LS["Divine Wrath"],
		LS["Dodge"],
		LS["Doomfire"],
		LS["Dragon's Breath"],
		LS["Dragonscale Leatherworking"],
		LS["Drain Life"],
		LS["Drain Mana"],
		LS["Drain Soul"],
		LS["Dreamless Sleep"],
		LS["Drink"],
		LS["Dual Wield"],
		LS["Dual Wield Specialization"],
		LS["Duel"],
		LS["Dust Cloud"],
        
		LS["Eagle Eye"],
		LS["Earth Shield"],
		LS["Earth Shock"],
		LS["Earthbind"],
		LS["Earthstrike"],
		LS["Efficiency"],
		LS["Elemental Devastation"],
		LS["Elemental Focus"],
		LS["Elemental Fury"],
		LS["Elemental Leatherworking"],
		LS["Elemental Mastery"],
		LS["Elemental Precision"],
		LS["Elemental Sharpening Stone"],
		LS["Elemental Weapons"],
		LS["Elune's Grace"],
		LS["Elusiveness"],
		LS["Emberstorm"],
		LS["Empowered Arcane Missiles"],
		LS["Empowered Corruption"],
		LS["Empowered Fireball"],
		LS["Empowered Frostbolt"],
		LS["Empowered Healing"],
		LS["Empowered Rejuvenation"],
		LS["Empowered Touch"],
		LS["Enamored Water Spirit"],
		LS["Enchanting"],
		LS["Endurance"],
		LS["Endurance Training"],
		LS["Engineering"],
		LS["Engineering Specialization"],
		LS["Enrage"],
		LS["Enriched Manna Biscuit"],
		LS["Enslave Demon"],
		LS["Entangling Roots"],
		LS["Entrapment"],
		LS["Envenom"],
		LS["Escape Artist"],
		LS["Evasion"],
		LS["Eviscerate"],
		LS["Evocation"],
		LS["Execute"],
		LS["Exorcism"],
		LS["Expansive Mind"],
		LS["Explosive Trap"],
		LS["Explosive Trap Effect"],
		LS["Expose Armor"],
		LS["Expose Weakness"],
		LS["Extract Gas"],
		LS["Eye for an Eye"],
		LS["Eye of Kilrogg"],
		LS["Eye of the Storm"],
		LS["Eyes of the Beast"],
        
		LS["Fade"],
		LS["Faerie Fire"],
		LS["Faerie Fire (Feral)"],
		LS["Fanaticism"],
		LS["Far Sight"],
		LS["Fatal Attraction"],
		LS["Fear"],
		LS["Fear Ward"],
		LS["Feed Pet"],
		LS["Feed Pet Effect"],
		LS["Feedback"],
		LS["Feign Death"],
		LS["Feint"],
		LS["Fel Armor"],
		LS["Fel Concentration"],
		LS["Fel Domination"],
		LS["Fel Energy"],
		LS["Fel Intellect"],
		LS["Fel Rage"],
		LS["Fel Stamina"],
		LS["Felfire"],
		LS["Feline Grace"],
		LS["Feral Aggression"],
		LS["Feral Charge"],
		LS["Feral Instinct"],
		LS["Feral Swiftness"],
		LS["Ferocious Bite"],
		LS["Ferocious Inspiration"],
		LS["Ferocity"],
		LS["Fetish"],
		LS["Find Weakness"],
		LS["Fire Blast"],
		LS["Fire Breath"],
		LS["Fire Power"],
		LS["Fire Resistance"],
		LS["Fire Shield"],
		LS["Fire Vulnerability"],
		LS["Fire Ward"],
		LS["Fire Weakness"],
		LS["Fireball"],
		LS["Firebolt"],
		LS["First Aid"],
		LS["Fishing"],
		LS["Fishing Poles"],
		LS["Fist Weapon Specialization"],
		LS["Fist Weapons"],
		LS["Flame Shock"],
		LS["Flame Throwing"],
		LS["Flamestrike"],
		LS["Flamethrower"],
		LS["Flametongue Attack"],
		LS["Fire Resistance Aura"],
		LS["Flametongue Weapon"],
		LS["Flare"],
		LS["Flash Heal"],
		LS["Flash of Light"],
		LS["Flight Form"],
		LS["FlightMaster"],
		LS["Flurry"],
		LS["Focused Casting"],
		LS["Focused Mind"],
		LS["Focused Power"],
		LS["Focused Rage"],
		LS["Focused Starlight"],
		LS["Food"],
		LS["Food & Drink"],
		LS["Forbearance"],
		LS["Force of Nature"],
		LS["Force of Will"],
		LS["Freezing Trap"],
		LS["Freezing Trap Effect"],
		LS["Frenzied Regeneration"],
		LS["Frenzy"],
		LS["Frenzy Effect"],
		LS["Frost Armor"],
		LS["Frost Blast"],
		LS["Frost Channeling"],
		LS["Frost Nova"],
		LS["Frost Resistance"],
		LS["Frost Resistance Aura"],
		LS["Frost Shock"],
		LS["Frost Trap"],
		LS["Frost Trap Aura"],
		LS["Frost Ward"],
		LS["Frost Warding"],
		LS["Frost Weakness"],
		LS["Frostbite"],
		LS["Frostbolt"],
		LS["Frostbrand Attack"],
		LS["Frostbrand Weapon"],
		LS["Frozen Core"],
		LS["Furious Howl"],
		LS["Furor"],
		LS["Fury of the Crashing Waves"],
        
		
        
		LS["Hammer of Justice"],
		LS["Hammer of Wrath"],
		LS["Hamstring"],
		LS["Harass"],
		LS["Hardiness"],
		LS["Haste"],
		LS["Hawk Eye"],
		LS["Heal"],
		LS["Healing Focus"],
		LS["Healing Light"],
		LS["Healing Stream"],
		LS["Healing Touch"],
		LS["Healing Wave"],
		LS["Healing Way"],
		LS["Health Funnel"],
		LS["Heart of the Wild"],
		LS["Heavy Sharpening Stone"],
		LS["Hellfire"],
		LS["Hellfire Effect"],
		LS["Hellfire Superiority"],
		LS["Hemorrhage"],
		LS["Herb Gathering"],
		LS["Herbalism"],
		LS["Heroic Strike"],
		LS["Heroism"],
		LS["Hex of Weakness"],
		LS["Hibernate"],
		LS["Holy Fire"],
		LS["Holy Light"],
		LS["Holy Nova"],
		LS["Holy Power"],
		LS["Holy Reach"],
		LS["Holy Shield"],
		LS["Holy Shock"],
		LS["Holy Specialization"],
		LS["Holy Vengeance"], 
		LS["Holy Wrath"],
		LS["Honorless Target"],
		LS["Horse Riding"],
		LS["Howl of Terror"],
		LS["Humanoid Slaying"],
		LS["Hunter's Mark"],
		LS["Hurricane"],
		LS["Hypothermia"],
        
		LS["Ice Armor"],
		LS["Ice Barrier"],
		LS["Ice Block"],
		LS["Ice Floes"],
		LS["Ice Lance"],
		LS["Ice Shards"],
		LS["Icy Veins"],
		LS["Ignite"],
		LS["Ignite Mana"],
		LS["Illumination"],
		LS["Immolate"],
		LS["Immolation Trap"],
		LS["Immolation Trap Effect"],
		LS["Impact"],
		LS["Impale"],
		LS["Impaling Spine"],
		
		LS["Incinerate"],
		LS["Incineration"],
		LS["Inferno"],
		LS["Initiative"],
		LS["Innkeeper"],
		LS["Inner Fire"],
		LS["Inner Focus"],
		LS["Innervate"],
		LS["Insect Swarm"],
		LS["Insidious Whisper"],
		LS["Insignifigance"],
		LS["Inspiration"],
		LS["Intensity"],
		LS["Intercept"],
		LS["Intercept Stun"],
		LS["Intervene"],
		LS["Intimidating Shout"],
		LS["Intimidation"],
		LS["Invisibility"],
		LS["Iron Will"],
      
        
		LS["Lacerate"],
		LS["Lash of Pain"],
		LS["Last Stand"],
		LS["Lay on Hands"],
		LS["Leader of the Pack"],
		LS["Leather"],
		LS["Leatherworking"],
		LS["Lesser Heal"],
		LS["Lesser Healing Wave"],
		LS["Lesser Invisibility"],
		LS["Lethal Shots"],
		LS["Lethality"],
		LS["Levitate"],
		LS["Libram"],
		LS["Life Tap"],
		LS["Lifebloom"],
		LS["Light's Grace"],
		LS["Lightning Bolt"],
		LS["Lightning Breath"],
		LS["Lightning Mastery"],
		LS["Lightning Reflexes"],
		LS["Lightning Shield"],
		LS["Lightning Speed"],
		LS["Lightwell"],
		LS["Lightwell Renew"],
		LS["Lockpicking"],
		LS["Long Daze"],
		LS["Lust for Battle"],
        
		LS["Mace Specialization"],
		LS["Mace Stun Effect"],
		LS["Mage Armor"],
		LS["Magic Absorption"],
		LS["Magic Attunement"],
		
		LS["Mail"],
		LS["Maim"],
		LS["Major Dreamless Sleep"],
		LS["Malediction"],
		LS["Malice"],
		LS["Mana Burn"],
		LS["Mana Feed"],
		LS["Mana Shield"],
		LS["Mana Spring"],
		LS["Mana Tap"],
		LS["Mana Tide"],
		LS["Mangle"],
		LS["Mangle (Bear)"],
		LS["Mangle (Cat)"],
		LS["Mark of the Wild"],
		LS["Martyrdom"],
		LS["Mass Dispel"],
		LS["Master Conjuror"],
		LS["Master Demonologist"],
		LS["Master Summoner"],
		LS["Master Tactician"],
		LS["Master of Deception"],
		LS["Master of Elements"],
		LS["Master of Subtlety"],
		LS["Maul"],
		LS["Mechanostrider Piloting"],
		LS["Meditation"],
		LS["Melee Specialization"],
		LS["Melt Armor"],
		LS["Mend Pet"],
		LS["Mental Agility"],
		LS["Mental Strength"],
		LS["Mind Blast"],
		LS["Mind Control"],
		LS["Mind Flay"],
		LS["Mind Mastery"],
		LS["Mind Soothe"],
		LS["Mind Vision"],
		LS["Mind-numbing Poison"],
		LS["Mind-numbing Poison II"],
		LS["Mind-numbing Poison III"],
		LS["Mining"],
		LS["Misdirection"],
		LS["Misery"],
		LS["Mocking Blow"],
		LS["Molten Armor"],
		LS["Molten Fury"],
		LS["Mongoose Bite"],
		LS["Monster Slaying"],
		LS["Moonfire"],
		LS["Moonfury"],
		LS["Moonglow"],
		LS["Moonkin Aura"],
		LS["Moonkin Form"],
		LS["Mortal Shots"],
		LS["Mortal Strike"],
		LS["Multi-Shot"],
		LS["Murder"],
		LS["Mutilate"],
        
		LS["Natural Armor"],
		LS["Natural Perfection"],
		LS["Natural Shapeshifter"],
		LS["Naturalist"],
		LS["Nature Resistance"],
		LS["Nature Weakness"],
		LS["Nature's Focus"],
		LS["Nature's Grace"],
		LS["Nature's Grasp"],
		LS["Nature's Guidance"],
		LS["Nature's Reach"],
		LS["Nature's Swiftness"],
		LS["Negative Charge"],
		LS["Nether Protection"],
		LS["Netherstorm Flag"],
		LS["Nightfall"],
		LS["Nurturing Instinct"],
        
		LS["Omen of Clarity"],
		LS["One-Handed Axes"],
		LS["One-Handed Maces"],
		LS["One-Handed Swords"],
		LS["One-Handed Weapon Specialization"],
		LS["Opening"],
		LS["Opening - No Text"],
		LS["Opportunity"],
		LS["Overpower"],
        
		LS["Pain Suppression"],
		LS["Panic"],
		LS["Paranoia"],
		LS["Parasitic Shadowfiend"],
		LS["Parry"],
		LS["Pathfinding"],
		LS["Perceived Weakness"],
		LS["Perception"],
		LS["Permafrost"],
		LS["Pet Aggression"],
		LS["Pet Hardiness"],
		LS["Pet Recovery"],
		LS["Pet Resistance"],
		LS["Phase Shift"],
		LS["Pick Lock"],
		LS["Pick Pocket"],
		LS["Piercing Howl"],
		LS["Piercing Ice"],
		LS["Plate Mail"],
		LS["Playing with Fire"],
		LS["Poison Spit"],
		LS["Poisons"],
		LS["Polearms"],
		LS["Poleaxe Specialization"],
		LS["Polymorph"],
		LS["Polymorph: Pig"],
		LS["Polymorph: Turtle"],
		LS["Positive Charge"],
		LS["Pounce"],
		LS["Pounce Bleed"],
		LS["Power Infusion"],
		LS["Power Word: Fortitude"],
		LS["Power Word: Shield"],
		LS["Prayer of Fortitude"],
		LS["Prayer of Healing"],
		LS["Prayer of Mending"],
		LS["Prayer of Shadow Protection"],
		LS["Prayer of Spirit"],
		LS["Precision"],
		LS["Predatory Instincts"],
		LS["Predatory Strikes"],
		LS["Premeditation"],
		LS["Preparation"],
		LS["Presence of Mind"],
		LS["Primal Fury"],
		LS["Prismatic Cloak"],
		LS["Profession Trainers"],
		LS["Prospecting"],
		LS["Prowl"],
		LS["Psychic Scream"],
		LS["Pummel"],
		LS["Purge"],
		LS["Purification"],
		LS["Purify"],
		LS["Purifying Power"],
		LS["Pursuit of Justice"],
		LS["Pyroblast"],
		LS["Pyroclasm"],
		LS["Pyromaniac"],
        
		
        
		LS["Rage of the Unraveller"],
		LS["Rain of Fire"],
		LS["Rake"],
		LS["Ram Riding"],
		LS["Rampage"],
		LS["Ranged Weapon Specialization"],
		LS["Rapid Fire"],
		LS["Rapid Killing"],
		LS["Raptor Riding"],
		LS["Raptor Strike"],
		LS["Ravage"],
		LS["Readiness"],
		LS["Reagents"],
		LS["Rebirth"],
		LS["Reckless Charge"],
		LS["Recklessness"],
		LS["Reckoning"],
		LS["Redemption"],
		LS["Redoubt"],
		LS["Reflection"],
		LS["Regeneration"],
		LS["Regrowth"],
		LS["Reincarnation"],
		LS["Reinforced Shield"],
		LS["Rejuvenation"],
		LS["Relentless Strikes"],
		LS["Remorseless"],
		LS["Remorseless Attacks"],
		LS["Remote Toy"],
		LS["Remove Curse"],
		LS["Remove Insignia"],
		LS["Remove Lesser Curse"],
		LS["Rend"],
		LS["Renew"],
		LS["Repair"],
		LS["Repentance"],
		LS["Restless Strength"],
		LS["Resurrection"],
		LS["Retaliation"],
		LS["Retribution Aura"],
		LS["Revenge"],
		LS["Revenge Stun"],
		LS["Reverberation"],
		LS["Revive Pet"],
		LS["Righteous Defense"],
		LS["Righteous Fury"],
		LS["Rip"],
		LS["Riposte"],
		LS["Ritual of Doom"],
		LS["Ritual of Doom Effect"],
		LS["Ritual of Refreshment"],
		LS["Ritual of Souls"],
		LS["Ritual of Summoning"],
		LS["Rockbiter Weapon"],
		LS["Rough Sharpening Stone"],
		LS["Ruin"],
		LS["Rupture"],
		LS["Ruthlessness"],
        
		LS["Sacrifice"],
		LS["Safe Fall"],
		LS["Sanctified Crusader"],
		LS["Sanctified Judgement"],
		LS["Sanctified Light"],
		LS["Sanctity Aura"],
		LS["Sap"],
		LS["Savage Fury"],
		LS["Savage Strikes"],
		LS["Scare Beast"],
		LS["Scatter Shot"],
		LS["Scorch"],
		LS["Scorpid Poison"],
		LS["Scorpid Sting"],
		LS["Screech"],
		LS["Seal Fate"],
		LS["Seal of Blood"],
		LS["Seal of Command"],
		LS["Seal of Justice"],
		LS["Seal of Light"],
		LS["Seal of Righteousness"],
		LS["Seal of Vengeance"],
		LS["Seal of Wisdom"],
		LS["Seal of the Crusader"],
		LS["Searing Light"],
		LS["Searing Pain"],
		LS["Second Wind"],
		LS["Seduction"],
		LS["Seed of Corruption"],
		LS["Seethe"],
		LS["Sense Demons"],
		LS["Sense Undead"],
		LS["Serpent Sting"],
		LS["Serrated Blades"],
		LS["Setup"],
		LS["Shackle Undead"],
		LS["Shadow Affinity"],
		LS["Shadow Bolt"],
		LS["Shadow Embrace"],
		LS["Shadow Focus"],
		LS["Shadow Mastery"],
		LS["Shadow Power"],
		LS["Shadow Protection"],
		LS["Shadow Reach"],
		LS["Shadow Resistance"],
		LS["Shadow Resistance Aura"],
		LS["Shadow Trance"],
		LS["Shadow Vulnerability"],
		LS["Shadow Ward"],
		LS["Shadow Weakness"],
		LS["Shadow Weaving"],
		LS["Shadow Word: Death"],
		LS["Shadow Word: Pain"],
		LS["Shadow and Flame"],
		LS["Shadow of Death"],
		LS["Shadowburn"],
		LS["Shadowfiend"],
		LS["Shadowform"],
		LS["Shadowfury"],
		LS["Shadowguard"],
		LS["Shadowmeld"],
		LS["Shadowmeld Passive"],
		LS["Shadowstep"],
		LS["Shamanistic Rage"],
		LS["Sharpened Claws"],
		LS["Shatter"],
		LS["Shell Shield"],
		LS["Shield"],
		LS["Shield Bash"],
		LS["Shield Bash - Silenced"],
		LS["Shield Block"],
		LS["Shield Slam"],
		LS["Shield Specialization"],
		LS["Shield Wall"],
		LS["Shiv"],
		LS["Shoot"],
		LS["Shoot Bow"],
		LS["Shoot Gun"],
		LS["Shred"],
		LS["Shredding Attacks"],
		LS["Silence"],
		LS["Silencing Shot"],
		LS["Silent Resolve"],
		LS["Silverwing Flag"],
		LS["Sinister Strike"],
		LS["Siphon Life"],
		LS["Skinning"],
		LS["Slam"],
		LS["Slayer's Crest"],
		LS["Sleep"],
		LS["Slice and Dice"],
		LS["Slow"],
		LS["Slow Fall"],
		LS["Smelting"],
		LS["Smite"],
		LS["Snake Trap"],
		LS["Solid Sharpening Stone"],
		LS["Sonic Burst"],
		LS["Soothe Animal"],
		LS["Soothing Kiss"],
		LS["Soul Fire"],
		LS["Soul Leech"],
		LS["Soul Link"],
		LS["Soul Siphon"],
		LS["Soulshatter"],
		LS["Soulstone Resurrection"],
		LS["Spell Haste"],
		LS["Spell Lock"],
		LS["Spell Power"],
		LS["Spell Reflection"],
		LS["Spell Vulnerability"],
		LS["Spell Warding"],
		LS["Spellsteal"],
		LS["Spirit Bond"],
		LS["Spirit Tap"],
		LS["Spirit of Redemption"],
		LS["Spiritual Attunement"],
		LS["Spiritual Focus"],
		LS["Spiritual Guidance"],
		LS["Spiritual Healing"],
		LS["Spiteful Fury"],
		LS["Sprint"],
		LS["StableMaster"],
		LS["Stance Mastery"],
		LS["Starfire"],
		LS["Starfire Stun"],
		LS["Starlight Wrath"],
		LS["Starshards"],
		LS["Static Charge"],
		LS["Staves"],
		LS["Steady Shot"],
		LS["Stealth"],
		LS["Stoneclaw Stun"],
		LS["Stoneform"],
		LS["Stoneskin"],
		LS["Stormstrike"],
		LS["Strength of Earth"],
		LS["Strength of the Halaani"],
		LS["Stuck"],
		LS["Stun"],
		LS["Subtlety"],
		LS["Suffering"],
		LS["Summon Charger"],
		LS["Summon Dreadsteed"],
		LS["Summon Felguard"],
		LS["Summon Felhunter"],
		LS["Summon Felsteed"],
		LS["Summon Imp"],
		LS["Summon Succubus"],
		LS["Summon Voidwalker"],
		LS["Summon Warhorse"],
		LS["Summon Water Elemental"],
		LS["Sunder Armor"],
		LS["Suppression"],
		LS["Surefooted"],
		LS["Surge of Light"],
		LS["Surprise Attacks"],
		LS["Survivalist"],
		LS["Sweeping Strikes"],
		LS["Swift Flight Form"],
		LS["Swiftmend"],
		LS["Swipe"],
		LS["Sword Specialization"],
		LS["Symbol of Hope"],
        
		LS["Tactical Mastery"],
		LS["Tailoring"],
		LS["Tainted Blood"],
		LS["Tainted Mind"],
		LS["Tame Beast"],
		LS["Taunt"],
		LS["Temporal Rift"],
		LS["The Beast Within"],
		LS["The Human Spirit"],
		LS["Thick Hide"],
		LS["Thorns"],
		LS["Thrill of the Hunt"],
		LS["Throw"],
		LS["Throwing Specialization"],
		LS["Thrown"],
		LS["Thunder Clap"],
		LS["Thunderfury"],
		LS["Thundering Strikes"],
		LS["Thunderstomp"],
		LS["Tidal Focus"],
		LS["Tidal Mastery"],
		LS["Tiger Riding"],
		LS["Tiger's Fury"],
		LS["Time's Favor"],
		LS["Torment"],
		LS["Totem"],
		LS["Totemic Call"],
		LS["Totemic Focus"],
		LS["Touch of Shadow"],
		LS["Touch of Weakness"],
		LS["Toughness"],
		LS["Traces of Silithyst"],
		LS["Tranquil Air"],
		LS["Tranquil Spirit"],
		LS["Tranquility"],
		LS["Tranquilizing Shot"],
		LS["Trap Mastery"],
		LS["Travel Form"],
		LS["Tree of Life"],
		LS["Tribal Leatherworking"],
		LS["Trueshot Aura"],
		LS["Turn Undead"],
		LS["Twin Spire Blessing"],
		LS["Two-Handed Axes"],
		LS["Two-Handed Axes and Maces"],
		LS["Two-Handed Maces"],
		LS["Two-Handed Swords"],
		LS["Two-Handed Weapon Specialization"],
        
		
        
		
    }
}

function LibSpell:Is(spellType, spell)
    return spells[spellType][spell] ~= nil
end
precondition(LibSpell, 'Is', function(self, spellType, spell)
	argCheck(spellType, 2, "string")
    argCheck(spell, 3, "string")
    
    if not spells[spellType] then
        error(("Bad argument #2 to `Is'. Expected %q, %q, %q, %q, %q, %q, %q, %q, %q, %q, %q, %q or %q, got %q"):format("totem", "food", "mount", "poison", "teleport", "talent", "buff", "debuff", "resurrection", "offensive", "defensive", "tradeskill", "uncategorized", spellType), 3)
    end
end)

function LibSpell:Gets(spellType)
    local s = spells[spellType]
    if s then
        table.sort(s)
    end
    return s
end
precondition(LibSpell, 'Gets', function(self, spellType)
	argCheck(spellType, 2, "string")
    
    if not spells[spellType] then
        error(("Bad argument #2 to `Gets'. Expected %q, %q, %q, %q, %q, %q, %q, %q, %q, %q, %q, %q or %q, got %q"):format("totem", "food", "mount", "poison", "teleport", "talent", "buff", "debuff", "resurrection", "offensive", "defensive", "tradeskill", "uncategorized", spellType), 3)
    end
end)

function LibSpell:OnEmbed(object)
end

function LibSpell:OnUnembed(object)
end

function LibSpell:OnEmbedDisable(object)
end

function LibSpell:OnLibraryLoad(major, instance)
end

LibSpell:SetExportedMethods("Is", "Gets")

Rock:FinalizeLibrary(MAJOR_VERSION)