---- CombustionTracker -- made by Tracerus on Wrathbringer (EU) ----------

local CombustionTracker_Version = "2.41";
local CombustionTracker_Loaded = false;
local CombustionTracker_maxCrits = 3;
local CombustionTracker_CombustionID = 28682;
local CombustionTracker_MoltenArmorID = 34913;
local CombustionTracker_PlayerFlags = 1297; --0x511
CombustionTracker_CritsLeft = 0; --not local to allow saving/loading

--default settings
CombustionTracker_Settings = {
	xoffset = -2,						--horizontal offset of buffnumber
	yoffset = 0,						--vertical offset of buffnumber
	showbuffnumber = true,				--show number under buff?
	showframe = true,					--show separate icon with number?
	scale = 1,							--scaling of seperate icon
	isLocked = false,					--can we move the icon
	autohide = false,					--automatically hide icon if there is no combustion active
};

---------------------
--   debug stuff   --
---------------------
local CombustionTracker_DebugMode = false;
function CombustionTracker_printdebug(msg)
	if( CombustionTracker_DebugMode and DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage("[CombustionTracker]: "..msg, 1, 1, 0);
	end
end

-----------------------------
--   resets all settings   --
-----------------------------
function CombustionTracker_Reset()
	--CombustionTracker_printdebug("CT_Reset()");
	
	--reset settings
	CombustionTracker_Settings = {
		xoffset = -2,
		yoffset = 0,
		showbuffnumber = true,
		showframe = true,
		scale = 1,
		isLocked = false,
		autohide = false,
	};
	
	--reset standalone icon position and scale
	CombustionTracker_StandaloneFrame:ClearAllPoints();
	CombustionTracker_scaleFrame(CombustionTracker_StandaloneFrame, CombustionTracker_Settings.scale);
	CombustionTracker_StandaloneFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", 400, 400);
end

---------------------------------------------
--					handles all events						 --
---------------------------------------------
function CombustionTracker_OnEvent()
	----CombustionTracker_printdebug("CT_OnEvent(), event = "..event);
	
	if( event=="ADDON_LOADED" and arg1=="CombustionTracker") then
		CombustionTracker_Loaded = true;

		--register all events we need
		this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		
		--make sure there is no corrupt data
		if( not CombustionTracker_CritsLeft ) then
			CombustionTracker_CritsLeft = 0;
		end
		if( not CombustionTracker_Settings ) then
			CombustionTracker_Reset();
		end
		
		CombustionTracker_UpdateText();
			
		---------- SETUP STANDALONE ICON -----------
		--scale standalone icon
		CombustionTracker_scaleFrame(CombustionTracker_StandaloneFrame, CombustionTracker_Settings.scale);
		CombustionTracker_StandaloneFrame.isLocked = CombustionTracker_Settings.isLocked;

		--show standalone icon if needed
		if( CombustionTracker_Settings.showframe and (not CombustionTracker_Settings.autohide or CombustionTracker_CritsLeft>0 ) ) then
			CombustionTracker_StandaloneFrame:Show();
		end
		
		
		---------- SETUP BUFF NUMBER -----------
		--if combustion was active when logged out (so critsleft is more than zero)
		if( CombustionTracker_CritsLeft>0 ) then
		
			if( CombustionTracker_Settings.showbuffnumber ) then
				--combustion already active
				this:RegisterEvent("PLAYER_AURAS_CHANGED");
				this:RegisterEvent("PLAYER_DEAD");
				CombustionTracker_UpdateTextPosition();
				
			end --CombustionTracker_Settings.showbuffnumber
		end --CombustionTracker_CritsLeft>0
		
		return;
	end --event=="ADDON_LOADED" and arg1=="CombustionTracker"
	
	if( not CombustionTracker_Loaded ) then
		return;
	end
	
	if( event=="COMBAT_LOG_EVENT_UNFILTERED" ) then
		-- event = arg2   (SPELL_DAMAGE, SPELL_AURA_APPLIED,SPELL_AURA_REMOVED)
		--sourceName = arg4
		--srcFlags = arg5
		--dstFlags = arg8 (our player == 511)
		--spellID = arg9 (CoMBUSTION == 28682)
		--spellName = arg10
		--spellSchool = arg11 (or arg13 with SPELL_DAMAGE) (fire==4)
		--crit = arg17 (only SPELL_DAMAGE)
		
		--Combustion buff gained or lost
		          --combustion buff casted or removed                                             --unit is our player
		if( arg9==CombustionTracker_CombustionID and arg8==CombustionTracker_PlayerFlags) then
			---------- START COMBUSTION -----------
			if( arg2=="SPELL_AURA_APPLIED" ) then
				--CombustionTracker_printdebug("Combustion gained");
				
				CombustionTracker_CritsLeft = CombustionTracker_maxCrits;
				
				CombustionTracker_UpdateText();
				this:RegisterEvent("PLAYER_AURAS_CHANGED");
				this:RegisterEvent("PLAYER_DEAD");
				--CombustionTracker_UpdateTextPosition();
				
				--buff icon is not active here so we can only show standalone frame, buff number is shown after event PLAYER_AURAS_CHANGED
				--if seperate icon is enabled show it (maybe it's hidden due to autohide)
				if( CombustionTracker_Settings.showframe ) then
					CombustionTracker_StandaloneFrame:Show();
				end
				
			---------- STOP COMBUSTION -----------
			elseif( arg2=="SPELL_AURA_REMOVED" or arg2=="SPELL_AURA_DISPELLED" ) then
				--CombustionTracker_printdebug("Combustion lost");
				
				CombustionTracker_CritsLeft = 0;
				--update the text (automatically hides it because it's 0 now)
				CombustionTracker_UpdateText();
				this:UnregisterEvent("PLAYER_AURAS_CHANGED");
				this:UnregisterEvent("PLAYER_DEAD");
				
				if( CombustionTracker_Settings.autohide ) then
					CombustionTracker_StandaloneFrame:Hide();
				end
			end
			
		---------- FIRECRIT -----------
		--...else if      combustion active                                                                             source is our player                                                                     did spell damage                                 or did aoe dmg                                of school fire               critical                                               and is not molten armor dmg
		elseif( CombustionTracker_CritsLeft>0 and arg5==CombustionTracker_PlayerFlags and (arg2=="SPELL_DAMAGE" or arg2=="RANGE_DAMAGE") and arg11==4 and arg17==1 and arg9~=CombustionTracker_MoltenArmorID) then
			--CombustionTracker_printdebug("fire crit from "..arg10.."(ID: "..arg9..")");

			--decrease number of crits left
			CombustionTracker_CritsLeft = CombustionTracker_CritsLeft-1;
			CombustionTracker_UpdateText();
		end
	---------- BUFFS CHANGED -----------
	--... else if any buff changed (combustion buff now visible or just a new position) and number under buff is enabled and combustion is active
	elseif( event=="PLAYER_AURAS_CHANGED" and CombustionTracker_Settings.showbuffnumber and CombustionTracker_CritsLeft>0) then
		--CombustionTracker_printdebug("buffs changed");
		
		--update its position and show it
		CombustionTracker_UpdateTextPosition();
	elseif( event=="PLAYER_DEAD") then
		this:UnregisterEvent("PLAYER_AURAS_CHANGED");
		this:UnregisterEvent("PLAYER_DEAD");
		
		CombustionTracker_CritsLeft = 0;
		CombustionTracker_UpdateText();
	end --event==
end

-------------------------------------------------------
--	updates the text position for standard buff bar  --
-------------------------------------------------------
function CombustionTracker_UpdateTextPosition()
	--CombustionTracker_printdebug("CT_UpdateTextPosition()");
	
	--go through all the buffs 
	for i = 1, 16 do
		local buffName, _ = GetPlayerBuffName(i);

		--check if this is really combustion buff (and not Fire Resistance Aura)
		if ( buffName and COMBUSTIONTRACKER_COMBUSTION==buffName ) then
			--place UI text under combustion buff and update text
			CombustionTracker_MainFrame_CritNumber:SetPoint("TOP", "BuffButton"..i, "BOTTOM", CombustionTracker_Settings.xoffset, CombustionTracker_Settings.yoffset);

			--we found combustion buff and can stop going through bufflist
			--CombustionTracker_printdebug("found Combustion buff - returning true");
			CombustionTracker_MainFrame:Show();
			return;
		end

		--end
	end

	--CombustionTracker_printdebug("did not find Combustion buff - returning false");
	CombustionTracker_MainFrame:Hide();
end

------------------------------
--   updates text content   --
------------------------------
function CombustionTracker_UpdateText()
	--CombustionTracker_printdebug("CT_UpdateText()");
	
	if( CombustionTracker_CritsLeft>0 ) then
		CombustionTracker_MainFrame_CritNumber:SetText(CombustionTracker_CritsLeft);
		CombustionTracker_StandaloneFrame_CritNumber:SetText(CombustionTracker_CritsLeft);
	else
		CombustionTracker_MainFrame:Hide();
		CombustionTracker_StandaloneFrame_CritNumber:SetText("-");
	end
end

--------------------------------
--   handles slash commands   --
--------------------------------
function CombustionTracker_SlashCommandHandler(msg)
	--CombustionTracker_printdebug("CT_SlashCommandHandler(msg),  msg = "..tostring(msg));
	if( msg ) then
		
		local a = string.find(msg, "%s+");
		if( a ) then
			local cmd = string.sub(msg, 1, a-1);
			local arg = string.sub(msg, a+1);
			if( cmd and arg ) then
				if( (cmd=="xoffset" or cmd=="xoff") and tonumber(arg) ) then
					CombustionTracker_Settings.xoffset = tonumber(arg);
					CombustionTracker_UpdateTextPosition();
					return;
				elseif( (cmd=="yoffset" or cmd=="yoff") and tonumber(arg) ) then
					CombustionTracker_Settings.yoffset = tonumber(arg);
					CombustionTracker_UpdateTextPosition();
					return;
				elseif( cmd=="showbuffnumber" ) then
					if( arg=="false" or arg=="off" or tonumber(arg)==0 ) then
						CombustionTracker_Settings.showbuffnumber = false;
						CombustionTracker_MainFrame:Hide();
					else
						CombustionTracker_Settings.showbuffnumber = true;
						CombustionTracker_MainFrame:Show();
					end
					return;
				elseif( cmd=="showicon" ) then
					if( arg=="false" or arg=="off" or tonumber(arg)==0 ) then
						CombustionTracker_Settings.showframe = false;
						CombustionTracker_StandaloneFrame:Hide();
					else
						CombustionTracker_Settings.showframe = true;
						--show icon now if  combustion is active or autohide is disabled
						if( CombustionTracker_CritsLeft>0 or not CombustionTracker_Settings.autohide ) then
							CombustionTracker_StandaloneFrame:Show();
						end
					end
					return;
				elseif( cmd=="scale" and tonumber(arg) and tonumber(arg)>0 ) then
					CombustionTracker_Settings.framescale = tonumber(arg);
					CombustionTracker_scaleFrame(CombustionTracker_StandaloneFrame, tonumber(arg));
					return;
				elseif( cmd=="autohide" ) then
					if( arg=="false" or arg=="off" or tonumber(arg)==0 ) then
						CombustionTracker_Settings.autohide = false;
						if( CombustionTracker_Settings.showframe ) then
							CombustionTracker_StandaloneFrame:Show();
						end
					else
						CombustionTracker_Settings.autohide = true;
						if( CombustionTracker_CritsLeft<=0 ) then
							CombustionTracker_StandaloneFrame:Hide();
						end
					end
					return;
				end
			end
		elseif( msg=="lock" ) then
			CombustionTracker_Settings.isLocked = true;
			CombustionTracker_StandaloneFrame.isLocked = true;
			return;
		elseif( msg=="unlock" ) then
			CombustionTracker_Settings.isLocked = false;
			CombustionTracker_StandaloneFrame.isLocked = false;
			return;
		elseif( msg=="reset" ) then
			CombustionTracker_StandaloneFrame:ClearAllPoints();
			CombustionTracker_scaleFrame(CombustionTracker_StandaloneFrame, 1);
			CombustionTracker_StandaloneFrame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",400, 400);
			CombustionTracker_Reset();
			return;
		end
	end
	--if nothing matches we print help
	CombustionTracker_PrintHelp();
end

------------------------------------------------------
--   prints help for slash commands in chat frame   --
------------------------------------------------------
function CombustionTracker_PrintHelp()
	--CombustionTracker_printdebug("CT_PrintHelp()");
	
	--print help
	for _, line in pairs(COMBUSTIONTRACKER_HELP) do
		DEFAULT_CHAT_FRAME:AddMessage(line, 1, 1, 0);
	end
	--print status
	DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFFFFshowbuffnumber: |cFFFF0000"..tostring(CombustionTracker_Settings.showbuffnumber).." |cFFFFFFFFxoffset: |cFFFF0000"..CombustionTracker_Settings.xoffset.." |cFFFFFFFFyoffset: |cFFFF0000"..CombustionTracker_Settings.yoffset);
	DEFAULT_CHAT_FRAME:AddMessage("|cFFFFFFFFshowicon: |cFFFF0000"..tostring(CombustionTracker_Settings.showframe).." |cFFFFFFFFicon scale: |cFFFF0000"..CombustionTracker_StandaloneFrame:GetScale().." |cFFFFFFFFlocked: |cFFFF0000"..tostring(CombustionTracker_Settings.isLocked));
end

--------------------------------------------------
--   scales frame without changing position   --
--------------------------------------------------
function CombustionTracker_scaleFrame(frame, scale)
	--CombustionTracker_printdebug("CT_scaleFrame(frame, scale)");
	--CombustionTracker_printdebug("frame = "..tostring(frame:GetName()));
	--CombustionTracker_printdebug("scale = "..tostring(scale));
	
	frame:ClearAllPoints();
	local oldscale = frame:GetScale() or 1;
	local framex = (frame:GetLeft() or 0)* oldscale;
	local framey = (frame:GetTop() or 0)* oldscale;
	frame:SetScale(scale);
	frame:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT",framex/scale, framey/scale);
end

-------------------------------------
--   called when addon is loaded   --
-------------------------------------
function CombustionTracker_OnLoad()
	--CombustionTracker_printdebug("CT_OnLoad()");
	
	--disable this mod if we are not a mage (not really disable but just do nothing)
	if (COMBUSTIONTRACKER_MAGE ~= UnitClass("player")) then
		DEFAULT_CHAT_FRAME:AddMessage(COMBUSTIONTRACKER_DISABLED);
		return;
	end

	--setup slash commands
	SLASH_CTRACKER1 = "/ct";
	SLASH_CTRACKER2 = "/ctracker";
	SLASH_CTRACKER3 = "/combustiontracker";
	SlashCmdList["CTRACKER"] = CombustionTracker_SlashCommandHandler;
	
	--generate welcome message
	local welcome = "CombustionTracker v"..CombustionTracker_Version.." "..COMBUSTIONTRACKER_LOADED;
	
	--show welcome message
	DEFAULT_CHAT_FRAME:AddMessage(welcome, 1, 1, 0);

	--wait for this addon to be loaded
	this:RegisterEvent("ADDON_LOADED");
end

