-- CombatCam by Everglow

-- View 1 = 1st person, accessed by slash command ("/autocam zin")
-- View 2 = Normal
-- View 3 = Reserved for Titan Rider AutoCam
-- View 4 = Combat
-- View 5 = User defined, accessed by slash command ("/autocam  zout")

local CC_Ver="2.4.03"
local CCTag="|c00FFFF66CombatCam "..CC_Ver.."|r: "
local function ChatMsg(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg)
end

local infotext =
	"Instructions:\n"..
	"adjust your camera as desired then click a button to save that view.\n\n"..
	"Slash commands:\n"..
	"/combatcam: display this window\n"..
	"/combatcam zin: first person view\n"..
	"/combatcam zout: custom view"

local useCC, useSE
local firstRun = false

local function BtoStr(bool)
	if(bool) then return "true" else return "false" end
end

	

local function setCam(view)
	if view>0 and view<6 then
		SetView(view)
	elseif view == 0 then
		if IsMounted() or IsFlying() then
			if TitanRiderAutoCam_Frame and (TR_UseAutoCam == true) then
				SetView(3)
			else
				SetView(2)
			end
		elseif UnitAffectingCombat("player") then
			SetView(4)
		else
			SetView(2)
		end
	else
		ChatMsg(CCTag..format("|c00CC6666invalid view (%d)- please report this error where you downloaded CombatCam",view))
		return -1
	end
end

local function acceptChanges()
	if firstRun then
		CombatCamInfoText:SetText(infotext)
		firstRun = false
	end
	useCombatCam = useCC;
	useSmartEdit = useSE;
end

local function cancelChanges()
	if firstRun then
		CombatCamInfoText:SetText(infotext)
		firstRun = false
	end
	useCC = useCombatCam;
	useSE = useSmartEdit;
	CombatCamEnableCheckButton:SetChecked(useCC);
	SmartEditEnableCheckButton:SetChecked(useSE);
end

function CombatCamToggle()
	useCC = not useCC;
end

function SmartEditToggle()
	useSE = not useSE;
end

-- SLASH COMMANDS
function CombatCam_SlashCommandHandler(a)
	if (a == "zin") then
		SetView(1)
	elseif (a == "zout") then
		SetView(5)
	else
		InterfaceOptionsFrame_OpenToFrame(CombatCamFrame)
	end
end

function CombatCam_OnLoad()
	this.name = "CombatCam"
	this.okay = acceptChanges
	this.cancel = cancelChanges
	this:RegisterEvent("PLAYER_REGEN_DISABLED")
	this:RegisterEvent("PLAYER_REGEN_ENABLED")
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	InterfaceOptions_AddCategory(this)

	SLASH_COMBATCAM1 = "/combatcam"
	SlashCmdList["COMBATCAM"] =
	function(msg)
		CombatCam_SlashCommandHandler(msg)
	end
	getglobal(CombatCamEnableCheckButton:GetName() .. "Text"):SetText("Enable CombatCam");
	getglobal(SmartEditEnableCheckButton:GetName() .. "Text"):SetText("Enable SmartEdit");
	CombatCamInfoText:SetWidth("300")
end
	
function CombatCam_OnEvent()
	if (event == "PLAYER_ENTERING_WORLD") then
		if useCombatCam == nil then
			firstRun = true
			local infotext1 = "|c0000FFFFIT looks like this is your first time running CombatCam on this toon. "..
				"Please set your views if you have not already done so on another toon.|r\n\n\n"
			useCombatCam = false
			useSmartEdit = false
			CombatCamInfoText:SetText(infotext1..infotext)
			InterfaceOptionsFrame_OpenToFrame(this)
		else
			CombatCamEnableCheckButton:SetChecked(useCombatCam)
			SmartEditEnableCheckButton:SetChecked(useSmartEdit)
			CombatCamInfoText:SetText(infotext)
		end
		useCC = useCombatCam
		if useCombatCam or (TitanRiderAutoCam_Frame and TR_UseAutoCam) then setCam(0) end
		ChatMsg(CCTag.."Loaded")
	elseif event == "PLAYER_REGEN_DISABLED" then  --player combat status changed
		if useCombatCam then setCam(0) end
		if useSmartEdit then
			ChatFrameEditBox:ClearFocus()
			ChatFrameEditBox:SetAutoFocus(false)
		end
	elseif event == "PLAYER_REGEN_ENABLED" then
		if useCombatCam then setCam(0) end
		if useSmartEdit then ChatFrameEditBox:SetAutoFocus(true) end
	else end
end
