
--[[
	LibFeedback is under development ATM
	It works as a nice replacement for the message frame in my addons so far
	Eventually it will have more animations, use StickyFrames and handle BigWigs-like alerts
	Some code ideas were borrowed, and probably badly-reused, from LibSharedMedia and Parrot
]]

local MAJOR_VERSION = "LibFeedback-0.1"
local MINOR_VERSION = tonumber(("$Revision: 67866 $"):match("%d+"))

local lib = LibStub:NewLibrary(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local _G = _G
local exp = _G.exp
local type = _G.type
local pairs = _G.pairs
local tinsert = _G.tinsert
local tremove = _G.tremove
local random = _G.random
local strsplit = _G.strsplit
local strupper = _G.strupper
local UIParent = _G.UIParent
local PlaySoundFile = _G.PlaySoundFile
local CallbackHandler = LibStub:GetLibrary("CallbackHandler-1.0")

local FEEDBACK_ICON = "questionmark.ico"
local FEEDBACK_FONTCOLOR = { r = 1.0, g = 1.0, b = 1.0, a = 1.0 }
local FEEDBACK_FONTTYPE = "Fonts\\ARIALN.TTF"
local FEEDBACK_FONTSIZE = 16
local FEEDBACK_FONTOUTLINE = ""
local FEEDBACK_ANIMATION_STYLE = "Scroll"
local FEEDBACK_ANIMATION_DIRECTION = "UP:NONE"
local FEEDBACK_ANIMATION_DELAY = 0.025
local FEEDBACK_ANIMATION_STEPS = 128
local FEEDBACK_ANIMATION_STICK = 16
local FEEDBACK_ANIMATIONS = {
	["Scroll"] = {
		desc = "Move messages in a scrolling motion",
		show = function(feedbackFrame, feedbackObject)
			local direction1, direction2 = string.split(":", strupper(lib.frames[feedbackFrame].animationdirection))
			lib.objects[feedbackFrame][feedbackObject].step = lib.objects[feedbackFrame][feedbackObject].step + 1
			if lib.objects[feedbackFrame][feedbackObject - 1] and lib.objects[feedbackFrame][feedbackObject - 1].step then -- fix vertical overlapping - may need some work
				if direction1 == "DOWN" and lib.objects[feedbackFrame][feedbackObject].yoffset > lib.objects[feedbackFrame][feedbackObject - 1].yoffset + lib.objects[feedbackFrame][feedbackObject - 1].fontsize then
					lib.objects[feedbackFrame][feedbackObject].yoffset = lib.objects[feedbackFrame][feedbackObject - 1].yoffset + lib.objects[feedbackFrame][feedbackObject - 1].fontsize
				elseif direction1 == "UP" and lib.objects[feedbackFrame][feedbackObject].yoffset > lib.objects[feedbackFrame][feedbackObject - 1].yoffset - lib.objects[feedbackFrame][feedbackObject - 1].fontsize then
					lib.objects[feedbackFrame][feedbackObject].yoffset = lib.objects[feedbackFrame][feedbackObject - 1].yoffset - lib.objects[feedbackFrame][feedbackObject - 1].fontsize
				end
			end
			lib.objects[feedbackFrame][feedbackObject].fontstring:SetPoint("CENTER", lib.frames[feedbackFrame], "CENTER", lib.objects[feedbackFrame][feedbackObject].xoffset, lib.objects[feedbackFrame][feedbackObject].yoffset)
			lib.objects[feedbackFrame][feedbackObject].fontstring:SetFont(lib.objects[feedbackFrame][feedbackObject].fonttype, lib.objects[feedbackFrame][feedbackObject].fontsize, lib.objects[feedbackFrame][feedbackObject].fontoutline)
			lib.objects[feedbackFrame][feedbackObject].fontstring:SetTextColor(lib.objects[feedbackFrame][feedbackObject]['fontcolor'].r, lib.objects[feedbackFrame][feedbackObject]['fontcolor'].g, lib.objects[feedbackFrame][feedbackObject]['fontcolor'].b)
			lib.objects[feedbackFrame][feedbackObject].fontstring:SetText(lib.objects[feedbackFrame][feedbackObject].text)
			lib.objects[feedbackFrame][feedbackObject].fontstring:SetParent(lib.frames[feedbackFrame])
			lib.objects[feedbackFrame][feedbackObject].fontstring:Show()
			if lib.objects[feedbackFrame][feedbackObject].sound then
				PlaySoundFile(lib.objects[feedbackFrame][feedbackObject].sound)
			end
			if lib.objects[feedbackFrame][feedbackObject].visual then
				lib.objects[feedbackFrame][feedbackObject].visual()
			end
		end,
		move = function(feedbackFrame, feedbackObject, elapsed)
			local direction1, direction2 = string.split(":", strupper(lib.frames[feedbackFrame].animationdirection))
			lib.objects[feedbackFrame][feedbackObject].elapsed = lib.objects[feedbackFrame][feedbackObject].elapsed + elapsed
			if lib.objects[feedbackFrame][feedbackObject].elapsed < lib.frames[feedbackFrame].animationdelay then return end
			lib.objects[feedbackFrame][feedbackObject].step = lib.objects[feedbackFrame][feedbackObject].step + 1
			lib.objects[feedbackFrame][feedbackObject].elapsed = 0
			if direction1 == "LEFT" then
				lib.objects[feedbackFrame][feedbackObject].xoffset = lib.objects[feedbackFrame][feedbackObject].xoffset - 3
			elseif direction1 == "RIGHT" then
				lib.objects[feedbackFrame][feedbackObject].xoffset = lib.objects[feedbackFrame][feedbackObject].xoffset + 3
			elseif direction1 == "DOWN" then
				lib.objects[feedbackFrame][feedbackObject].yoffset = lib.objects[feedbackFrame][feedbackObject].yoffset - 2
			elseif direction1 == "UP" then
				lib.objects[feedbackFrame][feedbackObject].yoffset = lib.objects[feedbackFrame][feedbackObject].yoffset + 2
			end
			if direction2 == "LEFT" then
				lib.objects[feedbackFrame][feedbackObject].xoffset = lib.objects[feedbackFrame][feedbackObject].xoffset - 3
			elseif direction2 == "RIGHT" then
				lib.objects[feedbackFrame][feedbackObject].xoffset = lib.objects[feedbackFrame][feedbackObject].xoffset + 3
			elseif direction2 == "DOWN" then
				lib.objects[feedbackFrame][feedbackObject].yoffset = lib.objects[feedbackFrame][feedbackObject].yoffset - 2
			elseif direction2 == "UP" then
				lib.objects[feedbackFrame][feedbackObject].yoffset = lib.objects[feedbackFrame][feedbackObject].yoffset + 2
			elseif direction2 == "ALT" and (direction1 == "DOWN" or direction1 == "UP") and feedbackObject % 2 == 0 then
				lib.objects[feedbackFrame][feedbackObject].xoffset = lib.objects[feedbackFrame][feedbackObject].xoffset - 3
			elseif direction2 == "ALT" and (direction1 == "DOWN" or direction1 == "UP") and feedbackObject % 2 ~= 0 then
				lib.objects[feedbackFrame][feedbackObject].xoffset = lib.objects[feedbackFrame][feedbackObject].xoffset + 3
			elseif direction2 == "ALT" and (direction1 == "LEFT" or direction1 == "RIGHT") and feedbackObject % 2 == 0 then
				lib.objects[feedbackFrame][feedbackObject].yoffset = lib.objects[feedbackFrame][feedbackObject].yoffset - 2
			elseif direction2 == "ALT" and (direction1 == "LEFT" or direction1 == "RIGHT") and feedbackObject % 2 ~= 0 then
				lib.objects[feedbackFrame][feedbackObject].yoffset = lib.objects[feedbackFrame][feedbackObject].yoffset + 2
			end
			if lib.objects[feedbackFrame][feedbackObject].sticky and lib.objects[feedbackFrame][feedbackObject].step == lib.frames[feedbackFrame].animationsteps - lib.frames[feedbackFrame].animationstick then
				lib.objects[feedbackFrame][feedbackObject].fontstring:SetPoint("CENTER", lib.frames[feedbackFrame], "CENTER", lib.objects[feedbackFrame][feedbackObject].xoffset, lib.objects[feedbackFrame][feedbackObject].yoffset)
				_, _, _, lib.objects[feedbackFrame][feedbackObject].stickxoffset, lib.objects[feedbackFrame][feedbackObject].stickyoffset = lib.objects[feedbackFrame][feedbackObject].fontstring:GetPoint()
			elseif lib.objects[feedbackFrame][feedbackObject].sticky and lib.objects[feedbackFrame][feedbackObject].step > lib.frames[feedbackFrame].animationsteps - lib.frames[feedbackFrame].animationstick then
				local shakex, shakey = random(-3, 3), random(-2, 2)
				lib.objects[feedbackFrame][feedbackObject].fontstring:SetPoint("CENTER", lib.frames[feedbackFrame], "CENTER", lib.objects[feedbackFrame][feedbackObject].stickxoffset + shakex, lib.objects[feedbackFrame][feedbackObject].stickyoffset + shakey)
			elseif lib.objects[feedbackFrame][feedbackObject].step > lib.frames[feedbackFrame].animationsteps - lib.frames[feedbackFrame].animationstick then
				lib.objects[feedbackFrame][feedbackObject].fontstring:SetAlpha((lib.frames[feedbackFrame].animationsteps - lib.objects[feedbackFrame][feedbackObject].step) / lib.frames[feedbackFrame].animationstick)
				lib.objects[feedbackFrame][feedbackObject].fontstring:SetPoint("CENTER", lib.frames[feedbackFrame], "CENTER", lib.objects[feedbackFrame][feedbackObject].xoffset, lib.objects[feedbackFrame][feedbackObject].yoffset)
			else
				lib.objects[feedbackFrame][feedbackObject].fontstring:SetPoint("CENTER", lib.frames[feedbackFrame], "CENTER", lib.objects[feedbackFrame][feedbackObject].xoffset, lib.objects[feedbackFrame][feedbackObject].yoffset)
			end
		end,
		hide = function(feedbackFrame, feedbackObject)
			lib.objects[feedbackFrame][feedbackObject].fontstring:Hide()
			lib.objects[feedbackFrame][feedbackObject] = {}
		end,
	}
}

lib.frames = lib.frames or {}
lib.objects = lib.objects or {}
lib.callbacks = lib.callbacks or CallbackHandler:New(lib, "AddCallback", "RemoveCallback", "RemoveAllCallbacks")
lib.mainframe = lib.mainframe or CreateFrame("Frame", "Feedback", UIParent)
lib.mainframe:SetScript("OnUpdate", function(this, elapsed)
	for feedbackFrame in pairs(lib.frames) do
		if lib.frames[feedbackFrame] and lib.objects[feedbackFrame] then
			for feedbackObject in pairs(lib.objects[feedbackFrame]) do
				if lib.objects[feedbackFrame][feedbackObject] and lib.objects[feedbackFrame][feedbackObject].step then
					if lib.objects[feedbackFrame][feedbackObject].step == 0 then
						FEEDBACK_ANIMATIONS[lib.frames[feedbackFrame].animationstyle].show(feedbackFrame, feedbackObject)
					elseif lib.objects[feedbackFrame][feedbackObject].step < lib.frames[feedbackFrame].animationsteps then
						FEEDBACK_ANIMATIONS[lib.frames[feedbackFrame].animationstyle].move(feedbackFrame, feedbackObject, elapsed)
					else
						FEEDBACK_ANIMATIONS[lib.frames[feedbackFrame].animationstyle].hide(feedbackFrame, feedbackObject)
					end
				end
			end
		end
	end
end)

--[[
Notes:
	Create a feedback frame
Arguments:
	string - the frame name
	table [optional] - the frame attributes
		table.parent string - the frame parent [default = "UIParent"] 
		table.strata string - the frame strata [default = "HIGH"]
		table.width number - the frame width [default = 1]
		table.height number - the frame height [default = 1]
		table.xoffset number - the frame relative xoffset [default = 0]
		table.yoffset number - the frame relative yoffset [default = 0]
		table.fonttype string - the default message font type [default = "Fonts\\ARIALN.TTF"]
		table.fontsize number - the default message font size [default = 16]
		table.fontcolor table - the default message font color [default = white]
		table.fontoutline string - the default message font outline [default = ""]
		table.animationstyle string - the type of animation to associate with the message [default = "Scroll"]
		table.animationdirection string - the direction[s] to associate with the animation [default = "UP:NONE"]
		table.animationdelay number- the update delay to associate with the animation [default = 0.025]
		table.animationsteps number- the number of steps to associate with the animation [default = 128]
		table.animationstick number - the number of steps to pause a sticky animation [default = 16]
Example:
	local FB = LibStub("LibFeedback-0.1")
	FB:Create("MyFeedback")
]]
function lib:Create(feedbackFrame, feedbackAttributes)
	if feedbackFrame and type(feedbackFrame) == 'string' and not lib.frames[feedbackFrame] then
		lib.frames[feedbackFrame] = CreateFrame("Frame", "Feedback_" .. feedbackFrame, lib.mainframe)
		lib.frames[feedbackFrame].parent = feedbackAttributes and feedbackAttributes.parent or UIParent
		lib.frames[feedbackFrame].strata = feedbackAttributes and feedbackAttributes.strata or "HIGH"
		lib.frames[feedbackFrame].width = feedbackAttributes and feedbackAttributes.width or 128
		lib.frames[feedbackFrame].height = feedbackAttributes and feedbackAttributes.height or 64
		lib.frames[feedbackFrame].xoffset = feedbackAttributes and feedbackAttributes.xoffset or 0
		lib.frames[feedbackFrame].yoffset = feedbackAttributes and feedbackAttributes.yoffset or 0
		lib.frames[feedbackFrame].fontcolor = feedbackAttributes and feedbackAttributes.fontcolor or FEEDBACK_FONTCOLOR
		lib.frames[feedbackFrame].fonttype = feedbackAttributes and feedbackAttributes.fonttype or FEEDBACK_FONTTYPE
		lib.frames[feedbackFrame].fontsize = feedbackAttributes and feedbackAttributes.fontsize or FEEDBACK_FONTSIZE
		lib.frames[feedbackFrame].fontoutline = feedbackAttributes and feedbackAttributes.fontoutline or FEEDBACK_FONTOUTLINE
		lib.frames[feedbackFrame].animationstyle = feedbackAttributes and feedbackAttributes.animationstyle or FEEDBACK_ANIMATION_STYLE
		lib.frames[feedbackFrame].animationdirection = feedbackAttributes and feedbackAttributes.animationdirection or FEEDBACK_ANIMATION_DIRECTION
		lib.frames[feedbackFrame].animationdelay = feedbackAttributes and feedbackAttributes.animationdelay or FEEDBACK_ANIMATION_DELAY
		lib.frames[feedbackFrame].animationsteps = feedbackAttributes and feedbackAttributes.animationsteps or FEEDBACK_ANIMATION_STEPS
		lib.frames[feedbackFrame].animationstick = feedbackAttributes and feedbackAttributes.animationstick or FEEDBACK_ANIMATION_STICK
		lib.frames[feedbackFrame]:SetFrameStrata(lib.frames[feedbackFrame].strata)
		lib.frames[feedbackFrame]:SetParent(lib.frames[feedbackFrame].parent)
		lib.frames[feedbackFrame]:SetWidth(lib.frames[feedbackFrame].width)
		lib.frames[feedbackFrame]:SetHeight(lib.frames[feedbackFrame].height)
		lib.frames[feedbackFrame]:SetPoint("CENTER", lib.frames[feedbackFrame].parent, "CENTER", lib.frames[feedbackFrame].xoffset, lib.frames[feedbackFrame].yoffset)
		lib.frames[feedbackFrame]:SetBackdrop({ bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", edgeSize = 16, tileSize = 16, tile = true, insets = { left = 4, right = 4, top = 4, bottom = 4 } })
		lib.frames[feedbackFrame].title = lib.frames[feedbackFrame]:CreateFontString("Feedback_" .. feedbackFrame .. "Title_FontString", "ARTWORK", "MasterFont")
		lib.frames[feedbackFrame].title:SetPoint("CENTER", lib.frames[feedbackFrame], "CENTER", 0, 10)
		lib.frames[feedbackFrame].title:SetFont(lib.frames[feedbackFrame].fonttype, 16, "")
		lib.frames[feedbackFrame].title:SetTextColor(1.0, 1.0, 1.0, 0.5)
		lib.frames[feedbackFrame].title:SetText(feedbackFrame)
		lib.frames[feedbackFrame].offsets = lib.frames[feedbackFrame]:CreateFontString("Feedback_" .. feedbackFrame .. "Position_FontString", "ARTWORK", "MasterFont")
		lib.frames[feedbackFrame].offsets:SetPoint("CENTER", lib.frames[feedbackFrame], "CENTER", 0, -10)
		lib.frames[feedbackFrame].offsets:SetFont(lib.frames[feedbackFrame].fonttype, 16, "")
		lib.frames[feedbackFrame].offsets:SetTextColor(1.0, 1.0, 1.0, 0.5)
		lib.frames[feedbackFrame].offsets:SetText("(" .. floor(lib.frames[feedbackFrame].xoffset) .. "," .. floor(lib.frames[feedbackFrame].yoffset) ..")")
		lib:Lock(feedbackFrame)
	end
end

--[[
Notes:
	Delete a feedback frame
Arguments:
	string - the frame name
Example:
	local FB = LibStub("LibFeedback-0.1")
	FB:Create("MyFeedback")
	FB:Destroy("MyFeedback")
]]
function lib:Destroy(feedbackFrame)
	if feedbackFrame and type(feedbackFrame) == 'string' and lib.frames[feedbackFrame] then
		if lib.objects[feedbackFrame] then
			for feedbackObject in pairs(lib.objects[feedbackFrame]) do
				if lib.objects[feedbackFrame][feedbackObject].fontstring then
					lib.objects[feedbackFrame][feedbackObject].fontstring:Hide()
				end
			end
		end
		lib.objects[feedbackFrame] = nil
		lib.frames[feedbackFrame] = nil
	end
end

--[[
Notes:
	Lock a feedback frame
Arguments:
	string - the frame name
Example:
	local FB = LibStub("LibFeedback-0.1")
	FB:Create("MyFeedback")
	FB:Lock("MyFeedback")
]]
function lib:Lock(feedbackFrame)
	if feedbackFrame and type(feedbackFrame) == 'string' and lib.frames[feedbackFrame] then
		lib.frames[feedbackFrame].title:Hide()
		lib.frames[feedbackFrame].offsets:Hide()
		lib.frames[feedbackFrame]:SetMovable(false)
		lib.frames[feedbackFrame]:EnableMouse(false)
		lib.frames[feedbackFrame]:SetBackdropColor(1.0, 1.0, 1.0, 0.0)
		lib.frames[feedbackFrame]:SetBackdropBorderColor(1.0, 1.0, 1.0, 0.0)
		lib.frames[feedbackFrame]:SetScript("OnUpdate", nil)
	end
end

--[[
Notes:
	Unlock a feedback frame
Arguments:
	string - the frame name
Example:
	local FB = LibStub("LibFeedback-0.1")
	FB:Create("MyFeedback")
	FB:Unlock("MyFeedback")
]]
function lib:Unlock(feedbackFrame)
	if feedbackFrame and type(feedbackFrame) == 'string' and lib.frames[feedbackFrame] then
		lib.frames[feedbackFrame].title:Show()
		lib.frames[feedbackFrame].offsets:Show()
		lib.frames[feedbackFrame]:SetMovable(true)
		lib.frames[feedbackFrame]:EnableMouse(true)
		lib.frames[feedbackFrame]:RegisterForDrag("LeftButton")
		lib.frames[feedbackFrame]:SetBackdropColor(1.0, 1.0, 1.0, 0.2)
		lib.frames[feedbackFrame]:SetBackdropBorderColor(1.0, 1.0, 1.0, 0.2)
		lib.frames[feedbackFrame]:SetScript("OnDragStart", function ()
			lib.frames[feedbackFrame]:StartMoving()
		end)
		lib.frames[feedbackFrame]:SetScript("OnDragStop", function()
			lib.frames[feedbackFrame]:StopMovingOrSizing()
			_, _, _, lib.frames[feedbackFrame].xoffset, lib.frames[feedbackFrame].yoffset = lib.frames[feedbackFrame]:GetPoint()
			lib.frames[feedbackFrame].offsets:SetText("(" .. floor(lib.frames[feedbackFrame].xoffset) .. "," .. floor(lib.frames[feedbackFrame].yoffset) ..")")
			self:FireCallback("OnFeedbackFrameMoved", feedbackFrame, lib.frames[feedbackFrame].xoffset, lib.frames[feedbackFrame].yoffset)
		end)
		lib.frames[feedbackFrame]:SetScript("OnUpdate", function()
			-- show frame position
		end)
	end
end

--[[
Notes:
	Add data to a feedback frame
Arguments:
	string - the frame name
	table - the feedback data
		table.text string - the text message
		table.icon string [optional] - the icon to use if enabled [default = ""]
		table.fonttype string [optional] - the message font type [default = feedback frame font type]
		table.fontsize number [optional] - the message font size [default = feedback frame font size]
		table.fontcolor table [optional] - the message font color [default = feedback frame font color]
		table.fontoutline string [optional] - the message font outline [default = feedback frame font outline]
		table.sticky boolean [optional] - produce a sticky message [default=false]
Example:
	local FB = LibStub("LibFeedback-0.1")
	FB:Create("MyFeedback")
	FB:AddData("MyFeedback", { text = "Hello, World of Warcraft!" })
]]
function lib:AddData(feedbackFrame, feedbackData)
	if feedbackFrame and type(feedbackFrame) == 'string' and lib.frames[feedbackFrame] and feedbackData and type(feedbackData) == 'table' and feedbackData.text and type(feedbackData.text) == 'string' then
		if lib.frames[feedbackFrame].objects and lib.frames[feedbackFrame].objects < 128 then
			lib.frames[feedbackFrame].objects = lib.frames[feedbackFrame].objects + 1
		else
			lib.frames[feedbackFrame].objects = 1
		end
		if not lib.objects[feedbackFrame] then
			lib.objects[feedbackFrame] = {}
		end
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects] = {}
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].text = feedbackData.text
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].icon = feedbackData.icon or nil
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].sticky = feedbackData.sticky or false
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].sound = feedbackData.sound or nil
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].visual = feedbackData.visual or nil
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].fonttype = feedbackData.fonttype or lib.frames[feedbackFrame].fonttype
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].fontsize = feedbackData.fontsize or lib.frames[feedbackFrame].fontsize
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].fontcolor = feedbackData.fontcolor or lib.frames[feedbackFrame].fontcolor
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].fontoutline = feedbackData.fontoutline or lib.frames[feedbackFrame].fontoutline
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].fontstring = lib.frames[feedbackFrame]:CreateFontString("Feedback_" .. feedbackFrame .. lib.frames[feedbackFrame].objects .. "_FontString", "ARTWORK", "MasterFont")
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].stickxoffset = 0
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].stickyoffset = 0
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].xoffset = 0
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].yoffset = 0
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].elapsed = 0
		lib.objects[feedbackFrame][lib.frames[feedbackFrame].objects].step = 0
	end
end

--[[
Notes:
	Allow mixin embedding
]]
lib.FireCallback = lib.callbacks.Fire
lib.CreateFeedback, lib.DestroyFeedback = lib.Create, lib.Destroy
lib.LockFeedback, lib.UnlockFeedback = lib.Lock, lib.Unlock
lib.AddFeedbackData = lib.AddData
lib.embeded = lib.embeded or {}
local mixins = {
	"AddCallback", "FireCallback", "RemoveCallback", "RemoveAllCallbacks",
	"CreateFeedback", "DestroyFeedback",
	"LockFeedback", "UnlockFeedback",
	"AddFeedbackData",
}
function lib:Embed(target)
	for k, v in pairs(mixins) do
		target[v] = self[v]
	end
	self.embeded[target] = true
	target.callbacks = target.callbacks or {}
	return target
end
for target, v in pairs(lib.embeded) do
	lib:Embed(target)
end
