local CombatAlert = Rock:NewAddon("CombatAlert", "LibRockDB-1.0", "LibRockHook-1.0", "LibRockEvent-1.0", "LibRockTimer-1.0", "LibRockConfig-1.0", "LibRockConsole-1.0", "LibFuBarPlugin-3.0", "LibFeedback-0.1")
local self = CombatAlert

local _G = _G
local bit = _G.bit
local time = _G.time
local math = _G.math
local string = _G.string
local pairs = _G.pairs
local ipairs = _G.ipairs
local select = _G.select
local tonumber = _G.tonumber
local UIParent = _G.UIParent
local PlaySoundFile = _G.PlaySoundFile
local IsAddOnLoaded = _G.IsAddOnLoaded
local CombatText_AddMessage = _G.CombatText_AddMessage
local GetInventorySlotInfo = _G.GetInventorySlotInfo
local GetInventoryItemLink = _G.GetInventoryItemLink
local GetInventoryItemCooldown = _G.GetInventoryItemCooldown
local GetContainerNumSlots = _G.GetContainerNumSlots
local GetContainerItemLink = _G.GetContainerItemLink
local GetContainerItemCooldown = _G.GetContainerItemCooldown
local GetSpellName = _G.GetSpellName
local GetSpellCooldown = _G.GetSpellCooldown
local GetRealZoneText = _G.GetRealZoneText
local GetGameTime = _G.GetGameTime
local GetTime = _G.GetTime
local GetCVar = _G.GetCVar
local UnitName = _G.UnitName
local UnitFactionGroup = _G.UnitFactionGroup
local UnitCreatureType = _G.UnitCreatureType
local UnitCreatureFamily = _G.UnitCreatureFamily
local BOOKTYPE_SPELL = _G.BOOKTYPE_SPELL
local BOOKTYPE_PET = _G.BOOKTYPE_PET

self:AddSlashCommand('OnCommand', '/CombatAlert', '/cal', '/ca')
self:SetDatabase('CombatAlertDB', 'CombatAlertPCDB')
self:SetFuBarOption('iconPath', "Interface\\AddOns\\CombatAlert\\icon")
self:SetFuBarOption('hasNoColor', true)

local MESSAGE_SHOW = 1
local MESSAGE_WARN = 2
local MESSAGE_ALERT = 3
local COOLDOWN_MINIMUM = 3
local COOLDOWN_MAXIMUM = 300
local COOLDOWN_MODIFIERS = { -- TODO: add modifier check
	["Cold Snap"] = {
		[3] = "Frost Nova",
		[1] = "Ice Block",
		[2] = "Frost Ward",
		[4] = "Ice Barrier",
		[5] = "Cone of Cold",
	},
	["Preparation"] = {
		[1] = "Evasion",
		[2] = "Sprint",
		[3] = "Vanish",
		[4] = "Cold Blood",
		[5] = "Adrenaline Rush",
		[6] = "Premeditation",
	},
	["Renataki's Charm of Beasts"] = {
		[1] = "Arcane Shot",
		[2] = "Aimed Shot",
		[3] = "Multi-Shot",
		[4] = "Volley",
	}
}
local COOLDOWN_GROUPS = {
	["Reta/SW/Reck"] = {
		[1] = "Retaliation",
		[2] = "Shield Wall",
		[3] = "Recklessness",
	},
	["Shocks"] = {
		[1] = "Earth Shock",
		[2] = "Flame Shock",
		[3] = "Frost Shock",
	},
	["Shots"] = {
		[1] = "Arcane Shot",
		[2] = "Aimed Shot",
	},
	["Traps"] = {
		[1] = "Freezing Trap",
		[2] = "Immolation Trap",
		[3] = "Explosive Trap",
		[4] = "Frost Trap",
	},
	["Wards"] = {
		[1] = "Frost Ward",
		[2] = "Fire Ward",
	}
}

function CombatAlert:OnInitialize()
	self.guidregistry = LibStub("LibGUIDRegistry-0.1", true)
	self.sharedmedia = LibStub("LibSharedMedia-3.0", true)
	self.sharedmedia:Register('sound', "CA: Info", "Sound\\Doodad\\BellTollTribal.wav")
	self.sharedmedia:Register('sound', "CA: Warn", "Sound\\Doodad\\BellTollNightElf.wav")
	if UnitFactionGroup('player') == "Horde" then
		self.sharedmedia:Register('sound', "CA: Alert", "Sound\\Doodad\\BellTollHorde.wav")
	else
		self.sharedmedia:Register('sound', "CA: Alert", "Sound\\Doodad\\BellTollAlliance.wav")
	end
	self:SetDatabaseDefaults('profile', {
		showIcon = true,
		showText = false,
		presetmode = false,
		compactmode = false,
		capture = false,
		silent = false,
		heals = false,
		damage = false,
		frame = "feedback",
		frames = {
			["Notification"] = {
				xoffset = 0,
				yoffset = 0,
				fontsize = 20,
				fonttype = "Fonts\\ARIALN.TTF",
				fontcolor = { r = 0.0, g = 0.0, b = 1.0, a = 1.0 },
				fontoutline = "THICKOUTLINE",
				animationstyle = "Scroll",
				animationdirection = "UP:NONE",
				animationdelay = 0.025,
				animationsteps = 96,
				animationstick = 32,
			},
			["Damage"] = {
				xoffset = 0,
				yoffset = 0,
				fontsize = 12,
				fonttype = "Fonts\\ARIALN.TTF",
				fontcolor = { r = 1.0, g = 0.0, b = 0.0, a = 1.0 },
				fontoutline = "OUTLINE",
				animationstyle = "Scroll",
				animationdirection = "DOWN:ALT",
				animationdelay = 0.0125,
				animationsteps = 64,
				animationstick = 16,
			},
			["Heals"] = {
				xoffset = 0,
				yoffset = 0,
				fontsize = 12,
				fonttype = "Fonts\\ARIALN.TTF",
				fontcolor = { r = 0.0, g = 1.0, b = 0.0, a = 1.0 },
				fontoutline = "OUTLINE",
				animationstyle = "Scroll",
				animationdirection = "UP:ALT",
				animationdelay = 0.0125,
				animationsteps = 64,
				animationstick = 16,
			},
		},
		fontsize = "16",
		fonttype = "Arial Narrow",
		fontoutline = "OUTLINE",
		statecolor = { r=0.0, g=1.0, b=0.0, a=1.0 },
		cooldowncolor = { r=1.0, g=1.0, b=0.0, a=1.0 },
		debuffcolor = { r=0.5, g=0.0, b=1.0, a=1.0 },
		buffcolor = { r=0.5, g=0.0, b=0.5, a=1.0 },
		castcolor = { r=1.0, g=1.0, b=1.0, a=1.0 },
		fadecolor = { r=1.0, g=0.5, b=0.0, a=1.0 },
		dispelcolor = { r=1.0, g=0.0, b=0.0, a=1.0 },
		infosound = "CA: Info",
		warnsound = "CA: Warn",
		alertsound = "CA: Alert",
	})
	self:SetDatabaseDefaults('char', {
		captured = {},
		capture = {},
		ignore = {},
		show = {},
		info = {},
		warn = {},
		alert = {},
	})
	self:SetConfigTable({
		type = 'group',
		name = "Combat Alert",
		desc = "Combat event announcer",
		icon = "Interface\\AddOns\\CombatAlert\\icon",
		args = {
			presetmode = {
				order = 100,
				type = 'boolean',
				name = "Preset mode",
				desc = "Display preset alerts",
				get = function(presetmode)
					return self.db.profile.presetmode
				end,
				set = function(presetmode)
					self.db.profile.presetmode = presetmode
					self:SetVariables()
					self:SetListeners()
				end,
			},
			compactmode = {
				order = 101,
				type = 'boolean',
				name = "Compact mode",
				desc = "Display compact alerts",
				get = function()
					return self.db.profile.compactmode
				end,
				set = function(compactmode)
					self.db.profile.compactmode = compactmode
				end,
			},
			damage = {
				order = 102,
				type = 'boolean',
				name = "Show damage",
				desc = "Show incoming damage",
				get = function(damage)
					return self.db.profile.damage
				end,
				set = function(damage)
					self.db.profile.damage = damage
					self:SetVariables()
					self:SetListeners()
				end,
				hidden = function()
					return self.db.profile.presetmode
				end,
			},
			heals = {
				order = 103,
				type = 'boolean',
				name = "Show heals",
				desc = "Show incoming heals",
				get = function(heals)
					return self.db.profile.heals
				end,
				set = function(heals)
					self.db.profile.heals = heals
					self:SetVariables()
					self:SetListeners()
				end,
				hidden = function()
					return self.db.profile.presetmode
				end,
			},
			capture = {
				order = 104,
				type = 'boolean',
				name = "Capture events",
				desc = "Capture all new events",
				get = function()
					return self.db.profile.capture
				end,
				set = function(capture)
					self.db.profile.capture = capture
				end,
				hidden = function()
					return self.db.profile.presetmode
				end,
			},
			silent = {
				order = 105,
				type = 'boolean',
				name = "Silent capture",
				desc = "Disable printing new events",
				get = function()
					return self.db.profile.silent
				end,
				set = function(silent)
					self.db.profile.silent = silent
				end,
				hidden = function()
					return not self.db.profile.capture
				end,
				hidden = function()
					return self.db.profile.presetmode
				end,
			},
			infosound = {
				order = 106,
				type = 'choice',
				name = "Info sound",
				desc = "Changes the info sound",
				get = function()
					return self.db.profile.infosound
				end,
				set = function(infosound)
					self.db.profile.infosound = infosound
					if self.db.profile.infosound == "None" then
						self:Print("info sound disabled!")
					else
						PlaySoundFile(self.sharedmedia:Fetch('sound', self.db.profile.infosound))
					end
				end,
				choices = self.sharedmedia:List('sound'),
			},
			warnsound = {
				order = 107,
				type = 'choice',
				name = "Warn sound",
				desc = "Changes the warn sound",
				get = function()
					return self.db.profile.warnsound
				end,
				set = function(warnsound)
					self.db.profile.warnsound = warnsound
					if self.db.profile.warnsound == "None" then
						self:Print("warn sound disabled!")
					else
						PlaySoundFile(self.sharedmedia:Fetch('sound', self.db.profile.warnsound))
					end
				end,
				choices = self.sharedmedia:List('sound'),
			},
			alertsound = {
				order = 108,
				type = 'choice',
				name = "Alert sound",
				desc = "Changes the alert sound",
				get = function()
					return self.db.profile.alertsound
				end,
				set = function(alertsound)
					self.db.profile.alertsound = alertsound
					if self.db.profile.alertsound == "None" then
						self:Print("alert sound disabled!")
					else
						PlaySoundFile(self.sharedmedia:Fetch('sound', self.db.profile.alertsound))
					end
				end,
				choices = self.sharedmedia:List('sound'),
			},
			frame = {
				order = 109,
				type = 'choice',
				name = "Message frames",
				desc = "Choose the message frames to use",
				get = function()
					return self.db.profile.frame
				end,
				set = function(frame)
					if (frame == "sct" and IsAddOnLoaded("sct")) or (frame == "msbt" and IsAddOnLoaded("MikScrollingBattleText")) or (frame == "parrot" and IsAddOnLoaded("Parrot")) or (frame == "blizzard" and SHOW_COMBAT_TEXT == "1") or frame == "feedback" then
						self.db.profile.frame = frame
						self:Announce("New frame selected")
					else
						self:Print("frame isnt usable!")
					end
				end,
				choices = {
					["feedback"] = "Feedback",
					["blizzard"] = "Blizzard",
					["parrot"] = "Parrot",
					["msbt"] = "MSBT",
					["sct"] = "SCT",
				},
			},
			header1 = {
				order = 200,
				type = 'header',
				hidden = function()
					return self.db.profile.frame ~= "feedback"
				end,
			},
			lock = {
				order = 201,
				type = 'boolean',
				name = "Lock frames",
				desc = "Locks the message frames",
				get = function()
					return self.db.profile.lock
				end,
				set = function()
					self.db.profile.lock = not self.db.profile.lock
					if self.db.profile.lock then
						for frame in pairs(self.db.profile.frames) do
							self:LockFeedback(frame)
						end
					else
						for frame in pairs(self.db.profile.frames) do
							self:UnlockFeedback(frame)
						end
					end
				end,
				hidden = function()
					return self.db.profile.frame ~= "feedback"
				end,
			},
			fonttype = {
				order = 202,
				type = 'choice',
				name = "Font type",
				desc = "Changes the message font type",
				get = function()
					return self.db.profile.fonttype
				end,
				set = function(fonttype)
					self.db.profile.fonttype = fonttype
					for frame in pairs(self.db.profile.frames) do
						self.db.profile.frames[frame].fonttype = self.sharedmedia:Fetch('font', fonttype)
					end
					self:SetFrames()
				end,
				hidden = function()
					return self.db.profile.frame ~= "feedback"
				end,
				choices = self.sharedmedia:List('font'),
			},
			fontsize = {
				order = 203,
				type = 'choice',
				name = "Font size",
				desc = "Changes the message font size",
				get = function()
					return self.db.profile.fontsize
				end,
				set = function(fontsize)
					self.db.profile.fontsize = fontsize
					for frame in pairs(self.db.profile.frames) do
						if frame == "Notification" then
							self.db.profile.frames[frame].fontsize = tonumber(fontsize) + 4
						else
							self.db.profile.frames[frame].fontsize = tonumber(fontsize) - 4
						end
					end
					self:SetFrames()
				end,
				hidden = function()
					return self.db.profile.frame ~= "feedback"
				end,
				choices = {
					["16"] = "Tiny",
					["22"] = "Small",
					["28"] = "Medium",
					["34"] = "Large",
					["40"] = "Huge",
				},
			},
			fontoutline = {
				order = 204,
				type = 'choice',
				name = "Font outline",
				desc = "Changes the message font outline",
				get = function()
					return self.db.profile.fontoutline
				end,
				set = function(fontoutline)
					self.db.profile.fontoutline = fontoutline
					for frame in pairs(self.db.profile.frames) do
						if frame == "Notification" then
							self.db.profile.frames[frame].fontoutline = fontoutline
						elseif fontoutline == "THICKOUTLINE" then
							self.db.profile.frames[frame].fontoutline = "OUTLINE"
						else
							self.db.profile.frames[frame].fontoutline = ""
						end
					end
					self:SetFrames()
				end,
				hidden = function()
					return self.db.profile.frame ~= "feedback"
				end,
				choices = {
					[""] = "None",
					["OUTLINE"] = "Thin",
					["THICKOUTLINE"] = "Thick",
				},
			},
			header2 = {
				order = 300,
				type = 'header',
			},
			notificationcolor = {
				order = 301,
				type = 'color',
				name = "Notification color",
				desc = "Changes the notification message color",
				get = function()
					return self.db.profile.frames['Notification'].fontcolor.r, self.db.profile.frames['Notification'].fontcolor.g, self.db.profile.frames['Notification'].fontcolor.b, self.db.profile.frames['Notification'].fontcolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.frames['Notification'].fontcolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
					self:SetFrames()
				end,
			},
			damagecolor = {
				order = 301,
				type = 'color',
				name = "Damage color",
				desc = "Changes the damage message color",
				get = function()
					return self.db.profile.frames['Damage'].fontcolor.r, self.db.profile.frames['Damage'].fontcolor.g, self.db.profile.frames['Damage'].fontcolor.b, self.db.profile.frames['Damage'].fontcolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.frames['Damage'].fontcolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
					self:SetFrames()
				end,
			},
			healscolor = {
				order = 301,
				type = 'color',
				name = "Heals color",
				desc = "Changes the heals message color",
				get = function()
					return self.db.profile.frames['Heals'].fontcolor.r, self.db.profile.frames['Heals'].fontcolor.g, self.db.profile.frames['Heals'].fontcolor.b, self.db.profile.frames['Heals'].fontcolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.frames['Heals'].fontcolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
					self:SetFrames()
				end,
			},
			cooldowncolor = {
				order = 302,
				type = 'color',
				name = "Cooldown color",
				desc = "Changes the cooldown message color",
				get = function()
					return self.db.profile.cooldowncolor.r, self.db.profile.cooldowncolor.g, self.db.profile.cooldowncolor.b, self.db.profile.cooldowncolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.cooldowncolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
				end,
			},
			statecolor = {
				order = 301,
				type = 'color',
				name = "State color",
				desc = "Changes the state message color",
				get = function()
					return self.db.profile.statecolor.r, self.db.profile.statecolor.g, self.db.profile.statecolor.b, self.db.profile.statecolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.statecolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
				end,
			},
			debuffcolor = {
				order = 303,
				type = 'color',
				name = "Debuff color",
				desc = "Changes the debuff message color",
				get = function()
					return self.db.profile.debuffcolor.r, self.db.profile.debuffcolor.g, self.db.profile.debuffcolor.b, self.db.profile.debuffcolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.debuffcolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
				end,
			},
			buffcolor = {
				order = 304,
				type = 'color',
				name = "Buff color",
				desc = "Changes the buff message color",
				get = function()
					return self.db.profile.buffcolor.r, self.db.profile.buffcolor.g, self.db.profile.buffcolor.b, self.db.profile.buffcolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.buffcolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
				end,
			},
			castcolor = {
				order = 305,
				type = 'color',
				name = "Cast color",
				desc = "Changes the cast message color",
				get = function()
					return self.db.profile.castcolor.r, self.db.profile.castcolor.g, self.db.profile.castcolor.b, self.db.profile.castcolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.castcolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
				end,
			},
			fadecolor = {
				order = 306,
				type = 'color',
				name = "Fade color",
				desc = "Changes the fade message color",
				get = function()
					return self.db.profile.fadecolor.r, self.db.profile.fadecolor.g, self.db.profile.fadecolor.b, self.db.profile.fadecolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.fadecolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
				end,
			},
			dispelcolor = {
				order = 307,
				type = 'color',
				name = "Dispel color",
				desc = "Changes the dispel message color",
				get = function()
					return self.db.profile.dispelcolor.r, self.db.profile.dispelcolor.g, self.db.profile.dispelcolor.b, self.db.profile.dispelcolor.a
				end,
				set = function(red, green, blue, alpha)
					self.db.profile.dispelcolor = {
						r = red,
						g = green,
						b = blue,
						a = alpha or 1.0,
					}
				end,
			},
		},
	})
end

function CombatAlert:OnEnable()
	self.fctdamage = GetCVar("CombatDamage")
	self.fcthealing = GetCVar("CombatHealing")
	self.fctenable = _G.SHOW_COMBAT_TEXT
	self:SetFrames()
	self:SetVariables()
	self:SetListeners()
end

function CombatAlert:OnDisable() 
	SetCVar("CombatDamage", self.fctdamage)
	SetCVar("CombatHealing", self.fcthealing)
	_G.SHOW_COMBAT_TEXT = self.fctenable
	self.db.profile.lock = true
	self:RemoveAllHooks()
	self:RemoveAllTimers()
	self:RemoveAllEventListeners()
end

function CombatAlert:OnCommand(command, text)
--[[	if text and string.find(text, "test%s(.+)") then
		local _, _, test = string.find(text, "test%s(%a+)%s.+")
		local _, _, pattern = string.find(text, "test%s%a+%s(.+)")
		if self[test] and type(self[test]) == 'function' then self[test](pattern) end
	else
--]]
	if text and string.find(text, "list%s(.+)") then
		local _, _, pattern = string.find(text, "list%s(.+)")
		self:List(pattern)
	elseif text and string.find(text, "insert%s(.+)") then
		local _, _, pattern = string.find(text, "insert%s(.+)")
		self:Insert(pattern)
	elseif text and string.find(text, "delete%s(.+)") then
		local _, _, pattern = string.find(text, "delete%s(.+)")
		self:Delete(pattern)
	else
		self:Print("Invalid command, view the readme.txt file in this addons directory for valid commands")
	end
end

function CombatAlert:OnFeedbackFrameMoved(event, frame, xoffset, yoffset)
	self.db.profile.frames[frame].xoffset, self.db.profile.frames[frame].yoffset = xoffset, yoffset
end

function CombatAlert:OnCombatLogEvent(caller, event, timestamp, eventType, sourceGUID, sourceName, sourceFlags, destinationGUID, destinationName, destinationFlags, ...)
	local sourceType, destinationType = self:GetObjectType(sourceFlags), self:GetObjectType(destinationFlags)
	if eventType == "SPELL_CAST_START" then -- spellId, spellName, spellSchool
		self:OnCastEvent("cast", sourceName, sourceType, destinationName, destinationType, select(2, ...))
	elseif eventType == "SPELL_AURA_APPLIED" and select(4, ...) == AURA_TYPE_BUFF then -- spellId, spellName, spellSchool, auraType
		self:OnBuffEvent("buff", sourceName, sourceType, destinationName, destinationType, select(2, ...))
	elseif eventType == "SPELL_AURA_APPLIED" and select(4, ...) == AURA_TYPE_DEBUFF then -- spellId, spellName, spellSchool, auraType
		self:OnDebuffEvent("debuff", sourceName, sourceType, destinationName, destinationType, select(2, ...))
	elseif eventType == "SPELL_AURA_REMOVED" then -- spellId, spellName, spellSchool, auraType
		self:OnFadeEvent("fade", sourceName, sourceType, destinationName, destinationType, select(2, ...))
	elseif eventType == "SPELL_AURA_DISPELLED" or eventType == "SPELL_AURA_STOLEN" then -- spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool
		self:OnDispelEvent("dispel", sourceName, sourceType, destinationName, destinationType, select(2, ...))
	end
end

function CombatAlert:OnCooldownUpdate(caller, event)
	local slotIDs = {
		"HeadSlot",
		"NeckSlot",
		"ShoulderSlot",
		"BackSlot",
		"ChestSlot",
		"WristSlot",
		"HandsSlot",
		"WaistSlot",
		"LegsSlot",
		"FeetSlot",
		"Finger0Slot",
		"Finger1Slot",
		"Trinket0Slot",
		"Trinket1Slot",
		"MainHandSlot",
		"SecondaryHandSlot",
	}
	local bookTypes = {
		['spell'] = BOOKTYPE_SPELL,
		['pet'] = BOOKTYPE_PET,
	}
	if event == "BAG_UPDATE_COOLDOWN" then
		for containerID = 0, 4 do
			for slotID = 1, GetContainerNumSlots(containerID) do
				if GetContainerItemLink(containerID, slotID) then
					local _, _, itemName = string.find(GetContainerItemLink(containerID, slotID), "%[(.+)%]")
					local start, duration, hasCooldown = GetContainerItemCooldown(containerID, slotID)
					if hasCooldown and start > 0 and duration > COOLDOWN_MINIMUM then
						self:AddTimer("COOLDOWN:" .. itemName, duration - (GetTime() - start), "OnCooldownEvent", "container", itemName)
						for cooldownGroup in pairs(COOLDOWN_GROUPS) do
							for _, cooldownName in ipairs(COOLDOWN_GROUPS[cooldownGroup]) do
								if itemName == cooldownName then
									self:AddTimer("COOLDOWN:" .. cooldownGroup, duration - (GetTime() - start), "OnCooldownEvent", "itemgroup", cooldownGroup)
								end
							end
						end
					end
				end
			end
		end
		for _, slot in ipairs(slotIDs) do
			local slotID = GetInventorySlotInfo(slot)
			if GetInventoryItemLink('player', slotID) then
				local _, _, itemName = string.find(GetInventoryItemLink('player', slotID), "%[(.+)%]")
				local start, duration, hasCooldown = GetInventoryItemCooldown('player', slotID)
				if hasCooldown and start > 0 and duration > COOLDOWN_MINIMUM then
					self:AddTimer("COOLDOWN:" .. itemName, duration - (GetTime() - start), "OnCooldownEvent", "inventory", itemName)
					for cooldownGroup in pairs(COOLDOWN_GROUPS) do
						for _, cooldownName in ipairs(COOLDOWN_GROUPS[cooldownGroup]) do
							if itemName == cooldownName then
								self:AddTimer("COOLDOWN:" .. cooldownGroup, duration - (GetTime() - start), "OnCooldownEvent", "itemgroup", cooldownGroup)
							end
						end
					end
				end
			end
		end
	elseif event == "SPELL_UPDATE_COOLDOWN" then
		for bookType, bookID in pairs(bookTypes) do
			local spellID = 1
			local spellName = GetSpellName(spellID, bookID)
			while spellName do
				local start, duration, hasCooldown = GetSpellCooldown(spellID, bookID)
				if hasCooldown and start > 0 and duration > COOLDOWN_MINIMUM then
					self:AddTimer("COOLDOWN:" .. spellName, duration - (GetTime() - start), "OnCooldownEvent", bookType, spellName)
					for cooldownGroup in pairs(COOLDOWN_GROUPS) do
						for _, cooldownName in ipairs(COOLDOWN_GROUPS[cooldownGroup]) do
							if spellName == cooldownName then
								self:AddTimer("COOLDOWN:" .. cooldownGroup, duration - (GetTime() - start), "OnCooldownEvent", "spellgroup", cooldownGroup)
							end
						end
					end
				end
				spellID = spellID + 1
				spellName = GetSpellName(spellID, bookID)
			end
		end
	end
end

function CombatAlert:OnCooldownEvent(cooldownType, cooldownName)
	local eventType = "cooldown"
	if self:Search(string.format("ignore %s %s %s", eventType, cooldownType, cooldownName)) then return end
	if self.db.profile.capture or self:Search(string.format("capture %s %s %s", eventType, cooldownType, cooldownName)) then
		if not self:Search(string.format("captured %s %s %s", eventType, cooldownType, cooldownName)) then
			self:Insert(string.format("captured %s %s %s", eventType, cooldownType, cooldownName))
			if not self.db.profile.silent then
				self:Print(string.format("New %s captured: %s %s", eventType, cooldownType, cooldownName))
			end
		end
	end
	if self:Search(string.format("alert %s %s %s", eventType, cooldownType, cooldownName)) then
		if self.db.profile.compactmode then
			self:Announce(string.format("[%s]", cooldownName), self.db.profile.cooldowncolor, MESSAGE_ALERT)
		else
			self:Announce(string.format("%s ready", cooldownName), self.db.profile.cooldowncolor, MESSAGE_ALERT)
		end
	elseif (self.db.profile.presetmode and cooldownType == 'inventory') or self:Search(string.format("warn %s %s %s", eventType, cooldownType, cooldownName)) then
		if self.db.profile.compactmode then
			self:Announce(string.format("[%s]", cooldownName), self.db.profile.cooldowncolor, MESSAGE_WARN)
		else
			self:Announce(string.format("%s ready", cooldownName), self.db.profile.cooldowncolor, MESSAGE_WARN)
		end
	elseif (self.db.profile.presetmode and cooldownType == 'spell' or cooldownType == 'container') or self:Search(string.format("show %s %s %s", eventType, cooldownType, cooldownName)) then
		if self.db.profile.compactmode then
			self:Announce(string.format("[%s]", cooldownName), self.db.profile.cooldowncolor, MESSAGE_SHOW)
		else
			self:Announce(string.format("%s ready", cooldownName), self.db.profile.cooldowncolor, MESSAGE_SHOW)
		end
	end
end

function CombatAlert:OnStateEvent(caller, event)
	local eventType, stateType = "state"
	if event == "PLAYER_REGEN_ENABLED" then
		stateType = "nocombat"
	elseif event == "PLAYER_REGEN_DISABLED" then
		stateType = "combat"
	end
	if self:Search(string.format("ignore %s %s", eventType, stateType)) then return end
	if self.db.profile.capture or self:Search(string.format("capture %s %s", eventType, stateType)) then
		if not self:Search(string.format("captured %s %s", eventType, stateType)) then
			self:Insert(string.format("captured %s %s", eventType, stateType))
			if not self.db.profile.silent then
				self:Print(string.format("New %s captured: %s", eventType, stateType))
			end
		end
	end
	if self:Search(string.format("alert %s %s", eventType, stateType)) then
		if self.db.profile.compactmode and stateType == "combat" then
			self:Announce(string.format("[+combat]"), self.db.profile.statecolor, MESSAGE_ALERT)
		elseif self.db.profile.compactmode and stateType == "nocombat" then
			self:Announce(string.format("[-combat]"), self.db.profile.statecolor, MESSAGE_ALERT)
		elseif stateType == "combat" then
			self:Announce(string.format("You have entered combat"), self.db.profile.statecolor, MESSAGE_ALERT)
		else
			self:Announce(string.format("You have exited combat"), self.db.profile.statecolor, MESSAGE_ALERT)
		end
	elseif self:Search(string.format("warn %s %s", eventType, stateType)) then
		if self.db.profile.compactmode and stateType == "combat" then
			self:Announce(string.format("[+combat]"), self.db.profile.statecolor, MESSAGE_WARN)
		elseif self.db.profile.compactmode and stateType == "nocombat" then
			self:Announce(string.format("[-combat]"), self.db.profile.statecolor, MESSAGE_WARN)
		elseif stateType == "combat" then
			self:Announce(string.format("You have entered combat"), self.db.profile.statecolor, MESSAGE_WARN)
		else
			self:Announce(string.format("You have exited combat"), self.db.profile.statecolor, MESSAGE_WARN)
		end
	elseif self.db.profile.presetmode or self:Search(string.format("show %s %s", eventType, stateType)) then
		if self.db.profile.compactmode and stateType == "combat" then
			self:Announce(string.format("[+combat]"), self.db.profile.statecolor, MESSAGE_SHOW)
		elseif self.db.profile.compactmode and stateType == "nocombat" then
			self:Announce(string.format("[-combat]"), self.db.profile.statecolor, MESSAGE_SHOW)
		elseif stateType == "combat" then
			self:Announce(string.format("You have entered combat"), self.db.profile.statecolor, MESSAGE_SHOW)
		else
			self:Announce(string.format("You have exited combat"), self.db.profile.statecolor, MESSAGE_SHOW)
		end
	end
end

function CombatAlert:OnCastEvent(eventType, sourceName, sourceType, destinationName, destinationType, abilityName, isBegin, isPerform)
	if self:Search(string.format("ignore %s %s %s %s", eventType, sourceType, destinationType, abilityName)) then return end
	if self.db.profile.capture or self:Search(string.format("capture %s %s %s %s", eventType, sourceType, destinationType, abilityName)) then
		if not self:Search(string.format("captured %s %s %s %s", eventType, sourceType, destinationType, abilityName)) then
			self:Insert(string.format("captured %s %s %s %s", eventType, sourceType, destinationType, abilityName))
			if not self.db.profile.silent then
				self:Print(string.format("New %s captured: %s %s %s", eventType, sourceType, destinationType, abilityName))
			end
		end
	end
	if destinationType == 'player' then destinationName = "you" end
	if destinationType == 'target' then destinationName = "your target" end
	if destinationType == 'focus' then destinationName = "your focus" end
	if destinationType == 'pet' then destinationName = "your pet" end
	if (self.db.profile.presetmode and destinationType == 'player') or self:Search(string.format("alert %s %s %s %s", eventType, sourceType, destinationType, abilityName)) then
		if sourceType == 'focus' and destinationType == 'unknown' then
			self:Announce(string.format("--- %s casts %s ---", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_ALERT)
		elseif sourceType == 'target' and destinationType == 'unknown' then
			self:Announce(string.format("*** %s casts %s ***", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_ALERT)
		elseif sourceType == 'focus' and destinationType ~= 'unknown' then
			self:Announce(string.format("--- %s casts %s at %s ---", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_ALERT)
		elseif sourceType == 'target' and destinationType ~= 'unknown' then
			self:Announce(string.format("*** %s casts %s at %s ***", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_ALERT)
		elseif destinationType ~= 'unknown' then
			self:Announce(string.format("%s casts %s at %s", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_ALERT)
		else
			self:Announce(string.format("%s casts %s", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_ALERT)
		end
	elseif self:Search(string.format("warn %s %s %s %s", eventType, sourceType, destinationType, abilityName)) then
		if sourceType == 'focus' and destinationType == 'unknown' then
			self:Announce(string.format("--- %s casts %s ---", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_WARN)
		elseif sourceType == 'target' and destinationType == 'unknown' then
			self:Announce(string.format("*** %s casts %s ***", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_WARN)
		elseif sourceType == 'focus' and destinationType ~= 'unknown' then
			self:Announce(string.format("--- %s casts %s at %s ---", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_WARN)
		elseif sourceType == 'target' and destinationType ~= 'unknown' then
			self:Announce(string.format("*** %s casts %s at %s ***", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_WARN)
		elseif destinationType ~= 'unknown' then
			self:Announce(string.format("%s casts %s at %s", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_WARN)
		else
			self:Announce(string.format("%s casts %s", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_WARN)
		end
	elseif self:Search(string.format("show %s %s %s %s", eventType, sourceType, destinationType, abilityName)) then
		if sourceType == 'focus' and destinationType == 'unknown' then
			self:Announce(string.format("--- %s casts %s ---", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_SHOW)
		elseif sourceType == 'target' and destinationType == 'unknown' then
			self:Announce(string.format("*** %s casts %s ***", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_SHOW)
		elseif sourceType == 'focus' and destinationType ~= 'unknown' then
			self:Announce(string.format("--- %s casts %s at %s ---", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_SHOW)
		elseif sourceType == 'target' and destinationType ~= 'unknown' then
			self:Announce(string.format("*** %s casts %s at %s ***", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_SHOW)
		elseif destinationType ~= 'unknown' then
			self:Announce(string.format("%s casts %s at %s", sourceName, abilityName, destinationName), self.db.profile.castcolor, MESSAGE_SHOW)
		else
			self:Announce(string.format("%s casts %s", sourceName, abilityName), self.db.profile.castcolor, MESSAGE_SHOW)
		end
	end
end

function CombatAlert:OnBuffEvent(eventType, sourceName, sourceType, destinationName, destinationType, abilityName)
	if self:Search(string.format("ignore %s %s %s", eventType, destinationType, abilityName)) then return end
	if self.db.profile.capture or self:Search(string.format("capture %s %s %s", eventType, destinationType, abilityName)) then
		if not self:Search(string.format("captured %s %s %s", eventType, destinationType, abilityName)) then
			self:Insert(string.format("captured %s %s %s", eventType, destinationType, abilityName))
			if not self.db.profile.silent then
				self:Print(string.format("New %s captured: %s %s", eventType, destinationType, abilityName))
			end
		end
	end
	if self:Search(string.format("alert %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[+%s]", abilityName), self.db.profile.buffcolor, MESSAGE_ALERT)
			else
				self:Announce(string.format("You gain %s", abilityName), self.db.profile.buffcolor, MESSAGE_ALERT)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("Your pet gains %s", abilityName), self.db.profile.buffcolor, MESSAGE_ALERT)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s gains %s ---", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_ALERT)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s gains %s ***", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_ALERT)
		else
			self:Announce(string.format("%s gains %s", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_ALERT)
		end
	elseif self:Search(string.format("warn %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[+%s]", abilityName), self.db.profile.buffcolor, MESSAGE_WARN)
			else
				self:Announce(string.format("You gain %s", abilityName), self.db.profile.buffcolor, MESSAGE_WARN)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("Your pet gains %s", abilityName), self.db.profile.buffcolor, MESSAGE_WARN)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s gains %s ---", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_WARN)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s gains %s ***", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_WARN)
		else
			self:Announce(string.format("%s gains %s", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_WARN)
		end
	elseif (self.db.profile.presetmode and (destinationType == 'target' or destinationType == 'focus' or destinationType == 'player')) or self:Search(string.format("show %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[+%s]", abilityName), self.db.profile.buffcolor, MESSAGE_SHOW)
			else
				self:Announce(string.format("You gain %s", abilityName), self.db.profile.buffcolor, MESSAGE_SHOW)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("Your pet gains %s", abilityName), self.db.profile.buffcolor, MESSAGE_SHOW)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s gains %s ---", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_SHOW)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s gains %s ***", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_SHOW)
		else
			self:Announce(string.format("%s gains %s", destinationName, abilityName), self.db.profile.buffcolor, MESSAGE_SHOW)
		end
	end
end

function CombatAlert:OnDebuffEvent(eventType, sourceName, sourceType, destinationName, destinationType, abilityName)
	if self:Search(string.format("ignore %s %s %s", eventType, destinationType, abilityName)) then return end
	if self.db.profile.capture or self:Search(string.format("capture %s %s %s", eventType, destinationType, abilityName)) then
		if not self:Search(string.format("captured %s %s %s", eventType, destinationType, abilityName)) then
			self:Insert(string.format("captured %s %s %s", eventType, destinationType, abilityName))
			if not self.db.profile.silent then
				self:Print(string.format("New %s captured: %s %s", eventType, destinationType, abilityName))
			end
		end
	end
	if (self.db.profile.presetmode and destinationType == 'player') or self:Search(string.format("alert %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[+%s]", abilityName), self.db.profile.debuffcolor, MESSAGE_ALERT)
			else
				self:Announce(string.format("You gain %s", abilityName), self.db.profile.debuffcolor, MESSAGE_ALERT)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("Your pet gains %s", abilityName), self.db.profile.debuffcolor, MESSAGE_ALERT)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s gains %s ---", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_ALERT)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s gains %s ***", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_ALERT)
		else
			self:Announce(string.format("%s gains %s", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_ALERT)
		end
	elseif self:Search(string.format("warn %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[+%s]", abilityName), self.db.profile.debuffcolor, MESSAGE_WARN)
			else
				self:Announce(string.format("You gain %s", abilityName), self.db.profile.debuffcolor, MESSAGE_WARN)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("Your pet gains %s", abilityName), self.db.profile.debuffcolor, MESSAGE_WARN)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s gains %s ---", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_WARN)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s gains %s ***", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_WARN)
		else
			self:Announce(string.format("%s gains %s", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_WARN)
		end
	elseif (self.db.profile.presetmode and (destinationType == 'target' or destinationType == 'focus' or destinationType == 'player')) or self:Search(string.format("show %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[+%s]", abilityName), self.db.profile.debuffcolor, MESSAGE_SHOW)
			else
				self:Announce(string.format("You gain %s", abilityName), self.db.profile.debuffcolor, MESSAGE_SHOW)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("Your pet gains %s", abilityName), self.db.profile.debuffcolor, MESSAGE_SHOW)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s gains %s ---", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_SHOW)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s gains %s ***", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_SHOW)
		else
			self:Announce(string.format("%s gains %s", destinationName, abilityName), self.db.profile.debuffcolor, MESSAGE_SHOW)
		end
	end
end

function CombatAlert:OnDispelEvent(eventType, sourceName, sourceType, destinationName, destinationType, abilityName)
	if self:Search(string.format("ignore %s %s %s", eventType, destinationType, abilityName)) then return end
	if self.db.profile.capture or self:Search(string.format("capture %s %s %s", eventType, destinationType, abilityName)) then
		if not self:Search(string.format("captured %s %s %s", eventType, destinationType, abilityName)) then
			self:Insert(string.format("captured %s %s %s", eventType, destinationType, abilityName))
			if not self.db.profile.silent then
				self:Print(string.format("New %s captured: %s %s", eventType, destinationType, abilityName))
			end
		end
	end
	if self:Search(string.format("alert %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[-%s]", abilityName), self.db.profile.dispelcolor, MESSAGE_ALERT)
			else
				self:Announce(string.format("%s is dispelled from you", abilityName), self.db.profile.dispelcolor, MESSAGE_ALERT)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("%s is dispelled from your pet", abilityName), self.db.profile.dispelcolor, MESSAGE_ALERT)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s is dispelled from %s ---", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_ALERT)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s is dispelled from %s ***", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_ALERT)
		else
			self:Announce(string.format("%s is dispelled from %s", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_ALERT)
		end
	elseif self:Search(string.format("warn %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[-%s]", abilityName), self.db.profile.dispelcolor, MESSAGE_WARN)
			else
				self:Announce(string.format("%s is dispelled from you", abilityName), self.db.profile.dispelcolor, MESSAGE_WARN)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("%s is dispelled from your pet", abilityName), self.db.profile.dispelcolor, MESSAGE_WARN)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s is dispelled from %s ---", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_WARN)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s is dispelled from %s ***", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_WARN)
		else
			self:Announce(string.format("%s is dispelled from %s", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_WARN)
		end
	elseif (self.db.profile.presetmode and destinationType == 'player') or self:Search(string.format("show %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[-%s]", abilityName), self.db.profile.dispelcolor, MESSAGE_SHOW)
			else
				self:Announce(string.format("%s is dispelled from you", abilityName), self.db.profile.dispelcolor, MESSAGE_SHOW)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("%s is dispelled from your pet", abilityName), self.db.profile.dispelcolor, MESSAGE_SHOW)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s is dispelled from %s ---", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_SHOW)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s is dispelled from %s ***", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_SHOW)
		else
			self:Announce(string.format("%s is dispelled from %s", abilityName, destinationName), self.db.profile.dispelcolor, MESSAGE_SHOW)
		end
	end
end

function CombatAlert:OnFadeEvent(eventType, sourceName, sourceType, destinationName, destinationType, abilityName)
	if self:Search(string.format("ignore %s %s %s", eventType, destinationType, abilityName)) then return end
	if self.db.profile.capture or self:Search(string.format("capture %s %s %s", eventType, destinationType, abilityName)) then
		if not self:Search(string.format("captured %s %s %s", eventType, destinationType, abilityName)) then
			self:Insert(string.format("captured %s %s %s", eventType, destinationType, abilityName))
			if not self.db.profile.silent then
				self:Print(string.format("New %s captured: %s %s", eventType, destinationType, abilityName))
			end
		end
	end
	if self:Search(string.format("alert %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[-%s]", abilityName), self.db.profile.fadecolor, MESSAGE_ALERT)
			else
				self:Announce(string.format("%s fades from you", abilityName), self.db.profile.fadecolor, MESSAGE_ALERT)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("%s fades from your pet", abilityName), self.db.profile.fadecolor, MESSAGE_ALERT)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s fades from %s ---", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_ALERT)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s fades from %s ***", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_ALERT)
		else
			self:Announce(string.format("%s fades from %s", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_ALERT)
		end
	elseif self:Search(string.format("warn %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[-%s]", abilityName), self.db.profile.fadecolor, MESSAGE_WARN)
			else
				self:Announce(string.format("%s fades from you", abilityName), self.db.profile.fadecolor, MESSAGE_WARN)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("%s fades from your pet", abilityName), self.db.profile.fadecolor, MESSAGE_WARN)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s fades from %s ---", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_WARN)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s fades from %s ***", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_WARN)
		else
			self:Announce(string.format("%s fades from %s", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_WARN)
		end
	elseif (self.db.profile.presetmode and (destinationType == 'player' or destinationType == 'target' or destinationType == 'focus')) or self:Search(string.format("show %s %s %s", eventType, destinationType, abilityName)) then
		if destinationType == 'player' then
			if self.db.profile.compactmode then
				self:Announce(string.format("[-%s]", abilityName), self.db.profile.fadecolor, MESSAGE_SHOW)
			else
				self:Announce(string.format("%s fades from you", abilityName), self.db.profile.fadecolor, MESSAGE_SHOW)
			end
		elseif destinationType == 'pet' then
			self:Announce(string.format("%s fades from your pet", abilityName), self.db.profile.fadecolor, MESSAGE_SHOW)
		elseif destinationType == 'focus' then
			self:Announce(string.format("--- %s fades from %s ---", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_SHOW)
		elseif destinationType == 'target' then
			self:Announce(string.format("*** %s fades from %s ***", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_SHOW)
		else
			self:Announce(string.format("%s fades from %s", abilityName, destinationName), self.db.profile.fadecolor, MESSAGE_SHOW)
		end
	end
end

function CombatAlert:CombatText_AddMessage(message, scrollFunction, r, g, b, displayType, isStaggered)
	if (self.db.profile.presetmode or self.db.profile.damage) and type(message) == "string" and string.find(message, "-(%d+)") then
		self:AddFeedbackData("Damage", { text = select(3, string.find(message, "-(%d+)")), fontcolor = self.db.profile.frames["Damage"].fontcolor, sticky = displayType == "crit" or false })
	elseif (self.db.profile.presetmode or self.db.profile.heals) and type(message) == "string" and string.find(message, "+(%d+)") then
		self:AddFeedbackData("Heals", { text = select(3, string.find(message, "(+%d+)")), fontcolor = self.db.profile.frames["Heals"].fontcolor, sticky = displayType == "crit" or false })
	end
end

function CombatAlert:Announce(messageText, messageColor, messageType)
	local messageColor = messageColor and messageColor or { r = 1.0, g = 1.0, b = 1.0, a = 1.0 }
	local messageSticky = messageType and (messageType == MESSAGE_ALERT or messageType == MESSAGE_WARN) or false
	local messageSound = self.sharedmedia:Fetch('sound', "None") or "Interface\\Quiet.wav"
	if messageType and messageType == MESSAGE_ALERT and self.db.profile.alertsound and self.db.profile.alertsound ~= "None" then
		messageSound = self.sharedmedia:Fetch('sound', self.db.profile.alertsound)
	elseif messageType and messageType == MESSAGE_WARN and self.db.profile.warnsound and self.db.profile.warnsound ~= "None" then
		messageSound = self.sharedmedia:Fetch('sound', self.db.profile.warnsound)
	elseif messageType and messageType == MESSAGE_INFO and self.db.profile.infosound and self.db.profile.infosound ~= "None" then
		messageSound = self.sharedmedia:Fetch('sound', self.db.profile.infosound)
	end
	if IsAddOnLoaded("sct") and self.db.profile.frame == "sct" then
		SCT:DisplayMessage(messageText, messageColor)
		PlaySoundFile(messageSound)
	elseif IsAddOnLoaded("Parrot") and self.db.profile.frame == "parrot" then
		Parrot:ShowMessage(messageText, "Notification", false, messageColor.r, messageColor.g, messageColor.b)
		PlaySoundFile(messageSound)
	elseif IsAddOnLoaded("MikScrollingBattleText") and self.db.profile.frame == "msbt" then
		MikSBT.DisplayMessage(messageText, MikSBT.DISPLAYTYPE_NOTIFICATION, false, messageColor.r, messageColor.g, messageColor.b)
		PlaySoundFile(messageSound)
	elseif SHOW_COMBAT_TEXT == "1" and self.db.profile.frame == "blizzard" then
		CombatText_AddMessage(messageText, COMBAT_TEXT_SCROLL_FUNCTION, messageColor.r, messageColor.g, messageColor.b, messageSticky and "crit" or "")
		PlaySoundFile(messageSound)
	else
		self:AddFeedbackData("Notification", { text = messageText, fontcolor = messageColor, sticky = messageSticky, sound = messageSound } )
	end
end

function CombatAlert:Insert(pattern)
	local _, _, type = string.find(pattern, "(%a+)")
	local _, _, value = string.find(pattern, "%a+%s(.+)")
	if type and self.db.char[type] and value then
		table.insert(self.db.char[type], value)
		table.sort(self.db.char[type])
	end
end

function CombatAlert:Search(pattern) -- TODO: re-check the way this works and maybe make a local search for self-use
	local _, _, type = string.find(pattern, "(%a+)")
	local _, _, value = string.find(pattern, "%a+%s(.+)")
	if type and self.db.char[type] and value then
		value = string.gsub(value, "*", ".+")
		for i, v in ipairs(self.db.char[type]) do
			v = string.gsub(v, "*", ".+")
			if string.find(v, value) or string.find(value, v) then
				return true
			end
		end
	end
	return false
end

function CombatAlert:Delete(pattern)
	local _, _, type = string.find(pattern, "(%a+)")
	local _, _, value = string.find(pattern, "%a+%s(.+)")
	if type and self.db.char[type] then
		if not value then
			self.db.char[type] = {}
		else
			value = string.gsub(value, "*", ".+")
			value = string.gsub(value, "\(.+\)", "")
			for i, v in ipairs(self.db.char[type]) do
				if string.find(v, value) then
					table.remove(self.db.char[type], i)
				end
			end
		end
	end
end

function CombatAlert:List(pattern)
	local _, _, type = string.find(pattern, "(%a+)")
	local _, _, value = string.find(pattern, "%a+%s(.+)")
	if type and self.db.char[type] then
		if value then
			value = string.gsub(value, "*", ".+")
		end
		for i, v in ipairs(self.db.char[type]) do
			if not value or string.find(v, value) then
				self:Print(string.format("%s %s", type, v))
			end
		end
	end
end

function CombatAlert:GetObjectType(objectFlags)
	local COMBATLOG_OBJECT = {
		[1] = { 'guardian', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_MINE, COMBATLOG_OBJECT_TYPE_GUARDIAN) },
		[2] = { 'object', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_MINE, COMBATLOG_OBJECT_TYPE_OBJECT) },
		[3] = { 'pet', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_MINE, COMBATLOG_OBJECT_TYPE_PET) },
		[4] = { 'player', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_MINE, COMBATLOG_OBJECT_TYPE_PLAYER) },
		[5] = { 'target', COMBATLOG_OBJECT_TARGET },
		[6] = { 'focus', COMBATLOG_OBJECT_FOCUS },
		[7] = { 'tank', COMBATLOG_OBJECT_MAINTANK },
		[8] = { 'assist', COMBATLOG_OBJECT_MAINASSIST },
		[9] = { 'star', COMBATLOG_OBJECT_RAIDTARGET1 },
		[10] = { 'circle', COMBATLOG_OBJECT_RAIDTARGET2 },
		[11] = { 'diamond', COMBATLOG_OBJECT_RAIDTARGET3 },
		[12] = { 'triangle', COMBATLOG_OBJECT_RAIDTARGET4 },
		[13] = { 'moon', COMBATLOG_OBJECT_RAIDTARGET5 },
		[14] = { 'square', COMBATLOG_OBJECT_RAIDTARGET6 },
		[15] = { 'cross', COMBATLOG_OBJECT_RAIDTARGET7 },
		[16] = { 'skull', COMBATLOG_OBJECT_RAIDTARGET8 },
		[17] = { 'partypet', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_PARTY, COMBATLOG_OBJECT_TYPE_PET) },
		[18] = { 'partyobject', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_PARTY, COMBATLOG_OBJECT_TYPE_OBJECT) },
		[19] = { 'partyguardian', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_PARTY, COMBATLOG_OBJECT_TYPE_GUARDIAN) },
		[20] = { 'party', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_PARTY, COMBATLOG_OBJECT_TYPE_PLAYER) },
		[21] = { 'raidpet', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_RAID, COMBATLOG_OBJECT_TYPE_PET) },
		[22] = { 'raidobject', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_RAID, COMBATLOG_OBJECT_TYPE_OBJECT) },
		[23] = { 'raidguardian', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_RAID, COMBATLOG_OBJECT_TYPE_GUARDIAN) },
		[24] = { 'raid', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_AFFILIATION_RAID, COMBATLOG_OBJECT_TYPE_PLAYER) },
		[25] = { 'friend', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_REACTION_FRIENDLY) },
		[26] = { 'enemy', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_REACTION_HOSTILE) },
		[27] = { 'neutral', bit.bor(COMBATLOG_OBJECT_CONTROL_PLAYER, COMBATLOG_OBJECT_REACTION_NEUTRAL) },
		[28] = { 'npc', COMBATLOG_OBJECT_CONTROL_NPC },
	}
	for _, objectInfo in ipairs(COMBATLOG_OBJECT) do
		local objectType, objectTypeFlags = objectInfo[1], objectInfo[2]
		if bit.band(objectFlags, objectTypeFlags) == objectTypeFlags then
			return objectType
		end
	end
	return 'unknown'
end

function CombatAlert:SetFrames()
	for frameName in pairs(self.db.profile.frames) do
		self:DestroyFeedback(frameName)
		self:CreateFeedback(frameName, self.db.profile.frames[frameName])
	end
end

function CombatAlert:SetVariables()
	_G.SHOW_COMBAT_TEXT = (self.db.profile.presetmode or self.db.profile.damage or self.db.profile.heals) and "1" or self.fctenable
	SetCVar("CombatDamage", (self.db.profile.presetmode or self.db.profile.damage) and "1" or self.fctdamage)
	SetCVar("CombatHealing", (self.db.profile.presetmode or self.db.profile.heals) and "1" or self.fcthealing)
end

function CombatAlert:SetListeners()
	self:RemoveAllHooks()
	self:RemoveAllCallbacks()
	self:RemoveAllEventListeners()
	if self.db.profile.presetmode or self.db.profile.damage or self.db.profile.heals then
		self:AddHook("CombatText_AddMessage")
	end
	if self.db.profile.frame == "feedback" then
		self:AddCallback("OnFeedbackFrameMoved")
	end
	self:AddEventListener("BAG_UPDATE_COOLDOWN", "OnCooldownUpdate")
	self:AddEventListener("SPELL_UPDATE_COOLDOWN", "OnCooldownUpdate")
	self:AddEventListener("PLAYER_REGEN_DISABLED", "OnStateEvent", "combat")
	self:AddEventListener("PLAYER_REGEN_ENABLED", "OnStateEvent", "nocombat")
	self:AddEventListener("COMBAT_LOG_EVENT_UNFILTERED", "OnCombatLogEvent")
end
