﻿--[[---------------------------------------------------------------------------
  ColaLight, an add on collecting and displaying sell values of items in 
  World of Warcraft
  
  Copyright (C) 2006  Murazorz
  
  Code from KC_Items are Copyright 2006 by Kaelten
  Code from Ludwig_SellValue are Copyright 2006 by Tuller
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  
  02110-1301, USA.
  
-------------------------------------------------------------------------------

  This is a data mining add on, collecting the sell value of items by 
  scanning the prices when a merchant frame is shown, and displaying the 
  price in the tool tip of an item.
  
  The intent and purpose of the add on is to be as lightweight and unobtrusive
  as possible, and provide a very limited set of functions.
  
  I do not appreciate others modifying and commiting to this add on the SVN 
  without my consent, except for localizations and urgent bugfixes.
  
  Any bugs, questions and requests can be posted in the 
  http://www.wowace.com/forums/index.php?topic=2351.0 thread.
-----------------------------------------------------------------------------]]

--[[
Name: ColaLight
Revision: $Revision: %%$
Author(s):  Murazorz (otnikion@gmail.com)
Website: http://www.wowace.com/forums/index.php?topic=2351.0
Documentation: http://www.wowace.com/wiki/ColaLight
Subversion: http://svn.wowace.com/wowace/trunk/ColaLight/
Issues and feature requests: http://www.wowace.com/forums/index.php?topic=2351.0
Description: An add-on for collecting and displaying the values of items in their tooltip.
Dependencies: Ace2, Abacus
]]

local abacus = AceLibrary("Abacus-2.0")
local L = AceLibrary("AceLocale-2.2"):new("ColaLight")

L:RegisterTranslations("enUS", function()
	return {
        ["ColaLight - adds value to your tool tip"] = true,
		["Purges the current databse."]			= true,
		["Set the maximum quality level of items to display the sell value for. 0 = Poor, 1 = Common, 2 = Uncommon, 3 = Rare, 4 = Epic, 5 = Legendary, 6 = Artifact."] = true,
		["Show the value in coins."]			= true,
		["Show the value of entire stacks."]	= true,
        ["Prints the size of the database."]    = true,
		["Sells for:"]							= true,
		["Sells for (stack):"]					= true,
		["Sells for (each):"]					= true,
		["Purged the database."]				= true,
        ["The database contains %d items"]      = true,
		["Choose how the price will be displayed"] = true,

		["purge"]	= true,
		["quality"]	= true,
		["style"]	= true,
		["stack"]	= true,
        ["size"]    = true,
	}
end)

L:RegisterTranslations("koKR", function()
	return {
        ["ColaLight - adds value to your tool tip"] = "ColaLight - 아이템의 툴팁에 판매가격을 표시합니다.",
		["Purges the current databse."]			= "현재 데이터베이스를 삭제합니다.",
		["Set the maximum quality level of items to display the sell value for. 0 = Poor, 1 = Common, 2 = Uncommon, 3 = Rare, 4 = Epic, 5 = Legendary, 6 = Artifact."] = "판매 가격이 보여질 아이템의 최고등급을 설정합니다. 0 = 회색, 1 = 일반, 2 = 고급, 3 = 희귀, 4 = 에픽, 5 = 전설, 6 = 유물.",
		["Show the value in coins."]			= "코인으로 가격을 표시합니다.",
		["Show the value of entire stacks."]	= "전체 묶음에 대한 가격을 표시합니다.",
		["Prints the size of the database."]    = "현재 판매 가격 데이터를 대화창에 표시합니다.",
        ["Sells for:"]							= "판매 가격:",
		["Sells for (stack):"]					= "판매 가격 (묶음):",
		["Sells for (each):"]					= "판매 가격 (개당):",
		["Purged the database."]				= "데이터 베이스가 삭제되었습니다.",
        ["The database contains %d items"]      = "판매 가격을 표시할 수 있는 아이템은 총 %d개 입니다.",
		["Choose how the price will be displayed"] = "가격을 표시할 방법을 선택하세요.",

		["purge"]	= "삭제",
		["quality"]	= "등급",
		["style"]	= "표시 방법",
		["stack"]	= "묶음 표시",
        ["size"]    = "데이터 크기",
	}
end)

L:RegisterTranslations("deDE", function()
	return {
        ["ColaLight - adds value to your tool tip"] = "ColaLight - f\195\188gt dem Tooltip die Verkaufswerte hinzu",
		["Purges the current databse."] = "Leert die aktuelle Datenbank.",
		["Set the maximum quality level of items to display the sell value for. 0 = Poor, 1 = Common, 2 = Uncommon, 3 = Rare, 4 = Epic, 5 = Legendary, 6 = Artifact."] = "Legt die maximale Qualit\195\164tsstufe der Items fest, f\195\188r die der Preis angezeigt werden soll. 0 = Schlecht, 1 = Gew\195\182hnlich, 2 = Aussergew\195\182hnlich, 3 = Selten, 4 = Episch, 5 = Legend\195\164r, 6 = Artefakt.",
		["Show the value in coins."] = "Den Wert in M\195\188nzen anzeigen.",
		["Show the value of entire stacks."] = "Den Wert des gesamten Stapels anzeigen.",
        ["Prints the size of the database."] = "Die Gr\195\182\195\159e der Datenbank anzeigen.",
		["Sells for:"] = "Verkauf f\195\188r:",
		["Sells for (stack):"] = "Verkauf f\195\188r (Stapel):",
		["Sells for (each):"] = "Verkauf f\195\188r (einzeln):",
		["Purged the database."] = "Datenbank geleert.",
        ["The database contains %d items"] = "Die Datenbank enth\195\164lt %d Gegenst\195\164nde",
		["Choose how the price will be displayed"] = "W\195\164hle wie der Preis angezeigt wird",

		["purge"]	= "bereinigung",
		["quality"]	= "qualit\195\164t",
		["style"]	= "art",
		["stack"]	= "stapel",
       	["size"]   	= "gr\195\182\195\159e",
	}
end)

L:RegisterTranslations("zhTW", function()
	return {
    ["ColaLight - adds value to your tool tip"] = "ColaLight - 在提示訊息上顯示賣出價",
		["Purges the current databse."]			= "清空現時的資料庫。",
		["Set the maximum quality level of items to display the sell value for. 0 = Poor, 1 = Common, 2 = Uncommon, 3 = Rare, 4 = Epic, 5 = Legendary, 6 = Artifact."] = "設定顯示賣出價的物品的最高品質。0 = 粗糙，1 = 普通，2 = 優秀，3 = 精良，4 = 史詩，5 = 傳說，6 = 神器。",
		["Show the value in coins."]			= "以金幣顯示售價。",
		["Show the value of entire stacks."]	= "顯示整疊售價。",
    ["Prints the size of the database."]    = "印出資料庫容量。",
		["Sells for:"]							= "售價：",
		["Sells for (stack):"]					= "總價：",
		["Sells for (each):"]					= "單價：",
		["Purged the database."]				= "資料庫已清除",
        ["The database contains %d items"]      = "資料庫內含%d個物品",
		["Choose how the price will be displayed"] = "選擇價錢顯示方式",

		["purge"]	= "清除",
		["quality"]	= "品質",
		["style"]	= "格式",
		["stack"]	= "疊",
    ["size"]    = "容量",
	}
end)

L:RegisterTranslations("zhCN", function()
	return {
    ["ColaLight - adds value to your tool tip"] = "ColaLight - 在提示信息上显示物品售价",
		["Purges the current databse."]			= "清空当前的数据库。",
		["Set the maximum quality level of items to display the sell value for. 0 = Poor, 1 = Common, 2 = Uncommon, 3 = Rare, 4 = Epic, 5 = Legendary, 6 = Artifact."] = "设置显示售价的物品的最高品质。0 = 粗糙，1 = 普通，2 = 优秀，3 = 精良，4 = 史诗，5 = 传说，6 = 神器。",
		["Show the value in coins."]			= "以金币方式显示售价。",
		["Show the value of entire stacks."]	= "显示总价。",
    ["Prints the size of the database."]    = "显示数据库容量。",
		["Sells for:"]							= "售价：",
		["Sells for (stack):"]					= "总价：",
		["Sells for (each):"]					= "单价：",
		["Purged the database."]				= "数据库已清空",
        ["The database contains %d items"]      = "当前数据库有 %d 件物品记录",
		["Choose how the price will be displayed"] = "选择价格显示的方式",

		["purge"]	= "清除",
		["quality"]	= "品质",
		["style"]	= "格式",
		["stack"]	= "堆叠",
    ["size"]    = "容量",
	}
end)

ColaLight = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1", "AceModuleCore-2.0", "AceConsole-2.0", "AceDB-2.0")

ColaLight.value = 0

ColaLight.options = {
    desc = L["ColaLight - adds value to your tool tip"],
	type = "group",
	args = {
		purge = {
			name = L["purge"], type = "execute",
			desc = L["Purges the current databse."],
			func = function(text) ColaLight:PurgeDB() end,
		},
		quality = {
			name = L["quality"], type = "range",
			desc = L["Set the maximum quality level of items to display the sell value for. 0 = Poor, 1 = Common, 2 = Uncommon, 3 = Rare, 4 = Epic, 5 = Legendary, 6 = Artifact."],
			get = function() return ColaLight.db.account.QualityLevel end,
			set = function(v) ColaLight.db.account.QualityLevel = v end,
			min = 0, max = 6, step = 1
		},
		style = {
			name = L["style"], type = "text",
			validate = {"Coins", "Extended", "Full", "Short", "Condensed",},
			desc = L["Choose how the price will be displayed"],
			get = function() return ColaLight.db.account.Style end,
			set = function(v) ColaLight.db.account.Style = v end,
		},
		stack = {
			name = L["stack"], type = "toggle",
			desc = L["Show the value of entire stacks."],
			get = function() return ColaLight.db.account.Stacks end,
			set = function(v) ColaLight.db.account.Stacks = v end,
		},
        size = {
            name = L["size"], type = "execute",
			desc = L["Prints the size of the database."],
			func = function(text) ColaLight:Size() end,
        },
	},
}

ColaLight:RegisterChatCommand({"/colalight", "/cl"}, ColaLight.options)

ColaLight:RegisterDB("ColaLightDB")
ColaLight:RegisterDefaults("account", {
	SellValues = {
        ["10000"] = 0,
        ["10001"] = 5257,
        ["10002"] = 5276,
        ["10003"] = 2859,
        ["10004"] = 5738,
        ["10005"] = 0,
        ["10007"] = 5800,
        ["10008"] = 4365,
        ["10009"] = 5284,
        ["10018"] = 3275,
        ["10019"] = 3944,
        ["10021"] = 7946,
        ["10022"] = 0,
        ["10023"] = 3334,
        ["10024"] = 5421,
        ["10025"] = 6790,
        ["10026"] = 5459,
        ["10027"] = 5479,
        ["10028"] = 5938,
        ["10029"] = 5391,
        ["10030"] = 6007,
        ["10031"] = 6030,
        ["10033"] = 6075,
        ["10034"] = 2000,
        ["10035"] = 1735,
        ["10036"] = 1741,
        ["10040"] = 1767,
        ["10041"] = 8593,
        ["10042"] = 6644,
        ["10043"] = 2033,
        ["10044"] = 6765,
        ["10045"] = 23,
        ["10046"] = 32,
        ["10047"] = 164,
        ["10048"] = 935,
        ["10050"] = 2500,
        ["10051"] = 2500,
        ["10052"] = 1500,
        ["10053"] = 4499,
        ["10054"] = 3000,
        ["10055"] = 3000,
        ["10056"] = 1500,
        ["10057"] = 12711,
        ["10058"] = 7083,
        ["10059"] = 4739,
        ["1006"] = 0,
        ["10060"] = 6668,
        ["10061"] = 7661,
        ["10062"] = 4758,
        ["10063"] = 7165,
        ["10064"] = 10775,
        ["10065"] = 12153,
        ["10066"] = 4220,
        ["10067"] = 5295,
        ["10068"] = 9128,
        ["10069"] = 5335,
        ["10070"] = 15482,
        ["10071"] = 6450,
        ["10072"] = 6177,
        ["10073"] = 9858,
        ["10074"] = 13985,
        ["10075"] = 9369,
        ["10076"] = 6571,
        ["10077"] = 16968,
        ["10078"] = 18642,
        ["10079"] = 6370,
        ["1008"] = 144,
        ["10080"] = 7319,
        ["10081"] = 7345,
        ["10082"] = 10752,
        ["10083"] = 10745,
        ["10084"] = 15246,
        ["10085"] = 11529,
        ["10086"] = 14768,
        ["10087"] = 5973,
        ["10088"] = 5551,
        ["10089"] = 8296,
        ["1009"] = 490,
        ["10090"] = 8992,
        ["10091"] = 13023,
        ["10092"] = 9785,
        ["10093"] = 18903,
        ["10094"] = 5828,
        ["10095"] = 10295,
        ["10096"] = 6130,
        ["10097"] = 10992,
        ["10098"] = 8737,
        ["10099"] = 6568,
        ["1010"] = 99,
        ["10100"] = 11109,
        ["10101"] = 15756,
        ["10102"] = 15020,
        ["10103"] = 5687,
        ["10104"] = 15137,
        ["10105"] = 19942,
        ["10106"] = 12120,
        ["10107"] = 7218,
        ["10108"] = 8203,
        ["10109"] = 7273,
        ["1011"] = 80,
        ["10110"] = 7948,
        ["10111"] = 13444,
        ["10112"] = 19071,
        ["10113"] = 13541,
        ["10118"] = 23382,
        ["10119"] = 16676,
        ["10120"] = 8797,
        ["10121"] = 10515,
        ["10122"] = 9007,
        ["10123"] = 15239,
        ["10124"] = 20396,
        ["10125"] = 14551,
        ["10126"] = 8865,
        ["10127"] = 7656,
        ["10128"] = 20838,
        ["10129"] = 8253,
        ["1013"] = 0,
        ["10130"] = 8283,
        ["10131"] = 12376,
        ["10132"] = 13289,
        ["10133"] = 18887,
        ["10134"] = 13386,
        ["10135"] = 17950,
        ["10136"] = 8530,
        ["10137"] = 13021,
        ["10138"] = 12274,
        ["10139"] = 13294,
        ["10140"] = 8773,
        ["10141"] = 18094,
        ["10142"] = 12495,
        ["10143"] = 17176,
        ["10144"] = 8164,
        ["10145"] = 9755,
        ["10146"] = 15638,
        ["10147"] = 10319,
        ["10148"] = 11273,
        ["10149"] = 10541,
        ["1015"] = 24,
        ["10150"] = 16087,
        ["10151"] = 22114,
        ["10152"] = 21901,
        ["10153"] = 16264,
        ["10154"] = 12880,
        ["10155"] = 19476,
        ["10156"] = 12794,
        ["10157"] = 26991,
        ["10158"] = 31040,
        ["10159"] = 11444,
        ["10160"] = 18599,
        ["10161"] = 12277,
        ["10162"] = 25325,
        ["10163"] = 18893,
        ["10164"] = 25915,
        ["10165"] = 10983,
        ["10166"] = 10399,
        ["10167"] = 16470,
        ["10168"] = 17523,
        ["10169"] = 24903,
        ["1017"] = 100,
        ["10170"] = 17651,
        ["10171"] = 10591,
        ["10172"] = 9603,
        ["10173"] = 5718,
        ["10174"] = 8121,
        ["10175"] = 9011,
        ["10176"] = 5689,
        ["10177"] = 12833,
        ["10178"] = 14475,
        ["10179"] = 8632,
        ["10180"] = 5141,
        ["10181"] = 14640,
        ["10182"] = 18370,
        ["10183"] = 10954,
        ["10184"] = 6523,
        ["10185"] = 7412,
        ["10186"] = 6966,
        ["10187"] = 11785,
        ["10188"] = 16717,
        ["10189"] = 11872,
        ["1019"] = 0,
        ["10190"] = 6669,
        ["10191"] = 7777,
        ["10192"] = 13212,
        ["10193"] = 19776,
        ["10194"] = 7345,
        ["10195"] = 19221,
        ["10196"] = 7593,
        ["10197"] = 7623,
        ["10198"] = 12167,
        ["10199"] = 17261,
        ["10200"] = 12314,
        ["10201"] = 10411,
        ["10202"] = 7020,
        ["10203"] = 18195,
        ["10204"] = 19888,
        ["10205"] = 7596,
        ["10206"] = 7125,
        ["10207"] = 11694,
        ["10208"] = 16777,
        ["10209"] = 12604,
        ["10210"] = 12845,
        ["10211"] = 12276,
        ["10212"] = 11069,
        ["10213"] = 7850,
        ["10214"] = 8271,
        ["10215"] = 16212,
        ["10216"] = 7180,
        ["10217"] = 16116,
        ["10218"] = 16399,
        ["10219"] = 12011,
        ["10220"] = 23263,
        ["10221"] = 9148,
        ["10222"] = 14462,
        ["10223"] = 9466,
        ["10224"] = 10755,
        ["10225"] = 10012,
        ["10226"] = 16046,
        ["10227"] = 21769,
        ["10228"] = 15940,
        ["10229"] = 10331,
        ["10230"] = 25686,
        ["10231"] = 9816,
        ["10232"] = 11732,
        ["10233"] = 11106,
        ["10234"] = 17801,
        ["10235"] = 16896,
        ["10236"] = 22616,
        ["10237"] = 16287,
        ["10238"] = 13362,
        ["10239"] = 8733,
        ["10240"] = 22009,
        ["10241"] = 14716,
        ["10242"] = 9360,
        ["10243"] = 8863,
        ["10244"] = 21069,
        ["10245"] = 14932,
        ["10246"] = 18058,
        ["10247"] = 13238,
        ["10248"] = 8737,
        ["10249"] = 12974,
        ["10250"] = 13380,
        ["10251"] = 8952,
        ["10252"] = 18207,
        ["10253"] = 13523,
        ["10254"] = 18580,
        ["10255"] = 8330,
        ["10256"] = 10309,
        ["10257"] = 15735,
        ["10258"] = 12292,
        ["10259"] = 10569,
        ["10260"] = 11945,
        ["10261"] = 16187,
        ["10262"] = 21954,
        ["10263"] = 16306,
        ["10264"] = 22406,
        ["10265"] = 12964,
        ["10266"] = 27085,
        ["10267"] = 12880,
        ["10268"] = 13978,
        ["10269"] = 13152,
        ["10270"] = 20158,
        ["10271"] = 27321,
        ["10272"] = 18780,
        ["10273"] = 25473,
        ["10274"] = 19008,
        ["10275"] = 28357,
        ["10276"] = 17200,
        ["10277"] = 12294,
        ["10278"] = 10981,
        ["10279"] = 19543,
        ["10280"] = 27515,
        ["10281"] = 19689,
        ["10282"] = 11813,
        ["10283"] = 0,
        ["10285"] = 1000,
        ["10286"] = 400,
        ["10287"] = 964,
        ["10288"] = 1410,
        ["10289"] = 1557,
        ["10290"] = 625,
        ["10298"] = 1243,
        ["10299"] = 3778,
        ["10300"] = 1250,
        ["10301"] = 1250,
        ["10302"] = 1250,
        ["10305"] = 100,
        ["10306"] = 100,
        ["10307"] = 112,
        ["10308"] = 112,
        ["10309"] = 125,
        ["10310"] = 125,
        ["10311"] = 750,
        ["10312"] = 1500,
        ["10314"] = 1000,
        ["10315"] = 1750,
        ["10316"] = 200,
        ["10317"] = 1000,
        ["10318"] = 1750,
        ["10320"] = 1750,
        ["10321"] = 1125,
        ["10323"] = 1125,
        ["10325"] = 2500,
        ["10326"] = 1250,
        ["10327"] = 0,
        ["10328"] = 6992,
        ["10329"] = 2507,
        ["10330"] = 9587,
        ["10331"] = 2729,
        ["10332"] = 3790,
        ["10333"] = 2314,
        ["10338"] = 0,
        ["10358"] = 2421,
        ["10359"] = 2430,
        ["10360"] = 1250,
        ["10361"] = 1250,
        ["10362"] = 24760,
        ["10363"] = 27396,
        ["10364"] = 24938,
        ["10365"] = 26276,
        ["10366"] = 28849,
        ["10367"] = 27639,
        ["10368"] = 29156,
        ["10369"] = 12984,
        ["10370"] = 12295,
        ["10371"] = 19474,
        ["10372"] = 20525,
        ["10373"] = 29298,
        ["10374"] = 20676,
        ["10375"] = 12525,
        ["10376"] = 21868,
        ["10377"] = 14042,
        ["10378"] = 30662,
        ["10379"] = 22418,
        ["10380"] = 14904,
        ["10381"] = 14246,
        ["10382"] = 30689,
        ["10383"] = 21121,
        ["10384"] = 29882,
        ["10385"] = 21575,
        ["10386"] = 14548,
        ["10387"] = 14405,
        ["10388"] = 22117,
        ["10389"] = 30056,
        ["10390"] = 22285,
        ["10391"] = 14420,
        ["10392"] = 1250,
        ["10393"] = 1250,
        ["10394"] = 1250,
        ["10398"] = 1000,
        ["10399"] = 1467,
        ["10400"] = 563,
        ["10401"] = 255,
        ["10402"] = 385,
        ["10403"] = 451,
        ["10404"] = 864,
        ["10405"] = 409,
        ["10406"] = 1976,
        ["10407"] = 432,
        ["10408"] = 2390,
        ["10409"] = 2409,
        ["10410"] = 1256,
        ["10411"] = 788,
        ["10412"] = 405,
        ["10413"] = 307,
        ["10414"] = 0,
        ["10418"] = 16464,
        ["10420"] = 0,
        ["10421"] = 32,
        ["10423"] = 2842,
        ["10424"] = 750,
        ["10438"] = 0,
        ["10439"] = 0,
        ["10440"] = 0,
        ["10441"] = 0,
        ["10442"] = 0,
        ["10443"] = 0,
        ["10444"] = 0,
        ["10445"] = 0,
        ["10446"] = 0,
        ["10447"] = 0,
        ["10450"] = 396,
        ["10454"] = 0,
        ["10455"] = 6464,
        ["10456"] = 0,
        ["10457"] = 142,
        ["10458"] = 0,
        ["10459"] = 0,
        ["10460"] = 629,
        ["10461"] = 3082,
        ["10462"] = 3609,
        ["10463"] = 1750,
        ["10465"] = 0,
        ["10466"] = 0,
        ["10467"] = 0,
        ["10479"] = 24,
        ["10498"] = 16,
        ["10499"] = 2105,
        ["10500"] = 3478,
        ["10501"] = 4398,
        ["10502"] = 4088,
        ["10503"] = 5169,
        ["10504"] = 7770,
        ["10505"] = 250,
        ["10506"] = 5227,
        ["10507"] = 350,
        ["10508"] = 8959,
        ["10509"] = 0,
        ["10510"] = 11369,
        ["10511"] = 0,
        ["10512"] = 2,
        ["10513"] = 5,
        ["10514"] = 750,
        ["10515"] = 0,
        ["10518"] = 4696,
        ["10538"] = 0,
        ["10539"] = 0,
        ["10540"] = 0,
        ["10541"] = 0,
        ["10542"] = 5255,
        ["10543"] = 3517,
        ["10544"] = 15,
        ["10545"] = 3929,
        ["10546"] = 1500,
        ["10547"] = 74,
        ["10548"] = 2500,
        ["10549"] = 162,
        ["10550"] = 48,
        ["10551"] = 0,
        ["10552"] = 0,
        ["10553"] = 131,
        ["10554"] = 105,
        ["10556"] = 0,
        ["10558"] = 250,
        ["10559"] = 750,
        ["10560"] = 1000,
        ["10561"] = 1000,
        ["10562"] = 750,
        ["10563"] = 0,
        ["10564"] = 0,
        ["10565"] = 0,
        ["10566"] = 0,
        ["10567"] = 8725,
        ["10569"] = 0,
        ["10570"] = 15875,
        ["10571"] = 10927,
        ["10572"] = 9592,
        ["10573"] = 13754,
        ["10574"] = 3775,
        ["10575"] = 0,
        ["10576"] = 6000,
        ["10577"] = 2000,
        ["10578"] = 3377,
        ["10581"] = 5310,
        ["10582"] = 3606,
        ["10583"] = 6191,
        ["10584"] = 2905,
        ["10586"] = 750,
        ["10587"] = 1500,
        ["10588"] = 5834,
        ["10589"] = 0,
        ["10592"] = 150,
        ["10593"] = 0,
        ["10597"] = 0,
        ["10598"] = 0,
        ["10599"] = 0,
        ["10600"] = 0,
        ["10601"] = 500,
        ["10602"] = 750,
        ["10603"] = 825,
        ["10604"] = 825,
        ["10605"] = 875,
        ["10606"] = 875,
        ["10607"] = 900,
        ["10608"] = 950,
        ["10609"] = 1000,
        ["10610"] = 0,
        ["10620"] = 250,
        ["10621"] = 0,
        ["10622"] = 0,
        ["10623"] = 24748,
        ["10624"] = 17249,
        ["10625"] = 27366,
        ["10626"] = 36732,
        ["10627"] = 26974,
        ["10628"] = 29245,
        ["10629"] = 8066,
        ["10630"] = 8664,
        ["10631"] = 6086,
        ["10632"] = 7624,
        ["10633"] = 20447,
        ["10634"] = 10812,
        ["10635"] = 14,
        ["10636"] = 6,
        ["10637"] = 139,
        ["10638"] = 210,
        ["10639"] = 0,
        ["10640"] = 0,
        ["10641"] = 0,
        ["10642"] = 0,
        ["10643"] = 0,
        ["10644"] = 500,
        ["10645"] = 750,
        ["10646"] = 500,
        ["10647"] = 500,
        ["10648"] = 125,
        ["10649"] = 0,
        ["10652"] = 30308,
        ["10653"] = 1639,
        ["10654"] = 965,
        ["10655"] = 9,
        ["10656"] = 14,
        ["10657"] = 933,
        ["10658"] = 1249,
        ["10659"] = 4662,
        ["10660"] = 0,
        ["10661"] = 0,
        ["10662"] = 0,
        ["10663"] = 0,
        ["10678"] = 0,
        ["10679"] = 0,
        ["10680"] = 0,
        ["10681"] = 0,
        ["10682"] = 0,
        ["10684"] = 500,
        ["10686"] = 21163,
        ["10687"] = 0,
        ["10688"] = 0,
        ["10689"] = 0,
        ["10690"] = 0,
        ["10691"] = 0,
        ["10692"] = 0,
        ["10693"] = 0,
        ["10694"] = 0,
        ["10695"] = 0,
        ["10696"] = 39766,
        ["10697"] = 42044,
        ["10698"] = 52747,
        ["10699"] = 0,
        ["10700"] = 4983,
        ["10701"] = 7536,
        ["10702"] = 5379,
        ["10703"] = 16792,
        ["10704"] = 13649,
        ["10705"] = 3666,
        ["10706"] = 5521,
        ["10707"] = 13576,
        ["10708"] = 8982,
        ["10709"] = 10953,
        ["10710"] = 6130,
        ["10711"] = 8377,
        ["10712"] = 0,
        ["10713"] = 500,
        ["10714"] = 0,
        ["10715"] = 0,
        ["10716"] = 750,
        ["10717"] = 0,
        ["10718"] = 0,
        ["10720"] = 750,
        ["10721"] = 3317,
        ["10722"] = 0,
        ["10724"] = 4697,
        ["10725"] = 1500,
        ["10726"] = 5520,
        ["10727"] = 2000,
        ["10728"] = 375,
        ["10738"] = 0,
        ["10739"] = 5292,
        ["1074"] = 491,
        ["10740"] = 18712,
        ["10741"] = 10063,
        ["10742"] = 9589,
        ["10743"] = 10830,
        ["10744"] = 24159,
        ["10745"] = 8498,
        ["10746"] = 8007,
        ["10747"] = 2327,
        ["10748"] = 4380,
        ["10749"] = 18436,
        ["1075"] = 0,
        ["10750"] = 35315,
        ["10751"] = 10634,
        ["10752"] = 0,
        ["10753"] = 0,
        ["10754"] = 0,
        ["10755"] = 0,
        ["10757"] = 0,
        ["10758"] = 20144,
        ["10759"] = 0,
        ["1076"] = 650,
        ["10760"] = 2428,
        ["10761"] = 17193,
        ["10762"] = 6903,
        ["10763"] = 9079,
        ["10764"] = 10434,
        ["10765"] = 3367,
        ["10766"] = 9660,
        ["10767"] = 9652,
        ["10768"] = 4541,
        ["10769"] = 5277,
        ["1077"] = 25,
        ["10770"] = 7835,
        ["10771"] = 2910,
        ["10772"] = 12170,
        ["10773"] = 0,
        ["10774"] = 5957,
        ["10775"] = 11161,
        ["10776"] = 4800,
        ["10777"] = 4014,
        ["10778"] = 16930,
        ["10779"] = 8807,
        ["10780"] = 5542,
        ["10781"] = 15072,
        ["10782"] = 4539,
        ["10783"] = 11476,
        ["10784"] = 18432,
        ["10785"] = 13200,
        ["10786"] = 11977,
        ["10787"] = 6382,
        ["10788"] = 9396,
        ["10789"] = 0,
        ["10790"] = 0,
        ["10791"] = 0,
        ["10792"] = 0,
        ["10794"] = 0,
        ["10795"] = 5542,
        ["10796"] = 8982,
        ["10797"] = 35069,
        ["10798"] = 11024,
        ["10799"] = 39288,
        ["1080"] = 78,
        ["10800"] = 7562,
        ["10801"] = 11704,
        ["10802"] = 7831,
        ["10803"] = 29441,
        ["10804"] = 29551,
        ["10805"] = 29661,
        ["10806"] = 15146,
        ["10807"] = 15202,
        ["10808"] = 7629,
        ["1081"] = 50,
        ["10818"] = 0,
        ["10819"] = 0,
        ["1082"] = 150,
        ["10820"] = 138,
        ["10821"] = 208,
        ["10822"] = 2500,
        ["10823"] = 17796,
        ["10824"] = 5930,
        ["10826"] = 25501,
        ["10827"] = 10238,
        ["10828"] = 40427,
        ["10829"] = 10680,
        ["1083"] = 0,
        ["10830"] = 750,
        ["10831"] = 0,
        ["10832"] = 0,
        ["10833"] = 8597,
        ["10835"] = 24645,
        ["10836"] = 28989,
        ["10837"] = 38801,
        ["10838"] = 34665,
        ["10839"] = 0,
        ["10840"] = 0,
        ["10841"] = 85,
        ["10842"] = 17595,
        ["10843"] = 10595,
        ["10844"] = 44314,
        ["10845"] = 24908,
        ["10846"] = 16143,
        ["10847"] = 56921,
        ["10858"] = 750,
        ["10918"] = 42,
        ["10919"] = 215,
        ["10920"] = 67,
        ["10921"] = 125,
        ["10922"] = 175,
        ["10938"] = 0,
        ["10939"] = 0,
        ["10940"] = 0,
        ["10958"] = 0,
        ["10959"] = 8750,
        ["10978"] = 0,
        ["10998"] = 0,
        ["10999"] = 0,
        ["11000"] = 0,
        ["11018"] = 146,
        ["11020"] = 0,
        ["11022"] = 250,
        ["11023"] = 2500,
        ["11024"] = 0,
        ["11026"] = 2500,
        ["11027"] = 2500,
        ["11038"] = 200,
        ["11039"] = 200,
        ["11040"] = 1,
        ["11078"] = 0,
        ["11079"] = 0,
        ["11080"] = 0,
        ["11081"] = 200,
        ["11082"] = 0,
        ["11083"] = 0,
        ["11084"] = 0,
        ["11086"] = 27403,
        ["11098"] = 500,
        ["11101"] = 625,
        ["11102"] = 0,
        ["11103"] = 0,
        ["11104"] = 0,
        ["11105"] = 0,
        ["11106"] = 0,
        ["11107"] = 0,
        ["11108"] = 0,
        ["11109"] = 6,
        ["11110"] = 2,
        ["11112"] = 0,
        ["11113"] = 0,
        ["11114"] = 0,
        ["11116"] = 0,
        ["11118"] = 10795,
        ["11119"] = 0,
        ["11120"] = 30144,
        ["11121"] = 2941,
        ["11122"] = 7162,
        ["11123"] = 15037,
        ["11124"] = 16980,
        ["11125"] = 0,
        ["11126"] = 0,
        ["11127"] = 0,
        ["11128"] = 500,
        ["1113"] = 0,
        ["11130"] = 500,
        ["11131"] = 0,
        ["11132"] = 0,
        ["11133"] = 0,
        ["11134"] = 0,
        ["11135"] = 0,
        ["11136"] = 0,
        ["11137"] = 0,
        ["11138"] = 0,
        ["11139"] = 0,
        ["1114"] = 0,
        ["11140"] = 0,
        ["11141"] = 0,
        ["11142"] = 0,
        ["11143"] = 0,
        ["11144"] = 1000,
        ["11145"] = 1250,
        ["11146"] = 0,
        ["11147"] = 0,
        ["11148"] = 0,
        ["11149"] = 0,
        ["11150"] = 750,
        ["11151"] = 750,
        ["11152"] = 750,
        ["1116"] = 1250,
        ["11162"] = 0,
        ["11163"] = 750,
        ["11164"] = 750,
        ["11165"] = 750,
        ["11166"] = 1000,
        ["11167"] = 1000,
        ["11168"] = 1000,
        ["11169"] = 0,
        ["11172"] = 0,
        ["11173"] = 0,
        ["11174"] = 0,
        ["11175"] = 0,
        ["11176"] = 0,
        ["11177"] = 0,
        ["11178"] = 0,
        ["11179"] = 0,
        ["11184"] = 0,
        ["11185"] = 0,
        ["11186"] = 0,
        ["11187"] = 5,
        ["11188"] = 0,
        ["11189"] = 10,
        ["11190"] = 5,
        ["11191"] = 45,
        ["11192"] = 4,
        ["11193"] = 16938,
        ["11194"] = 20405,
        ["11195"] = 23897,
        ["11196"] = 16875,
        ["11197"] = 0,
        ["11202"] = 1100,
        ["11203"] = 1100,
        ["11204"] = 1100,
        ["11205"] = 1250,
        ["11206"] = 1250,
        ["11207"] = 3000,
        ["11208"] = 1350,
        ["1121"] = 1075,
        ["11223"] = 1450,
        ["11224"] = 1450,
        ["11225"] = 1550,
        ["11226"] = 1550,
        ["11227"] = 0,
        ["11229"] = 1696,
        ["11230"] = 0,
        ["11231"] = 0,
        ["11242"] = 0,
        ["11243"] = 0,
        ["11262"] = 8142,
        ["11263"] = 10103,
        ["11265"] = 16485,
        ["11268"] = 0,
        ["11269"] = 0,
        ["1127"] = 25,
        ["11270"] = 0,
        ["11282"] = 0,
        ["11284"] = 1,
        ["11285"] = 2,
        ["11286"] = 0,
        ["11287"] = 508,
        ["11288"] = 1535,
        ["11289"] = 3581,
        ["1129"] = 0,
        ["11290"] = 5263,
        ["11291"] = 1125,
        ["1130"] = 0,
        ["11302"] = 7130,
        ["11303"] = 637,
        ["11304"] = 972,
        ["11305"] = 5162,
        ["11306"] = 3893,
        ["11307"] = 13590,
        ["11308"] = 15765,
        ["11309"] = 0,
        ["1131"] = 1136,
        ["11310"] = 6598,
        ["11311"] = 5110,
        ["11312"] = 0,
        ["11313"] = 0,
        ["11315"] = 0,
        ["11316"] = 0,
        ["11318"] = 0,
        ["11319"] = 0,
        ["1132"] = 0,
        ["11320"] = 0,
        ["11324"] = 6250,
        ["11325"] = 150,
        ["11362"] = 250,
        ["11366"] = 0,
        ["11367"] = 0,
        ["11368"] = 0,
        ["11370"] = 500,
        ["11371"] = 600,
        ["11382"] = 750,
        ["11384"] = 70,
        ["11385"] = 145,
        ["11386"] = 676,
        ["11387"] = 1013,
        ["11388"] = 1563,
        ["11389"] = 2163,
        ["11390"] = 80,
        ["11391"] = 205,
        ["11392"] = 403,
        ["11393"] = 780,
        ["11394"] = 580,
        ["11395"] = 830,
        ["11402"] = 1205,
        ["11403"] = 1592,
        ["11404"] = 2080,
        ["11405"] = 0,
        ["11406"] = 168,
        ["11407"] = 108,
        ["11408"] = 898,
        ["11409"] = 503,
        ["11410"] = 578,
        ["11411"] = 1484,
        ["11412"] = 0,
        ["11413"] = 0,
        ["11414"] = 1828,
        ["11415"] = 200,
        ["11416"] = 328,
        ["11417"] = 1204,
        ["11418"] = 604,
        ["11419"] = 1900,
        ["11420"] = 1712,
        ["11422"] = 0,
        ["11423"] = 0,
        ["11444"] = 200,
        ["11445"] = 0,
        ["11446"] = 0,
        ["11462"] = 0,
        ["11463"] = 0,
        ["11464"] = 0,
        ["11465"] = 0,
        ["11466"] = 0,
        ["11467"] = 0,
        ["11468"] = 0,
        ["11469"] = 3563,
        ["11470"] = 0,
        ["11471"] = 0,
        ["11472"] = 0,
        ["11474"] = 500,
        ["11475"] = 7,
        ["11476"] = 0,
        ["11477"] = 0,
        ["11478"] = 0,
        ["11479"] = 0,
        ["11480"] = 0,
        ["11482"] = 0,
        ["11502"] = 6510,
        ["11503"] = 0,
        ["11504"] = 0,
        ["11509"] = 0,
        ["11510"] = 0,
        ["11511"] = 0,
        ["11512"] = 0,
        ["11513"] = 1,
        ["11514"] = 1,
        ["11515"] = 1,
        ["11516"] = 0,
        ["11522"] = 0,
        ["1154"] = 102,
        ["1155"] = 5954,
        ["1156"] = 812,
        ["11562"] = 1000,
        ["11563"] = 1000,
        ["11564"] = 1000,
        ["11565"] = 1000,
        ["11566"] = 1000,
        ["11567"] = 1000,
        ["11568"] = 0,
        ["11569"] = 0,
        ["11570"] = 0,
        ["1158"] = 146,
        ["11582"] = 0,
        ["11583"] = 0,
        ["11584"] = 1,
        ["1159"] = 32,
        ["11590"] = 250,
        ["11602"] = 0,
        ["11603"] = 30656,
        ["11604"] = 34000,
        ["11605"] = 18822,
        ["11606"] = 19256,
        ["11607"] = 51225,
        ["11608"] = 45760,
        ["1161"] = 25,
        ["11610"] = 3000,
        ["11611"] = 3000,
        ["11612"] = 3000,
        ["11614"] = 3000,
        ["11615"] = 3000,
        ["11617"] = 0,
        ["11622"] = 0,
        ["11623"] = 9999,
        ["11624"] = 9079,
        ["11625"] = 10452,
        ["11626"] = 9698,
        ["11627"] = 14668,
        ["11628"] = 24433,
        ["11629"] = 24527,
        ["11630"] = 5,
        ["11631"] = 19893,
        ["11632"] = 16349,
        ["11633"] = 24633,
        ["11634"] = 7063,
        ["11635"] = 35451,
        ["11642"] = 0,
        ["11643"] = 0,
        ["11644"] = 0,
        ["11647"] = 0,
        ["11662"] = 7462,
        ["11665"] = 8532,
        ["11668"] = 0,
        ["11669"] = 17157,
        ["11674"] = 0,
        ["11675"] = 14464,
        ["11677"] = 11655,
        ["11678"] = 27293,
        ["11679"] = 11738,
        ["1168"] = 42296,
        ["11682"] = 0,
        ["11684"] = 63086,
        ["11685"] = 13941,
        ["11686"] = 9329,
        ["1169"] = 18815,
        ["117"] = 1,
        ["11702"] = 36752,
        ["11703"] = 12986,
        ["1171"] = 55,
        ["1172"] = 968,
        ["11722"] = 16610,
        ["11723"] = 0,
        ["11724"] = 0,
        ["11725"] = 0,
        ["11726"] = 33533,
        ["11727"] = 0,
        ["11728"] = 25336,
        ["11729"] = 19073,
        ["1173"] = 52,
        ["11730"] = 12762,
        ["11731"] = 19300,
        ["11732"] = 0,
        ["11733"] = 0,
        ["11734"] = 0,
        ["11735"] = 16670,
        ["11736"] = 0,
        ["11737"] = 0,
        ["11742"] = 8750,
        ["11743"] = 30734,
        ["11744"] = 39242,
        ["11745"] = 13865,
        ["11746"] = 20718,
        ["11747"] = 16659,
        ["11748"] = 25083,
        ["11749"] = 20141,
        ["1175"] = 28,
        ["11750"] = 43234,
        ["11751"] = 0,
        ["11752"] = 0,
        ["11753"] = 0,
        ["11754"] = 0,
        ["11755"] = 14627,
        ["11764"] = 10398,
        ["11765"] = 12525,
        ["11766"] = 8606,
        ["11767"] = 15202,
        ["11768"] = 7224,
        ["1177"] = 3,
        ["1178"] = 7,
        ["11782"] = 12720,
        ["11783"] = 12767,
        ["11784"] = 33835,
        ["11785"] = 29083,
        ["11786"] = 50740,
        ["11787"] = 23986,
        ["1179"] = 6,
        ["118"] = 5,
        ["1180"] = 37,
        ["11802"] = 31459,
        ["11803"] = 50177,
        ["11805"] = 40439,
        ["11807"] = 9153,
        ["11808"] = 19292,
        ["11809"] = 51287,
        ["1181"] = 25,
        ["11810"] = 10000,
        ["11811"] = 1500,
        ["11812"] = 13979,
        ["11813"] = 3000,
        ["11814"] = 13083,
        ["11815"] = 10000,
        ["11816"] = 48882,
        ["11817"] = 39254,
        ["11818"] = 0,
        ["11819"] = 10000,
        ["1182"] = 44,
        ["11820"] = 26761,
        ["11821"] = 22385,
        ["11822"] = 14153,
        ["11823"] = 23677,
        ["11824"] = 13657,
        ["11825"] = 2500,
        ["11826"] = 2500,
        ["11827"] = 675,
        ["11828"] = 675,
        ["11829"] = 0,
        ["1183"] = 29,
        ["11830"] = 0,
        ["11831"] = 0,
        ["11832"] = 10000,
        ["11833"] = 0,
        ["11834"] = 0,
        ["11835"] = 0,
        ["11837"] = 0,
        ["11839"] = 11191,
        ["11840"] = 7137,
        ["11841"] = 15032,
        ["11842"] = 17050,
        ["11843"] = 0,
        ["11844"] = 0,
        ["11845"] = 62,
        ["11846"] = 30,
        ["11847"] = 7,
        ["11848"] = 5,
        ["11849"] = 7,
        ["11850"] = 7,
        ["11851"] = 12,
        ["11852"] = 14,
        ["11853"] = 388,
        ["11854"] = 1494,
        ["11855"] = 782,
        ["11856"] = 15775,
        ["11857"] = 21377,
        ["11858"] = 4768,
        ["11859"] = 7135,
        ["11860"] = 12971,
        ["11861"] = 5207,
        ["11862"] = 7042,
        ["11863"] = 27191,
        ["11864"] = 34108,
        ["11865"] = 8708,
        ["11866"] = 9819,
        ["11867"] = 8769,
        ["11868"] = 6542,
        ["11869"] = 6542,
        ["1187"] = 1081,
        ["11870"] = 10287,
        ["11871"] = 10666,
        ["11872"] = 14962,
        ["11873"] = 9662,
        ["11874"] = 12124,
        ["11875"] = 5776,
        ["11876"] = 16287,
        ["11882"] = 20520,
        ["11883"] = 0,
        ["11884"] = 1846,
        ["11885"] = 711,
        ["11887"] = 12,
        ["11888"] = 4879,
        ["11889"] = 12830,
        ["11902"] = 34194,
        ["11904"] = 13815,
        ["11905"] = 6203,
        ["11906"] = 32723,
        ["11907"] = 41050,
        ["11908"] = 9887,
        ["11909"] = 8267,
        ["1191"] = 82,
        ["11910"] = 21604,
        ["11911"] = 12392,
        ["11912"] = 0,
        ["11913"] = 14045,
        ["11914"] = 0,
        ["11915"] = 20124,
        ["11916"] = 11834,
        ["11917"] = 6335,
        ["11918"] = 9537,
        ["11919"] = 16720,
        ["11920"] = 40732,
        ["11921"] = 54167,
        ["11922"] = 43491,
        ["11923"] = 43649,
        ["11924"] = 20475,
        ["11925"] = 16484,
        ["11926"] = 24590,
        ["11927"] = 28799,
        ["11928"] = 22045,
        ["11929"] = 16581,
        ["11930"] = 14588,
        ["11931"] = 58103,
        ["11932"] = 58322,
        ["11933"] = 19646,
        ["11934"] = 19921,
        ["11935"] = 13162,
        ["11936"] = 284,
        ["11937"] = 187,
        ["11938"] = 213,
        ["11939"] = 671,
        ["1194"] = 20,
        ["11940"] = 389,
        ["11941"] = 5896,
        ["11942"] = 5303,
        ["11943"] = 21485,
        ["11944"] = 8821,
        ["11945"] = 6592,
        ["11946"] = 7912,
        ["11947"] = 0,
        ["11948"] = 0,
        ["11949"] = 0,
        ["1195"] = 47,
        ["11950"] = 0,
        ["11951"] = 0,
        ["11952"] = 0,
        ["11953"] = 0,
        ["11954"] = 0,
        ["11955"] = 0,
        ["1196"] = 442,
        ["11962"] = 7939,
        ["11963"] = 10025,
        ["11964"] = 30156,
        ["11965"] = 464,
        ["11966"] = 164,
        ["11967"] = 1087,
        ["11968"] = 997,
        ["11969"] = 1721,
        ["1197"] = 533,
        ["11970"] = 1710,
        ["11971"] = 3969,
        ["11972"] = 4649,
        ["11973"] = 3971,
        ["11974"] = 4971,
        ["11975"] = 4739,
        ["11976"] = 7778,
        ["11977"] = 7896,
        ["11978"] = 7414,
        ["11979"] = 7471,
        ["1198"] = 535,
        ["11980"] = 10539,
        ["11981"] = 496,
        ["11982"] = 1062,
        ["11983"] = 1130,
        ["11984"] = 2189,
        ["11985"] = 2144,
        ["11986"] = 1745,
        ["11987"] = 2885,
        ["11988"] = 7113,
        ["11989"] = 7471,
        ["11990"] = 8306,
        ["11991"] = 6317,
        ["11992"] = 7396,
        ["11993"] = 874,
        ["11994"] = 1312,
        ["11995"] = 914,
        ["11996"] = 1713,
        ["11997"] = 6469,
        ["11998"] = 2896,
        ["11999"] = 5538,
        ["120"] = 1,
        ["1200"] = 16,
        ["12000"] = 41054,
        ["12001"] = 4971,
        ["12002"] = 6322,
        ["12003"] = 250,
        ["12004"] = 9163,
        ["12005"] = 8813,
        ["12006"] = 1064,
        ["12007"] = 1064,
        ["12008"] = 895,
        ["12009"] = 2174,
        ["1201"] = 94,
        ["12010"] = 2469,
        ["12011"] = 4649,
        ["12012"] = 2463,
        ["12013"] = 4649,
        ["12014"] = 6289,
        ["12015"] = 8811,
        ["12016"] = 7781,
        ["12017"] = 8963,
        ["12018"] = 13842,
        ["12019"] = 4220,
        ["1202"] = 367,
        ["12020"] = 3969,
        ["12021"] = 16291,
        ["12022"] = 4718,
        ["12023"] = 4971,
        ["12024"] = 5396,
        ["12025"] = 5282,
        ["12026"] = 7757,
        ["12027"] = 6257,
        ["12028"] = 4007,
        ["12029"] = 5395,
        ["1203"] = 23505,
        ["12030"] = 7143,
        ["12031"] = 7894,
        ["12032"] = 5396,
        ["12033"] = 0,
        ["12034"] = 5012,
        ["12035"] = 5513,
        ["12036"] = 5982,
        ["12037"] = 87,
        ["12038"] = 9092,
        ["12039"] = 4224,
        ["1204"] = 12577,
        ["12040"] = 4164,
        ["12041"] = 14446,
        ["12042"] = 4749,
        ["12043"] = 5396,
        ["12044"] = 5145,
        ["12045"] = 7767,
        ["12046"] = 5757,
        ["12047"] = 4996,
        ["12048"] = 6507,
        ["12049"] = 16850,
        ["1205"] = 25,
        ["12050"] = 8963,
        ["12051"] = 8996,
        ["12052"] = 837,
        ["12053"] = 837,
        ["12054"] = 837,
        ["12055"] = 8375,
        ["12056"] = 8375,
        ["12057"] = 8375,
        ["12058"] = 8376,
        ["12059"] = 12377,
        ["1206"] = 400,
        ["12060"] = 0,
        ["12061"] = 40212,
        ["12062"] = 40365,
        ["12065"] = 7953,
        ["12066"] = 11149,
        ["1207"] = 9892,
        ["1208"] = 0,
        ["12082"] = 13726,
        ["12083"] = 7348,
        ["121"] = 1,
        ["1210"] = 250,
        ["12102"] = 9042,
        ["12103"] = 12157,
        ["12108"] = 23055,
        ["12109"] = 11569,
        ["1211"] = 347,
        ["12110"] = 11610,
        ["12111"] = 13672,
        ["12112"] = 10407,
        ["12113"] = 10444,
        ["12114"] = 8734,
        ["12115"] = 12341,
        ["1212"] = 21,
        ["12122"] = 0,
        ["1213"] = 87,
        ["1214"] = 930,
        ["12144"] = 0,
        ["1215"] = 469,
        ["12162"] = 750,
        ["12163"] = 1100,
        ["12164"] = 1100,
        ["1217"] = 0,
        ["1218"] = 2064,
        ["12184"] = 87,
        ["12185"] = 12895,
        ["1219"] = 823,
        ["12190"] = 250,
        ["12191"] = 0,
        ["12192"] = 0,
        ["1220"] = 1807,
        ["12202"] = 87,
        ["12203"] = 87,
        ["12204"] = 112,
        ["12205"] = 112,
        ["12206"] = 112,
        ["12207"] = 150,
        ["12208"] = 150,
        ["12209"] = 95,
        ["1221"] = 0,
        ["12210"] = 300,
        ["12212"] = 300,
        ["12213"] = 300,
        ["12214"] = 300,
        ["12215"] = 300,
        ["12216"] = 300,
        ["12217"] = 300,
        ["12218"] = 300,
        ["12219"] = 0,
        ["12220"] = 0,
        ["12223"] = 4,
        ["12224"] = 10,
        ["12225"] = 188,
        ["12226"] = 6,
        ["12227"] = 400,
        ["12228"] = 1250,
        ["12229"] = 1250,
        ["12231"] = 750,
        ["12232"] = 1250,
        ["12233"] = 750,
        ["12234"] = 0,
        ["12235"] = 0,
        ["12237"] = 0,
        ["12238"] = 2,
        ["12239"] = 1750,
        ["12240"] = 1750,
        ["12241"] = 0,
        ["12242"] = 0,
        ["12243"] = 45980,
        ["12247"] = 5674,
        ["12248"] = 6406,
        ["12249"] = 6039,
        ["12250"] = 8068,
        ["12251"] = 10779,
        ["12252"] = 12619,
        ["12253"] = 3545,
        ["12254"] = 4483,
        ["12255"] = 6997,
        ["12256"] = 8765,
        ["12257"] = 3886,
        ["12259"] = 8072,
        ["12260"] = 10395,
        ["12261"] = 950,
        ["12262"] = 0,
        ["12263"] = 0,
        ["12264"] = 1500,
        ["12282"] = 8,
        ["12283"] = 0,
        ["12284"] = 0,
        ["12286"] = 0,
        ["12287"] = 0,
        ["12289"] = 0,
        ["12292"] = 0,
        ["12293"] = 0,
        ["12295"] = 282,
        ["12296"] = 722,
        ["12299"] = 16,
        ["12300"] = 0,
        ["12301"] = 0,
        ["12323"] = 0,
        ["12324"] = 0,
        ["12330"] = 0,
        ["12334"] = 0,
        ["12335"] = 0,
        ["12336"] = 0,
        ["12337"] = 0,
        ["12339"] = 0,
        ["12341"] = 0,
        ["12342"] = 0,
        ["12343"] = 0,
        ["12344"] = 0,
        ["12345"] = 0,
        ["12346"] = 0,
        ["12347"] = 0,
        ["12349"] = 0,
        ["12350"] = 0,
        ["12351"] = 0,
        ["12352"] = 0,
        ["12353"] = 0,
        ["12355"] = 0,
        ["12356"] = 0,
        ["12358"] = 0,
        ["12359"] = 600,
        ["12360"] = 5000,
        ["12361"] = 7000,
        ["12363"] = 2000,
        ["12364"] = 10000,
        ["12365"] = 250,
        ["12366"] = 0,
        ["12367"] = 0,
        ["12368"] = 0,
        ["12382"] = 0,
        ["12383"] = 0,
        ["12384"] = 0,
        ["12402"] = 0,
        ["12404"] = 75,
        ["12405"] = 16170,
        ["12406"] = 8160,
        ["12408"] = 8797,
        ["12409"] = 18054,
        ["12410"] = 18117,
        ["12411"] = 0,
        ["12412"] = 0,
        ["12414"] = 30408,
        ["12415"] = 17003,
        ["12416"] = 7596,
        ["12417"] = 17034,
        ["12418"] = 10242,
        ["12419"] = 16421,
        ["12420"] = 24462,
        ["12422"] = 28357,
        ["12424"] = 9738,
        ["12425"] = 10638,
        ["12426"] = 21069,
        ["12427"] = 21145,
        ["12428"] = 15103,
        ["12429"] = 30289,
        ["12430"] = 0,
        ["12431"] = 0,
        ["12432"] = 0,
        ["12433"] = 0,
        ["12434"] = 0,
        ["12435"] = 0,
        ["12436"] = 0,
        ["12437"] = 0,
        ["12438"] = 0,
        ["12444"] = 0,
        ["12445"] = 0,
        ["12446"] = 17,
        ["12447"] = 10,
        ["12448"] = 19,
        ["12449"] = 19,
        ["12450"] = 1500,
        ["12451"] = 1500,
        ["12455"] = 1500,
        ["12457"] = 1500,
        ["12458"] = 1500,
        ["12459"] = 1500,
        ["12460"] = 1500,
        ["12462"] = 20274,
        ["12463"] = 42446,
        ["12464"] = 8520,
        ["12465"] = 10261,
        ["12466"] = 6865,
        ["12467"] = 0,
        ["12470"] = 8784,
        ["12471"] = 8409,
        ["12472"] = 0,
        ["1251"] = 10,
        ["1252"] = 0,
        ["12522"] = 182,
        ["12524"] = 0,
        ["12525"] = 0,
        ["12527"] = 35332,
        ["12528"] = 37833,
        ["12529"] = 1500,
        ["12530"] = 0,
        ["12531"] = 28883,
        ["12532"] = 48501,
        ["12533"] = 0,
        ["12534"] = 0,
        ["12535"] = 34926,
        ["1254"] = 0,
        ["12542"] = 12356,
        ["12543"] = 7156,
        ["12544"] = 7407,
        ["12545"] = 7082,
        ["12546"] = 7463,
        ["12547"] = 10519,
        ["12548"] = 7102,
        ["12549"] = 13670,
        ["12550"] = 11378,
        ["12551"] = 11594,
        ["12552"] = 10980,
        ["12553"] = 17699,
        ["12554"] = 9474,
        ["12555"] = 19923,
        ["12556"] = 14317,
        ["12557"] = 25096,
        ["1256"] = 0,
        ["12562"] = 0,
        ["12563"] = 0,
        ["12564"] = 0,
        ["12565"] = 0,
        ["12566"] = 0,
        ["12567"] = 0,
        ["1257"] = 0,
        ["12582"] = 51199,
        ["12583"] = 66915,
        ["12584"] = 49636,
        ["12586"] = 0,
        ["12587"] = 18929,
        ["12588"] = 25446,
        ["12589"] = 9899,
        ["12590"] = 68066,
        ["12592"] = 85722,
        ["1260"] = 0,
        ["12602"] = 31693,
        ["12603"] = 24189,
        ["12604"] = 14368,
        ["12605"] = 29106,
        ["12606"] = 12233,
        ["12607"] = 8048,
        ["12608"] = 13232,
        ["12609"] = 19795,
        ["1261"] = 0,
        ["12610"] = 21392,
        ["12612"] = 21854,
        ["12613"] = 31859,
        ["12614"] = 31977,
        ["12618"] = 37759,
        ["12619"] = 37893,
        ["1262"] = 111,
        ["12620"] = 28084,
        ["12621"] = 45085,
        ["12622"] = 0,
        ["12623"] = 0,
        ["12624"] = 20642,
        ["12626"] = 9191,
        ["12627"] = 0,
        ["12628"] = 16212,
        ["1263"] = 79064,
        ["12630"] = 0,
        ["12631"] = 15698,
        ["12632"] = 14099,
        ["12633"] = 25955,
        ["12634"] = 15310,
        ["12637"] = 18157,
        ["12638"] = 0,
        ["12639"] = 25061,
        ["1264"] = 3671,
        ["12640"] = 36930,
        ["12641"] = 39455,
        ["12642"] = 0,
        ["12643"] = 75,
        ["12644"] = 200,
        ["12645"] = 500,
        ["12647"] = 0,
        ["12648"] = 0,
        ["1265"] = 11775,
        ["12650"] = 0,
        ["12651"] = 36055,
        ["12652"] = 0,
        ["12653"] = 36318,
        ["12654"] = 62,
        ["12655"] = 500,
        ["12662"] = 600,
        ["12663"] = 0,
        ["12682"] = 3000,
        ["12683"] = 3000,
        ["12684"] = 3000,
        ["12685"] = 3000,
        ["12689"] = 3500,
        ["12691"] = 4000,
        ["12692"] = 4000,
        ["12693"] = 5000,
        ["12694"] = 5000,
        ["12695"] = 5000,
        ["12696"] = 5000,
        ["12697"] = 5500,
        ["12699"] = 5000,
        ["127"] = 1,
        ["1270"] = 213,
        ["12701"] = 6250,
        ["12702"] = 6250,
        ["12703"] = 10000,
        ["12704"] = 7500,
        ["12705"] = 7500,
        ["12707"] = 7500,
        ["12708"] = 0,
        ["12709"] = 52195,
        ["12710"] = 0,
        ["12711"] = 10000,
        ["12712"] = 0,
        ["12713"] = 10000,
        ["12717"] = 15000,
        ["12719"] = 15000,
        ["12720"] = 20000,
        ["12721"] = 0,
        ["12722"] = 0,
        ["12723"] = 0,
        ["12724"] = 0,
        ["12725"] = 15000,
        ["12726"] = 15000,
        ["12727"] = 15000,
        ["12728"] = 20000,
        ["1273"] = 1656,
        ["12730"] = 0,
        ["12731"] = 0,
        ["12732"] = 0,
        ["12734"] = 0,
        ["12735"] = 0,
        ["12736"] = 0,
        ["12737"] = 0,
        ["12738"] = 0,
        ["12739"] = 0,
        ["1274"] = 8,
        ["12740"] = 0,
        ["12741"] = 0,
        ["1275"] = 1668,
        ["12752"] = 21359,
        ["12753"] = 0,
        ["12756"] = 32687,
        ["12757"] = 32813,
        ["1276"] = 2220,
        ["12765"] = 0,
        ["12766"] = 0,
        ["12768"] = 0,
        ["12770"] = 0,
        ["12771"] = 0,
        ["12773"] = 33080,
        ["12774"] = 36044,
        ["12775"] = 39949,
        ["12776"] = 48125,
        ["12777"] = 38648,
        ["12780"] = 0,
        ["12781"] = 42721,
        ["12782"] = 56808,
        ["12783"] = 52397,
        ["12784"] = 65736,
        ["12785"] = 0,
        ["12790"] = 67161,
        ["12791"] = 39411,
        ["12792"] = 39255,
        ["12793"] = 19846,
        ["12794"] = 50676,
        ["12796"] = 63825,
        ["12797"] = 51252,
        ["12798"] = 51438,
        ["12799"] = 7000,
        ["1280"] = 3696,
        ["12800"] = 10000,
        ["12803"] = 500,
        ["12804"] = 2000,
        ["12806"] = 0,
        ["12807"] = 0,
        ["12808"] = 1000,
        ["12809"] = 10000,
        ["12810"] = 500,
        ["12811"] = 20000,
        ["12812"] = 0,
        ["12813"] = 0,
        ["12814"] = 0,
        ["12815"] = 0,
        ["12819"] = 4000,
        ["1282"] = 2825,
        ["12820"] = 0,
        ["12821"] = 4000,
        ["12822"] = 0,
        ["12823"] = 5000,
        ["12824"] = 5000,
        ["12825"] = 5000,
        ["12827"] = 5000,
        ["12828"] = 5500,
        ["12829"] = 0,
        ["1283"] = 0,
        ["12830"] = 5500,
        ["12833"] = 20000,
        ["12834"] = 20000,
        ["12835"] = 20000,
        ["12836"] = 20000,
        ["12837"] = 20000,
        ["12838"] = 20000,
        ["12839"] = 20000,
        ["1284"] = 0,
        ["12840"] = 0,
        ["12841"] = 0,
        ["12842"] = 0,
        ["12843"] = 0,
        ["12844"] = 0,
        ["12845"] = 0,
        ["12846"] = 0,
        ["12848"] = 0,
        ["12849"] = 0,
        ["1287"] = 703,
        ["12871"] = 8048,
        ["1288"] = 185,
        ["12884"] = 0,
        ["12885"] = 0,
        ["12886"] = 0,
        ["12888"] = 0,
        ["12891"] = 0,
        ["12894"] = 0,
        ["12895"] = 48071,
        ["12896"] = 0,
        ["12897"] = 0,
        ["12898"] = 0,
        ["12899"] = 0,
        ["129"] = 1,
        ["12900"] = 0,
        ["12903"] = 42407,
        ["12905"] = 15798,
        ["12906"] = 0,
        ["12907"] = 0,
        ["1292"] = 3300,
        ["12922"] = 0,
        ["12923"] = 0,
        ["12924"] = 0,
        ["12925"] = 0,
        ["12926"] = 14907,
        ["12927"] = 18492,
        ["12928"] = 0,
        ["12929"] = 19646,
        ["1293"] = 0,
        ["12930"] = 10000,
        ["12935"] = 36536,
        ["12936"] = 18440,
        ["12938"] = 0,
        ["12939"] = 54330,
        ["1294"] = 0,
        ["12940"] = 49334,
        ["12942"] = 0,
        ["12945"] = 39686,
        ["12946"] = 0,
        ["12952"] = 25957,
        ["12953"] = 22374,
        ["12954"] = 0,
        ["12955"] = 0,
        ["12956"] = 0,
        ["12957"] = 0,
        ["12958"] = 12500,
        ["1296"] = 1681,
        ["12960"] = 17752,
        ["12963"] = 24947,
        ["12964"] = 30051,
        ["12965"] = 20111,
        ["12966"] = 12617,
        ["12967"] = 15196,
        ["12968"] = 15254,
        ["12969"] = 63799,
        ["1297"] = 2038,
        ["12973"] = 0,
        ["12974"] = 6105,
        ["12975"] = 2205,
        ["12976"] = 1770,
        ["12977"] = 355,
        ["12978"] = 534,
        ["12979"] = 617,
        ["12982"] = 851,
        ["12983"] = 2362,
        ["12984"] = 1423,
        ["12985"] = 1153,
        ["12987"] = 906,
        ["12988"] = 1137,
        ["12989"] = 2854,
        ["1299"] = 390,
        ["12990"] = 2589,
        ["12992"] = 3260,
        ["12994"] = 788,
        ["12996"] = 1527,
        ["12997"] = 1920,
        ["12998"] = 1020,
        ["12999"] = 853,
        ["1300"] = 1854,
        ["13000"] = 60815,
        ["13001"] = 10648,
        ["13002"] = 14617,
        ["13003"] = 49640,
        ["13004"] = 33591,
        ["13005"] = 1331,
        ["13006"] = 51132,
        ["13007"] = 13585,
        ["13008"] = 12815,
        ["13009"] = 15167,
        ["13010"] = 2241,
        ["13011"] = 1031,
        ["13012"] = 1241,
        ["13013"] = 12355,
        ["13014"] = 34705,
        ["13015"] = 52106,
        ["13016"] = 4771,
        ["13017"] = 17209,
        ["13018"] = 31967,
        ["13019"] = 4765,
        ["1302"] = 262,
        ["13020"] = 8985,
        ["13021"] = 16694,
        ["13022"] = 27990,
        ["13023"] = 38435,
        ["13024"] = 4863,
        ["13025"] = 10464,
        ["13026"] = 19441,
        ["13027"] = 33832,
        ["13028"] = 50800,
        ["13029"] = 5613,
        ["1303"] = 418,
        ["13030"] = 13113,
        ["13031"] = 1401,
        ["13032"] = 4138,
        ["13033"] = 8094,
        ["13034"] = 14710,
        ["13035"] = 25141,
        ["13036"] = 40988,
        ["13037"] = 4729,
        ["13038"] = 9630,
        ["13039"] = 17892,
        ["1304"] = 279,
        ["13040"] = 29444,
        ["13041"] = 4516,
        ["13042"] = 17596,
        ["13043"] = 32389,
        ["13044"] = 52800,
        ["13045"] = 10809,
        ["13046"] = 35042,
        ["13047"] = 56588,
        ["13048"] = 5971,
        ["13049"] = 6191,
        ["13051"] = 22911,
        ["13052"] = 41677,
        ["13053"] = 59186,
        ["13054"] = 15805,
        ["13055"] = 29367,
        ["13056"] = 48330,
        ["13057"] = 5382,
        ["13058"] = 21833,
        ["13059"] = 38719,
        ["1306"] = 352,
        ["13060"] = 60784,
        ["13062"] = 2991,
        ["13063"] = 5851,
        ["13064"] = 11487,
        ["13065"] = 20945,
        ["13066"] = 15716,
        ["13067"] = 25098,
        ["13068"] = 8358,
        ["13070"] = 24606,
        ["13071"] = 7148,
        ["13072"] = 18351,
        ["13073"] = 15861,
        ["13074"] = 14043,
        ["13075"] = 34795,
        ["13076"] = 8300,
        ["13077"] = 14478,
        ["13079"] = 3359,
        ["13081"] = 7123,
        ["13082"] = 13235,
        ["13083"] = 32348,
        ["13084"] = 6614,
        ["13085"] = 9137,
        ["13086"] = 0,
        ["13087"] = 5896,
        ["13088"] = 7413,
        ["13089"] = 8039,
        ["1309"] = 0,
        ["13091"] = 10637,
        ["13093"] = 3381,
        ["13094"] = 2646,
        ["13095"] = 6646,
        ["13096"] = 7913,
        ["13097"] = 2164,
        ["13098"] = 15282,
        ["13099"] = 1431,
        ["1310"] = 715,
        ["13100"] = 5421,
        ["13101"] = 14318,
        ["13102"] = 6879,
        ["13103"] = 3453,
        ["13105"] = 2147,
        ["13106"] = 1216,
        ["13107"] = 10528,
        ["13108"] = 2446,
        ["13109"] = 8152,
        ["13110"] = 4968,
        ["13111"] = 13993,
        ["13112"] = 9625,
        ["13113"] = 18492,
        ["13114"] = 2574,
        ["13115"] = 6991,
        ["13116"] = 18705,
        ["13117"] = 3830,
        ["13118"] = 10601,
        ["13119"] = 3063,
        ["13120"] = 9505,
        ["13121"] = 3428,
        ["13122"] = 11489,
        ["13123"] = 31130,
        ["13124"] = 3996,
        ["13125"] = 12954,
        ["13126"] = 10374,
        ["13127"] = 3021,
        ["13128"] = 10543,
        ["13129"] = 7621,
        ["13130"] = 25065,
        ["13131"] = 2312,
        ["13132"] = 7340,
        ["13133"] = 22291,
        ["13134"] = 7716,
        ["13135"] = 14001,
        ["13136"] = 1456,
        ["13137"] = 5874,
        ["13138"] = 11532,
        ["13139"] = 21029,
        ["1314"] = 362,
        ["13140"] = 0,
        ["13141"] = 12093,
        ["13142"] = 18442,
        ["13143"] = 21372,
        ["13144"] = 6865,
        ["13145"] = 4760,
        ["13146"] = 34704,
        ["13148"] = 62629,
        ["1315"] = 13000,
        ["13155"] = 0,
        ["13156"] = 0,
        ["13157"] = 0,
        ["13158"] = 0,
        ["13159"] = 0,
        ["13161"] = 63494,
        ["13162"] = 17945,
        ["13163"] = 64835,
        ["13164"] = 10539,
        ["13166"] = 24811,
        ["13167"] = 59410,
        ["13168"] = 33398,
        ["13169"] = 23948,
        ["1317"] = 3500,
        ["13170"] = 19230,
        ["13171"] = 7000,
        ["13172"] = 0,
        ["13173"] = 11,
        ["13174"] = 0,
        ["13175"] = 30619,
        ["13176"] = 0,
        ["13177"] = 16396,
        ["13178"] = 13782,
        ["13179"] = 14916,
        ["1318"] = 3066,
        ["13180"] = 0,
        ["13181"] = 8797,
        ["13182"] = 44142,
        ["13183"] = 51771,
        ["13184"] = 13170,
        ["13185"] = 15858,
        ["13186"] = 0,
        ["13187"] = 0,
        ["13188"] = 0,
        ["13189"] = 0,
        ["1319"] = 462,
        ["13190"] = 0,
        ["13191"] = 0,
        ["13192"] = 0,
        ["13193"] = 0,
        ["13194"] = 0,
        ["13195"] = 0,
        ["13196"] = 0,
        ["13197"] = 0,
        ["13198"] = 50851,
        ["13199"] = 4399,
        ["13202"] = 0,
        ["13203"] = 15529,
        ["13204"] = 51945,
        ["13205"] = 33829,
        ["13206"] = 19198,
        ["13207"] = 0,
        ["13208"] = 12091,
        ["13209"] = 0,
        ["13210"] = 18024,
        ["13211"] = 14474,
        ["13212"] = 10670,
        ["13213"] = 9633,
        ["13216"] = 12795,
        ["13217"] = 8814,
        ["13218"] = 53388,
        ["1322"] = 68,
        ["13243"] = 34046,
        ["13244"] = 14482,
        ["13245"] = 1064,
        ["13246"] = 49997,
        ["13247"] = 5837,
        ["13248"] = 29669,
        ["13249"] = 63199,
        ["1325"] = 0,
        ["13250"] = 0,
        ["13251"] = 0,
        ["13252"] = 12434,
        ["13253"] = 9983,
        ["13254"] = 21569,
        ["13255"] = 14366,
        ["13257"] = 18088,
        ["13258"] = 12885,
        ["13259"] = 27105,
        ["1326"] = 10,
        ["13260"] = 21787,
        ["13261"] = 10452,
        ["1327"] = 0,
        ["13282"] = 13684,
        ["13283"] = 14907,
        ["13284"] = 19785,
        ["13285"] = 54924,
        ["13286"] = 44106,
        ["13287"] = 625,
        ["13288"] = 625,
        ["13289"] = 0,
        ["13302"] = 0,
        ["13303"] = 0,
        ["13304"] = 0,
        ["13305"] = 0,
        ["13306"] = 0,
        ["13307"] = 0,
        ["13308"] = 450,
        ["13309"] = 250,
        ["13310"] = 500,
        ["13311"] = 2500,
        ["13313"] = 0,
        ["13314"] = 28178,
        ["13315"] = 11396,
        ["13320"] = 0,
        ["13321"] = 0,
        ["13322"] = 0,
        ["13326"] = 0,
        ["13327"] = 0,
        ["13328"] = 0,
        ["13331"] = 0,
        ["13332"] = 0,
        ["13333"] = 0,
        ["13334"] = 0,
        ["13335"] = 25000,
        ["13340"] = 14850,
        ["13344"] = 15490,
        ["13345"] = 15457,
        ["13346"] = 20807,
        ["13347"] = 2,
        ["13348"] = 65497,
        ["13349"] = 52589,
        ["13352"] = 0,
        ["13353"] = 10452,
        ["13354"] = 0,
        ["13356"] = 0,
        ["13357"] = 0,
        ["13358"] = 18933,
        ["13359"] = 22804,
        ["13360"] = 50868,
        ["13361"] = 51060,
        ["13362"] = 2000,
        ["13363"] = 2000,
        ["13364"] = 2000,
        ["13365"] = 2000,
        ["13366"] = 3000,
        ["13367"] = 0,
        ["13368"] = 51689,
        ["13369"] = 15775,
        ["13370"] = 0,
        ["13371"] = 6657,
        ["13372"] = 63769,
        ["13373"] = 14846,
        ["13374"] = 14315,
        ["13375"] = 30656,
        ["13376"] = 13738,
        ["13377"] = 7,
        ["13378"] = 21972,
        ["13379"] = 10734,
        ["13380"] = 37124,
        ["13381"] = 26032,
        ["13382"] = 10850,
        ["13383"] = 26864,
        ["13384"] = 15819,
        ["13385"] = 13237,
        ["13386"] = 15182,
        ["13387"] = 15238,
        ["13388"] = 20974,
        ["13389"] = 21000,
        ["13390"] = 16367,
        ["13391"] = 15861,
        ["13392"] = 12211,
        ["13393"] = 60240,
        ["13394"] = 31808,
        ["13395"] = 11403,
        ["13396"] = 30853,
        ["13397"] = 14680,
        ["13398"] = 18674,
        ["13399"] = 46312,
        ["13400"] = 16361,
        ["13401"] = 49675,
        ["13402"] = 21168,
        ["13403"] = 9401,
        ["13404"] = 15895,
        ["13405"] = 22885,
        ["13408"] = 44142,
        ["13409"] = 8860,
        ["13422"] = 10,
        ["13423"] = 125,
        ["13442"] = 500,
        ["13443"] = 400,
        ["13444"] = 1500,
        ["13445"] = 500,
        ["13446"] = 1000,
        ["13447"] = 1250,
        ["13448"] = 0,
        ["13450"] = 0,
        ["13451"] = 0,
        ["13452"] = 1250,
        ["13453"] = 1250,
        ["13454"] = 750,
        ["13455"] = 750,
        ["13456"] = 750,
        ["13457"] = 750,
        ["13458"] = 750,
        ["13459"] = 100,
        ["13461"] = 750,
        ["13462"] = 750,
        ["13463"] = 100,
        ["13464"] = 100,
        ["13465"] = 150,
        ["13466"] = 250,
        ["13467"] = 250,
        ["13468"] = 1000,
        ["13470"] = 0,
        ["13471"] = 0,
        ["13473"] = 7164,
        ["13474"] = 24725,
        ["13475"] = 8109,
        ["13476"] = 3000,
        ["13477"] = 3000,
        ["13478"] = 3250,
        ["13479"] = 3500,
        ["13480"] = 3750,
        ["13481"] = 3750,
        ["13482"] = 0,
        ["13483"] = 0,
        ["13484"] = 0,
        ["13485"] = 0,
        ["13486"] = 3750,
        ["13487"] = 3750,
        ["13488"] = 3750,
        ["13489"] = 3750,
        ["1349"] = 0,
        ["13490"] = 4000,
        ["13491"] = 4000,
        ["13492"] = 5000,
        ["13493"] = 5000,
        ["13494"] = 6000,
        ["13495"] = 6000,
        ["13496"] = 6000,
        ["13497"] = 6000,
        ["13498"] = 34808,
        ["13499"] = 6000,
        ["13501"] = 7500,
        ["13502"] = 18989,
        ["13503"] = 25000,
        ["13505"] = 82215,
        ["13506"] = 5000,
        ["13507"] = 0,
        ["13508"] = 4778,
        ["13509"] = 5393,
        ["1351"] = 705,
        ["13510"] = 5000,
        ["13511"] = 5000,
        ["13512"] = 5000,
        ["13513"] = 5000,
        ["13514"] = 5820,
        ["13515"] = 9600,
        ["13517"] = 20000,
        ["13518"] = 10000,
        ["13519"] = 10000,
        ["13520"] = 10000,
        ["13521"] = 10000,
        ["13522"] = 10000,
        ["13523"] = 0,
        ["13524"] = 12458,
        ["13525"] = 8110,
        ["13526"] = 10177,
        ["13527"] = 21414,
        ["13528"] = 12306,
        ["13529"] = 31195,
        ["1353"] = 0,
        ["13530"] = 12232,
        ["13531"] = 21191,
        ["13532"] = 12762,
        ["13533"] = 21607,
        ["13534"] = 37728,
        ["13535"] = 16829,
        ["13536"] = 0,
        ["13537"] = 10594,
        ["13538"] = 19223,
        ["13539"] = 15022,
        ["13542"] = 0,
        ["13544"] = 2,
        ["13545"] = 0,
        ["13546"] = 62,
        ["1355"] = 201,
        ["13562"] = 0,
        ["1357"] = 0,
        ["1358"] = 0,
        ["13582"] = 0,
        ["13583"] = 0,
        ["13584"] = 0,
        ["13585"] = 0,
        ["1359"] = 19,
        ["1360"] = 42,
        ["13602"] = 0,
        ["13603"] = 0,
        ["1361"] = 0,
        ["1362"] = 0,
        ["13624"] = 0,
        ["13626"] = 0,
        ["1364"] = 8,
        ["1366"] = 2,
        ["1367"] = 2,
        ["1368"] = 2,
        ["1369"] = 4,
        ["13699"] = 0,
        ["1370"] = 2,
        ["13700"] = 0,
        ["13701"] = 0,
        ["13702"] = 0,
        ["13703"] = 0,
        ["13704"] = 0,
        ["1372"] = 2,
        ["13724"] = 300,
        ["13725"] = 0,
        ["1374"] = 3,
        ["13752"] = 0,
        ["13754"] = 6,
        ["13755"] = 7,
        ["13756"] = 9,
        ["13757"] = 10,
        ["13758"] = 4,
        ["13759"] = 10,
        ["1376"] = 4,
        ["13760"] = 10,
        ["13761"] = 0,
        ["1377"] = 1,
        ["1378"] = 1,
        ["1380"] = 4,
        ["1381"] = 0,
        ["13810"] = 300,
        ["13813"] = 300,
        ["13815"] = 0,
        ["13816"] = 10561,
        ["13817"] = 18797,
        ["13818"] = 13431,
        ["13819"] = 19881,
        ["1382"] = 24,
        ["13820"] = 12042,
        ["13821"] = 17993,
        ["13822"] = 11442,
        ["13823"] = 13107,
        ["13824"] = 9015,
        ["13825"] = 10168,
        ["1383"] = 25,
        ["1384"] = 11,
        ["13850"] = 0,
        ["13851"] = 312,
        ["13853"] = 0,
        ["13856"] = 5112,
        ["13857"] = 10878,
        ["13858"] = 10917,
        ["13860"] = 8741,
        ["13863"] = 6617,
        ["13864"] = 9553,
        ["13865"] = 13555,
        ["13866"] = 11358,
        ["13867"] = 12138,
        ["13868"] = 9665,
        ["13869"] = 9702,
        ["1387"] = 1578,
        ["13870"] = 5471,
        ["13871"] = 13436,
        ["13872"] = 0,
        ["13873"] = 0,
        ["13874"] = 1,
        ["13875"] = 1,
        ["13876"] = 25,
        ["13877"] = 30,
        ["13878"] = 32,
        ["13879"] = 35,
        ["13880"] = 37,
        ["13881"] = 100,
        ["13882"] = 60,
        ["13883"] = 60,
        ["13884"] = 75,
        ["13885"] = 50,
        ["13886"] = 50,
        ["13887"] = 75,
        ["13888"] = 12,
        ["13889"] = 5,
        ["1389"] = 58,
        ["13890"] = 70,
        ["13891"] = 100,
        ["13892"] = 0,
        ["13893"] = 15,
        ["13895"] = 101324,
        ["13896"] = 11020,
        ["13897"] = 595,
        ["13898"] = 57739,
        ["13899"] = 3528,
        ["139"] = 1,
        ["13901"] = 25,
        ["13902"] = 25,
        ["13903"] = 25,
        ["13904"] = 25,
        ["13907"] = 50,
        ["13909"] = 55,
        ["1391"] = 1392,
        ["13910"] = 62,
        ["13914"] = 125,
        ["13915"] = 125,
        ["13918"] = 1,
        ["13920"] = 0,
        ["13926"] = 10000,
        ["13927"] = 8,
        ["13928"] = 8,
        ["13929"] = 10,
        ["13930"] = 5,
        ["13931"] = 12,
        ["13932"] = 12,
        ["13933"] = 14,
        ["13934"] = 18,
        ["13935"] = 10,
        ["13937"] = 81129,
        ["13938"] = 36646,
        ["13939"] = 4000,
        ["1394"] = 740,
        ["13940"] = 4000,
        ["13941"] = 4000,
        ["13942"] = 4000,
        ["13943"] = 4000,
        ["13944"] = 24996,
        ["13945"] = 5000,
        ["13946"] = 5000,
        ["13947"] = 5000,
        ["13948"] = 5000,
        ["13949"] = 5000,
        ["1395"] = 1,
        ["13950"] = 15335,
        ["13951"] = 18059,
        ["13952"] = 52850,
        ["13953"] = 53034,
        ["13954"] = 19687,
        ["13955"] = 27607,
        ["13956"] = 10574,
        ["13957"] = 12001,
        ["13958"] = 9505,
        ["13959"] = 16794,
        ["1396"] = 1,
        ["13960"] = 12828,
        ["13961"] = 18028,
        ["13962"] = 12064,
        ["13963"] = 14533,
        ["13964"] = 49986,
        ["13965"] = 16250,
        ["13966"] = 16250,
        ["13967"] = 22537,
        ["13968"] = 16250,
        ["13969"] = 15470,
        ["13982"] = 62847,
        ["13983"] = 62240,
        ["13984"] = 52029,
        ["13986"] = 15723,
        ["1399"] = 12,
        ["140"] = 1,
        ["14002"] = 33050,
        ["1401"] = 14,
        ["14022"] = 8991,
        ["14023"] = 8991,
        ["14024"] = 50623,
        ["14025"] = 188,
        ["1404"] = 10306,
        ["14042"] = 10561,
        ["14043"] = 5955,
        ["14044"] = 9503,
        ["14045"] = 13481,
        ["14046"] = 5000,
        ["14047"] = 400,
        ["14048"] = 2000,
        ["1405"] = 1184,
        ["1406"] = 2079,
        ["1407"] = 0,
        ["1408"] = 0,
        ["14086"] = 45,
        ["14087"] = 16,
        ["14088"] = 24,
        ["14089"] = 30,
        ["1409"] = 0,
        ["14090"] = 119,
        ["14091"] = 120,
        ["14093"] = 21,
        ["14094"] = 121,
        ["14095"] = 36,
        ["14096"] = 325,
        ["14097"] = 236,
        ["14098"] = 43,
        ["14099"] = 47,
        ["1410"] = 0,
        ["14100"] = 12089,
        ["14101"] = 6066,
        ["14102"] = 60,
        ["14103"] = 9716,
        ["14104"] = 15484,
        ["14106"] = 17434,
        ["14107"] = 13141,
        ["14108"] = 11112,
        ["14109"] = 341,
        ["1411"] = 68,
        ["14110"] = 84,
        ["14111"] = 10775,
        ["14112"] = 12596,
        ["14113"] = 139,
        ["14114"] = 242,
        ["14115"] = 70,
        ["14116"] = 106,
        ["14117"] = 163,
        ["14119"] = 378,
        ["1412"] = 49,
        ["14120"] = 577,
        ["14121"] = 579,
        ["14122"] = 219,
        ["14123"] = 287,
        ["14124"] = 292,
        ["14125"] = 676,
        ["14126"] = 396,
        ["14127"] = 1000,
        ["14128"] = 16093,
        ["14129"] = 415,
        ["1413"] = 55,
        ["14130"] = 12330,
        ["14131"] = 242,
        ["14132"] = 12441,
        ["14133"] = 950,
        ["14134"] = 11280,
        ["14136"] = 17025,
        ["14137"] = 18113,
        ["14138"] = 20042,
        ["14139"] = 15297,
        ["1414"] = 97,
        ["14140"] = 15565,
        ["14141"] = 12859,
        ["14142"] = 6087,
        ["14143"] = 5763,
        ["14144"] = 14374,
        ["14145"] = 1032,
        ["14146"] = 13132,
        ["14147"] = 312,
        ["14148"] = 208,
        ["14149"] = 314,
        ["1415"] = 72,
        ["14150"] = 420,
        ["14151"] = 1056,
        ["14152"] = 26866,
        ["14153"] = 26965,
        ["14154"] = 27066,
        ["14155"] = 20000,
        ["14156"] = 40000,
        ["14157"] = 434,
        ["14158"] = 1236,
        ["14159"] = 570,
        ["1416"] = 72,
        ["14160"] = 251,
        ["14161"] = 337,
        ["14162"] = 445,
        ["14163"] = 1168,
        ["14164"] = 312,
        ["14165"] = 1041,
        ["14166"] = 238,
        ["14167"] = 358,
        ["14168"] = 276,
        ["14169"] = 286,
        ["1417"] = 65,
        ["14170"] = 331,
        ["14171"] = 738,
        ["14172"] = 837,
        ["14173"] = 281,
        ["14174"] = 368,
        ["14175"] = 847,
        ["14176"] = 920,
        ["14177"] = 631,
        ["14178"] = 1532,
        ["14179"] = 747,
        ["1418"] = 9,
        ["14180"] = 1870,
        ["14181"] = 775,
        ["14182"] = 1167,
        ["14183"] = 1710,
        ["14184"] = 1716,
        ["14185"] = 647,
        ["14186"] = 1179,
        ["14187"] = 717,
        ["14188"] = 982,
        ["14189"] = 1588,
        ["1419"] = 19,
        ["14190"] = 1932,
        ["14191"] = 881,
        ["14192"] = 1946,
        ["14193"] = 2006,
        ["14194"] = 756,
        ["14195"] = 1252,
        ["14196"] = 1673,
        ["14197"] = 925,
        ["14198"] = 1531,
        ["14199"] = 1240,
        ["1420"] = 18,
        ["14200"] = 2258,
        ["14201"] = 2060,
        ["14202"] = 3336,
        ["14203"] = 2754,
        ["14204"] = 3041,
        ["14205"] = 1042,
        ["14206"] = 1046,
        ["14207"] = 3076,
        ["14208"] = 2316,
        ["14209"] = 1196,
        ["1421"] = 28,
        ["14210"] = 1637,
        ["14211"] = 1325,
        ["14212"] = 2194,
        ["14213"] = 3449,
        ["14214"] = 2009,
        ["14215"] = 3579,
        ["14216"] = 4887,
        ["14217"] = 1638,
        ["14218"] = 2713,
        ["14219"] = 2046,
        ["1422"] = 6,
        ["14220"] = 3442,
        ["14221"] = 1511,
        ["14222"] = 1834,
        ["14223"] = 2699,
        ["14224"] = 3901,
        ["14225"] = 4694,
        ["14226"] = 1731,
        ["14227"] = 2500,
        ["14228"] = 3560,
        ["14229"] = 2387,
        ["1423"] = 19,
        ["14230"] = 5164,
        ["14231"] = 1905,
        ["14232"] = 3097,
        ["14233"] = 4476,
        ["14234"] = 5240,
        ["14235"] = 1789,
        ["14236"] = 2909,
        ["14237"] = 7206,
        ["14238"] = 3691,
        ["14239"] = 3176,
        ["14240"] = 2294,
        ["14241"] = 2311,
        ["14242"] = 5413,
        ["14243"] = 4075,
        ["14244"] = 6870,
        ["14245"] = 2346,
        ["14246"] = 4451,
        ["14247"] = 4467,
        ["14248"] = 2373,
        ["14249"] = 7559,
        ["1425"] = 37,
        ["14250"] = 3873,
        ["14251"] = 3332,
        ["14252"] = 4914,
        ["14253"] = 2819,
        ["14254"] = 7698,
        ["14255"] = 2629,
        ["14256"] = 2000,
        ["14257"] = 6194,
        ["14258"] = 3109,
        ["14259"] = 5056,
        ["14260"] = 2900,
        ["14261"] = 4044,
        ["14262"] = 3156,
        ["14263"] = 5987,
        ["14264"] = 8013,
        ["14265"] = 9853,
        ["14266"] = 5606,
        ["14267"] = 9926,
        ["14268"] = 3486,
        ["14269"] = 5669,
        ["1427"] = 29,
        ["14270"] = 4877,
        ["14271"] = 6599,
        ["14272"] = 3821,
        ["14273"] = 6375,
        ["14274"] = 10448,
        ["14275"] = 11115,
        ["14276"] = 3598,
        ["14277"] = 10131,
        ["14278"] = 6725,
        ["14279"] = 4206,
        ["14280"] = 5919,
        ["14281"] = 8178,
        ["14282"] = 4552,
        ["14283"] = 11646,
        ["14284"] = 13135,
        ["14285"] = 6905,
        ["14286"] = 4620,
        ["14287"] = 13283,
        ["14288"] = 14132,
        ["14289"] = 5131,
        ["1429"] = 7,
        ["14290"] = 7725,
        ["14291"] = 4830,
        ["14292"] = 6795,
        ["14293"] = 9857,
        ["14294"] = 5223,
        ["14295"] = 13237,
        ["14296"] = 7568,
        ["14297"] = 13556,
        ["14298"] = 9629,
        ["14299"] = 8602,
        ["1430"] = 7,
        ["14300"] = 7685,
        ["14301"] = 5451,
        ["14302"] = 6517,
        ["14303"] = 16209,
        ["14304"] = 6194,
        ["14305"] = 14349,
        ["14306"] = 16830,
        ["14307"] = 12064,
        ["14308"] = 17188,
        ["14309"] = 6867,
        ["1431"] = 20,
        ["14310"] = 11615,
        ["14311"] = 6524,
        ["14312"] = 13077,
        ["14313"] = 9298,
        ["14314"] = 7854,
        ["14315"] = 16550,
        ["14316"] = 11271,
        ["14317"] = 16062,
        ["14318"] = 16569,
        ["14319"] = 11401,
        ["14320"] = 6855,
        ["14321"] = 9438,
        ["14322"] = 12785,
        ["14323"] = 8322,
        ["14324"] = 16706,
        ["14325"] = 12751,
        ["14326"] = 17533,
        ["14327"] = 7659,
        ["14328"] = 21633,
        ["14329"] = 13115,
        ["1433"] = 14,
        ["14330"] = 8655,
        ["14331"] = 11654,
        ["14332"] = 13616,
        ["14333"] = 8989,
        ["14334"] = 18041,
        ["14335"] = 13578,
        ["14336"] = 16880,
        ["14337"] = 8253,
        ["14338"] = 0,
        ["14339"] = 0,
        ["1434"] = 43,
        ["14340"] = 20305,
        ["14341"] = 1250,
        ["14342"] = 4000,
        ["14343"] = 0,
        ["14344"] = 0,
        ["1436"] = 458,
        ["14364"] = 325,
        ["14365"] = 214,
        ["14366"] = 189,
        ["14367"] = 252,
        ["14368"] = 346,
        ["14369"] = 809,
        ["14370"] = 473,
        ["14371"] = 816,
        ["14372"] = 1430,
        ["14373"] = 525,
        ["14374"] = 699,
        ["14375"] = 528,
        ["14376"] = 552,
        ["14377"] = 602,
        ["14378"] = 997,
        ["14379"] = 1615,
        ["1438"] = 70,
        ["14380"] = 1473,
        ["14381"] = 0,
        ["14395"] = 0,
        ["14396"] = 0,
        ["14397"] = 1600,
        ["14398"] = 2355,
        ["14399"] = 1465,
        ["1440"] = 1230,
        ["14400"] = 1215,
        ["14401"] = 1786,
        ["14402"] = 838,
        ["14403"] = 1017,
        ["14404"] = 2472,
        ["14405"] = 2480,
        ["14406"] = 935,
        ["14407"] = 4266,
        ["14408"] = 2275,
        ["14409"] = 1707,
        ["14410"] = 2710,
        ["14411"] = 1387,
        ["14412"] = 2298,
        ["14413"] = 3947,
        ["14414"] = 1276,
        ["14415"] = 3410,
        ["14416"] = 1285,
        ["14417"] = 5888,
        ["14418"] = 3098,
        ["14419"] = 1919,
        ["14420"] = 2889,
        ["14421"] = 3945,
        ["14422"] = 2263,
        ["14423"] = 3406,
        ["14424"] = 5316,
        ["14425"] = 6223,
        ["14426"] = 2125,
        ["14427"] = 9124,
        ["14428"] = 4717,
        ["14429"] = 2644,
        ["1443"] = 21125,
        ["14430"] = 3686,
        ["14431"] = 2877,
        ["14432"] = 4679,
        ["14433"] = 6764,
        ["14434"] = 8706,
        ["14435"] = 2778,
        ["14436"] = 5270,
        ["14437"] = 12002,
        ["14438"] = 6192,
        ["14439"] = 3836,
        ["14440"] = 5347,
        ["14441"] = 7167,
        ["14442"] = 4481,
        ["14443"] = 6745,
        ["14444"] = 10955,
        ["14445"] = 12353,
        ["14446"] = 4248,
        ["14447"] = 8801,
        ["14448"] = 5555,
        ["14449"] = 10125,
        ["1445"] = 584,
        ["14450"] = 7364,
        ["14451"] = 5537,
        ["14452"] = 8836,
        ["14453"] = 15677,
        ["14454"] = 5598,
        ["14455"] = 15792,
        ["14456"] = 20230,
        ["14457"] = 7575,
        ["14458"] = 12573,
        ["14459"] = 10798,
        ["1446"] = 563,
        ["14460"] = 13196,
        ["14461"] = 8711,
        ["14462"] = 17483,
        ["14463"] = 13160,
        ["14464"] = 20823,
        ["14465"] = 8596,
        ["14466"] = 3000,
        ["14467"] = 3000,
        ["14468"] = 3000,
        ["14469"] = 3000,
        ["1447"] = 22775,
        ["14470"] = 3000,
        ["14471"] = 3000,
        ["14472"] = 3000,
        ["14473"] = 3000,
        ["14474"] = 3000,
        ["14476"] = 3500,
        ["14477"] = 3500,
        ["14478"] = 3500,
        ["14479"] = 3500,
        ["1448"] = 405,
        ["14480"] = 4000,
        ["14481"] = 4000,
        ["14482"] = 4000,
        ["14483"] = 4000,
        ["14484"] = 4000,
        ["14485"] = 4000,
        ["14486"] = 10000,
        ["14487"] = 49623,
        ["14488"] = 5000,
        ["14489"] = 5000,
        ["1449"] = 1875,
        ["14490"] = 5000,
        ["14491"] = 5000,
        ["14492"] = 5000,
        ["14493"] = 5000,
        ["14494"] = 5500,
        ["14495"] = 5500,
        ["14496"] = 5500,
        ["14497"] = 5500,
        ["14498"] = 6250,
        ["14499"] = 7500,
        ["14500"] = 7500,
        ["14501"] = 7500,
        ["14502"] = 12169,
        ["14503"] = 18323,
        ["14504"] = 10000,
        ["14505"] = 10000,
        ["14506"] = 10000,
        ["14507"] = 10000,
        ["14508"] = 15000,
        ["14509"] = 15000,
        ["1451"] = 0,
        ["14510"] = 15000,
        ["14511"] = 15000,
        ["14512"] = 15000,
        ["14513"] = 15000,
        ["14514"] = 15000,
        ["14522"] = 29200,
        ["14523"] = 0,
        ["14525"] = 17330,
        ["14526"] = 5000,
        ["14528"] = 31870,
        ["14529"] = 500,
        ["1453"] = 0,
        ["14530"] = 1000,
        ["14531"] = 59891,
        ["14536"] = 31164,
        ["14537"] = 27688,
        ["14538"] = 15908,
        ["14539"] = 19956,
        ["1454"] = 3937,
        ["14540"] = 0,
        ["14541"] = 66079,
        ["14542"] = 0,
        ["14543"] = 9770,
        ["14544"] = 0,
        ["14545"] = 24612,
        ["14546"] = 0,
        ["14547"] = 0,
        ["14548"] = 23116,
        ["14549"] = 13637,
        ["1455"] = 2931,
        ["14551"] = 10601,
        ["14552"] = 26860,
        ["14553"] = 17125,
        ["14554"] = 48787,
        ["14555"] = 70900,
        ["14557"] = 17880,
        ["14558"] = 10500,
        ["14559"] = 279,
        ["14560"] = 484,
        ["14561"] = 245,
        ["14562"] = 1039,
        ["14563"] = 275,
        ["14564"] = 304,
        ["14565"] = 809,
        ["14566"] = 1010,
        ["14567"] = 529,
        ["14568"] = 797,
        ["14569"] = 472,
        ["1457"] = 1850,
        ["14570"] = 1870,
        ["14571"] = 496,
        ["14572"] = 609,
        ["14573"] = 1289,
        ["14574"] = 1568,
        ["14576"] = 48770,
        ["14577"] = 20844,
        ["14578"] = 983,
        ["14579"] = 1791,
        ["1458"] = 2623,
        ["14580"] = 818,
        ["14581"] = 2912,
        ["14582"] = 1089,
        ["14583"] = 1333,
        ["14584"] = 2673,
        ["14585"] = 2687,
        ["14587"] = 2030,
        ["14588"] = 1989,
        ["14589"] = 3294,
        ["1459"] = 2380,
        ["14590"] = 1821,
        ["14591"] = 4180,
        ["14592"] = 5594,
        ["14593"] = 2210,
        ["14594"] = 2236,
        ["14595"] = 4500,
        ["14596"] = 3388,
        ["14598"] = 2655,
        ["14599"] = 4663,
        ["1460"] = 1768,
        ["14600"] = 2675,
        ["14601"] = 7307,
        ["14602"] = 2995,
        ["14603"] = 4383,
        ["14604"] = 5986,
        ["14605"] = 6868,
        ["14606"] = 2955,
        ["14607"] = 5581,
        ["14608"] = 3162,
        ["1461"] = 3387,
        ["14610"] = 0,
        ["14611"] = 31394,
        ["14612"] = 31503,
        ["14613"] = 0,
        ["14614"] = 15863,
        ["14615"] = 14404,
        ["14616"] = 21785,
        ["14617"] = 6250,
        ["14619"] = 0,
        ["1462"] = 1306,
        ["14620"] = 17226,
        ["14621"] = 25741,
        ["14622"] = 17357,
        ["14623"] = 34649,
        ["14624"] = 34776,
        ["14625"] = 0,
        ["14626"] = 20021,
        ["14627"] = 200,
        ["14628"] = 0,
        ["14629"] = 10389,
        ["14630"] = 250,
        ["14631"] = 15694,
        ["14632"] = 21000,
        ["14633"] = 15806,
        ["14634"] = 625,
        ["14635"] = 750,
        ["14636"] = 12048,
        ["14637"] = 24189,
        ["14638"] = 24282,
        ["14639"] = 375,
        ["1464"] = 71,
        ["14640"] = 12233,
        ["14641"] = 18420,
        ["14644"] = 0,
        ["14645"] = 0,
        ["14646"] = 0,
        ["14647"] = 0,
        ["14648"] = 0,
        ["14649"] = 0,
        ["1465"] = 9825,
        ["14650"] = 0,
        ["14651"] = 0,
        ["14652"] = 4216,
        ["14653"] = 6854,
        ["14654"] = 3931,
        ["14655"] = 10392,
        ["14656"] = 4300,
        ["14657"] = 4195,
        ["14658"] = 7884,
        ["14659"] = 9382,
        ["14660"] = 7063,
        ["14661"] = 5461,
        ["14662"] = 9413,
        ["14663"] = 5141,
        ["14664"] = 15058,
        ["14665"] = 6214,
        ["14666"] = 6367,
        ["14667"] = 10770,
        ["14668"] = 13597,
        ["14669"] = 9654,
        ["1467"] = 0,
        ["14670"] = 20396,
        ["14671"] = 13012,
        ["14672"] = 7309,
        ["14673"] = 8303,
        ["14674"] = 8270,
        ["14675"] = 8182,
        ["14676"] = 13841,
        ["14677"] = 18524,
        ["14678"] = 13156,
        ["14679"] = 0,
        ["1468"] = 28,
        ["14680"] = 25101,
        ["14681"] = 15980,
        ["14682"] = 9906,
        ["14683"] = 11932,
        ["14684"] = 10477,
        ["14685"] = 11594,
        ["14686"] = 18327,
        ["14687"] = 21778,
        ["14688"] = 16168,
        ["1469"] = 1180,
        ["147"] = 1,
        ["1470"] = 875,
        ["14722"] = 424,
        ["14723"] = 290,
        ["14724"] = 253,
        ["14725"] = 292,
        ["14726"] = 337,
        ["14727"] = 778,
        ["14728"] = 485,
        ["14729"] = 870,
        ["1473"] = 1497,
        ["14730"] = 1223,
        ["14742"] = 1118,
        ["14743"] = 583,
        ["14744"] = 2310,
        ["14745"] = 444,
        ["14746"] = 589,
        ["14747"] = 668,
        ["14748"] = 1550,
        ["14749"] = 1325,
        ["1475"] = 82,
        ["14750"] = 1068,
        ["14751"] = 3454,
        ["14752"] = 978,
        ["14753"] = 2610,
        ["14754"] = 1193,
        ["14755"] = 1118,
        ["14756"] = 1860,
        ["14757"] = 3298,
        ["14758"] = 2267,
        ["14759"] = 2010,
        ["1476"] = 6,
        ["14760"] = 6263,
        ["14761"] = 2024,
        ["14762"] = 4074,
        ["14763"] = 1685,
        ["14764"] = 2250,
        ["14765"] = 4428,
        ["14766"] = 5486,
        ["14767"] = 4478,
        ["14768"] = 8566,
        ["14769"] = 5554,
        ["1477"] = 87,
        ["14770"] = 3172,
        ["14771"] = 3030,
        ["14772"] = 3284,
        ["14773"] = 3052,
        ["14774"] = 6252,
        ["14775"] = 8367,
        ["14776"] = 6326,
        ["14777"] = 9710,
        ["14778"] = 4933,
        ["14779"] = 13347,
        ["1478"] = 62,
        ["14780"] = 14289,
        ["14781"] = 4617,
        ["14782"] = 5004,
        ["14783"] = 5424,
        ["14784"] = 8202,
        ["14785"] = 9558,
        ["14786"] = 11841,
        ["14787"] = 8323,
        ["14788"] = 6408,
        ["14789"] = 17541,
        ["1479"] = 47,
        ["14790"] = 18781,
        ["14791"] = 6056,
        ["14792"] = 6960,
        ["14793"] = 6985,
        ["14794"] = 10563,
        ["14795"] = 12690,
        ["14796"] = 16983,
        ["14797"] = 11427,
        ["14798"] = 24037,
        ["14799"] = 17308,
        ["148"] = 1,
        ["1480"] = 954,
        ["14800"] = 25826,
        ["14801"] = 8156,
        ["14802"] = 9749,
        ["14803"] = 9087,
        ["14804"] = 16296,
        ["14805"] = 20577,
        ["14806"] = 15560,
        ["14807"] = 8211,
        ["14808"] = 11581,
        ["14809"] = 18905,
        ["1481"] = 3337,
        ["14810"] = 11669,
        ["14813"] = 10601,
        ["14814"] = 19435,
        ["14815"] = 13760,
        ["14816"] = 27620,
        ["14817"] = 19471,
        ["1482"] = 2964,
        ["14821"] = 9258,
        ["14825"] = 8595,
        ["14826"] = 4068,
        ["14827"] = 4083,
        ["14828"] = 6590,
        ["14829"] = 8837,
        ["1483"] = 2025,
        ["14830"] = 6640,
        ["14831"] = 4120,
        ["14832"] = 4160,
        ["14833"] = 5260,
        ["14834"] = 4889,
        ["14835"] = 14337,
        ["14838"] = 5090,
        ["14839"] = 8212,
        ["1484"] = 2922,
        ["14840"] = 13869,
        ["14841"] = 7484,
        ["14842"] = 12483,
        ["14843"] = 8796,
        ["14844"] = 20075,
        ["14846"] = 7981,
        ["14847"] = 7487,
        ["14848"] = 11972,
        ["14849"] = 14448,
        ["1485"] = 1410,
        ["14850"] = 18275,
        ["14851"] = 12954,
        ["14852"] = 19420,
        ["14853"] = 7346,
        ["14854"] = 28358,
        ["14855"] = 11444,
        ["14856"] = 10835,
        ["14857"] = 16185,
        ["14858"] = 20507,
        ["14859"] = 14820,
        ["1486"] = 1202,
        ["14860"] = 18380,
        ["14861"] = 8880,
        ["14862"] = 28887,
        ["14863"] = 13995,
        ["14864"] = 13380,
        ["14865"] = 20993,
        ["14866"] = 21662,
        ["14867"] = 29048,
        ["14868"] = 22112,
        ["14869"] = 13336,
        ["1487"] = 0,
        ["14872"] = 0,
        ["1488"] = 3379,
        ["1489"] = 1553,
        ["14894"] = 0,
        ["14895"] = 8583,
        ["14896"] = 5970,
        ["14897"] = 4025,
        ["14898"] = 4039,
        ["14899"] = 6517,
        ["1490"] = 8910,
        ["14900"] = 7521,
        ["14901"] = 6104,
        ["14902"] = 7482,
        ["14903"] = 3825,
        ["14904"] = 16179,
        ["14905"] = 5662,
        ["14906"] = 5262,
        ["14907"] = 10696,
        ["14908"] = 14342,
        ["14909"] = 8554,
        ["1491"] = 2207,
        ["14910"] = 5339,
        ["14911"] = 9305,
        ["14912"] = 15232,
        ["14913"] = 11698,
        ["14914"] = 6318,
        ["14915"] = 20246,
        ["14916"] = 17254,
        ["14917"] = 6920,
        ["14918"] = 6432,
        ["14919"] = 13480,
        ["14920"] = 17053,
        ["14921"] = 11191,
        ["14922"] = 14451,
        ["14923"] = 8104,
        ["14924"] = 24555,
        ["14925"] = 18448,
        ["14926"] = 9852,
        ["14927"] = 9329,
        ["14928"] = 22179,
        ["14929"] = 15719,
        ["1493"] = 3922,
        ["14930"] = 22950,
        ["14931"] = 30265,
        ["14932"] = 20583,
        ["14933"] = 13876,
        ["14934"] = 11887,
        ["14935"] = 20760,
        ["14936"] = 28227,
        ["14937"] = 19923,
        ["14938"] = 11387,
        ["14939"] = 11888,
        ["14940"] = 7090,
        ["14941"] = 4427,
        ["14942"] = 4443,
        ["14943"] = 4460,
        ["14944"] = 8395,
        ["14945"] = 11257,
        ["14946"] = 7251,
        ["14947"] = 11198,
        ["14948"] = 18028,
        ["14949"] = 6876,
        ["1495"] = 59,
        ["14950"] = 6390,
        ["14951"] = 10309,
        ["14952"] = 12792,
        ["14953"] = 16028,
        ["14954"] = 15234,
        ["14955"] = 9463,
        ["14956"] = 5471,
        ["14957"] = 12617,
        ["14958"] = 22643,
        ["14959"] = 9052,
        ["14960"] = 8572,
        ["14961"] = 16172,
        ["14962"] = 20458,
        ["14963"] = 14501,
        ["14964"] = 21741,
        ["14965"] = 7833,
        ["14966"] = 30083,
        ["14967"] = 12087,
        ["14968"] = 11444,
        ["14969"] = 21381,
        ["1497"] = 71,
        ["14970"] = 27297,
        ["14971"] = 19346,
        ["14972"] = 18316,
        ["14973"] = 27810,
        ["14974"] = 10576,
        ["14975"] = 29662,
        ["14976"] = 14191,
        ["14977"] = 14049,
        ["14978"] = 21873,
        ["14979"] = 25614,
        ["1498"] = 57,
        ["14980"] = 30244,
        ["14981"] = 22417,
        ["14982"] = 34119,
        ["14983"] = 14054,
        ["1499"] = 51,
        ["15002"] = 0,
        ["15003"] = 20,
        ["15004"] = 42,
        ["15005"] = 28,
        ["15006"] = 73,
        ["15007"] = 24,
        ["15008"] = 37,
        ["15009"] = 162,
        ["1501"] = 80,
        ["15010"] = 163,
        ["15011"] = 184,
        ["15012"] = 296,
        ["15013"] = 86,
        ["15014"] = 585,
        ["15015"] = 86,
        ["15016"] = 200,
        ["15017"] = 611,
        ["15018"] = 706,
        ["15019"] = 366,
        ["1502"] = 60,
        ["1503"] = 109,
        ["1504"] = 32,
        ["15042"] = 0,
        ["15043"] = 0,
        ["15044"] = 0,
        ["15045"] = 19938,
        ["15046"] = 22482,
        ["15047"] = 28812,
        ["15048"] = 24409,
        ["15049"] = 20543,
        ["1505"] = 48,
        ["15050"] = 26071,
        ["15051"] = 21736,
        ["15052"] = 29774,
        ["15053"] = 17275,
        ["15054"] = 14559,
        ["15055"] = 15470,
        ["15056"] = 20966,
        ["15057"] = 18728,
        ["15058"] = 17631,
        ["15059"] = 24776,
        ["1506"] = 51,
        ["15060"] = 21277,
        ["15061"] = 13803,
        ["15062"] = 25709,
        ["15063"] = 11701,
        ["15064"] = 19717,
        ["15065"] = 22233,
        ["15066"] = 23650,
        ["15067"] = 12758,
        ["15068"] = 20359,
        ["15069"] = 17013,
        ["1507"] = 123,
        ["15070"] = 9504,
        ["15071"] = 11443,
        ["15072"] = 16234,
        ["15073"] = 11530,
        ["15074"] = 6867,
        ["15075"] = 18449,
        ["15076"] = 16604,
        ["15077"] = 7615,
        ["15078"] = 9649,
        ["15079"] = 21760,
        ["15080"] = 18230,
        ["15081"] = 19566,
        ["15082"] = 10375,
        ["15083"] = 6872,
        ["15084"] = 7311,
        ["15085"] = 21952,
        ["15086"] = 13154,
        ["15087"] = 17892,
        ["15088"] = 9901,
        ["1509"] = 59,
        ["15090"] = 20514,
        ["15091"] = 7195,
        ["15092"] = 7656,
        ["15093"] = 8368,
        ["15094"] = 14155,
        ["15095"] = 20885,
        ["15096"] = 16161,
        ["1510"] = 150,
        ["15104"] = 3188,
        ["15105"] = 14397,
        ["15106"] = 14447,
        ["15107"] = 5000,
        ["15108"] = 5000,
        ["15109"] = 3344,
        ["1511"] = 194,
        ["15110"] = 351,
        ["15111"] = 609,
        ["15112"] = 354,
        ["15113"] = 1361,
        ["15114"] = 372,
        ["15115"] = 474,
        ["15116"] = 1163,
        ["15117"] = 1219,
        ["15118"] = 1562,
        ["15119"] = 13683,
        ["1512"] = 194,
        ["15120"] = 787,
        ["15121"] = 1433,
        ["15122"] = 701,
        ["15123"] = 2463,
        ["15124"] = 847,
        ["15125"] = 991,
        ["15126"] = 1989,
        ["15127"] = 1647,
        ["15128"] = 2425,
        ["15129"] = 1825,
        ["1513"] = 293,
        ["15130"] = 3252,
        ["15131"] = 2023,
        ["15132"] = 1017,
        ["15133"] = 3827,
        ["15134"] = 3295,
        ["15135"] = 1357,
        ["15136"] = 1249,
        ["15137"] = 1516,
        ["15138"] = 15198,
        ["15139"] = 3055,
        ["1514"] = 294,
        ["15140"] = 2530,
        ["15142"] = 2603,
        ["15143"] = 1439,
        ["15144"] = 4232,
        ["15145"] = 4943,
        ["15146"] = 3730,
        ["15147"] = 1754,
        ["15148"] = 1614,
        ["15149"] = 1960,
        ["1515"] = 196,
        ["15150"] = 2951,
        ["15151"] = 3949,
        ["15152"] = 4449,
        ["15153"] = 2626,
        ["15154"] = 2372,
        ["15155"] = 2571,
        ["15156"] = 5266,
        ["15157"] = 6200,
        ["15158"] = 4320,
        ["15159"] = 6743,
        ["1516"] = 237,
        ["15160"] = 2430,
        ["15161"] = 3319,
        ["15162"] = 5829,
        ["15163"] = 3344,
        ["15164"] = 9135,
        ["15165"] = 3744,
        ["15166"] = 3945,
        ["15167"] = 7484,
        ["15168"] = 7951,
        ["15169"] = 5542,
        ["15170"] = 13104,
        ["15171"] = 8697,
        ["15172"] = 4706,
        ["15173"] = 5387,
        ["15174"] = 6017,
        ["15175"] = 9692,
        ["15176"] = 12121,
        ["15177"] = 8525,
        ["15178"] = 4936,
        ["15179"] = 18593,
        ["1518"] = 0,
        ["15180"] = 6686,
        ["15181"] = 11312,
        ["15182"] = 5996,
        ["15183"] = 6751,
        ["15184"] = 7197,
        ["15185"] = 12906,
        ["15186"] = 15373,
        ["15187"] = 10918,
        ["15188"] = 8702,
        ["15189"] = 15723,
        ["1519"] = 0,
        ["15190"] = 9614,
        ["15191"] = 9035,
        ["15192"] = 10596,
        ["15193"] = 16397,
        ["15194"] = 22412,
        ["15195"] = 22020,
        ["15196"] = 2500,
        ["15197"] = 2500,
        ["15198"] = 2,
        ["15199"] = 10000,
        ["1520"] = 71,
        ["15200"] = 5000,
        ["15202"] = 516,
        ["15203"] = 621,
        ["15204"] = 779,
        ["15205"] = 1063,
        ["15206"] = 857,
        ["15207"] = 914,
        ["15208"] = 0,
        ["15209"] = 0,
        ["1521"] = 19205,
        ["15210"] = 825,
        ["15211"] = 1917,
        ["15212"] = 3450,
        ["15213"] = 8165,
        ["15214"] = 11356,
        ["15215"] = 16744,
        ["15216"] = 25932,
        ["15217"] = 30996,
        ["15218"] = 37048,
        ["15219"] = 41376,
        ["1522"] = 10224,
        ["15220"] = 40552,
        ["15221"] = 51946,
        ["15222"] = 1219,
        ["15223"] = 2376,
        ["15224"] = 2695,
        ["15225"] = 5958,
        ["15226"] = 8755,
        ["15227"] = 21925,
        ["15228"] = 28308,
        ["15229"] = 31924,
        ["1523"] = 10261,
        ["15230"] = 2755,
        ["15231"] = 5033,
        ["15232"] = 6112,
        ["15233"] = 10476,
        ["15234"] = 11354,
        ["15235"] = 21091,
        ["15236"] = 27485,
        ["15237"] = 30526,
        ["15238"] = 36496,
        ["15239"] = 40954,
        ["1524"] = 0,
        ["15240"] = 42810,
        ["15241"] = 3012,
        ["15242"] = 4426,
        ["15243"] = 7871,
        ["15244"] = 12769,
        ["15245"] = 23284,
        ["15246"] = 42614,
        ["15247"] = 43935,
        ["15248"] = 1791,
        ["15249"] = 3877,
        ["15250"] = 6895,
        ["15251"] = 17685,
        ["15252"] = 27906,
        ["15253"] = 31547,
        ["15254"] = 35584,
        ["15255"] = 42545,
        ["15256"] = 47531,
        ["15257"] = 51499,
        ["15258"] = 53805,
        ["15259"] = 3306,
        ["15260"] = 11556,
        ["15261"] = 13530,
        ["15262"] = 21552,
        ["15263"] = 28889,
        ["15264"] = 41517,
        ["15265"] = 46823,
        ["15266"] = 54405,
        ["15267"] = 54186,
        ["15268"] = 1024,
        ["15269"] = 3036,
        ["15270"] = 22775,
        ["15271"] = 43701,
        ["15272"] = 51740,
        ["15273"] = 51401,
        ["15274"] = 31666,
        ["15275"] = 35714,
        ["15276"] = 45263,
        ["15277"] = 0,
        ["15278"] = 50286,
        ["15279"] = 18267,
        ["1528"] = 0,
        ["15280"] = 20603,
        ["15281"] = 26110,
        ["15282"] = 30628,
        ["15283"] = 32459,
        ["15284"] = 3039,
        ["15285"] = 4061,
        ["15286"] = 5568,
        ["15287"] = 12516,
        ["15288"] = 32585,
        ["15289"] = 34505,
        ["1529"] = 700,
        ["15290"] = 0,
        ["15291"] = 19591,
        ["15292"] = 0,
        ["15294"] = 20135,
        ["15295"] = 22712,
        ["15296"] = 31193,
        ["15297"] = 45,
        ["15298"] = 305,
        ["15299"] = 42,
        ["153"] = 1,
        ["15300"] = 86,
        ["15301"] = 108,
        ["15302"] = 47,
        ["15303"] = 299,
        ["15304"] = 414,
        ["15305"] = 412,
        ["15306"] = 208,
        ["15307"] = 815,
        ["15308"] = 241,
        ["15309"] = 220,
        ["15310"] = 279,
        ["15311"] = 982,
        ["15312"] = 745,
        ["15313"] = 514,
        ["15314"] = 0,
        ["1532"] = 0,
        ["15322"] = 7745,
        ["15323"] = 17791,
        ["15324"] = 25565,
        ["15325"] = 31785,
        ["15326"] = 1,
        ["15327"] = 1,
        ["15329"] = 623,
        ["15330"] = 1059,
        ["15331"] = 555,
        ["15332"] = 2263,
        ["15333"] = 537,
        ["15334"] = 828,
        ["15335"] = 580,
        ["15336"] = 1669,
        ["15337"] = 2027,
        ["15338"] = 1387,
        ["15339"] = 2466,
        ["15340"] = 1016,
        ["15341"] = 1697,
        ["15342"] = 2907,
        ["15343"] = 1139,
        ["15344"] = 2516,
        ["15345"] = 1894,
        ["15346"] = 2788,
        ["15347"] = 955,
        ["15348"] = 792,
        ["15349"] = 1550,
        ["15350"] = 2385,
        ["15351"] = 1090,
        ["15352"] = 4101,
        ["15353"] = 3467,
        ["15354"] = 1600,
        ["15355"] = 1620,
        ["15356"] = 3935,
        ["15357"] = 2693,
        ["15358"] = 3604,
        ["15359"] = 5955,
        ["15360"] = 2372,
        ["15361"] = 2204,
        ["15362"] = 3871,
        ["15363"] = 4894,
        ["15364"] = 2431,
        ["15365"] = 2415,
        ["15366"] = 5250,
        ["15367"] = 6246,
        ["15368"] = 3674,
        ["15369"] = 3097,
        ["1537"] = 62,
        ["15370"] = 5439,
        ["15371"] = 3467,
        ["15372"] = 3383,
        ["15373"] = 6930,
        ["15374"] = 7363,
        ["15375"] = 5132,
        ["15376"] = 8653,
        ["15377"] = 3191,
        ["15378"] = 4358,
        ["15379"] = 7654,
        ["15380"] = 4391,
        ["15381"] = 12593,
        ["15382"] = 5043,
        ["15383"] = 5313,
        ["15384"] = 9155,
        ["15385"] = 11449,
        ["15386"] = 7287,
        ["15387"] = 5584,
        ["15388"] = 6357,
        ["15389"] = 10146,
        ["1539"] = 1572,
        ["15390"] = 16175,
        ["15391"] = 12178,
        ["15392"] = 6382,
        ["15393"] = 6479,
        ["15394"] = 14615,
        ["15395"] = 10379,
        ["15396"] = 582,
        ["15397"] = 731,
        ["15398"] = 108,
        ["15399"] = 151,
        ["154"] = 1,
        ["15400"] = 109,
        ["15401"] = 73,
        ["15402"] = 110,
        ["15403"] = 280,
        ["15404"] = 337,
        ["15405"] = 245,
        ["15406"] = 402,
        ["15407"] = 500,
        ["15408"] = 500,
        ["15409"] = 1000,
        ["15410"] = 5000,
        ["15411"] = 10283,
        ["15412"] = 500,
        ["15413"] = 35470,
        ["15414"] = 1500,
        ["15415"] = 500,
        ["15416"] = 1000,
        ["15417"] = 500,
        ["15418"] = 66242,
        ["15419"] = 600,
        ["15420"] = 100,
        ["15421"] = 16070,
        ["15422"] = 500,
        ["15423"] = 500,
        ["15424"] = 1404,
        ["15425"] = 8273,
        ["15426"] = 13419,
        ["15427"] = 8536,
        ["15428"] = 8024,
        ["15429"] = 9049,
        ["15430"] = 15435,
        ["15431"] = 19673,
        ["15432"] = 14104,
        ["15433"] = 21099,
        ["15434"] = 10588,
        ["15435"] = 16380,
        ["15436"] = 10519,
        ["15437"] = 12845,
        ["15438"] = 11039,
        ["15439"] = 16841,
        ["15440"] = 24707,
        ["15441"] = 16737,
        ["15442"] = 27433,
        ["15443"] = 1119,
        ["15444"] = 1404,
        ["15445"] = 1127,
        ["15448"] = 0,
        ["15449"] = 425,
        ["15450"] = 534,
        ["15451"] = 643,
        ["15452"] = 215,
        ["15453"] = 270,
        ["15454"] = 0,
        ["15455"] = 3541,
        ["15456"] = 4442,
        ["15457"] = 1134,
        ["15458"] = 1423,
        ["15459"] = 1142,
        ["15461"] = 841,
        ["15462"] = 653,
        ["15463"] = 787,
        ["15464"] = 4504,
        ["15465"] = 2713,
        ["15466"] = 2324,
        ["15467"] = 8630,
        ["15468"] = 1207,
        ["15469"] = 1009,
        ["1547"] = 2795,
        ["15470"] = 2432,
        ["15471"] = 2034,
        ["15472"] = 33,
        ["15473"] = 65,
        ["15474"] = 24,
        ["15475"] = 24,
        ["15476"] = 44,
        ["15477"] = 192,
        ["15478"] = 52,
        ["15479"] = 179,
        ["15480"] = 84,
        ["15481"] = 127,
        ["15482"] = 54,
        ["15483"] = 42,
        ["15484"] = 68,
        ["15485"] = 344,
        ["15486"] = 245,
        ["15487"] = 479,
        ["15488"] = 967,
        ["15489"] = 363,
        ["15490"] = 105,
        ["15491"] = 211,
        ["15492"] = 212,
        ["15493"] = 647,
        ["15494"] = 693,
        ["15495"] = 220,
        ["15496"] = 462,
        ["15497"] = 387,
        ["15498"] = 674,
        ["15499"] = 307,
        ["15500"] = 1378,
        ["15501"] = 269,
        ["15502"] = 411,
        ["15503"] = 1091,
        ["15504"] = 1168,
        ["15505"] = 561,
        ["15506"] = 723,
        ["15507"] = 364,
        ["15508"] = 365,
        ["15509"] = 485,
        ["15510"] = 423,
        ["15511"] = 1474,
        ["15512"] = 1578,
        ["15513"] = 1264,
        ["15514"] = 1902,
        ["15515"] = 845,
        ["15516"] = 1588,
        ["15517"] = 850,
        ["15518"] = 2825,
        ["15519"] = 607,
        ["15520"] = 879,
        ["15521"] = 1942,
        ["15522"] = 2516,
        ["15523"] = 1474,
        ["15524"] = 2876,
        ["15525"] = 1634,
        ["15526"] = 704,
        ["15527"] = 1020,
        ["15528"] = 931,
        ["15529"] = 2487,
        ["15530"] = 3222,
        ["15531"] = 2076,
        ["15532"] = 944,
        ["15533"] = 2290,
        ["15534"] = 2308,
        ["15535"] = 1270,
        ["15536"] = 4107,
        ["15537"] = 1163,
        ["15538"] = 1412,
        ["15539"] = 1282,
        ["15540"] = 2827,
        ["15541"] = 3441,
        ["15542"] = 2365,
        ["15543"] = 4179,
        ["15544"] = 2448,
        ["15545"] = 1348,
        ["15546"] = 4794,
        ["15547"] = 1234,
        ["15548"] = 1649,
        ["15549"] = 1504,
        ["15550"] = 3316,
        ["15551"] = 4438,
        ["15552"] = 5226,
        ["15553"] = 3061,
        ["15554"] = 1853,
        ["15555"] = 2802,
        ["15556"] = 1697,
        ["15557"] = 5486,
        ["15558"] = 4128,
        ["15559"] = 1450,
        ["15560"] = 1937,
        ["15561"] = 4705,
        ["15562"] = 3558,
        ["15563"] = 5562,
        ["15564"] = 1000,
        ["15565"] = 4274,
        ["15566"] = 2178,
        ["15567"] = 6666,
        ["15568"] = 1814,
        ["15569"] = 7162,
        ["1557"] = 919,
        ["15570"] = 2431,
        ["15571"] = 2218,
        ["15572"] = 4714,
        ["15573"] = 5840,
        ["15574"] = 5150,
        ["15575"] = 2300,
        ["15576"] = 4462,
        ["15577"] = 2317,
        ["15578"] = 6962,
        ["15579"] = 2122,
        ["15580"] = 4871,
        ["15581"] = 2794,
        ["15582"] = 6544,
        ["15583"] = 5344,
        ["15584"] = 7594,
        ["15585"] = 1447,
        ["15587"] = 1822,
        ["15588"] = 2194,
        ["15589"] = 5462,
        ["15590"] = 2674,
        ["15591"] = 8740,
        ["15592"] = 8465,
        ["15593"] = 5532,
        ["15594"] = 2520,
        ["15595"] = 2950,
        ["15596"] = 6909,
        ["15597"] = 5642,
        ["15598"] = 2763,
        ["15599"] = 6631,
        ["1560"] = 513,
        ["15600"] = 3787,
        ["15601"] = 10345,
        ["15602"] = 7211,
        ["15603"] = 3546,
        ["15604"] = 11158,
        ["15605"] = 3858,
        ["15606"] = 3585,
        ["15607"] = 9306,
        ["15608"] = 7035,
        ["15609"] = 11806,
        ["1561"] = 268,
        ["15610"] = 4354,
        ["15611"] = 4369,
        ["15612"] = 4285,
        ["15613"] = 3688,
        ["15614"] = 7026,
        ["15615"] = 7584,
        ["15616"] = 10151,
        ["15617"] = 7107,
        ["15618"] = 11782,
        ["15619"] = 5987,
        ["15620"] = 5564,
        ["15621"] = 15766,
        ["15622"] = 14834,
        ["15623"] = 10715,
        ["15624"] = 4971,
        ["15625"] = 5818,
        ["15626"] = 8798,
        ["15627"] = 14493,
        ["15628"] = 9570,
        ["15629"] = 6374,
        ["15630"] = 10312,
        ["15631"] = 16672,
        ["15632"] = 4997,
        ["15633"] = 16210,
        ["15634"] = 11441,
        ["15635"] = 5896,
        ["15636"] = 6333,
        ["15637"] = 14557,
        ["15638"] = 9615,
        ["15639"] = 7040,
        ["15640"] = 20233,
        ["15641"] = 7587,
        ["15642"] = 12162,
        ["15643"] = 6675,
        ["15644"] = 8130,
        ["15645"] = 14577,
        ["15646"] = 19507,
        ["15647"] = 13125,
        ["15648"] = 22212,
        ["15649"] = 7808,
        ["15650"] = 22230,
        ["15651"] = 15785,
        ["15652"] = 7139,
        ["15653"] = 8053,
        ["15654"] = 8569,
        ["15655"] = 19862,
        ["15656"] = 13366,
        ["15657"] = 22625,
        ["15658"] = 17851,
        ["15659"] = 9508,
        ["1566"] = 1132,
        ["15660"] = 25412,
        ["15661"] = 9036,
        ["15662"] = 10801,
        ["15663"] = 10226,
        ["15664"] = 19071,
        ["15665"] = 25520,
        ["15666"] = 18375,
        ["15667"] = 28785,
        ["15668"] = 11697,
        ["15669"] = 26609,
        ["15670"] = 19753,
        ["15671"] = 9782,
        ["15672"] = 12164,
        ["15673"] = 11075,
        ["15674"] = 18464,
        ["15675"] = 26976,
        ["15676"] = 25039,
        ["15677"] = 18933,
        ["15678"] = 19525,
        ["15679"] = 12658,
        ["15680"] = 26811,
        ["15681"] = 11406,
        ["15682"] = 13149,
        ["15683"] = 12666,
        ["15684"] = 20135,
        ["15685"] = 26587,
        ["15686"] = 20099,
        ["15687"] = 32494,
        ["15689"] = 4040,
        ["15690"] = 4912,
        ["15691"] = 6909,
        ["15692"] = 6935,
        ["15693"] = 14533,
        ["15694"] = 13264,
        ["15695"] = 5984,
        ["15696"] = 0,
        ["15697"] = 2826,
        ["15698"] = 4273,
        ["15699"] = 25,
        ["15702"] = 7396,
        ["15703"] = 9645,
        ["15704"] = 6145,
        ["15705"] = 33774,
        ["15706"] = 33905,
        ["15707"] = 7215,
        ["15708"] = 9053,
        ["15709"] = 12796,
        ["15710"] = 0,
        ["15722"] = 0,
        ["15723"] = 2825,
        ["15724"] = 3000,
        ["15725"] = 3000,
        ["15726"] = 3000,
        ["15727"] = 3000,
        ["15728"] = 3000,
        ["15729"] = 3000,
        ["15730"] = 3000,
        ["15731"] = 3500,
        ["15732"] = 3500,
        ["15733"] = 3500,
        ["15734"] = 3500,
        ["15735"] = 3500,
        ["15736"] = 0,
        ["15737"] = 4000,
        ["15738"] = 4000,
        ["15739"] = 4000,
        ["15740"] = 4000,
        ["15741"] = 4000,
        ["15742"] = 4000,
        ["15743"] = 5000,
        ["15744"] = 5000,
        ["15745"] = 5000,
        ["15746"] = 5000,
        ["15747"] = 5000,
        ["15748"] = 5000,
        ["15749"] = 5000,
        ["15750"] = 0,
        ["15751"] = 5000,
        ["15752"] = 5000,
        ["15753"] = 5000,
        ["15755"] = 5500,
        ["15756"] = 5500,
        ["15757"] = 5500,
        ["15758"] = 5500,
        ["15759"] = 5500,
        ["15760"] = 5500,
        ["15761"] = 6250,
        ["15762"] = 6250,
        ["15763"] = 6250,
        ["15764"] = 6250,
        ["15765"] = 7500,
        ["15766"] = 0,
        ["15767"] = 0,
        ["15768"] = 7500,
        ["15770"] = 7500,
        ["15771"] = 7500,
        ["15772"] = 7500,
        ["15773"] = 10000,
        ["15774"] = 10000,
        ["15775"] = 10000,
        ["15776"] = 10000,
        ["15777"] = 15000,
        ["15778"] = 1250,
        ["15779"] = 15000,
        ["15781"] = 15000,
        ["15782"] = 43142,
        ["15783"] = 43292,
        ["15784"] = 11541,
        ["15785"] = 0,
        ["15786"] = 19381,
        ["15787"] = 23343,
        ["15788"] = 0,
        ["15789"] = 9967,
        ["15790"] = 0,
        ["15791"] = 7521,
        ["15792"] = 14154,
        ["15793"] = 50,
        ["15794"] = 39,
        ["15795"] = 13431,
        ["15796"] = 12063,
        ["15797"] = 14206,
        ["15798"] = 50,
        ["15799"] = 7108,
        ["15800"] = 36082,
        ["15801"] = 36221,
        ["15802"] = 11648,
        ["15803"] = 0,
        ["15804"] = 9781,
        ["15805"] = 14662,
        ["15806"] = 49514,
        ["15807"] = 58,
        ["15808"] = 728,
        ["15809"] = 2938,
        ["15810"] = 2029,
        ["15811"] = 5426,
        ["15812"] = 10076,
        ["15813"] = 10113,
        ["15814"] = 41911,
        ["15815"] = 12619,
        ["15822"] = 11446,
        ["15823"] = 9191,
        ["15824"] = 15385,
        ["15825"] = 19302,
        ["15826"] = 0,
        ["15827"] = 22592,
        ["15842"] = 0,
        ["15843"] = 0,
        ["15844"] = 0,
        ["15845"] = 0,
        ["15846"] = 7500,
        ["15847"] = 0,
        ["15848"] = 0,
        ["15849"] = 0,
        ["15851"] = 0,
        ["15852"] = 0,
        ["15853"] = 51418,
        ["15854"] = 64502,
        ["15855"] = 7888,
        ["15856"] = 8788,
        ["15857"] = 15335,
        ["15858"] = 7516,
        ["15859"] = 11317,
        ["15860"] = 13997,
        ["15861"] = 14969,
        ["15862"] = 28789,
        ["15863"] = 28896,
        ["15864"] = 2043,
        ["15865"] = 6562,
        ["15866"] = 562,
        ["15867"] = 7464,
        ["15869"] = 50,
        ["15870"] = 300,
        ["15871"] = 625,
        ["15872"] = 625,
        ["15873"] = 8144,
        ["15874"] = 0,
        ["15877"] = 0,
        ["15878"] = 0,
        ["15879"] = 0,
        ["15881"] = 0,
        ["15882"] = 0,
        ["15883"] = 0,
        ["15884"] = 0,
        ["15885"] = 0,
        ["15887"] = 27581,
        ["15890"] = 25831,
        ["15891"] = 2014,
        ["15892"] = 3582,
        ["15893"] = 1082,
        ["15894"] = 1802,
        ["15895"] = 53,
        ["159"] = 1,
        ["15902"] = 20000,
        ["15903"] = 1623,
        ["15904"] = 4341,
        ["15905"] = 426,
        ["15906"] = 427,
        ["15907"] = 1647,
        ["15909"] = 4421,
        ["15912"] = 1148,
        ["15918"] = 4848,
        ["15921"] = 0,
        ["15924"] = 0,
        ["15925"] = 439,
        ["15926"] = 802,
        ["15927"] = 1864,
        ["15928"] = 2387,
        ["15929"] = 4396,
        ["15930"] = 9146,
        ["15931"] = 10646,
        ["15932"] = 527,
        ["15933"] = 620,
        ["15934"] = 2596,
        ["15935"] = 3323,
        ["15936"] = 8950,
        ["15937"] = 7922,
        ["15938"] = 9550,
        ["15939"] = 10455,
        ["15940"] = 10957,
        ["15941"] = 12345,
        ["15942"] = 12757,
        ["15943"] = 26800,
        ["15944"] = 512,
        ["15945"] = 837,
        ["15946"] = 802,
        ["15947"] = 1887,
        ["1596"] = 0,
        ["15962"] = 2716,
        ["15963"] = 4887,
        ["15964"] = 6364,
        ["15965"] = 7996,
        ["15966"] = 9137,
        ["15967"] = 10304,
        ["15969"] = 425,
        ["15970"] = 587,
        ["15971"] = 1064,
        ["15972"] = 1171,
        ["15973"] = 2313,
        ["15974"] = 1461,
        ["15975"] = 2421,
        ["15976"] = 4146,
        ["15977"] = 4614,
        ["15978"] = 5385,
        ["15979"] = 7215,
        ["1598"] = 0,
        ["15980"] = 7469,
        ["15981"] = 7215,
        ["15982"] = 8142,
        ["15983"] = 8387,
        ["15984"] = 9614,
        ["15985"] = 9887,
        ["15986"] = 10813,
        ["15987"] = 10996,
        ["15988"] = 12471,
        ["15989"] = 12498,
        ["15990"] = 6850,
        ["15991"] = 26309,
        ["15992"] = 250,
        ["15993"] = 1500,
        ["15994"] = 2500,
        ["15995"] = 19739,
        ["15996"] = 2500,
        ["15997"] = 10,
        ["15998"] = 0,
        ["15999"] = 9003,
        ["16000"] = 3750,
        ["16001"] = 0,
        ["16002"] = 0,
        ["16003"] = 0,
        ["16004"] = 29152,
        ["16005"] = 1250,
        ["16006"] = 10000,
        ["16007"] = 39231,
        ["16008"] = 11739,
        ["16009"] = 5930,
        ["1602"] = 11685,
        ["16022"] = 40000,
        ["16023"] = 10000,
        ["16039"] = 53598,
        ["1604"] = 19464,
        ["16040"] = 4000,
        ["16041"] = 3000,
        ["16042"] = 3000,
        ["16043"] = 3000,
        ["16044"] = 4000,
        ["16045"] = 4000,
        ["16046"] = 4000,
        ["16047"] = 4000,
        ["16048"] = 4000,
        ["16049"] = 5000,
        ["16050"] = 5000,
        ["16051"] = 5000,
        ["16052"] = 5000,
        ["16053"] = 5000,
        ["16054"] = 6000,
        ["16055"] = 6000,
        ["16056"] = 6000,
        ["16058"] = 10156,
        ["16059"] = 100,
        ["16060"] = 100,
        ["1607"] = 43420,
        ["16072"] = 2500,
        ["1608"] = 18940,
        ["16083"] = 2500,
        ["16084"] = 2500,
        ["16110"] = 3000,
        ["16111"] = 3000,
        ["16112"] = 550,
        ["16113"] = 1250,
        ["16114"] = 0,
        ["16115"] = 0,
        ["1613"] = 19139,
        ["16166"] = 1,
        ["16167"] = 6,
        ["16168"] = 100,
        ["16169"] = 62,
        ["16170"] = 25,
        ["16171"] = 200,
        ["16189"] = 0,
        ["16190"] = 0,
        ["16192"] = 0,
        ["16202"] = 0,
        ["16203"] = 0,
        ["16204"] = 0,
        ["16205"] = 0,
        ["16206"] = 1000,
        ["16207"] = 1250,
        ["16208"] = 0,
        ["16209"] = 0,
        ["16210"] = 0,
        ["16214"] = 3000,
        ["16215"] = 3000,
        ["16216"] = 3000,
        ["16217"] = 3000,
        ["16218"] = 3500,
        ["16219"] = 3500,
        ["16220"] = 4000,
        ["16221"] = 4000,
        ["16222"] = 5000,
        ["16223"] = 5000,
        ["16224"] = 5000,
        ["1624"] = 6172,
        ["16242"] = 5500,
        ["16243"] = 5500,
        ["16244"] = 6000,
        ["16245"] = 6000,
        ["16246"] = 6000,
        ["16247"] = 6000,
        ["16248"] = 6000,
        ["16249"] = 7500,
        ["1625"] = 14754,
        ["16250"] = 7500,
        ["16251"] = 7500,
        ["16252"] = 7500,
        ["16253"] = 7500,
        ["16254"] = 7500,
        ["16255"] = 7500,
        ["16262"] = 0,
        ["16263"] = 0,
        ["16282"] = 0,
        ["16283"] = 0,
        ["1630"] = 66,
        ["16302"] = 25,
        ["16303"] = 0,
        ["16304"] = 0,
        ["16305"] = 0,
        ["16306"] = 0,
        ["16307"] = 0,
        ["16309"] = 0,
        ["16310"] = 0,
        ["16311"] = 0,
        ["16312"] = 0,
        ["16313"] = 0,
        ["16314"] = 0,
        ["16316"] = 375,
        ["16317"] = 1250,
        ["16318"] = 2500,
        ["16319"] = 3500,
        ["16320"] = 6000,
        ["16321"] = 25,
        ["16322"] = 225,
        ["16323"] = 1000,
        ["16324"] = 2500,
        ["16325"] = 3750,
        ["16326"] = 225,
        ["16327"] = 750,
        ["16328"] = 2000,
        ["16329"] = 3000,
        ["16330"] = 5000,
        ["16331"] = 150,
        ["16332"] = 0,
        ["16333"] = 0,
        ["16335"] = 10000,
        ["16341"] = 4285,
        ["16342"] = 8830,
        ["16345"] = 49483,
        ["16346"] = 500,
        ["16347"] = 1500,
        ["16348"] = 2750,
        ["16349"] = 3750,
        ["16350"] = 6500,
        ["16351"] = 300,
        ["16352"] = 750,
        ["16353"] = 1750,
        ["16354"] = 2750,
        ["16355"] = 3500,
        ["16356"] = 5500,
        ["16357"] = 375,
        ["16358"] = 1000,
        ["16359"] = 2000,
        ["16360"] = 2750,
        ["16361"] = 3750,
        ["16362"] = 6000,
        ["16363"] = 750,
        ["16364"] = 2250,
        ["16365"] = 3500,
        ["16366"] = 6500,
        ["16368"] = 1250,
        ["16369"] = 7575,
        ["1637"] = 0,
        ["16371"] = 2250,
        ["16372"] = 3000,
        ["16373"] = 4500,
        ["16374"] = 6500,
        ["16375"] = 625,
        ["16376"] = 2000,
        ["16377"] = 3250,
        ["16378"] = 6000,
        ["16379"] = 1000,
        ["16380"] = 1750,
        ["16381"] = 2500,
        ["16382"] = 3250,
        ["16383"] = 5000,
        ["16384"] = 1750,
        ["16385"] = 2750,
        ["16386"] = 3500,
        ["16387"] = 5500,
        ["16388"] = 2250,
        ["16389"] = 4500,
        ["1639"] = 28460,
        ["16390"] = 2750,
        ["16391"] = 5087,
        ["16392"] = 9574,
        ["16393"] = 9609,
        ["16396"] = 6650,
        ["16397"] = 6673,
        ["1640"] = 15637,
        ["16401"] = 12237,
        ["16403"] = 7401,
        ["16405"] = 13027,
        ["16406"] = 8785,
        ["16409"] = 13227,
        ["16410"] = 8919,
        ["16413"] = 11692,
        ["16414"] = 10562,
        ["16415"] = 7950,
        ["16416"] = 7978,
        ["16417"] = 13345,
        ["16418"] = 10045,
        ["16419"] = 13441,
        ["16420"] = 10116,
        ["16421"] = 13536,
        ["16422"] = 13583,
        ["16423"] = 9251,
        ["16424"] = 9286,
        ["16425"] = 14915,
        ["16426"] = 14972,
        ["16427"] = 11632,
        ["16428"] = 11623,
        ["16429"] = 13585,
        ["16430"] = 18215,
        ["16431"] = 18281,
        ["16432"] = 13734,
        ["16433"] = 18415,
        ["16434"] = 13835,
        ["16435"] = 18547,
        ["16436"] = 13934,
        ["16437"] = 13076,
        ["16440"] = 8810,
        ["16441"] = 13263,
        ["16442"] = 17745,
        ["16443"] = 16561,
        ["16444"] = 12468,
        ["16446"] = 15701,
        ["16448"] = 10545,
        ["16449"] = 15877,
        ["1645"] = 100,
        ["16450"] = 21246,
        ["16451"] = 15993,
        ["16452"] = 21402,
        ["16453"] = 21481,
        ["16454"] = 10778,
        ["16455"] = 16226,
        ["16456"] = 21713,
        ["16457"] = 16342,
        ["16459"] = 15291,
        ["16462"] = 18642,
        ["16463"] = 12420,
        ["16465"] = 18769,
        ["16466"] = 25119,
        ["16467"] = 25213,
        ["16468"] = 19065,
        ["16471"] = 8528,
        ["16472"] = 12839,
        ["16473"] = 17181,
        ["16474"] = 12933,
        ["16475"] = 17755,
        ["16476"] = 12091,
        ["16477"] = 16184,
        ["16478"] = 12185,
        ["16479"] = 16309,
        ["16480"] = 12277,
        ["16483"] = 12418,
        ["16484"] = 8309,
        ["16485"] = 7660,
        ["16486"] = 5695,
        ["16487"] = 5145,
        ["16489"] = 7774,
        ["16490"] = 10404,
        ["16491"] = 10716,
        ["16492"] = 8066,
        ["16494"] = 10154,
        ["16496"] = 6168,
        ["16497"] = 6880,
        ["16498"] = 9325,
        ["16499"] = 6240,
        ["16501"] = 9431,
        ["16502"] = 12623,
        ["16503"] = 9502,
        ["16504"] = 12718,
        ["16505"] = 12766,
        ["16506"] = 9609,
        ["16507"] = 9903,
        ["16508"] = 13252,
        ["16509"] = 13938,
        ["16510"] = 5931,
        ["16513"] = 18886,
        ["16514"] = 14187,
        ["16515"] = 19019,
        ["16516"] = 12928,
        ["16518"] = 11237,
        ["16519"] = 7487,
        ["1652"] = 5000,
        ["16521"] = 11316,
        ["16522"] = 15145,
        ["16523"] = 15615,
        ["16524"] = 11806,
        ["16525"] = 15728,
        ["16526"] = 11839,
        ["16527"] = 15843,
        ["16528"] = 11978,
        ["16530"] = 8007,
        ["16531"] = 12107,
        ["16532"] = 8960,
        ["16533"] = 13217,
        ["16534"] = 17686,
        ["16535"] = 17748,
        ["16536"] = 12087,
        ["16539"] = 12563,
        ["16540"] = 8406,
        ["16541"] = 16875,
        ["16542"] = 10915,
        ["16543"] = 17000,
        ["16544"] = 12795,
        ["16545"] = 12842,
        ["16548"] = 8492,
        ["16549"] = 21716,
        ["16550"] = 16345,
        ["16551"] = 16404,
        ["16552"] = 21948,
        ["16554"] = 16579,
        ["16555"] = 10312,
        ["16558"] = 15644,
        ["1656"] = 0,
        ["16560"] = 10506,
        ["16561"] = 15818,
        ["16562"] = 15877,
        ["16563"] = 21246,
        ["16564"] = 21324,
        ["16565"] = 25683,
        ["16566"] = 19333,
        ["16567"] = 25868,
        ["16568"] = 19558,
        ["16569"] = 19629,
        ["16571"] = 12186,
        ["16573"] = 18502,
        ["16574"] = 12326,
        ["16577"] = 24934,
        ["16578"] = 18769,
        ["16579"] = 25119,
        ["16580"] = 18994,
        ["16581"] = 0,
        ["16583"] = 2500,
        ["1659"] = 2136,
        ["16603"] = 0,
        ["16604"] = 17,
        ["16605"] = 17,
        ["16606"] = 17,
        ["16607"] = 17,
        ["16608"] = 213,
        ["16622"] = 27307,
        ["16623"] = 7783,
        ["1664"] = 14695,
        ["16642"] = 0,
        ["16643"] = 0,
        ["16645"] = 62,
        ["16646"] = 62,
        ["16647"] = 62,
        ["16648"] = 62,
        ["16649"] = 62,
        ["16650"] = 62,
        ["16651"] = 62,
        ["16652"] = 62,
        ["16653"] = 62,
        ["16654"] = 62,
        ["16655"] = 62,
        ["16656"] = 62,
        ["16658"] = 1649,
        ["16659"] = 856,
        ["16660"] = 2200,
        ["16661"] = 1035,
        ["16662"] = 0,
        ["16663"] = 0,
        ["16665"] = 0,
        ["16666"] = 32368,
        ["16667"] = 24035,
        ["16668"] = 29493,
        ["16669"] = 21995,
        ["16670"] = 21027,
        ["16671"] = 12586,
        ["16672"] = 14059,
        ["16673"] = 13440,
        ["16674"] = 30993,
        ["16675"] = 21421,
        ["16676"] = 14268,
        ["16677"] = 23186,
        ["16678"] = 30607,
        ["16679"] = 22822,
        ["16680"] = 13788,
        ["16681"] = 13055,
        ["16682"] = 14582,
        ["16683"] = 8765,
        ["16684"] = 9093,
        ["16685"] = 8694,
        ["16686"] = 14836,
        ["16687"] = 19585,
        ["16688"] = 20202,
        ["16689"] = 14597,
        ["16690"] = 20355,
        ["16691"] = 14005,
        ["16692"] = 9372,
        ["16693"] = 15230,
        ["16694"] = 20106,
        ["16695"] = 14925,
        ["16696"] = 9058,
        ["16697"] = 8577,
        ["16698"] = 15511,
        ["16699"] = 20475,
        ["16700"] = 21665,
        ["16701"] = 15650,
        ["16702"] = 8593,
        ["16703"] = 8138,
        ["16704"] = 13639,
        ["16705"] = 9127,
        ["16706"] = 25058,
        ["16707"] = 18612,
        ["16708"] = 18175,
        ["16709"] = 24666,
        ["16710"] = 10446,
        ["16711"] = 17505,
        ["16712"] = 11714,
        ["16713"] = 11197,
        ["16714"] = 10602,
        ["16715"] = 17766,
        ["16716"] = 11621,
        ["16717"] = 12244,
        ["16718"] = 19354,
        ["16719"] = 26260,
        ["16720"] = 20037,
        ["16721"] = 27173,
        ["16722"] = 14266,
        ["16723"] = 15180,
        ["16724"] = 16001,
        ["16725"] = 23910,
        ["16726"] = 35078,
        ["16727"] = 26005,
        ["16728"] = 34398,
        ["16729"] = 25488,
        ["16730"] = 35611,
        ["16731"] = 26399,
        ["16732"] = 35849,
        ["16733"] = 26562,
        ["16734"] = 25389,
        ["16735"] = 15379,
        ["16736"] = 16359,
        ["16737"] = 17239,
        ["16738"] = 4235,
        ["16739"] = 7969,
        ["16740"] = 1032,
        ["16741"] = 1295,
        ["16742"] = 0,
        ["16743"] = 0,
        ["16744"] = 0,
        ["16745"] = 0,
        ["16746"] = 0,
        ["16747"] = 27,
        ["16748"] = 15,
        ["16762"] = 0,
        ["16763"] = 0,
        ["16764"] = 0,
        ["16765"] = 0,
        ["16766"] = 100,
        ["16767"] = 750,
        ["16768"] = 37500,
        ["16769"] = 26616,
        ["1677"] = 10093,
        ["1678"] = 4581,
        ["16782"] = 0,
        ["16783"] = 0,
        ["16784"] = 0,
        ["16785"] = 0,
        ["16786"] = 0,
        ["16787"] = 0,
        ["16788"] = 5095,
        ["16789"] = 5992,
        ["1679"] = 9635,
        ["16790"] = 0,
        ["16791"] = 1912,
        ["16793"] = 4353,
        ["16794"] = 2899,
        ["16795"] = 22128,
        ["16796"] = 27491,
        ["16797"] = 20698,
        ["16798"] = 27704,
        ["16799"] = 13905,
        ["1680"] = 18234,
        ["16800"] = 20935,
        ["16801"] = 14010,
        ["16802"] = 14063,
        ["16803"] = 21174,
        ["16804"] = 14168,
        ["16805"] = 14221,
        ["16806"] = 14274,
        ["16807"] = 21491,
        ["16808"] = 21569,
        ["16809"] = 28865,
        ["16810"] = 28972,
        ["16811"] = 21806,
        ["16812"] = 14591,
        ["16813"] = 22537,
        ["16814"] = 30156,
        ["16815"] = 27382,
        ["16816"] = 20616,
        ["16817"] = 13797,
        ["16818"] = 15636,
        ["16819"] = 13902,
        ["16820"] = 34888,
        ["16821"] = 26266,
        ["16822"] = 35154,
        ["16823"] = 26463,
        ["16824"] = 26562,
        ["16825"] = 17775,
        ["16826"] = 17839,
        ["16827"] = 17906,
        ["16828"] = 17972,
        ["16829"] = 27773,
        ["16830"] = 18580,
        ["16831"] = 18646,
        ["16832"] = 31689,
        ["16833"] = 37559,
        ["16834"] = 28266,
        ["16835"] = 34223,
        ["16836"] = 25767,
        ["16837"] = 31178,
        ["16838"] = 20771,
        ["16839"] = 20851,
        ["16840"] = 20931,
        ["16841"] = 42021,
        ["16842"] = 31632,
        ["16843"] = 42336,
        ["16844"] = 32013,
        ["16845"] = 43794,
        ["16846"] = 32965,
        ["16847"] = 44113,
        ["16848"] = 33352,
        ["16849"] = 33469,
        ["1685"] = 6250,
        ["16850"] = 22294,
        ["16851"] = 22373,
        ["16852"] = 22453,
        ["16853"] = 52573,
        ["16854"] = 39494,
        ["16855"] = 47908,
        ["16856"] = 36002,
        ["16857"] = 24275,
        ["16858"] = 24369,
        ["16859"] = 36416,
        ["1686"] = 733,
        ["16860"] = 24554,
        ["16861"] = 25318,
        ["16862"] = 37829,
        ["16863"] = 25505,
        ["16864"] = 25596,
        ["16865"] = 51088,
        ["16866"] = 38382,
        ["16867"] = 51461,
        ["16868"] = 38657,
        ["16869"] = 0,
        ["1687"] = 243,
        ["16870"] = 0,
        ["16871"] = 0,
        ["16872"] = 0,
        ["16873"] = 2469,
        ["1688"] = 806,
        ["16882"] = 0,
        ["16883"] = 0,
        ["16884"] = 0,
        ["16885"] = 0,
        ["16886"] = 5492,
        ["16887"] = 1988,
        ["16889"] = 3093,
        ["16890"] = 2483,
        ["16891"] = 1697,
        ["16892"] = 0,
        ["16893"] = 0,
        ["16894"] = 1993,
        ["16895"] = 0,
        ["16896"] = 0,
        ["16897"] = 39996,
        ["16898"] = 30106,
        ["16899"] = 20146,
        ["16900"] = 30331,
        ["16901"] = 40592,
        ["16902"] = 30554,
        ["16903"] = 20444,
        ["16904"] = 20519,
        ["16905"] = 41189,
        ["16906"] = 31001,
        ["16907"] = 20742,
        ["16908"] = 31226,
        ["16909"] = 38795,
        ["16910"] = 19472,
        ["16911"] = 19547,
        ["16912"] = 23547,
        ["16913"] = 15756,
        ["16914"] = 23725,
        ["16915"] = 31753,
        ["16916"] = 31873,
        ["16917"] = 23992,
        ["16918"] = 16055,
        ["16919"] = 24173,
        ["16920"] = 16175,
        ["16921"] = 24350,
        ["16922"] = 32587,
        ["16923"] = 32707,
        ["16924"] = 24618,
        ["16925"] = 16902,
        ["16926"] = 16962,
        ["16927"] = 25533,
        ["16928"] = 15456,
        ["16929"] = 23274,
        ["16930"] = 31152,
        ["16931"] = 31273,
        ["16932"] = 23542,
        ["16933"] = 15755,
        ["16934"] = 15815,
        ["16935"] = 23812,
        ["16936"] = 23900,
        ["16937"] = 36145,
        ["16938"] = 48160,
        ["16939"] = 36252,
        ["16940"] = 24258,
        ["16941"] = 37656,
        ["16942"] = 50167,
        ["16943"] = 25171,
        ["16944"] = 25261,
        ["16945"] = 38196,
        ["16946"] = 50882,
        ["16947"] = 38293,
        ["16948"] = 23182,
        ["16949"] = 35063,
        ["16950"] = 46724,
        ["16951"] = 27514,
        ["16952"] = 27620,
        ["16953"] = 41273,
        ["16954"] = 55341,
        ["16955"] = 41584,
        ["16956"] = 28040,
        ["16957"] = 43025,
        ["16958"] = 57681,
        ["16959"] = 29111,
        ["1696"] = 606,
        ["16960"] = 29217,
        ["16961"] = 43651,
        ["16962"] = 58516,
        ["16963"] = 43961,
        ["16964"] = 29637,
        ["16965"] = 44276,
        ["16966"] = 59351,
        ["16967"] = 0,
        ["16968"] = 0,
        ["16969"] = 0,
        ["1697"] = 445,
        ["16970"] = 0,
        ["16971"] = 300,
        ["16973"] = 0,
        ["16974"] = 0,
        ["16975"] = 813,
        ["16976"] = 0,
        ["16977"] = 1536,
        ["16978"] = 1233,
        ["16979"] = 13894,
        ["16980"] = 20632,
        ["16981"] = 292,
        ["16982"] = 24397,
        ["16983"] = 25709,
        ["16984"] = 31533,
        ["16985"] = 847,
        ["16986"] = 850,
        ["16987"] = 884,
        ["16988"] = 29333,
        ["16989"] = 18610,
        ["16990"] = 998,
        ["16991"] = 0,
        ["16992"] = 30874,
        ["16993"] = 30989,
        ["16994"] = 10368,
        ["16995"] = 15609,
        ["16996"] = 38648,
        ["16997"] = 38790,
        ["16998"] = 33222,
        ["16999"] = 10709,
        ["17001"] = 10314,
        ["17002"] = 43287,
        ["17003"] = 43439,
        ["17004"] = 54493,
        ["17005"] = 1632,
        ["17006"] = 1966,
        ["17007"] = 11697,
        ["17008"] = 0,
        ["17009"] = 0,
        ["1701"] = 376,
        ["17010"] = 2000,
        ["17011"] = 2000,
        ["17012"] = 1000,
        ["17013"] = 46272,
        ["17014"] = 22242,
        ["17015"] = 63738,
        ["17016"] = 53627,
        ["17017"] = 45000,
        ["17018"] = 20000,
        ["1702"] = 320,
        ["17020"] = 250,
        ["17021"] = 175,
        ["17022"] = 37500,
        ["17023"] = 40000,
        ["17025"] = 40000,
        ["17026"] = 250,
        ["17028"] = 175,
        ["17029"] = 250,
        ["1703"] = 81,
        ["17030"] = 500,
        ["17031"] = 250,
        ["17032"] = 500,
        ["17033"] = 500,
        ["17034"] = 50,
        ["17035"] = 100,
        ["17036"] = 200,
        ["17037"] = 350,
        ["17038"] = 500,
        ["17039"] = 8317,
        ["17042"] = 5706,
        ["17043"] = 3055,
        ["17044"] = 15038,
        ["17045"] = 14846,
        ["17046"] = 4796,
        ["17047"] = 1313,
        ["17048"] = 400,
        ["17049"] = 22500,
        ["1705"] = 600,
        ["17050"] = 12536,
        ["17051"] = 17500,
        ["17052"] = 45000,
        ["17053"] = 50000,
        ["17054"] = 28788,
        ["17055"] = 28892,
        ["17056"] = 7,
        ["17057"] = 7,
        ["17058"] = 7,
        ["17059"] = 55000,
        ["1706"] = 86,
        ["17060"] = 55000,
        ["17061"] = 12888,
        ["17062"] = 550,
        ["17063"] = 23961,
        ["17064"] = 45914,
        ["17065"] = 33381,
        ["17066"] = 45228,
        ["17067"] = 75452,
        ["17068"] = 78453,
        ["17069"] = 54968,
        ["1707"] = 62,
        ["17070"] = 76483,
        ["17071"] = 75814,
        ["17072"] = 57776,
        ["17073"] = 91903,
        ["17074"] = 88668,
        ["17075"] = 81686,
        ["17076"] = 106067,
        ["17077"] = 53771,
        ["17078"] = 24190,
        ["1708"] = 50,
        ["17082"] = 46146,
        ["1710"] = 125,
        ["17102"] = 23363,
        ["17103"] = 75431,
        ["17104"] = 100375,
        ["17105"] = 74149,
        ["17106"] = 51180,
        ["17107"] = 23523,
        ["17109"] = 33625,
        ["1711"] = 75,
        ["17110"] = 24648,
        ["17111"] = 34648,
        ["17112"] = 73242,
        ["17113"] = 93061,
        ["17114"] = 0,
        ["17117"] = 0,
        ["17118"] = 0,
        ["17119"] = 6,
        ["1712"] = 62,
        ["17124"] = 0,
        ["17125"] = 0,
        ["17126"] = 0,
        ["1713"] = 5350,
        ["1714"] = 2535,
        ["1715"] = 10301,
        ["1716"] = 5067,
        ["1717"] = 3108,
        ["1718"] = 8040,
        ["17182"] = 160402,
        ["17183"] = 7,
        ["17184"] = 7,
        ["17185"] = 52,
        ["17186"] = 52,
        ["17187"] = 232,
        ["17188"] = 489,
        ["17189"] = 2610,
        ["17190"] = 7529,
        ["17191"] = 0,
        ["17192"] = 964,
        ["17193"] = 95427,
        ["17194"] = 0,
        ["17196"] = 12,
        ["17197"] = 10,
        ["17198"] = 9,
        ["1720"] = 26209,
        ["17200"] = 6,
        ["17201"] = 60,
        ["17202"] = 0,
        ["17203"] = 100000,
        ["17204"] = 200000,
        ["1721"] = 35815,
        ["1722"] = 19407,
        ["17222"] = 300,
        ["17223"] = 87372,
        ["17224"] = 11273,
        ["1725"] = 5000,
        ["1726"] = 12183,
        ["1727"] = 4562,
        ["1728"] = 72936,
        ["1729"] = 500,
        ["1730"] = 48,
        ["17303"] = 2,
        ["17304"] = 2,
        ["17306"] = 0,
        ["17307"] = 2,
        ["17309"] = 0,
        ["1731"] = 92,
        ["17310"] = 0,
        ["1732"] = 73,
        ["17322"] = 0,
        ["17326"] = 0,
        ["17327"] = 0,
        ["17328"] = 0,
        ["17329"] = 0,
        ["1733"] = 88,
        ["17330"] = 0,
        ["17331"] = 0,
        ["17332"] = 0,
        ["17333"] = 0,
        ["1734"] = 39,
        ["17344"] = 1,
        ["17345"] = 0,
        ["17346"] = 0,
        ["17348"] = 250,
        ["17349"] = 125,
        ["1735"] = 89,
        ["17351"] = 250,
        ["17352"] = 125,
        ["17355"] = 0,
        ["1737"] = 139,
        ["1738"] = 147,
        ["1739"] = 255,
        ["1740"] = 97,
        ["17402"] = 500,
        ["17403"] = 37,
        ["17404"] = 6,
        ["17405"] = 50,
        ["17406"] = 6,
        ["17407"] = 50,
        ["17408"] = 100,
        ["1741"] = 112,
        ["17410"] = 0,
        ["17411"] = 0,
        ["17413"] = 7750,
        ["17414"] = 14750,
        ["1742"] = 129,
        ["17422"] = 2,
        ["17423"] = 0,
        ["1743"] = 299,
        ["1744"] = 260,
        ["17442"] = 2,
        ["1745"] = 198,
        ["1746"] = 332,
        ["1747"] = 302,
        ["1748"] = 232,
        ["1749"] = 263,
        ["1750"] = 298,
        ["17502"] = 0,
        ["17503"] = 0,
        ["17504"] = 0,
        ["17507"] = 0,
        ["17508"] = 7880,
        ["1751"] = 676,
        ["1752"] = 286,
        ["17522"] = 2,
        ["17523"] = 11453,
        ["1753"] = 439,
        ["1754"] = 359,
        ["17542"] = 2,
        ["1755"] = 597,
        ["1756"] = 438,
        ["17562"] = 7863,
        ["17564"] = 5280,
        ["17566"] = 7977,
        ["17567"] = 10675,
        ["17568"] = 9949,
        ["17569"] = 7491,
        ["1757"] = 483,
        ["17570"] = 7519,
        ["17571"] = 10064,
        ["17572"] = 10102,
        ["17573"] = 7605,
        ["17576"] = 7690,
        ["17577"] = 5146,
        ["17578"] = 12655,
        ["17579"] = 16936,
        ["1758"] = 534,
        ["17580"] = 12747,
        ["17581"] = 17059,
        ["17583"] = 12887,
        ["17584"] = 8847,
        ["17586"] = 12093,
        ["17588"] = 8124,
        ["1759"] = 732,
        ["17590"] = 12280,
        ["17591"] = 12326,
        ["17592"] = 16497,
        ["17593"] = 16560,
        ["17594"] = 7633,
        ["17596"] = 5126,
        ["17598"] = 7746,
        ["17599"] = 10367,
        ["1760"] = 609,
        ["17600"] = 10680,
        ["17601"] = 8039,
        ["17602"] = 13175,
        ["17603"] = 17630,
        ["17604"] = 13269,
        ["17605"] = 17755,
        ["17607"] = 12138,
        ["17608"] = 8123,
        ["1761"] = 892,
        ["17610"] = 7517,
        ["17611"] = 10061,
        ["17612"] = 10100,
        ["17613"] = 7603,
        ["17616"] = 7895,
        ["17617"] = 5282,
        ["17620"] = 8721,
        ["17622"] = 13174,
        ["17623"] = 13221,
        ["17624"] = 17691,
        ["17625"] = 17752,
        ["1764"] = 113,
        ["17642"] = 0,
        ["17643"] = 0,
        ["1766"] = 131,
        ["17662"] = 0,
        ["1767"] = 101,
        ["1768"] = 217,
        ["17682"] = 8750,
        ["17683"] = 14750,
        ["17684"] = 0,
        ["17685"] = 0,
        ["17686"] = 10192,
        ["17687"] = 10231,
        ["17688"] = 5695,
        ["1769"] = 163,
        ["17690"] = 0,
        ["17691"] = 2,
        ["17692"] = 881,
        ["17693"] = 0,
        ["17694"] = 881,
        ["17695"] = 702,
        ["17696"] = 0,
        ["1770"] = 143,
        ["17702"] = 0,
        ["17703"] = 0,
        ["17704"] = 9178,
        ["17705"] = 32854,
        ["17706"] = 950,
        ["17707"] = 11631,
        ["17708"] = 35,
        ["17709"] = 500,
        ["17710"] = 35483,
        ["17711"] = 24928,
        ["17712"] = 0,
        ["17713"] = 14641,
        ["17714"] = 11086,
        ["17715"] = 11125,
        ["17716"] = 7500,
        ["17717"] = 26426,
        ["17718"] = 22630,
        ["17719"] = 32106,
        ["1772"] = 247,
        ["17720"] = 600,
        ["17721"] = 2268,
        ["17722"] = 700,
        ["17723"] = 750,
        ["17724"] = 375,
        ["17725"] = 750,
        ["17726"] = 0,
        ["17727"] = 0,
        ["17728"] = 12458,
        ["17730"] = 42952,
        ["17732"] = 10383,
        ["17733"] = 34735,
        ["17734"] = 18265,
        ["17735"] = 0,
        ["17736"] = 10532,
        ["17737"] = 10163,
        ["17738"] = 33351,
        ["17739"] = 9085,
        ["1774"] = 281,
        ["17740"] = 11401,
        ["17741"] = 11516,
        ["17742"] = 14450,
        ["17743"] = 40748,
        ["17744"] = 9031,
        ["17745"] = 22520,
        ["17746"] = 10608,
        ["17747"] = 500,
        ["17748"] = 9107,
        ["17749"] = 11425,
        ["1775"] = 212,
        ["17750"] = 5096,
        ["17751"] = 12787,
        ["17752"] = 28785,
        ["17753"] = 26046,
        ["17754"] = 17394,
        ["17755"] = 5818,
        ["17756"] = 0,
        ["17757"] = 0,
        ["17758"] = 0,
        ["17759"] = 10307,
        ["1776"] = 257,
        ["17760"] = 0,
        ["17761"] = 0,
        ["17762"] = 0,
        ["17763"] = 0,
        ["17764"] = 0,
        ["17765"] = 0,
        ["17766"] = 44863,
        ["17767"] = 13610,
        ["17768"] = 7891,
        ["1777"] = 222,
        ["17770"] = 6778,
        ["17771"] = 100000,
        ["17772"] = 7132,
        ["17773"] = 7132,
        ["17774"] = 6133,
        ["17775"] = 7841,
        ["17776"] = 7377,
        ["17777"] = 11011,
        ["17778"] = 4605,
        ["17779"] = 9689,
        ["1778"] = 337,
        ["17780"] = 46796,
        ["17781"] = 0,
        ["1780"] = 489,
        ["1782"] = 542,
        ["1783"] = 247,
        ["1784"] = 546,
        ["17849"] = 0,
        ["1785"] = 464,
        ["1786"] = 683,
        ["1787"] = 102,
        ["1788"] = 177,
        ["1789"] = 136,
        ["1790"] = 93,
        ["17900"] = 2,
        ["17901"] = 0,
        ["17902"] = 2,
        ["17903"] = 2,
        ["17904"] = 2,
        ["17905"] = 0,
        ["17906"] = 0,
        ["17907"] = 0,
        ["17908"] = 750,
        ["17909"] = 0,
        ["1791"] = 90,
        ["1792"] = 208,
        ["17922"] = 125,
        ["1793"] = 207,
        ["1794"] = 277,
        ["17943"] = 35234,
        ["1795"] = 235,
        ["1796"] = 400,
        ["17962"] = 4762,
        ["17963"] = 213,
        ["17964"] = 5512,
        ["17965"] = 213,
        ["17966"] = 8750,
        ["17969"] = 4773,
        ["1797"] = 161,
        ["1798"] = 279,
        ["1799"] = 211,
        ["1800"] = 479,
        ["1801"] = 418,
        ["1802"] = 337,
        ["18022"] = 10709,
        ["1803"] = 465,
        ["1804"] = 478,
        ["18042"] = 10,
        ["18043"] = 15495,
        ["18044"] = 41478,
        ["18045"] = 300,
        ["18046"] = 3000,
        ["18047"] = 22776,
        ["18048"] = 49204,
        ["1805"] = 351,
        ["1806"] = 466,
        ["1807"] = 387,
        ["1808"] = 856,
        ["18082"] = 28161,
        ["18083"] = 4522,
        ["1809"] = 440,
        ["1810"] = 648,
        ["18102"] = 15444,
        ["18103"] = 15252,
        ["18104"] = 15557,
        ["1811"] = 451,
        ["1812"] = 453,
        ["1813"] = 523,
        ["1814"] = 603,
        ["18145"] = 0,
        ["18146"] = 0,
        ["18147"] = 0,
        ["18148"] = 0,
        ["1815"] = 366,
        ["18150"] = 0,
        ["18151"] = 0,
        ["18152"] = 0,
        ["18154"] = 0,
        ["1816"] = 486,
        ["18160"] = 50,
        ["18168"] = 47292,
        ["18169"] = 25000,
        ["1817"] = 501,
        ["18170"] = 25000,
        ["18171"] = 25000,
        ["18172"] = 25000,
        ["18173"] = 25000,
        ["1818"] = 1221,
        ["18182"] = 100000,
        ["1819"] = 768,
        ["182"] = 0,
        ["1820"] = 963,
        ["18202"] = 73256,
        ["18203"] = 73522,
        ["18204"] = 22136,
        ["18205"] = 33287,
        ["18206"] = 41319,
        ["18207"] = 0,
        ["18208"] = 22741,
        ["1821"] = 988,
        ["1822"] = 1096,
        ["18222"] = 3070,
        ["18223"] = 6142,
        ["18224"] = 1728,
        ["18225"] = 140,
        ["18226"] = 408,
        ["18227"] = 248,
        ["18228"] = 2500,
        ["18229"] = 790,
        ["1823"] = 779,
        ["18230"] = 509,
        ["18231"] = 361,
        ["18232"] = 10000,
        ["18233"] = 130,
        ["18234"] = 225,
        ["18236"] = 2716,
        ["18237"] = 1622,
        ["18238"] = 3321,
        ["18239"] = 875,
        ["1824"] = 1104,
        ["18240"] = 0,
        ["18241"] = 0,
        ["18242"] = 0,
        ["18243"] = 0,
        ["18244"] = 0,
        ["18245"] = 0,
        ["18246"] = 0,
        ["18247"] = 0,
        ["18248"] = 0,
        ["18249"] = 0,
        ["1825"] = 1548,
        ["18250"] = 0,
        ["18251"] = 5000,
        ["18252"] = 50000,
        ["18253"] = 15,
        ["18254"] = 18,
        ["18255"] = 15,
        ["18256"] = 1500,
        ["18257"] = 50000,
        ["18258"] = 0,
        ["18259"] = 7500,
        ["1826"] = 1765,
        ["18260"] = 7500,
        ["18261"] = 0,
        ["18262"] = 1250,
        ["18263"] = 14690,
        ["18264"] = 25000,
        ["18265"] = 30000,
        ["18266"] = 0,
        ["18267"] = 5000,
        ["18268"] = 0,
        ["18269"] = 375,
        ["1827"] = 1282,
        ["1828"] = 1609,
        ["18282"] = 55617,
        ["18283"] = 25000,
        ["18284"] = 375,
        ["18285"] = 4558,
        ["18286"] = 2953,
        ["18287"] = 50,
        ["18288"] = 250,
        ["18289"] = 9701,
        ["1829"] = 1563,
        ["18291"] = 30000,
        ["18292"] = 30000,
        ["18294"] = 250,
        ["18295"] = 11582,
        ["18296"] = 12322,
        ["18297"] = 0,
        ["18298"] = 20685,
        ["18299"] = 0,
        ["1830"] = 1783,
        ["18300"] = 200,
        ["18301"] = 29363,
        ["18302"] = 7530,
        ["18305"] = 25157,
        ["18306"] = 7215,
        ["18307"] = 11163,
        ["18308"] = 14006,
        ["18309"] = 11808,
        ["1831"] = 1790,
        ["18310"] = 47406,
        ["18311"] = 56644,
        ["18312"] = 33429,
        ["18313"] = 23920,
        ["18314"] = 12100,
        ["18315"] = 12100,
        ["18317"] = 12503,
        ["18318"] = 22057,
        ["18319"] = 20989,
        ["1832"] = 362,
        ["18321"] = 49320,
        ["18322"] = 17677,
        ["18323"] = 32988,
        ["18324"] = 55189,
        ["18325"] = 16617,
        ["18326"] = 16440,
        ["18327"] = 9376,
        ["18328"] = 14116,
        ["18329"] = 0,
        ["18330"] = 0,
        ["18331"] = 0,
        ["18332"] = 0,
        ["18333"] = 0,
        ["18334"] = 0,
        ["18335"] = 0,
        ["18336"] = 0,
        ["18337"] = 8103,
        ["18338"] = 36595,
        ["18339"] = 11370,
        ["18340"] = 28853,
        ["18343"] = 14615,
        ["18344"] = 11587,
        ["18345"] = 14727,
        ["18347"] = 43067,
        ["18348"] = 75990,
        ["18349"] = 12568,
        ["1835"] = 6,
        ["18350"] = 12615,
        ["18351"] = 8740,
        ["18352"] = 27109,
        ["18353"] = 53142,
        ["18354"] = 17466,
        ["18356"] = 0,
        ["18357"] = 0,
        ["18358"] = 0,
        ["18359"] = 0,
        ["1836"] = 6,
        ["18360"] = 0,
        ["18361"] = 0,
        ["18362"] = 0,
        ["18363"] = 0,
        ["18364"] = 0,
        ["18365"] = 0,
        ["18366"] = 17257,
        ["18367"] = 14762,
        ["18368"] = 12348,
        ["18369"] = 9915,
        ["18370"] = 21612,
        ["18371"] = 20737,
        ["18372"] = 54895,
        ["18373"] = 26535,
        ["18374"] = 19970,
        ["18375"] = 13360,
        ["18376"] = 53632,
        ["18377"] = 12175,
        ["18378"] = 29332,
        ["18379"] = 22182,
        ["18380"] = 34486,
        ["18381"] = 21635,
        ["18382"] = 14891,
        ["18383"] = 17301,
        ["18384"] = 26209,
        ["18385"] = 20080,
        ["18386"] = 19882,
        ["18387"] = 9840,
        ["18388"] = 39093,
        ["18389"] = 15692,
        ["1839"] = 37,
        ["18390"] = 25891,
        ["18391"] = 13171,
        ["18392"] = 52875,
        ["18393"] = 15701,
        ["18394"] = 15974,
        ["18395"] = 36645,
        ["18396"] = 53627,
        ["18397"] = 22464,
        ["18398"] = 27103,
        ["18399"] = 27103,
        ["1840"] = 37,
        ["18400"] = 14853,
        ["18401"] = 0,
        ["18402"] = 18662,
        ["18403"] = 49060,
        ["18404"] = 6714,
        ["18405"] = 13747,
        ["18406"] = 46030,
        ["18407"] = 10386,
        ["18408"] = 10422,
        ["18409"] = 10460,
        ["18410"] = 45516,
        ["18411"] = 13704,
        ["18412"] = 0,
        ["18413"] = 15916,
        ["18414"] = 30000,
        ["18415"] = 10000,
        ["18416"] = 10000,
        ["18417"] = 10000,
        ["18418"] = 10000,
        ["18420"] = 64117,
        ["18421"] = 23168,
        ["18423"] = 0,
        ["18424"] = 19520,
        ["18425"] = 5537,
        ["18426"] = 0,
        ["18427"] = 1322,
        ["18428"] = 7500,
        ["18429"] = 5889,
        ["1843"] = 145,
        ["18430"] = 2878,
        ["18432"] = 4348,
        ["18434"] = 7493,
        ["18435"] = 3662,
        ["18436"] = 3417,
        ["18437"] = 2744,
        ["1844"] = 145,
        ["18440"] = 1288,
        ["18441"] = 4178,
        ["18442"] = 5000,
        ["18443"] = 10000,
        ["18444"] = 2,
        ["18445"] = 5804,
        ["18447"] = 2847,
        ["18448"] = 8801,
        ["18449"] = 4301,
        ["1845"] = 175,
        ["18450"] = 17016,
        ["18451"] = 10673,
        ["18452"] = 6910,
        ["18453"] = 3343,
        ["18454"] = 1154,
        ["18455"] = 3343,
        ["18456"] = 5613,
        ["18457"] = 2674,
        ["18458"] = 12212,
        ["18459"] = 14383,
        ["1846"] = 176,
        ["18460"] = 30762,
        ["18461"] = 8577,
        ["18462"] = 41319,
        ["18463"] = 41472,
        ["18464"] = 29135,
        ["18465"] = 2,
        ["18466"] = 2,
        ["18467"] = 2,
        ["18468"] = 2,
        ["18469"] = 2,
        ["18470"] = 2,
        ["18471"] = 0,
        ["18472"] = 2,
        ["18473"] = 2,
        ["18475"] = 8049,
        ["18476"] = 15149,
        ["18477"] = 20276,
        ["18478"] = 20352,
        ["18479"] = 18384,
        ["18480"] = 21488,
        ["18481"] = 51451,
        ["18482"] = 29652,
        ["18483"] = 37839,
        ["18484"] = 51975,
        ["18485"] = 33383,
        ["18486"] = 20939,
        ["18487"] = 10000,
        ["18488"] = 0,
        ["18489"] = 0,
        ["1849"] = 277,
        ["18490"] = 18015,
        ["18491"] = 40695,
        ["18492"] = 0,
        ["18493"] = 25113,
        ["18494"] = 21743,
        ["18495"] = 15094,
        ["18496"] = 14542,
        ["18497"] = 9731,
        ["18498"] = 48836,
        ["18499"] = 34589,
        ["1850"] = 278,
        ["18500"] = 31340,
        ["18501"] = 0,
        ["18502"] = 65385,
        ["18503"] = 36748,
        ["18504"] = 13171,
        ["18505"] = 13218,
        ["18506"] = 19897,
        ["18507"] = 15974,
        ["18508"] = 16031,
        ["18509"] = 21451,
        ["18510"] = 19477,
        ["18511"] = 19553,
        ["18512"] = 4000,
        ["18513"] = 0,
        ["18514"] = 15000,
        ["18515"] = 15000,
        ["18516"] = 15000,
        ["18517"] = 40000,
        ["18518"] = 40000,
        ["18519"] = 40000,
        ["1852"] = 336,
        ["18520"] = 65795,
        ["18521"] = 27679,
        ["18522"] = 36253,
        ["18523"] = 34810,
        ["18524"] = 32038,
        ["18525"] = 13396,
        ["18526"] = 16132,
        ["18527"] = 16190,
        ["18528"] = 19763,
        ["18529"] = 18616,
        ["1853"] = 338,
        ["18530"] = 29212,
        ["18531"] = 61096,
        ["18532"] = 20166,
        ["18533"] = 18055,
        ["18534"] = 64356,
        ["18535"] = 30231,
        ["18536"] = 38664,
        ["18537"] = 66135,
        ["18538"] = 96748,
        ["18539"] = 0,
        ["18540"] = 0,
        ["18541"] = 23110,
        ["18542"] = 94273,
        ["18543"] = 63728,
        ["18544"] = 19705,
        ["18545"] = 30875,
        ["18546"] = 34859,
        ["18547"] = 28041,
        ["18562"] = 100000,
        ["18564"] = 0,
        ["18566"] = 0,
        ["18567"] = 37500,
        ["18585"] = 14853,
        ["18586"] = 14853,
        ["18587"] = 2000,
        ["18588"] = 200,
        ["18590"] = 0,
        ["18591"] = 0,
        ["18592"] = 20000,
        ["18594"] = 3000,
        ["18598"] = 0,
        ["18600"] = 12000,
        ["18601"] = 0,
        ["18602"] = 0,
        ["18603"] = 0,
        ["18604"] = 0,
        ["18605"] = 0,
        ["18606"] = 12500,
        ["18607"] = 12500,
        ["18608"] = 0,
        ["18609"] = 0,
        ["18610"] = 37,
        ["18611"] = 27,
        ["18612"] = 35,
        ["18622"] = 0,
        ["18623"] = 0,
        ["18624"] = 0,
        ["18625"] = 0,
        ["18626"] = 0,
        ["18629"] = 0,
        ["18631"] = 3000,
        ["18632"] = 50,
        ["18633"] = 6,
        ["18634"] = 12500,
        ["18635"] = 100,
        ["18636"] = 100,
        ["18637"] = 600,
        ["18638"] = 12500,
        ["18639"] = 12500,
        ["18640"] = 0,
        ["18641"] = 500,
        ["18642"] = 0,
        ["18643"] = 0,
        ["18645"] = 1500,
        ["18646"] = 0,
        ["18647"] = 450,
        ["18648"] = 450,
        ["18649"] = 450,
        ["18650"] = 1250,
        ["18651"] = 3000,
        ["18652"] = 3000,
        ["18653"] = 4000,
        ["18654"] = 4000,
        ["18655"] = 4000,
        ["18656"] = 4000,
        ["18657"] = 5000,
        ["18658"] = 6000,
        ["18659"] = 0,
        ["18660"] = 7500,
        ["18661"] = 3000,
        ["18662"] = 5,
        ["18663"] = 0,
        ["18664"] = 25,
        ["18665"] = 2,
        ["18670"] = 0,
        ["18671"] = 47747,
        ["18672"] = 17855,
        ["18673"] = 30782,
        ["18674"] = 22003,
        ["18675"] = 25,
        ["18676"] = 15529,
        ["18677"] = 12059,
        ["18678"] = 26635,
        ["18679"] = 25136,
        ["18680"] = 36594,
        ["18681"] = 14693,
        ["18682"] = 24583,
        ["18683"] = 49347,
        ["18684"] = 36141,
        ["18686"] = 22869,
        ["18687"] = 0,
        ["18688"] = 0,
        ["18689"] = 15347,
        ["18690"] = 35939,
        ["18691"] = 31400,
        ["18692"] = 25109,
        ["18693"] = 10652,
        ["18694"] = 24158,
        ["18695"] = 34450,
        ["18696"] = 31173,
        ["18697"] = 10867,
        ["18698"] = 14454,
        ["18699"] = 15380,
        ["18700"] = 10910,
        ["18701"] = 36410,
        ["18702"] = 17064,
        ["18703"] = 0,
        ["18704"] = 0,
        ["18705"] = 0,
        ["18706"] = 10031,
        ["18707"] = 0,
        ["18708"] = 0,
        ["18709"] = 5758,
        ["18710"] = 7224,
        ["18711"] = 8700,
        ["18712"] = 10245,
        ["18713"] = 0,
        ["18714"] = 0,
        ["18715"] = 180778,
        ["18716"] = 18015,
        ["18717"] = 61940,
        ["18718"] = 26065,
        ["18719"] = 0,
        ["18720"] = 15036,
        ["18721"] = 14689,
        ["18722"] = 17539,
        ["18723"] = 41953,
        ["18724"] = 0,
        ["18725"] = 59927,
        ["18726"] = 12029,
        ["18727"] = 14487,
        ["18728"] = 32466,
        ["18729"] = 38302,
        ["18730"] = 10250,
        ["18731"] = 500,
        ["18734"] = 16031,
        ["18735"] = 16086,
        ["18736"] = 24346,
        ["18737"] = 48882,
        ["18738"] = 36303,
        ["18739"] = 34010,
        ["18740"] = 9754,
        ["18741"] = 17704,
        ["18742"] = 22503,
        ["18743"] = 14275,
        ["18744"] = 11371,
        ["18745"] = 17228,
        ["18746"] = 0,
        ["18749"] = 0,
        ["1875"] = 0,
        ["18752"] = 0,
        ["18753"] = 0,
        ["18754"] = 18806,
        ["18755"] = 40213,
        ["18756"] = 31160,
        ["18757"] = 15069,
        ["18758"] = 50416,
        ["18759"] = 63257,
        ["18760"] = 30866,
        ["18761"] = 38238,
        ["18762"] = 27631,
        ["18766"] = 0,
        ["18767"] = 0,
        ["18769"] = 0,
        ["18770"] = 0,
        ["18771"] = 0,
        ["18773"] = 0,
        ["18774"] = 0,
        ["18775"] = 0,
        ["18776"] = 0,
        ["18777"] = 0,
        ["18778"] = 0,
        ["18779"] = 0,
        ["18780"] = 0,
        ["18781"] = 0,
        ["18782"] = 0,
        ["18783"] = 0,
        ["18784"] = 0,
        ["18785"] = 0,
        ["18786"] = 0,
        ["18787"] = 0,
        ["18788"] = 0,
        ["18789"] = 0,
        ["18790"] = 0,
        ["18791"] = 0,
        ["18792"] = 0,
        ["18793"] = 0,
        ["18794"] = 0,
        ["18795"] = 0,
        ["18796"] = 0,
        ["18797"] = 0,
        ["18798"] = 0,
        ["18802"] = 5000,
        ["18803"] = 94876,
        ["18805"] = 76460,
        ["18806"] = 41261,
        ["18807"] = 25796,
        ["18808"] = 15859,
        ["18809"] = 14578,
        ["18810"] = 27440,
        ["18811"] = 22035,
        ["18812"] = 22119,
        ["18813"] = 89103,
        ["18814"] = 89135,
        ["18815"] = 64095,
        ["18816"] = 80298,
        ["18817"] = 35861,
        ["18818"] = 0,
        ["18820"] = 66290,
        ["18821"] = 64030,
        ["18822"] = 94642,
        ["18823"] = 19235,
        ["18824"] = 40964,
        ["18825"] = 31807,
        ["18826"] = 16926,
        ["18827"] = 30725,
        ["18828"] = 50225,
        ["18829"] = 32943,
        ["18830"] = 35132,
        ["18831"] = 35268,
        ["18832"] = 72832,
        ["18833"] = 34731,
        ["18834"] = 3750,
        ["18835"] = 21485,
        ["18836"] = 21566,
        ["18837"] = 21646,
        ["18838"] = 48458,
        ["18839"] = 250,
        ["18840"] = 29966,
        ["18841"] = 250,
        ["18842"] = 97012,
        ["18843"] = 30290,
        ["18844"] = 30399,
        ["18845"] = 3750,
        ["18846"] = 3750,
        ["18847"] = 30722,
        ["18848"] = 30828,
        ["18849"] = 0,
        ["18850"] = 3750,
        ["18851"] = 3750,
        ["18852"] = 3750,
        ["18853"] = 0,
        ["18854"] = 3750,
        ["18856"] = 2,
        ["18857"] = 3750,
        ["18858"] = 3750,
        ["18859"] = 2,
        ["18860"] = 22470,
        ["18861"] = 48152,
        ["18862"] = 3750,
        ["18863"] = 2,
        ["18864"] = 0,
        ["18865"] = 30501,
        ["18866"] = 30610,
        ["18867"] = 38395,
        ["18868"] = 38531,
        ["18869"] = 34989,
        ["18870"] = 30139,
        ["18871"] = 36231,
        ["18872"] = 27356,
        ["18873"] = 59459,
        ["18874"] = 36639,
        ["18875"] = 35039,
        ["18876"] = 60118,
        ["18877"] = 60339,
        ["18878"] = 71794,
        ["18879"] = 53364,
        ["18880"] = 0,
        ["18902"] = 0,
        ["18904"] = 0,
        ["18922"] = 0,
        ["1893"] = 1663,
        ["1894"] = 0,
        ["18944"] = 123,
        ["18945"] = 100,
        ["18946"] = 0,
        ["18947"] = 0,
        ["18948"] = 1589,
        ["18949"] = 500,
        ["18953"] = 287,
        ["18955"] = 16,
        ["18956"] = 0,
        ["18957"] = 250,
        ["18958"] = 0,
        ["18959"] = 0,
        ["18960"] = 0,
        ["18969"] = 0,
        ["18984"] = 5000,
        ["18986"] = 5000,
        ["18987"] = 0,
        ["19005"] = 12500,
        ["19006"] = 3868,
        ["19007"] = 12500,
        ["19009"] = 0,
        ["19010"] = 5847,
        ["19011"] = 0,
        ["19012"] = 0,
        ["19013"] = 0,
        ["19016"] = 3154,
        ["19019"] = 123140,
        ["19022"] = 28580,
        ["19024"] = 10031,
        ["19026"] = 250,
        ["19027"] = 1250,
        ["19028"] = 1078,
        ["19030"] = 0,
        ["19031"] = 2500,
        ["19032"] = 2,
        ["19035"] = 250,
        ["19037"] = 10266,
        ["19038"] = 11145,
        ["19039"] = 7403,
        ["19040"] = 19817,
        ["19041"] = 9946,
        ["19042"] = 9984,
        ["19043"] = 13291,
        ["19044"] = 11116,
        ["19045"] = 12500,
        ["19046"] = 12500,
        ["19047"] = 9232,
        ["19048"] = 28061,
        ["19049"] = 13531,
        ["19050"] = 16295,
        ["19051"] = 16483,
        ["19052"] = 17621,
        ["19056"] = 12941,
        ["19057"] = 17744,
        ["19058"] = 18977,
        ["19059"] = 15238,
        ["19060"] = 100,
        ["19061"] = 75,
        ["19062"] = 50,
        ["19066"] = 100,
        ["19067"] = 75,
        ["19068"] = 50,
        ["19083"] = 15044,
        ["19084"] = 15100,
        ["19085"] = 15155,
        ["19086"] = 15209,
        ["19087"] = 10176,
        ["19088"] = 15319,
        ["19089"] = 11860,
        ["19090"] = 10285,
        ["19091"] = 9488,
        ["19092"] = 14233,
        ["19093"] = 11860,
        ["19094"] = 9488,
        ["19095"] = 17912,
        ["19096"] = 17912,
        ["19097"] = 17912,
        ["19098"] = 17912,
        ["19099"] = 63065,
        ["19100"] = 63300,
        ["19101"] = 79411,
        ["19102"] = 79705,
        ["19103"] = 63568,
        ["19104"] = 64227,
        ["19105"] = 17540,
        ["19106"] = 66021,
        ["19107"] = 44171,
        ["19108"] = 44327,
        ["19109"] = 33920,
        ["19110"] = 59528,
        ["19111"] = 25087,
        ["19112"] = 17650,
        ["19113"] = 12583,
        ["19114"] = 18282,
        ["19115"] = 11003,
        ["19116"] = 4590,
        ["19117"] = 16127,
        ["19118"] = 17344,
        ["19119"] = 5803,
        ["19120"] = 16283,
        ["19121"] = 9007,
        ["19123"] = 4114,
        ["19124"] = 14453,
        ["19125"] = 6652,
        ["19126"] = 7833,
        ["19127"] = 12258,
        ["19128"] = 13358,
        ["1913"] = 148,
        ["19130"] = 54431,
        ["19131"] = 21586,
        ["19132"] = 21400,
        ["19133"] = 29722,
        ["19134"] = 17969,
        ["19135"] = 14066,
        ["19136"] = 15029,
        ["19137"] = 28803,
        ["19138"] = 79853,
        ["19139"] = 28496,
        ["19140"] = 60256,
        ["19141"] = 16612,
        ["19142"] = 18903,
        ["19143"] = 27183,
        ["19144"] = 34596,
        ["19145"] = 29952,
        ["19146"] = 18542,
        ["19147"] = 91453,
        ["19148"] = 35881,
        ["19149"] = 17185,
        ["19156"] = 28236,
        ["19157"] = 22350,
        ["19159"] = 21141,
        ["19160"] = 0,
        ["19162"] = 19474,
        ["19163"] = 19544,
        ["19164"] = 27616,
        ["19165"] = 31491,
        ["19166"] = 75133,
        ["19167"] = 94248,
        ["19168"] = 71993,
        ["19169"] = 90341,
        ["1917"] = 251,
        ["19170"] = 72552,
        ["19182"] = 25,
        ["19183"] = 0,
        ["19202"] = 5500,
        ["19203"] = 5500,
        ["19204"] = 10000,
        ["19205"] = 10000,
        ["19206"] = 15000,
        ["19207"] = 20000,
        ["19213"] = 0,
        ["19215"] = 5500,
        ["19216"] = 5500,
        ["19217"] = 10000,
        ["19218"] = 10000,
        ["19219"] = 15000,
        ["1922"] = 0,
        ["19221"] = 12,
        ["19222"] = 2,
        ["19223"] = 1,
        ["19224"] = 50,
        ["19225"] = 200,
        ["19227"] = 12500,
        ["19228"] = 100000,
        ["19229"] = 0,
        ["19230"] = 12500,
        ["19231"] = 12500,
        ["19232"] = 12500,
        ["19233"] = 12500,
        ["19234"] = 12500,
        ["19235"] = 12500,
        ["19236"] = 12500,
        ["19237"] = 15,
        ["19238"] = 0,
        ["19239"] = 0,
        ["19243"] = 0,
        ["19244"] = 0,
        ["19245"] = 0,
        ["19246"] = 86,
        ["19247"] = 1658,
        ["19248"] = 0,
        ["19249"] = 78,
        ["1925"] = 787,
        ["19250"] = 0,
        ["19251"] = 0,
        ["19252"] = 1423,
        ["19253"] = 0,
        ["19254"] = 0,
        ["19255"] = 0,
        ["19256"] = 0,
        ["19257"] = 100000,
        ["19258"] = 12500,
        ["19259"] = 12500,
        ["1926"] = 687,
        ["19260"] = 12500,
        ["19261"] = 12500,
        ["19262"] = 12500,
        ["19263"] = 12500,
        ["19264"] = 12500,
        ["19265"] = 12500,
        ["19267"] = 100000,
        ["19268"] = 12500,
        ["19269"] = 12500,
        ["1927"] = 690,
        ["19270"] = 12500,
        ["19271"] = 12500,
        ["19272"] = 12500,
        ["19273"] = 12500,
        ["19274"] = 12500,
        ["19275"] = 12500,
        ["19276"] = 12500,
        ["19277"] = 100000,
        ["19278"] = 12500,
        ["19279"] = 12500,
        ["1928"] = 996,
        ["19280"] = 12500,
        ["19281"] = 12500,
        ["19282"] = 12500,
        ["19283"] = 12500,
        ["19284"] = 12500,
        ["19287"] = 100000,
        ["19288"] = 100000,
        ["19289"] = 100000,
        ["1929"] = 434,
        ["19290"] = 100000,
        ["19291"] = 25000,
        ["19292"] = 4022,
        ["19293"] = 19376,
        ["19295"] = 750,
        ["19296"] = 250,
        ["19297"] = 110,
        ["19298"] = 50,
        ["19299"] = 25,
        ["193"] = 9,
        ["1930"] = 327,
        ["19300"] = 100,
        ["19301"] = 350,
        ["19302"] = 12500,
        ["19303"] = 12500,
        ["19304"] = 6,
        ["19305"] = 25,
        ["19306"] = 100,
        ["19307"] = 100,
        ["19308"] = 3087,
        ["19309"] = 125000,
        ["1931"] = 0,
        ["19310"] = 125000,
        ["19312"] = 0,
        ["19315"] = 125000,
        ["19316"] = 7,
        ["19317"] = 7,
        ["19318"] = 250,
        ["19319"] = 87500,
        ["19320"] = 87500,
        ["19321"] = 156686,
        ["19322"] = 0,
        ["19323"] = 312980,
        ["19324"] = 251323,
        ["19325"] = 188888,
        ["19326"] = 5500,
        ["19327"] = 10000,
        ["19328"] = 5500,
        ["19329"] = 10000,
        ["1933"] = 905,
        ["19330"] = 15000,
        ["19334"] = 100551,
        ["19335"] = 80731,
        ["19336"] = 72039,
        ["19337"] = 72039,
        ["19338"] = 0,
        ["19339"] = 72039,
        ["1934"] = 731,
        ["19340"] = 72039,
        ["19341"] = 72039,
        ["19342"] = 72039,
        ["19343"] = 72039,
        ["19344"] = 72039,
        ["19345"] = 72039,
        ["19346"] = 79053,
        ["19347"] = 82129,
        ["19348"] = 50969,
        ["19349"] = 52946,
        ["1935"] = 2974,
        ["19350"] = 60867,
        ["19351"] = 81453,
        ["19352"] = 85814,
        ["19353"] = 105206,
        ["19354"] = 91123,
        ["19355"] = 95910,
        ["19356"] = 102955,
        ["19357"] = 96642,
        ["19358"] = 91409,
        ["1936"] = 1114,
        ["19360"] = 83625,
        ["19361"] = 60230,
        ["19362"] = 74238,
        ["19363"] = 84569,
        ["19364"] = 106097,
        ["19365"] = 79672,
        ["19366"] = 203059,
        ["19367"] = 60199,
        ["19368"] = 62010,
        ["19369"] = 16212,
        ["1937"] = 1700,
        ["19370"] = 24405,
        ["19371"] = 88355,
        ["19372"] = 43435,
        ["19373"] = 38038,
        ["19374"] = 15284,
        ["19375"] = 25143,
        ["19376"] = 111528,
        ["19377"] = 105328,
        ["19378"] = 25432,
        ["19379"] = 205863,
        ["1938"] = 1962,
        ["19380"] = 25624,
        ["19381"] = 32152,
        ["19382"] = 128280,
        ["19383"] = 128862,
        ["19384"] = 130616,
        ["19385"] = 33472,
        ["19386"] = 25195,
        ["19387"] = 44162,
        ["19388"] = 16916,
        ["19389"] = 31832,
        ["1939"] = 168,
        ["19390"] = 21297,
        ["19391"] = 25645,
        ["19392"] = 30198,
        ["19393"] = 25828,
        ["19394"] = 40037,
        ["19395"] = 103103,
        ["19396"] = 19250,
        ["19397"] = 107438,
        ["19398"] = 23275,
        ["19399"] = 31153,
        ["194"] = 9,
        ["19400"] = 16061,
        ["19401"] = 48361,
        ["19402"] = 56624,
        ["19403"] = 105328,
        ["19405"] = 40891,
        ["19406"] = 91160,
        ["19407"] = 16473,
        ["1941"] = 203,
        ["1942"] = 316,
        ["19422"] = 0,
        ["19424"] = 0,
        ["19426"] = 25000,
        ["1943"] = 713,
        ["19430"] = 24972,
        ["19431"] = 103117,
        ["19432"] = 147286,
        ["19433"] = 46932,
        ["19434"] = 80863,
        ["19435"] = 55695,
        ["19436"] = 22359,
        ["19437"] = 22443,
        ["19438"] = 22804,
        ["19439"] = 38148,
        ["1944"] = 259,
        ["19440"] = 500,
        ["19441"] = 1500,
        ["19442"] = 25000,
        ["19443"] = 46934,
        ["19444"] = 7500,
        ["19445"] = 7500,
        ["19446"] = 7500,
        ["19447"] = 15000,
        ["19448"] = 20000,
        ["1945"] = 267,
        ["19450"] = 0,
        ["19451"] = 79064,
        ["19452"] = 0,
        ["19453"] = 0,
        ["19454"] = 1,
        ["1946"] = 0,
        ["19462"] = 0,
        ["19483"] = 11774,
        ["19484"] = 0,
        ["19491"] = 25000,
        ["195"] = 7,
        ["19505"] = 12500,
        ["19506"] = 2,
        ["19507"] = 1701,
        ["19508"] = 1423,
        ["19509"] = 2583,
        ["1951"] = 1258,
        ["19510"] = 18750,
        ["19511"] = 15000,
        ["19512"] = 11250,
        ["19513"] = 5000,
        ["19514"] = 18750,
        ["19515"] = 11250,
        ["19516"] = 15000,
        ["19517"] = 5000,
        ["19518"] = 18750,
        ["19519"] = 15000,
        ["19520"] = 11250,
        ["19521"] = 5000,
        ["19522"] = 18750,
        ["19523"] = 15000,
        ["19524"] = 11250,
        ["19525"] = 5000,
        ["19526"] = 0,
        ["19527"] = 9631,
        ["19528"] = 4780,
        ["19529"] = 2122,
        ["19530"] = 17098,
        ["19531"] = 10048,
        ["19533"] = 2154,
        ["19534"] = 18750,
        ["19535"] = 2,
        ["19536"] = 11250,
        ["19537"] = 5000,
        ["19538"] = 2,
        ["19539"] = 2,
        ["19540"] = 2,
        ["19541"] = 5000,
        ["19542"] = 54922,
        ["19543"] = 1500,
        ["19544"] = 10438,
        ["19545"] = 6969,
        ["19546"] = 54922,
        ["19548"] = 11250,
        ["1955"] = 1573,
        ["19550"] = 54922,
        ["19552"] = 5420,
        ["19553"] = 63,
        ["19554"] = 54922,
        ["19558"] = 44011,
        ["19559"] = 100,
        ["1956"] = 0,
        ["19560"] = 14808,
        ["19561"] = 6,
        ["19562"] = 41191,
        ["19563"] = 213,
        ["19564"] = 3087,
        ["19566"] = 70171,
        ["19567"] = 41241,
        ["19568"] = 20466,
        ["19570"] = 71229,
        ["19574"] = 2,
        ["19575"] = 2,
        ["19576"] = 2,
        ["19577"] = 2,
        ["19578"] = 17699,
        ["19579"] = 2,
        ["1958"] = 975,
        ["19581"] = 8656,
        ["19582"] = 24220,
        ["19583"] = 10261,
        ["19584"] = 10,
        ["19585"] = 2,
        ["19586"] = 2,
        ["19587"] = 20183,
        ["19588"] = 2,
        ["1959"] = 1223,
        ["19591"] = 2,
        ["19592"] = 2,
        ["19593"] = 2,
        ["19594"] = 2,
        ["19595"] = 0,
        ["19597"] = 8963,
        ["19598"] = 2,
        ["19599"] = 2,
        ["19600"] = 2,
        ["19601"] = 2,
        ["19602"] = 2,
        ["19603"] = 2,
        ["19604"] = 2,
        ["19605"] = 2,
        ["19606"] = 4739,
        ["19607"] = 3424,
        ["19609"] = 233,
        ["19610"] = 2,
        ["19611"] = 2,
        ["19612"] = 2,
        ["19613"] = 2,
        ["19614"] = 2,
        ["19615"] = 2,
        ["19616"] = 0,
        ["19617"] = 2,
        ["19618"] = 2,
        ["19619"] = 2,
        ["1962"] = 0,
        ["19620"] = 2,
        ["19621"] = 2,
        ["1965"] = 36,
        ["1968"] = 0,
        ["19682"] = 20986,
        ["19683"] = 21065,
        ["19684"] = 15856,
        ["19685"] = 26526,
        ["19686"] = 13312,
        ["19687"] = 13361,
        ["19688"] = 26819,
        ["19689"] = 20188,
        ["19690"] = 33265,
        ["19691"] = 25148,
        ["19692"] = 16749,
        ["19693"] = 35490,
        ["19694"] = 35628,
        ["19695"] = 26773,
        ["19696"] = 0,
        ["19697"] = 0,
        ["19698"] = 2,
        ["19699"] = 0,
        ["1970"] = 120,
        ["19700"] = 0,
        ["19701"] = 0,
        ["19702"] = 0,
        ["19703"] = 0,
        ["19704"] = 0,
        ["19705"] = 0,
        ["19706"] = 0,
        ["19707"] = 79064,
        ["19708"] = 0,
        ["1971"] = 0,
        ["19710"] = 13444,
        ["19711"] = 14941,
        ["19713"] = 193,
        ["19714"] = 13541,
        ["19715"] = 6590,
        ["19716"] = 10367,
        ["19718"] = 2500,
        ["19719"] = 15149,
        ["1972"] = 0,
        ["19721"] = 287,
        ["19722"] = 11250,
        ["19723"] = 3696,
        ["19726"] = 500,
        ["19727"] = 15000,
        ["1973"] = 4618,
        ["1974"] = 464,
        ["1975"] = 5744,
        ["1976"] = 6340,
        ["19764"] = 12500,
        ["19765"] = 12500,
        ["19766"] = 12500,
        ["19767"] = 2000,
        ["19768"] = 2000,
        ["19769"] = 12500,
        ["19770"] = 12500,
        ["19771"] = 12500,
        ["19772"] = 12500,
        ["19773"] = 12500,
        ["19774"] = 5000,
        ["19775"] = 25,
        ["19776"] = 12500,
        ["19777"] = 12500,
        ["19778"] = 12500,
        ["19779"] = 12500,
        ["1978"] = 981,
        ["19780"] = 12500,
        ["19781"] = 12500,
        ["19787"] = 1,
        ["1979"] = 23274,
        ["1980"] = 6200,
        ["19807"] = 0,
        ["19808"] = 15556,
        ["1981"] = 14113,
        ["19812"] = 0,
        ["19816"] = 14808,
        ["19819"] = 213,
        ["1982"] = 29513,
        ["19821"] = 0,
        ["19823"] = 14601,
        ["19824"] = 15364,
        ["19826"] = 1400,
        ["19827"] = 1405,
        ["19831"] = 13622,
        ["19834"] = 0,
        ["19835"] = 703,
        ["19838"] = 164,
        ["19846"] = 0,
        ["19849"] = 21242,
        ["19852"] = 73811,
        ["19853"] = 55563,
        ["19854"] = 92937,
        ["19855"] = 52235,
        ["19856"] = 48628,
        ["19857"] = 22550,
        ["19858"] = 0,
        ["19859"] = 75706,
        ["1986"] = 14861,
        ["19861"] = 57183,
        ["19862"] = 48971,
        ["19863"] = 61286,
        ["19864"] = 77063,
        ["19865"] = 77328,
        ["19866"] = 70360,
        ["19867"] = 70626,
        ["19869"] = 14200,
        ["1987"] = 0,
        ["19870"] = 17104,
        ["19871"] = 50287,
        ["19873"] = 48660,
        ["19874"] = 90591,
        ["19875"] = 26132,
        ["19876"] = 85311,
        ["19877"] = 29245,
        ["19878"] = 30760,
        ["1988"] = 2852,
        ["19881"] = 0,
        ["19883"] = 0,
        ["19884"] = 87276,
        ["19885"] = 44203,
        ["19886"] = 16849,
        ["19887"] = 33827,
        ["19888"] = 16975,
        ["19889"] = 28398,
        ["19890"] = 71409,
        ["19891"] = 63628,
        ["19892"] = 21535,
        ["19893"] = 55355,
        ["19894"] = 20364,
        ["19895"] = 23224,
        ["19896"] = 72049,
        ["19897"] = 21693,
        ["19898"] = 55035,
        ["19899"] = 21077,
        ["1990"] = 10077,
        ["19900"] = 66122,
        ["19901"] = 53102,
        ["19903"] = 68651,
        ["19904"] = 41348,
        ["19905"] = 45253,
        ["19906"] = 20294,
        ["19907"] = 16295,
        ["19908"] = 52467,
        ["19909"] = 87773,
        ["1991"] = 8357,
        ["19910"] = 70474,
        ["19912"] = 43548,
        ["19913"] = 29103,
        ["19914"] = 8750,
        ["19915"] = 36742,
        ["19918"] = 93051,
        ["19919"] = 23814,
        ["1992"] = 5468,
        ["19920"] = 56037,
        ["19921"] = 51094,
        ["19922"] = 63655,
        ["19923"] = 44030,
        ["19925"] = 43635,
        ["19927"] = 52265,
        ["19928"] = 20444,
        ["19929"] = 11356,
        ["1993"] = 2100,
        ["19930"] = 73852,
        ["19933"] = 2080,
        ["19934"] = 1400,
        ["19935"] = 830,
        ["19936"] = 830,
        ["19937"] = 780,
        ["19938"] = 580,
        ["1994"] = 16696,
        ["19943"] = 2000,
        ["19944"] = 86115,
        ["19945"] = 25933,
        ["19946"] = 67629,
        ["19947"] = 86528,
        ["19948"] = 111303,
        ["19949"] = 111303,
        ["19950"] = 111303,
        ["19953"] = 2,
        ["19954"] = 2,
        ["19955"] = 2,
        ["19957"] = 2,
        ["19958"] = 2,
        ["1996"] = 1720,
        ["19961"] = 53080,
        ["19962"] = 88511,
        ["19963"] = 68686,
        ["19964"] = 55154,
        ["19965"] = 55358,
        ["19967"] = 41821,
        ["19968"] = 55966,
        ["19969"] = 3360,
        ["1997"] = 2538,
        ["19970"] = 2175,
        ["19971"] = 2000,
        ["19972"] = 3396,
        ["19973"] = 162,
        ["19974"] = 2500,
        ["19975"] = 15149,
        ["19978"] = 8548,
        ["19979"] = 25000,
        ["1998"] = 7239,
        ["19982"] = 9444,
        ["19984"] = 11893,
        ["19990"] = 2,
        ["19991"] = 2,
        ["19992"] = 2,
        ["19993"] = 42730,
        ["19994"] = 0,
        ["19995"] = 0,
        ["19996"] = 8677,
        ["19997"] = 0,
        ["19998"] = 19457,
        ["19999"] = 15625,
        ["200"] = 454,
        ["2000"] = 8827,
        ["20000"] = 30000,
        ["20001"] = 12500,
        ["20002"] = 1000,
        ["20004"] = 1000,
        ["20006"] = 8375,
        ["20007"] = 1000,
        ["20008"] = 600,
        ["20009"] = 3079,
        ["20010"] = 17985,
        ["20011"] = 12500,
        ["20012"] = 12500,
        ["20013"] = 12500,
        ["20014"] = 12500,
        ["20015"] = 1658,
        ["20016"] = 3635,
        ["20017"] = 1830,
        ["20022"] = 14258,
        ["20023"] = 4426,
        ["20028"] = 12311,
        ["20030"] = 1580,
        ["20032"] = 27040,
        ["20033"] = 177,
        ["20034"] = 9755,
        ["20035"] = 30651,
        ["20036"] = 2750,
        ["20037"] = 15003,
        ["20038"] = 52549,
        ["20039"] = 38754,
        ["2004"] = 0,
        ["20040"] = 20000,
        ["20042"] = 1,
        ["20043"] = 1,
        ["20046"] = 1,
        ["20047"] = 11911,
        ["20048"] = 24333,
        ["2005"] = 0,
        ["20053"] = 1,
        ["20055"] = 43,
        ["2006"] = 0,
        ["20062"] = 100,
        ["20063"] = 50,
        ["20064"] = 75,
        ["20065"] = 75,
        ["20066"] = 100,
        ["20067"] = 50,
        ["20068"] = 26353,
        ["2007"] = 0,
        ["20071"] = 10307,
        ["20072"] = 10307,
        ["20073"] = 25,
        ["20074"] = 300,
        ["20075"] = 500,
        ["2008"] = 0,
        ["20082"] = 24229,
        ["20083"] = 40524,
        ["20086"] = 1,
        ["20088"] = 1113,
        ["20089"] = 5208,
        ["20090"] = 5718,
        ["20091"] = 703,
        ["20092"] = 7375,
        ["20094"] = 3923,
        ["20095"] = 10261,
        ["20096"] = 2138,
        ["20098"] = 12833,
        ["201"] = 455,
        ["20106"] = 14640,
        ["20107"] = 5634,
        ["2011"] = 3840,
        ["20110"] = 8484,
        ["20111"] = 11,
        ["20113"] = 31943,
        ["20116"] = 6966,
        ["20125"] = 5590,
        ["20128"] = 8419,
        ["2013"] = 3644,
        ["20130"] = 2,
        ["20131"] = 12500,
        ["20132"] = 2,
        ["20134"] = 30246,
        ["2014"] = 4617,
        ["2015"] = 4443,
        ["20151"] = 2581,
        ["20154"] = 4316,
        ["20156"] = 7682,
        ["20157"] = 2753,
        ["20162"] = 2242,
        ["20163"] = 12038,
        ["20168"] = 6023,
        ["20169"] = 2602,
        ["2017"] = 895,
        ["20170"] = 12274,
        ["20172"] = 1802,
        ["20173"] = 4202,
        ["20174"] = 8530,
        ["20176"] = 25401,
        ["2018"] = 2856,
        ["20188"] = 2663,
        ["20192"] = 3000,
        ["202"] = 343,
        ["2020"] = 1050,
        ["20201"] = 2792,
        ["20204"] = 8408,
        ["20206"] = 5765,
        ["20208"] = 17022,
        ["20209"] = 8678,
        ["2021"] = 1025,
        ["20210"] = 3234,
        ["20211"] = 46934,
        ["20212"] = 25508,
        ["20213"] = 20119,
        ["20214"] = 1,
        ["20215"] = 17271,
        ["20216"] = 14445,
        ["20217"] = 11598,
        ["20218"] = 14590,
        ["20219"] = 14641,
        ["20220"] = 5,
        ["20222"] = 100,
        ["20223"] = 50,
        ["20224"] = 75,
        ["20229"] = 162,
        ["20230"] = 5035,
        ["20231"] = 15149,
        ["20232"] = 75,
        ["20234"] = 100,
        ["20235"] = 50,
        ["20237"] = 75,
        ["2024"] = 1215,
        ["20243"] = 100,
        ["20244"] = 50,
        ["2025"] = 1061,
        ["20254"] = 5000,
        ["20255"] = 12425,
        ["20257"] = 23207,
        ["20258"] = 63375,
        ["20259"] = 12724,
        ["2026"] = 1257,
        ["20260"] = 31854,
        ["20261"] = 12821,
        ["20262"] = 24182,
        ["20263"] = 27080,
        ["20264"] = 25299,
        ["20265"] = 28353,
        ["20266"] = 38019,
        ["2027"] = 763,
        ["2028"] = 1013,
        ["2029"] = 884,
        ["20295"] = 31083,
        ["20296"] = 12590,
        ["203"] = 229,
        ["2030"] = 1109,
        ["2032"] = 1665,
        ["2033"] = 967,
        ["2034"] = 1035,
        ["2035"] = 2300,
        ["2036"] = 258,
        ["20369"] = 9975,
        ["2037"] = 469,
        ["20380"] = 43614,
        ["20381"] = 5000,
        ["20382"] = 15000,
        ["20384"] = 6268,
        ["20388"] = 0,
        ["20389"] = 0,
        ["2039"] = 750,
        ["20390"] = 0,
        ["20391"] = 1,
        ["20392"] = 1,
        ["20398"] = 0,
        ["2040"] = 15296,
        ["20400"] = 20000,
        ["20404"] = 0,
        ["20406"] = 1929,
        ["20407"] = 2581,
        ["20408"] = 1942,
        ["20409"] = 0,
        ["2041"] = 1412,
        ["20410"] = 0,
        ["20411"] = 0,
        ["20413"] = 0,
        ["20415"] = 0,
        ["2042"] = 3588,
        ["20422"] = 2,
        ["20424"] = 175,
        ["20425"] = 3286,
        ["20426"] = 5000,
        ["20427"] = 794,
        ["2043"] = 1500,
        ["20430"] = 2488,
        ["20437"] = 1915,
        ["2044"] = 7357,
        ["20441"] = 2591,
        ["20452"] = 250,
        ["2046"] = 2461,
        ["20465"] = 1102,
        ["20469"] = 12,
        ["2047"] = 26,
        ["20474"] = 750,
        ["20476"] = 15292,
        ["20477"] = 15755,
        ["20478"] = 31624,
        ["20479"] = 31734,
        ["2048"] = 26,
        ["20480"] = 15924,
        ["20481"] = 15980,
        ["20483"] = 0,
        ["20490"] = 0,
        ["20491"] = 100,
        ["20492"] = 0,
        ["20493"] = 1081,
        ["20494"] = 200,
        ["20495"] = 1,
        ["20496"] = 0,
        ["20498"] = 1000,
        ["20499"] = 500,
        ["20500"] = 2000,
        ["20501"] = 2000,
        ["20503"] = 4676,
        ["20504"] = 37873,
        ["20505"] = 15457,
        ["20507"] = 10000,
        ["20510"] = 10000,
        ["20512"] = 2,
        ["20513"] = 0,
        ["20514"] = 13247,
        ["20515"] = 5537,
        ["20516"] = 0,
        ["20517"] = 17113,
        ["20518"] = 500,
        ["20519"] = 0,
        ["20520"] = 2000,
        ["20521"] = 17358,
        ["20526"] = 500,
        ["20527"] = 500,
        ["20528"] = 500,
        ["20530"] = 12735,
        ["20531"] = 750,
        ["20533"] = 750,
        ["20534"] = 3975,
        ["20536"] = 40671,
        ["20537"] = 15963,
        ["20538"] = 21361,
        ["20539"] = 10717,
        ["2054"] = 16,
        ["20542"] = 1250,
        ["20545"] = 500,
        ["20546"] = 10000,
        ["20547"] = 10000,
        ["20548"] = 10000,
        ["20549"] = 18192,
        ["2055"] = 16,
        ["20550"] = 36308,
        ["20551"] = 27279,
        ["20552"] = 500,
        ["20553"] = 15000,
        ["20554"] = 15000,
        ["20555"] = 15000,
        ["20556"] = 40667,
        ["20557"] = 175,
        ["20558"] = 0,
        ["20559"] = 0,
        ["20560"] = 0,
        ["20561"] = 1,
        ["20562"] = 1,
        ["20563"] = 1,
        ["20564"] = 1,
        ["20565"] = 1,
        ["20566"] = 1,
        ["20567"] = 1,
        ["20568"] = 1,
        ["20569"] = 1,
        ["2057"] = 16,
        ["20570"] = 1,
        ["20571"] = 1,
        ["20572"] = 1,
        ["20573"] = 1,
        ["20574"] = 1,
        ["20575"] = 743,
        ["20576"] = 350,
        ["20577"] = 72906,
        ["20578"] = 73189,
        ["20579"] = 22041,
        ["2058"] = 4197,
        ["20580"] = 73748,
        ["20581"] = 92539,
        ["20582"] = 62802,
        ["2059"] = 863,
        ["20599"] = 55093,
        ["20600"] = 98660,
        ["20601"] = 12,
        ["20602"] = 12,
        ["20603"] = 12,
        ["20615"] = 19996,
        ["20616"] = 28254,
        ["20617"] = 44264,
        ["20618"] = 14810,
        ["20619"] = 38954,
        ["20621"] = 49595,
        ["20622"] = 114103,
        ["20623"] = 29073,
        ["20624"] = 143303,
        ["20625"] = 22879,
        ["20626"] = 15488,
        ["20627"] = 38863,
        ["20628"] = 29608,
        ["20629"] = 55079,
        ["20630"] = 27991,
        ["20631"] = 23655,
        ["20632"] = 101281,
        ["20633"] = 30139,
        ["20634"] = 30247,
        ["20635"] = 31990,
        ["20636"] = 89103,
        ["20637"] = 59440,
        ["20638"] = 45658,
        ["20639"] = 53469,
        ["2064"] = 191,
        ["20640"] = 8405,
        ["20641"] = 4829,
        ["20642"] = 7539,
        ["20643"] = 7094,
        ["20645"] = 21785,
        ["20646"] = 29963,
        ["20647"] = 40097,
        ["20648"] = 52827,
        ["20649"] = 22425,
        ["2065"] = 113,
        ["20650"] = 14980,
        ["20652"] = 12858,
        ["20653"] = 15141,
        ["20654"] = 60175,
        ["20655"] = 8054,
        ["20656"] = 18269,
        ["20657"] = 48687,
        ["20658"] = 15272,
        ["20659"] = 12263,
        ["2066"] = 68,
        ["20660"] = 61543,
        ["20661"] = 10295,
        ["20662"] = 21659,
        ["20663"] = 37336,
        ["20664"] = 8909,
        ["20665"] = 25775,
        ["20666"] = 51740,
        ["20667"] = 11258,
        ["20668"] = 31268,
        ["20669"] = 65379,
        ["2067"] = 186,
        ["20670"] = 12679,
        ["20671"] = 34239,
        ["20672"] = 36826,
        ["20673"] = 15048,
        ["20674"] = 19792,
        ["20675"] = 49664,
        ["20676"] = 500,
        ["20677"] = 500,
        ["20678"] = 500,
        ["20679"] = 500,
        ["20680"] = 24739,
        ["20681"] = 13734,
        ["20682"] = 73553,
        ["20683"] = 28999,
        ["20684"] = 16664,
        ["20685"] = 61617,
        ["20686"] = 17224,
        ["20687"] = 20282,
        ["20688"] = 47483,
        ["20689"] = 21761,
        ["2069"] = 122,
        ["20690"] = 10538,
        ["20691"] = 20361,
        ["20692"] = 13362,
        ["20693"] = 11985,
        ["20694"] = 17828,
        ["20695"] = 36253,
        ["20696"] = 63158,
        ["20697"] = 15213,
        ["20698"] = 67873,
        ["20699"] = 35767,
        ["2070"] = 1,
        ["20700"] = 35901,
        ["20701"] = 30885,
        ["20702"] = 31824,
        ["20703"] = 26616,
        ["20704"] = 26711,
        ["20705"] = 21444,
        ["20707"] = 21597,
        ["20708"] = 2,
        ["20709"] = 50,
        ["20710"] = 25873,
        ["20711"] = 25973,
        ["20712"] = 14926,
        ["20713"] = 14983,
        ["20714"] = 18801,
        ["20715"] = 18873,
        ["20716"] = 10103,
        ["20717"] = 10141,
        ["2072"] = 4414,
        ["20720"] = 54064,
        ["20721"] = 38790,
        ["20722"] = 40843,
        ["20723"] = 43760,
        ["20724"] = 54892,
        ["20725"] = 5091,
        ["2073"] = 742,
        ["20731"] = 25000,
        ["20732"] = 25000,
        ["20733"] = 25000,
        ["20736"] = 25000,
        ["2074"] = 1054,
        ["20741"] = 0,
        ["20742"] = 0,
        ["20744"] = 400,
        ["20745"] = 1000,
        ["20746"] = 1000,
        ["20747"] = 1000,
        ["20748"] = 1000,
        ["20749"] = 1000,
        ["2075"] = 386,
        ["20750"] = 1000,
        ["20752"] = 750,
        ["20753"] = 1000,
        ["20754"] = 2500,
        ["20755"] = 5000,
        ["20756"] = 10000,
        ["20757"] = 10000,
        ["20758"] = 125,
        ["20761"] = 30000,
        ["20763"] = 312,
        ["20765"] = 0,
        ["20767"] = 10272,
        ["20769"] = 2500,
        ["2077"] = 5059,
        ["20770"] = 450,
        ["2078"] = 1070,
        ["2079"] = 934,
        ["2080"] = 6590,
        ["20803"] = 1046,
        ["20804"] = 0,
        ["20805"] = 12,
        ["20808"] = 12,
        ["20809"] = 12,
        ["20812"] = 5,
        ["20813"] = 4,
        ["20815"] = 200,
        ["20816"] = 20,
        ["20817"] = 100,
        ["20818"] = 625,
        ["2082"] = 250,
        ["20820"] = 1064,
        ["20821"] = 1064,
        ["20823"] = 837,
        ["20824"] = 6250,
        ["20826"] = 2207,
        ["20827"] = 875,
        ["20828"] = 677,
        ["20830"] = 1535,
        ["20831"] = 1535,
        ["20832"] = 1800,
        ["20833"] = 1540,
        ["20835"] = 25,
        ["20836"] = 25,
        ["20838"] = 19,
        ["20839"] = 32,
        ["2084"] = 5709,
        ["20840"] = 26,
        ["20841"] = 16,
        ["20842"] = 5,
        ["20843"] = 6,
        ["20844"] = 150,
        ["20845"] = 4,
        ["20846"] = 5,
        ["20847"] = 6,
        ["20848"] = 5,
        ["20849"] = 16,
        ["20852"] = 17,
        ["20853"] = 21,
        ["20854"] = 450,
        ["20855"] = 375,
        ["20856"] = 375,
        ["20857"] = 1,
        ["20858"] = 150,
        ["20859"] = 0,
        ["20860"] = 250,
        ["20861"] = 0,
        ["20862"] = 750,
        ["20863"] = 0,
        ["20864"] = 0,
        ["20865"] = 64,
        ["20866"] = 1000,
        ["20867"] = 73597,
        ["20868"] = 750,
        ["20869"] = 2500,
        ["2087"] = 252,
        ["20870"] = 18903,
        ["20871"] = 1772,
        ["20872"] = 138,
        ["20873"] = 141,
        ["20874"] = 0,
        ["20875"] = 0,
        ["20876"] = 0,
        ["20877"] = 0,
        ["20878"] = 0,
        ["20879"] = 0,
        ["2088"] = 729,
        ["20881"] = 0,
        ["20882"] = 200,
        ["2089"] = 1113,
        ["20891"] = 1,
        ["20892"] = 1,
        ["20893"] = 1,
        ["20894"] = 1,
        ["20895"] = 1,
        ["20896"] = 1,
        ["20897"] = 1,
        ["20898"] = 1,
        ["20899"] = 1,
        ["209"] = 12,
        ["20900"] = 1,
        ["20901"] = 1,
        ["20906"] = 250,
        ["20907"] = 300,
        ["20909"] = 1010,
        ["2091"] = 213,
        ["20912"] = 16,
        ["20914"] = 7,
        ["20915"] = 12,
        ["20916"] = 7,
        ["20917"] = 7,
        ["20918"] = 14,
        ["20919"] = 14,
        ["2092"] = 7,
        ["20920"] = 6,
        ["20921"] = 9,
        ["20922"] = 6,
        ["20923"] = 6,
        ["20924"] = 12,
        ["20925"] = 12,
        ["20930"] = 0,
        ["20938"] = 0,
        ["20950"] = 1535,
        ["20954"] = 5681,
        ["20955"] = 665,
        ["20957"] = 875,
        ["20958"] = 1130,
        ["20959"] = 1720,
        ["20960"] = 1720,
        ["20961"] = 1720,
        ["20963"] = 900,
        ["20964"] = 6646,
        ["20966"] = 3482,
        ["20967"] = 3482,
        ["20969"] = 5989,
        ["20971"] = 375,
        ["20973"] = 500,
        ["20974"] = 625,
        ["20975"] = 625,
        ["20976"] = 875,
        ["2098"] = 3021,
        ["20980"] = 5,
        ["20981"] = 7,
        ["20982"] = 7,
        ["20983"] = 7,
        ["20985"] = 7,
        ["20987"] = 5,
        ["20988"] = 5,
        ["20989"] = 5,
        ["2099"] = 45040,
        ["20990"] = 10,
        ["20991"] = 7,
        ["20992"] = 4,
        ["20993"] = 6,
        ["20994"] = 14,
        ["20995"] = 4,
        ["20996"] = 6,
        ["20997"] = 11,
        ["20998"] = 4,
        ["20999"] = 7,
        ["210"] = 9,
        ["2100"] = 24540,
        ["21000"] = 6,
        ["21001"] = 10,
        ["21002"] = 1,
        ["21003"] = 3,
        ["21004"] = 5,
        ["21005"] = 1,
        ["21006"] = 2,
        ["21007"] = 4,
        ["21008"] = 3,
        ["21009"] = 4,
        ["2101"] = 1,
        ["21010"] = 2,
        ["21011"] = 2,
        ["21012"] = 2,
        ["21013"] = 2,
        ["21014"] = 8,
        ["21015"] = 1,
        ["21016"] = 9,
        ["21017"] = 2,
        ["21018"] = 3,
        ["21019"] = 3,
        ["2102"] = 1,
        ["21020"] = 3,
        ["21021"] = 7,
        ["21023"] = 250,
        ["21025"] = 1250,
        ["21030"] = 100,
        ["21031"] = 200,
        ["21033"] = 200,
        ["2105"] = 1,
        ["21071"] = 25,
        ["21072"] = 40,
        ["2108"] = 8,
        ["21099"] = 125,
        ["2110"] = 6,
        ["21100"] = 0,
        ["21108"] = 0,
        ["21114"] = 50,
        ["21115"] = 0,
        ["21116"] = 3807,
        ["21117"] = 2,
        ["21118"] = 2,
        ["21119"] = 2,
        ["2112"] = 54,
        ["21120"] = 1807,
        ["21126"] = 85698,
        ["21128"] = 97775,
        ["2113"] = 0,
        ["21131"] = 12,
        ["21132"] = 12,
        ["21133"] = 12,
        ["21134"] = 110377,
        ["21140"] = 52747,
        ["21143"] = 0,
        ["21150"] = 2,
        ["21151"] = 50,
        ["21153"] = 125,
        ["21154"] = 1,
        ["21156"] = 12,
        ["21157"] = 1,
        ["2117"] = 3,
        ["21171"] = 0,
        ["21174"] = 0,
        ["21177"] = 37,
        ["21178"] = 13268,
        ["21179"] = 10709,
        ["21180"] = 21612,
        ["21181"] = 21612,
        ["21182"] = 10709,
        ["21183"] = 20620,
        ["21184"] = 23671,
        ["21185"] = 10452,
        ["21186"] = 13550,
        ["21187"] = 15299,
        ["21188"] = 89953,
        ["21189"] = 188888,
        ["2119"] = 5,
        ["21190"] = 188888,
        ["2120"] = 10,
        ["21203"] = 0,
        ["21205"] = 0,
        ["21209"] = 0,
        ["2121"] = 10,
        ["21211"] = 0,
        ["21212"] = 0,
        ["21213"] = 0,
        ["21214"] = 100000,
        ["21215"] = 0,
        ["21216"] = 0,
        ["21217"] = 125,
        ["21218"] = 0,
        ["21219"] = 1250,
        ["2122"] = 6,
        ["21222"] = 1750,
        ["21223"] = 1500,
        ["21224"] = 3000,
        ["21225"] = 2500,
        ["21226"] = 4000,
        ["21228"] = 2,
        ["21229"] = 0,
        ["2123"] = 9,
        ["21235"] = 0,
        ["2124"] = 6,
        ["21241"] = 0,
        ["21242"] = 82145,
        ["21243"] = 100,
        ["21244"] = 82758,
        ["21245"] = 375,
        ["21249"] = 2,
        ["2125"] = 6,
        ["21250"] = 2,
        ["21251"] = 2,
        ["21253"] = 57,
        ["21254"] = 0,
        ["21256"] = 9661,
        ["21257"] = 71,
        ["21259"] = 1,
        ["2126"] = 12,
        ["21261"] = 1067,
        ["21264"] = 1000,
        ["21266"] = 12,
        ["21267"] = 9022,
        ["21268"] = 86208,
        ["21269"] = 55371,
        ["2127"] = 12,
        ["21271"] = 4676,
        ["21272"] = 65581,
        ["21273"] = 109680,
        ["21275"] = 99954,
        ["21277"] = 1250,
        ["21278"] = 12319,
        ["21279"] = 100000,
        ["21280"] = 100000,
        ["21281"] = 100000,
        ["21282"] = 100000,
        ["21283"] = 100000,
        ["21284"] = 100000,
        ["21285"] = 100000,
        ["21287"] = 100000,
        ["21288"] = 100000,
        ["21289"] = 100000,
        ["2129"] = 15,
        ["21290"] = 100000,
        ["21291"] = 100000,
        ["21292"] = 100000,
        ["21293"] = 100000,
        ["21294"] = 100000,
        ["21295"] = 100000,
        ["21296"] = 100000,
        ["21297"] = 100000,
        ["21298"] = 100000,
        ["21299"] = 100000,
        ["2130"] = 10,
        ["21300"] = 100000,
        ["21302"] = 100000,
        ["21303"] = 100000,
        ["21304"] = 100000,
        ["21306"] = 100000,
        ["21307"] = 100000,
        ["21308"] = 0,
        ["21309"] = 0,
        ["2131"] = 10,
        ["21310"] = 1000,
        ["21311"] = 8473,
        ["21312"] = 6377,
        ["21314"] = 0,
        ["21315"] = 0,
        ["21316"] = 21713,
        ["21317"] = 11675,
        ["21318"] = 7444,
        ["21319"] = 9339,
        ["2132"] = 20,
        ["21320"] = 22497,
        ["21321"] = 0,
        ["21322"] = 26439,
        ["21324"] = 0,
        ["21325"] = 0,
        ["21326"] = 8991,
        ["21327"] = 21490,
        ["21328"] = 0,
        ["21329"] = 43010,
        ["21330"] = 41773,
        ["21331"] = 62274,
        ["21332"] = 58117,
        ["21333"] = 42255,
        ["21334"] = 35991,
        ["21335"] = 24374,
        ["21336"] = 33714,
        ["21337"] = 25378,
        ["21338"] = 24648,
        ["2134"] = 16,
        ["21340"] = 5000,
        ["21341"] = 20000,
        ["21342"] = 80000,
        ["21343"] = 37212,
        ["21344"] = 25198,
        ["21345"] = 25947,
        ["21346"] = 35883,
        ["21347"] = 27007,
        ["21348"] = 24526,
        ["21349"] = 23821,
        ["21350"] = 23913,
        ["21351"] = 35581,
        ["21352"] = 33203,
        ["21353"] = 31246,
        ["21354"] = 30349,
        ["21355"] = 30464,
        ["21356"] = 42134,
        ["21357"] = 45491,
        ["21358"] = 3000,
        ["21359"] = 30922,
        ["2136"] = 0,
        ["21360"] = 32073,
        ["21361"] = 31974,
        ["21362"] = 44219,
        ["21364"] = 47900,
        ["21365"] = 39091,
        ["21366"] = 40364,
        ["21367"] = 40683,
        ["21368"] = 49042,
        ["2137"] = 25,
        ["21370"] = 53161,
        ["21371"] = 20000,
        ["21372"] = 37349,
        ["21373"] = 36438,
        ["21374"] = 53975,
        ["21375"] = 50365,
        ["21376"] = 36851,
        ["21377"] = 200,
        ["2138"] = 38,
        ["21383"] = 200,
        ["21386"] = 12,
        ["21387"] = 47159,
        ["21388"] = 41438,
        ["21389"] = 61776,
        ["2139"] = 11,
        ["21390"] = 57649,
        ["21391"] = 41916,
        ["21392"] = 1350,
        ["21393"] = 3,
        ["21394"] = 0,
        ["21398"] = 9036,
        ["21399"] = 347,
        ["2140"] = 323,
        ["21400"] = 40427,
        ["21401"] = 70,
        ["21402"] = 1,
        ["21403"] = 4,
        ["21404"] = 750,
        ["21409"] = 8736,
        ["2141"] = 1044,
        ["21410"] = 8597,
        ["21411"] = 71,
        ["21412"] = 375,
        ["21415"] = 100,
        ["21416"] = 28989,
        ["21418"] = 38801,
        ["2142"] = 524,
        ["2143"] = 789,
        ["2144"] = 527,
        ["2145"] = 529,
        ["21452"] = 96177,
        ["21453"] = 40467,
        ["21454"] = 35033,
        ["21455"] = 22403,
        ["21456"] = 23424,
        ["21457"] = 27585,
        ["21458"] = 20174,
        ["21459"] = 60738,
        ["2146"] = 961,
        ["21460"] = 42586,
        ["21461"] = 29522,
        ["21462"] = 14816,
        ["21463"] = 22311,
        ["21464"] = 14931,
        ["21466"] = 72521,
        ["21467"] = 36399,
        ["21468"] = 17462,
        ["21469"] = 14605,
        ["21470"] = 17592,
        ["21471"] = 88787,
        ["21472"] = 22251,
        ["21473"] = 82878,
        ["21474"] = 22909,
        ["21475"] = 42918,
        ["21476"] = 36919,
        ["21477"] = 88503,
        ["21478"] = 57620,
        ["21479"] = 27139,
        ["2148"] = 581,
        ["21480"] = 18501,
        ["21481"] = 29346,
        ["21482"] = 25412,
        ["21483"] = 75303,
        ["21484"] = 21244,
        ["21485"] = 45658,
        ["21486"] = 25208,
        ["21487"] = 21566,
        ["21488"] = 67812,
        ["21489"] = 17319,
        ["2149"] = 879,
        ["21490"] = 31182,
        ["21491"] = 14931,
        ["21492"] = 91625,
        ["21493"] = 27587,
        ["21494"] = 14736,
        ["21495"] = 41405,
        ["21496"] = 11872,
        ["21497"] = 26928,
        ["21498"] = 74888,
        ["21499"] = 30059,
        ["2150"] = 586,
        ["21500"] = 12041,
        ["21501"] = 13668,
        ["21502"] = 16466,
        ["21503"] = 19392,
        ["21504"] = 111628,
        ["21505"] = 111628,
        ["21506"] = 111628,
        ["21507"] = 111628,
        ["2151"] = 582,
        ["21513"] = 71,
        ["21517"] = 24982,
        ["21519"] = 0,
        ["2152"] = 1170,
        ["21520"] = 85129,
        ["21521"] = 77306,
        ["21522"] = 142269,
        ["21523"] = 80049,
        ["21524"] = 1,
        ["21525"] = 1,
        ["21526"] = 828085,
        ["21528"] = 2080,
        ["21529"] = 90788,
        ["2153"] = 1185,
        ["21530"] = 49843,
        ["21531"] = 103030,
        ["21532"] = 58116,
        ["21533"] = 20,
        ["21534"] = 2500,
        ["21536"] = 750,
        ["21537"] = 17,
        ["21538"] = 1,
        ["21539"] = 1,
        ["2154"] = 0,
        ["21541"] = 1,
        ["21542"] = 1,
        ["21543"] = 1,
        ["21544"] = 1,
        ["21546"] = 35,
        ["21547"] = 2500,
        ["21548"] = 15000,
        ["21552"] = 5,
        ["21557"] = 6,
        ["21558"] = 6,
        ["21559"] = 6,
        ["2156"] = 615,
        ["21561"] = 6,
        ["21562"] = 6,
        ["21563"] = 188888,
        ["21565"] = 10000,
        ["21566"] = 5000,
        ["21567"] = 10000,
        ["21568"] = 2,
        ["21571"] = 25,
        ["21574"] = 25,
        ["21576"] = 25,
        ["21579"] = 108030,
        ["2158"] = 413,
        ["21581"] = 31789,
        ["21582"] = 18128,
        ["21583"] = 27295,
        ["21585"] = 18333,
        ["21586"] = 23611,
        ["21589"] = 12,
        ["2159"] = 829,
        ["21590"] = 12,
        ["21592"] = 12,
        ["21593"] = 12,
        ["21595"] = 12,
        ["21596"] = 89033,
        ["21597"] = 72651,
        ["21598"] = 29215,
        ["21599"] = 24994,
        ["2160"] = 832,
        ["21600"] = 25090,
        ["21601"] = 79025,
        ["21602"] = 21633,
        ["21603"] = 63026,
        ["21604"] = 17433,
        ["21605"] = 21869,
        ["21606"] = 30903,
        ["21607"] = 26433,
        ["21608"] = 102777,
        ["21609"] = 22184,
        ["2161"] = 0,
        ["21610"] = 56995,
        ["21611"] = 17874,
        ["21615"] = 24614,
        ["21616"] = 59764,
        ["21617"] = 19998,
        ["21618"] = 29040,
        ["21619"] = 16561,
        ["21620"] = 88661,
        ["21621"] = 25024,
        ["21624"] = 25297,
        ["21627"] = 25286,
        ["2163"] = 46710,
        ["21635"] = 100824,
        ["21639"] = 42897,
        ["2164"] = 27032,
        ["21640"] = 0,
        ["21645"] = 31380,
        ["21647"] = 86370,
        ["21648"] = 25088,
        ["2165"] = 45,
        ["21650"] = 79141,
        ["21651"] = 47667,
        ["21652"] = 55824,
        ["2166"] = 811,
        ["21663"] = 33225,
        ["21664"] = 86443,
        ["21665"] = 31373,
        ["21666"] = 91352,
        ["21667"] = 54142,
        ["21668"] = 46588,
        ["21669"] = 29227,
        ["2167"] = 339,
        ["21670"] = 80303,
        ["21671"] = 31415,
        ["21672"] = 19707,
        ["21673"] = 79132,
        ["21674"] = 27960,
        ["21675"] = 19933,
        ["21676"] = 32009,
        ["21677"] = 96853,
        ["21678"] = 99641,
        ["21679"] = 106933,
        ["2168"] = 469,
        ["21681"] = 91369,
        ["21683"] = 44157,
        ["21685"] = 87120,
        ["21686"] = 25548,
        ["21688"] = 40213,
        ["21689"] = 19260,
        ["2169"] = 943,
        ["21690"] = 73749,
        ["21691"] = 27324,
        ["21692"] = 27429,
        ["21693"] = 29332,
        ["21694"] = 23555,
        ["21695"] = 90277,
        ["21696"] = 31641,
        ["21697"] = 23819,
        ["21698"] = 38927,
        ["21699"] = 36256,
        ["21700"] = 90535,
        ["21701"] = 24238,
        ["21702"] = 78630,
        ["21703"] = 101707,
        ["21704"] = 42787,
        ["21705"] = 37039,
        ["21706"] = 43087,
        ["21707"] = 85399,
        ["21708"] = 18740,
        ["21709"] = 113642,
        ["21710"] = 26680,
        ["21711"] = 0,
        ["21712"] = 115200,
        ["21713"] = 250,
        ["21715"] = 78119,
        ["2172"] = 7,
        ["21721"] = 3,
        ["21722"] = 1250,
        ["21723"] = 1250,
        ["21727"] = 275,
        ["21728"] = 275,
        ["21729"] = 275,
        ["2173"] = 6,
        ["21733"] = 4000,
        ["21734"] = 4000,
        ["21735"] = 4000,
        ["21737"] = 4000,
        ["21738"] = 875,
        ["21744"] = 0,
        ["21745"] = 0,
        ["21746"] = 1,
        ["21747"] = 75,
        ["21748"] = 1500,
        ["21749"] = 1,
        ["2175"] = 2683,
        ["21750"] = 1,
        ["21751"] = 1,
        ["21752"] = 1250,
        ["21753"] = 5000,
        ["21754"] = 4307,
        ["21755"] = 4307,
        ["21756"] = 1500,
        ["21758"] = 1500,
        ["21760"] = 1500,
        ["21761"] = 4,
        ["21762"] = 0,
        ["21763"] = 1500,
        ["21764"] = 6420,
        ["21765"] = 2542,
        ["21767"] = 8375,
        ["21768"] = 12500,
        ["21769"] = 1500,
        ["21774"] = 11416,
        ["21775"] = 8375,
        ["21777"] = 3750,
        ["21778"] = 18662,
        ["21779"] = 21305,
        ["21790"] = 7767,
        ["21791"] = 12503,
        ["21792"] = 25218,
        ["21800"] = 39523,
        ["21801"] = 39677,
        ["21802"] = 53107,
        ["21803"] = 27935,
        ["21804"] = 24080,
        ["21805"] = 28147,
        ["21806"] = 69942,
        ["21809"] = 48655,
        ["21810"] = 17039,
        ["21812"] = 0,
        ["21813"] = 32,
        ["21814"] = 56555,
        ["21815"] = 0,
        ["21816"] = 750,
        ["21829"] = 22,
        ["21830"] = 1,
        ["21833"] = 20,
        ["21835"] = 125,
        ["21836"] = 96853,
        ["21837"] = 79716,
        ["21838"] = 31996,
        ["21839"] = 92916,
        ["21840"] = 4000,
        ["21841"] = 10000,
        ["21842"] = 8000,
        ["21843"] = 10000,
        ["21844"] = 8000,
        ["21845"] = 4000,
        ["21846"] = 21632,
        ["21847"] = 21712,
        ["21848"] = 43584,
        ["21849"] = 12261,
        ["21850"] = 12306,
        ["21851"] = 13059,
        ["21852"] = 26926,
        ["21853"] = 21336,
        ["21854"] = 29267,
        ["21855"] = 30091,
        ["21856"] = 99282,
        ["21858"] = 20000,
        ["21859"] = 31883,
        ["2186"] = 6,
        ["21860"] = 24616,
        ["21861"] = 34308,
        ["21862"] = 34437,
        ["21863"] = 20474,
        ["21864"] = 30824,
        ["21865"] = 41251,
        ["21866"] = 17197,
        ["21867"] = 26309,
        ["21868"] = 35486,
        ["21869"] = 32801,
        ["2187"] = 0,
        ["21870"] = 32921,
        ["21871"] = 44055,
        ["21872"] = 40000,
        ["21873"] = 22185,
        ["21874"] = 33398,
        ["21875"] = 41510,
        ["21876"] = 50000,
        ["21877"] = 800,
        ["2188"] = 0,
        ["21881"] = 5000,
        ["21882"] = 2500,
        ["21884"] = 4000,
        ["21885"] = 4000,
        ["21886"] = 4000,
        ["21887"] = 1250,
        ["21888"] = 15430,
        ["21889"] = 28578,
        ["21891"] = 99378,
        ["21892"] = 10000,
        ["21893"] = 10000,
        ["21894"] = 10000,
        ["21895"] = 10000,
        ["21896"] = 10000,
        ["21897"] = 10000,
        ["21898"] = 15000,
        ["21899"] = 15000,
        ["21900"] = 15000,
        ["21901"] = 15000,
        ["21902"] = 20000,
        ["21905"] = 15000,
        ["21908"] = 15000,
        ["21909"] = 15000,
        ["21910"] = 15000,
        ["21911"] = 15000,
        ["21912"] = 15000,
        ["21913"] = 15000,
        ["21914"] = 15000,
        ["21916"] = 15000,
        ["21917"] = 15000,
        ["21918"] = 15000,
        ["21919"] = 15000,
        ["21927"] = 125,
        ["21929"] = 10000,
        ["21931"] = 250,
        ["21932"] = 250,
        ["21933"] = 750,
        ["21934"] = 1500,
        ["21939"] = 100000,
        ["2194"] = 3276,
        ["21940"] = 1250,
        ["21941"] = 1250,
        ["21942"] = 1500,
        ["21943"] = 1500,
        ["21944"] = 1875,
        ["21945"] = 1875,
        ["21947"] = 1875,
        ["21949"] = 2500,
        ["2195"] = 13,
        ["21953"] = 3125,
        ["21957"] = 3375,
        ["21960"] = 0,
        ["21990"] = 1500,
        ["21991"] = 2250,
        ["21992"] = 5000,
        ["21993"] = 10000,
        ["21994"] = 18406,
        ["21995"] = 34276,
        ["21996"] = 18543,
        ["21997"] = 46128,
        ["21998"] = 17731,
        ["21999"] = 34787,
        ["22000"] = 37912,
        ["22001"] = 28117,
        ["22002"] = 13464,
        ["22003"] = 25261,
        ["22004"] = 13913,
        ["22005"] = 26102,
        ["22006"] = 12034,
        ["22007"] = 25791,
        ["22008"] = 19166,
        ["22009"] = 31970,
        ["22010"] = 15451,
        ["22011"] = 15508,
        ["22012"] = 12500,
        ["22013"] = 29212,
        ["22014"] = 333333,
        ["22015"] = 14941,
        ["22016"] = 23809,
        ["22017"] = 32137,
        ["22018"] = 0,
        ["22019"] = 0,
        ["2203"] = 1492,
        ["2204"] = 1133,
        ["22047"] = 14059,
        ["22048"] = 40732,
        ["2205"] = 3961,
        ["22051"] = 5537,
        ["22053"] = 150,
        ["22054"] = 150,
        ["22055"] = 175,
        ["22058"] = 2,
        ["22060"] = 41015,
        ["22061"] = 31009,
        ["22062"] = 11049,
        ["22063"] = 11088,
        ["22064"] = 20800,
        ["22065"] = 20873,
        ["22066"] = 9623,
        ["22067"] = 20624,
        ["22068"] = 15749,
        ["22069"] = 26269,
        ["2207"] = 478,
        ["22070"] = 10578,
        ["22071"] = 10618,
        ["22072"] = 21591,
        ["22073"] = 16043,
        ["22074"] = 20067,
        ["22075"] = 26852,
        ["22076"] = 20213,
        ["22077"] = 10299,
        ["22078"] = 10891,
        ["22079"] = 10929,
        ["2208"] = 730,
        ["22080"] = 20505,
        ["22081"] = 10448,
        ["22082"] = 16572,
        ["22083"] = 27632,
        ["22084"] = 19333,
        ["22085"] = 21034,
        ["22086"] = 18341,
        ["22087"] = 34151,
        ["22088"] = 18477,
        ["22089"] = 45966,
        ["2209"] = 1423,
        ["22090"] = 17667,
        ["22091"] = 34662,
        ["22092"] = 37780,
        ["22093"] = 28020,
        ["22095"] = 16158,
        ["22096"] = 30451,
        ["22097"] = 30427,
        ["22098"] = 16334,
        ["22099"] = 15558,
        ["2210"] = 3,
        ["22100"] = 30953,
        ["22101"] = 23106,
        ["22102"] = 38368,
        ["22103"] = 0,
        ["22105"] = 0,
        ["22106"] = 13023,
        ["22107"] = 24438,
        ["22108"] = 13122,
        ["22109"] = 24619,
        ["2211"] = 7,
        ["22110"] = 12546,
        ["22111"] = 26883,
        ["22112"] = 19976,
        ["22113"] = 33313,
        ["22115"] = 0,
        ["22117"] = 0,
        ["22119"] = 0,
        ["2212"] = 16,
        ["22120"] = 0,
        ["2213"] = 24,
        ["22131"] = 0,
        ["22132"] = 0,
        ["22133"] = 0,
        ["22137"] = 12,
        ["2214"] = 182,
        ["22140"] = 0,
        ["22141"] = 0,
        ["22146"] = 100000,
        ["22147"] = 500,
        ["22148"] = 250,
        ["22149"] = 10283,
        ["2215"] = 81,
        ["22150"] = 10283,
        ["22153"] = 100000,
        ["2216"] = 210,
        ["22167"] = 0,
        ["22168"] = 0,
        ["2217"] = 243,
        ["22173"] = 0,
        ["22176"] = 0,
        ["22179"] = 13500,
        ["2218"] = 501,
        ["22180"] = 6500,
        ["22181"] = 9000,
        ["22182"] = 16750,
        ["22183"] = 8000,
        ["22184"] = 11000,
        ["22185"] = 9000,
        ["22186"] = 13500,
        ["22187"] = 16750,
        ["22188"] = 7250,
        ["22189"] = 16750,
        ["2219"] = 457,
        ["22190"] = 9000,
        ["22191"] = 47549,
        ["22194"] = 23455,
        ["22195"] = 17221,
        ["22196"] = 56466,
        ["22197"] = 18915,
        ["22198"] = 47188,
        ["2220"] = 519,
        ["22202"] = 2500,
        ["22203"] = 5000,
        ["22204"] = 12403,
        ["22205"] = 14998,
        ["22207"] = 15047,
        ["22208"] = 57079,
        ["22209"] = 12500,
        ["2221"] = 910,
        ["22212"] = 18636,
        ["22214"] = 12500,
        ["22217"] = 0,
        ["22218"] = 0,
        ["2222"] = 1005,
        ["22220"] = 12500,
        ["22223"] = 19722,
        ["22225"] = 14937,
        ["2223"] = 0,
        ["22231"] = 15880,
        ["22232"] = 14421,
        ["22234"] = 9713,
        ["22235"] = 0,
        ["22236"] = 0,
        ["22237"] = 0,
        ["22238"] = 0,
        ["22239"] = 0,
        ["2224"] = 24,
        ["22240"] = 14972,
        ["22241"] = 15739,
        ["22242"] = 11923,
        ["22245"] = 12375,
        ["22246"] = 2500,
        ["22247"] = 16087,
        ["22248"] = 10000,
        ["22249"] = 30000,
        ["2225"] = 183,
        ["22250"] = 250,
        ["22251"] = 10000,
        ["22252"] = 30000,
        ["22253"] = 34450,
        ["22254"] = 30655,
        ["22255"] = 32802,
        ["22256"] = 8236,
        ["22257"] = 36127,
        ["22259"] = 0,
        ["2226"] = 4118,
        ["22260"] = 0,
        ["22261"] = 0,
        ["22262"] = 0,
        ["22263"] = 1,
        ["22266"] = 43878,
        ["22267"] = 16084,
        ["22268"] = 66290,
        ["22269"] = 16199,
        ["2227"] = 4133,
        ["22270"] = 20755,
        ["22271"] = 22328,
        ["22272"] = 15152,
        ["22274"] = 15270,
        ["22275"] = 15383,
        ["22276"] = 1,
        ["22277"] = 1,
        ["22278"] = 1,
        ["22279"] = 1,
        ["22280"] = 1,
        ["22281"] = 1,
        ["22282"] = 1,
        ["22283"] = 0,
        ["22284"] = 0,
        ["22285"] = 0,
        ["22286"] = 0,
        ["22287"] = 0,
        ["22288"] = 0,
        ["22289"] = 0,
        ["22290"] = 0,
        ["22291"] = 0,
        ["22294"] = 1,
        ["22298"] = 1070,
        ["22299"] = 37,
        ["2230"] = 714,
        ["22300"] = 3830,
        ["22301"] = 20983,
        ["22302"] = 17549,
        ["22304"] = 10322,
        ["22305"] = 15538,
        ["22306"] = 10765,
        ["22307"] = 1500,
        ["22308"] = 5000,
        ["22309"] = 12500,
        ["2231"] = 4386,
        ["22310"] = 5000,
        ["22311"] = 14758,
        ["22312"] = 12500,
        ["22313"] = 9912,
        ["22314"] = 62189,
        ["22315"] = 49937,
        ["22317"] = 50306,
        ["22318"] = 37869,
        ["22319"] = 38664,
        ["2232"] = 812,
        ["22320"] = 12,
        ["22321"] = 10539,
        ["22322"] = 51234,
        ["22324"] = 200,
        ["22325"] = 12019,
        ["22326"] = 15282,
        ["22327"] = 2535,
        ["22328"] = 34980,
        ["22329"] = 34450,
        ["2233"] = 1690,
        ["22330"] = 14701,
        ["22331"] = 36253,
        ["22332"] = 50053,
        ["22333"] = 67357,
        ["22334"] = 13782,
        ["22335"] = 64130,
        ["22336"] = 32957,
        ["22337"] = 15506,
        ["22339"] = 15282,
        ["2234"] = 1806,
        ["22340"] = 65328,
        ["22342"] = 21605,
        ["22343"] = 16260,
        ["22345"] = 14620,
        ["22347"] = 38332,
        ["22348"] = 64134,
        ["2235"] = 1281,
        ["2236"] = 3386,
        ["2237"] = 75,
        ["22373"] = 0,
        ["22374"] = 675,
        ["22375"] = 0,
        ["22376"] = 0,
        ["22377"] = 54468,
        ["22378"] = 54665,
        ["22379"] = 54862,
        ["2238"] = 60,
        ["22380"] = 55053,
        ["22383"] = 73223,
        ["22384"] = 72503,
        ["22385"] = 44234,
        ["22388"] = 15000,
        ["22389"] = 20000,
        ["22390"] = 20000,
        ["22393"] = 14750,
        ["22394"] = 64707,
        ["22395"] = 12973,
        ["22396"] = 25392,
        ["22397"] = 13067,
        ["22398"] = 15755,
        ["22399"] = 25666,
        ["2240"] = 121,
        ["22400"] = 13208,
        ["22401"] = 15924,
        ["22402"] = 25942,
        ["22403"] = 41953,
        ["22404"] = 52913,
        ["22405"] = 14415,
        ["22406"] = 61968,
        ["22407"] = 18658,
        ["22408"] = 38489,
        ["22409"] = 25221,
        ["2241"] = 408,
        ["22410"] = 15509,
        ["22411"] = 27190,
        ["22412"] = 15624,
        ["22414"] = 0,
        ["22416"] = 68505,
        ["22417"] = 66097,
        ["22418"] = 49653,
        ["22419"] = 48830,
        ["22420"] = 49006,
        ["22421"] = 33715,
        ["22422"] = 31441,
        ["22423"] = 31561,
        ["22424"] = 31681,
        ["22425"] = 65783,
        ["22426"] = 31919,
        ["22427"] = 63714,
        ["22428"] = 47873,
        ["22429"] = 47082,
        ["2243"] = 65783,
        ["22430"] = 47257,
        ["22431"] = 32516,
        ["22433"] = 15282,
        ["22436"] = 58712,
        ["22437"] = 56644,
        ["22438"] = 39580,
        ["22439"] = 39109,
        ["2244"] = 51858,
        ["22440"] = 39260,
        ["22441"] = 26691,
        ["22442"] = 26794,
        ["22443"] = 26896,
        ["22445"] = 0,
        ["22446"] = 0,
        ["22447"] = 0,
        ["22448"] = 8962,
        ["22449"] = 0,
        ["2245"] = 27636,
        ["22451"] = 4000,
        ["22452"] = 4000,
        ["22456"] = 4000,
        ["22457"] = 4000,
        ["22458"] = 37892,
        ["2246"] = 30000,
        ["22461"] = 1250,
        ["22462"] = 32000,
        ["22463"] = 40000,
        ["22464"] = 56155,
        ["22465"] = 54191,
        ["22466"] = 40797,
        ["22467"] = 40302,
        ["22468"] = 40453,
        ["22469"] = 27502,
        ["22470"] = 28338,
        ["22471"] = 28438,
        ["22472"] = 19500,
        ["22476"] = 50184,
        ["22477"] = 48416,
        ["22478"] = 32973,
        ["22479"] = 32436,
        ["22480"] = 32562,
        ["22481"] = 22238,
        ["22482"] = 22321,
        ["22483"] = 22406,
        ["22488"] = 48769,
        ["22489"] = 47055,
        ["2249"] = 91,
        ["22490"] = 35416,
        ["22491"] = 34830,
        ["22492"] = 34955,
        ["22493"] = 23864,
        ["22494"] = 23950,
        ["22495"] = 24035,
        ["22496"] = 40143,
        ["22497"] = 38726,
        ["22498"] = 26376,
        ["22499"] = 25946,
        ["2250"] = 0,
        ["22500"] = 26046,
        ["22501"] = 17787,
        ["22502"] = 18344,
        ["22503"] = 18412,
        ["22504"] = 38446,
        ["22505"] = 37094,
        ["22506"] = 27923,
        ["22507"] = 27462,
        ["22508"] = 27560,
        ["22509"] = 18818,
        ["2251"] = 12,
        ["22510"] = 18886,
        ["22511"] = 18955,
        ["22512"] = 39571,
        ["22513"] = 38179,
        ["22514"] = 28737,
        ["22515"] = 28260,
        ["22516"] = 28358,
        ["22517"] = 19361,
        ["22518"] = 18071,
        ["22519"] = 18139,
        ["2252"] = 0,
        ["22521"] = 1500,
        ["22522"] = 1500,
        ["22523"] = 0,
        ["22524"] = 0,
        ["22525"] = 200,
        ["22526"] = 200,
        ["22527"] = 200,
        ["22528"] = 200,
        ["22529"] = 200,
        ["22531"] = 15000,
        ["22533"] = 15000,
        ["22534"] = 20000,
        ["22535"] = 25000,
        ["22536"] = 25000,
        ["22537"] = 25000,
        ["22538"] = 50000,
        ["2254"] = 506,
        ["22541"] = 20000,
        ["22547"] = 15000,
        ["22551"] = 15000,
        ["22553"] = 20000,
        ["22558"] = 25000,
        ["22559"] = 15000,
        ["2256"] = 2996,
        ["22562"] = 12500,
        ["22563"] = 17500,
        ["22565"] = 15000,
        ["22568"] = 20475,
        ["2257"] = 189,
        ["22572"] = 400,
        ["22573"] = 400,
        ["22574"] = 400,
        ["22575"] = 400,
        ["22576"] = 400,
        ["22577"] = 400,
        ["22578"] = 400,
        ["2258"] = 83,
        ["2259"] = 75,
        ["22595"] = 4814,
        ["2260"] = 106,
        ["22600"] = 63086,
        ["22601"] = 30,
        ["22604"] = 60,
        ["22605"] = 30,
        ["22610"] = 40,
        ["22611"] = 19065,
        ["22613"] = 162,
        ["22614"] = 10000,
        ["22615"] = 12839,
        ["22616"] = 1000,
        ["22617"] = 3211,
        ["22618"] = 6,
        ["2262"] = 8746,
        ["22620"] = 11794,
        ["22621"] = 2316,
        ["22622"] = 1000,
        ["2263"] = 2346,
        ["22630"] = 185158,
        ["22631"] = 172821,
        ["22632"] = 173474,
        ["2264"] = 1957,
        ["22641"] = 146,
        ["22644"] = 12,
        ["22645"] = 25,
        ["22647"] = 100,
        ["22648"] = 12,
        ["22649"] = 12,
        ["2265"] = 477,
        ["22650"] = 12,
        ["22651"] = 20,
        ["22652"] = 33356,
        ["22654"] = 16804,
        ["22655"] = 16865,
        ["22656"] = 49612,
        ["22657"] = 33625,
        ["22658"] = 25580,
        ["22659"] = 33625,
        ["2266"] = 479,
        ["22660"] = 17213,
        ["22667"] = 12789,
        ["22668"] = 16048,
        ["2267"] = 711,
        ["22672"] = 2288,
        ["22673"] = 7650,
        ["22678"] = 111303,
        ["22679"] = 8750,
        ["2268"] = 146,
        ["22680"] = 10709,
        ["22681"] = 10709,
        ["22682"] = 20000,
        ["22683"] = 22500,
        ["22688"] = 52177,
        ["22689"] = 19639,
        ["22690"] = 31542,
        ["22691"] = 110631,
        ["22707"] = 98660,
        ["22708"] = 0,
        ["2271"] = 3255,
        ["22710"] = 30,
        ["22711"] = 22162,
        ["22712"] = 16737,
        ["22713"] = 55994,
        ["22714"] = 19782,
        ["22715"] = 16919,
        ["22716"] = 11320,
        ["22718"] = 21379,
        ["22720"] = 17224,
        ["22721"] = 64030,
        ["22722"] = 64030,
        ["22725"] = 38790,
        ["22728"] = 5000,
        ["22730"] = 18480,
        ["22731"] = 27821,
        ["22732"] = 86443,
        ["2274"] = 289,
        ["22741"] = 0,
        ["22742"] = 1,
        ["22743"] = 1,
        ["22744"] = 1,
        ["22745"] = 1,
        ["22756"] = 23205,
        ["22757"] = 17465,
        ["22758"] = 17528,
        ["22759"] = 20424,
        ["2276"] = 4093,
        ["22760"] = 20503,
        ["22761"] = 13719,
        ["22762"] = 38562,
        ["22763"] = 19465,
        ["22764"] = 19537,
        ["22766"] = 12500,
        ["22767"] = 12500,
        ["22768"] = 12500,
        ["2277"] = 3620,
        ["22772"] = 12500,
        ["22773"] = 12500,
        ["22774"] = 12500,
        ["2278"] = 2326,
        ["22783"] = 1387,
        ["22784"] = 802,
        ["22785"] = 500,
        ["22786"] = 500,
        ["22787"] = 600,
        ["22788"] = 750,
        ["22789"] = 500,
        ["22790"] = 750,
        ["22791"] = 1000,
        ["22792"] = 1250,
        ["22793"] = 2500,
        ["22794"] = 10000,
        ["22795"] = 0,
        ["22797"] = 1250,
        ["22798"] = 111458,
        ["22799"] = 111889,
        ["2280"] = 4023,
        ["22800"] = 105618,
        ["22801"] = 106023,
        ["22802"] = 90536,
        ["22803"] = 83651,
        ["22804"] = 85783,
        ["22806"] = 84594,
        ["22807"] = 86747,
        ["22808"] = 89393,
        ["22809"] = 112147,
        ["2281"] = 300,
        ["22810"] = 66096,
        ["22811"] = 67768,
        ["22812"] = 72327,
        ["22813"] = 111341,
        ["22815"] = 112134,
        ["22816"] = 91970,
        ["22818"] = 53656,
        ["22819"] = 58990,
        ["2282"] = 139,
        ["22820"] = 63364,
        ["22821"] = 69654,
        ["22823"] = 2500,
        ["22824"] = 2500,
        ["22825"] = 2500,
        ["22826"] = 2500,
        ["22827"] = 2500,
        ["22828"] = 2500,
        ["22829"] = 5000,
        ["2283"] = 140,
        ["22831"] = 4000,
        ["22832"] = 5000,
        ["22833"] = 2500,
        ["22834"] = 4000,
        ["22835"] = 6000,
        ["22836"] = 5000,
        ["22837"] = 5000,
        ["22838"] = 5000,
        ["22839"] = 5000,
        ["2284"] = 211,
        ["22840"] = 6000,
        ["22843"] = 21125,
        ["22844"] = 6000,
        ["22847"] = 6000,
        ["22848"] = 7000,
        ["22849"] = 7000,
        ["22851"] = 20000,
        ["22852"] = 10,
        ["22853"] = 20000,
        ["22854"] = 20000,
        ["22855"] = 8577,
        ["22856"] = 63086,
        ["22857"] = 30,
        ["22859"] = 1768,
        ["22860"] = 60,
        ["22861"] = 20000,
        ["22862"] = 10000,
        ["22866"] = 20000,
        ["22867"] = 19065,
        ["22869"] = 162,
        ["2287"] = 6,
        ["22870"] = 10000,
        ["22871"] = 5000,
        ["22872"] = 1000,
        ["22873"] = 3211,
        ["22875"] = 583,
        ["22877"] = 2316,
        ["22878"] = 1000,
        ["2288"] = 0,
        ["22880"] = 13657,
        ["22883"] = 8309,
        ["22884"] = 30,
        ["22885"] = 500,
        ["22887"] = 100,
        ["2289"] = 87,
        ["22890"] = 10000,
        ["22891"] = 10000,
        ["22895"] = 0,
        ["22897"] = 10000,
        ["2290"] = 75,
        ["22900"] = 7500,
        ["22901"] = 7500,
        ["22902"] = 10000,
        ["22903"] = 10000,
        ["22905"] = 12500,
        ["22907"] = 12500,
        ["22908"] = 15000,
        ["22909"] = 12500,
        ["2291"] = 44580,
        ["22910"] = 20000,
        ["22911"] = 12500,
        ["22912"] = 20000,
        ["22913"] = 20000,
        ["22914"] = 20000,
        ["22915"] = 20000,
        ["22917"] = 20000,
        ["22918"] = 20000,
        ["2292"] = 1334,
        ["22922"] = 25000,
        ["22925"] = 25000,
        ["22926"] = 25000,
        ["22927"] = 15000,
        ["22936"] = 30895,
        ["22937"] = 72651,
        ["22938"] = 26523,
        ["22939"] = 60256,
        ["22941"] = 33516,
        ["22942"] = 87803,
        ["22943"] = 102777,
        ["22947"] = 88355,
        ["2295"] = 70,
        ["22951"] = 27,
        ["22952"] = 16,
        ["22953"] = 33,
        ["22954"] = 91160,
        ["22955"] = 0,
        ["22956"] = 57,
        ["22957"] = 57,
        ["22958"] = 182,
        ["22959"] = 183,
        ["2296"] = 50,
        ["22960"] = 26713,
        ["22961"] = 113642,
        ["22962"] = 0,
        ["22963"] = 149,
        ["22964"] = 24,
        ["22965"] = 20,
        ["22966"] = 16,
        ["22969"] = 230,
        ["22971"] = 231,
        ["22979"] = 403,
        ["22980"] = 2493,
        ["22981"] = 128862,
        ["22982"] = 1507,
        ["22983"] = 26999,
        ["22984"] = 1879,
        ["22985"] = 407,
        ["22986"] = 272,
        ["22987"] = 342,
        ["22988"] = 85160,
        ["2299"] = 8757,
        ["22990"] = 576,
        ["22991"] = 208,
        ["22992"] = 261,
        ["22993"] = 316,
        ["22994"] = 91352,
        ["22995"] = 2448,
        ["22996"] = 911,
        ["22997"] = 1072,
        ["22998"] = 717,
        ["22999"] = 2500,
        ["2300"] = 192,
        ["23000"] = 63636,
        ["23001"] = 91160,
        ["23002"] = 0,
        ["23003"] = 0,
        ["23004"] = 25159,
        ["23005"] = 25253,
        ["23006"] = 25351,
        ["23007"] = 0,
        ["23009"] = 64100,
        ["23014"] = 85238,
        ["23017"] = 27110,
        ["23018"] = 60256,
        ["2302"] = 29,
        ["23021"] = 18331,
        ["23023"] = 86443,
        ["23025"] = 60256,
        ["23027"] = 91160,
        ["23029"] = 72651,
        ["2303"] = 71,
        ["23030"] = 25734,
        ["23031"] = 60256,
        ["23035"] = 26915,
        ["23036"] = 88355,
        ["23038"] = 60256,
        ["23039"] = 113747,
        ["2304"] = 15,
        ["23041"] = 91160,
        ["23043"] = 57405,
        ["23044"] = 83837,
        ["23045"] = 27117,
        ["23047"] = 91160,
        ["23048"] = 72651,
        ["23049"] = 72651,
        ["23050"] = 28385,
        ["23053"] = 86443,
        ["23054"] = 95047,
        ["23055"] = 0,
        ["23056"] = 95737,
        ["23057"] = 102777,
        ["23060"] = 60256,
        ["23062"] = 60256,
        ["23063"] = 60256,
        ["23066"] = 60256,
        ["23067"] = 60256,
        ["23068"] = 61207,
        ["23069"] = 35844,
        ["2307"] = 243,
        ["23070"] = 35976,
        ["23071"] = 44201,
        ["23073"] = 33391,
        ["23075"] = 57402,
        ["23077"] = 10000,
        ["23078"] = 18870,
        ["23079"] = 10000,
        ["2308"] = 214,
        ["23081"] = 12591,
        ["23082"] = 15167,
        ["23083"] = 2623,
        ["23084"] = 10187,
        ["23085"] = 20451,
        ["23087"] = 36057,
        ["23088"] = 31018,
        ["23089"] = 25944,
        ["2309"] = 268,
        ["23090"] = 18332,
        ["23091"] = 10454,
        ["23092"] = 15737,
        ["23093"] = 13162,
        ["23094"] = 10000,
        ["23095"] = 10000,
        ["23096"] = 10000,
        ["23097"] = 10000,
        ["23098"] = 10000,
        ["23099"] = 10000,
        ["2310"] = 89,
        ["23100"] = 10000,
        ["23101"] = 10000,
        ["23103"] = 10000,
        ["23104"] = 10000,
        ["23105"] = 10000,
        ["23106"] = 20000,
        ["23107"] = 10000,
        ["23108"] = 10000,
        ["23109"] = 10000,
        ["2311"] = 150,
        ["23110"] = 10000,
        ["23111"] = 10000,
        ["23112"] = 10000,
        ["23113"] = 10000,
        ["23114"] = 10000,
        ["23115"] = 10000,
        ["23116"] = 10000,
        ["23117"] = 10000,
        ["23118"] = 10000,
        ["23119"] = 10000,
        ["2312"] = 181,
        ["23120"] = 10000,
        ["23121"] = 10000,
        ["23122"] = 40,
        ["23123"] = 40,
        ["23124"] = 61095,
        ["23125"] = 41953,
        ["23126"] = 9847,
        ["23127"] = 15448,
        ["23128"] = 10198,
        ["23129"] = 11269,
        ["2313"] = 200,
        ["23130"] = 10000,
        ["23131"] = 12500,
        ["23132"] = 53100,
        ["23133"] = 15000,
        ["23134"] = 15000,
        ["23135"] = 10000,
        ["23136"] = 12500,
        ["23137"] = 15000,
        ["23138"] = 15000,
        ["23139"] = 31549,
        ["2314"] = 743,
        ["23140"] = 10000,
        ["23141"] = 12500,
        ["23142"] = 15000,
        ["23143"] = 15000,
        ["23144"] = 10000,
        ["23145"] = 12500,
        ["23146"] = 15000,
        ["23147"] = 15000,
        ["23148"] = 10000,
        ["23149"] = 12500,
        ["2315"] = 307,
        ["23150"] = 15000,
        ["23151"] = 15000,
        ["23152"] = 10000,
        ["23153"] = 12500,
        ["23154"] = 15000,
        ["23155"] = 15000,
        ["23156"] = 13113,
        ["2316"] = 408,
        ["23160"] = 200,
        ["23161"] = 200,
        ["23168"] = 2665,
        ["23169"] = 3482,
        ["2317"] = 689,
        ["23170"] = 2684,
        ["23171"] = 4213,
        ["23173"] = 1357,
        ["23177"] = 10536,
        ["23178"] = 4230,
        ["2318"] = 15,
        ["2319"] = 50,
        ["23192"] = 7143,
        ["23194"] = 0,
        ["23196"] = 0,
        ["23197"] = 15690,
        ["23198"] = 15749,
        ["23199"] = 15808,
        ["2320"] = 2,
        ["23200"] = 15867,
        ["23201"] = 15925,
        ["23203"] = 16043,
        ["23205"] = 0,
        ["2321"] = 25,
        ["23219"] = 31190,
        ["23220"] = 35572,
        ["23221"] = 87413,
        ["23226"] = 45674,
        ["23237"] = 60256,
        ["23238"] = 55321,
        ["23239"] = 0,
        ["2324"] = 6,
        ["23242"] = 94813,
        ["23246"] = 0,
        ["23248"] = 0,
        ["2325"] = 250,
        ["2326"] = 29,
        ["23260"] = 6147,
        ["23265"] = 58,
        ["23266"] = 98,
        ["23267"] = 59,
        ["23268"] = 0,
        ["23269"] = 0,
        ["2327"] = 36,
        ["23270"] = 0,
        ["23282"] = 1,
        ["23284"] = 1,
        ["23285"] = 922,
        ["23286"] = 1,
        ["23287"] = 1,
        ["23288"] = 6993,
        ["23289"] = 9442,
        ["23290"] = 1,
        ["23292"] = 10,
        ["23293"] = 41,
        ["23294"] = 789,
        ["23296"] = 13815,
        ["23298"] = 6203,
        ["23299"] = 13877,
        ["23300"] = 171,
        ["23301"] = 245,
        ["23302"] = 2,
        ["23303"] = 15149,
        ["23304"] = 9661,
        ["23306"] = 1,
        ["23307"] = 3379,
        ["23308"] = 1,
        ["23309"] = 1,
        ["23310"] = 1,
        ["23311"] = 1,
        ["23312"] = 33835,
        ["23313"] = 3,
        ["23314"] = 29082,
        ["23315"] = 9022,
        ["23316"] = 1,
        ["23318"] = 1,
        ["23319"] = 1,
        ["23320"] = 100000,
        ["23321"] = 1,
        ["23323"] = 1,
        ["23324"] = 1,
        ["23326"] = 9572,
        ["23327"] = 14059,
        ["23329"] = 5,
        ["23331"] = 4,
        ["23332"] = 3,
        ["23333"] = 5,
        ["23334"] = 10,
        ["23336"] = 0,
        ["23345"] = 1,
        ["23346"] = 9,
        ["23353"] = 3,
        ["23354"] = 6,
        ["23355"] = 0,
        ["23358"] = 0,
        ["23367"] = 9,
        ["23370"] = 38,
        ["23371"] = 48,
        ["23372"] = 72,
        ["23373"] = 58,
        ["23375"] = 19,
        ["23376"] = 11,
        ["23377"] = 15,
        ["23379"] = 79,
        ["23387"] = 0,
        ["23389"] = 15,
        ["23390"] = 29,
        ["23395"] = 73,
        ["23396"] = 115,
        ["23397"] = 23,
        ["23398"] = 86,
        ["23399"] = 100,
        ["23400"] = 255,
        ["23401"] = 802,
        ["23402"] = 577,
        ["23403"] = 347,
        ["23404"] = 218,
        ["23405"] = 194,
        ["23406"] = 368,
        ["23407"] = 246,
        ["23408"] = 309,
        ["23409"] = 1072,
        ["23410"] = 1435,
        ["23411"] = 1800,
        ["23412"] = 429,
        ["23413"] = 286,
        ["23414"] = 359,
        ["23415"] = 726,
        ["23423"] = 293,
        ["23424"] = 1000,
        ["23425"] = 1500,
        ["23426"] = 2500,
        ["23427"] = 1250,
        ["23436"] = 30000,
        ["23437"] = 30000,
        ["23438"] = 30000,
        ["23439"] = 30000,
        ["23440"] = 30000,
        ["23441"] = 30000,
        ["23445"] = 2000,
        ["23446"] = 3000,
        ["23447"] = 2500,
        ["23448"] = 22500,
        ["23449"] = 12500,
        ["23451"] = 3337,
        ["23466"] = 5207,
        ["23467"] = 2964,
        ["23468"] = 1450,
        ["23473"] = 1,
        ["23474"] = 1,
        ["23475"] = 1,
        ["23476"] = 1,
        ["23479"] = 1,
        ["23480"] = 0,
        ["23482"] = 20269,
        ["23483"] = 0,
        ["23484"] = 20969,
        ["23485"] = 0,
        ["23487"] = 33419,
        ["23488"] = 44805,
        ["23489"] = 47475,
        ["23490"] = 39760,
        ["23491"] = 18866,
        ["23493"] = 27683,
        ["23494"] = 19615,
        ["23497"] = 58164,
        ["23499"] = 79583,
        ["23502"] = 82647,
        ["23503"] = 85143,
        ["23504"] = 68364,
        ["23505"] = 70380,
        ["23506"] = 28586,
        ["23507"] = 58548,
        ["23508"] = 28793,
        ["23509"] = 62984,
        ["23510"] = 31529,
        ["23511"] = 47104,
        ["23512"] = 64163,
        ["23513"] = 64391,
        ["23514"] = 32234,
        ["23515"] = 29607,
        ["23516"] = 44599,
        ["23517"] = 30311,
        ["23518"] = 60504,
        ["23519"] = 45822,
        ["23520"] = 30896,
        ["23521"] = 46159,
        ["23522"] = 61891,
        ["23523"] = 61628,
        ["23524"] = 31103,
        ["23525"] = 46837,
        ["23526"] = 26912,
        ["23527"] = 54020,
        ["23528"] = 750,
        ["23529"] = 1000,
        ["23530"] = 12000,
        ["23531"] = 31259,
        ["23532"] = 36818,
        ["23533"] = 36955,
        ["23534"] = 47423,
        ["23535"] = 55431,
        ["23536"] = 55635,
        ["23537"] = 37514,
        ["23538"] = 37654,
        ["23539"] = 37795,
        ["23540"] = 107762,
        ["23541"] = 135202,
        ["23542"] = 108562,
        ["23543"] = 136202,
        ["23544"] = 109350,
        ["23546"] = 137687,
        ["23550"] = 0,
        ["23554"] = 91813,
        ["23555"] = 105763,
        ["23556"] = 106163,
        ["23557"] = 63465,
        ["23558"] = 1807,
        ["23559"] = 750,
        ["23563"] = 67081,
        ["23564"] = 75985,
        ["23565"] = 87849,
        ["23568"] = 0,
        ["23570"] = 1807,
        ["23571"] = 16000,
        ["23572"] = 16000,
        ["23573"] = 30000,
        ["23574"] = 20000,
        ["23575"] = 1500,
        ["23576"] = 1250,
        ["23577"] = 91925,
        ["23587"] = 18522,
        ["23590"] = 10000,
        ["23591"] = 10000,
        ["23592"] = 10000,
        ["23593"] = 10000,
        ["23594"] = 15000,
        ["23595"] = 15000,
        ["23596"] = 15000,
        ["23597"] = 15000,
        ["23598"] = 15000,
        ["23599"] = 15000,
        ["236"] = 559,
        ["23600"] = 20000,
        ["23601"] = 15000,
        ["23602"] = 15000,
        ["23603"] = 15000,
        ["23604"] = 20000,
        ["23606"] = 15000,
        ["23608"] = 60000,
        ["23609"] = 60000,
        ["2361"] = 9,
        ["23611"] = 20000,
        ["23617"] = 15000,
        ["23618"] = 15000,
        ["23619"] = 15000,
        ["2362"] = 1,
        ["23622"] = 120000,
        ["23623"] = 120000,
        ["23624"] = 120000,
        ["23625"] = 120000,
        ["23626"] = 120000,
        ["23627"] = 120000,
        ["23628"] = 120000,
        ["23629"] = 120000,
        ["23630"] = 120000,
        ["23632"] = 120000,
        ["23634"] = 120000,
        ["23635"] = 120000,
        ["23636"] = 120000,
        ["23637"] = 120000,
        ["23638"] = 15000,
        ["23639"] = 75000,
        ["2364"] = 59,
        ["23654"] = 0,
        ["2366"] = 59,
        ["23662"] = 0,
        ["23663"] = 25793,
        ["23664"] = 39007,
        ["23665"] = 51978,
        ["23666"] = 30610,
        ["23667"] = 45741,
        ["23668"] = 61330,
        ["23669"] = 0,
        ["2367"] = 44,
        ["23676"] = 5,
        ["23677"] = 0,
        ["23678"] = 0,
        ["23685"] = 0,
        ["2369"] = 30,
        ["23692"] = 0,
        ["23693"] = 0,
        ["237"] = 561,
        ["2370"] = 75,
        ["23705"] = 225,
        ["2371"] = 37,
        ["23711"] = 4500,
        ["2372"] = 68,
        ["23723"] = 0,
        ["2373"] = 51,
        ["23730"] = 6500,
        ["23731"] = 15000,
        ["23734"] = 3750,
        ["23736"] = 2500,
        ["23737"] = 2500,
        ["23738"] = 0,
        ["23739"] = 0,
        ["2374"] = 34,
        ["23742"] = 47216,
        ["23745"] = 3750,
        ["23746"] = 55725,
        ["23747"] = 62413,
        ["23748"] = 66312,
        ["2375"] = 34,
        ["23755"] = 15000,
        ["23756"] = 10,
        ["23757"] = 0,
        ["23758"] = 29667,
        ["23759"] = 0,
        ["2376"] = 89,
        ["23761"] = 20534,
        ["23762"] = 25324,
        ["23763"] = 31774,
        ["23764"] = 2500,
        ["23765"] = 2500,
        ["23766"] = 20000,
        ["23772"] = 20,
        ["23773"] = 25,
        ["23774"] = 30000,
        ["23779"] = 0,
        ["2378"] = 0,
        ["23781"] = 500,
        ["23782"] = 8000,
        ["23783"] = 1500,
        ["23784"] = 10000,
        ["23785"] = 30000,
        ["2379"] = 15,
        ["23792"] = 0,
        ["23793"] = 6250,
        ["23799"] = 20000,
        ["238"] = 422,
        ["2380"] = 7,
        ["23802"] = 37500,
        ["23804"] = 20000,
        ["23805"] = 20000,
        ["23807"] = 15000,
        ["23808"] = 40000,
        ["2381"] = 15,
        ["23811"] = 15000,
        ["23814"] = 15000,
        ["23815"] = 15000,
        ["23816"] = 10000,
        ["2382"] = 0,
        ["23823"] = 100000,
        ["23824"] = 32734,
        ["23825"] = 11565,
        ["23829"] = 38321,
        ["2383"] = 11,
        ["23835"] = 22500,
        ["23836"] = 22500,
        ["23839"] = 44345,
        ["2384"] = 7,
        ["2385"] = 7,
        ["2386"] = 15,
        ["23864"] = 0,
        ["23868"] = 0,
        ["2387"] = 7,
        ["23875"] = 0,
        ["2388"] = 15,
        ["23881"] = 0,
        ["23884"] = 20000,
        ["23885"] = 12500,
        ["23886"] = 0,
        ["2389"] = 11,
        ["23894"] = 0,
        ["23899"] = 0,
        ["239"] = 282,
        ["2390"] = 7,
        ["23909"] = 7,
        ["2391"] = 7,
        ["2392"] = 82,
        ["23923"] = 582,
        ["23924"] = 17,
        ["23927"] = 0,
        ["23928"] = 0,
        ["2393"] = 41,
        ["23933"] = 0,
        ["23938"] = 1325,
        ["23939"] = 1185,
        ["2394"] = 83,
        ["23944"] = 7,
        ["23945"] = 8,
        ["23946"] = 9,
        ["23947"] = 14,
        ["23948"] = 17,
        ["23949"] = 22,
        ["2395"] = 64,
        ["2396"] = 43,
        ["23965"] = 870,
        ["2397"] = 43,
        ["23976"] = 705,
        ["23977"] = 498,
        ["23978"] = 605,
        ["23979"] = 990,
        ["2398"] = 86,
        ["2399"] = 43,
        ["23995"] = 0,
        ["23999"] = 2500,
        ["2400"] = 87,
        ["24000"] = 15000,
        ["24001"] = 12500,
        ["24002"] = 15000,
        ["24003"] = 15000,
        ["24004"] = 2500,
        ["24006"] = 100,
        ["24007"] = 100,
        ["24008"] = 225,
        ["24009"] = 225,
        ["2401"] = 66,
        ["2402"] = 44,
        ["24020"] = 63979,
        ["24021"] = 44959,
        ["24022"] = 38681,
        ["24023"] = 16179,
        ["24024"] = 19489,
        ["24027"] = 30000,
        ["24028"] = 30000,
        ["24029"] = 30000,
        ["2403"] = 44,
        ["24030"] = 30000,
        ["24031"] = 30000,
        ["24032"] = 30000,
        ["24033"] = 30000,
        ["24036"] = 30000,
        ["24037"] = 30000,
        ["24039"] = 30000,
        ["24044"] = 81199,
        ["24045"] = 13782,
        ["24046"] = 40337,
        ["24047"] = 30000,
        ["24048"] = 30000,
        ["24050"] = 30000,
        ["24051"] = 30000,
        ["24052"] = 30000,
        ["24054"] = 30000,
        ["24055"] = 30000,
        ["24056"] = 30000,
        ["24057"] = 30000,
        ["24058"] = 30000,
        ["24059"] = 30000,
        ["2406"] = 25,
        ["24060"] = 30000,
        ["24061"] = 30000,
        ["24062"] = 30000,
        ["24063"] = 16619,
        ["24064"] = 34963,
        ["24065"] = 30000,
        ["24066"] = 30000,
        ["24067"] = 30000,
        ["24069"] = 84950,
        ["2407"] = 162,
        ["24072"] = 6,
        ["24073"] = 10283,
        ["24074"] = 24491,
        ["24075"] = 24491,
        ["24076"] = 25650,
        ["24077"] = 27388,
        ["24078"] = 27388,
        ["24079"] = 38775,
        ["2408"] = 125,
        ["24080"] = 39122,
        ["24083"] = 26588,
        ["24085"] = 39470,
        ["24086"] = 39818,
        ["24087"] = 37037,
        ["24088"] = 39122,
        ["24089"] = 39818,
        ["2409"] = 350,
        ["24090"] = 20458,
        ["24091"] = 24092,
        ["24092"] = 39470,
        ["24093"] = 39470,
        ["24094"] = 80302,
        ["24095"] = 39470,
        ["24096"] = 44030,
        ["24097"] = 39470,
        ["24098"] = 39470,
        ["24101"] = 100000,
        ["24102"] = 100000,
        ["24104"] = 33,
        ["24105"] = 6,
        ["24106"] = 39122,
        ["24107"] = 117,
        ["2411"] = 0,
        ["24110"] = 39122,
        ["24112"] = 76,
        ["24114"] = 39470,
        ["24116"] = 39470,
        ["24117"] = 39818,
        ["24118"] = 1500,
        ["24119"] = 1500,
        ["24120"] = 1500,
        ["24121"] = 39818,
        ["24122"] = 30597,
        ["24123"] = 30712,
        ["24124"] = 12000,
        ["24125"] = 15000,
        ["24126"] = 15000,
        ["24127"] = 15000,
        ["24128"] = 15000,
        ["24131"] = 7,
        ["24133"] = 12,
        ["24136"] = 284,
        ["2414"] = 0,
        ["24142"] = 20,
        ["24143"] = 1,
        ["24145"] = 1,
        ["24146"] = 1,
        ["24150"] = 20984,
        ["24151"] = 75303,
        ["24154"] = 13782,
        ["24155"] = 80578,
        ["24158"] = 30000,
        ["24164"] = 30000,
        ["24165"] = 35000,
        ["24166"] = 30000,
        ["24167"] = 30000,
        ["24168"] = 30000,
        ["24169"] = 30000,
        ["2417"] = 3074,
        ["24170"] = 35000,
        ["24171"] = 35000,
        ["24172"] = 15000,
        ["24174"] = 30000,
        ["24175"] = 30000,
        ["24176"] = 30000,
        ["24177"] = 30000,
        ["24178"] = 30000,
        ["24179"] = 30000,
        ["2418"] = 3146,
        ["24180"] = 30000,
        ["24181"] = 30000,
        ["24182"] = 30000,
        ["24183"] = 30000,
        ["24186"] = 50,
        ["24189"] = 1500,
        ["2419"] = 1579,
        ["24192"] = 30000,
        ["24193"] = 30000,
        ["24194"] = 30000,
        ["24195"] = 30000,
        ["24196"] = 30000,
        ["24197"] = 30000,
        ["24198"] = 30000,
        ["24199"] = 30000,
        ["2420"] = 2387,
        ["24200"] = 30000,
        ["24201"] = 30000,
        ["24202"] = 30000,
        ["24204"] = 30000,
        ["24205"] = 30000,
        ["24206"] = 30000,
        ["24207"] = 30000,
        ["24209"] = 30000,
        ["2421"] = 1590,
        ["24210"] = 30000,
        ["24211"] = 30000,
        ["24212"] = 30000,
        ["24213"] = 30000,
        ["24214"] = 30000,
        ["24215"] = 30000,
        ["24216"] = 30000,
        ["24217"] = 30000,
        ["24219"] = 30000,
        ["2422"] = 1596,
        ["24220"] = 30000,
        ["24222"] = 44210,
        ["2423"] = 8554,
        ["24231"] = 52,
        ["24232"] = 225,
        ["24238"] = 0,
        ["2424"] = 4292,
        ["24240"] = 0,
        ["24241"] = 7,
        ["24242"] = 1500,
        ["24243"] = 2250,
        ["24245"] = 146,
        ["24246"] = 400,
        ["24247"] = 0,
        ["24249"] = 16563,
        ["2425"] = 8615,
        ["24250"] = 16626,
        ["24251"] = 16690,
        ["24252"] = 25128,
        ["24253"] = 25223,
        ["24254"] = 26001,
        ["24255"] = 21880,
        ["24256"] = 21960,
        ["24257"] = 22040,
        ["24258"] = 33181,
        ["24259"] = 33297,
        ["2426"] = 6513,
        ["24260"] = 33417,
        ["24261"] = 44716,
        ["24262"] = 44876,
        ["24263"] = 45032,
        ["24264"] = 33894,
        ["24266"] = 30889,
        ["24267"] = 31006,
        ["24268"] = 100,
        ["2427"] = 4029,
        ["24270"] = 30000,
        ["24271"] = 4000,
        ["24272"] = 4000,
        ["24273"] = 20000,
        ["24274"] = 50000,
        ["24275"] = 20000,
        ["24276"] = 50000,
        ["2428"] = 4044,
        ["24280"] = 0,
        ["24281"] = 302,
        ["24286"] = 125000,
        ["2429"] = 2027,
        ["24291"] = 500,
        ["24292"] = 15000,
        ["24293"] = 15000,
        ["24294"] = 90000,
        ["24295"] = 90000,
        ["24296"] = 20000,
        ["24300"] = 20000,
        ["24302"] = 30000,
        ["24303"] = 30000,
        ["24304"] = 30000,
        ["24305"] = 30000,
        ["24306"] = 30000,
        ["24307"] = 30000,
        ["2431"] = 2043,
        ["24314"] = 10000,
        ["24316"] = 10000,
        ["2432"] = 1538,
        ["24330"] = 0,
        ["24334"] = 798,
        ["24338"] = 200,
        ["24339"] = 299,
        ["2434"] = 1033,
        ["24340"] = 120,
        ["24341"] = 90,
        ["24343"] = 475,
        ["24347"] = 528,
        ["24349"] = 412,
        ["2435"] = 5536,
        ["24355"] = 0,
        ["24356"] = 74307,
        ["24357"] = 44738,
        ["24359"] = 27182,
        ["24360"] = 20465,
        ["24361"] = 68476,
        ["24362"] = 20621,
        ["24363"] = 48302,
        ["24364"] = 48487,
        ["24365"] = 17381,
        ["24366"] = 31544,
        ["24367"] = 0,
        ["24368"] = 500,
        ["2437"] = 5578,
        ["24372"] = 0,
        ["24374"] = 0,
        ["24375"] = 0,
        ["24376"] = 1807,
        ["24378"] = 74821,
        ["24379"] = 20384,
        ["2438"] = 4199,
        ["24380"] = 51153,
        ["24381"] = 51351,
        ["24382"] = 0,
        ["24384"] = 69061,
        ["24385"] = 19646,
        ["24386"] = 20872,
        ["24387"] = 24577,
        ["24388"] = 21023,
        ["24389"] = 52751,
        ["24390"] = 20737,
        ["24391"] = 35419,
        ["24392"] = 14219,
        ["24393"] = 14270,
        ["24394"] = 89510,
        ["24395"] = 14371,
        ["24396"] = 36056,
        ["24397"] = 28947,
        ["24398"] = 27234,
        ["2440"] = 2819,
        ["24401"] = 750,
        ["24402"] = 12,
        ["24403"] = 1000,
        ["24404"] = 500,
        ["24405"] = 500,
        ["24406"] = 750,
        ["24408"] = 1000,
        ["24412"] = 6,
        ["24413"] = 22693,
        ["24417"] = 2,
        ["24419"] = 0,
        ["24421"] = 0,
        ["24423"] = 11,
        ["24429"] = 2000,
        ["24430"] = 181,
        ["24435"] = 24,
        ["24445"] = 43,
        ["24448"] = 150,
        ["24449"] = 146,
        ["2445"] = 686,
        ["24450"] = 15352,
        ["24451"] = 23107,
        ["24452"] = 17487,
        ["24453"] = 70222,
        ["24454"] = 21148,
        ["24455"] = 35379,
        ["24456"] = 49720,
        ["24457"] = 37361,
        ["24458"] = 25193,
        ["24459"] = 21551,
        ["2446"] = 1236,
        ["24460"] = 32466,
        ["24461"] = 90474,
        ["24462"] = 10283,
        ["24463"] = 39226,
        ["24464"] = 75131,
        ["24465"] = 45241,
        ["24466"] = 37833,
        ["24467"] = 0,
        ["24469"] = 0,
        ["2447"] = 10,
        ["24470"] = 0,
        ["24473"] = 0,
        ["24475"] = 0,
        ["24476"] = 100,
        ["24477"] = 100,
        ["24478"] = 1000,
        ["24479"] = 1000,
        ["2448"] = 3231,
        ["24481"] = 29723,
        ["24484"] = 0,
        ["24487"] = 0,
        ["24488"] = 0,
        ["24489"] = 0,
        ["2449"] = 20,
        ["24490"] = 0,
        ["24493"] = 0,
        ["24496"] = 0,
        ["24497"] = 0,
        ["24498"] = 0,
        ["2450"] = 25,
        ["24501"] = 0,
        ["24502"] = 0,
        ["24503"] = 0,
        ["24504"] = 0,
        ["24507"] = 870,
        ["24508"] = 1185,
        ["2451"] = 8725,
        ["24510"] = 990,
        ["24511"] = 1325,
        ["24513"] = 0,
        ["24514"] = 0,
        ["24516"] = 870,
        ["24517"] = 990,
        ["2452"] = 15,
        ["24523"] = 0,
        ["2453"] = 25,
        ["2454"] = 20,
        ["24540"] = 1000,
        ["24542"] = 0,
        ["2455"] = 10,
        ["24558"] = 0,
        ["2456"] = 15,
        ["24560"] = 0,
        ["2457"] = 15,
        ["24575"] = 10617,
        ["24576"] = 3666,
        ["24577"] = 5520,
        ["24578"] = 3693,
        ["24579"] = 0,
        ["2458"] = 15,
        ["24580"] = 5579,
        ["24581"] = 0,
        ["24582"] = 16765,
        ["24583"] = 22431,
        ["24584"] = 11255,
        ["24585"] = 15332,
        ["24586"] = 20522,
        ["24587"] = 15449,
        ["24588"] = 10339,
        ["24589"] = 10715,
        ["2459"] = 25,
        ["24590"] = 16134,
        ["24591"] = 21592,
        ["24592"] = 11130,
        ["24593"] = 16757,
        ["24594"] = 22423,
        ["24595"] = 16878,
        ["24596"] = 11293,
        ["24597"] = 11690,
        ["24598"] = 17597,
        ["24599"] = 23547,
        ["24600"] = 11815,
        ["24601"] = 17787,
        ["24602"] = 23798,
        ["24603"] = 17912,
        ["24604"] = 11983,
        ["24605"] = 11214,
        ["24606"] = 16885,
        ["24607"] = 22600,
        ["24608"] = 11655,
        ["24609"] = 17546,
        ["24610"] = 23482,
        ["24611"] = 17677,
        ["24612"] = 11828,
        ["24613"] = 12221,
        ["24614"] = 18399,
        ["24615"] = 24622,
        ["24616"] = 12356,
        ["24617"] = 18599,
        ["24618"] = 24888,
        ["24619"] = 18733,
        ["24620"] = 12534,
        ["24621"] = 12938,
        ["24622"] = 19477,
        ["24623"] = 26061,
        ["24624"] = 12158,
        ["24625"] = 18306,
        ["24626"] = 24501,
        ["24627"] = 18445,
        ["24628"] = 12341,
        ["24629"] = 12733,
        ["2463"] = 2739,
        ["24630"] = 19171,
        ["24631"] = 25656,
        ["24632"] = 12874,
        ["24633"] = 19382,
        ["24634"] = 25938,
        ["24635"] = 19524,
        ["24636"] = 13062,
        ["24637"] = 13465,
        ["24638"] = 20271,
        ["24639"] = 27126,
        ["2464"] = 1374,
        ["24640"] = 12642,
        ["24641"] = 19036,
        ["24642"] = 25478,
        ["24643"] = 19180,
        ["24644"] = 12835,
        ["24645"] = 13224,
        ["24646"] = 19911,
        ["24647"] = 26646,
        ["24648"] = 13373,
        ["24649"] = 20134,
        ["2465"] = 2495,
        ["24650"] = 26946,
        ["24651"] = 20282,
        ["24652"] = 13571,
        ["24653"] = 13972,
        ["24654"] = 21035,
        ["24655"] = 28146,
        ["24656"] = 14491,
        ["24657"] = 21814,
        ["24658"] = 26412,
        ["24659"] = 19886,
        ["2466"] = 0,
        ["24660"] = 13308,
        ["24661"] = 13695,
        ["24662"] = 20619,
        ["24663"] = 27597,
        ["24664"] = 13851,
        ["24665"] = 20855,
        ["24666"] = 27910,
        ["24667"] = 21011,
        ["24668"] = 14060,
        ["24669"] = 14458,
        ["2467"] = 1886,
        ["24670"] = 21765,
        ["24671"] = 29128,
        ["24672"] = 15003,
        ["24673"] = 22583,
        ["24674"] = 30219,
        ["24675"] = 22745,
        ["24676"] = 15217,
        ["24677"] = 15634,
        ["24678"] = 21298,
        ["24679"] = 28507,
        ["2468"] = 1262,
        ["24680"] = 14309,
        ["24681"] = 21544,
        ["24682"] = 28835,
        ["24683"] = 21709,
        ["24684"] = 14528,
        ["24685"] = 14921,
        ["24686"] = 22467,
        ["24687"] = 30069,
        ["24688"] = 15495,
        ["24689"] = 23324,
        ["2469"] = 1267,
        ["24690"] = 31212,
        ["24691"] = 23494,
        ["24692"] = 15717,
        ["24693"] = 13872,
        ["24694"] = 20882,
        ["24695"] = 27942,
        ["24696"] = 14019,
        ["24697"] = 21103,
        ["24698"] = 25553,
        ["24699"] = 19239,
        ["2470"] = 6790,
        ["24700"] = 12874,
        ["24701"] = 13343,
        ["24702"] = 20091,
        ["24703"] = 26891,
        ["24704"] = 13862,
        ["24705"] = 20870,
        ["24706"] = 27929,
        ["24707"] = 21021,
        ["24708"] = 14065,
        ["24709"] = 14560,
        ["2471"] = 3408,
        ["24710"] = 21919,
        ["24711"] = 29328,
        ["24712"] = 14717,
        ["24713"] = 22154,
        ["24714"] = 29645,
        ["24715"] = 22311,
        ["24716"] = 14926,
        ["24717"] = 15435,
        ["24718"] = 21026,
        ["24719"] = 28141,
        ["2472"] = 6842,
        ["24720"] = 14515,
        ["24721"] = 21854,
        ["24722"] = 29244,
        ["24723"] = 22015,
        ["24724"] = 14731,
        ["24725"] = 15222,
        ["24726"] = 22915,
        ["24727"] = 30665,
        ["24728"] = 15389,
        ["24729"] = 23167,
        ["2473"] = 5150,
        ["24730"] = 30999,
        ["24731"] = 23333,
        ["24732"] = 15611,
        ["24733"] = 16117,
        ["24734"] = 24259,
        ["24735"] = 32461,
        ["24736"] = 15142,
        ["24737"] = 22797,
        ["24738"] = 30511,
        ["24739"] = 22970,
        ["2474"] = 3446,
        ["24740"] = 15371,
        ["24741"] = 15857,
        ["24742"] = 23875,
        ["24743"] = 31951,
        ["24744"] = 16035,
        ["24745"] = 24139,
        ["24746"] = 32304,
        ["24747"] = 24316,
        ["24748"] = 16270,
        ["24749"] = 16771,
        ["2475"] = 3459,
        ["24750"] = 25248,
        ["24751"] = 33785,
        ["24752"] = 15743,
        ["24753"] = 23703,
        ["24754"] = 31726,
        ["24755"] = 23886,
        ["24756"] = 15983,
        ["24757"] = 16468,
        ["24758"] = 24796,
        ["24759"] = 33186,
        ["24760"] = 16653,
        ["24761"] = 25074,
        ["24762"] = 33557,
        ["24763"] = 25261,
        ["24764"] = 16902,
        ["24765"] = 17401,
        ["24766"] = 26197,
        ["24767"] = 35058,
        ["24768"] = 17591,
        ["24769"] = 27171,
        ["24770"] = 36357,
        ["24771"] = 24761,
        ["24772"] = 16571,
        ["24773"] = 17053,
        ["24774"] = 25678,
        ["24775"] = 34365,
        ["24776"] = 17248,
        ["24777"] = 25971,
        ["24778"] = 34759,
        ["24779"] = 26165,
        ["24780"] = 17509,
        ["24781"] = 18005,
        ["24782"] = 3572,
        ["24783"] = 27207,
        ["24784"] = 36410,
        ["24785"] = 18754,
        ["24786"] = 28229,
        ["24787"] = 37774,
        ["24788"] = 28431,
        ["24789"] = 19021,
        ["2479"] = 21,
        ["24790"] = 19543,
        ["24791"] = 26622,
        ["24792"] = 35634,
        ["24793"] = 17886,
        ["24794"] = 26930,
        ["24795"] = 36044,
        ["24796"] = 27136,
        ["24797"] = 18160,
        ["24798"] = 18652,
        ["24799"] = 28084,
        ["2480"] = 14,
        ["24800"] = 37586,
        ["24801"] = 19366,
        ["24802"] = 29156,
        ["24803"] = 39015,
        ["24804"] = 29367,
        ["24805"] = 19646,
        ["24806"] = 16646,
        ["24807"] = 25170,
        ["24808"] = 33531,
        ["24809"] = 16823,
        ["24810"] = 25324,
        ["24811"] = 30664,
        ["24812"] = 23190,
        ["24813"] = 15449,
        ["24814"] = 16011,
        ["24815"] = 24217,
        ["24816"] = 32269,
        ["24817"] = 16634,
        ["24818"] = 25044,
        ["24819"] = 33515,
        ["24820"] = 25338,
        ["24821"] = 16878,
        ["24822"] = 17472,
        ["24823"] = 26420,
        ["24824"] = 35194,
        ["24825"] = 17660,
        ["24826"] = 26585,
        ["24827"] = 35574,
        ["24828"] = 26892,
        ["24829"] = 17912,
        ["24830"] = 18522,
        ["24831"] = 25344,
        ["24832"] = 33770,
        ["24833"] = 17418,
        ["24834"] = 26225,
        ["24835"] = 35093,
        ["24836"] = 26535,
        ["24837"] = 17677,
        ["24838"] = 18266,
        ["24839"] = 27620,
        ["24840"] = 36799,
        ["24841"] = 18466,
        ["24842"] = 27801,
        ["24843"] = 37198,
        ["24844"] = 28124,
        ["24845"] = 18733,
        ["24846"] = 19340,
        ["24847"] = 29241,
        ["24848"] = 38954,
        ["24849"] = 18170,
        ["24850"] = 27356,
        ["24851"] = 36613,
        ["24852"] = 27686,
        ["24853"] = 18445,
        ["24854"] = 19028,
        ["24855"] = 28777,
        ["24856"] = 38342,
        ["24857"] = 19242,
        ["24858"] = 28967,
        ["24859"] = 38764,
        ["24860"] = 29310,
        ["24861"] = 19524,
        ["24862"] = 20125,
        ["24863"] = 30432,
        ["24864"] = 40543,
        ["24865"] = 18890,
        ["24866"] = 28444,
        ["24867"] = 38072,
        ["24868"] = 28791,
        ["24869"] = 19180,
        ["24870"] = 19761,
        ["24871"] = 29887,
        ["24872"] = 39823,
        ["24873"] = 19984,
        ["24874"] = 30089,
        ["24875"] = 40269,
        ["24876"] = 30449,
        ["24877"] = 20282,
        ["24878"] = 20881,
        ["24879"] = 31577,
        ["2488"] = 107,
        ["24880"] = 42070,
        ["24881"] = 21660,
        ["24882"] = 32606,
        ["24883"] = 43628,
        ["24884"] = 29845,
        ["24885"] = 19886,
        ["24886"] = 20463,
        ["24887"] = 30951,
        ["24888"] = 41238,
        ["24889"] = 20698,
        ["2489"] = 68,
        ["24890"] = 31165,
        ["24891"] = 41711,
        ["24892"] = 31538,
        ["24893"] = 21011,
        ["24894"] = 21606,
        ["24895"] = 32675,
        ["24896"] = 43531,
        ["24897"] = 22424,
        ["24898"] = 33758,
        ["24899"] = 45167,
        ["2490"] = 108,
        ["24900"] = 34148,
        ["24901"] = 22745,
        ["24902"] = 23371,
        ["24903"] = 35334,
        ["24904"] = 42596,
        ["24905"] = 21380,
        ["24906"] = 32195,
        ["24907"] = 43088,
        ["24908"] = 32584,
        ["24909"] = 21709,
        ["2491"] = 96,
        ["24910"] = 22300,
        ["24911"] = 33723,
        ["24912"] = 44934,
        ["24913"] = 23157,
        ["24914"] = 34860,
        ["24915"] = 46649,
        ["24916"] = 35270,
        ["24917"] = 23494,
        ["24918"] = 19462,
        ["24919"] = 29075,
        ["2492"] = 57,
        ["24920"] = 38980,
        ["24921"] = 19671,
        ["24922"] = 29384,
        ["24923"] = 39393,
        ["24924"] = 26780,
        ["24925"] = 18059,
        ["24926"] = 18715,
        ["24927"] = 27967,
        ["24928"] = 37504,
        ["24929"] = 19445,
        ["2493"] = 140,
        ["24930"] = 29055,
        ["24931"] = 38957,
        ["24932"] = 29269,
        ["24933"] = 19732,
        ["24934"] = 20426,
        ["24935"] = 30518,
        ["24936"] = 40916,
        ["24937"] = 20647,
        ["24938"] = 30847,
        ["24939"] = 41355,
        ["2494"] = 80,
        ["24940"] = 31068,
        ["24941"] = 20942,
        ["24942"] = 21656,
        ["24943"] = 32353,
        ["24944"] = 39250,
        ["24945"] = 20360,
        ["24946"] = 30423,
        ["24947"] = 40794,
        ["24948"] = 30648,
        ["24949"] = 20664,
        ["2495"] = 101,
        ["24950"] = 21354,
        ["24951"] = 31906,
        ["24952"] = 42775,
        ["24953"] = 21588,
        ["24954"] = 32255,
        ["24955"] = 43246,
        ["24956"] = 32487,
        ["24957"] = 21902,
        ["24958"] = 22611,
        ["24959"] = 33781,
        ["24960"] = 45285,
        ["24961"] = 21238,
        ["24962"] = 31737,
        ["24963"] = 42554,
        ["24964"] = 31976,
        ["24965"] = 21561,
        ["24966"] = 22246,
        ["24967"] = 33237,
        ["24968"] = 44566,
        ["24969"] = 22494,
        ["24970"] = 33609,
        ["24971"] = 45059,
        ["24972"] = 33854,
        ["24973"] = 22825,
        ["24974"] = 23530,
        ["24975"] = 35152,
        ["24976"] = 47129,
        ["24977"] = 22081,
        ["24978"] = 32994,
        ["24979"] = 44247,
        ["24980"] = 33249,
        ["24981"] = 22421,
        ["24982"] = 23099,
        ["24983"] = 34517,
        ["24984"] = 46285,
        ["24985"] = 23363,
        ["24986"] = 34906,
        ["24987"] = 46805,
        ["24988"] = 35168,
        ["24989"] = 23712,
        ["24990"] = 24410,
        ["24991"] = 36472,
        ["24992"] = 48902,
        ["24993"] = 24678,
        ["24994"] = 37833,
        ["24995"] = 50720,
        ["24996"] = 38102,
        ["24997"] = 23242,
        ["24998"] = 23918,
        ["24999"] = 35743,
        ["25"] = 7,
        ["25000"] = 47933,
        ["25001"] = 24193,
        ["25002"] = 36152,
        ["25003"] = 48479,
        ["25004"] = 36428,
        ["25005"] = 24560,
        ["25006"] = 25256,
        ["25007"] = 37739,
        ["25008"] = 50603,
        ["25009"] = 25538,
        ["25010"] = 39168,
        ["25011"] = 52512,
        ["25012"] = 39446,
        ["25013"] = 26593,
        ["25014"] = 27325,
        ["25015"] = 40822,
        ["25016"] = 54721,
        ["25017"] = 24989,
        ["25018"] = 37345,
        ["25019"] = 50081,
        ["25020"] = 37630,
        ["25021"] = 25375,
        ["25022"] = 26066,
        ["25023"] = 38951,
        ["25024"] = 52226,
        ["25025"] = 26361,
        ["25026"] = 40449,
        ["25027"] = 54227,
        ["25028"] = 40740,
        ["25029"] = 27467,
        ["25030"] = 16529,
        ["25031"] = 17124,
        ["25032"] = 17725,
        ["25033"] = 18330,
        ["25034"] = 18939,
        ["25035"] = 19549,
        ["25036"] = 20166,
        ["25037"] = 18811,
        ["25038"] = 19383,
        ["25039"] = 19956,
        ["2504"] = 5,
        ["25040"] = 20536,
        ["25041"] = 21119,
        ["25042"] = 22296,
        ["25043"] = 22901,
        ["25044"] = 26809,
        ["25045"] = 27678,
        ["25046"] = 28546,
        ["25047"] = 29415,
        ["25048"] = 30284,
        ["25049"] = 31154,
        ["2505"] = 12,
        ["25050"] = 32023,
        ["25051"] = 32891,
        ["25052"] = 33760,
        ["25053"] = 34629,
        ["25054"] = 35498,
        ["25055"] = 36368,
        ["25056"] = 37236,
        ["25057"] = 38105,
        ["25058"] = 26809,
        ["25059"] = 27678,
        ["2506"] = 57,
        ["25060"] = 28546,
        ["25061"] = 29415,
        ["25062"] = 30284,
        ["25063"] = 31154,
        ["25064"] = 32023,
        ["25065"] = 32891,
        ["25066"] = 33760,
        ["25067"] = 34629,
        ["25068"] = 35498,
        ["25069"] = 36368,
        ["2507"] = 350,
        ["25070"] = 37236,
        ["25071"] = 38105,
        ["25072"] = 35505,
        ["25073"] = 36784,
        ["25074"] = 35384,
        ["25075"] = 36601,
        ["25076"] = 37822,
        ["25077"] = 39054,
        ["25078"] = 40295,
        ["25079"] = 41545,
        ["2508"] = 5,
        ["25080"] = 42798,
        ["25081"] = 44063,
        ["25082"] = 45337,
        ["25083"] = 46619,
        ["25084"] = 47905,
        ["25085"] = 49203,
        ["25086"] = 26809,
        ["25087"] = 27678,
        ["25088"] = 28546,
        ["25089"] = 29415,
        ["2509"] = 82,
        ["25090"] = 30284,
        ["25091"] = 31154,
        ["25092"] = 32023,
        ["25093"] = 32891,
        ["25094"] = 33760,
        ["25095"] = 34629,
        ["25096"] = 35498,
        ["25097"] = 36368,
        ["25098"] = 37236,
        ["25099"] = 38105,
        ["2510"] = 8,
        ["25100"] = 53097,
        ["25101"] = 55022,
        ["25102"] = 56961,
        ["25103"] = 58907,
        ["25104"] = 60871,
        ["25105"] = 62848,
        ["25106"] = 66529,
        ["25107"] = 68578,
        ["25108"] = 70639,
        ["25109"] = 72714,
        ["2511"] = 264,
        ["25110"] = 67687,
        ["25111"] = 69613,
        ["25112"] = 71552,
        ["25113"] = 73504,
        ["25114"] = 51906,
        ["25115"] = 53793,
        ["25116"] = 55694,
        ["25117"] = 57607,
        ["25118"] = 59526,
        ["25119"] = 61465,
        ["2512"] = 0,
        ["25120"] = 63416,
        ["25121"] = 65381,
        ["25122"] = 69140,
        ["25123"] = 71176,
        ["25124"] = 73225,
        ["25125"] = 75279,
        ["25126"] = 77354,
        ["25127"] = 79441,
        ["25128"] = 70111,
        ["25130"] = 68033,
        ["25131"] = 70376,
        ["25132"] = 72735,
        ["25133"] = 75102,
        ["25134"] = 77493,
        ["25135"] = 79901,
        ["25136"] = 82324,
        ["25137"] = 84754,
        ["25138"] = 89561,
        ["25139"] = 92090,
        ["25140"] = 94626,
        ["25141"] = 97186,
        ["25142"] = 54898,
        ["25143"] = 56882,
        ["25144"] = 58874,
        ["25146"] = 62906,
        ["25147"] = 64942,
        ["25148"] = 66984,
        ["25149"] = 69045,
        ["2515"] = 0,
        ["25150"] = 64360,
        ["25151"] = 66273,
        ["25152"] = 68191,
        ["25153"] = 70130,
        ["25154"] = 74055,
        ["25155"] = 76057,
        ["25156"] = 67135,
        ["25157"] = 69567,
        ["25158"] = 72015,
        ["2516"] = 0,
        ["25160"] = 76952,
        ["25161"] = 79448,
        ["25162"] = 81961,
        ["25163"] = 84481,
        ["25164"] = 87025,
        ["25165"] = 89585,
        ["25166"] = 92161,
        ["25167"] = 94745,
        ["25168"] = 97353,
        ["25169"] = 99977,
        ["25170"] = 65647,
        ["25171"] = 68031,
        ["25172"] = 70431,
        ["25174"] = 75271,
        ["25175"] = 77719,
        ["25176"] = 80183,
        ["25177"] = 82663,
        ["25178"] = 85151,
        ["25179"] = 87663,
        ["25180"] = 90191,
        ["25181"] = 92736,
        ["25182"] = 95287,
        ["25183"] = 97863,
        ["25184"] = 55279,
        ["25185"] = 57275,
        ["25186"] = 55077,
        ["25187"] = 56971,
        ["25188"] = 58878,
        ["25189"] = 60792,
        ["2519"] = 0,
        ["25190"] = 62725,
        ["25191"] = 64670,
        ["25192"] = 66629,
        ["25193"] = 68593,
        ["25195"] = 72574,
        ["25196"] = 74583,
        ["25197"] = 76598,
        ["25198"] = 54088,
        ["25199"] = 56046,
        ["2520"] = 4925,
        ["25200"] = 58017,
        ["25201"] = 59995,
        ["25202"] = 61992,
        ["25203"] = 59415,
        ["25204"] = 61303,
        ["25205"] = 63210,
        ["25206"] = 65130,
        ["25207"] = 67062,
        ["25208"] = 69001,
        ["2521"] = 6179,
        ["25210"] = 72930,
        ["25211"] = 74914,
        ["25212"] = 66123,
        ["25213"] = 68522,
        ["25214"] = 70937,
        ["25215"] = 73369,
        ["25216"] = 75809,
        ["25217"] = 78272,
        ["25218"] = 80752,
        ["25219"] = 85418,
        ["2522"] = 4509,
        ["25220"] = 87987,
        ["25221"] = 90572,
        ["25222"] = 93173,
        ["25223"] = 86680,
        ["25224"] = 89096,
        ["25225"] = 91528,
        ["25226"] = 64642,
        ["25227"] = 66986,
        ["25228"] = 69353,
        ["25229"] = 71736,
        ["2523"] = 5657,
        ["25230"] = 74136,
        ["25231"] = 76543,
        ["25232"] = 78974,
        ["25233"] = 81422,
        ["25234"] = 83877,
        ["25235"] = 88650,
        ["25236"] = 91203,
        ["25237"] = 93772,
        ["25238"] = 96348,
        ["25239"] = 98949,
        ["2524"] = 3838,
        ["25240"] = 41917,
        ["25241"] = 43430,
        ["25242"] = 44947,
        ["25243"] = 42062,
        ["25244"] = 43473,
        ["25245"] = 44893,
        ["25246"] = 46318,
        ["25247"] = 47758,
        ["25248"] = 49207,
        ["25249"] = 50665,
        ["2525"] = 5298,
        ["25250"] = 52128,
        ["25251"] = 55052,
        ["25252"] = 56574,
        ["25253"] = 58100,
        ["25254"] = 41025,
        ["25255"] = 42508,
        ["25256"] = 44001,
        ["25257"] = 45499,
        ["25258"] = 47011,
        ["25259"] = 48533,
        ["2526"] = 3867,
        ["25260"] = 50065,
        ["25261"] = 51601,
        ["25262"] = 53152,
        ["25263"] = 49512,
        ["25264"] = 50952,
        ["25265"] = 52395,
        ["25266"] = 53854,
        ["25267"] = 56837,
        ["25268"] = 40132,
        ["25269"] = 41586,
        ["2527"] = 5871,
        ["25270"] = 43050,
        ["25271"] = 44524,
        ["25272"] = 46003,
        ["25273"] = 47496,
        ["25274"] = 48998,
        ["25275"] = 50511,
        ["25276"] = 52027,
        ["25277"] = 53559,
        ["25278"] = 55100,
        ["25279"] = 56650,
        ["2528"] = 10367,
        ["25280"] = 58205,
        ["25281"] = 59775,
        ["25282"] = 42203,
        ["25283"] = 40665,
        ["25284"] = 42100,
        ["25286"] = 44999,
        ["25287"] = 46458,
        ["25288"] = 47932,
        ["25289"] = 49415,
        ["2529"] = 13006,
        ["25290"] = 50908,
        ["25291"] = 52406,
        ["25292"] = 53918,
        ["25293"] = 55439,
        ["25294"] = 56971,
        ["25295"] = 58506,
        ["25296"] = 55080,
        ["25297"] = 57071,
        ["25298"] = 59068,
        ["25299"] = 56754,
        ["2530"] = 10444,
        ["25300"] = 58654,
        ["25301"] = 60568,
        ["25302"] = 62488,
        ["25303"] = 64427,
        ["25304"] = 66379,
        ["25305"] = 68344,
        ["25306"] = 70314,
        ["25307"] = 72305,
        ["25308"] = 74308,
        ["25309"] = 76324,
        ["2531"] = 11234,
        ["25310"] = 53890,
        ["25311"] = 55842,
        ["25312"] = 57806,
        ["25313"] = 59783,
        ["25314"] = 61768,
        ["25315"] = 65421,
        ["25316"] = 61072,
        ["25317"] = 62967,
        ["25318"] = 64880,
        ["25319"] = 66806,
        ["2532"] = 10521,
        ["25320"] = 68745,
        ["25321"] = 70690,
        ["25322"] = 72654,
        ["25323"] = 74632,
        ["25324"] = 65881,
        ["25325"] = 68266,
        ["25326"] = 70673,
        ["25327"] = 73097,
        ["25328"] = 75536,
        ["25329"] = 77984,
        ["2533"] = 12221,
        ["25330"] = 80456,
        ["25331"] = 85122,
        ["25332"] = 87675,
        ["25333"] = 90252,
        ["25334"] = 92845,
        ["25335"] = 95454,
        ["25336"] = 88752,
        ["25337"] = 91175,
        ["25338"] = 6906,
        ["25339"] = 5199,
        ["2534"] = 9086,
        ["25340"] = 6959,
        ["25341"] = 3763,
        ["25342"] = 5666,
        ["25343"] = 3791,
        ["25344"] = 3805,
        ["25345"] = 5729,
        ["25346"] = 7668,
        ["25347"] = 5926,
        ["25348"] = 7930,
        ["25349"] = 9234,
        ["2535"] = 12311,
        ["25350"] = 4633,
        ["25351"] = 6974,
        ["25352"] = 4666,
        ["25353"] = 4683,
        ["25354"] = 7049,
        ["25355"] = 9432,
        ["25356"] = 6424,
        ["25357"] = 9264,
        ["25358"] = 4650,
        ["25359"] = 7001,
        ["2536"] = 0,
        ["25360"] = 4685,
        ["25361"] = 4703,
        ["25362"] = 7081,
        ["25363"] = 9733,
        ["25364"] = 7327,
        ["25365"] = 10921,
        ["25366"] = 5480,
        ["25367"] = 8286,
        ["25368"] = 5520,
        ["25369"] = 8310,
        ["25370"] = 5559,
        ["25371"] = 11158,
        ["25372"] = 8436,
        ["25373"] = 12108,
        ["25374"] = 6075,
        ["25375"] = 9185,
        ["25376"] = 5536,
        ["25377"] = 8337,
        ["25378"] = 5578,
        ["25379"] = 11508,
        ["25380"] = 8702,
        ["25381"] = 6313,
        ["25382"] = 9432,
        ["25383"] = 6359,
        ["25384"] = 12694,
        ["25385"] = 6406,
        ["25386"] = 9571,
        ["25387"] = 12832,
        ["25388"] = 9640,
        ["25389"] = 7001,
        ["25390"] = 10460,
        ["25391"] = 7052,
        ["25392"] = 14074,
        ["25393"] = 7102,
        ["25394"] = 10609,
        ["25395"] = 13226,
        ["25396"] = 9937,
        ["25397"] = 18352,
        ["25398"] = 23027,
        ["25399"] = 18490,
        ["25400"] = 23197,
        ["25401"] = 18626,
        ["25402"] = 23370,
        ["25403"] = 18765,
        ["25404"] = 23540,
        ["25405"] = 14176,
        ["25406"] = 14227,
        ["25408"] = 870,
        ["25409"] = 1185,
        ["25410"] = 990,
        ["25411"] = 1325,
        ["25412"] = 870,
        ["25413"] = 1185,
        ["25414"] = 990,
        ["25415"] = 1325,
        ["25416"] = 200,
        ["25417"] = 870,
        ["25418"] = 1185,
        ["25419"] = 12,
        ["25420"] = 990,
        ["25421"] = 1325,
        ["25424"] = 12,
        ["25425"] = 870,
        ["25426"] = 1185,
        ["25427"] = 990,
        ["25428"] = 1325,
        ["25429"] = 870,
        ["25430"] = 1185,
        ["25431"] = 990,
        ["25433"] = 200,
        ["25434"] = 870,
        ["25435"] = 1185,
        ["25436"] = 990,
        ["25437"] = 1325,
        ["25438"] = 750,
        ["25439"] = 250,
        ["25440"] = 870,
        ["25441"] = 1185,
        ["25442"] = 990,
        ["25443"] = 1325,
        ["25444"] = 870,
        ["25445"] = 1185,
        ["25446"] = 990,
        ["25448"] = 0,
        ["2545"] = 1796,
        ["25450"] = 870,
        ["25451"] = 1185,
        ["25452"] = 990,
        ["25453"] = 1325,
        ["25454"] = 990,
        ["25456"] = 870,
        ["25458"] = 0,
        ["25459"] = 0,
        ["2546"] = 55,
        ["25463"] = 500,
        ["25464"] = 3301,
        ["25465"] = 0,
        ["25466"] = 4,
        ["25467"] = 4,
        ["25469"] = 6500,
        ["2547"] = 7,
        ["25475"] = 0,
        ["25477"] = 0,
        ["25478"] = 21595,
        ["25479"] = 27828,
        ["2548"] = 0,
        ["25480"] = 12358,
        ["25481"] = 21829,
        ["25482"] = 28132,
        ["25483"] = 12491,
        ["25484"] = 12536,
        ["25485"] = 22143,
        ["25486"] = 15782,
        ["25487"] = 30284,
        ["25488"] = 30284,
        ["25489"] = 17320,
        ["2549"] = 5016,
        ["25491"] = 0,
        ["25492"] = 60005,
        ["25494"] = 75559,
        ["25495"] = 60671,
        ["25496"] = 45671,
        ["25498"] = 25,
        ["25499"] = 30284,
        ["25500"] = 30284,
        ["25501"] = 18603,
        ["25502"] = 21275,
        ["25503"] = 12132,
        ["25504"] = 15219,
        ["25505"] = 29415,
        ["25506"] = 28403,
        ["25507"] = 31671,
        ["25508"] = 29554,
        ["25510"] = 23820,
        ["25511"] = 41842,
        ["25512"] = 35999,
        ["25513"] = 22581,
        ["25514"] = 25751,
        ["25515"] = 21444,
        ["25516"] = 17218,
        ["25517"] = 30284,
        ["25518"] = 30665,
        ["25519"] = 61556,
        ["25521"] = 3000,
        ["25522"] = 32604,
        ["25523"] = 18733,
        ["25524"] = 21827,
        ["25525"] = 18032,
        ["25526"] = 15000,
        ["2553"] = 25,
        ["25530"] = 32096,
        ["25534"] = 18650,
        ["25539"] = 0,
        ["25540"] = 23032,
        ["25541"] = 36689,
        ["25542"] = 36689,
        ["25543"] = 64630,
        ["25544"] = 48660,
        ["25545"] = 65130,
        ["2555"] = 40,
        ["25556"] = 40712,
        ["25557"] = 35683,
        ["25558"] = 20500,
        ["25559"] = 27343,
        ["25560"] = 24806,
        ["25561"] = 28859,
        ["25562"] = 38775,
        ["25563"] = 38775,
        ["25564"] = 38775,
        ["25565"] = 24421,
        ["25566"] = 23009,
        ["25567"] = 19684,
        ["25568"] = 39519,
        ["25569"] = 46281,
        ["25570"] = 24884,
        ["25574"] = 27656,
        ["25575"] = 31225,
        ["25576"] = 17410,
        ["25577"] = 27953,
        ["25578"] = 17533,
        ["25579"] = 31672,
        ["25583"] = 16154,
        ["25584"] = 19460,
        ["25585"] = 45576,
        ["25589"] = 35575,
        ["25590"] = 0,
        ["25591"] = 17097,
        ["25592"] = 20590,
        ["25593"] = 36095,
        ["25594"] = 31248,
        ["25595"] = 27753,
        ["25597"] = 21431,
        ["25598"] = 18330,
        ["25599"] = 15329,
        ["2560"] = 0,
        ["25600"] = 15382,
        ["25601"] = 18524,
        ["25602"] = 19739,
        ["25603"] = 90253,
        ["25605"] = 18690,
        ["25606"] = 32891,
        ["25607"] = 32891,
        ["25608"] = 94489,
        ["25609"] = 18967,
        ["2561"] = 0,
        ["25610"] = 28044,
        ["25611"] = 10742,
        ["25612"] = 33757,
        ["25613"] = 12711,
        ["25614"] = 40408,
        ["25615"] = 33543,
        ["25616"] = 24091,
        ["25617"] = 24178,
        ["25618"] = 19411,
        ["25619"] = 7000,
        ["2562"] = 575,
        ["25620"] = 7000,
        ["25621"] = 18241,
        ["25622"] = 80542,
        ["25623"] = 22766,
        ["25624"] = 41549,
        ["25628"] = 7000,
        ["25629"] = 49598,
        ["2563"] = 0,
        ["25630"] = 19910,
        ["25631"] = 19983,
        ["25632"] = 50141,
        ["25633"] = 7000,
        ["25634"] = 7000,
        ["25636"] = 19393,
        ["25637"] = 12977,
        ["25638"] = 0,
        ["25639"] = 57838,
        ["2564"] = 6817,
        ["25640"] = 58059,
        ["25642"] = 0,
        ["25643"] = 23486,
        ["25644"] = 23574,
        ["25645"] = 23660,
        ["25647"] = 0,
        ["25649"] = 250,
        ["2565"] = 3113,
        ["25650"] = 7500,
        ["25651"] = 22500,
        ["25652"] = 22500,
        ["25653"] = 17500,
        ["25654"] = 17436,
        ["25655"] = 26106,
        ["25656"] = 36782,
        ["25657"] = 39930,
        ["25659"] = 30312,
        ["2566"] = 1322,
        ["25660"] = 38360,
        ["25661"] = 17727,
        ["25662"] = 32525,
        ["25668"] = 24047,
        ["25669"] = 14274,
        ["2567"] = 2509,
        ["25670"] = 32249,
        ["25671"] = 35070,
        ["25673"] = 21717,
        ["25674"] = 15897,
        ["25675"] = 30530,
        ["25676"] = 32311,
        ["2568"] = 31,
        ["25680"] = 31300,
        ["25681"] = 37703,
        ["25682"] = 31539,
        ["25685"] = 20771,
        ["25686"] = 32862,
        ["25687"] = 43976,
        ["25689"] = 45010,
        ["2569"] = 87,
        ["25690"] = 44808,
        ["25691"] = 33726,
        ["25692"] = 51110,
        ["25693"] = 36667,
        ["25694"] = 25734,
        ["25695"] = 24563,
        ["25696"] = 50116,
        ["25697"] = 25155,
        ["25699"] = 1250,
        ["2570"] = 11,
        ["25700"] = 1250,
        ["25701"] = 48531,
        ["25702"] = 41752,
        ["25703"] = 100,
        ["25707"] = 6250,
        ["25708"] = 750,
        ["2571"] = 17,
        ["25710"] = 26858,
        ["25711"] = 28751,
        ["25712"] = 21640,
        ["25713"] = 34604,
        ["25714"] = 28836,
        ["25715"] = 33525,
        ["25716"] = 19266,
        ["25717"] = 24843,
        ["25718"] = 19949,
        ["25719"] = 0,
        ["2572"] = 99,
        ["25720"] = 12500,
        ["25721"] = 12500,
        ["25722"] = 12500,
        ["25725"] = 12500,
        ["25728"] = 15000,
        ["25730"] = 15000,
        ["25732"] = 30000,
        ["25733"] = 35000,
        ["25734"] = 35000,
        ["25735"] = 40000,
        ["25736"] = 35000,
        ["25737"] = 35000,
        ["25738"] = 30000,
        ["25739"] = 40000,
        ["25740"] = 40000,
        ["25741"] = 30000,
        ["25742"] = 30000,
        ["25743"] = 30000,
        ["25744"] = 676,
        ["25745"] = 0,
        ["25746"] = 0,
        ["2575"] = 25,
        ["25751"] = 0,
        ["25759"] = 79164,
        ["2576"] = 75,
        ["25760"] = 99323,
        ["25761"] = 99692,
        ["25762"] = 100050,
        ["25763"] = 80334,
        ["25764"] = 80629,
        ["25766"] = 0,
        ["25767"] = 0,
        ["25768"] = 0,
        ["25769"] = 0,
        ["2577"] = 75,
        ["25772"] = 75090,
        ["25773"] = 75369,
        ["25774"] = 75656,
        ["25775"] = 38775,
        ["25776"] = 38775,
        ["25777"] = 22952,
        ["25778"] = 13373,
        ["25779"] = 16778,
        ["2578"] = 224,
        ["25780"] = 20207,
        ["25781"] = 43576,
        ["25782"] = 37485,
        ["25783"] = 18810,
        ["25784"] = 28546,
        ["25785"] = 28546,
        ["25786"] = 7464,
        ["25787"] = 8910,
        ["25788"] = 29291,
        ["25789"] = 25060,
        ["2579"] = 37,
        ["25790"] = 31447,
        ["25791"] = 21045,
        ["25792"] = 25349,
        ["2580"] = 67,
        ["25802"] = 1500,
        ["25803"] = 41903,
        ["25804"] = 41903,
        ["25805"] = 26207,
        ["25806"] = 65751,
        ["25808"] = 59918,
        ["25809"] = 41903,
        ["2581"] = 20,
        ["25810"] = 24153,
        ["25811"] = 41903,
        ["25812"] = 0,
        ["25813"] = 1020,
        ["25819"] = 56869,
        ["2582"] = 216,
        ["25820"] = 36691,
        ["25821"] = 40916,
        ["25822"] = 32847,
        ["25823"] = 69463,
        ["25824"] = 28695,
        ["25825"] = 69960,
        ["25826"] = 28695,
        ["2583"] = 359,
        ["25835"] = 89596,
        ["25836"] = 71940,
        ["25837"] = 0,
        ["25838"] = 36230,
        ["2584"] = 142,
        ["25842"] = 0,
        ["25843"] = 8000,
        ["25844"] = 32000,
        ["25845"] = 40000,
        ["25846"] = 10000,
        ["25847"] = 30000,
        ["25848"] = 25000,
        ["25849"] = 30000,
        ["2585"] = 638,
        ["25852"] = 0,
        ["25853"] = 0,
        ["25861"] = 3,
        ["25866"] = 0,
        ["25867"] = 30000,
        ["25868"] = 30000,
        ["25869"] = 20000,
        ["2587"] = 200,
        ["25870"] = 20000,
        ["25872"] = 7,
        ["25873"] = 18,
        ["25874"] = 19640,
        ["25875"] = 50,
        ["25876"] = 200,
        ["25878"] = 13253,
        ["25881"] = 600,
        ["25882"] = 1000,
        ["25889"] = 0,
        ["2589"] = 13,
        ["25890"] = 30000,
        ["25893"] = 30000,
        ["25894"] = 30000,
        ["25895"] = 30000,
        ["25896"] = 30000,
        ["25897"] = 30000,
        ["25898"] = 30000,
        ["25899"] = 30000,
        ["2590"] = 5,
        ["25900"] = 5500,
        ["25901"] = 30000,
        ["25902"] = 30000,
        ["25903"] = 30000,
        ["25904"] = 30000,
        ["25905"] = 30000,
        ["25906"] = 30000,
        ["25907"] = 30000,
        ["25908"] = 30000,
        ["2591"] = 5,
        ["25910"] = 30000,
        ["25911"] = 0,
        ["25912"] = 0,
        ["25913"] = 30284,
        ["25914"] = 30284,
        ["25915"] = 62470,
        ["25916"] = 64487,
        ["25917"] = 80897,
        ["25918"] = 64948,
        ["25919"] = 30284,
        ["2592"] = 33,
        ["25920"] = 63579,
        ["25921"] = 30284,
        ["25922"] = 21574,
        ["25923"] = 27810,
        ["25924"] = 23159,
        ["25925"] = 18598,
        ["25926"] = 32023,
        ["25927"] = 19247,
        ["25928"] = 32023,
        ["25929"] = 42788,
        ["2593"] = 37,
        ["25930"] = 27607,
        ["25931"] = 18470,
        ["25932"] = 30896,
        ["25933"] = 65575,
        ["25934"] = 82265,
        ["25935"] = 82553,
        ["25936"] = 66290,
        ["25937"] = 66290,
        ["25938"] = 0,
        ["25939"] = 59195,
        ["2594"] = 375,
        ["25940"] = 23761,
        ["25941"] = 32513,
        ["25942"] = 26119,
        ["25943"] = 74482,
        ["25944"] = 93451,
        ["25945"] = 22512,
        ["25946"] = 28242,
        ["25947"] = 34167,
        ["25948"] = 22665,
        ["25949"] = 16156,
        ["2595"] = 500,
        ["25950"] = 95526,
        ["25951"] = 29422,
        ["25952"] = 76979,
        ["25953"] = 57944,
        ["25954"] = 8377,
        ["25955"] = 35014,
        ["25956"] = 27487,
        ["25957"] = 23508,
        ["25958"] = 21241,
        ["25959"] = 18172,
        ["2596"] = 30,
        ["25960"] = 15201,
        ["25961"] = 12205,
        ["25962"] = 83797,
        ["25963"] = 31154,
        ["25964"] = 76819,
        ["25965"] = 18583,
        ["25966"] = 18652,
        ["25968"] = 32394,
        ["25969"] = 17981,
        ["25970"] = 21657,
        ["25971"] = 40426,
        ["25972"] = 40569,
        ["25973"] = 40717,
        ["25974"] = 17826,
        ["25975"] = 22369,
        ["25976"] = 26944,
        ["25977"] = 31496,
        ["25978"] = 50177,
        ["25979"] = 38850,
        ["2598"] = 30,
        ["25980"] = 33423,
        ["25981"] = 20968,
        ["25982"] = 11225,
        ["25983"] = 16901,
        ["25984"] = 21204,
        ["25985"] = 75264,
        ["25986"] = 75544,
        ["25987"] = 75824,
        ["25989"] = 28546,
        ["25990"] = 28546,
        ["25992"] = 28546,
        ["25993"] = 28546,
        ["26002"] = 0,
        ["2601"] = 100,
        ["26016"] = 169,
        ["26021"] = 458,
        ["26026"] = 364,
        ["2604"] = 12,
        ["26042"] = 0,
        ["26043"] = 0,
        ["26044"] = 0,
        ["26045"] = 0,
        ["26048"] = 0,
        ["2605"] = 25,
        ["26050"] = 844,
        ["26055"] = 92386,
        ["2606"] = 0,
        ["2607"] = 0,
        ["2608"] = 63,
        ["2609"] = 0,
        ["2610"] = 0,
        ["2611"] = 0,
        ["2612"] = 32,
        ["2613"] = 121,
        ["2614"] = 232,
        ["2615"] = 1018,
        ["2616"] = 532,
        ["2617"] = 1470,
        ["2618"] = 5328,
        ["2619"] = 0,
        ["2620"] = 3013,
        ["2621"] = 2357,
        ["2622"] = 2603,
        ["2623"] = 3554,
        ["2624"] = 3852,
        ["2625"] = 0,
        ["2628"] = 0,
        ["2629"] = 0,
        ["2632"] = 605,
        ["2633"] = 25,
        ["2634"] = 0,
        ["2635"] = 16,
        ["2636"] = 0,
        ["2637"] = 0,
        ["2639"] = 0,
        ["2640"] = 0,
        ["2642"] = 33,
        ["2643"] = 28,
        ["2644"] = 7,
        ["2645"] = 11,
        ["2646"] = 32,
        ["2648"] = 58,
        ["2649"] = 1,
        ["2650"] = 3,
        ["2651"] = 3,
        ["2652"] = 4,
        ["2653"] = 3,
        ["2654"] = 2,
        ["2656"] = 9,
        ["2657"] = 875,
        ["2658"] = 0,
        ["2659"] = 0,
        ["2660"] = 0,
        ["2661"] = 0,
        ["2662"] = 8750,
        ["2663"] = 8750,
        ["2665"] = 5,
        ["2666"] = 0,
        ["2667"] = 0,
        ["2671"] = 0,
        ["2672"] = 4,
        ["2673"] = 10,
        ["2674"] = 12,
        ["2675"] = 11,
        ["2676"] = 0,
        ["2677"] = 15,
        ["2678"] = 0,
        ["2679"] = 5,
        ["2680"] = 10,
        ["2681"] = 6,
        ["2682"] = 25,
        ["2683"] = 25,
        ["2684"] = 20,
        ["2685"] = 75,
        ["2686"] = 12,
        ["2687"] = 25,
        ["2690"] = 7,
        ["2691"] = 10,
        ["2692"] = 10,
        ["2694"] = 539,
        ["2696"] = 0,
        ["2697"] = 100,
        ["2698"] = 100,
        ["2699"] = 200,
        ["2700"] = 100,
        ["2701"] = 400,
        ["2702"] = 0,
        ["2712"] = 0,
        ["2713"] = 0,
        ["2719"] = 0,
        ["2720"] = 0,
        ["2721"] = 1982,
        ["2722"] = 0,
        ["2723"] = 12,
        ["2724"] = 0,
        ["2725"] = 375,
        ["2728"] = 375,
        ["2730"] = 375,
        ["2732"] = 375,
        ["2734"] = 375,
        ["2735"] = 375,
        ["2738"] = 375,
        ["27399"] = 254,
        ["2740"] = 375,
        ["27408"] = 39509,
        ["27409"] = 28382,
        ["27410"] = 22792,
        ["27411"] = 22876,
        ["27412"] = 95675,
        ["27413"] = 18750,
        ["27414"] = 34701,
        ["27415"] = 29022,
        ["27416"] = 10307,
        ["27417"] = 30024,
        ["27418"] = 32140,
        ["2742"] = 375,
        ["27420"] = 42412,
        ["27422"] = 8,
        ["27423"] = 22786,
        ["27424"] = 76249,
        ["27425"] = 8,
        ["27426"] = 76831,
        ["27427"] = 53987,
        ["27428"] = 23226,
        ["27429"] = 8,
        ["27430"] = 46800,
        ["27431"] = 78296,
        ["27432"] = 36645,
        ["27433"] = 23663,
        ["27434"] = 29689,
        ["27435"] = 8,
        ["27436"] = 4308,
        ["27437"] = 8,
        ["27438"] = 8,
        ["27439"] = 8,
        ["2744"] = 375,
        ["27440"] = 12377,
        ["27442"] = 60000,
        ["27447"] = 29989,
        ["27448"] = 25656,
        ["27449"] = 54936,
        ["2745"] = 375,
        ["27450"] = 38946,
        ["27451"] = 25946,
        ["27452"] = 17361,
        ["27453"] = 7102,
        ["27454"] = 40584,
        ["27455"] = 47219,
        ["27456"] = 45215,
        ["27457"] = 31946,
        ["27458"] = 54649,
        ["27459"] = 32175,
        ["27460"] = 55035,
        ["27461"] = 46024,
        ["27462"] = 18474,
        ["27463"] = 83894,
        ["27464"] = 22464,
        ["27465"] = 16907,
        ["27466"] = 25458,
        ["27467"] = 31941,
        ["27468"] = 21376,
        ["27474"] = 26933,
        ["27475"] = 31713,
        ["27476"] = 90421,
        ["27477"] = 34450,
        ["27478"] = 27321,
        ["27479"] = 0,
        ["2748"] = 375,
        ["27480"] = 0,
        ["27483"] = 20969,
        ["27484"] = 25260,
        ["27485"] = 26057,
        ["27487"] = 59798,
        ["27488"] = 26347,
        ["27489"] = 31029,
        ["2749"] = 375,
        ["27490"] = 88468,
        ["27491"] = 30866,
        ["27492"] = 44559,
        ["27493"] = 17889,
        ["27495"] = 41953,
        ["27497"] = 31936,
        ["27498"] = 125,
        ["27499"] = 112,
        ["2750"] = 375,
        ["27500"] = 100,
        ["27501"] = 100,
        ["27502"] = 112,
        ["27503"] = 125,
        ["27505"] = 45504,
        ["27506"] = 34866,
        ["27508"] = 17563,
        ["27509"] = 22033,
        ["2751"] = 375,
        ["27510"] = 26538,
        ["27511"] = 25,
        ["27512"] = 89111,
        ["27513"] = 20,
        ["27514"] = 44876,
        ["27515"] = 500,
        ["27516"] = 500,
        ["27517"] = 16449,
        ["27518"] = 24770,
        ["27519"] = 24865,
        ["27520"] = 43593,
        ["27521"] = 25661,
        ["27522"] = 25759,
        ["27523"] = 14846,
        ["27524"] = 105570,
        ["27525"] = 25432,
        ["27526"] = 63818,
        ["27527"] = 61238,
        ["27528"] = 26340,
        ["27529"] = 66290,
        ["27531"] = 22191,
        ["27532"] = 12500,
        ["27533"] = 91750,
        ["27534"] = 22045,
        ["27535"] = 29422,
        ["27536"] = 16782,
        ["27537"] = 16847,
        ["27538"] = 84562,
        ["27539"] = 44476,
        ["2754"] = 13,
        ["27540"] = 63903,
        ["27541"] = 25659,
        ["27542"] = 17171,
        ["27543"] = 86172,
        ["27544"] = 25949,
        ["27545"] = 43411,
        ["27546"] = 8788,
        ["27547"] = 17493,
        ["27548"] = 30902,
        ["27549"] = 40882,
        ["27550"] = 27229,
        ["27551"] = 10283,
        ["27552"] = 12,
        ["27553"] = 30,
        ["2756"] = 0,
        ["2757"] = 0,
        ["2758"] = 0,
        ["2759"] = 0,
        ["2760"] = 0,
        ["2763"] = 240,
        ["27631"] = 36689,
        ["27632"] = 0,
        ["27633"] = 0,
        ["27634"] = 0,
        ["27635"] = 6,
        ["2764"] = 440,
        ["2765"] = 811,
        ["27651"] = 150,
        ["27655"] = 150,
        ["27656"] = 150,
        ["27657"] = 150,
        ["27658"] = 150,
        ["27659"] = 150,
        ["2766"] = 1564,
        ["27660"] = 150,
        ["27661"] = 150,
        ["27662"] = 150,
        ["27663"] = 150,
        ["27664"] = 150,
        ["27665"] = 150,
        ["27666"] = 150,
        ["27667"] = 150,
        ["27668"] = 5,
        ["27671"] = 200,
        ["27672"] = 29874,
        ["27673"] = 85196,
        ["27674"] = 200,
        ["27676"] = 200,
        ["27677"] = 200,
        ["27678"] = 200,
        ["27681"] = 200,
        ["27682"] = 200,
        ["27683"] = 10000,
        ["27684"] = 5000,
        ["27685"] = 10,
        ["27686"] = 10,
        ["27687"] = 100,
        ["27688"] = 5000,
        ["27689"] = 5000,
        ["27690"] = 7500,
        ["27691"] = 7500,
        ["27692"] = 7500,
        ["27693"] = 7500,
        ["27694"] = 5000,
        ["27695"] = 5000,
        ["27696"] = 5000,
        ["27697"] = 7500,
        ["27698"] = 7500,
        ["27699"] = 7500,
        ["2770"] = 5,
        ["27700"] = 7500,
        ["2771"] = 25,
        ["27712"] = 21793,
        ["27713"] = 39550,
        ["27714"] = 34450,
        ["27715"] = 30889,
        ["27716"] = 40188,
        ["27717"] = 35626,
        ["2772"] = 150,
        ["27721"] = 32499,
        ["27722"] = 18673,
        ["27723"] = 15616,
        ["27724"] = 23508,
        ["27725"] = 32966,
        ["27726"] = 17603,
        ["27727"] = 22086,
        ["27728"] = 17736,
        ["27729"] = 667,
        ["2773"] = 39,
        ["27730"] = 17870,
        ["27731"] = 17421,
        ["27732"] = 17486,
        ["27733"] = 30284,
        ["27734"] = 30284,
        ["27735"] = 30284,
        ["27736"] = 5000,
        ["27737"] = 33294,
        ["27738"] = 26730,
        ["27739"] = 46860,
        ["2774"] = 28,
        ["27740"] = 10709,
        ["27741"] = 90078,
        ["27742"] = 16784,
        ["27743"] = 25273,
        ["27744"] = 25371,
        ["27745"] = 25469,
        ["27746"] = 17042,
        ["27747"] = 85539,
        ["27748"] = 60105,
        ["27749"] = 78430,
        ["2775"] = 75,
        ["27750"] = 78718,
        ["27751"] = 79015,
        ["27752"] = 79311,
        ["27753"] = 60223,
        ["27754"] = 60447,
        ["27755"] = 31020,
        ["27756"] = 60895,
        ["27757"] = 110959,
        ["27758"] = 22464,
        ["27759"] = 41287,
        ["2776"] = 500,
        ["27760"] = 23018,
        ["27761"] = 10709,
        ["27762"] = 10709,
        ["27763"] = 31588,
        ["27764"] = 16912,
        ["27765"] = 21219,
        ["27766"] = 39470,
        ["27767"] = 85530,
        ["27768"] = 17171,
        ["27769"] = 107715,
        ["2777"] = 147,
        ["27770"] = 21612,
        ["27771"] = 45495,
        ["27772"] = 55769,
        ["27773"] = 52479,
        ["27775"] = 27134,
        ["27776"] = 34036,
        ["27778"] = 27424,
        ["27779"] = 50287,
        ["2778"] = 147,
        ["27780"] = 83797,
        ["27781"] = 25073,
        ["27783"] = 20557,
        ["27784"] = 41903,
        ["27787"] = 41742,
        ["27789"] = 25236,
        ["2779"] = 0,
        ["27790"] = 45438,
        ["27791"] = 108780,
        ["27792"] = 8788,
        ["27793"] = 26298,
        ["27794"] = 65983,
        ["27795"] = 18086,
        ["27796"] = 27226,
        ["27797"] = 34155,
        ["27799"] = 36689,
        ["2780"] = 374,
        ["27800"] = 46024,
        ["27801"] = 41753,
        ["27802"] = 37916,
        ["27803"] = 44126,
        ["27804"] = 25360,
        ["27805"] = 10709,
        ["27806"] = 26252,
        ["27807"] = 0,
        ["27808"] = 0,
        ["2781"] = 335,
        ["27813"] = 47044,
        ["27814"] = 90096,
        ["27815"] = 27126,
        ["27816"] = 27224,
        ["27817"] = 68304,
        ["27818"] = 45694,
        ["2782"] = 751,
        ["27821"] = 27707,
        ["27822"] = 55035,
        ["27823"] = 51920,
        ["27824"] = 34743,
        ["27825"] = 21793,
        ["27826"] = 39550,
        ["27828"] = 10000,
        ["2783"] = 590,
        ["27838"] = 33962,
        ["27839"] = 59661,
        ["2784"] = 0,
        ["27844"] = 45504,
        ["27845"] = 39399,
        ["27846"] = 87492,
        ["27847"] = 46016,
        ["27848"] = 26440,
        ["2785"] = 1062,
        ["27854"] = 280,
        ["27855"] = 280,
        ["27856"] = 280,
        ["27857"] = 280,
        ["27858"] = 280,
        ["27859"] = 280,
        ["2786"] = 1173,
        ["27860"] = 320,
        ["27865"] = 26147,
        ["27866"] = 26242,
        ["27867"] = 32925,
        ["27868"] = 86036,
        ["27869"] = 41903,
        ["2787"] = 10,
        ["27870"] = 62137,
        ["27871"] = 8788,
        ["27872"] = 91750,
        ["27873"] = 46037,
        ["27874"] = 50151,
        ["27875"] = 33564,
        ["27876"] = 84237,
        ["27877"] = 105703,
        ["27878"] = 25463,
        ["2788"] = 0,
        ["27884"] = 44417,
        ["27885"] = 63806,
        ["27886"] = 25617,
        ["27887"] = 56311,
        ["27888"] = 39736,
        ["27889"] = 17722,
        ["27890"] = 66698,
        ["27891"] = 66290,
        ["27892"] = 26870,
        ["27893"] = 62913,
        ["27895"] = 30866,
        ["27896"] = 10000,
        ["27897"] = 57778,
        ["27898"] = 62144,
        ["27899"] = 85196,
        ["27900"] = 21612,
        ["27901"] = 83803,
        ["27902"] = 25849,
        ["27903"] = 111025,
        ["27904"] = 10709,
        ["27905"] = 89462,
        ["27906"] = 62851,
        ["27907"] = 36045,
        ["27908"] = 45215,
        ["27909"] = 54453,
        ["27910"] = 58292,
        ["27911"] = 22851,
        ["27912"] = 55034,
        ["27913"] = 92049,
        ["27914"] = 33819,
        ["27915"] = 37017,
        ["27916"] = 43988,
        ["27917"] = 24759,
        ["27918"] = 29163,
        ["27919"] = 25630,
        ["27925"] = 7102,
        ["27932"] = 870,
        ["27933"] = 990,
        ["27934"] = 1185,
        ["27935"] = 1325,
        ["27936"] = 51920,
        ["27937"] = 86858,
        ["27938"] = 32690,
        ["27939"] = 5537,
        ["2794"] = 0,
        ["27940"] = 100000,
        ["27941"] = 50000,
        ["27944"] = 87500,
        ["27945"] = 37500,
        ["27946"] = 26928,
        ["27948"] = 36165,
        ["2795"] = 0,
        ["2797"] = 0,
        ["27976"] = 62500,
        ["27977"] = 60782,
        ["27978"] = 2500,
        ["27979"] = 25000,
        ["2798"] = 25,
        ["27980"] = 87800,
        ["27981"] = 26437,
        ["27982"] = 75000,
        ["27985"] = 32296,
        ["27986"] = 115094,
        ["27987"] = 61203,
        ["27988"] = 24576,
        ["2799"] = 67,
        ["27991"] = 0,
        ["27992"] = 12500,
        ["27993"] = 37576,
        ["27994"] = 25143,
        ["27995"] = 31548,
        ["27996"] = 30866,
        ["2800"] = 1525,
        ["2801"] = 90978,
        ["2802"] = 1625,
        ["28024"] = 0,
        ["28026"] = 19557,
        ["28027"] = 22457,
        ["28028"] = 14852,
        ["28029"] = 14047,
        ["28030"] = 21753,
        ["28031"] = 22437,
        ["28032"] = 22518,
        ["28033"] = 107191,
        ["28034"] = 10000,
        ["28040"] = 66290,
        ["28041"] = 66290,
        ["28042"] = 66290,
        ["2805"] = 1882,
        ["28050"] = 33134,
        ["28051"] = 33255,
        ["28052"] = 26703,
        ["28053"] = 2,
        ["28055"] = 47247,
        ["28056"] = 3,
        ["28057"] = 40796,
        ["28058"] = 870,
        ["28059"] = 990,
        ["2806"] = 0,
        ["28060"] = 2,
        ["28061"] = 3,
        ["28062"] = 46848,
        ["28063"] = 43673,
        ["28064"] = 17536,
        ["28065"] = 17603,
        ["28066"] = 17669,
        ["28068"] = 15000,
        ["28069"] = 36740,
        ["2807"] = 2452,
        ["28070"] = 21111,
        ["28071"] = 3750,
        ["28072"] = 6500,
        ["28073"] = 16750,
        ["28074"] = 26782,
        ["28075"] = 21505,
        ["28100"] = 1000,
        ["28101"] = 1500,
        ["28102"] = 2500,
        ["28103"] = 2500,
        ["28104"] = 2500,
        ["28106"] = 0,
        ["28108"] = 10307,
        ["28109"] = 10307,
        ["28111"] = 0,
        ["28112"] = 0,
        ["28116"] = 0,
        ["28121"] = 10000,
        ["28124"] = 21217,
        ["28132"] = 0,
        ["28134"] = 22464,
        ["28141"] = 134,
        ["28142"] = 169,
        ["28143"] = 203,
        ["28144"] = 77,
        ["28146"] = 48,
        ["28147"] = 60,
        ["28148"] = 72,
        ["28149"] = 158,
        ["2815"] = 19778,
        ["28150"] = 149,
        ["28151"] = 449,
        ["28152"] = 240,
        ["28153"] = 257,
        ["28154"] = 334,
        ["28155"] = 193,
        ["28156"] = 193,
        ["28157"] = 422,
        ["28158"] = 243,
        ["28159"] = 244,
        ["2816"] = 7324,
        ["28160"] = 476,
        ["28161"] = 478,
        ["28162"] = 276,
        ["28163"] = 277,
        ["28164"] = 876,
        ["28166"] = 46065,
        ["28167"] = 31029,
        ["28168"] = 39818,
        ["28169"] = 24112,
        ["2817"] = 201,
        ["28170"] = 26735,
        ["28171"] = 22359,
        ["28172"] = 40625,
        ["28173"] = 48927,
        ["28174"] = 18082,
        ["28175"] = 57488,
        ["28176"] = 44320,
        ["28177"] = 38377,
        ["28178"] = 31961,
        ["28179"] = 25664,
        ["2818"] = 363,
        ["28180"] = 44997,
        ["28181"] = 38789,
        ["28182"] = 32446,
        ["28183"] = 26052,
        ["28184"] = 85100,
        ["28185"] = 34167,
        ["28186"] = 51441,
        ["28187"] = 22045,
        ["28188"] = 110575,
        ["28189"] = 88785,
        ["2819"] = 3830,
        ["28190"] = 10000,
        ["28191"] = 35771,
        ["28192"] = 41438,
        ["28193"] = 25081,
        ["28194"] = 25176,
        ["2820"] = 4662,
        ["28202"] = 43253,
        ["28203"] = 60782,
        ["28204"] = 43578,
        ["28205"] = 61232,
        ["28206"] = 32925,
        ["28207"] = 46177,
        ["2821"] = 1117,
        ["28210"] = 91424,
        ["28211"] = 55035,
        ["28212"] = 36830,
        ["28213"] = 34450,
        ["28215"] = 37906,
        ["28219"] = 50101,
        ["2822"] = 1402,
        ["28221"] = 45154,
        ["28227"] = 83797,
        ["28228"] = 54458,
        ["28229"] = 36436,
        ["2823"] = 1618,
        ["28230"] = 36566,
        ["28231"] = 55044,
        ["28232"] = 36823,
        ["28233"] = 22464,
        ["2824"] = 32032,
        ["28246"] = 322,
        ["28248"] = 27226,
        ["28249"] = 27324,
        ["2825"] = 14722,
        ["28250"] = 27422,
        ["28251"] = 34396,
        ["28252"] = 36819,
        ["28253"] = 115468,
        ["28254"] = 22464,
        ["28255"] = 31579,
        ["28256"] = 26060,
        ["28257"] = 87193,
        ["28258"] = 43988,
        ["28259"] = 30866,
        ["28260"] = 22045,
        ["28262"] = 62162,
        ["28263"] = 89128,
        ["28264"] = 44727,
        ["28265"] = 55035,
        ["28266"] = 54057,
        ["28267"] = 90421,
        ["28268"] = 22686,
        ["28269"] = 27319,
        ["28271"] = 20000,
        ["28272"] = 20000,
        ["28273"] = 15000,
        ["28274"] = 10000,
        ["28275"] = 38940,
        ["28278"] = 26250,
        ["28279"] = 30000,
        ["2828"] = 0,
        ["28281"] = 15000,
        ["28282"] = 10000,
        ["28283"] = 0,
        ["28284"] = 75,
        ["28285"] = 47035,
        ["28286"] = 67565,
        ["28287"] = 0,
        ["28288"] = 10000,
        ["2829"] = 0,
        ["28290"] = 10000,
        ["28291"] = 15000,
        ["28292"] = 0,
        ["28296"] = 26052,
        ["2830"] = 0,
        ["28301"] = 26538,
        ["28303"] = 403,
        ["28304"] = 17885,
        ["28306"] = 37788,
        ["2831"] = 0,
        ["28311"] = 85213,
        ["28315"] = 86506,
        ["28316"] = 55572,
        ["28317"] = 17431,
        ["28318"] = 45836,
        ["2832"] = 0,
        ["28321"] = 8788,
        ["28322"] = 91099,
        ["28323"] = 7102,
        ["28324"] = 32296,
        ["28325"] = 115094,
        ["28327"] = 14846,
        ["28328"] = 25271,
        ["2833"] = 0,
        ["28337"] = 62630,
        ["28338"] = 35918,
        ["28339"] = 33796,
        ["28340"] = 33918,
        ["28341"] = 113456,
        ["28342"] = 36436,
        ["28343"] = 10283,
        ["28345"] = 92058,
        ["28347"] = 41951,
        ["28348"] = 31582,
        ["28349"] = 38045,
        ["2835"] = 2,
        ["28350"] = 44472,
        ["28359"] = 0,
        ["2836"] = 15,
        ["28364"] = 0,
        ["28367"] = 104856,
        ["28369"] = 0,
        ["2837"] = 0,
        ["28370"] = 10000,
        ["28371"] = 26252,
        ["28372"] = 26350,
        ["28373"] = 26448,
        ["28374"] = 26545,
        ["28375"] = 31258,
        ["2838"] = 60,
        ["28384"] = 41455,
        ["28386"] = 64411,
        ["28387"] = 22045,
        ["2839"] = 0,
        ["28390"] = 30685,
        ["28391"] = 52500,
        ["28392"] = 87826,
        ["28393"] = 110190,
        ["28394"] = 41903,
        ["28396"] = 22279,
        ["28397"] = 67077,
        ["28398"] = 22440,
        ["28399"] = 280,
        ["2840"] = 10,
        ["28403"] = 59434,
        ["28406"] = 25762,
        ["28407"] = 55035,
        ["28408"] = 9,
        ["2841"] = 50,
        ["28412"] = 22045,
        ["28413"] = 26440,
        ["28414"] = 33172,
        ["28415"] = 26635,
        ["28416"] = 89102,
        ["28417"] = 0,
        ["28418"] = 10000,
        ["28419"] = 39470,
        ["2842"] = 100,
        ["28421"] = 1000,
        ["28425"] = 100534,
        ["28426"] = 114486,
        ["28427"] = 128528,
        ["28428"] = 127089,
        ["28429"] = 144720,
        ["2843"] = 0,
        ["28430"] = 162480,
        ["28431"] = 102808,
        ["28432"] = 117066,
        ["28433"] = 134904,
        ["28434"] = 133370,
        ["28435"] = 151832,
        ["28436"] = 170435,
        ["28437"] = 107834,
        ["28438"] = 122767,
        ["28439"] = 124657,
        ["2844"] = 106,
        ["28440"] = 123276,
        ["28441"] = 140395,
        ["28442"] = 157642,
        ["2845"] = 109,
        ["28452"] = 175,
        ["28453"] = 26575,
        ["28454"] = 32002,
        ["28455"] = 0,
        ["28457"] = 0,
        ["28458"] = 5000,
        ["28459"] = 5000,
        ["2846"] = 0,
        ["28460"] = 5000,
        ["28461"] = 5000,
        ["28462"] = 5000,
        ["28463"] = 5000,
        ["28464"] = 5000,
        ["28465"] = 5000,
        ["28466"] = 5000,
        ["28467"] = 5000,
        ["28468"] = 5000,
        ["28469"] = 5000,
        ["2847"] = 110,
        ["28470"] = 5000,
        ["28475"] = 0,
        ["28477"] = 21560,
        ["28478"] = 0,
        ["2848"] = 1119,
        ["28483"] = 71734,
        ["28484"] = 84902,
        ["28485"] = 98174,
        ["28486"] = 280,
        ["2849"] = 1269,
        ["28491"] = 22464,
        ["28492"] = 28179,
        ["28493"] = 34088,
        ["28494"] = 39661,
        ["28495"] = 13258,
        ["28496"] = 16632,
        ["28497"] = 18615,
        ["28498"] = 21925,
        ["285"] = 711,
        ["2850"] = 1439,
        ["28501"] = 25,
        ["28502"] = 35933,
        ["28503"] = 30737,
        ["28504"] = 77129,
        ["28505"] = 36334,
        ["28506"] = 25901,
        ["28507"] = 20795,
        ["28508"] = 20871,
        ["28509"] = 128862,
        ["2851"] = 56,
        ["28510"] = 60256,
        ["28511"] = 21099,
        ["28512"] = 37269,
        ["28513"] = 0,
        ["28514"] = 24756,
        ["28515"] = 19881,
        ["28516"] = 86443,
        ["28517"] = 30051,
        ["28518"] = 35391,
        ["28519"] = 30278,
        ["2852"] = 67,
        ["28520"] = 30392,
        ["28521"] = 25423,
        ["28522"] = 102064,
        ["28523"] = 30734,
        ["28524"] = 102829,
        ["28525"] = 203059,
        ["28526"] = 0,
        ["28527"] = 0,
        ["28528"] = 91160,
        ["28529"] = 31416,
        ["2853"] = 17,
        ["28530"] = 88355,
        ["28531"] = 26809,
        ["28532"] = 27678,
        ["28533"] = 28546,
        ["28534"] = 29415,
        ["28535"] = 30284,
        ["28536"] = 31154,
        ["28537"] = 32023,
        ["28538"] = 32891,
        ["28539"] = 33760,
        ["2854"] = 225,
        ["28540"] = 34629,
        ["28541"] = 35498,
        ["28542"] = 36368,
        ["28543"] = 37236,
        ["28544"] = 38105,
        ["28545"] = 38696,
        ["28547"] = 0,
        ["28548"] = 0,
        ["2855"] = 0,
        ["28551"] = 0,
        ["28554"] = 0,
        ["28558"] = 0,
        ["2856"] = 0,
        ["28561"] = 0,
        ["28562"] = 0,
        ["28563"] = 0,
        ["28565"] = 21184,
        ["28566"] = 37418,
        ["28567"] = 32002,
        ["28568"] = 32117,
        ["28569"] = 56299,
        ["2857"] = 198,
        ["28570"] = 32347,
        ["28572"] = 98228,
        ["28573"] = 123263,
        ["28578"] = 41297,
        ["28579"] = 91160,
        ["2858"] = 0,
        ["28581"] = 78293,
        ["28582"] = 31428,
        ["28583"] = 47315,
        ["28584"] = 105528,
        ["28585"] = 31773,
        ["28586"] = 31884,
        ["28587"] = 133332,
        ["28588"] = 80286,
        ["28589"] = 48554,
        ["2859"] = 0,
        ["28590"] = 91160,
        ["28591"] = 54092,
        ["28592"] = 32570,
        ["28593"] = 51661,
        ["28594"] = 40685,
        ["28595"] = 10000,
        ["28596"] = 12500,
        ["28597"] = 71995,
        ["28599"] = 62169,
        ["286"] = 645,
        ["28600"] = 51998,
        ["28601"] = 52185,
        ["28602"] = 41901,
        ["28603"] = 203059,
        ["28604"] = 131884,
        ["28606"] = 68014,
        ["28607"] = 0,
        ["28608"] = 56082,
        ["28609"] = 102777,
        ["28610"] = 45282,
        ["28611"] = 64361,
        ["28612"] = 30281,
        ["2862"] = 3,
        ["28621"] = 73051,
        ["2863"] = 10,
        ["28631"] = 45446,
        ["28632"] = 15000,
        ["28633"] = 126636,
        ["28634"] = 0,
        ["28635"] = 0,
        ["2864"] = 630,
        ["28647"] = 37130,
        ["28649"] = 60256,
        ["2865"] = 962,
        ["28651"] = 0,
        ["28652"] = 20183,
        ["28653"] = 30386,
        ["28654"] = 20334,
        ["28655"] = 25513,
        ["28656"] = 30730,
        ["28657"] = 102808,
        ["28658"] = 132414,
        ["2866"] = 753,
        ["28660"] = 32008,
        ["28661"] = 60256,
        ["28662"] = 75216,
        ["28663"] = 32350,
        ["28664"] = 0,
        ["28665"] = 0,
        ["28666"] = 51677,
        ["28667"] = 0,
        ["28669"] = 37409,
        ["28670"] = 6930,
        ["28671"] = 45235,
        ["28672"] = 30268,
        ["28673"] = 75958,
        ["28674"] = 88355,
        ["28675"] = 60256,
        ["28677"] = 0,
        ["2868"] = 807,
        ["2869"] = 1831,
        ["287"] = 488,
        ["2870"] = 2935,
        ["2871"] = 40,
        ["2872"] = 0,
        ["28726"] = 30395,
        ["28727"] = 91160,
        ["28728"] = 203059,
        ["28729"] = 102457,
        ["28730"] = 60256,
        ["28731"] = 102777,
        ["28732"] = 38848,
        ["28733"] = 36599,
        ["28734"] = 203059,
        ["28735"] = 62845,
        ["2874"] = 0,
        ["28740"] = 59414,
        ["28741"] = 49703,
        ["28742"] = 39915,
        ["28743"] = 52490,
        ["28744"] = 30163,
        ["28745"] = 102777,
        ["28746"] = 45791,
        ["28747"] = 53286,
        ["28748"] = 71445,
        ["28749"] = 102446,
        ["2875"] = 0,
        ["28750"] = 25707,
        ["28751"] = 61921,
        ["28752"] = 38844,
        ["28753"] = 60256,
        ["28754"] = 66783,
        ["28755"] = 40298,
        ["28756"] = 32353,
        ["28757"] = 113642,
        ["2876"] = 0,
        ["28762"] = 102777,
        ["28763"] = 60256,
        ["28764"] = 32863,
        ["28765"] = 32988,
        ["28766"] = 33110,
        ["28767"] = 110785,
        ["28768"] = 111202,
        ["28769"] = 0,
        ["2877"] = 8524,
        ["28770"] = 112024,
        ["28771"] = 115427,
        ["28772"] = 86883,
        ["28773"] = 145326,
        ["28777"] = 35375,
        ["28778"] = 32113,
        ["2878"] = 5143,
        ["28782"] = 135876,
        ["28783"] = 81838,
        ["28784"] = 0,
        ["28785"] = 91160,
        ["28786"] = 0,
        ["28787"] = 0,
        ["28788"] = 2500,
        ["2879"] = 3121,
        ["28795"] = 41209,
        ["28796"] = 44058,
        ["28797"] = 35368,
        ["28799"] = 21490,
        ["2880"] = 25,
        ["28800"] = 134820,
        ["28801"] = 48722,
        ["28802"] = 108689,
        ["28803"] = 42034,
        ["28804"] = 33749,
        ["2881"] = 150,
        ["28810"] = 51974,
        ["2882"] = 300,
        ["28822"] = 102777,
        ["28823"] = 91160,
        ["28825"] = 72258,
        ["28827"] = 34117,
        ["28828"] = 28535,
        ["28829"] = 0,
        ["2883"] = 375,
        ["28830"] = 91160,
        ["2885"] = 0,
        ["2886"] = 5,
        ["2888"] = 10,
        ["2889"] = 60,
        ["28913"] = 0,
        ["2892"] = 30,
        ["2893"] = 55,
        ["28934"] = 0,
        ["2894"] = 12,
        ["28962"] = 0,
        ["28969"] = 0,
        ["28972"] = 2350,
        ["28979"] = 3,
        ["2898"] = 32,
        ["2899"] = 169,
        ["2900"] = 89,
        ["29007"] = 7,
        ["29008"] = 18,
        ["29009"] = 50,
        ["2901"] = 16,
        ["29010"] = 200,
        ["29013"] = 200,
        ["29014"] = 200,
        ["29018"] = 0,
        ["2902"] = 1305,
        ["29026"] = 0,
        ["29027"] = 0,
        ["2903"] = 515,
        ["2904"] = 595,
        ["2905"] = 53,
        ["2906"] = 1810,
        ["2907"] = 1755,
        ["2908"] = 1409,
        ["2909"] = 0,
        ["2910"] = 1257,
        ["29101"] = 0,
        ["29106"] = 0,
        ["29108"] = 58074,
        ["29109"] = 72850,
        ["2911"] = 524,
        ["29110"] = 2,
        ["29111"] = 3,
        ["29112"] = 75,
        ["29113"] = 0,
        ["29115"] = 68812,
        ["29116"] = 46037,
        ["29117"] = 33434,
        ["29118"] = 25000,
        ["29119"] = 197528,
        ["2912"] = 6731,
        ["29121"] = 381149,
        ["29122"] = 114783,
        ["29123"] = 197528,
        ["29124"] = 395963,
        ["29125"] = 397425,
        ["29126"] = 197528,
        ["29127"] = 62408,
        ["29128"] = 7102,
        ["29129"] = 35918,
        ["2913"] = 1153,
        ["29130"] = 112653,
        ["29131"] = 45224,
        ["29132"] = 43988,
        ["29133"] = 113863,
        ["29134"] = 32178,
        ["29135"] = 41279,
        ["29136"] = 41426,
        ["29137"] = 104471,
        ["29138"] = 104878,
        ["29139"] = 25265,
        ["29140"] = 26062,
        ["29141"] = 43600,
        ["29142"] = 43763,
        ["29143"] = 25000,
        ["29145"] = 43988,
        ["29146"] = 43988,
        ["29147"] = 33426,
        ["2915"] = 55289,
        ["29151"] = 304557,
        ["29152"] = 305654,
        ["29153"] = 409000,
        ["29155"] = 411884,
        ["29156"] = 384270,
        ["29157"] = 1500,
        ["29158"] = 1750,
        ["29159"] = 8375,
        ["2916"] = 4405,
        ["29160"] = 9125,
        ["29161"] = 0,
        ["29163"] = 0,
        ["29165"] = 397346,
        ["29166"] = 111003,
        ["29167"] = 111410,
        ["29168"] = 43988,
        ["29169"] = 43988,
        ["2917"] = 665,
        ["29170"] = 197528,
        ["29171"] = 507547,
        ["29172"] = 197528,
        ["29173"] = 43988,
        ["29174"] = 25474,
        ["29175"] = 382768,
        ["29176"] = 245907,
        ["29177"] = 197528,
        ["29179"] = 43988,
        ["29180"] = 26057,
        ["29181"] = 197528,
        ["29182"] = 392921,
        ["29183"] = 78876,
        ["29184"] = 61700,
        ["29185"] = 88468,
        ["29186"] = 250000,
        ["29187"] = 75000,
        ["29189"] = 250000,
        ["29190"] = 250000,
        ["29191"] = 250000,
        ["29192"] = 250000,
        ["29194"] = 250000,
        ["29195"] = 250000,
        ["29196"] = 250000,
        ["29197"] = 250000,
        ["29198"] = 250000,
        ["29199"] = 250000,
        ["29201"] = 150,
        ["29202"] = 600,
        ["29203"] = 10000,
        ["29204"] = 20000,
        ["29207"] = 0,
        ["29209"] = 500,
        ["29211"] = 9954,
        ["29212"] = 300,
        ["29213"] = 30000,
        ["29214"] = 40000,
        ["29215"] = 40000,
        ["29216"] = 0,
        ["29226"] = 0,
        ["29232"] = 20000,
        ["29238"] = 36614,
        ["29239"] = 54706,
        ["2924"] = 16,
        ["29240"] = 20956,
        ["29241"] = 21031,
        ["29242"] = 31661,
        ["29243"] = 31776,
        ["29244"] = 31891,
        ["29245"] = 48217,
        ["29249"] = 21639,
        ["2925"] = 0,
        ["29251"] = 29583,
        ["29252"] = 34842,
        ["29255"] = 20574,
        ["29257"] = 20725,
        ["29258"] = 31202,
        ["29259"] = 31317,
        ["2926"] = 0,
        ["29264"] = 26570,
        ["29265"] = 39999,
        ["2928"] = 5,
        ["29280"] = 0,
        ["29281"] = 0,
        ["29292"] = 10,
        ["2930"] = 12,
        ["2931"] = 250,
        ["29312"] = 11665,
        ["29313"] = 33669,
        ["29314"] = 37384,
        ["29315"] = 15009,
        ["29316"] = 41649,
        ["29317"] = 16377,
        ["29318"] = 30818,
        ["29319"] = 24743,
        ["29320"] = 7102,
        ["29321"] = 7102,
        ["29322"] = 7102,
        ["29323"] = 7102,
        ["29325"] = 37866,
        ["29326"] = 32789,
        ["29327"] = 18203,
        ["29328"] = 14618,
        ["29329"] = 106924,
        ["2933"] = 3750,
        ["29330"] = 34450,
        ["29332"] = 32440,
        ["29333"] = 41953,
        ["29334"] = 41953,
        ["29335"] = 41953,
        ["29336"] = 41953,
        ["29337"] = 55814,
        ["29339"] = 48180,
        ["2934"] = 7,
        ["29340"] = 40294,
        ["29341"] = 32350,
        ["29342"] = 55280,
        ["29343"] = 35848,
        ["29344"] = 43186,
        ["29345"] = 28902,
        ["29346"] = 94921,
        ["29347"] = 88355,
        ["29348"] = 95652,
        ["29349"] = 88355,
        ["29350"] = 77727,
        ["29351"] = 74517,
        ["29354"] = 30132,
        ["29355"] = 126010,
        ["29356"] = 126467,
        ["29359"] = 127825,
        ["29361"] = 0,
        ["29362"] = 103346,
        ["29363"] = 100000,
        ["29364"] = 25000,
        ["29365"] = 0,
        ["29366"] = 0,
        ["29371"] = 69666,
        ["29372"] = 69923,
        ["29377"] = 88988,
        ["29378"] = 53585,
        ["29380"] = 71952,
        ["2939"] = 0,
        ["29391"] = 69653,
        ["29393"] = 280,
        ["29394"] = 400,
        ["29395"] = 320,
        ["29397"] = 0,
        ["29398"] = 30284,
        ["29399"] = 72796,
        ["2940"] = 43,
        ["29400"] = 17538,
        ["2941"] = 3552,
        ["29411"] = 0,
        ["2942"] = 3663,
        ["29425"] = 200,
        ["29426"] = 200,
        ["29428"] = 0,
        ["29429"] = 0,
        ["2943"] = 537,
        ["29434"] = 0,
        ["2944"] = 0,
        ["29443"] = 0,
        ["29445"] = 0,
        ["29447"] = 0,
        ["29448"] = 400,
        ["29449"] = 400,
        ["29450"] = 400,
        ["29451"] = 400,
        ["29452"] = 400,
        ["29453"] = 400,
        ["29454"] = 280,
        ["29456"] = 69716,
        ["29457"] = 69987,
        ["29459"] = 0,
        ["2946"] = 0,
        ["29461"] = 0,
        ["29463"] = 34844,
        ["29464"] = 0,
        ["29466"] = 5045,
        ["29468"] = 0,
        ["29469"] = 3899,
        ["2947"] = 0,
        ["29473"] = 0,
        ["29474"] = 0,
        ["29482"] = 0,
        ["29486"] = 15000,
        ["29488"] = 15000,
        ["29489"] = 52781,
        ["2949"] = 1039,
        ["29490"] = 26486,
        ["29491"] = 40049,
        ["29492"] = 53353,
        ["29493"] = 40332,
        ["29494"] = 24968,
        ["29495"] = 41772,
        ["29496"] = 20965,
        ["29497"] = 31564,
        ["29498"] = 42245,
        ["29499"] = 31803,
        ["2950"] = 3476,
        ["29500"] = 21281,
        ["29502"] = 40447,
        ["29503"] = 27064,
        ["29504"] = 37247,
        ["29505"] = 40893,
        ["29506"] = 27361,
        ["29507"] = 27461,
        ["29508"] = 49606,
        ["29509"] = 33190,
        ["2951"] = 656,
        ["29510"] = 46388,
        ["29511"] = 31045,
        ["29512"] = 46950,
        ["29514"] = 62803,
        ["29515"] = 63043,
        ["29516"] = 31638,
        ["29517"] = 31758,
        ["29520"] = 32114,
        ["29521"] = 32234,
        ["29525"] = 54518,
        ["29526"] = 28074,
        ["29527"] = 28172,
        ["29528"] = 5000,
        ["29529"] = 5000,
        ["2953"] = 1857,
        ["29532"] = 5000,
        ["29533"] = 20000,
        ["29534"] = 20000,
        ["29535"] = 40000,
        ["29536"] = 40000,
        ["29539"] = 1250,
        ["2954"] = 2485,
        ["29540"] = 30000,
        ["29547"] = 1250,
        ["29548"] = 2000,
        ["29549"] = 100000,
        ["2955"] = 3449,
        ["29550"] = 10000,
        ["29553"] = 870,
        ["29554"] = 990,
        ["29555"] = 1325,
        ["29556"] = 1185,
        ["29559"] = 1185,
        ["2956"] = 0,
        ["29560"] = 1325,
        ["29562"] = 990,
        ["29563"] = 1185,
        ["29564"] = 1325,
        ["29567"] = 1185,
        ["29568"] = 1325,
        ["29569"] = 0,
        ["2957"] = 119,
        ["29570"] = 670,
        ["29571"] = 670,
        ["29575"] = 670,
        ["29576"] = 670,
        ["29578"] = 990,
        ["29579"] = 870,
        ["2958"] = 94,
        ["29580"] = 1185,
        ["29581"] = 1325,
        ["29583"] = 1462,
        ["29584"] = 150,
        ["29589"] = 0,
        ["2959"] = 32,
        ["29590"] = 0,
        ["2960"] = 22,
        ["2961"] = 155,
        ["29618"] = 0,
        ["2962"] = 120,
        ["29624"] = 0,
        ["29625"] = 0,
        ["2963"] = 41,
        ["2964"] = 36,
        ["2965"] = 189,
        ["2966"] = 146,
        ["29664"] = 12500,
        ["2967"] = 66,
        ["29675"] = 12500,
        ["29677"] = 20000,
        ["2968"] = 34,
        ["29682"] = 20000,
        ["29684"] = 20000,
        ["29689"] = 20000,
        ["2969"] = 381,
        ["29691"] = 20000,
        ["29693"] = 20000,
        ["29698"] = 20000,
        ["2970"] = 333,
        ["29700"] = 20000,
        ["29701"] = 20000,
        ["29702"] = 20000,
        ["29703"] = 20000,
        ["29704"] = 20000,
        ["2971"] = 109,
        ["29713"] = 30000,
        ["29717"] = 30000,
        ["29719"] = 15000,
        ["2972"] = 72,
        ["29720"] = 15000,
        ["29721"] = 30000,
        ["29722"] = 30000,
        ["29723"] = 60000,
        ["29724"] = 60000,
        ["29725"] = 60000,
        ["29726"] = 60000,
        ["29728"] = 60000,
        ["29729"] = 60000,
        ["2973"] = 484,
        ["29731"] = 60000,
        ["29732"] = 60000,
        ["29733"] = 60000,
        ["29736"] = 0,
        ["29737"] = 0,
        ["29739"] = 0,
        ["2974"] = 392,
        ["29740"] = 0,
        ["29741"] = 0,
        ["2975"] = 128,
        ["2976"] = 172,
        ["29769"] = 0,
        ["2977"] = 476,
        ["29770"] = 0,
        ["29771"] = 14706,
        ["29772"] = 18446,
        ["29773"] = 33322,
        ["29774"] = 52018,
        ["29775"] = 34629,
        ["29776"] = 34629,
        ["29777"] = 19896,
        ["29778"] = 0,
        ["29779"] = 50120,
        ["2978"] = 415,
        ["29780"] = 32469,
        ["29781"] = 39728,
        ["29782"] = 35891,
        ["29783"] = 57552,
        ["29784"] = 17922,
        ["29785"] = 21586,
        ["29786"] = 37841,
        ["29787"] = 72472,
        ["29788"] = 43641,
        ["29789"] = 51098,
        ["2979"] = 157,
        ["29791"] = 38522,
        ["29792"] = 22133,
        ["29793"] = 35498,
        ["29794"] = 35498,
        ["29796"] = 0,
        ["29797"] = 0,
        ["29798"] = 0,
        ["29799"] = 1185,
        ["2980"] = 209,
        ["29800"] = 1325,
        ["29801"] = 0,
        ["29803"] = 0,
        ["29804"] = 26881,
        ["29806"] = 21660,
        ["29807"] = 25507,
        ["29808"] = 21818,
        ["2981"] = 648,
        ["29810"] = 27467,
        ["29811"] = 22052,
        ["29812"] = 25967,
        ["29813"] = 25562,
        ["29814"] = 27999,
        ["29815"] = 27999,
        ["29817"] = 0,
        ["29818"] = 0,
        ["2982"] = 566,
        ["2983"] = 280,
        ["2984"] = 215,
        ["2985"] = 822,
        ["2986"] = 718,
        ["2987"] = 408,
        ["2988"] = 314,
        ["2989"] = 1001,
        ["2990"] = 933,
        ["29902"] = 25000,
        ["29904"] = 1250,
        ["29908"] = 63676,
        ["29909"] = 51139,
        ["2991"] = 705,
        ["29910"] = 64172,
        ["29911"] = 64414,
        ["29913"] = 53349,
        ["29914"] = 53547,
        ["29915"] = 40305,
        ["29916"] = 40454,
        ["29917"] = 34647,
        ["29919"] = 34898,
        ["2992"] = 408,
        ["29926"] = 22362,
        ["29927"] = 16831,
        ["29928"] = 20942,
        ["29929"] = 26277,
        ["29930"] = 26374,
        ["29931"] = 19855,
        ["29932"] = 31887,
        ["29933"] = 32006,
        ["29934"] = 24091,
        ["29935"] = 37614,
        ["29936"] = 37753,
        ["29937"] = 28362,
        ["29938"] = 27162,
        ["29939"] = 27261,
        ["29940"] = 20520,
        ["29941"] = 32948,
        ["29942"] = 33067,
        ["29943"] = 24890,
        ["29944"] = 36094,
        ["29945"] = 36229,
        ["29946"] = 27224,
        ["29953"] = 1250,
        ["29954"] = 20744,
        ["29955"] = 17350,
        ["29956"] = 1250,
        ["29957"] = 1250,
        ["29958"] = 25000,
        ["29959"] = 24788,
        ["2996"] = 40,
        ["29964"] = 15290,
        ["29967"] = 33680,
        ["29968"] = 40565,
        ["29969"] = 35561,
        ["2997"] = 100,
        ["29970"] = 15642,
        ["29971"] = 18839,
        ["29973"] = 38564,
        ["29974"] = 38708,
        ["29975"] = 46617,
        ["29978"] = 30242,
        ["29979"] = 28450,
        ["2998"] = 0,
        ["29980"] = 53296,
        ["2999"] = 0,
        ["29999"] = 27088,
        ["3000"] = 119,
        ["30000"] = 14498,
        ["30001"] = 19742,
        ["30002"] = 34618,
        ["30003"] = 17412,
        ["30004"] = 31603,
        ["30005"] = 36774,
        ["30006"] = 36368,
        ["30009"] = 105395,
        ["30010"] = 105783,
        ["30011"] = 106170,
        ["30012"] = 106558,
        ["30014"] = 41860,
        ["30016"] = 44182,
        ["30019"] = 51135,
        ["30069"] = 22391,
        ["30070"] = 19263,
        ["30071"] = 32222,
        ["30072"] = 32340,
        ["30073"] = 33297,
        ["30074"] = 51597,
        ["30076"] = 44570,
        ["30077"] = 74563,
        ["3008"] = 43,
        ["30086"] = 96412,
        ["30087"] = 77416,
        ["30088"] = 97120,
        ["30089"] = 80037,
        ["30093"] = 101472,
        ["30094"] = 0,
        ["3010"] = 101,
        ["3011"] = 2847,
        ["3012"] = 50,
        ["3013"] = 25,
        ["3014"] = 0,
        ["30155"] = 150,
        ["30157"] = 0,
        ["3016"] = 0,
        ["3017"] = 0,
        ["3018"] = 625,
        ["3019"] = 423,
        ["3020"] = 2655,
        ["3021"] = 2421,
        ["30218"] = 26421,
        ["3022"] = 1085,
        ["30224"] = 21594,
        ["30225"] = 25427,
        ["30226"] = 54369,
        ["30227"] = 34629,
        ["3023"] = 754,
        ["3024"] = 1419,
        ["3025"] = 3695,
        ["30251"] = 0,
        ["30252"] = 51684,
        ["30253"] = 14527,
        ["30254"] = 25661,
        ["30255"] = 43902,
        ["30256"] = 33847,
        ["30257"] = 42459,
        ["30258"] = 59660,
        ["30259"] = 0,
        ["3026"] = 762,
        ["30260"] = 0,
        ["30262"] = 26795,
        ["30263"] = 32412,
        ["30264"] = 25332,
        ["30265"] = 13760,
        ["30266"] = 25899,
        ["30267"] = 24403,
        ["30268"] = 27154,
        ["30269"] = 25551,
        ["3027"] = 1269,
        ["30270"] = 47874,
        ["30271"] = 21111,
        ["30272"] = 35317,
        ["30273"] = 32042,
        ["30274"] = 20823,
        ["30275"] = 36505,
        ["30276"] = 34629,
        ["30277"] = 71933,
        ["30278"] = 72196,
        ["30279"] = 54344,
        ["30284"] = 20559,
        ["30285"] = 17198,
        ["30286"] = 31214,
        ["30290"] = 35050,
        ["30291"] = 36867,
        ["30293"] = 21612,
        ["30294"] = 20821,
        ["30295"] = 31483,
        ["30296"] = 48936,
        ["30297"] = 31838,
        ["30298"] = 52460,
        ["30299"] = 61414,
        ["3030"] = 0,
        ["30300"] = 41903,
        ["30309"] = 0,
        ["30315"] = 0,
        ["30326"] = 0,
        ["30328"] = 35632,
        ["30329"] = 32187,
        ["3033"] = 0,
        ["30330"] = 25950,
        ["30331"] = 14798,
        ["30332"] = 18565,
        ["30333"] = 33684,
        ["30334"] = 39191,
        ["30335"] = 28148,
        ["30336"] = 22599,
        ["30337"] = 39610,
        ["30338"] = 22758,
        ["30339"] = 36368,
        ["30340"] = 36368,
        ["30341"] = 17345,
        ["30342"] = 20895,
        ["3035"] = 0,
        ["30352"] = 26134,
        ["30354"] = 0,
        ["30355"] = 400,
        ["30357"] = 400,
        ["30358"] = 400,
        ["30359"] = 400,
        ["3036"] = 515,
        ["30360"] = 1500,
        ["30361"] = 400,
        ["30362"] = 25556,
        ["30363"] = 41039,
        ["30364"] = 68655,
        ["30365"] = 7086,
        ["30366"] = 7086,
        ["30368"] = 25292,
        ["30369"] = 31731,
        ["3037"] = 4814,
        ["30370"] = 25475,
        ["30371"] = 30000,
        ["30372"] = 21384,
        ["30373"] = 32193,
        ["30374"] = 38940,
        ["30375"] = 30434,
        ["30377"] = 7086,
        ["30378"] = 7086,
        ["30379"] = 35377,
        ["30380"] = 25000,
        ["30381"] = 37358,
        ["30382"] = 14311,
        ["30383"] = 13678,
        ["30384"] = 17162,
        ["30386"] = 36236,
        ["3039"] = 1610,
        ["30394"] = 86762,
        ["30395"] = 87099,
        ["30396"] = 87435,
        ["30397"] = 50141,
        ["30398"] = 20638,
        ["30399"] = 17264,
        ["3040"] = 940,
        ["30400"] = 24400,
        ["30401"] = 25452,
        ["30402"] = 23981,
        ["30404"] = 0,
        ["3041"] = 3769,
        ["30419"] = 750,
        ["3042"] = 4577,
        ["30420"] = 677,
        ["30421"] = 2542,
        ["30422"] = 8375,
        ["30425"] = 0,
        ["30429"] = 0,
        ["3045"] = 1574,
        ["30454"] = 0,
        ["30457"] = 320,
        ["30458"] = 280,
        ["30466"] = 1185,
        ["30467"] = 1325,
        ["3047"] = 1052,
        ["30475"] = 1185,
        ["30476"] = 1325,
        ["30477"] = 1185,
        ["30478"] = 1325,
        ["3048"] = 1919,
        ["30480"] = 25000,
        ["30481"] = 0,
        ["30483"] = 10000,
        ["3049"] = 2119,
        ["30500"] = 0,
        ["30501"] = 0,
        ["30504"] = 1258,
        ["30505"] = 631,
        ["30510"] = 1185,
        ["30511"] = 1325,
        ["30512"] = 1185,
        ["30513"] = 1325,
        ["30514"] = 20361,
        ["30515"] = 20438,
        ["30516"] = 13677,
        ["30517"] = 28831,
        ["30518"] = 28939,
        ["30519"] = 21785,
        ["30520"] = 14229,
        ["30521"] = 13930,
        ["30522"] = 91772,
        ["30523"] = 55355,
        ["30527"] = 0,
        ["3053"] = 2140,
        ["30532"] = 38419,
        ["30533"] = 67489,
        ["30536"] = 68249,
        ["30538"] = 49115,
        ["30541"] = 61160,
        ["30542"] = 5000,
        ["30543"] = 41065,
        ["30544"] = 5000,
        ["3055"] = 1526,
        ["30552"] = 30000,
        ["30554"] = 30000,
        ["3056"] = 1532,
        ["30563"] = 30000,
        ["30564"] = 30000,
        ["30565"] = 30000,
        ["30568"] = 5535,
        ["30569"] = 3633,
        ["3057"] = 903,
        ["30570"] = 17545,
        ["30571"] = 35243,
        ["3058"] = 682,
        ["30586"] = 30000,
        ["30588"] = 30000,
        ["30592"] = 30000,
        ["30593"] = 30000,
        ["30596"] = 0,
        ["30597"] = 18492,
        ["30599"] = 5535,
        ["30602"] = 30000,
        ["30603"] = 30000,
        ["30604"] = 30000,
        ["30605"] = 30000,
        ["30606"] = 30000,
        ["30608"] = 30000,
        ["30610"] = 280,
        ["30611"] = 7,
        ["30612"] = 7,
        ["30615"] = 1333,
        ["30622"] = 25000,
        ["30623"] = 25000,
        ["30633"] = 25000,
        ["30634"] = 25000,
        ["30635"] = 25000,
        ["30637"] = 25000,
        ["30640"] = 0,
        ["30641"] = 51899,
        ["30642"] = 29825,
        ["30643"] = 29586,
        ["30644"] = 25045,
        ["3065"] = 658,
        ["30651"] = 0,
        ["30652"] = 0,
        ["30653"] = 0,
        ["30654"] = 0,
        ["30655"] = 0,
        ["30656"] = 0,
        ["30657"] = 0,
        ["3066"] = 497,
        ["30666"] = 88355,
        ["30667"] = 60256,
        ["30668"] = 19724,
        ["3067"] = 1275,
        ["30673"] = 21264,
        ["30674"] = 36982,
        ["30675"] = 20455,
        ["30676"] = 25661,
        ["30677"] = 30903,
        ["30678"] = 36388,
        ["30679"] = 0,
        ["30681"] = 35466,
        ["30683"] = 51307,
        ["30684"] = 78623,
        ["30685"] = 24661,
        ["30686"] = 29703,
        ["30687"] = 34976,
        ["30688"] = 0,
        ["3069"] = 1412,
        ["30690"] = 0,
        ["30692"] = 0,
        ["30694"] = 0,
        ["30696"] = 15000,
        ["3070"] = 7,
        ["30703"] = 0,
        ["30709"] = 33564,
        ["3071"] = 231,
        ["30719"] = 0,
        ["3072"] = 1207,
        ["30721"] = 0,
        ["30722"] = 133352,
        ["30726"] = 102777,
        ["30728"] = 49076,
        ["3073"] = 1211,
        ["30732"] = 128369,
        ["30733"] = 103095,
        ["30735"] = 31168,
        ["30736"] = 60256,
        ["30738"] = 60256,
        ["3074"] = 476,
        ["30740"] = 55476,
        ["30741"] = 37407,
        ["30742"] = 0,
        ["30744"] = 30000,
        ["30745"] = 35000,
        ["30746"] = 25000,
        ["30747"] = 30000,
        ["30748"] = 35000,
        ["30749"] = 29108,
        ["3075"] = 15073,
        ["30750"] = 37874,
        ["30751"] = 29676,
        ["30752"] = 33679,
        ["30753"] = 65333,
        ["30754"] = 27483,
        ["30755"] = 50995,
        ["30757"] = 20851,
        ["30758"] = 20675,
        ["30759"] = 20499,
        ["3076"] = 636,
        ["30765"] = 25321,
        ["30771"] = 13006,
        ["30775"] = 21719,
        ["30777"] = 11851,
        ["3078"] = 2314,
        ["30781"] = 20200,
        ["30782"] = 0,
        ["30783"] = 0,
        ["30784"] = 10100,
        ["30787"] = 90791,
        ["30788"] = 91108,
        ["30789"] = 114292,
        ["3079"] = 297,
        ["30798"] = 0,
        ["30799"] = 0,
        ["3080"] = 0,
        ["30803"] = 0,
        ["30804"] = 1064,
        ["30808"] = 0,
        ["30809"] = 200,
        ["3081"] = 0,
        ["30810"] = 200,
        ["30811"] = 175,
        ["30812"] = 1185,
        ["30813"] = 1325,
        ["30814"] = 1185,
        ["30815"] = 1325,
        ["30816"] = 5,
        ["30817"] = 1,
        ["30819"] = 0,
        ["3082"] = 0,
        ["30820"] = 1325,
        ["30821"] = 1185,
        ["30823"] = 75000,
        ["30825"] = 37037,
        ["30826"] = 30000,
        ["3083"] = 0,
        ["30830"] = 478559,
        ["30831"] = 25066,
        ["30832"] = 96442,
        ["30833"] = 15000,
        ["30834"] = 49382,
        ["30835"] = 52125,
        ["30836"] = 34880,
        ["30837"] = 17088,
        ["30838"] = 17430,
        ["30839"] = 35267,
        ["3084"] = 0,
        ["30840"] = 0,
        ["30841"] = 43988,
        ["30842"] = 15000,
        ["30843"] = 20000,
        ["30844"] = 25000,
        ["30846"] = 250000,
        ["30847"] = 0,
        ["3085"] = 0,
        ["30851"] = 0,
        ["30852"] = 0,
        ["30853"] = 0,
        ["30854"] = 0,
        ["30855"] = 54657,
        ["30856"] = 28744,
        ["30857"] = 27388,
        ["30858"] = 0,
        ["30859"] = 62985,
        ["3086"] = 0,
        ["30860"] = 41555,
        ["30867"] = 0,
        ["3087"] = 11,
        ["30890"] = 0,
        ["30922"] = 22675,
        ["30923"] = 15170,
        ["30924"] = 15901,
        ["30925"] = 24553,
        ["30926"] = 20879,
        ["30927"] = 14314,
        ["30928"] = 28046,
        ["30929"] = 28151,
        ["30930"] = 14474,
        ["30931"] = 21789,
        ["30932"] = 16799,
        ["30933"] = 42153,
        ["30936"] = 18492,
        ["30937"] = 18559,
        ["30938"] = 27273,
        ["30939"] = 32306,
        ["30940"] = 17421,
        ["30941"] = 34142,
        ["30942"] = 17556,
        ["30943"] = 0,
        ["30944"] = 20381,
        ["30945"] = 35512,
        ["30946"] = 26096,
        ["30947"] = 41907,
        ["30948"] = 49654,
        ["30950"] = 21188,
        ["30951"] = 25103,
        ["30952"] = 32948,
        ["30953"] = 33069,
        ["30955"] = 32370,
        ["30956"] = 22189,
        ["30957"] = 45695,
        ["30958"] = 31251,
        ["30959"] = 48587,
        ["30960"] = 47610,
        ["30961"] = 36652,
        ["30962"] = 28475,
        ["30964"] = 37072,
        ["30966"] = 24490,
        ["30967"] = 29018,
        ["30971"] = 21785,
        ["30973"] = 40860,
        ["30981"] = 36368,
        ["30984"] = 52160,
        ["30986"] = 44524,
        ["30999"] = 79950,
        ["31000"] = 60195,
        ["31002"] = 80880,
        ["31009"] = 106568,
        ["31010"] = 106956,
        ["31013"] = 86486,
        ["31025"] = 24577,
        ["3103"] = 466,
        ["31031"] = 25116,
        ["31033"] = 25295,
        ["31036"] = 108344,
        ["31038"] = 101456,
        ["31062"] = 103834,
        ["3107"] = 0,
        ["31071"] = 79665,
        ["31072"] = 59981,
        ["31073"] = 80285,
        ["31074"] = 41555,
        ["31075"] = 41555,
        ["31076"] = 41555,
        ["31077"] = 41555,
        ["31078"] = 41555,
        ["31079"] = 10000,
        ["3108"] = 0,
        ["31080"] = 4000,
        ["31084"] = 0,
        ["31085"] = 0,
        ["31086"] = 0,
        ["3110"] = 0,
        ["31104"] = 25765,
        ["31105"] = 45161,
        ["31106"] = 38922,
        ["31107"] = 39062,
        ["31108"] = 0,
        ["31109"] = 32781,
        ["3111"] = 0,
        ["31110"] = 32897,
        ["31111"] = 13825,
        ["31112"] = 26020,
        ["31113"] = 43988,
        ["31114"] = 20977,
        ["31115"] = 36782,
        ["31116"] = 30000,
        ["31119"] = 0,
        ["31120"] = 0,
        ["31121"] = 0,
        ["31125"] = 33546,
        ["31126"] = 17317,
        ["31127"] = 41706,
        ["31128"] = 0,
        ["31129"] = 0,
        ["31130"] = 0,
        ["31131"] = 16005,
        ["31133"] = 25608,
        ["31134"] = 82877,
        ["31136"] = 48207,
        ["31137"] = 24331,
        ["31138"] = 19802,
        ["31139"] = 69628,
        ["31140"] = 20965,
        ["31141"] = 0,
        ["31142"] = 66009,
        ["31143"] = 21832,
        ["31144"] = 0,
        ["31145"] = 25499,
        ["31146"] = 0,
        ["31147"] = 28836,
        ["31148"] = 25499,
        ["31149"] = 13599,
        ["31150"] = 13599,
        ["31151"] = 24635,
        ["31152"] = 50352,
        ["31153"] = 69987,
        ["31154"] = 750,
        ["31155"] = 58153,
        ["31157"] = 41843,
        ["31159"] = 44177,
        ["31160"] = 38247,
        ["31161"] = 31844,
        ["31162"] = 25568,
        ["31163"] = 28611,
        ["31164"] = 22786,
        ["31165"] = 18988,
        ["31166"] = 15259,
        ["3117"] = 0,
        ["31170"] = 37218,
        ["31172"] = 31015,
        ["31173"] = 31634,
        ["31174"] = 24812,
        ["31175"] = 17496,
        ["31176"] = 24964,
        ["31177"] = 20399,
        ["31178"] = 38775,
        ["31179"] = 17928,
        ["31180"] = 25335,
        ["31181"] = 13599,
        ["31182"] = 33546,
        ["31183"] = 31627,
        ["31184"] = 24007,
        ["31185"] = 19206,
        ["31186"] = 89970,
        ["31187"] = 32533,
        ["31188"] = 24635,
        ["31189"] = 20996,
        ["31190"] = 26991,
        ["31191"] = 17496,
        ["31192"] = 13997,
        ["31193"] = 71976,
        ["31194"] = 37731,
        ["31195"] = 27778,
        ["31196"] = 8788,
        ["31197"] = 22786,
        ["31198"] = 18988,
        ["31199"] = 15191,
        ["31200"] = 47338,
        ["31201"] = 24836,
        ["31202"] = 26036,
        ["31203"] = 39818,
        ["31204"] = 55282,
        ["31209"] = 56839,
        ["31210"] = 48900,
        ["31212"] = 32848,
        ["31213"] = 41885,
        ["31214"] = 36129,
        ["31215"] = 29975,
        ["31216"] = 23980,
        ["31217"] = 45002,
        ["31218"] = 35970,
        ["31219"] = 29975,
        ["31220"] = 23980,
        ["31221"] = 26736,
        ["31222"] = 33284,
        ["31223"] = 22786,
        ["31224"] = 18921,
        ["31225"] = 15191,
        ["31226"] = 36982,
        ["31227"] = 24126,
        ["31228"] = 20399,
        ["31229"] = 16999,
        ["31230"] = 23239,
        ["31231"] = 13599,
        ["31232"] = 35631,
        ["31233"] = 30735,
        ["31234"] = 80717,
        ["31235"] = 25499,
        ["31236"] = 21834,
        ["31237"] = 37977,
        ["31238"] = 36689,
        ["31239"] = 0,
        ["31240"] = 49481,
        ["31241"] = 0,
        ["31242"] = 50527,
        ["31243"] = 39605,
        ["31244"] = 33004,
        ["31246"] = 26403,
        ["31247"] = 35821,
        ["31248"] = 31012,
        ["31249"] = 24753,
        ["31250"] = 20737,
        ["31251"] = 0,
        ["31254"] = 21593,
        ["31255"] = 24298,
        ["31258"] = 55035,
        ["31262"] = 0,
        ["31268"] = 1066,
        ["31269"] = 1070,
        ["31270"] = 805,
        ["31272"] = 24033,
        ["31275"] = 41903,
        ["31276"] = 40842,
        ["31277"] = 41903,
        ["31279"] = 0,
        ["31280"] = 23383,
        ["31281"] = 29229,
        ["31282"] = 31177,
        ["31283"] = 15899,
        ["31284"] = 28806,
        ["31285"] = 39966,
        ["31286"] = 47960,
        ["31287"] = 51157,
        ["31288"] = 29975,
        ["31289"] = 99916,
        ["31290"] = 10709,
        ["31291"] = 107599,
        ["31292"] = 52430,
        ["31293"] = 24576,
        ["31294"] = 40363,
        ["31295"] = 40961,
        ["31297"] = 32769,
        ["31298"] = 58768,
        ["31299"] = 105351,
        ["31300"] = 0,
        ["31303"] = 64180,
        ["31304"] = 85891,
        ["31305"] = 86216,
        ["31306"] = 33564,
        ["31308"] = 104889,
        ["3131"] = 0,
        ["31310"] = 0,
        ["31312"] = 21446,
        ["31313"] = 17936,
        ["31314"] = 32544,
        ["31315"] = 25434,
        ["31317"] = 0,
        ["31318"] = 117800,
        ["31319"] = 79025,
        ["31320"] = 65940,
        ["31321"] = 115200,
        ["31322"] = 119615,
        ["31323"] = 72035,
        ["31324"] = 0,
        ["31326"] = 60256,
        ["31328"] = 56520,
        ["31329"] = 28260,
        ["31330"] = 42390,
        ["31331"] = 101568,
        ["31332"] = 101934,
        ["31333"] = 35325,
        ["31334"] = 128318,
        ["31335"] = 47100,
        ["31336"] = 413543,
        ["31337"] = 6250,
        ["31338"] = 88355,
        ["31339"] = 60256,
        ["31340"] = 37680,
        ["31341"] = 20052,
        ["31342"] = 94200,
        ["31343"] = 37680,
        ["31347"] = 0,
        ["3135"] = 0,
        ["31351"] = 0,
        ["31354"] = 10000,
        ["31355"] = 10000,
        ["31356"] = 10000,
        ["31357"] = 10000,
        ["31358"] = 30000,
        ["31359"] = 15000,
        ["31361"] = 15000,
        ["31362"] = 30000,
        ["31364"] = 72552,
        ["31366"] = 1,
        ["31367"] = 73355,
        ["31368"] = 55107,
        ["31369"] = 73884,
        ["3137"] = 0,
        ["31370"] = 74152,
        ["31371"] = 55708,
        ["31373"] = 0,
        ["31380"] = 41903,
        ["31381"] = 41903,
        ["31382"] = 41903,
        ["31383"] = 41903,
        ["31384"] = 0,
        ["31386"] = 0,
        ["31387"] = 0,
        ["31390"] = 60000,
        ["31391"] = 60000,
        ["31392"] = 60000,
        ["31393"] = 60000,
        ["31394"] = 60000,
        ["31395"] = 60000,
        ["31398"] = 60256,
        ["31399"] = 60256,
        ["31401"] = 30000,
        ["31402"] = 30000,
        ["31414"] = 83568,
        ["31415"] = 44029,
        ["31416"] = 50525,
        ["31417"] = 102273,
        ["31418"] = 12893,
        ["31419"] = 24266,
        ["31420"] = 29359,
        ["31421"] = 22947,
        ["31422"] = 65433,
        ["31423"] = 67420,
        ["31424"] = 50747,
        ["31425"] = 13580,
        ["31426"] = 17036,
        ["31427"] = 30911,
        ["31428"] = 24155,
        ["31429"] = 20660,
        ["31430"] = 15631,
        ["31431"] = 18830,
        ["31432"] = 33015,
        ["31433"] = 25968,
        ["31434"] = 32585,
        ["31435"] = 30196,
        ["31436"] = 35293,
        ["31437"] = 0,
        ["31438"] = 19848,
        ["31439"] = 17050,
        ["31440"] = 20533,
        ["31441"] = 35996,
        ["31442"] = 27578,
        ["31443"] = 34597,
        ["31444"] = 31247,
        ["31445"] = 24530,
        ["31446"] = 69937,
        ["31447"] = 70180,
        ["31448"] = 70430,
        ["31450"] = 0,
        ["31451"] = 0,
        ["31452"] = 15519,
        ["31453"] = 24342,
        ["31454"] = 19549,
        ["31455"] = 23653,
        ["31456"] = 20754,
        ["31457"] = 26039,
        ["31459"] = 48960,
        ["31460"] = 31388,
        ["31461"] = 17899,
        ["31462"] = 26944,
        ["31463"] = 0,
        ["31464"] = 22616,
        ["31465"] = 27237,
        ["31470"] = 25002,
        ["31471"] = 32246,
        ["31472"] = 19420,
        ["31473"] = 22872,
        ["31474"] = 50204,
        ["31475"] = 67189,
        ["31476"] = 67439,
        ["31477"] = 13188,
        ["31478"] = 24818,
        ["31479"] = 19928,
        ["31480"] = 23468,
        ["31481"] = 13381,
        ["31482"] = 16787,
        ["31483"] = 35314,
        ["31484"] = 20291,
        ["31485"] = 27149,
        ["31486"] = 34058,
        ["31487"] = 28583,
        ["31488"] = 33411,
        ["31489"] = 0,
        ["31490"] = 52380,
        ["31491"] = 52578,
        ["31492"] = 81771,
        ["31493"] = 41555,
        ["31494"] = 41555,
        ["31501"] = 100000,
        ["31504"] = 0,
        ["31508"] = 26847,
        ["31509"] = 20212,
        ["3151"] = 87,
        ["31510"] = 13186,
        ["31511"] = 33940,
        ["31512"] = 16606,
        ["31513"] = 16669,
        ["31514"] = 41189,
        ["31515"] = 20669,
        ["31516"] = 20225,
        ["31519"] = 50226,
        ["3152"] = 28,
        ["31520"] = 37732,
        ["31521"] = 36916,
        ["31523"] = 41555,
        ["31526"] = 41555,
        ["31527"] = 41555,
        ["31528"] = 41555,
        ["3153"] = 33,
        ["31531"] = 13574,
        ["31532"] = 25548,
        ["31533"] = 30910,
        ["31534"] = 24159,
        ["31535"] = 0,
        ["31537"] = 20835,
        ["31538"] = 26135,
        ["31539"] = 20983,
        ["3154"] = 1094,
        ["31540"] = 24708,
        ["31541"] = 72250,
        ["31542"] = 90633,
        ["31543"] = 82287,
        ["31544"] = 39983,
        ["31545"] = 40134,
        ["31546"] = 24173,
        ["31547"] = 36399,
        ["31548"] = 56839,
        ["31549"] = 57050,
        ["3155"] = 0,
        ["31550"] = 0,
        ["3158"] = 60,
        ["3160"] = 470,
        ["31606"] = 0,
        ["3161"] = 295,
        ["31610"] = 0,
        ["31615"] = 8222,
        ["31617"] = 8222,
        ["3162"] = 0,
        ["3163"] = 0,
        ["3164"] = 33,
        ["3165"] = 0,
        ["31652"] = 0,
        ["31655"] = 0,
        ["31657"] = 22454,
        ["31658"] = 21130,
        ["31659"] = 16969,
        ["3166"] = 407,
        ["31660"] = 15873,
        ["31661"] = 15092,
        ["31662"] = 0,
        ["31666"] = 5000,
        ["31668"] = 0,
        ["3167"] = 68,
        ["31670"] = 200,
        ["31671"] = 200,
        ["31672"] = 150,
        ["31673"] = 150,
        ["31674"] = 7500,
        ["31675"] = 7500,
        ["31676"] = 5000,
        ["31677"] = 5000,
        ["31678"] = 0,
        ["31679"] = 3000,
        ["31680"] = 10000,
        ["31681"] = 10000,
        ["31682"] = 10000,
        ["31683"] = 13887,
        ["31684"] = 17423,
        ["31686"] = 49140,
        ["31687"] = 21136,
        ["31688"] = 26514,
        ["3169"] = 18,
        ["31690"] = 25068,
        ["31691"] = 39818,
        ["31692"] = 39818,
        ["31693"] = 39818,
        ["31694"] = 39818,
        ["31695"] = 39818,
        ["31696"] = 39818,
        ["31697"] = 0,
        ["31698"] = 0,
        ["31699"] = 34629,
        ["3170"] = 47,
        ["31700"] = 85828,
        ["31701"] = 86148,
        ["31702"] = 0,
        ["31703"] = 69424,
        ["3171"] = 6,
        ["31711"] = 20900,
        ["31712"] = 24355,
        ["31713"] = 29338,
        ["31714"] = 23037,
        ["31715"] = 28546,
        ["31717"] = 27137,
        ["31718"] = 34046,
        ["31719"] = 41009,
        ["3172"] = 18,
        ["31720"] = 48023,
        ["31723"] = 62449,
        ["31724"] = 48321,
        ["31725"] = 12933,
        ["31726"] = 30574,
        ["31727"] = 30574,
        ["31728"] = 32023,
        ["31729"] = 32023,
        ["3173"] = 15,
        ["31730"] = 32023,
        ["31731"] = 32023,
        ["31732"] = 32023,
        ["31733"] = 61828,
        ["31734"] = 39721,
        ["31735"] = 25,
        ["31737"] = 25,
        ["31739"] = 0,
        ["3174"] = 16,
        ["31740"] = 0,
        ["31747"] = 41953,
        ["31748"] = 41953,
        ["31749"] = 41953,
        ["3175"] = 100,
        ["31752"] = 0,
        ["31754"] = 0,
        ["31756"] = 71638,
        ["31758"] = 72181,
        ["31759"] = 72453,
        ["3176"] = 75,
        ["31760"] = 5000,
        ["31761"] = 47720,
        ["31762"] = 47893,
        ["31763"] = 0,
        ["31764"] = 39664,
        ["31765"] = 46440,
        ["31766"] = 19974,
        ["31768"] = 18476,
        ["31769"] = 0,
        ["3177"] = 50,
        ["31770"] = 11890,
        ["31773"] = 2500,
        ["31774"] = 2500,
        ["31776"] = 2500,
        ["31778"] = 2500,
        ["31779"] = 2500,
        ["31780"] = 2500,
        ["31781"] = 2500,
        ["31782"] = 39375,
        ["31783"] = 26345,
        ["31784"] = 24787,
        ["31785"] = 82921,
        ["31786"] = 27639,
        ["31787"] = 21600,
        ["31788"] = 15396,
        ["31789"] = 16773,
        ["3179"] = 125,
        ["31790"] = 34629,
        ["31791"] = 41555,
        ["31792"] = 20526,
        ["31793"] = 17169,
        ["31794"] = 44616,
        ["31796"] = 19263,
        ["31797"] = 24165,
        ["31798"] = 25871,
        ["3180"] = 168,
        ["31800"] = 0,
        ["31804"] = 2500,
        ["31808"] = 0,
        ["3181"] = 23,
        ["31810"] = 0,
        ["31811"] = 0,
        ["31812"] = 0,
        ["31813"] = 0,
        ["31814"] = 0,
        ["31815"] = 0,
        ["31816"] = 82425,
        ["31817"] = 29915,
        ["31818"] = 34629,
        ["31819"] = 34935,
        ["3182"] = 387,
        ["31820"] = 32891,
        ["31821"] = 67150,
        ["31823"] = 32023,
        ["31825"] = 0,
        ["31827"] = 0,
        ["31829"] = 175000,
        ["3183"] = 0,
        ["31831"] = 175000,
        ["31833"] = 175000,
        ["31835"] = 175000,
        ["31837"] = 14750,
        ["3184"] = 1394,
        ["3185"] = 8088,
        ["3186"] = 4436,
        ["3187"] = 14870,
        ["3188"] = 879,
        ["3189"] = 99,
        ["3190"] = 99,
        ["3191"] = 3857,
        ["3192"] = 495,
        ["3193"] = 2072,
        ["3194"] = 2496,
        ["3195"] = 1372,
        ["3196"] = 1377,
        ["3197"] = 9295,
        ["3198"] = 2742,
        ["3199"] = 2262,
        ["3200"] = 19,
        ["3201"] = 4496,
        ["3202"] = 584,
        ["3203"] = 5436,
        ["3204"] = 751,
        ["3205"] = 230,
        ["3206"] = 4582,
        ["3207"] = 87,
        ["3208"] = 25378,
        ["3209"] = 6783,
        ["3210"] = 5627,
        ["3211"] = 373,
        ["3212"] = 929,
        ["3213"] = 89,
        ["3214"] = 34,
        ["3216"] = 55,
        ["3217"] = 135,
        ["3220"] = 40,
        ["3223"] = 306,
        ["3224"] = 28,
        ["3225"] = 109,
        ["3227"] = 2480,
        ["3228"] = 1098,
        ["3229"] = 424,
        ["3230"] = 768,
        ["3231"] = 1266,
        ["3233"] = 212,
        ["3234"] = 0,
        ["3235"] = 412,
        ["3236"] = 0,
        ["3237"] = 0,
        ["3238"] = 0,
        ["3239"] = 3,
        ["3240"] = 10,
        ["3241"] = 40,
        ["3248"] = 0,
        ["3250"] = 0,
        ["3251"] = 0,
        ["3252"] = 0,
        ["3253"] = 0,
        ["3254"] = 0,
        ["3260"] = 6,
        ["3261"] = 7,
        ["3262"] = 10,
        ["3263"] = 4,
        ["3264"] = 0,
        ["3265"] = 0,
        ["3266"] = 0,
        ["3267"] = 25,
        ["3268"] = 25,
        ["3269"] = 25,
        ["3270"] = 10,
        ["3272"] = 13,
        ["3273"] = 15,
        ["3274"] = 7,
        ["3275"] = 5,
        ["3276"] = 15,
        ["3277"] = 30,
        ["3279"] = 105,
        ["3280"] = 33,
        ["3281"] = 56,
        ["3282"] = 235,
        ["3283"] = 295,
        ["3284"] = 88,
        ["3285"] = 36,
        ["3286"] = 59,
        ["3287"] = 199,
        ["3288"] = 250,
        ["3289"] = 57,
        ["3290"] = 48,
        ["3291"] = 202,
        ["3292"] = 203,
        ["3295"] = 10,
        ["3297"] = 0,
        ["3299"] = 48,
        ["3300"] = 9,
        ["3301"] = 102,
        ["3302"] = 319,
        ["3303"] = 70,
        ["3304"] = 106,
        ["3305"] = 492,
        ["3306"] = 654,
        ["3307"] = 215,
        ["3308"] = 144,
        ["3309"] = 333,
        ["3310"] = 442,
        ["3311"] = 152,
        ["3312"] = 70,
        ["3313"] = 519,
        ["3314"] = 171,
        ["3315"] = 455,
        ["3317"] = 0,
        ["3318"] = 0,
        ["3319"] = 110,
        ["3321"] = 41,
        ["3322"] = 11,
        ["3323"] = 15,
        ["3324"] = 1120,
        ["3325"] = 140,
        ["3327"] = 141,
        ["3328"] = 46,
        ["3329"] = 179,
        ["3330"] = 281,
        ["3331"] = 67,
        ["3332"] = 48,
        ["3334"] = 68,
        ["3335"] = 46,
        ["3336"] = 3986,
        ["3337"] = 0,
        ["3339"] = 0,
        ["3340"] = 31,
        ["3341"] = 1621,
        ["3342"] = 137,
        ["3343"] = 450,
        ["3344"] = 133,
        ["3345"] = 2720,
        ["3347"] = 0,
        ["3348"] = 0,
        ["3349"] = 0,
        ["3352"] = 1250,
        ["3353"] = 0,
        ["3355"] = 50,
        ["3356"] = 30,
        ["3357"] = 75,
        ["3358"] = 175,
        ["3360"] = 625,
        ["3363"] = 1,
        ["3365"] = 3,
        ["3369"] = 25,
        ["3370"] = 10,
        ["3371"] = 1,
        ["3372"] = 10,
        ["3373"] = 14,
        ["3374"] = 45,
        ["3375"] = 30,
        ["3376"] = 86,
        ["3377"] = 99,
        ["3378"] = 132,
        ["3379"] = 152,
        ["3380"] = 365,
        ["3381"] = 303,
        ["3382"] = 10,
        ["3383"] = 100,
        ["3384"] = 20,
        ["3385"] = 30,
        ["3386"] = 35,
        ["3387"] = 30,
        ["3388"] = 40,
        ["3389"] = 40,
        ["3390"] = 35,
        ["3391"] = 20,
        ["3392"] = 1663,
        ["3393"] = 250,
        ["3394"] = 250,
        ["3395"] = 250,
        ["3396"] = 250,
        ["3397"] = 0,
        ["3399"] = 81,
        ["3400"] = 2761,
        ["3401"] = 81,
        ["3402"] = 602,
        ["3403"] = 321,
        ["3404"] = 181,
        ["3405"] = 0,
        ["3406"] = 0,
        ["3407"] = 0,
        ["3408"] = 0,
        ["3409"] = 0,
        ["3411"] = 0,
        ["3412"] = 0,
        ["3413"] = 3229,
        ["3414"] = 4029,
        ["3415"] = 3598,
        ["3416"] = 2213,
        ["3417"] = 4629,
        ["3418"] = 0,
        ["3419"] = 125,
        ["3420"] = 1250,
        ["3421"] = 50,
        ["3422"] = 500,
        ["3423"] = 5000,
        ["3424"] = 125000,
        ["3426"] = 1000,
        ["3427"] = 1500,
        ["3428"] = 100,
        ["3429"] = 586,
        ["3430"] = 11027,
        ["3431"] = 1335,
        ["3434"] = 3,
        ["3435"] = 19,
        ["3437"] = 24,
        ["3439"] = 30,
        ["3440"] = 640,
        ["3442"] = 44,
        ["3443"] = 138,
        ["3444"] = 90,
        ["3445"] = 226,
        ["3446"] = 592,
        ["3447"] = 34,
        ["3448"] = 6,
        ["3449"] = 207,
        ["3450"] = 443,
        ["3451"] = 607,
        ["3452"] = 2322,
        ["3453"] = 46,
        ["3454"] = 105,
        ["3455"] = 188,
        ["3456"] = 6375,
        ["3457"] = 444,
        ["3458"] = 334,
        ["3460"] = 0,
        ["3461"] = 1006,
        ["3462"] = 2283,
        ["3463"] = 9,
        ["3464"] = 8,
        ["3465"] = 9,
        ["3466"] = 500,
        ["3467"] = 0,
        ["3469"] = 49,
        ["3470"] = 5,
        ["3471"] = 142,
        ["3472"] = 71,
        ["3473"] = 299,
        ["3474"] = 216,
        ["3475"] = 21810,
        ["3476"] = 0,
        ["3477"] = 0,
        ["3478"] = 10,
        ["3480"] = 532,
        ["3481"] = 1284,
        ["3482"] = 1317,
        ["3483"] = 965,
        ["3484"] = 1767,
        ["3485"] = 1295,
        ["3486"] = 100,
        ["3487"] = 1498,
        ["3488"] = 613,
        ["3489"] = 937,
        ["3490"] = 2731,
        ["3491"] = 2741,
        ["3492"] = 4552,
        ["3493"] = 3426,
        ["3496"] = 0,
        ["3498"] = 0,
        ["3499"] = 0,
        ["35"] = 9,
        ["3505"] = 0,
        ["3508"] = 0,
        ["3511"] = 267,
        ["3514"] = 0,
        ["3517"] = 0,
        ["3518"] = 0,
        ["3521"] = 0,
        ["3530"] = 28,
        ["3531"] = 57,
        ["3550"] = 0,
        ["3551"] = 0,
        ["3552"] = 0,
        ["3553"] = 0,
        ["3554"] = 0,
        ["3555"] = 1032,
        ["3556"] = 1285,
        ["3558"] = 1044,
        ["3559"] = 473,
        ["3560"] = 2102,
        ["3561"] = 895,
        ["3562"] = 823,
        ["3563"] = 557,
        ["3565"] = 280,
        ["3566"] = 2023,
        ["3567"] = 922,
        ["3569"] = 1262,
        ["3570"] = 839,
        ["3571"] = 2118,
        ["3572"] = 972,
        ["3573"] = 212,
        ["3575"] = 200,
        ["3576"] = 35,
        ["3577"] = 600,
        ["3578"] = 340,
        ["3581"] = 1046,
        ["3582"] = 315,
        ["3583"] = 57,
        ["3585"] = 953,
        ["3586"] = 1034,
        ["3587"] = 2862,
        ["3588"] = 2873,
        ["3589"] = 115,
        ["3590"] = 115,
        ["3591"] = 419,
        ["3592"] = 420,
        ["3593"] = 1095,
        ["3594"] = 1099,
        ["3595"] = 4,
        ["3596"] = 4,
        ["3597"] = 216,
        ["3598"] = 209,
        ["3599"] = 4,
        ["36"] = 7,
        ["3600"] = 4,
        ["3601"] = 0,
        ["3602"] = 29,
        ["3603"] = 29,
        ["3604"] = 500,
        ["3605"] = 500,
        ["3606"] = 29,
        ["3607"] = 29,
        ["3608"] = 500,
        ["3609"] = 25,
        ["3610"] = 50,
        ["3611"] = 500,
        ["3612"] = 500,
        ["3613"] = 0,
        ["3614"] = 0,
        ["3615"] = 0,
        ["3616"] = 0,
        ["3617"] = 0,
        ["3618"] = 0,
        ["3619"] = 0,
        ["3621"] = 0,
        ["3622"] = 0,
        ["3623"] = 0,
        ["3625"] = 0,
        ["3626"] = 0,
        ["3627"] = 0,
        ["3628"] = 0,
        ["3629"] = 0,
        ["3630"] = 0,
        ["3631"] = 0,
        ["3632"] = 0,
        ["3633"] = 0,
        ["3635"] = 0,
        ["3636"] = 0,
        ["3637"] = 0,
        ["3638"] = 0,
        ["3639"] = 0,
        ["3640"] = 0,
        ["3641"] = 15,
        ["3642"] = 22,
        ["3643"] = 71,
        ["3644"] = 47,
        ["3645"] = 189,
        ["3647"] = 434,
        ["3649"] = 115,
        ["3650"] = 68,
        ["3651"] = 435,
        ["3652"] = 364,
        ["3653"] = 438,
        ["3654"] = 367,
        ["3655"] = 1022,
        ["3656"] = 2116,
        ["3657"] = 0,
        ["3658"] = 0,
        ["3659"] = 0,
        ["3660"] = 0,
        ["3661"] = 9,
        ["3662"] = 25,
        ["3663"] = 125,
        ["3664"] = 100,
        ["3665"] = 150,
        ["3666"] = 100,
        ["3667"] = 25,
        ["3668"] = 0,
        ["3669"] = 195,
        ["3670"] = 70,
        ["3671"] = 201,
        ["3672"] = 0,
        ["3673"] = 45,
        ["3674"] = 95,
        ["3676"] = 106,
        ["3678"] = 100,
        ["3679"] = 100,
        ["3680"] = 400,
        ["3681"] = 400,
        ["3682"] = 400,
        ["3683"] = 400,
        ["3684"] = 0,
        ["3685"] = 71,
        ["3688"] = 0,
        ["3689"] = 0,
        ["3690"] = 0,
        ["3691"] = 0,
        ["3692"] = 0,
        ["37"] = 7,
        ["3702"] = 498,
        ["3703"] = 36,
        ["3704"] = 0,
        ["3706"] = 0,
        ["3708"] = 0,
        ["3710"] = 0,
        ["3711"] = 0,
        ["3712"] = 87,
        ["3713"] = 40,
        ["3714"] = 0,
        ["3715"] = 0,
        ["3716"] = 0,
        ["3717"] = 0,
        ["3718"] = 0,
        ["3719"] = 822,
        ["3720"] = 0,
        ["3721"] = 0,
        ["3722"] = 213,
        ["3723"] = 68,
        ["3724"] = 81,
        ["3725"] = 166,
        ["3726"] = 125,
        ["3727"] = 125,
        ["3728"] = 300,
        ["3729"] = 300,
        ["3730"] = 45,
        ["3731"] = 55,
        ["3732"] = 801,
        ["3733"] = 1269,
        ["3734"] = 400,
        ["3735"] = 450,
        ["3736"] = 500,
        ["3737"] = 550,
        ["3739"] = 1250,
        ["3740"] = 2452,
        ["3741"] = 923,
        ["3742"] = 2862,
        ["3743"] = 2451,
        ["3745"] = 0,
        ["3747"] = 1092,
        ["3748"] = 1305,
        ["3749"] = 1320,
        ["3750"] = 2209,
        ["3751"] = 2661,
        ["3752"] = 746,
        ["3753"] = 1635,
        ["3754"] = 1492,
        ["3755"] = 5447,
        ["3758"] = 1817,
        ["3759"] = 1216,
        ["3760"] = 1500,
        ["3761"] = 3306,
        ["3763"] = 6761,
        ["3764"] = 3181,
        ["3765"] = 4811,
        ["3766"] = 30,
        ["3767"] = 23,
        ["3769"] = 13,
        ["3770"] = 25,
        ["3771"] = 50,
        ["3772"] = 0,
        ["3775"] = 13,
        ["3776"] = 175,
        ["3777"] = 10,
        ["3778"] = 1541,
        ["3779"] = 2835,
        ["3780"] = 1877,
        ["3781"] = 3125,
        ["3782"] = 3451,
        ["3783"] = 3048,
        ["3784"] = 4208,
        ["3785"] = 3650,
        ["3786"] = 3957,
        ["3787"] = 4289,
        ["3792"] = 521,
        ["3793"] = 648,
        ["3794"] = 775,
        ["3795"] = 982,
        ["3796"] = 493,
        ["3797"] = 1692,
        ["3798"] = 902,
        ["3799"] = 1461,
        ["38"] = 1,
        ["3800"] = 1068,
        ["3801"] = 1031,
        ["3802"] = 627,
        ["3803"] = 1086,
        ["3804"] = 765,
        ["3805"] = 1049,
        ["3806"] = 1272,
        ["3807"] = 1162,
        ["3808"] = 770,
        ["3809"] = 962,
        ["3810"] = 1145,
        ["3811"] = 1064,
        ["3812"] = 971,
        ["3813"] = 1772,
        ["3814"] = 1891,
        ["3815"] = 1475,
        ["3816"] = 2102,
        ["3817"] = 1585,
        ["3818"] = 125,
        ["3819"] = 100,
        ["3820"] = 100,
        ["3821"] = 150,
        ["3822"] = 6481,
        ["3823"] = 100,
        ["3824"] = 150,
        ["3825"] = 110,
        ["3826"] = 105,
        ["3827"] = 120,
        ["3828"] = 150,
        ["3829"] = 150,
        ["3830"] = 500,
        ["3831"] = 550,
        ["3832"] = 550,
        ["3833"] = 24,
        ["3834"] = 32,
        ["3835"] = 1106,
        ["3836"] = 3053,
        ["3837"] = 4405,
        ["3838"] = 0,
        ["3839"] = 0,
        ["3840"] = 2571,
        ["3841"] = 3106,
        ["3842"] = 2906,
        ["3843"] = 3882,
        ["3844"] = 5658,
        ["3845"] = 6558,
        ["3846"] = 3937,
        ["3847"] = 4977,
        ["3848"] = 1426,
        ["3849"] = 5468,
        ["3850"] = 7304,
        ["3851"] = 6258,
        ["3852"] = 8361,
        ["3853"] = 10153,
        ["3854"] = 14120,
        ["3855"] = 11248,
        ["3856"] = 13633,
        ["3857"] = 125,
        ["3858"] = 250,
        ["3859"] = 60,
        ["3860"] = 400,
        ["3862"] = 0,
        ["3863"] = 0,
        ["3864"] = 800,
        ["3866"] = 1000,
        ["3867"] = 950,
        ["3868"] = 1250,
        ["3869"] = 1250,
        ["3870"] = 750,
        ["3871"] = 850,
        ["3872"] = 800,
        ["3873"] = 1100,
        ["3874"] = 1100,
        ["3875"] = 1250,
        ["3876"] = 0,
        ["3877"] = 0,
        ["3879"] = 0,
        ["3880"] = 0,
        ["3882"] = 13,
        ["3889"] = 1584,
        ["3890"] = 2040,
        ["3891"] = 2457,
        ["3892"] = 4388,
        ["3893"] = 5504,
        ["3894"] = 5997,
        ["3897"] = 0,
        ["3898"] = 0,
        ["3899"] = 25,
        ["39"] = 1,
        ["3900"] = 0,
        ["3901"] = 0,
        ["3902"] = 1317,
        ["3904"] = 0,
        ["3905"] = 0,
        ["3906"] = 0,
        ["3907"] = 0,
        ["3908"] = 0,
        ["3909"] = 0,
        ["3910"] = 0,
        ["3911"] = 0,
        ["3912"] = 0,
        ["3913"] = 0,
        ["3914"] = 6250,
        ["3915"] = 0,
        ["3916"] = 0,
        ["3917"] = 0,
        ["3918"] = 0,
        ["3919"] = 0,
        ["3920"] = 0,
        ["3921"] = 0,
        ["3922"] = 0,
        ["3923"] = 0,
        ["3924"] = 0,
        ["3925"] = 0,
        ["3926"] = 0,
        ["3927"] = 150,
        ["3928"] = 250,
        ["3930"] = 0,
        ["3931"] = 185,
        ["3932"] = 0,
        ["3936"] = 985,
        ["3937"] = 2018,
        ["3938"] = 1189,
        ["3939"] = 2256,
        ["3940"] = 1630,
        ["3941"] = 2598,
        ["3942"] = 2636,
        ["3943"] = 2244,
        ["3944"] = 2277,
        ["3945"] = 3852,
        ["3946"] = 2432,
        ["3947"] = 3258,
        ["3948"] = 3092,
        ["3949"] = 6517,
        ["3950"] = 4157,
        ["3951"] = 5897,
        ["3960"] = 0,
        ["3961"] = 1503,
        ["3962"] = 3080,
        ["3963"] = 1402,
        ["3964"] = 2127,
        ["3965"] = 2221,
        ["3966"] = 2625,
        ["3967"] = 2904,
        ["3968"] = 3331,
        ["3969"] = 3256,
        ["3970"] = 4296,
        ["3971"] = 3811,
        ["3972"] = 3891,
        ["3973"] = 3657,
        ["3974"] = 5487,
        ["3975"] = 3896,
        ["3976"] = 6979,
        ["3985"] = 0,
        ["3986"] = 5332,
        ["3987"] = 6837,
        ["3989"] = 3154,
        ["3990"] = 8237,
        ["3992"] = 3082,
        ["3993"] = 4940,
        ["3994"] = 4404,
        ["3995"] = 4171,
        ["3996"] = 4660,
        ["3997"] = 7929,
        ["3998"] = 5656,
        ["3999"] = 7109,
        ["40"] = 1,
        ["4000"] = 1797,
        ["4001"] = 3170,
        ["4002"] = 2463,
        ["4003"] = 2714,
        ["4004"] = 2357,
        ["4005"] = 3477,
        ["4006"] = 2434,
        ["4007"] = 3261,
        ["4016"] = 0,
        ["4017"] = 6910,
        ["4018"] = 6372,
        ["4019"] = 8336,
        ["4020"] = 11189,
        ["4021"] = 7198,
        ["4022"] = 12059,
        ["4023"] = 6216,
        ["4024"] = 9822,
        ["4025"] = 5070,
        ["4026"] = 4362,
        ["4027"] = 0,
        ["4028"] = 0,
        ["4029"] = 0,
        ["4034"] = 0,
        ["4035"] = 1989,
        ["4036"] = 681,
        ["4037"] = 1821,
        ["4038"] = 3562,
        ["4039"] = 2215,
        ["4040"] = 1347,
        ["4041"] = 3149,
        ["4042"] = 2107,
        ["4043"] = 1958,
        ["4044"] = 4584,
        ["4045"] = 2683,
        ["4046"] = 6783,
        ["4047"] = 3959,
        ["4048"] = 1767,
        ["4049"] = 888,
        ["4050"] = 2375,
        ["4051"] = 1670,
        ["4052"] = 2699,
        ["4053"] = 0,
        ["4054"] = 3626,
        ["4055"] = 2481,
        ["4056"] = 0,
        ["4057"] = 4032,
        ["4058"] = 6056,
        ["4059"] = 2234,
        ["4060"] = 5648,
        ["4061"] = 3306,
        ["4062"] = 8359,
        ["4063"] = 3596,
        ["4064"] = 2987,
        ["4065"] = 5311,
        ["4066"] = 4845,
        ["4067"] = 6381,
        ["4068"] = 6918,
        ["4069"] = 11900,
        ["4070"] = 7527,
        ["4071"] = 2939,
        ["4072"] = 1340,
        ["4073"] = 2230,
        ["4074"] = 4785,
        ["4075"] = 1984,
        ["4076"] = 3301,
        ["4077"] = 3298,
        ["4078"] = 4672,
        ["4079"] = 6753,
        ["4080"] = 7469,
        ["4082"] = 11699,
        ["4083"] = 4328,
        ["4084"] = 10136,
        ["4085"] = 0,
        ["4086"] = 6386,
        ["4087"] = 8722,
        ["4088"] = 18523,
        ["4089"] = 15060,
        ["4090"] = 20736,
        ["4091"] = 22479,
        ["4092"] = 1296,
        ["4093"] = 713,
        ["4094"] = 0,
        ["4096"] = 608,
        ["4097"] = 305,
        ["4098"] = 0,
        ["4099"] = 1131,
        ["4100"] = 23,
        ["4101"] = 26,
        ["4102"] = 33,
        ["4103"] = 0,
        ["4104"] = 0,
        ["4105"] = 0,
        ["4106"] = 0,
        ["4107"] = 2136,
        ["4108"] = 5403,
        ["4109"] = 4393,
        ["4112"] = 4182,
        ["4113"] = 4853,
        ["4114"] = 3866,
        ["4115"] = 5783,
        ["4117"] = 3119,
        ["4118"] = 7313,
        ["4119"] = 7271,
        ["4120"] = 4192,
        ["4121"] = 1380,
        ["4122"] = 8384,
        ["4123"] = 3804,
        ["4124"] = 3991,
        ["4125"] = 3142,
        ["4126"] = 6396,
        ["4127"] = 8073,
        ["4128"] = 14588,
        ["4129"] = 9444,
        ["4130"] = 2171,
        ["4131"] = 3815,
        ["4132"] = 2681,
        ["4133"] = 1794,
        ["4134"] = 22495,
        ["4135"] = 1130,
        ["4136"] = 6022,
        ["4137"] = 4010,
        ["4138"] = 10140,
        ["4139"] = 2749,
        ["414"] = 6,
        ["4140"] = 1875,
        ["4197"] = 2765,
        ["4213"] = 2500,
        ["422"] = 25,
        ["4231"] = 110,
        ["4232"] = 125,
        ["4233"] = 200,
        ["4234"] = 150,
        ["4235"] = 200,
        ["4236"] = 225,
        ["4237"] = 35,
        ["4238"] = 200,
        ["4239"] = 71,
        ["4240"] = 300,
        ["4241"] = 450,
        ["4242"] = 347,
        ["4243"] = 461,
        ["4244"] = 723,
        ["4245"] = 2000,
        ["4246"] = 125,
        ["4247"] = 1049,
        ["4248"] = 791,
        ["4249"] = 703,
        ["4250"] = 705,
        ["4251"] = 1200,
        ["4252"] = 1457,
        ["4253"] = 962,
        ["4254"] = 1071,
        ["4255"] = 2366,
        ["4256"] = 3477,
        ["4257"] = 1311,
        ["4258"] = 1592,
        ["4259"] = 1934,
        ["4260"] = 2559,
        ["4261"] = 32,
        ["4262"] = 2652,
        ["4264"] = 2804,
        ["4265"] = 650,
        ["4278"] = 25,
        ["4289"] = 12,
        ["4290"] = 715,
        ["4291"] = 125,
        ["4292"] = 200,
        ["4293"] = 162,
        ["4294"] = 400,
        ["4296"] = 525,
        ["4297"] = 500,
        ["4298"] = 162,
        ["4299"] = 500,
        ["43"] = 1,
        ["4300"] = 700,
        ["4301"] = 875,
        ["4302"] = 146,
        ["4303"] = 398,
        ["4304"] = 300,
        ["4305"] = 600,
        ["4306"] = 150,
        ["4307"] = 29,
        ["4308"] = 45,
        ["4309"] = 226,
        ["4310"] = 180,
        ["4311"] = 475,
        ["4312"] = 237,
        ["4313"] = 416,
        ["4314"] = 331,
        ["4315"] = 425,
        ["4316"] = 743,
        ["4317"] = 1076,
        ["4318"] = 610,
        ["4319"] = 815,
        ["4320"] = 979,
        ["4321"] = 1120,
        ["4322"] = 1810,
        ["4323"] = 1999,
        ["4324"] = 1874,
        ["4325"] = 2272,
        ["4326"] = 2496,
        ["4327"] = 3788,
        ["4328"] = 1524,
        ["4329"] = 2120,
        ["4330"] = 250,
        ["4331"] = 526,
        ["4332"] = 500,
        ["4333"] = 1200,
        ["4334"] = 550,
        ["4335"] = 1500,
        ["4336"] = 1500,
        ["4337"] = 750,
        ["4338"] = 250,
        ["4339"] = 1250,
        ["4340"] = 87,
        ["4341"] = 125,
        ["4342"] = 625,
        ["4343"] = 60,
        ["4344"] = 11,
        ["4345"] = 100,
        ["4346"] = 100,
        ["4347"] = 150,
        ["4348"] = 175,
        ["4349"] = 175,
        ["4350"] = 200,
        ["4351"] = 225,
        ["4352"] = 275,
        ["4353"] = 300,
        ["4354"] = 350,
        ["4355"] = 375,
        ["4356"] = 375,
        ["4357"] = 4,
        ["4358"] = 30,
        ["4359"] = 12,
        ["4360"] = 60,
        ["4361"] = 120,
        ["4362"] = 187,
        ["4363"] = 50,
        ["4364"] = 12,
        ["4365"] = 75,
        ["4366"] = 75,
        ["4367"] = 150,
        ["4368"] = 408,
        ["4369"] = 1179,
        ["4370"] = 175,
        ["4371"] = 200,
        ["4372"] = 1800,
        ["4373"] = 722,
        ["4374"] = 200,
        ["4375"] = 115,
        ["4376"] = 200,
        ["4377"] = 150,
        ["4378"] = 350,
        ["4379"] = 2357,
        ["4380"] = 500,
        ["4381"] = 600,
        ["4382"] = 600,
        ["4383"] = 3183,
        ["4384"] = 1000,
        ["4385"] = 1410,
        ["4386"] = 175,
        ["4387"] = 400,
        ["4388"] = 600,
        ["4389"] = 750,
        ["4390"] = 500,
        ["4391"] = 4000,
        ["4392"] = 2500,
        ["4393"] = 2632,
        ["4394"] = 750,
        ["4395"] = 1600,
        ["4396"] = 6000,
        ["4397"] = 5000,
        ["4398"] = 900,
        ["4399"] = 50,
        ["44"] = 1,
        ["4400"] = 500,
        ["4401"] = 100,
        ["4402"] = 250,
        ["4403"] = 2000,
        ["4404"] = 25,
        ["4405"] = 125,
        ["4406"] = 600,
        ["4407"] = 1200,
        ["4408"] = 162,
        ["4409"] = 200,
        ["4410"] = 250,
        ["4411"] = 275,
        ["4412"] = 375,
        ["4413"] = 450,
        ["4414"] = 462,
        ["4415"] = 550,
        ["4416"] = 600,
        ["4417"] = 675,
        ["4419"] = 112,
        ["4421"] = 100,
        ["4422"] = 112,
        ["4424"] = 100,
        ["4425"] = 125,
        ["4426"] = 125,
        ["4428"] = 331,
        ["4429"] = 0,
        ["4430"] = 4307,
        ["4432"] = 0,
        ["4433"] = 0,
        ["4434"] = 572,
        ["4435"] = 0,
        ["4436"] = 331,
        ["4437"] = 1855,
        ["4438"] = 1693,
        ["4439"] = 1788,
        ["4440"] = 0,
        ["4443"] = 3472,
        ["4444"] = 1490,
        ["4445"] = 2068,
        ["4446"] = 3594,
        ["4447"] = 901,
        ["4448"] = 1992,
        ["4449"] = 3332,
        ["4450"] = 0,
        ["4453"] = 0,
        ["4454"] = 3800,
        ["4455"] = 3096,
        ["4456"] = 1553,
        ["4457"] = 300,
        ["4458"] = 0,
        ["4459"] = 150,
        ["4460"] = 175,
        ["4461"] = 208,
        ["4462"] = 1425,
        ["4463"] = 953,
        ["4464"] = 2380,
        ["4465"] = 1575,
        ["4466"] = 0,
        ["4467"] = 0,
        ["4468"] = 0,
        ["4469"] = 0,
        ["4470"] = 9,
        ["4471"] = 33,
        ["4472"] = 0,
        ["4473"] = 0,
        ["4474"] = 4207,
        ["4476"] = 2734,
        ["4477"] = 4390,
        ["4478"] = 10176,
        ["4479"] = 178,
        ["4480"] = 185,
        ["4481"] = 176,
        ["4482"] = 0,
        ["4483"] = 0,
        ["4484"] = 0,
        ["4485"] = 0,
        ["4487"] = 0,
        ["4488"] = 0,
        ["4489"] = 0,
        ["4490"] = 0,
        ["4491"] = 0,
        ["4492"] = 0,
        ["4493"] = 0,
        ["4494"] = 0,
        ["4495"] = 0,
        ["4496"] = 125,
        ["4497"] = 5000,
        ["4498"] = 625,
        ["4499"] = 25000,
        ["45"] = 1,
        ["4500"] = 8750,
        ["4502"] = 0,
        ["4503"] = 0,
        ["4504"] = 1475,
        ["4505"] = 1974,
        ["4506"] = 0,
        ["4507"] = 8282,
        ["4508"] = 7793,
        ["4509"] = 2794,
        ["4510"] = 0,
        ["4511"] = 11256,
        ["4512"] = 0,
        ["4513"] = 0,
        ["4514"] = 0,
        ["4515"] = 0,
        ["4516"] = 0,
        ["4517"] = 0,
        ["4518"] = 0,
        ["4519"] = 0,
        ["4520"] = 0,
        ["4521"] = 0,
        ["4522"] = 0,
        ["4525"] = 0,
        ["4526"] = 0,
        ["4527"] = 0,
        ["4528"] = 0,
        ["4529"] = 0,
        ["4531"] = 0,
        ["4532"] = 0,
        ["4533"] = 0,
        ["4534"] = 1173,
        ["4535"] = 882,
        ["4536"] = 1,
        ["4537"] = 6,
        ["4538"] = 25,
        ["4539"] = 50,
        ["4540"] = 1,
        ["4541"] = 6,
        ["4542"] = 25,
        ["4543"] = 4098,
        ["4544"] = 50,
        ["4545"] = 2202,
        ["4546"] = 533,
        ["4547"] = 8319,
        ["4548"] = 15028,
        ["4549"] = 2092,
        ["4550"] = 2092,
        ["4551"] = 0,
        ["4552"] = 530,
        ["4553"] = 411,
        ["4554"] = 708,
        ["4555"] = 155,
        ["4556"] = 903,
        ["4557"] = 225,
        ["4558"] = 1565,
        ["4560"] = 37,
        ["4561"] = 309,
        ["4562"] = 298,
        ["4563"] = 110,
        ["4564"] = 610,
        ["4565"] = 38,
        ["4566"] = 631,
        ["4567"] = 1049,
        ["4568"] = 1695,
        ["4569"] = 612,
        ["4570"] = 922,
        ["4571"] = 979,
        ["4575"] = 1487,
        ["4576"] = 1184,
        ["4577"] = 357,
        ["4580"] = 787,
        ["4581"] = 862,
        ["4582"] = 745,
        ["4583"] = 812,
        ["4584"] = 937,
        ["4585"] = 583,
        ["4586"] = 713,
        ["4587"] = 807,
        ["4588"] = 900,
        ["4589"] = 530,
        ["4590"] = 655,
        ["4591"] = 413,
        ["4592"] = 1,
        ["4593"] = 4,
        ["4594"] = 6,
        ["4595"] = 75,
        ["4596"] = 25,
        ["4597"] = 250,
        ["4598"] = 212,
        ["4599"] = 100,
        ["4600"] = 85,
        ["4601"] = 100,
        ["4602"] = 100,
        ["4603"] = 4,
        ["4604"] = 1,
        ["4605"] = 6,
        ["4606"] = 25,
        ["4607"] = 50,
        ["4608"] = 100,
        ["4609"] = 250,
        ["4610"] = 0,
        ["4611"] = 50,
        ["4612"] = 0,
        ["4614"] = 2,
        ["4615"] = 0,
        ["4616"] = 3,
        ["4621"] = 0,
        ["4622"] = 0,
        ["4623"] = 375,
        ["4624"] = 550,
        ["4625"] = 250,
        ["4626"] = 0,
        ["4627"] = 0,
        ["4628"] = 0,
        ["4629"] = 0,
        ["4630"] = 0,
        ["4631"] = 0,
        ["4632"] = 50,
        ["4633"] = 70,
        ["4634"] = 87,
        ["4635"] = 0,
        ["4636"] = 110,
        ["4637"] = 150,
        ["4638"] = 200,
        ["4639"] = 162,
        ["4640"] = 0,
        ["4641"] = 0,
        ["4643"] = 1824,
        ["4644"] = 0,
        ["4645"] = 0,
        ["4646"] = 0,
        ["4647"] = 0,
        ["4648"] = 0,
        ["4649"] = 0,
        ["4650"] = 0,
        ["4652"] = 10126,
        ["4653"] = 7178,
        ["4654"] = 0,
        ["4655"] = 71,
        ["4656"] = 1,
        ["4658"] = 23,
        ["4659"] = 23,
        ["4660"] = 324,
        ["4661"] = 929,
        ["4662"] = 24,
        ["4663"] = 23,
        ["4665"] = 22,
        ["4666"] = 26,
        ["4668"] = 32,
        ["4669"] = 42,
        ["4671"] = 32,
        ["4672"] = 28,
        ["4674"] = 32,
        ["4675"] = 35,
        ["4676"] = 278,
        ["4677"] = 70,
        ["4678"] = 108,
        ["4680"] = 91,
        ["4681"] = 109,
        ["4683"] = 92,
        ["4684"] = 61,
        ["4686"] = 67,
        ["4687"] = 67,
        ["4689"] = 85,
        ["4690"] = 71,
        ["4692"] = 69,
        ["4693"] = 86,
        ["4694"] = 515,
        ["4695"] = 327,
        ["4696"] = 5537,
        ["4697"] = 435,
        ["4698"] = 301,
        ["4699"] = 221,
        ["47"] = 1,
        ["4700"] = 379,
        ["4701"] = 252,
        ["4702"] = 0,
        ["4703"] = 0,
        ["4705"] = 1449,
        ["4706"] = 687,
        ["4707"] = 881,
        ["4708"] = 462,
        ["4709"] = 982,
        ["4710"] = 561,
        ["4711"] = 1112,
        ["4712"] = 1228,
        ["4713"] = 926,
        ["4714"] = 681,
        ["4715"] = 1026,
        ["4716"] = 1658,
        ["4717"] = 2014,
        ["4718"] = 2223,
        ["4719"] = 1676,
        ["4720"] = 1234,
        ["4721"] = 2809,
        ["4722"] = 1694,
        ["4723"] = 1703,
        ["4724"] = 1763,
        ["4725"] = 4736,
        ["4726"] = 2340,
        ["4727"] = 2791,
        ["4729"] = 3036,
        ["4731"] = 3824,
        ["4732"] = 2632,
        ["4733"] = 7957,
        ["4734"] = 4208,
        ["4735"] = 3621,
        ["4736"] = 2616,
        ["4737"] = 5743,
        ["4738"] = 3294,
        ["4739"] = 0,
        ["4740"] = 0,
        ["4741"] = 5438,
        ["4742"] = 0,
        ["4743"] = 5430,
        ["4744"] = 1986,
        ["4745"] = 3230,
        ["4746"] = 4324,
        ["4751"] = 0,
        ["4752"] = 0,
        ["4753"] = 0,
        ["4755"] = 0,
        ["4757"] = 4,
        ["4758"] = 0,
        ["4759"] = 0,
        ["4765"] = 575,
        ["4766"] = 481,
        ["4767"] = 139,
        ["4768"] = 139,
        ["4769"] = 0,
        ["4770"] = 0,
        ["4771"] = 211,
        ["4772"] = 56,
        ["4775"] = 28,
        ["4776"] = 41,
        ["4777"] = 1408,
        ["4778"] = 1470,
        ["4779"] = 13,
        ["4780"] = 56,
        ["4781"] = 547,
        ["4782"] = 415,
        ["4783"] = 0,
        ["4784"] = 360,
        ["4785"] = 469,
        ["4786"] = 278,
        ["4787"] = 577,
        ["4788"] = 526,
        ["4789"] = 399,
        ["4790"] = 831,
        ["4791"] = 133,
        ["4792"] = 656,
        ["4793"] = 744,
        ["4794"] = 703,
        ["4795"] = 705,
        ["4796"] = 708,
        ["4797"] = 852,
        ["4798"] = 774,
        ["4799"] = 608,
        ["48"] = 1,
        ["4800"] = 1222,
        ["4801"] = 0,
        ["4802"] = 0,
        ["4803"] = 0,
        ["4804"] = 0,
        ["4805"] = 0,
        ["4806"] = 0,
        ["4807"] = 0,
        ["4808"] = 0,
        ["4809"] = 0,
        ["4810"] = 3183,
        ["4813"] = 33,
        ["4814"] = 6,
        ["4816"] = 1503,
        ["4817"] = 2462,
        ["4818"] = 2854,
        ["4819"] = 0,
        ["4820"] = 1664,
        ["4821"] = 1308,
        ["4822"] = 1349,
        ["4823"] = 0,
        ["4824"] = 3371,
        ["4825"] = 4094,
        ["4826"] = 3087,
        ["4827"] = 749,
        ["4828"] = 684,
        ["4829"] = 830,
        ["4830"] = 1895,
        ["4831"] = 1571,
        ["4832"] = 2099,
        ["4833"] = 1731,
        ["4834"] = 0,
        ["4835"] = 2110,
        ["4836"] = 2000,
        ["4837"] = 2000,
        ["4838"] = 2000,
        ["4840"] = 142,
        ["4841"] = 0,
        ["4843"] = 0,
        ["4844"] = 0,
        ["4845"] = 0,
        ["4846"] = 0,
        ["4847"] = 0,
        ["4848"] = 0,
        ["4849"] = 0,
        ["4850"] = 0,
        ["4851"] = 0,
        ["4852"] = 300,
        ["4854"] = 0,
        ["4859"] = 0,
        ["4860"] = 741,
        ["4861"] = 119,
        ["4862"] = 0,
        ["4863"] = 0,
        ["4864"] = 0,
        ["4865"] = 5,
        ["4866"] = 0,
        ["4867"] = 8,
        ["4869"] = 0,
        ["4870"] = 0,
        ["4871"] = 0,
        ["4872"] = 95,
        ["4873"] = 15,
        ["4874"] = 46,
        ["4875"] = 13,
        ["4876"] = 78,
        ["4877"] = 10,
        ["4878"] = 56,
        ["4879"] = 7,
        ["4880"] = 86,
        ["4881"] = 0,
        ["4882"] = 0,
        ["4883"] = 0,
        ["4886"] = 0,
        ["4887"] = 0,
        ["4888"] = 0,
        ["4890"] = 0,
        ["4891"] = 0,
        ["4892"] = 0,
        ["4893"] = 0,
        ["4894"] = 0,
        ["4895"] = 0,
        ["4896"] = 0,
        ["4897"] = 0,
        ["4898"] = 0,
        ["49"] = 1,
        ["4903"] = 0,
        ["4904"] = 0,
        ["4905"] = 0,
        ["4906"] = 22,
        ["4907"] = 13,
        ["4908"] = 6,
        ["4909"] = 369,
        ["4910"] = 7,
        ["4911"] = 15,
        ["4913"] = 7,
        ["4914"] = 6,
        ["4915"] = 7,
        ["4916"] = 9,
        ["4917"] = 14,
        ["4918"] = 0,
        ["4919"] = 5,
        ["4920"] = 7,
        ["4921"] = 12,
        ["4922"] = 15,
        ["4923"] = 25,
        ["4924"] = 25,
        ["4925"] = 26,
        ["4926"] = 0,
        ["4928"] = 20,
        ["4929"] = 58,
        ["4931"] = 134,
        ["4932"] = 179,
        ["4933"] = 32,
        ["4935"] = 23,
        ["4936"] = 23,
        ["4937"] = 71,
        ["4938"] = 236,
        ["4939"] = 395,
        ["4940"] = 36,
        ["4941"] = 11,
        ["4942"] = 89,
        ["4944"] = 72,
        ["4945"] = 37,
        ["4946"] = 67,
        ["4947"] = 325,
        ["4948"] = 326,
        ["4949"] = 1706,
        ["4951"] = 13,
        ["4952"] = 63,
        ["4953"] = 88,
        ["4954"] = 6,
        ["4957"] = 250,
        ["4958"] = 23,
        ["4960"] = 12,
        ["4961"] = 183,
        ["4962"] = 20,
        ["4963"] = 24,
        ["4964"] = 503,
        ["4967"] = 116,
        ["4968"] = 91,
        ["4969"] = 42,
        ["4970"] = 54,
        ["4971"] = 383,
        ["4972"] = 64,
        ["4973"] = 35,
        ["4974"] = 388,
        ["4975"] = 6478,
        ["4976"] = 5486,
        ["4977"] = 11893,
        ["4978"] = 7976,
        ["4979"] = 2587,
        ["4980"] = 2209,
        ["4982"] = 961,
        ["4983"] = 16837,
        ["4984"] = 5630,
        ["4986"] = 0,
        ["4987"] = 15584,
        ["4992"] = 0,
        ["4995"] = 0,
        ["4998"] = 837,
        ["4999"] = 1052,
        ["5001"] = 1038,
        ["5002"] = 1535,
        ["5003"] = 1713,
        ["5006"] = 0,
        ["5007"] = 1632,
        ["5009"] = 1696,
        ["5011"] = 1912,
        ["5012"] = 0,
        ["5016"] = 2955,
        ["5017"] = 0,
        ["5018"] = 0,
        ["5019"] = 0,
        ["5020"] = 3,
        ["5021"] = 0,
        ["5022"] = 0,
        ["5023"] = 0,
        ["5025"] = 0,
        ["5026"] = 0,
        ["5027"] = 0,
        ["5028"] = 5537,
        ["5029"] = 5282,
        ["5030"] = 0,
        ["5038"] = 0,
        ["5040"] = 0,
        ["5042"] = 12,
        ["5043"] = 0,
        ["5044"] = 0,
        ["5048"] = 12,
        ["5050"] = 0,
        ["5051"] = 1,
        ["5052"] = 0,
        ["5054"] = 0,
        ["5055"] = 0,
        ["5056"] = 0,
        ["5057"] = 1,
        ["5058"] = 0,
        ["5059"] = 0,
        ["5060"] = 0,
        ["5061"] = 0,
        ["5062"] = 0,
        ["5063"] = 0,
        ["5064"] = 0,
        ["5065"] = 0,
        ["5066"] = 21,
        ["5067"] = 0,
        ["5068"] = 0,
        ["5069"] = 293,
        ["5071"] = 443,
        ["5072"] = 0,
        ["5073"] = 0,
        ["5074"] = 0,
        ["5075"] = 25,
        ["5076"] = 0,
        ["5077"] = 0,
        ["5078"] = 0,
        ["5079"] = 4642,
        ["5080"] = 0,
        ["5081"] = 250,
        ["5082"] = 25,
        ["5084"] = 0,
        ["5085"] = 0,
        ["5086"] = 0,
        ["5087"] = 0,
        ["5088"] = 0,
        ["5089"] = 0,
        ["5092"] = 240,
        ["5093"] = 247,
        ["5094"] = 233,
        ["5095"] = 3,
        ["5096"] = 0,
        ["5097"] = 0,
        ["5098"] = 0,
        ["5099"] = 0,
        ["51"] = 1,
        ["5100"] = 0,
        ["5101"] = 0,
        ["5102"] = 0,
        ["5103"] = 0,
        ["5104"] = 0,
        ["5107"] = 139,
        ["5109"] = 223,
        ["5110"] = 257,
        ["5111"] = 212,
        ["5112"] = 730,
        ["5113"] = 250,
        ["5114"] = 96,
        ["5115"] = 101,
        ["5116"] = 303,
        ["5117"] = 825,
        ["5118"] = 71,
        ["5119"] = 118,
        ["5120"] = 193,
        ["5121"] = 162,
        ["5122"] = 287,
        ["5123"] = 117,
        ["5124"] = 117,
        ["5125"] = 155,
        ["5128"] = 202,
        ["5133"] = 300,
        ["5134"] = 92,
        ["5135"] = 142,
        ["5136"] = 177,
        ["5137"] = 217,
        ["5138"] = 0,
        ["5140"] = 6,
        ["5143"] = 0,
        ["5164"] = 0,
        ["5165"] = 0,
        ["5166"] = 0,
        ["5167"] = 0,
        ["5168"] = 0,
        ["5169"] = 0,
        ["5170"] = 0,
        ["5173"] = 25,
        ["5175"] = 0,
        ["5176"] = 0,
        ["5177"] = 0,
        ["5178"] = 0,
        ["5179"] = 0,
        ["5180"] = 2777,
        ["5181"] = 1778,
        ["5182"] = 1769,
        ["5183"] = 1575,
        ["5184"] = 0,
        ["5185"] = 0,
        ["5186"] = 0,
        ["5187"] = 1081,
        ["5188"] = 0,
        ["5189"] = 0,
        ["5191"] = 2964,
        ["5192"] = 1803,
        ["5193"] = 940,
        ["5194"] = 3079,
        ["5195"] = 364,
        ["5196"] = 1830,
        ["5197"] = 1598,
        ["5198"] = 1660,
        ["5199"] = 805,
        ["52"] = 1,
        ["5200"] = 2323,
        ["5201"] = 3161,
        ["5202"] = 1147,
        ["5203"] = 0,
        ["5204"] = 0,
        ["5205"] = 31,
        ["5206"] = 37,
        ["5207"] = 1081,
        ["5208"] = 668,
        ["5209"] = 771,
        ["5210"] = 1161,
        ["5211"] = 1166,
        ["5212"] = 672,
        ["5213"] = 5218,
        ["5214"] = 3935,
        ["5215"] = 8656,
        ["5216"] = 11821,
        ["5217"] = 0,
        ["5218"] = 0,
        ["5219"] = 0,
        ["5221"] = 0,
        ["5232"] = 0,
        ["5233"] = 0,
        ["5234"] = 0,
        ["5236"] = 2878,
        ["5237"] = 18,
        ["5238"] = 7145,
        ["5239"] = 7746,
        ["5240"] = 1244,
        ["5241"] = 820,
        ["5242"] = 623,
        ["5243"] = 1312,
        ["5244"] = 3465,
        ["5245"] = 5091,
        ["5246"] = 3490,
        ["5247"] = 7961,
        ["5248"] = 6849,
        ["5249"] = 8658,
        ["5250"] = 2646,
        ["5251"] = 0,
        ["5252"] = 1175,
        ["5253"] = 7952,
        ["5254"] = 309,
        ["5256"] = 7227,
        ["5257"] = 3159,
        ["5263"] = 1,
        ["5266"] = 11157,
        ["5267"] = 53869,
        ["5268"] = 218,
        ["5269"] = 95,
        ["5270"] = 0,
        ["5271"] = 0,
        ["5272"] = 0,
        ["5273"] = 0,
        ["5274"] = 1003,
        ["5275"] = 176,
        ["5279"] = 1437,
        ["5299"] = 359,
        ["53"] = 1,
        ["5302"] = 929,
        ["5306"] = 1710,
        ["5309"] = 1038,
        ["5310"] = 555,
        ["5311"] = 601,
        ["5312"] = 420,
        ["5313"] = 650,
        ["5314"] = 423,
        ["5315"] = 214,
        ["5316"] = 1355,
        ["5317"] = 1360,
        ["5318"] = 1789,
        ["5319"] = 323,
        ["5320"] = 372,
        ["5321"] = 1484,
        ["5322"] = 4016,
        ["5323"] = 1632,
        ["5324"] = 776,
        ["5325"] = 498,
        ["5326"] = 776,
        ["5327"] = 519,
        ["5328"] = 205,
        ["5329"] = 15,
        ["5334"] = 0,
        ["5335"] = 0,
        ["5336"] = 0,
        ["5337"] = 167,
        ["5338"] = 0,
        ["5339"] = 0,
        ["5340"] = 919,
        ["5341"] = 369,
        ["5342"] = 88,
        ["5343"] = 306,
        ["5344"] = 562,
        ["5345"] = 705,
        ["5346"] = 425,
        ["5347"] = 3142,
        ["5348"] = 0,
        ["5349"] = 0,
        ["5350"] = 0,
        ["5351"] = 403,
        ["5352"] = 0,
        ["5354"] = 0,
        ["5355"] = 947,
        ["5356"] = 2594,
        ["5357"] = 2221,
        ["5359"] = 0,
        ["5360"] = 0,
        ["5362"] = 18,
        ["5363"] = 20,
        ["5364"] = 27,
        ["5366"] = 0,
        ["5367"] = 22,
        ["5368"] = 48,
        ["5369"] = 32,
        ["537"] = 87,
        ["5370"] = 37,
        ["5371"] = 48,
        ["5373"] = 72,
        ["5374"] = 87,
        ["5375"] = 95,
        ["5376"] = 66,
        ["5377"] = 57,
        ["5379"] = 0,
        ["5382"] = 0,
        ["5385"] = 0,
        ["5386"] = 0,
        ["5387"] = 0,
        ["5390"] = 0,
        ["5391"] = 0,
        ["5392"] = 25,
        ["5393"] = 32,
        ["5394"] = 6,
        ["5395"] = 16,
        ["5396"] = 0,
        ["5397"] = 0,
        ["5398"] = 13,
        ["5399"] = 11,
        ["5404"] = 469,
        ["5405"] = 7,
        ["5411"] = 0,
        ["5412"] = 0,
        ["5413"] = 0,
        ["5414"] = 0,
        ["5415"] = 0,
        ["5419"] = 13,
        ["5420"] = 227,
        ["5421"] = 650,
        ["5422"] = 692,
        ["5423"] = 2084,
        ["5424"] = 0,
        ["5425"] = 420,
        ["5426"] = 1686,
        ["5427"] = 147,
        ["5428"] = 322,
        ["5429"] = 137,
        ["5430"] = 277,
        ["5431"] = 155,
        ["5432"] = 330,
        ["5433"] = 138,
        ["5435"] = 272,
        ["5437"] = 0,
        ["5439"] = 25,
        ["5441"] = 250,
        ["5442"] = 0,
        ["5443"] = 1067,
        ["5444"] = 363,
        ["5445"] = 0,
        ["5446"] = 13,
        ["5447"] = 20,
        ["5448"] = 17,
        ["5451"] = 22,
        ["5455"] = 0,
        ["5456"] = 0,
        ["5457"] = 23,
        ["5458"] = 27,
        ["5459"] = 472,
        ["5460"] = 0,
        ["5462"] = 0,
        ["5463"] = 0,
        ["5464"] = 0,
        ["5465"] = 3,
        ["5466"] = 8,
        ["5467"] = 7,
        ["5468"] = 12,
        ["5469"] = 9,
        ["5470"] = 28,
        ["5471"] = 30,
        ["5472"] = 10,
        ["5473"] = 10,
        ["5474"] = 9,
        ["5475"] = 0,
        ["5477"] = 18,
        ["5478"] = 70,
        ["5479"] = 125,
        ["5480"] = 95,
        ["5481"] = 0,
        ["5482"] = 10,
        ["5483"] = 35,
        ["5484"] = 60,
        ["5485"] = 100,
        ["5486"] = 110,
        ["5487"] = 200,
        ["5488"] = 100,
        ["5489"] = 300,
        ["5490"] = 0,
        ["5493"] = 0,
        ["5494"] = 0,
        ["5498"] = 200,
        ["55"] = 1,
        ["5500"] = 750,
        ["5503"] = 16,
        ["5504"] = 22,
        ["5505"] = 0,
        ["5506"] = 71,
        ["5507"] = 600,
        ["5509"] = 0,
        ["5510"] = 0,
        ["5511"] = 0,
        ["5512"] = 0,
        ["5513"] = 0,
        ["5514"] = 0,
        ["5516"] = 317,
        ["5522"] = 0,
        ["5523"] = 15,
        ["5524"] = 21,
        ["5525"] = 20,
        ["5526"] = 75,
        ["5527"] = 95,
        ["5528"] = 200,
        ["5529"] = 125,
        ["5530"] = 125,
        ["5534"] = 0,
        ["5535"] = 0,
        ["5536"] = 0,
        ["5538"] = 0,
        ["5539"] = 0,
        ["5540"] = 2107,
        ["5541"] = 3694,
        ["5542"] = 370,
        ["5543"] = 450,
        ["5544"] = 0,
        ["5547"] = 0,
        ["555"] = 8,
        ["556"] = 106,
        ["5565"] = 1250,
        ["5566"] = 105,
        ["5567"] = 196,
        ["5568"] = 4,
        ["5569"] = 203,
        ["5570"] = 0,
        ["5571"] = 250,
        ["5572"] = 250,
        ["5573"] = 875,
        ["5574"] = 875,
        ["5575"] = 2500,
        ["5576"] = 2500,
        ["5578"] = 300,
        ["5579"] = 32,
        ["5580"] = 25,
        ["5581"] = 32,
        ["5582"] = 0,
        ["5583"] = 0,
        ["5584"] = 0,
        ["5585"] = 0,
        ["5586"] = 26,
        ["5587"] = 512,
        ["5589"] = 41,
        ["5590"] = 36,
        ["5591"] = 54,
        ["5592"] = 54,
        ["5593"] = 116,
        ["5594"] = 0,
        ["5595"] = 235,
        ["5596"] = 141,
        ["56"] = 1,
        ["5601"] = 22,
        ["5602"] = 63,
        ["5604"] = 380,
        ["5605"] = 150,
        ["5606"] = 23,
        ["5608"] = 3463,
        ["5609"] = 447,
        ["5610"] = 208,
        ["5611"] = 452,
        ["5612"] = 72,
        ["5613"] = 2635,
        ["5614"] = 6147,
        ["5615"] = 1776,
        ["5616"] = 22738,
        ["5617"] = 244,
        ["5618"] = 57,
        ["5619"] = 0,
        ["5621"] = 0,
        ["5622"] = 556,
        ["5624"] = 2927,
        ["5626"] = 1717,
        ["5627"] = 1379,
        ["5628"] = 0,
        ["5629"] = 347,
        ["5630"] = 293,
        ["5631"] = 30,
        ["5633"] = 150,
        ["5634"] = 75,
        ["5635"] = 45,
        ["5636"] = 75,
        ["5637"] = 75,
        ["5639"] = 0,
        ["5640"] = 25,
        ["5642"] = 450,
        ["5643"] = 500,
        ["5645"] = 0,
        ["5646"] = 0,
        ["5655"] = 0,
        ["5656"] = 0,
        ["5665"] = 0,
        ["5668"] = 0,
        ["5686"] = 0,
        ["5687"] = 0,
        ["5689"] = 0,
        ["5690"] = 0,
        ["5691"] = 0,
        ["57"] = 1,
        ["5732"] = 0,
        ["5734"] = 0,
        ["5735"] = 0,
        ["5736"] = 0,
        ["5739"] = 2739,
        ["5740"] = 25,
        ["5741"] = 111,
        ["5744"] = 386,
        ["5749"] = 2664,
        ["5750"] = 641,
        ["5751"] = 822,
        ["5752"] = 3109,
        ["5753"] = 1884,
        ["5754"] = 2538,
        ["5755"] = 4127,
        ["5756"] = 10026,
        ["5757"] = 1363,
        ["5758"] = 250,
        ["5759"] = 375,
        ["5760"] = 500,
        ["5761"] = 30,
        ["5762"] = 250,
        ["5763"] = 700,
        ["5764"] = 3000,
        ["5765"] = 4000,
        ["5766"] = 1338,
        ["5767"] = 44,
        ["5770"] = 1807,
        ["5771"] = 50,
        ["5772"] = 125,
        ["5773"] = 250,
        ["5774"] = 275,
        ["5775"] = 350,
        ["5776"] = 30,
        ["5777"] = 30,
        ["5778"] = 30,
        ["5779"] = 30,
        ["5780"] = 260,
        ["5781"] = 576,
        ["5782"] = 3211,
        ["5783"] = 2316,
        ["5784"] = 75,
        ["5785"] = 500,
        ["5786"] = 137,
        ["5787"] = 150,
        ["5788"] = 162,
        ["5789"] = 700,
        ["5790"] = 0,
        ["5791"] = 0,
        ["5792"] = 0,
        ["5793"] = 0,
        ["5794"] = 0,
        ["5795"] = 0,
        ["5796"] = 0,
        ["5797"] = 0,
        ["5798"] = 0,
        ["5799"] = 0,
        ["5800"] = 0,
        ["5801"] = 0,
        ["5802"] = 0,
        ["5803"] = 0,
        ["5804"] = 0,
        ["5805"] = 0,
        ["5806"] = 0,
        ["5807"] = 0,
        ["5808"] = 0,
        ["5810"] = 0,
        ["5811"] = 0,
        ["5812"] = 1129,
        ["5813"] = 7088,
        ["5814"] = 2351,
        ["5815"] = 5871,
        ["5816"] = 405,
        ["5817"] = 3145,
        ["5818"] = 3239,
        ["5819"] = 3201,
        ["5820"] = 1623,
        ["5824"] = 0,
        ["5826"] = 0,
        ["5827"] = 0,
        ["5829"] = 804,
        ["5830"] = 0,
        ["5831"] = 0,
        ["5832"] = 0,
        ["5833"] = 0,
        ["5834"] = 0,
        ["5835"] = 0,
        ["5836"] = 0,
        ["5837"] = 0,
        ["5838"] = 0,
        ["5839"] = 1,
        ["5840"] = 0,
        ["5841"] = 0,
        ["5842"] = 0,
        ["5843"] = 0,
        ["5844"] = 0,
        ["5846"] = 0,
        ["5848"] = 0,
        ["5849"] = 0,
        ["5850"] = 0,
        ["5851"] = 0,
        ["5852"] = 0,
        ["5853"] = 0,
        ["5854"] = 0,
        ["5855"] = 0,
        ["5860"] = 0,
        ["5861"] = 0,
        ["5862"] = 0,
        ["5863"] = 0,
        ["5864"] = 0,
        ["5865"] = 0,
        ["5868"] = 0,
        ["5871"] = 318,
        ["5872"] = 0,
        ["5873"] = 0,
        ["5876"] = 0,
        ["5877"] = 0,
        ["5879"] = 0,
        ["5880"] = 0,
        ["5881"] = 0,
        ["5883"] = 0,
        ["5884"] = 0,
        ["5897"] = 0,
        ["59"] = 1,
        ["5919"] = 0,
        ["5936"] = 20,
        ["5938"] = 0,
        ["5939"] = 20,
        ["5940"] = 153,
        ["5941"] = 115,
        ["5943"] = 840,
        ["5944"] = 331,
        ["5945"] = 0,
        ["5946"] = 0,
        ["5947"] = 0,
        ["5948"] = 0,
        ["5950"] = 0,
        ["5951"] = 41,
        ["5952"] = 0,
        ["5956"] = 3,
        ["5957"] = 40,
        ["5958"] = 829,
        ["5959"] = 0,
        ["5960"] = 0,
        ["5961"] = 1089,
        ["5962"] = 2794,
        ["5963"] = 3151,
        ["5964"] = 2609,
        ["5965"] = 2536,
        ["5966"] = 1374,
        ["5967"] = 209,
        ["5969"] = 625,
        ["5970"] = 418,
        ["5971"] = 909,
        ["5972"] = 375,
        ["5973"] = 162,
        ["5974"] = 350,
        ["5975"] = 532,
        ["5976"] = 2500,
        ["5996"] = 95,
        ["5997"] = 5,
        ["5998"] = 0,
        ["60"] = 12,
        ["6016"] = 0,
        ["6037"] = 1250,
        ["6038"] = 312,
        ["6039"] = 1250,
        ["6040"] = 1649,
        ["6041"] = 1500,
        ["6042"] = 250,
        ["6043"] = 500,
        ["6044"] = 450,
        ["6045"] = 650,
        ["6046"] = 950,
        ["6047"] = 1100,
        ["6048"] = 100,
        ["6049"] = 170,
        ["6050"] = 300,
        ["6051"] = 62,
        ["6052"] = 300,
        ["6053"] = 200,
        ["6054"] = 225,
        ["6055"] = 375,
        ["6056"] = 500,
        ["6057"] = 500,
        ["6058"] = 6,
        ["6059"] = 13,
        ["6060"] = 4,
        ["6061"] = 23,
        ["6062"] = 28,
        ["6063"] = 23,
        ["6064"] = 0,
        ["6065"] = 0,
        ["6067"] = 0,
        ["6068"] = 375,
        ["6069"] = 0,
        ["6070"] = 6,
        ["6071"] = 0,
        ["6072"] = 0,
        ["6073"] = 0,
        ["6074"] = 0,
        ["6076"] = 9,
        ["6077"] = 0,
        ["6078"] = 15,
        ["6079"] = 0,
        ["6080"] = 0,
        ["6081"] = 0,
        ["6082"] = 0,
        ["6083"] = 0,
        ["6084"] = 291,
        ["6085"] = 243,
        ["6086"] = 22,
        ["6087"] = 1728,
        ["6089"] = 24,
        ["6091"] = 0,
        ["6092"] = 421,
        ["6093"] = 4418,
        ["6094"] = 1278,
        ["6095"] = 688,
        ["6096"] = 1,
        ["6097"] = 1,
        ["6098"] = 1,
        ["61"] = 12,
        ["6117"] = 1,
        ["6118"] = 1,
        ["6119"] = 1,
        ["6120"] = 1,
        ["6121"] = 1,
        ["6122"] = 1,
        ["6123"] = 1,
        ["6124"] = 1,
        ["6125"] = 1,
        ["6126"] = 1,
        ["6127"] = 1,
        ["6129"] = 1,
        ["6134"] = 1,
        ["6135"] = 1,
        ["6136"] = 1,
        ["6137"] = 1,
        ["6138"] = 1,
        ["6139"] = 1,
        ["6140"] = 1,
        ["6144"] = 1,
        ["6145"] = 0,
        ["6146"] = 0,
        ["6147"] = 37,
        ["6148"] = 44,
        ["6149"] = 120,
        ["6150"] = 22,
        ["6166"] = 0,
        ["6167"] = 0,
        ["6168"] = 0,
        ["6169"] = 0,
        ["6170"] = 0,
        ["6171"] = 6,
        ["6172"] = 0,
        ["6173"] = 7,
        ["6175"] = 0,
        ["6176"] = 15,
        ["6177"] = 69,
        ["6178"] = 0,
        ["6179"] = 556,
        ["6180"] = 423,
        ["6181"] = 0,
        ["6184"] = 0,
        ["6185"] = 7,
        ["6186"] = 1372,
        ["6187"] = 613,
        ["6188"] = 305,
        ["6189"] = 624,
        ["6190"] = 0,
        ["6191"] = 616,
        ["6193"] = 0,
        ["6194"] = 5308,
        ["6195"] = 416,
        ["6196"] = 0,
        ["6197"] = 929,
        ["6198"] = 1113,
        ["6199"] = 650,
        ["6200"] = 1223,
        ["6201"] = 54,
        ["6202"] = 37,
        ["6203"] = 121,
        ["6204"] = 2065,
        ["6205"] = 922,
        ["6206"] = 555,
        ["6211"] = 450,
        ["6212"] = 0,
        ["6214"] = 595,
        ["6215"] = 602,
        ["6217"] = 24,
        ["6218"] = 24,
        ["6219"] = 144,
        ["6220"] = 4893,
        ["6223"] = 4797,
        ["6226"] = 890,
        ["6238"] = 98,
        ["6239"] = 160,
        ["6240"] = 161,
        ["6241"] = 99,
        ["6242"] = 243,
        ["6245"] = 0,
        ["6246"] = 0,
        ["6247"] = 0,
        ["6248"] = 0,
        ["6249"] = 0,
        ["6250"] = 0,
        ["6251"] = 0,
        ["6252"] = 0,
        ["6253"] = 0,
        ["6256"] = 4,
        ["6257"] = 0,
        ["6258"] = 0,
        ["6259"] = 0,
        ["6260"] = 12,
        ["6261"] = 250,
        ["6263"] = 589,
        ["6264"] = 884,
        ["6265"] = 0,
        ["6266"] = 205,
        ["6267"] = 149,
        ["6268"] = 234,
        ["6269"] = 193,
        ["6270"] = 50,
        ["6271"] = 50,
        ["6272"] = 75,
        ["6274"] = 100,
        ["6275"] = 200,
        ["6282"] = 2244,
        ["6283"] = 0,
        ["6287"] = 0,
        ["6288"] = 0,
        ["6289"] = 1,
        ["6290"] = 1,
        ["6291"] = 1,
        ["6292"] = 8,
        ["6293"] = 33,
        ["6294"] = 10,
        ["6295"] = 12,
        ["6296"] = 28,
        ["6297"] = 7,
        ["6298"] = 130,
        ["6299"] = 1,
        ["6300"] = 443,
        ["6301"] = 20,
        ["6302"] = 628,
        ["6303"] = 1,
        ["6304"] = 25,
        ["6305"] = 25,
        ["6306"] = 25,
        ["6307"] = 1,
        ["6308"] = 2,
        ["6309"] = 100,
        ["6310"] = 150,
        ["6311"] = 187,
        ["6314"] = 1014,
        ["6315"] = 2546,
        ["6316"] = 3,
        ["6317"] = 2,
        ["6318"] = 4803,
        ["6319"] = 803,
        ["6320"] = 2711,
        ["6321"] = 1650,
        ["6323"] = 2611,
        ["6324"] = 1892,
        ["6325"] = 10,
        ["6326"] = 10,
        ["6327"] = 12135,
        ["6328"] = 100,
        ["6329"] = 100,
        ["6330"] = 300,
        ["6331"] = 9466,
        ["6332"] = 1153,
        ["6333"] = 1929,
        ["6335"] = 1581,
        ["6336"] = 305,
        ["6337"] = 245,
        ["6338"] = 125,
        ["6339"] = 24,
        ["6340"] = 1050,
        ["6341"] = 666,
        ["6342"] = 75,
        ["6344"] = 100,
        ["6346"] = 100,
        ["6347"] = 100,
        ["6348"] = 125,
        ["6349"] = 125,
        ["6350"] = 295,
        ["6351"] = 1,
        ["6352"] = 1,
        ["6354"] = 1,
        ["6355"] = 1,
        ["6357"] = 1,
        ["6358"] = 4,
        ["6359"] = 5,
        ["6360"] = 2581,
        ["6361"] = 2,
        ["6362"] = 4,
        ["6363"] = 250,
        ["6365"] = 180,
        ["6367"] = 3378,
        ["6368"] = 100,
        ["6369"] = 550,
        ["6370"] = 10,
        ["6371"] = 12,
        ["6372"] = 35,
        ["6373"] = 35,
        ["6375"] = 250,
        ["6377"] = 250,
        ["6378"] = 292,
        ["6379"] = 244,
        ["6380"] = 654,
        ["6381"] = 625,
        ["6382"] = 523,
        ["6383"] = 1519,
        ["6384"] = 250,
        ["6385"] = 250,
        ["6386"] = 2692,
        ["6387"] = 1228,
        ["6388"] = 2043,
        ["6389"] = 2245,
        ["6390"] = 150,
        ["6391"] = 150,
        ["6392"] = 1000,
        ["6393"] = 760,
        ["6394"] = 1041,
        ["6395"] = 1264,
        ["6396"] = 2814,
        ["6397"] = 986,
        ["6398"] = 989,
        ["6399"] = 1639,
        ["6400"] = 3089,
        ["6401"] = 275,
        ["6402"] = 4699,
        ["6403"] = 1772,
        ["6404"] = 3242,
        ["6405"] = 3168,
        ["6406"] = 1970,
        ["6407"] = 1198,
        ["6408"] = 1654,
        ["6409"] = 1660,
        ["6410"] = 1515,
        ["6411"] = 7268,
        ["6412"] = 4711,
        ["6413"] = 2497,
        ["6414"] = 2055,
        ["6415"] = 4565,
        ["6416"] = 2728,
        ["6417"] = 2536,
        ["6418"] = 1697,
        ["6419"] = 2299,
        ["6420"] = 3739,
        ["6421"] = 2317,
        ["6422"] = 3768,
        ["6423"] = 7233,
        ["6424"] = 3825,
        ["6425"] = 4478,
        ["6426"] = 4162,
        ["6427"] = 7016,
        ["6428"] = 2795,
        ["6429"] = 4544,
        ["6430"] = 9098,
        ["6431"] = 5436,
        ["6432"] = 3741,
        ["6433"] = 4953,
        ["6435"] = 0,
        ["6436"] = 0,
        ["6438"] = 362,
        ["6439"] = 237,
        ["6440"] = 15812,
        ["6441"] = 0,
        ["6442"] = 0,
        ["6443"] = 0,
        ["6444"] = 228,
        ["6445"] = 88,
        ["6446"] = 532,
        ["6447"] = 562,
        ["6448"] = 1942,
        ["6449"] = 701,
        ["6450"] = 200,
        ["6451"] = 400,
        ["6452"] = 28,
        ["6453"] = 62,
        ["6454"] = 225,
        ["6456"] = 3,
        ["6457"] = 4,
        ["6458"] = 1,
        ["6459"] = 935,
        ["6460"] = 844,
        ["6461"] = 1190,
        ["6462"] = 0,
        ["6463"] = 1527,
        ["6464"] = 0,
        ["6465"] = 768,
        ["6466"] = 330,
        ["6467"] = 420,
        ["6468"] = 658,
        ["6469"] = 2240,
        ["647"] = 70024,
        ["6470"] = 20,
        ["6471"] = 500,
        ["6472"] = 3018,
        ["6473"] = 1010,
        ["6474"] = 137,
        ["6475"] = 375,
        ["6476"] = 500,
        ["6477"] = 274,
        ["6479"] = 0,
        ["6480"] = 713,
        ["6481"] = 642,
        ["6482"] = 728,
        ["6486"] = 0,
        ["6487"] = 0,
        ["6488"] = 0,
        ["6502"] = 1140,
        ["6503"] = 763,
        ["6504"] = 2933,
        ["6505"] = 3680,
        ["6506"] = 87,
        ["6507"] = 44,
        ["6508"] = 34,
        ["6509"] = 45,
        ["6510"] = 54,
        ["6511"] = 121,
        ["6512"] = 191,
        ["6513"] = 28,
        ["6514"] = 42,
        ["6515"] = 37,
        ["6517"] = 35,
        ["6518"] = 70,
        ["6519"] = 36,
        ["6520"] = 33,
        ["6521"] = 47,
        ["6522"] = 4,
        ["6523"] = 284,
        ["6524"] = 574,
        ["6525"] = 1033,
        ["6526"] = 2497,
        ["6527"] = 187,
        ["6528"] = 358,
        ["6529"] = 12,
        ["6530"] = 25,
        ["6531"] = 417,
        ["6532"] = 62,
        ["6533"] = 62,
        ["6534"] = 0,
        ["6536"] = 488,
        ["6537"] = 210,
        ["6538"] = 492,
        ["6539"] = 162,
        ["6540"] = 431,
        ["6541"] = 163,
        ["6542"] = 219,
        ["6543"] = 147,
        ["6545"] = 676,
        ["6546"] = 533,
        ["6547"] = 267,
        ["6548"] = 233,
        ["6549"] = 102,
        ["6550"] = 204,
        ["6551"] = 409,
        ["6552"] = 601,
        ["6553"] = 525,
        ["6554"] = 229,
        ["6555"] = 104,
        ["6556"] = 174,
        ["6557"] = 302,
        ["6558"] = 180,
        ["6559"] = 533,
        ["6560"] = 616,
        ["6561"] = 675,
        ["6562"] = 508,
        ["6563"] = 295,
        ["6564"] = 512,
        ["6565"] = 394,
        ["6566"] = 411,
        ["6567"] = 1036,
        ["6568"] = 920,
        ["6569"] = 1044,
        ["6570"] = 363,
        ["6571"] = 1167,
        ["6572"] = 1323,
        ["6573"] = 938,
        ["6574"] = 568,
        ["6575"] = 431,
        ["6576"] = 572,
        ["6577"] = 649,
        ["6578"] = 1303,
        ["6579"] = 667,
        ["6580"] = 1312,
        ["6581"] = 422,
        ["6582"] = 731,
        ["6583"] = 425,
        ["6584"] = 1416,
        ["6585"] = 446,
        ["6586"] = 505,
        ["6587"] = 1146,
        ["6588"] = 458,
        ["6590"] = 1830,
        ["6591"] = 1007,
        ["6592"] = 2448,
        ["6593"] = 923,
        ["6594"] = 1121,
        ["6595"] = 1125,
        ["6596"] = 2258,
        ["6597"] = 1707,
        ["6598"] = 2426,
        ["6599"] = 2678,
        ["6600"] = 867,
        ["6601"] = 1437,
        ["6602"] = 874,
        ["6603"] = 2335,
        ["6604"] = 960,
        ["6605"] = 971,
        ["6607"] = 2202,
        ["6608"] = 1328,
        ["6609"] = 2148,
        ["6610"] = 2156,
        ["6611"] = 812,
        ["6612"] = 1112,
        ["6613"] = 744,
        ["6614"] = 1120,
        ["6615"] = 824,
        ["6616"] = 2204,
        ["6617"] = 1371,
        ["6622"] = 49863,
        ["6627"] = 2620,
        ["6628"] = 370,
        ["6629"] = 630,
        ["6630"] = 2067,
        ["6631"] = 4053,
        ["6632"] = 426,
        ["6633"] = 2131,
        ["6634"] = 0,
        ["6635"] = 0,
        ["6636"] = 0,
        ["6637"] = 0,
        ["6640"] = 0,
        ["6641"] = 3675,
        ["6642"] = 1880,
        ["6643"] = 6,
        ["6652"] = 0,
        ["6653"] = 0,
        ["6654"] = 0,
        ["6655"] = 0,
        ["6656"] = 0,
        ["6657"] = 5,
        ["6658"] = 0,
        ["6659"] = 541,
        ["6660"] = 36157,
        ["6661"] = 115,
        ["6662"] = 95,
        ["6663"] = 150,
        ["6664"] = 892,
        ["6665"] = 895,
        ["6666"] = 830,
        ["6667"] = 992,
        ["6668"] = 1245,
        ["6669"] = 1378,
        ["6670"] = 1672,
        ["6671"] = 2068,
        ["6672"] = 500,
        ["6675"] = 1049,
        ["6676"] = 2246,
        ["6677"] = 2401,
        ["6678"] = 677,
        ["6679"] = 4853,
        ["6681"] = 3124,
        ["6682"] = 1901,
        ["6684"] = 0,
        ["6685"] = 1311,
        ["6686"] = 2627,
        ["6687"] = 9930,
        ["6688"] = 2059,
        ["6689"] = 8267,
        ["6690"] = 3346,
        ["6691"] = 8866,
        ["6692"] = 9788,
        ["6693"] = 1816,
        ["6694"] = 6309,
        ["6695"] = 3002,
        ["6696"] = 5086,
        ["6697"] = 2041,
        ["6709"] = 545,
        ["6710"] = 137,
        ["6712"] = 12,
        ["6713"] = 10,
        ["6714"] = 75,
        ["6715"] = 21,
        ["6716"] = 200,
        ["6719"] = 1097,
        ["6720"] = 3219,
        ["6721"] = 1419,
        ["6722"] = 1331,
        ["6723"] = 8155,
        ["6725"] = 6105,
        ["6726"] = 2388,
        ["6727"] = 2996,
        ["6729"] = 7187,
        ["6731"] = 871,
        ["6732"] = 2421,
        ["6735"] = 150,
        ["6737"] = 2805,
        ["6738"] = 7040,
        ["6739"] = 2991,
        ["6740"] = 1001,
        ["6741"] = 3014,
        ["6742"] = 2830,
        ["6743"] = 1462,
        ["6744"] = 1190,
        ["6745"] = 1791,
        ["6746"] = 7076,
        ["6747"] = 5015,
        ["6748"] = 897,
        ["6749"] = 897,
        ["6750"] = 897,
        ["6751"] = 1411,
        ["6752"] = 1602,
        ["6753"] = 0,
        ["6755"] = 0,
        ["6756"] = 1375,
        ["6757"] = 4630,
        ["6766"] = 0,
        ["6767"] = 0,
        ["6773"] = 7366,
        ["6774"] = 2885,
        ["6776"] = 0,
        ["6780"] = 1560,
        ["6784"] = 2032,
        ["6785"] = 0,
        ["6786"] = 59,
        ["6787"] = 466,
        ["6788"] = 3331,
        ["6789"] = 4012,
        ["6790"] = 1540,
        ["6791"] = 3464,
        ["6792"] = 4738,
        ["6793"] = 3062,
        ["6794"] = 2641,
        ["6795"] = 500,
        ["6796"] = 750,
        ["6797"] = 6362,
        ["6798"] = 6386,
        ["6799"] = 0,
        ["6800"] = 0,
        ["6801"] = 4456,
        ["6802"] = 18255,
        ["6803"] = 4885,
        ["6804"] = 11262,
        ["6806"] = 8508,
        ["6807"] = 62,
        ["6810"] = 0,
        ["6811"] = 25,
        ["6826"] = 548,
        ["6827"] = 150,
        ["6828"] = 6268,
        ["6829"] = 18714,
        ["6830"] = 23476,
        ["6831"] = 17522,
        ["6832"] = 3770,
        ["6833"] = 500,
        ["6835"] = 504,
        ["6842"] = 0,
        ["6843"] = 0,
        ["6847"] = 0,
        ["6851"] = 0,
        ["6866"] = 0,
        ["6887"] = 5,
        ["6888"] = 10,
        ["6889"] = 4,
        ["6890"] = 6,
        ["6892"] = 62,
        ["6893"] = 0,
        ["6894"] = 0,
        ["6895"] = 0,
        ["6898"] = 4132,
        ["6900"] = 4685,
        ["6901"] = 1523,
        ["6902"] = 877,
        ["6903"] = 1549,
        ["6904"] = 4665,
        ["6905"] = 4010,
        ["6906"] = 1275,
        ["6907"] = 1873,
        ["6908"] = 522,
        ["6909"] = 7155,
        ["6910"] = 2298,
        ["6911"] = 1442,
        ["6912"] = 0,
        ["6913"] = 0,
        ["6916"] = 0,
        ["6928"] = 0,
        ["6929"] = 0,
        ["6930"] = 0,
        ["6931"] = 0,
        ["6947"] = 5,
        ["6948"] = 0,
        ["6949"] = 20,
        ["6950"] = 30,
        ["6951"] = 75,
        ["6952"] = 0,
        ["6953"] = 7459,
        ["6966"] = 693,
        ["6967"] = 696,
        ["6968"] = 698,
        ["6969"] = 701,
        ["6970"] = 906,
        ["6971"] = 2221,
        ["6972"] = 3242,
        ["6973"] = 2465,
        ["6974"] = 1497,
        ["6975"] = 16766,
        ["6976"] = 17264,
        ["6977"] = 17325,
        ["6978"] = 672,
        ["6979"] = 675,
        ["6980"] = 677,
        ["6981"] = 680,
        ["6982"] = 683,
        ["6983"] = 685,
        ["6984"] = 688,
        ["6985"] = 690,
        ["6986"] = 50,
        ["6987"] = 13,
        ["6989"] = 0,
        ["6990"] = 0,
        ["6991"] = 0,
        ["6992"] = 0,
        ["6993"] = 0,
        ["6994"] = 0,
        ["6995"] = 0,
        ["6996"] = 0,
        ["6997"] = 0,
        ["6998"] = 774,
        ["6999"] = 0,
        ["7000"] = 650,
        ["7001"] = 3535,
        ["7002"] = 3028,
        ["7003"] = 981,
        ["7004"] = 985,
        ["7005"] = 16,
        ["7006"] = 0,
        ["7026"] = 22,
        ["7046"] = 1494,
        ["7047"] = 825,
        ["7048"] = 745,
        ["7049"] = 914,
        ["7050"] = 999,
        ["7051"] = 2696,
        ["7052"] = 1488,
        ["7053"] = 2240,
        ["7054"] = 4701,
        ["7055"] = 1504,
        ["7056"] = 2314,
        ["7057"] = 2323,
        ["7058"] = 2052,
        ["7059"] = 2781,
        ["7060"] = 2791,
        ["7061"] = 2017,
        ["7062"] = 2430,
        ["7063"] = 4741,
        ["7064"] = 2569,
        ["7065"] = 2398,
        ["7067"] = 400,
        ["7068"] = 400,
        ["7069"] = 400,
        ["7070"] = 400,
        ["7071"] = 100,
        ["7072"] = 150,
        ["7073"] = 6,
        ["7074"] = 4,
        ["7075"] = 400,
        ["7076"] = 400,
        ["7077"] = 400,
        ["7078"] = 400,
        ["7079"] = 400,
        ["7080"] = 400,
        ["7081"] = 400,
        ["7082"] = 400,
        ["7083"] = 0,
        ["7084"] = 350,
        ["7085"] = 350,
        ["7086"] = 375,
        ["7087"] = 300,
        ["7088"] = 1250,
        ["7089"] = 375,
        ["7090"] = 250,
        ["7091"] = 250,
        ["7092"] = 250,
        ["7094"] = 174,
        ["7095"] = 32,
        ["7096"] = 5,
        ["7097"] = 1,
        ["7098"] = 6,
        ["7099"] = 6,
        ["710"] = 72,
        ["7100"] = 7,
        ["7101"] = 5,
        ["7106"] = 1234,
        ["7107"] = 1858,
        ["7108"] = 209,
        ["7109"] = 74,
        ["711"] = 5,
        ["7110"] = 2070,
        ["7111"] = 3329,
        ["7112"] = 4547,
        ["7113"] = 6707,
        ["7114"] = 250,
        ["7115"] = 683,
        ["7116"] = 685,
        ["7117"] = 688,
        ["7118"] = 690,
        ["7120"] = 896,
        ["7126"] = 0,
        ["7129"] = 1546,
        ["7130"] = 2328,
        ["7132"] = 2338,
        ["7133"] = 3098,
        ["7135"] = 0,
        ["714"] = 6,
        ["7146"] = 0,
        ["7148"] = 21,
        ["7166"] = 194,
        ["718"] = 322,
        ["7189"] = 4712,
        ["719"] = 4,
        ["7190"] = 0,
        ["7191"] = 0,
        ["720"] = 1070,
        ["7208"] = 0,
        ["7209"] = 0,
        ["7226"] = 0,
        ["7228"] = 25,
        ["7229"] = 285,
        ["723"] = 15,
        ["7230"] = 3103,
        ["724"] = 25,
        ["7247"] = 0,
        ["7249"] = 0,
        ["725"] = 0,
        ["727"] = 245,
        ["7273"] = 0,
        ["7276"] = 34,
        ["7277"] = 28,
        ["7278"] = 25,
        ["7279"] = 25,
        ["728"] = 50,
        ["7280"] = 162,
        ["7281"] = 85,
        ["7282"] = 599,
        ["7283"] = 415,
        ["7284"] = 586,
        ["7285"] = 589,
        ["7286"] = 25,
        ["7287"] = 100,
        ["7288"] = 125,
        ["7289"] = 162,
        ["729"] = 17,
        ["7290"] = 400,
        ["7291"] = 0,
        ["7292"] = 0,
        ["7295"] = 0,
        ["7296"] = 56,
        ["7297"] = 0,
        ["7298"] = 469,
        ["730"] = 16,
        ["7307"] = 62,
        ["7308"] = 0,
        ["731"] = 27,
        ["732"] = 6,
        ["7326"] = 696,
        ["7327"] = 698,
        ["7328"] = 701,
        ["7329"] = 703,
        ["733"] = 100,
        ["7330"] = 3923,
        ["7331"] = 4330,
        ["7332"] = 6692,
        ["7334"] = 1544,
        ["7335"] = 1937,
        ["7336"] = 1509,
        ["7337"] = 250000,
        ["7338"] = 2500,
        ["7339"] = 62500,
        ["7340"] = 125000,
        ["7341"] = 12500,
        ["7342"] = 25000,
        ["7343"] = 0,
        ["7344"] = 5000,
        ["7345"] = 0,
        ["7346"] = 0,
        ["7348"] = 690,
        ["7349"] = 861,
        ["735"] = 0,
        ["7350"] = 29,
        ["7351"] = 58,
        ["7352"] = 1306,
        ["7353"] = 2998,
        ["7354"] = 1865,
        ["7355"] = 1031,
        ["7356"] = 1411,
        ["7357"] = 1875,
        ["7358"] = 885,
        ["7359"] = 978,
        ["7360"] = 400,
        ["7361"] = 450,
        ["7362"] = 500,
        ["7363"] = 525,
        ["7364"] = 550,
        ["7365"] = 0,
        ["7366"] = 1098,
        ["7367"] = 1818,
        ["7368"] = 2677,
        ["7369"] = 2955,
        ["737"] = 0,
        ["7370"] = 1012,
        ["7371"] = 500,
        ["7372"] = 500,
        ["7373"] = 3097,
        ["7374"] = 3760,
        ["7375"] = 3774,
        ["7376"] = 0,
        ["7377"] = 2269,
        ["7378"] = 2146,
        ["738"] = 0,
        ["7386"] = 2387,
        ["7387"] = 2587,
        ["739"] = 0,
        ["7390"] = 4237,
        ["7391"] = 4253,
        ["7392"] = 200,
        ["740"] = 0,
        ["7406"] = 1372,
        ["7407"] = 3666,
        ["7408"] = 2281,
        ["7409"] = 2289,
        ["7410"] = 1174,
        ["7411"] = 1415,
        ["7412"] = 1302,
        ["7413"] = 2157,
        ["7414"] = 3176,
        ["7415"] = 1484,
        ["7416"] = 1442,
        ["7417"] = 2903,
        ["7418"] = 4256,
        ["7419"] = 1326,
        ["742"] = 0,
        ["7420"] = 2658,
        ["7421"] = 1778,
        ["7422"] = 1622,
        ["7423"] = 3941,
        ["7424"] = 2709,
        ["7428"] = 250,
        ["7429"] = 4620,
        ["743"] = 0,
        ["7430"] = 4194,
        ["7431"] = 3899,
        ["7432"] = 2718,
        ["7433"] = 1684,
        ["7434"] = 2536,
        ["7435"] = 2749,
        ["7436"] = 2111,
        ["7437"] = 1554,
        ["7438"] = 1560,
        ["7439"] = 5425,
        ["744"] = 10000,
        ["7440"] = 5042,
        ["7441"] = 3514,
        ["7442"] = 0,
        ["7443"] = 2243,
        ["7444"] = 3377,
        ["7445"] = 3660,
        ["7446"] = 2474,
        ["7447"] = 2068,
        ["7448"] = 2076,
        ["7449"] = 625,
        ["745"] = 0,
        ["7450"] = 500,
        ["7451"] = 700,
        ["7452"] = 875,
        ["7453"] = 875,
        ["7454"] = 5915,
        ["7455"] = 5937,
        ["7456"] = 4139,
        ["7457"] = 2564,
        ["7458"] = 3983,
        ["7459"] = 4317,
        ["7460"] = 2000,
        ["7461"] = 2429,
        ["7462"] = 2682,
        ["7463"] = 6202,
        ["7465"] = 6747,
        ["7468"] = 6763,
        ["7469"] = 6284,
        ["7470"] = 3668,
        ["7471"] = 2455,
        ["7472"] = 3423,
        ["7473"] = 3710,
        ["7474"] = 3281,
        ["7475"] = 2371,
        ["7476"] = 2203,
        ["7477"] = 8125,
        ["7478"] = 6991,
        ["7479"] = 4873,
        ["748"] = 0,
        ["7480"] = 3019,
        ["7481"] = 4908,
        ["7482"] = 4926,
        ["7483"] = 3390,
        ["7484"] = 3062,
        ["7485"] = 3073,
        ["7486"] = 9325,
        ["7487"] = 8665,
        ["7488"] = 6038,
        ["7489"] = 3740,
        ["7490"] = 5680,
        ["7491"] = 6158,
        ["7492"] = 3015,
        ["7493"] = 3268,
        ["7494"] = 3543,
        ["7495"] = 9558,
        ["7496"] = 8882,
        ["7498"] = 0,
        ["7499"] = 0,
        ["750"] = 0,
        ["7500"] = 0,
        ["7506"] = 500,
        ["7507"] = 400,
        ["7508"] = 400,
        ["7509"] = 553,
        ["7510"] = 556,
        ["7511"] = 1938,
        ["7512"] = 1945,
        ["7513"] = 9805,
        ["7514"] = 9842,
        ["7515"] = 5382,
        ["7516"] = 0,
        ["7517"] = 9372,
        ["7518"] = 9406,
        ["7519"] = 7635,
        ["752"] = 0,
        ["7520"] = 5747,
        ["7521"] = 3560,
        ["7522"] = 4963,
        ["7523"] = 4993,
        ["7524"] = 4297,
        ["7525"] = 3106,
        ["7526"] = 3367,
        ["7527"] = 11284,
        ["7528"] = 9894,
        ["7529"] = 6897,
        ["753"] = 3842,
        ["7530"] = 4273,
        ["7531"] = 6434,
        ["7532"] = 6975,
        ["7533"] = 4446,
        ["7534"] = 4016,
        ["7535"] = 4353,
        ["7536"] = 13048,
        ["7537"] = 14012,
        ["7538"] = 12322,
        ["7539"] = 12692,
        ["754"] = 23556,
        ["7540"] = 8845,
        ["7541"] = 5479,
        ["7542"] = 8284,
        ["7543"] = 8123,
        ["7544"] = 4296,
        ["7545"] = 4658,
        ["7546"] = 5050,
        ["755"] = 1,
        ["7552"] = 2542,
        ["7553"] = 2542,
        ["7554"] = 1039,
        ["7555"] = 7123,
        ["7556"] = 5387,
        ["7557"] = 7596,
        ["7558"] = 1609,
        ["7559"] = 666,
        ["756"] = 4963,
        ["7560"] = 300,
        ["7561"] = 500,
        ["7566"] = 0,
        ["7567"] = 0,
        ["7568"] = 0,
        ["7569"] = 0,
        ["7586"] = 0,
        ["7606"] = 557,
        ["7607"] = 1355,
        ["7608"] = 1106,
        ["7609"] = 4210,
        ["7610"] = 5811,
        ["7611"] = 7364,
        ["7613"] = 500,
        ["7626"] = 0,
        ["7627"] = 0,
        ["7628"] = 0,
        ["7629"] = 0,
        ["763"] = 58,
        ["7646"] = 0,
        ["765"] = 10,
        ["766"] = 57,
        ["7666"] = 0,
        ["7667"] = 0,
        ["7668"] = 0,
        ["7669"] = 0,
        ["767"] = 100,
        ["7670"] = 0,
        ["7671"] = 0,
        ["7672"] = 0,
        ["7673"] = 8990,
        ["7674"] = 0,
        ["7676"] = 30,
        ["7678"] = 50,
        ["768"] = 113,
        ["7682"] = 7678,
        ["7683"] = 3958,
        ["7684"] = 2184,
        ["7685"] = 5468,
        ["7686"] = 4308,
        ["7687"] = 8836,
        ["7688"] = 5320,
        ["7689"] = 11124,
        ["769"] = 3,
        ["7690"] = 2232,
        ["7691"] = 2689,
        ["770"] = 316,
        ["7708"] = 6649,
        ["7709"] = 3559,
        ["771"] = 38,
        ["7710"] = 12279,
        ["7711"] = 1171,
        ["7712"] = 881,
        ["7713"] = 4777,
        ["7714"] = 3835,
        ["7715"] = 0,
        ["7717"] = 18923,
        ["7718"] = 6867,
        ["7719"] = 6863,
        ["772"] = 0,
        ["7720"] = 5356,
        ["7721"] = 17922,
        ["7722"] = 9295,
        ["7723"] = 22567,
        ["7724"] = 5436,
        ["7726"] = 11681,
        ["7727"] = 2488,
        ["7728"] = 3223,
        ["7729"] = 5514,
        ["773"] = 0,
        ["7730"] = 10146,
        ["7731"] = 3482,
        ["7733"] = 0,
        ["7734"] = 15495,
        ["7736"] = 11971,
        ["7738"] = 211,
        ["7739"] = 480,
        ["774"] = 15,
        ["7740"] = 0,
        ["7741"] = 0,
        ["7742"] = 600,
        ["7746"] = 8430,
        ["7747"] = 7754,
        ["7749"] = 4885,
        ["7750"] = 1712,
        ["7751"] = 1614,
        ["7752"] = 6903,
        ["7753"] = 7874,
        ["7754"] = 1959,
        ["7755"] = 4140,
        ["7756"] = 1606,
        ["7757"] = 12875,
        ["7758"] = 15074,
        ["7759"] = 6724,
        ["776"] = 5765,
        ["7760"] = 6074,
        ["7761"] = 11290,
        ["7766"] = 0,
        ["7767"] = 0,
        ["7768"] = 0,
        ["7769"] = 0,
        ["777"] = 21,
        ["7770"] = 0,
        ["7771"] = 0,
        ["778"] = 44,
        ["7786"] = 5605,
        ["7787"] = 3960,
        ["779"] = 18,
        ["780"] = 0,
        ["7808"] = 10,
        ["7809"] = 1024,
        ["781"] = 110,
        ["7810"] = 0,
        ["7811"] = 0,
        ["7812"] = 0,
        ["7813"] = 0,
        ["782"] = 0,
        ["783"] = 50,
        ["7846"] = 0,
        ["7847"] = 0,
        ["7848"] = 0,
        ["785"] = 20,
        ["7866"] = 0,
        ["7867"] = 0,
        ["787"] = 1,
        ["7870"] = 0,
        ["7871"] = 0,
        ["7886"] = 0,
        ["7887"] = 0,
        ["7888"] = 8990,
        ["789"] = 1969,
        ["79"] = 10,
        ["790"] = 2020,
        ["7907"] = 0,
        ["7908"] = 0,
        ["7909"] = 1000,
        ["791"] = 7069,
        ["7910"] = 5000,
        ["7911"] = 500,
        ["7912"] = 100,
        ["7913"] = 2500,
        ["7914"] = 3331,
        ["7915"] = 3337,
        ["7916"] = 3700,
        ["7917"] = 2711,
        ["7918"] = 6466,
        ["7919"] = 4359,
        ["792"] = 41,
        ["7920"] = 8053,
        ["7921"] = 9427,
        ["7922"] = 4152,
        ["7923"] = 0,
        ["7924"] = 4103,
        ["7926"] = 10416,
        ["7927"] = 2987,
        ["7928"] = 8484,
        ["7929"] = 7739,
        ["793"] = 27,
        ["7930"] = 12330,
        ["7931"] = 7955,
        ["7932"] = 8463,
        ["7933"] = 10077,
        ["7934"] = 10114,
        ["7935"] = 8368,
        ["7936"] = 11771,
        ["7937"] = 11813,
        ["7938"] = 7090,
        ["7939"] = 19074,
        ["794"] = 56,
        ["7941"] = 12520,
        ["7942"] = 14659,
        ["7943"] = 15892,
        ["7944"] = 20092,
        ["7945"] = 17291,
        ["7946"] = 21660,
        ["7947"] = 24892,
        ["795"] = 56,
        ["7954"] = 23160,
        ["7955"] = 241,
        ["7956"] = 1944,
        ["7957"] = 2205,
        ["7958"] = 2435,
        ["7959"] = 33858,
        ["796"] = 52,
        ["7960"] = 38548,
        ["7961"] = 25508,
        ["7963"] = 6488,
        ["7964"] = 40,
        ["7965"] = 40,
        ["7966"] = 200,
        ["7967"] = 250,
        ["7969"] = 250,
        ["797"] = 35,
        ["7970"] = 0,
        ["7971"] = 1000,
        ["7972"] = 400,
        ["7973"] = 46,
        ["7974"] = 50,
        ["7975"] = 1500,
        ["7976"] = 2000,
        ["7978"] = 750,
        ["7979"] = 750,
        ["798"] = 71,
        ["7989"] = 2500,
        ["799"] = 71,
        ["7990"] = 2500,
        ["7991"] = 2500,
        ["7992"] = 2000,
        ["7993"] = 2500,
        ["7995"] = 1500,
        ["7997"] = 81,
        ["80"] = 7,
        ["8006"] = 12472,
        ["8007"] = 0,
        ["8008"] = 0,
        ["8009"] = 0,
        ["8026"] = 0,
        ["8027"] = 0,
        ["8028"] = 2500,
        ["8029"] = 2000,
        ["8030"] = 2500,
        ["804"] = 2500,
        ["8046"] = 0,
        ["8047"] = 0,
        ["8048"] = 0,
        ["8049"] = 0,
        ["805"] = 250,
        ["8050"] = 0,
        ["8051"] = 0,
        ["8052"] = 0,
        ["8053"] = 0,
        ["8066"] = 0,
        ["8067"] = 0,
        ["8068"] = 0,
        ["8069"] = 0,
        ["8070"] = 0,
        ["8071"] = 1534,
        ["8075"] = 0,
        ["8076"] = 0,
        ["8077"] = 0,
        ["8078"] = 0,
        ["8079"] = 0,
        ["8080"] = 10477,
        ["8081"] = 4989,
        ["8082"] = 5570,
        ["8083"] = 3980,
        ["8084"] = 4758,
        ["8085"] = 9194,
        ["8086"] = 6516,
        ["8088"] = 4694,
        ["8089"] = 7015,
        ["809"] = 39125,
        ["8090"] = 4730,
        ["8091"] = 4748,
        ["8092"] = 7095,
        ["8093"] = 9515,
        ["8094"] = 9551,
        ["810"] = 45267,
        ["8106"] = 10438,
        ["8107"] = 5938,
        ["8108"] = 3594,
        ["8109"] = 5012,
        ["811"] = 54123,
        ["8110"] = 3622,
        ["8111"] = 5890,
        ["8112"] = 8436,
        ["8113"] = 9694,
        ["8114"] = 3677,
        ["8115"] = 5980,
        ["8116"] = 4632,
        ["8117"] = 7161,
        ["8118"] = 4436,
        ["8119"] = 12726,
        ["812"] = 57018,
        ["8120"] = 4965,
        ["8121"] = 4843,
        ["8122"] = 7875,
        ["8123"] = 11276,
        ["8124"] = 7932,
        ["8125"] = 6367,
        ["8126"] = 15656,
        ["8127"] = 5937,
        ["8128"] = 6229,
        ["8129"] = 6253,
        ["8130"] = 9459,
        ["8131"] = 10115,
        ["8132"] = 14485,
        ["8133"] = 10517,
        ["8134"] = 15993,
        ["8135"] = 10884,
        ["8136"] = 0,
        ["8137"] = 4940,
        ["8138"] = 13416,
        ["8139"] = 5375,
        ["814"] = 25,
        ["8140"] = 4994,
        ["8141"] = 8058,
        ["8142"] = 8087,
        ["8143"] = 12647,
        ["8144"] = 8796,
        ["8146"] = 500,
        ["8149"] = 0,
        ["8150"] = 250,
        ["8151"] = 250,
        ["8152"] = 500,
        ["8153"] = 5,
        ["8154"] = 250,
        ["8155"] = 0,
        ["8156"] = 3907,
        ["8157"] = 9096,
        ["8158"] = 3936,
        ["8159"] = 3950,
        ["816"] = 305,
        ["8160"] = 5901,
        ["8161"] = 5922,
        ["8162"] = 8575,
        ["8163"] = 6442,
        ["8164"] = 2,
        ["8165"] = 500,
        ["8167"] = 100,
        ["8168"] = 100,
        ["8169"] = 500,
        ["8170"] = 500,
        ["8171"] = 500,
        ["8172"] = 500,
        ["8173"] = 1000,
        ["8174"] = 4131,
        ["8175"] = 5971,
        ["8176"] = 4495,
        ["8177"] = 71,
        ["8178"] = 306,
        ["8179"] = 28,
        ["818"] = 100,
        ["8180"] = 240,
        ["8181"] = 79,
        ["8182"] = 40,
        ["8183"] = 2426,
        ["8184"] = 2947,
        ["8185"] = 10952,
        ["8186"] = 2231,
        ["8187"] = 3477,
        ["8188"] = 6414,
        ["8189"] = 7567,
        ["8190"] = 37286,
        ["8191"] = 7780,
        ["8192"] = 4782,
        ["8193"] = 8708,
        ["8194"] = 13877,
        ["8196"] = 13979,
        ["8197"] = 7158,
        ["8198"] = 4013,
        ["8199"] = 24661,
        ["820"] = 947,
        ["8200"] = 7275,
        ["8201"] = 5350,
        ["8202"] = 9022,
        ["8203"] = 8628,
        ["8204"] = 4676,
        ["8205"] = 4346,
        ["8206"] = 12704,
        ["8207"] = 8978,
        ["8208"] = 10272,
        ["8209"] = 8375,
        ["821"] = 249,
        ["8210"] = 5537,
        ["8211"] = 8002,
        ["8212"] = 11585,
        ["8213"] = 8150,
        ["8214"] = 6230,
        ["8215"] = 7213,
        ["8216"] = 6323,
        ["8217"] = 1000,
        ["8218"] = 1000,
        ["8223"] = 10066,
        ["8224"] = 7655,
        ["8225"] = 9222,
        ["8226"] = 5747,
        ["8244"] = 10000,
        ["8245"] = 12923,
        ["8246"] = 7917,
        ["8247"] = 4997,
        ["8248"] = 7032,
        ["8249"] = 5336,
        ["8250"] = 8034,
        ["8251"] = 12080,
        ["8252"] = 13622,
        ["8253"] = 5107,
        ["8254"] = 8640,
        ["8255"] = 6010,
        ["8256"] = 10261,
        ["8257"] = 6053,
        ["8258"] = 17396,
        ["8259"] = 7315,
        ["826"] = 732,
        ["8260"] = 6938,
        ["8261"] = 10617,
        ["8262"] = 14606,
        ["8263"] = 10373,
        ["8264"] = 7857,
        ["8265"] = 19914,
        ["8266"] = 7468,
        ["8267"] = 8928,
        ["8268"] = 8960,
        ["8269"] = 14362,
        ["827"] = 971,
        ["8270"] = 14351,
        ["8271"] = 20358,
        ["8272"] = 13697,
        ["8273"] = 6290,
        ["8274"] = 17940,
        ["8275"] = 22028,
        ["8276"] = 6867,
        ["8277"] = 6381,
        ["8278"] = 9567,
        ["8279"] = 10371,
        ["828"] = 250,
        ["8280"] = 14881,
        ["8281"] = 10450,
        ["8282"] = 15695,
        ["8283"] = 16550,
        ["8284"] = 10514,
        ["8285"] = 6637,
        ["8286"] = 9427,
        ["8287"] = 7087,
        ["8288"] = 11876,
        ["8289"] = 16688,
        ["829"] = 0,
        ["8290"] = 16982,
        ["8291"] = 6784,
        ["8292"] = 11476,
        ["8293"] = 8542,
        ["8294"] = 12652,
        ["8295"] = 7988,
        ["8296"] = 20145,
        ["8297"] = 9113,
        ["8298"] = 8565,
        ["8299"] = 14353,
        ["8300"] = 20172,
        ["8301"] = 14463,
        ["8302"] = 11060,
        ["8303"] = 25164,
        ["8304"] = 10513,
        ["8305"] = 11743,
        ["8306"] = 11787,
        ["8307"] = 18717,
        ["8308"] = 18703,
        ["8309"] = 25377,
        ["8310"] = 19420,
        ["8311"] = 10287,
        ["8312"] = 25918,
        ["8313"] = 28565,
        ["8314"] = 9405,
        ["8315"] = 8908,
        ["8316"] = 14110,
        ["8317"] = 15013,
        ["8318"] = 22622,
        ["8319"] = 16037,
        ["832"] = 203,
        ["8320"] = 22092,
        ["833"] = 28000,
        ["8343"] = 500,
        ["8344"] = 0,
        ["8345"] = 7421,
        ["8346"] = 5363,
        ["8347"] = 5980,
        ["8348"] = 10819,
        ["8349"] = 14478,
        ["835"] = 23,
        ["8350"] = 1130,
        ["8363"] = 0,
        ["8364"] = 6,
        ["8365"] = 4,
        ["8367"] = 18455,
        ["8368"] = 1000,
        ["837"] = 225,
        ["838"] = 225,
        ["8383"] = 0,
        ["8384"] = 875,
        ["8385"] = 875,
        ["8386"] = 1000,
        ["8387"] = 1000,
        ["8389"] = 1250,
        ["839"] = 113,
        ["8390"] = 1250,
        ["8391"] = 0,
        ["8392"] = 0,
        ["8393"] = 0,
        ["8394"] = 0,
        ["8395"] = 1000,
        ["8396"] = 0,
        ["8397"] = 1000,
        ["8398"] = 1125,
        ["8399"] = 1250,
        ["840"] = 170,
        ["8400"] = 1250,
        ["8401"] = 1375,
        ["8402"] = 1375,
        ["8403"] = 1000,
        ["8404"] = 1000,
        ["8405"] = 1000,
        ["8406"] = 1250,
        ["8407"] = 1250,
        ["8408"] = 1250,
        ["8409"] = 1000,
        ["841"] = 0,
        ["8410"] = 0,
        ["8411"] = 0,
        ["8412"] = 0,
        ["8423"] = 0,
        ["8424"] = 0,
        ["8425"] = 0,
        ["8426"] = 0,
        ["8427"] = 0,
        ["8428"] = 0,
        ["8429"] = 31,
        ["843"] = 215,
        ["8430"] = 46,
        ["8431"] = 0,
        ["8432"] = 0,
        ["844"] = 144,
        ["8443"] = 0,
        ["8444"] = 0,
        ["845"] = 289,
        ["846"] = 290,
        ["8463"] = 0,
        ["847"] = 349,
        ["848"] = 351,
        ["8483"] = 171,
        ["8484"] = 68,
        ["8485"] = 1000,
        ["8486"] = 1000,
        ["8487"] = 1000,
        ["8488"] = 1000,
        ["8489"] = 1500,
        ["849"] = 265,
        ["8490"] = 1500,
        ["8491"] = 1500,
        ["8492"] = 1000,
        ["8494"] = 1000,
        ["8495"] = 1000,
        ["8496"] = 1000,
        ["8497"] = 500,
        ["8498"] = 2500,
        ["8499"] = 2500,
        ["85"] = 12,
        ["850"] = 176,
        ["8500"] = 1250,
        ["8501"] = 1250,
        ["8508"] = 178,
        ["851"] = 404,
        ["852"] = 347,
        ["8523"] = 0,
        ["8524"] = 0,
        ["8526"] = 0,
        ["8527"] = 0,
        ["8528"] = 0,
        ["8529"] = 175,
        ["853"] = 481,
        ["854"] = 604,
        ["8544"] = 400,
        ["8545"] = 600,
        ["8548"] = 0,
        ["856"] = 875,
        ["8563"] = 0,
        ["8564"] = 200,
        ["857"] = 2500,
        ["858"] = 25,
        ["8584"] = 0,
        ["8585"] = 0,
        ["8587"] = 0,
        ["8588"] = 0,
        ["859"] = 87,
        ["8591"] = 0,
        ["8592"] = 0,
        ["8593"] = 0,
        ["8594"] = 0,
        ["8595"] = 25000,
        ["860"] = 89,
        ["8603"] = 0,
        ["862"] = 38222,
        ["8623"] = 0,
        ["8624"] = 250,
        ["8625"] = 250,
        ["8626"] = 250,
        ["8629"] = 0,
        ["863"] = 8964,
        ["8631"] = 0,
        ["8632"] = 0,
        ["864"] = 9716,
        ["8643"] = 2500,
        ["8644"] = 1500,
        ["8645"] = 750,
        ["8647"] = 0,
        ["865"] = 5096,
        ["866"] = 16640,
        ["8663"] = 0,
        ["867"] = 5344,
        ["868"] = 21533,
        ["8683"] = 1,
        ["8684"] = 0,
        ["8687"] = 0,
        ["869"] = 18529,
        ["870"] = 21528,
        ["8703"] = 6492,
        ["8704"] = 0,
        ["8705"] = 0,
        ["8707"] = 0,
        ["8708"] = 0,
        ["871"] = 29628,
        ["872"] = 2011,
        ["8723"] = 0,
        ["8724"] = 0,
        ["873"] = 21770,
        ["8746"] = 682,
        ["8747"] = 1036,
        ["8748"] = 775,
        ["8749"] = 1604,
        ["8750"] = 1863,
        ["8751"] = 2618,
        ["8752"] = 5217,
        ["8753"] = 5198,
        ["8754"] = 3937,
        ["8755"] = 6512,
        ["8766"] = 200,
        ["878"] = 56,
        ["880"] = 2692,
        ["8831"] = 300,
        ["8836"] = 95,
        ["8838"] = 60,
        ["8839"] = 375,
        ["884"] = 0,
        ["8845"] = 375,
        ["8846"] = 250,
        ["885"] = 2301,
        ["886"] = 2949,
        ["887"] = 82,
        ["888"] = 980,
        ["889"] = 0,
        ["890"] = 3517,
        ["892"] = 370,
        ["8923"] = 50,
        ["8924"] = 25,
        ["8925"] = 125,
        ["8926"] = 75,
        ["8927"] = 100,
        ["8928"] = 125,
        ["893"] = 137,
        ["8932"] = 200,
        ["8948"] = 200,
        ["8949"] = 200,
        ["8950"] = 200,
        ["8951"] = 200,
        ["8952"] = 200,
        ["8953"] = 200,
        ["8956"] = 200,
        ["8957"] = 200,
        ["8959"] = 160,
        ["897"] = 1022,
        ["8973"] = 0,
        ["8984"] = 100,
        ["8985"] = 150,
        ["899"] = 1215,
        ["9030"] = 200,
        ["9036"] = 20,
        ["9060"] = 1000,
        ["9061"] = 250,
        ["9088"] = 250,
        ["910"] = 0,
        ["911"] = 3324,
        ["914"] = 2669,
        ["9144"] = 250,
        ["9149"] = 250,
        ["915"] = 0,
        ["9153"] = 0,
        ["9154"] = 300,
        ["9155"] = 400,
        ["916"] = 0,
        ["9172"] = 500,
        ["9173"] = 0,
        ["9179"] = 1000,
        ["918"] = 1250,
        ["9186"] = 175,
        ["9187"] = 600,
        ["9189"] = 0,
        ["9197"] = 600,
        ["920"] = 2821,
        ["9206"] = 700,
        ["921"] = 0,
        ["9210"] = 750,
        ["9214"] = 2500,
        ["922"] = 2407,
        ["9224"] = 700,
        ["923"] = 1748,
        ["9233"] = 500,
        ["9234"] = 0,
        ["9237"] = 0,
        ["9238"] = 0,
        ["924"] = 2194,
        ["9240"] = 0,
        ["9241"] = 0,
        ["9242"] = 2421,
        ["9243"] = 8155,
        ["9244"] = 0,
        ["9245"] = 0,
        ["9246"] = 0,
        ["9247"] = 0,
        ["9248"] = 0,
        ["9249"] = 1553,
        ["925"] = 1559,
        ["9250"] = 0,
        ["9251"] = 62,
        ["9252"] = 62,
        ["9253"] = 62,
        ["9254"] = 0,
        ["9255"] = 0,
        ["9256"] = 0,
        ["9258"] = 0,
        ["9259"] = 64,
        ["926"] = 1957,
        ["9260"] = 400,
        ["9261"] = 250,
        ["9262"] = 1000,
        ["9263"] = 0,
        ["9264"] = 35,
        ["9265"] = 15,
        ["9266"] = 0,
        ["927"] = 1390,
        ["9275"] = 0,
        ["9276"] = 100,
        ["9277"] = 0,
        ["9278"] = 0,
        ["9279"] = 45,
        ["928"] = 1972,
        ["9280"] = 0,
        ["9281"] = 0,
        ["9282"] = 0,
        ["9283"] = 0,
        ["9284"] = 0,
        ["9285"] = 4204,
        ["9286"] = 10571,
        ["9287"] = 4235,
        ["9288"] = 4250,
        ["9289"] = 6350,
        ["929"] = 75,
        ["9290"] = 6883,
        ["9291"] = 9251,
        ["9292"] = 6436,
        ["9293"] = 1250,
        ["9294"] = 2000,
        ["9295"] = 2000,
        ["9296"] = 2000,
        ["9297"] = 2500,
        ["9298"] = 2250,
        ["9299"] = 0,
        ["9300"] = 2500,
        ["9301"] = 2500,
        ["9302"] = 2250,
        ["9303"] = 2000,
        ["9304"] = 2000,
        ["9305"] = 2000,
        ["9306"] = 0,
        ["9307"] = 0,
        ["9308"] = 38,
        ["9309"] = 0,
        ["9311"] = 0,
        ["9312"] = 5,
        ["9313"] = 5,
        ["9314"] = 12,
        ["9315"] = 10,
        ["9316"] = 0,
        ["9317"] = 25,
        ["9318"] = 5,
        ["9319"] = 0,
        ["932"] = 637,
        ["9320"] = 0,
        ["9326"] = 0,
        ["9327"] = 625,
        ["9328"] = 0,
        ["9329"] = 0,
        ["933"] = 2500,
        ["9330"] = 0,
        ["9331"] = 0,
        ["9332"] = 38,
        ["9333"] = 73,
        ["9334"] = 47,
        ["9335"] = 52,
        ["9336"] = 1288,
        ["934"] = 10682,
        ["935"] = 1742,
        ["9355"] = 376,
        ["9356"] = 217,
        ["9357"] = 227,
        ["9358"] = 228,
        ["9359"] = 19577,
        ["936"] = 11620,
        ["9360"] = 400,
        ["9361"] = 400,
        ["9362"] = 1,
        ["9363"] = 12,
        ["9364"] = 0,
        ["9365"] = 0,
        ["9366"] = 3689,
        ["9367"] = 1250,
        ["9368"] = 0,
        ["9369"] = 0,
        ["937"] = 14577,
        ["9372"] = 61936,
        ["9375"] = 4220,
        ["9378"] = 11380,
        ["9379"] = 26383,
        ["938"] = 0,
        ["9381"] = 8628,
        ["9382"] = 3608,
        ["9383"] = 16895,
        ["9384"] = 9789,
        ["9385"] = 12281,
        ["9386"] = 9859,
        ["9387"] = 6006,
        ["9388"] = 3196,
        ["9389"] = 4331,
        ["939"] = 0,
        ["9390"] = 2147,
        ["9391"] = 12831,
        ["9392"] = 12980,
        ["9393"] = 7882,
        ["9394"] = 2397,
        ["9395"] = 1565,
        ["9396"] = 7319,
        ["9397"] = 3672,
        ["9398"] = 1244,
        ["9399"] = 3,
        ["940"] = 12566,
        ["9400"] = 1624,
        ["9401"] = 5070,
        ["9402"] = 25308,
        ["9403"] = 1331,
        ["9404"] = 2819,
        ["9405"] = 2055,
        ["9406"] = 4161,
        ["9407"] = 5094,
        ["9408"] = 18639,
        ["9409"] = 4490,
        ["9410"] = 6662,
        ["9411"] = 7156,
        ["9412"] = 16681,
        ["9413"] = 32249,
        ["9414"] = 8645,
        ["9415"] = 8997,
        ["9416"] = 28218,
        ["9418"] = 32851,
        ["9419"] = 18076,
        ["942"] = 4500,
        ["9420"] = 4083,
        ["9421"] = 0,
        ["9422"] = 13052,
        ["9423"] = 25464,
        ["9424"] = 13594,
        ["9425"] = 21489,
        ["9426"] = 10275,
        ["9427"] = 14853,
        ["9428"] = 2096,
        ["9429"] = 5236,
        ["943"] = 42863,
        ["9430"] = 8553,
        ["9431"] = 4885,
        ["9432"] = 5327,
        ["9433"] = 4133,
        ["9434"] = 5648,
        ["9435"] = 2916,
        ["9437"] = 0,
        ["9438"] = 0,
        ["9439"] = 0,
        ["944"] = 80153,
        ["9440"] = 0,
        ["9441"] = 0,
        ["9442"] = 0,
        ["9444"] = 1120,
        ["9445"] = 2260,
        ["9446"] = 7564,
        ["9447"] = 3237,
        ["9448"] = 1154,
        ["9449"] = 9564,
        ["9450"] = 2181,
        ["9451"] = 25,
        ["9452"] = 8210,
        ["9453"] = 6592,
        ["9454"] = 1984,
        ["9455"] = 1826,
        ["9456"] = 6652,
        ["9457"] = 8902,
        ["9458"] = 6918,
        ["9459"] = 13560,
        ["9460"] = 0,
        ["9461"] = 4586,
        ["9462"] = 0,
        ["9463"] = 0,
        ["9465"] = 18561,
        ["9466"] = 0,
        ["9467"] = 18682,
        ["9468"] = 0,
        ["9469"] = 14634,
        ["9470"] = 7858,
        ["9471"] = 0,
        ["9472"] = 0,
        ["9473"] = 13241,
        ["9474"] = 13290,
        ["9475"] = 33346,
        ["9476"] = 15010,
        ["9477"] = 35936,
        ["9478"] = 28853,
        ["9479"] = 10858,
        ["9480"] = 31725,
        ["9481"] = 34067,
        ["9482"] = 29585,
        ["9483"] = 19139,
        ["9484"] = 10962,
        ["9485"] = 5288,
        ["9486"] = 5483,
        ["9487"] = 3632,
        ["9488"] = 4419,
        ["9489"] = 3690,
        ["9490"] = 6122,
        ["9491"] = 1308,
        ["9492"] = 3172,
        ["9507"] = 0,
        ["9508"] = 2352,
        ["9509"] = 2683,
        ["9510"] = 2945,
        ["9511"] = 21060,
        ["9512"] = 6341,
        ["9513"] = 620,
        ["9514"] = 306,
        ["9515"] = 2011,
        ["9516"] = 2071,
        ["9517"] = 15737,
        ["9518"] = 1900,
        ["9519"] = 2288,
        ["9520"] = 11461,
        ["9521"] = 14382,
        ["9522"] = 4938,
        ["9523"] = 0,
        ["9527"] = 21613,
        ["9528"] = 0,
        ["9530"] = 0,
        ["9531"] = 9195,
        ["9533"] = 7092,
        ["9534"] = 8847,
        ["9535"] = 1406,
        ["9536"] = 1411,
        ["9538"] = 6463,
        ["9539"] = 50,
        ["954"] = 50,
        ["9540"] = 150,
        ["9544"] = 0,
        ["9546"] = 0,
        ["9548"] = 0,
        ["955"] = 37,
        ["9552"] = 0,
        ["9553"] = 0,
        ["9554"] = 0,
        ["9558"] = 0,
        ["9559"] = 0,
        ["9560"] = 0,
        ["9561"] = 0,
        ["9562"] = 0,
        ["9563"] = 0,
        ["9564"] = 0,
        ["9565"] = 0,
        ["9566"] = 0,
        ["9567"] = 0,
        ["9568"] = 0,
        ["957"] = 0,
        ["9573"] = 0,
        ["9574"] = 0,
        ["9575"] = 0,
        ["9576"] = 0,
        ["9577"] = 0,
        ["9580"] = 0,
        ["9581"] = 0,
        ["9587"] = 6250,
        ["9588"] = 6463,
        ["9589"] = 0,
        ["9591"] = 0,
        ["9592"] = 0,
        ["9593"] = 0,
        ["9594"] = 0,
        ["9595"] = 0,
        ["9596"] = 0,
        ["9597"] = 0,
        ["9598"] = 94,
        ["9599"] = 142,
        ["9600"] = 93,
        ["9601"] = 87,
        ["9603"] = 302,
        ["9604"] = 5632,
        ["9605"] = 1356,
        ["9606"] = 0,
        ["9607"] = 1762,
        ["9608"] = 5028,
        ["9609"] = 1009,
        ["961"] = 2,
        ["9618"] = 0,
        ["9619"] = 0,
        ["962"] = 0,
        ["9620"] = 0,
        ["9621"] = 0,
        ["9622"] = 5665,
        ["9623"] = 4198,
        ["9624"] = 5267,
        ["9625"] = 6344,
        ["9626"] = 16243,
        ["9627"] = 2542,
        ["9628"] = 0,
        ["9629"] = 0,
        ["9630"] = 5780,
        ["9631"] = 3868,
        ["9632"] = 3883,
        ["9633"] = 5847,
        ["9634"] = 3381,
        ["9635"] = 4713,
        ["9636"] = 3154,
        ["9637"] = 8296,
        ["9638"] = 6875,
        ["9639"] = 24111,
        ["9640"] = 8519,
        ["9641"] = 13041,
        ["9642"] = 2092,
        ["9643"] = 15988,
        ["9644"] = 9885,
        ["9645"] = 6768,
        ["9646"] = 11863,
        ["9647"] = 7962,
        ["9648"] = 6392,
        ["9650"] = 18016,
        ["9651"] = 26828,
        ["9652"] = 13466,
        ["9653"] = 6745,
        ["9654"] = 16929,
        ["9655"] = 7092,
        ["9656"] = 4251,
        ["9657"] = 5333,
        ["9658"] = 4086,
        ["9660"] = 4227,
        ["9661"] = 9051,
        ["9662"] = 7437,
        ["9663"] = 9969,
        ["9664"] = 8738,
        ["9665"] = 4827,
        ["9666"] = 7266,
        ["9678"] = 17486,
        ["9679"] = 17550,
        ["9680"] = 14090,
        ["9681"] = 50,
        ["9682"] = 3831,
        ["9683"] = 29953,
        ["9684"] = 25729,
        ["9686"] = 25914,
        ["9687"] = 1554,
        ["9698"] = 1504,
        ["9699"] = 1812,
        ["9703"] = 4272,
        ["9704"] = 3573,
        ["9705"] = 3586,
        ["9706"] = 9212,
        ["9718"] = 11421,
        ["9719"] = 6250,
        ["9738"] = 0,
        ["9739"] = 0,
        ["9740"] = 0,
        ["9741"] = 0,
        ["9742"] = 49,
        ["9743"] = 67,
        ["9744"] = 45,
        ["9745"] = 54,
        ["9746"] = 56,
        ["9747"] = 227,
        ["9748"] = 274,
        ["9749"] = 275,
        ["9750"] = 57,
        ["9751"] = 86,
        ["9752"] = 58,
        ["9753"] = 248,
        ["9754"] = 56,
        ["9755"] = 73,
        ["9756"] = 294,
        ["9757"] = 364,
        ["9758"] = 73,
        ["9759"] = 138,
        ["9760"] = 73,
        ["9761"] = 59,
        ["9762"] = 92,
        ["9763"] = 336,
        ["9764"] = 300,
        ["9765"] = 406,
        ["9766"] = 362,
        ["9767"] = 616,
        ["9768"] = 317,
        ["9769"] = 1637,
        ["9770"] = 417,
        ["9771"] = 532,
        ["9772"] = 1328,
        ["9773"] = 1369,
        ["9774"] = 1374,
        ["9775"] = 316,
        ["9776"] = 547,
        ["9777"] = 318,
        ["9778"] = 940,
        ["9779"] = 334,
        ["9780"] = 370,
        ["9781"] = 982,
        ["9782"] = 1113,
        ["9783"] = 812,
        ["9784"] = 533,
        ["9785"] = 269,
        ["9786"] = 234,
        ["9787"] = 358,
        ["9788"] = 312,
        ["9789"] = 742,
        ["9790"] = 794,
        ["9791"] = 1644,
        ["9792"] = 823,
        ["9793"] = 550,
        ["9794"] = 829,
        ["9795"] = 626,
        ["9796"] = 1038,
        ["9797"] = 1528,
        ["9798"] = 1686,
        ["9799"] = 635,
        ["9800"] = 2027,
        ["9801"] = 708,
        ["9802"] = 1205,
        ["9803"] = 729,
        ["9804"] = 1874,
        ["9805"] = 709,
        ["9806"] = 834,
        ["9807"] = 1255,
        ["9808"] = 1848,
        ["9809"] = 1855,
        ["981"] = 0,
        ["9810"] = 1231,
        ["9811"] = 725,
        ["9812"] = 570,
        ["9813"] = 826,
        ["9814"] = 733,
        ["9815"] = 1664,
        ["9816"] = 1781,
        ["9817"] = 1426,
        ["9818"] = 1682,
        ["9819"] = 2726,
        ["9820"] = 1541,
        ["9821"] = 871,
        ["9822"] = 1192,
        ["9823"] = 965,
        ["9824"] = 1599,
        ["9825"] = 2355,
        ["9826"] = 2600,
        ["9827"] = 1114,
        ["9828"] = 1845,
        ["9829"] = 1020,
        ["983"] = 21,
        ["9830"] = 3489,
        ["9831"] = 1233,
        ["9832"] = 1248,
        ["9833"] = 3031,
        ["9834"] = 2074,
        ["9835"] = 3053,
        ["9836"] = 3677,
        ["9837"] = 1287,
        ["9838"] = 1174,
        ["9839"] = 1426,
        ["9840"] = 1432,
        ["9841"] = 3163,
        ["9842"] = 2391,
        ["9843"] = 3739,
        ["9844"] = 3709,
        ["9845"] = 2136,
        ["9846"] = 1429,
        ["9847"] = 1779,
        ["9848"] = 1584,
        ["9849"] = 2385,
        ["9850"] = 2394,
        ["9851"] = 3524,
        ["9852"] = 3820,
        ["9853"] = 1368,
        ["9854"] = 4935,
        ["9855"] = 1895,
        ["9856"] = 2839,
        ["9857"] = 1570,
        ["9858"] = 4882,
        ["9859"] = 2872,
        ["9860"] = 1906,
        ["9861"] = 1753,
        ["9862"] = 4260,
        ["9863"] = 3207,
        ["9864"] = 3527,
        ["9865"] = 1942,
        ["9866"] = 5605,
        ["9867"] = 1779,
        ["9868"] = 2160,
        ["9869"] = 2225,
        ["9870"] = 3686,
        ["9871"] = 5425,
        ["9872"] = 4101,
        ["9873"] = 5828,
        ["9874"] = 5801,
        ["9875"] = 2139,
        ["9876"] = 3146,
        ["9877"] = 2708,
        ["9878"] = 3425,
        ["9879"] = 1964,
        ["9880"] = 2130,
        ["9881"] = 3464,
        ["9882"] = 6209,
        ["9883"] = 5026,
        ["9884"] = 5448,
        ["9885"] = 4180,
        ["9886"] = 2589,
        ["9887"] = 7071,
        ["9889"] = 4240,
        ["9890"] = 2919,
        ["9891"] = 2636,
        ["9892"] = 2857,
        ["9893"] = 6689,
        ["9894"] = 4661,
        ["9895"] = 5221,
        ["9896"] = 2913,
        ["9897"] = 7368,
        ["9898"] = 2718,
        ["9899"] = 7920,
        ["9900"] = 3195,
        ["9901"] = 3295,
        ["9902"] = 5357,
        ["9903"] = 7743,
        ["9904"] = 5420,
        ["9905"] = 8251,
        ["9906"] = 3043,
        ["9907"] = 4581,
        ["9908"] = 4257,
        ["9909"] = 2848,
        ["9910"] = 3087,
        ["9911"] = 7228,
        ["9912"] = 5037,
        ["9913"] = 8491,
        ["9914"] = 7557,
        ["9915"] = 5091,
        ["9916"] = 3566,
        ["9917"] = 5519,
        ["9918"] = 10212,
        ["9919"] = 4119,
        ["9920"] = 3721,
        ["9921"] = 6050,
        ["9922"] = 8745,
        ["9923"] = 6095,
        ["9924"] = 10276,
        ["9925"] = 3790,
        ["9926"] = 6368,
        ["9927"] = 3927,
        ["9928"] = 9930,
        ["9929"] = 3662,
        ["9930"] = 4287,
        ["9931"] = 4303,
        ["9932"] = 6995,
        ["9933"] = 9394,
        ["9934"] = 6577,
        ["9935"] = 9404,
        ["9936"] = 6403,
        ["9937"] = 4004,
        ["9938"] = 6029,
        ["9939"] = 4317,
        ["9940"] = 6954,
        ["9941"] = 6523,
        ["9942"] = 9341,
        ["9943"] = 11271,
        ["9944"] = 8570,
        ["9945"] = 4124,
        ["9946"] = 11396,
        ["9947"] = 5193,
        ["9948"] = 8365,
        ["9949"] = 4855,
        ["9950"] = 13418,
        ["9951"] = 5436,
        ["9952"] = 5255,
        ["9953"] = 8467,
        ["9954"] = 12126,
        ["9955"] = 8531,
        ["9956"] = 5130,
        ["9957"] = 13753,
        ["9958"] = 14724,
        ["9959"] = 4803,
        ["9960"] = 5623,
        ["9961"] = 5644,
        ["9962"] = 9218,
        ["9963"] = 9211,
        ["9964"] = 13190,
        ["9965"] = 9973,
        ["9966"] = 11800,
        ["9967"] = 5105,
        ["9968"] = 4744,
        ["9969"] = 6925,
        ["9970"] = 10029,
        ["9971"] = 6978,
        ["9972"] = 4357,
        ["9973"] = 6510,
        ["9974"] = 16449,
        ["9978"] = 0,
        ["9998"] = 4815,
        ["9999"] = 4833,
    },
	QualityLevel = 6,
	Style = "Coins",
	Stacks = true,
})

--[[--------------------------------------------------------------------------------
    OnEnable, enable the mod
-----------------------------------------------------------------------------------]]
function ColaLight:OnEnable()
	self:HookTooltips()
    
    self:RegisterEvent("MERCHANT_SHOW")
    -- register for the Links add on
    self:RegisterEvent("Links_LinkOpened")
end

--[[--------------------------------------------------------------------------------
    OnDisable, disable the mod
-----------------------------------------------------------------------------------]]
function ColaLight:OnDisable()
	for name, module in self:IterateModules() do
		self:ToggleModuleActive(module, false)
	end
    
    self:UnhookAll()
    self:UnregisterAllEvents()
end

--[[--------------------------------------------------------------------------------
    Slash command handlers
-----------------------------------------------------------------------------------]]
function ColaLight:PurgeDB()
	self.db.account.SellValues = {}
	self:Print(L["Purged the database."])
end

function ColaLight:Size()
    -- for some reason #self.db.account.SellValues doesn't work, maybe it shouldn't?
    local count = 0
    for _, _ in pairs(self.db.account.SellValues) do
        count = count + 1
    end
    self:Print(string.format(L["The database contains %d items"], count))
end

--[[--------------------------------------------------------------------------------
    Hook Handlers
-----------------------------------------------------------------------------------]]
local tooltips = {
    -- Blizzard tooltips
	GameTooltip,
	ItemRefTooltip,
	-- AtlasLoot tooltip
	AtlasLootTooltip,
}

local getLinkFunctions = {
	SetLootItem			= GetLootSlotLink,
	SetLootRollItem		= function(id) return GetLootRollItemLink(id) end,
	SetHyperlink		= function(link) return link end,
	SetAuctionItem		= GetAuctionItemLink,
	SetBagItem			= GetContainerItemLink,
	SetCraftItem		= function(skill, id) return id and GetCraftReagentItemLink(skill, id) or GetCraftItemLink(skill) end,
	SetInventoryItem	= function(type, slot) if not this then return end return type and GetInventoryItemLink(type, slot) or GetContainerItemLink(BANK_CONTAINER,this:GetID()) end,
	SetQuestItem		= GetQuestItemLink,
	SetQuestLogItem		= GetQuestLogItemLink,
	SetTradePlayerItem	= GetTradePlayerItemLink,
	SetTradeSkillItem	= function(skill, id) return (id) and GetTradeSkillReagentItemLink(skill, id) or GetTradeSkillItemLink(skill) end,
	SetTradeTargetItem	= GetTradeTargetItemLink,
    SetInboxItem	    = GetInboxItemLink,
}

local getQuantityFunctions = {
	SetLootItem			= function(slot) local _,_, count = GetLootSlotInfo(slot); return count; end,
	SetLootRollItem		= function(id) local _, _, count = GetLootRollItemInfo(id); return count end,
	SetHyperlink		= function() return 1 end,
	SetAuctionItem		= function(type, slot) local _,_, count = GetAuctionItemInfo(type, slot); return count; end,
	SetBagItem			= function(bag, slot) local _, count = GetContainerItemInfo(bag, slot); return count;  end,
	SetCraftItem		= function(skill, id) if id then local _, _, count = GetCraftReagentInfo(skill, id); return count else return 1 end end,
	SetInventoryItem	= function(unit, slot) if not this then return end; if unit then return GetInventoryItemCount(unit, slot) else local _, count = GetContainerItemInfo(BANK_CONTAINER,this:GetID()); return count; end end,
	SetQuestItem		= function(type, slot) local _,_, count = GetQuestItemInfo(type, slot); return count; end,
	SetQuestLogItem		= function(type, slot) local _,_, count = GetQuestLogRewardInfo(slot); return count; end,
	SetTradePlayerItem	= function(id) local _,_, count = GetTradeTargetItemInfo(id); return count; end,
	SetTradeSkillItem	= function(skill, id) if id then local _, _, count = GetTradeSkillReagentInfo(skill, id); return count else return 1 end end,
	SetTradeTargetItem	= function(id) local _,_, count = GetTradeTargetItemInfo(id); return count; end,
    SetInboxItem	    = function(id) local _,_, count = GetInboxItem(id); return count; end,
}

-- Hooking routine, loops all tooltips and functions and securely hooks
function ColaLight:HookTooltips()
    for _, tooltip in pairs(tooltips) do
        if tooltip then
            for o, l in pairs(getLinkFunctions) do
                local originalFunction, linkFunction = o, l  -- Get these into a local context, to avoid errors.  This drove me nuts.
                local quantityFunction = getQuantityFunctions[originalFunction]
                
                local func = function(frame, arg1, arg2, arg3)
                    local quality = 0
                    local link = linkFunction(arg1, arg2, arg3)
                    if link then _, _, quality = GetItemInfo(link) end
                    if quality and quality <= self.db.account.QualityLevel then
                        self:AddValueToTooltip(frame, link, quantityFunction(arg1, arg2, arg3), originalFunction)
                    end
                end
                
                self:SecureHook(tooltip, originalFunction, func)
            end
        end
    end
end

function ColaLight:SetTooltipMoney(object, value)
    self.value = value
    self.hooks.SetTooltipMoney(object, value)
end

--[[--------------------------------------------------------------------------------
    Event Handlers
-----------------------------------------------------------------------------------]]
-- scan all items, only save those of a quality equal or less than set by the quality option
function ColaLight:MERCHANT_SHOW()
    self:Hook("SetTooltipMoney", true)
    
    local newValues = {}
	for bag = 0, NUM_BAG_FRAMES do
		for slot = 1, GetContainerNumSlots(bag) do
            GameTooltip:SetBagItem(bag, slot)
            local id = self:LinkToID(GetContainerItemLink(bag, slot))
            local _, count, _, quality = GetContainerItemInfo(bag, slot)
            if id and id ~= '' and quality and quality <= self.db.account.QualityLevel then
                if count and count > 0 and self.value then
                    self.db.account.SellValues[id] = self.value / count
                    newValues[id] = self.value / count
                end
            end
            self.value = 0
		end
	end
    
    self:Unhook("SetTooltipMoney")
    
    -- notify modules that new data is available
    self:TriggerEvent("ColaLight_NewValueData", newValues)
end

-- respond to links opened by Links
function ColaLight:Links_LinkOpened(link, frame)
    self:AddValueToTooltip(frame, link, 1, "Links")
end

--[[--------------------------------------------------------------------------------
    Utility functions
-----------------------------------------------------------------------------------]]
function ColaLight:LinkToID(link)
	if link then
		local _, _, id = string.find(link, "(%d+):")
		return id
	end
end

function ColaLight:AddValueToTooltip(tooltip, link, count, source)
    if self.db.account.SellValues and not (MerchantFrame:IsVisible() and source == 'SetBagItem') and count then
		local id = self:LinkToID(link) 
        local value = self.db.account.SellValues[id]
		
        if value ~= nil then
			if value == 0 then
				tooltip:AddLine(ITEM_UNSELLABLE, 1.0, 1.0, 0, 0)
			else
				if self.db.account.Style == 'Coins' then
                    if count == 1 then
                        tooltip:AddLine(L["Sells for:"], 1.0, 1.0, 0, 0)
                    else
                        if self.db.account.Stacks then
                            tooltip:AddLine(L["Sells for (stack):"], 1.0, 1.0, 0, 0)
                            value = value * count
                        else
                            tooltip:AddLine(L["Sells for (each):"], 1.0, 1.0, 0, 0)
                        end
                    end
                    
                    SetTooltipMoney(tooltip, value)
				else
					local format = abacus["FormatMoney"..self.db.account.Style]
					if count == 1 then
						value = format(abacus, value, true)
                        tooltip:AddDoubleLine(L["Sells for:"], value, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0)
					else
						if self.db.account.Stacks then
							value = format(abacus, value, true)..' ('..format(abacus, value * count, true)..')'
                            tooltip:AddDoubleLine(L["Sells for:"], value, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0)
						else
							value = format(abacus, value, true)
                            tooltip:AddDoubleLine(L["Sells for (each):"], value, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0)
						end
					end
				end
			end
            
			tooltip:Show()
		end
	end
end
