﻿-- ----------------------------------------------------------------------------
-- ClosetGnome_TooltipX by kunda rip
-- originally submitted to ClosetGnome_Tooltip, but well...
-- ----------------------------------------------------------------------------
-- ATTENTION:
-- BLOAT incoming ;)
-- ----------------------------------------------------------------------------
local L = AceLibrary("AceLocale-2.2"):new("ClosetGnome_TooltipX")
ClosetGnome_TooltipX = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceHook-2.1")
ClosetGnome_TooltipX:RegisterDB("ClosetGnome_TooltipXDB")
ClosetGnome_TooltipX:RegisterDefaults("profile", {
	colorR = 1,
	colorG = 1,
	colorB = 1,
	doubleLine = false,
	multiLine = true,
	lineBreak = 3,
})

local addon = ClosetGnome_TooltipX

local _G = getfenv(0)
local item2set = {}
local item2setBreak = {}

local event = {
	"ClosetGnome_AddSet",
	"ClosetGnome_UpdateSet",
	"ClosetGnome_DeleteSet",
}

ClosetGnome_TooltipX.Opts = {
	type = "group",
	name = L["Tooltip"],
	desc = L["Tooltip options."],
	order = 103.9,
	args = {
		color = {
			type = "color",
			name = L["Color"],
			desc = L["Change Tooltip color."],
			get = function() return ClosetGnome_TooltipX.db.profile.colorR, ClosetGnome_TooltipX.db.profile.colorG, ClosetGnome_TooltipX.db.profile.colorB end,
			set = function(r,g,b) ClosetGnome_TooltipX.db.profile.colorR, ClosetGnome_TooltipX.db.profile.colorG, ClosetGnome_TooltipX.db.profile.colorB = r,g,b end,
			order = 120,
		},
		doubleLine = {
			type = "toggle",
			name = L["One Double Line"],
			desc = L["Right Side: ClosetGnome (x Set(s))\nLeft Side: Displays sets."],
			get = function() return ClosetGnome_TooltipX.db.profile.doubleLine end,
			set = function(v) ClosetGnome_TooltipX.db.profile.doubleLine = v ClosetGnome_TooltipX.db.profile.multiLine = false end,
			order = 130,
		},
		multiLine = {
			type = "toggle",
			name = L["Two or more Lines"],
			desc = L["First Line: CloseGnome (x Set(s))\nNext Line(s): Displays sets."],
			get = function() return ClosetGnome_TooltipX.db.profile.multiLine end,
			set = function(v) ClosetGnome_TooltipX.db.profile.multiLine = v ClosetGnome_TooltipX.db.profile.doubleLine = false end,
			order = 140,
		},
		lineBreak = {
			type = "range",
			name = L["Line Break"],
			desc = L["Choose a number. Set display in Tooltip will break line after every n-th set."],
			disabled = function()
				if ClosetGnome_TooltipX.db.profile.multiLine then
					return false
				else
					return true
				end
			end,
			min = 0,
			max = 10,
			step = 1,
			get = function() return ClosetGnome_TooltipX.db.profile.lineBreak end,
			set = function(v) ClosetGnome_TooltipX.db.profile.lineBreak = v addon:CacheSets() end,
			order = 150,
		},
	},
}

function addon:OnInitialize()
	ClosetGnome.OnMenuRequest.args.tooltip = ClosetGnome_TooltipX.Opts
end

function addon:OnEnable()
	if not ClosetGnome then return end
	self:RegisterBucketEvent(event, 1, "CacheSets")
	self:HookScript(GameTooltip, "OnTooltipSetItem")
	self:CacheSets()
end

function addon:CacheSets()
	local function sortedpairs(t)
		_G.ntab = {}
		for k,v in pairs(t) do
			table.insert(_G.ntab,k)
		end
		table.sort(_G.ntab, function(a,b) return a<b end)
		local i = 0
		local function _f(_s,_v)
			i = i + 1
			local k = _G.ntab[i]
			if (k) then
				return k,t[k]
			end
		end
		return _f,nil,nil
	end

	for k in pairs(item2set) do
		item2set[k] = nil
	end
	for k in pairs(item2setBreak) do
		item2setBreak[k] = nil
	end

	for setname, set in sortedpairs(ClosetGnome.db.char.set) do
		for i = 0, 19 do
			if set[i] then
				local item = set[i]
				if not item2set[item] then
					item2set[item] = setname
					item2setBreak[item] = 1
				else
					if math.fmod(item2setBreak[item],ClosetGnome_TooltipX.db.profile.lineBreak) == 0 then
						item2set[item] = item2set[item]..",\n"..setname
					else
						item2set[item] = item2set[item]..", "..setname
					end
					item2setBreak[item] = item2setBreak[item] +1
				end
			end
		end
	end
end

-- Upvalue since OnTooltipSetItem gets called 24/7
local select = select
function addon:OnTooltipSetItem(tooltip, ...)
	local linkItem = select(2, tooltip:GetItem())
	if item2set[linkItem] then
		local t = ClosetGnome_TooltipX.db.profile
		local SetList = item2set[linkItem]
		local SetCount = item2setBreak[linkItem]
		-- plural check
		local settxt = L["Sets"]
		if SetCount == 1 then
			settxt = L["Set"]
		end
		-- plural check
		-- doubleLine
		if t.doubleLine then
			tooltip:AddDoubleLine("ClosetGnome ("..(SetCount).." "..settxt.."):", gsub(SetList,",\n",", "),t.colorR,t.colorG,t.colorB,t.colorR,t.colorG,t.colorB)
		end
		-- doubleLine
		-- multiLine
		if t.multiLine then
			tooltip:AddLine("ClosetGnome ("..(SetCount).." "..settxt.."):",t.colorR,t.colorG,t.colorB)
			tooltip:AddLine(SetList,t.colorR,t.colorG,t.colorB)
		end
		-- multiLine
	end
	return self.hooks[tooltip].OnTooltipSetItem(tooltip, ...)
end
