
ClosetGnome_Tooltip = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1")
local addon = ClosetGnome_Tooltip

local item2set = {}

local event = {
	"ClosetGnome_AddSet",
	"ClosetGnome_UpdateSet",
	"ClosetGnome_DeleteSet",
}
function addon:OnEnable()
	if not ClosetGnome then return end
	self:RegisterBucketEvent(event, 1, "CacheSets")
	self:HookScript(GameTooltip, "OnTooltipSetItem")

	self:CacheSets()
end

-- ripped somewhat from closetgnome baggins
function addon:CacheSets()
	for k in pairs(item2set) do
		item2set[k] = nil
	end

	for setname, set in pairs(ClosetGnome.db.char.set) do
		for i = 0, 19 do
			if set[i] then
				local item = set[i]
				if not item2set[item] then
					item2set[item] = setname
				else
					item2set[item] = item2set[item]..", "..setname
				end
			end
		end
	end
end

-- Upvalue since OnTooltipSetItem gets called 24/7
local select = select
function addon:OnTooltipSetItem(tooltip, ...)
	local linkItem = select(2, tooltip:GetItem())
	if item2set[linkItem] then
		tooltip:AddDoubleLine("ClosetGnome", item2set[linkItem])
	end
	return self.hooks[tooltip].OnTooltipSetItem(tooltip, ...)
end

