local _,class = UnitClass("player")
if class ~= "WARRIOR" then return end

local battle = GetSpellInfo(2457) -- Battle Stance
local zerker = GetSpellInfo(2458) -- Berserker Stance
local defensive = GetSpellInfo(71) -- Defensive Stance

local L = AceLibrary("AceLocale-2.2"):new("ClosetGnomeSwitcher")

local ClosetGnomeSwitcher_Warrior = ClosetGnomeSwitcher:NewModule("ClosetGnomeSwitcher_Warrior", "AceEvent-2.0")

function ClosetGnomeSwitcher_Warrior:OnInitialize()
	ClosetGnomeSwitcher.Opts.args.battleSet = {
		type = "text",
		name = battle,
		desc = string.format(L["The set to use when in %s."], battle),
		usage = "<setName>",
		validate = ClosetGnomeSwitcher.sets,
		disabled = "ShouldDisable",
	}
	ClosetGnomeSwitcher.Opts.args.defensiveSet = {
		type = "text",
		name = defensive,
		desc = string.format(L["The set to use when in %s."], defensive),
		usage = "<setName>",
		validate = ClosetGnomeSwitcher.sets,
		disabled = "ShouldDisable",
	}
	ClosetGnomeSwitcher.Opts.args.berserkerSet = {
		type = "text",
		name = zerker,
		desc = string.format(L["The set to use when in %s."], zerker),
		usage = "<setName>",
		validate = ClosetGnomeSwitcher.sets,
		disabled = "ShouldDisable",
	}
end

function ClosetGnomeSwitcher_Warrior:FormChanged(form)
	if form == battle then
		return ClosetGnomeSwitcherDBPC.battleSet
	elseif form == defensive then
		return ClosetGnomeSwitcherDBPC.defensiveSet
	elseif form == zerker then
		return ClosetGnomeSwitcherDBPC.berserkerSet
	end
	return false
end

