local _,class = UnitClass("player")
if class ~= "ROGUE" then return end

local stealth = GetSpellInfo(1784) -- Stealth

local L = AceLibrary("AceLocale-2.2"):new("ClosetGnomeSwitcher")

local ClosetGnomeSwitcher_Rogue = ClosetGnomeSwitcher:NewModule("ClosetGnomeSwitcher_Rogue")

function ClosetGnomeSwitcher_Rogue:OnInitialize()
	ClosetGnomeSwitcher.Opts.args.stealth = {
		type = "text",
		name = stealth,
		desc = L["The set to use when stealthed."],
		usage = "<setName>",
		validate = ClosetGnomeSwitcher.sets,
		disabled = "ShouldDisable",
	}
end

function ClosetGnomeSwitcher_Rogue:OnEnable()
	ClosetGnomeSwitcher:RegisterForBuff(self, stealth)
end

function ClosetGnomeSwitcher_Rogue:BuffGained(name)
	if name == stealth then
		return ClosetGnomeSwitcherDBPC.stealth
	end
end

function ClosetGnomeSwitcher_Rogue:BuffLost(name)
	if name == stealth and ClosetGnomeSwitcher:HasSet("stealth") then
		return true
	end
end

