local _,class = UnitClass("player")
if class ~= "PRIEST" then return end

local shadowForm = GetSpellInfo(15473) -- Shadowform
local spiritTap = GetSpellInfo(15270) -- Spirit Tap
local innervate = GetSpellInfo(29166) -- Innervate

local L = AceLibrary("AceLocale-2.2"):new("ClosetGnomeSwitcher")
local SEEA = AceLibrary("SpecialEvents-Aura-2.0")

local CGS = ClosetGnomeSwitcher

local ClosetGnomeSwitcher_Priest = CGS:NewModule("ClosetGnomeSwitcher_Priest")

function ClosetGnomeSwitcher_Priest:OnInitialize()
	CGS.Opts.args.shadowSet = {
		type = "text",
		name = shadowForm,
		desc = string.format(L["The set to use when in %s."], shadowForm),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args.spirittapSet = {
		type = "text",
		name = spiritTap,
		desc = string.format(L["The set to use when you get %s."], spiritTap),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args.innervateSet = {
		type = "text",
		name = innervate,
		desc = string.format(L["The set to use when you get %s."], innervate),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
end

function ClosetGnomeSwitcher_Priest:OnEnable()
	CGS:RegisterForBuff(self, shadowForm)
	CGS:RegisterForBuff(self, spiritTap)
	CGS:RegisterForBuff(self, innervate)
end

function ClosetGnomeSwitcher_Priest:BuffGained(name)
	if name == innervate then
		return ClosetGnomeSwitcherDBPC.innervateSet
	elseif name == spiritTap then
		return ClosetGnomeSwitcherDBPC.spirittapSet
	elseif name == shadowForm then
		return ClosetGnomeSwitcherDBPC.shadowSet
	end
end

function ClosetGnomeSwitcher_Priest:BuffLost(name)
	if CGS:HasSet("innervateSet") and SEEA:UnitHasBuff("player", innervate) then
		return ClosetGnomeSwitcherDBPC.innervateSet
	elseif CGS:HasSet("spirittapSet") and SEEA:UnitHasBuff("player", spiritTap) then
		return ClosetGnomeSwitcherDBPC.spirittapSet
	elseif CGS:HasSet("shadowSet") and SEEA:UnitHasBuff("player", shadowForm) then
		return ClosetGnomeSwitcherDBPC.shadowSet
	end

	if name == innervate and CGS:HasSet("innervateSet") then
		return true
	elseif name == spiritTap and CGS:HasSet("spirittapSet") then
		return true
	elseif name == shadowForm and CGS:HasSet("shadowSet") then
		return true
	end
end

