local _,class = UnitClass("player")
if class ~= "MAGE" then return end

local evocation = GetSpellInfo(12051) -- Evocation
local innervate = GetSpellInfo(29166) -- Innervate

local L = AceLibrary("AceLocale-2.2"):new("ClosetGnomeSwitcher")

local ClosetGnomeSwitcher_Mage = ClosetGnomeSwitcher:NewModule("ClosetGnomeSwitcher_Mage")

function ClosetGnomeSwitcher_Mage:OnInitialize()
	ClosetGnomeSwitcher.Opts.args.evocation = {
		type = "text",
		name = evocation,
		desc = string.format(L["The set to use when you get %s."], evocation),
		usage = "<setName>",
		validate = ClosetGnomeSwitcher.sets,
		disabled = "ShouldDisable",
	}
	ClosetGnomeSwitcher.Opts.args.innervate = {
		type = "text",
		name = innervate,
		desc = string.format(L["The set to use when you get %s."], innervate),
		usage = "<setName>",
		validate = ClosetGnomeSwitcher.sets,
		disabled = "ShouldDisable",
	}
end

function ClosetGnomeSwitcher_Mage:OnEnable()
	ClosetGnomeSwitcher:RegisterForBuff(self, evocation)
	ClosetGnomeSwitcher:RegisterForBuff(self, innervate)
end

function ClosetGnomeSwitcher_Mage:BuffGained(name)
	if name == evocation then
		return ClosetGnomeSwitcherDBPC.evocation
	elseif name == innervate then
		return ClosetGnomeSwitcherDBPC.innervate
	end
end

function ClosetGnomeSwitcher_Mage:BuffLost(name)
	if name == evocation and ClosetGnomeSwitcher:HasSet("evocation") then
		return true
	elseif name == innervate and ClosetGnomeSwitcher:HasSet("innervate") then
		return true
	end
end

