local _,class = UnitClass("player")
if class ~= "DRUID" then return end

local cat = GetSpellInfo(768) -- Cat Form
local bear = GetSpellInfo(5487) -- Bear Form
local direBear = GetSpellInfo(9634) -- Dire Bear Form
local travel = GetSpellInfo(783) -- Travel Form
local moonkin = GetSpellInfo(24858) -- Moonkin Form
local tree = GetSpellInfo(33891) -- Tree of Life
local prowl = GetSpellInfo(5215) -- Prowl
local innervate = GetSpellInfo(29166) -- Innervate
local flight = GetSpellInfo(33943) -- Flight Form
local swift = GetSpellInfo(40120) -- Swift Flight Form

local L = AceLibrary("AceLocale-2.2"):new("ClosetGnomeSwitcher")
local SEEA = AceLibrary("SpecialEvents-Aura-2.0")

local CGS = ClosetGnomeSwitcher

local ClosetGnomeSwitcher_Druid = CGS:NewModule("ClosetGnomeSwitcher_Druid")

function ClosetGnomeSwitcher_Druid:OnInitialize()

	CGS.Opts.args[prowl] = {
		type = "text",
		name = prowl,
		desc = L["The set to use when prowling in Cat Form."],
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args[cat] = {
		type = "text",
		name = cat,
		desc = string.format(L["The set to use when in %s."], cat),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args[bear] = {
		type = "text",
		name = bear,
		desc = string.format(L["The set to use when in %s."], bear),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args[travel] = {
		type = "text",
		name = travel,
		desc = string.format(L["The set to use when in %s."], travel),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args[moonkin] = {
		type = "text",
		name = moonkin,
		desc = string.format(L["The set to use when in %s."], moonkin),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args[tree] = {
		type = "text",
		name = tree,
		desc = string.format(L["The set to use when in %s."], tree),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args[innervate] = {
		type = "text",
		name = innervate,
		desc = string.format(L["The set to use when you get %s."], innervate),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
	CGS.Opts.args[flight] = {
		type = "text",
		name = flight,
		desc = string.format(L["The set to use when in %s."], flight),
		usage = "<setName>",
		validate = CGS.sets,
		disabled = "ShouldDisable",
	}
end

function ClosetGnomeSwitcher_Druid:OnEnable()
	CGS:RegisterForBuff(self, prowl)
	CGS:RegisterForBuff(self, cat)
	CGS:RegisterForBuff(self, bear)
	CGS:RegisterForBuff(self, direBear)
	CGS:RegisterForBuff(self, travel)
	CGS:RegisterForBuff(self, moonkin)
	CGS:RegisterForBuff(self, tree)
	CGS:RegisterForBuff(self, innervate)
	CGS:RegisterForBuff(self, flight)
	CGS:RegisterForBuff(self, swift)
end

function ClosetGnomeSwitcher_Druid:FormChanged()
	return true -- ignore, buffs are used instead
end

function ClosetGnomeSwitcher_Druid:BuffGained(name)
	if name == direBear then name = bear end
	if name == swift then name = flight end
	return ClosetGnomeSwitcherDBPC[name]
end

function ClosetGnomeSwitcher_Druid:BuffLost(name)
	if name == direBear then name = bear end
	if name == swift then name = flight end

	if name == prowl and CGS:HasSet(prowl) then
		if SEEA:UnitHasBuff("player", cat) then
			return ClosetGnomeSwitcherDBPC.catSet
		end
		return true
	elseif name == innervate and CGS:HasSet(innervate) then
		local form = nil
		for buff in SEEA:BuffIter("player") do
			if ClosetGnomeSwitcherDBPC[buff] then
				form = ClosetGnomeSwitcherDBPC[buff]
				break
			end
		end
		return form or true
	elseif (name == flight or name == cat or name == bear or name == innervate or name == travel or name == moonkin or name == tree or name == innervate) and CGS:HasSet(name) then
		return true
	end
end

