﻿-------------------------------------------------------------------------------
-- Locals                                                                    --
-------------------------------------------------------------------------------

local SEM = AceLibrary("SpecialEvents-Mount-2.0")
local L = AceLibrary("AceLocale-2.2"):new("ClosetGnomeMount")

local CG = ClosetGnome

local lastSetBeforeMounting = nil
local mounted = nil

-------------------------------------------------------------------------------
-- Localization                                                              --
-------------------------------------------------------------------------------

L:RegisterTranslations("enUS", function() return {
	["Mount"] = true,
	["Dismount"] = true,
	["Flight Form"] = true,
	["Swift Flight Form"] = true,
	["Adds a saddle to your mount that can carry your ClosetGnome."] = true,

	["Battleground"] = true,
	["Instances"] = true,
	["Toggle whether set switching when mounting is enabled in instances or not."] = true,
	["Toggle whether set switching when mounting is enabled in battlegrounds or not."] = true,
	["What set to equip when you dismount. If no set is specified, the set you equipped before you mounted will be equipped automatically on dismount."] = true,
	["What set to equip when you mount."] = true,
	["What set to equip when in Druid Flight Form."] = true,
	["<set>"] = true,

	["Could not find a set named %q. Please add one."] = true,
	["Toggle whether ClosetGnome_Mount is enabled at all."] = true,
	["Enabled"] = true,
} end)

L:RegisterTranslations("frFR", function() return {
	["Mount"] = "Monture",
	["Dismount"] = "Sans Monture",
	["Flight Form"] = "Forme de vol",
	["Swift Flight Form"] = "Forme de vol rapide",
	["Adds a saddle to your mount that can carry your ClosetGnome."] = "Change automatiquement votre set quand vous \195\170tes sur une monture.",
	
	["Battleground"] = "Champs en bataille",
	--["Instances"] = true,
	["Toggle whether set switching when mounting is enabled in instances or not."] = "Si actif, change votre stuff monture automatiquement dans les instances.",
	["Toggle whether set switching when mounting is enabled in battlegrounds or not."] = "Si actif, change votre stuff monture automatiquement dans les champs de bataille.",
	["What set to equip when you dismount. If no set is specified, the set you equipped before you mounted will be equipped automatically on dismount."] = "Set \195\160 \195\169quiper quand vous descendez de monture. Si aucun set n'est sp\195\169cifi\195\169, vous serez \195\169quip\195\169 du set que vous aviez avant de prendre la monture.",
	["What set to equip when you mount."] = "Set \195\160 \195\169quiper sur la monture.",
	["What set to equip when in Druid Flight Form."] = "Set \195\160 \195\169quiper pour la forme de vol du druide.",
	--["<set>"] = true,

	["Could not find a set named %q. Please add one."] = "Impossible de trouver le set %q. Veuillez en ajouter un.",
	["Toggle whether ClosetGnome_Mount is enabled at all."] = "Active ClosetGnome_Mount.",
	["Enabled"] = "Activer",
} end)

L:RegisterTranslations("zhCN", function() return {
	["Mount"] = "骑乘换装",
	--["Dismount"] = true, NEEDS TRANSLATION
	--["Flight Form"] = true, NEEDS TRANSLATION
	--["Swift Flight Form"] = true, NEEDS TRANSLATION
	--["Adds a saddle to your mount that can carry your ClosetGnome."] = true, NEEDS TRANSLATION

	--["Battleground"] = true, NEEDS TRANSLATION
	--["Instances"] = true, NEEDS TRANSLATION
	--["Toggle whether set switching when mounting is enabled in instances or not."] = true, NEEDS TRANSLATION
	--["Toggle whether set switching when mounting is enabled in battlegrounds or not."] = true, NEEDS TRANSLATION
	--["What set to equip when you dismount. If no set is specified, the set you equipped before you mounted will be equipped automatically on dismount."] = true, NEEDS TRANSLATION
	--["What set to equip when you mount."] = true, NEEDS TRANSLATION
	--["What set to equip when in Druid Flight Form."] = true, NEEDS TRANSLATION
	--["<set>"] = true, NEEDS TRANSLATION

	["Could not find a set named %q. Please add one."] = "无法找到名为 qs 的设置. 请添加一个.",
	--["Toggle whether ClosetGnome_Mount is enabled at all."] = true, NEEDS TRANSLATION
	--["Enabled"] = true, NEEDS TRANSLATION
} end)

L:RegisterTranslations("koKR", function() return {
	["Mount"] = "탈때",
	["Dismount"] = "내릴때",
	["Flight Form"] = "폭풍까마귀 변신",
	["Swift Flight Form"] = "빠른 폭풍까마귀 변신",
	["Adds a saddle to your mount that can carry your ClosetGnome."] = "ClosetGnome으로 가져올 수 있는 탈것을 위한 안장을 추가합니다.",

	["Battleground"] = "전장",
	--["Instances"] = true, NEEDS TRANSLATION
	--["Toggle whether set switching when mounting is enabled in instances or not."] = true, NEEDS TRANSLATION
	["Toggle whether set switching when mounting is enabled in battlegrounds or not."] = "전장 혹은 비전장에서 타는 것이 활성화되어 있는 경우에 세트 교체 여부를 전환합니다.",
	["What set to equip when you dismount. If no set is specified, the set you equipped before you mounted will be equipped automatically on dismount."] = "내릴때 착용하기 위한 세트를 설정합니다. 세트가 지정되지 않았다면, 타기전에 착용했던 세트가 내릴때에 자동으로 착용됩니다.",
	["What set to equip when you mount."] = "탈때 착용하기 위한 세트를 설정합니다.",
	["What set to equip when in Druid Flight Form."] = "드루이드의 날것 변신에서 착용할 세트를 설정합니다.",
	["<set>"] = "<세트>",

	["Could not find a set named %q. Please add one."] = "%q란 이름의 세트를 찾을수 없습니다. 그것을 추가하기 바랍니다.",
	["Toggle whether ClosetGnome_Mount is enabled at all."] = "ClosetGnome_Mount|1을;를; 모든 경우에 활성화할지 여부를 전환합니다.",
	["Enabled"] = "활성화",
} end)

L:RegisterTranslations("esES", function() return {
	["Mount"] = "Montar",
	["Dismount"] = "Desmontar",
	["Swift Flight Form"] = "Disponer Forma de Vuelo",
	["Adds a saddle to your mount that can carry your ClosetGnome."] = "A\195\177ade una silla de montar en la que puedes llevar a tu ClosetGnome.",

	["Battleground"] = "Campo de Batalla",
	["Instances"] = "Instancias",
	["Toggle whether set switching when mounting is enabled in instances or not."] = "Determina si se activa este accesorio en instancias.",
	["Toggle whether set switching when mounting is enabled in battlegrounds or not."] = "Determina si se activa este accesorio en campos de batalla.",
	["What set to equip when you dismount. If no set is specified, the set you equipped before you mounted will be equipped automatically on dismount."] = "Qu\195\169 conjunto equipar cuando desmontas. Si no se especifica un conjunto se equipar\195\161 autom\195\161ticamente al desmontar el conjunto que ten\195\173as puesto antes de montar",
	["What set to equip when you mount."] = "Qu\195\169 conjunto equipar cuando montas.",
	["What set to equip when in Druid Flight Form."] = "Qu\195\169 conjunto equipar cuando estás en Forma de Vuelo Druida.",
	["<set>"] = "<conjunto>",

	["Could not find a set named %q. Please add one."] = "No se ha podido encontrar el conjunto llamado %q. Por favor, a\195\177ade uno.",
	["Toggle whether ClosetGnome_Mount is enabled at all."] = "Determina si se activa ClosetGnome_Mount",
	["Enabled"] = "Activado",
} end)

L:RegisterTranslations("zhTW", function() return {
	["Mount"] = "騎乘",
	["Dismount"] = "下馬",
	["Flight Form"] = "飛行形態",
	["Swift Flight Form"] = "迅捷飛行形態",
	["Adds a saddle to your mount that can carry your ClosetGnome."] = "教導 ClosetGnome 什麼是騎乘裝備。",

	["Battleground"] = "戰場",
	--["Instances"] = true, NEEDS TRANSLATION
	--["Toggle whether set switching when mounting is enabled in instances or not."] = true, NEEDS TRANSLATION
	["Toggle whether set switching when mounting is enabled in battlegrounds or not."] = "切換在戰場上用不用騎乘套裝。",
	["What set to equip when you dismount. If no set is specified, the set you equipped before you mounted will be equipped automatically on dismount."] = "當下馬時裝備什麼套裝。假如沒有設定，將會用回騎乘前的裝備。",
	["What set to equip when you mount."] = "當騎乘時裝備什麼套裝。",
	["What set to equip when in Druid Flight Form."] = "當在德魯伊飛行形態時裝備什麼套裝。",
	["<set>"] = "<套裝>",

	["Could not find a set named %q. Please add one."] = "找不到套裝: %q。請新增一套。",
	["Toggle whether ClosetGnome_Mount is enabled at all."] = "切換 ClosetGnome_Mount 模組。",
	["Enabled"] = "已啟用",
} end)

L:RegisterTranslations("deDE", function() return {
	["Mount"] = "Aufsteigen",
	["Dismount"] = "Absteigen",
	["Flight Form"] = "Fluggestalt",
	["Swift Flight Form"] = "Schnelle Fluggestalt",
	["Adds a saddle to your mount that can carry your ClosetGnome."] = "Dein ClosetGnome setzt sich in seinen eigenen kleinen Sattel, der ist Dir vorher noch nie aufgefallen.",

	["Battleground"] = "Schlachtfeld",
	["Instances"] = "Instanzen",
	["Toggle whether set switching when mounting is enabled in instances or not."] = "Setwechsel beim Aufsteigen in Instanzen ein-/ausschalten.",
	["Toggle whether set switching when mounting is enabled in battlegrounds or not."] = "Setwechsel beim Aufsteigen in Schlachtfeldern ein-/ausschalten.",
	["What set to equip when you dismount. If no set is specified, the set you equipped before you mounted will be equipped automatically on dismount."] = "Welches Set soll beim Absteigen angezogen werden? Wenn kein Set vorm Aufsteigen festgelegt wurde, wird das Set, das Du vorm Aufsteigen anhattest getragen.",
	["What set to equip when you mount."] = "Welches Set soll beim Aufsteigen angezogen werden?",
	["What set to equip when in Druid Flight Form."] = "Welches Set soll in der (schnellen) Flugform getragen werden?",
	["<set>"] = "<Set>",

	["Could not find a set named %q. Please add one."] = "Konnte das Set %s nicht finden. Bitte erstelle es!",
	["Toggle whether ClosetGnome_Mount is enabled at all."] = "ClosetGnome_Mount ein-/ausschalten.",
	["Enabled"] = "aktiviert",
} end)

-------------------------------------------------------------------------------
-- Addon declaration                                                         --
-------------------------------------------------------------------------------

ClosetGnomeMount = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0")

local function disabled()
	return ClosetGnomeMountPCDB.disabled
end

local playerClass = select(2, UnitClass("player"))
local options = {
	type = "group",
	name = L["Mount"],
	desc = L["Adds a saddle to your mount that can carry your ClosetGnome."],
	order = 106,
	args = {
		mount = {
			type = "text",
			name = L["Mount"],
			desc = L["What set to equip when you mount."],
			order = 1,
			get = function() return ClosetGnomeMountPCDB.mount end,
			set = function(v)
				if v:trim() == "" then v = nil end
				ClosetGnomeMountPCDB.mount = v
			end,
			validate = function(input) return type(input) == "string" or input == nil end,
			usage = L["<set>"],
			disabled = disabled,
		},
		flight = {
			type = "text",
			name = L["Flight Form"],
			desc = L["What set to equip when in Druid Flight Form."],
			order = 2,
			get = function() return ClosetGnomeMountPCDB.flight end,
			set = function(v)
				if v:trim() == "" then v = nil end
				ClosetGnomeMountPCDB.flight = v
			end,
			validate = function(input) return type(input) == "string" or input == nil end,
			usage = L["<set>"],
			disabled = disabled,
			hidden = function()
				if playerClass ~= "DRUID" then return true end
			end,
		},
		dismount = {
			type = "text",
			name = L["Dismount"],
			desc = L["What set to equip when you dismount. If no set is specified, the set you equipped before you mounted will be equipped automatically on dismount."],
			order = 3,
			get = function() return ClosetGnomeMountPCDB.dismount end,
			set = function(v)
				if v:trim() == "" then v = nil end
				ClosetGnomeMountPCDB.dismount = v
			end,
			validate = function(input) return type(input) == "string" or input == nil end,
			usage = L["<set>"],
			disabled = disabled,
		},
		spacer1 = {
			type = "header",
			name = " ",
			order = 50,
		},
		battleground = {
			type = "toggle",
			name = L["Battleground"],
			desc = L["Toggle whether set switching when mounting is enabled in battlegrounds or not."],
			order = 100,
			get = function() return ClosetGnomeMountPCDB.enabledInBG end,
			set = function(v) ClosetGnomeMountPCDB.enabledInBG = v end,
			disabled = disabled,
		},
		instances = {
			type = "toggle",
			name = L["Instances"],
			desc = L["Toggle whether set switching when mounting is enabled in instances or not."],
			order = 101,
			get = function() return ClosetGnomeMountPCDB.enabledInInstances end,
			set = function(v) ClosetGnomeMountPCDB.enabledInInstances = v end,
			disabled = disabled,
		},
		enabled = {
			type = "toggle",
			name = L["Enabled"],
			desc = L["Toggle whether ClosetGnome_Mount is enabled at all."],
			order = 102,
			get = function() return not ClosetGnomeMountPCDB.disabled end,
			set = function(v) ClosetGnomeMountPCDB.disabled = not v end,
		},
	},
}

-------------------------------------------------------------------------------
-- Util                                                                      --
-------------------------------------------------------------------------------

local function getMountSet(name)
	local x = ClosetGnomeMountPCDB.mount
	if type(x) == "string" and x:trim() == "" then x = nil end
	return (name and ClosetGnome:HasSet(name) and name) or x or L["Mount"]
end

local function getFFSet()
	local x = ClosetGnomeMountPCDB.flight
	if type(x) == "string" and x:trim() == "" then x = nil end
	return x or L["Flight Form"]
end

local function getDismountSet()
	local x = ClosetGnomeMountPCDB.dismount
	if type(x) == "string" and x:trim() == "" then x = nil end
	return x or L["Dismount"]
end

local function Wear(set)
	local quips = CG.db.profile.quips
	CG.db.profile.quips = nil
	CG:WearSet(set)
	CG.db.profile.quips = quips
end

local function isMountSwappingDisabled()
	if ClosetGnomeMountPCDB.disabled or IsControlKeyDown() then return true end
	local inInstance, instanceType = IsInInstance()
	if inInstance and not ClosetGnomeMountPCDB.enabledInInstances and not mounted then return true end
	if (instanceType == "pvp" or instanceType == "arena") and not ClosetGnomeMountPCDB.enabledInBG and not mounted then return true end
	return false
end

-------------------------------------------------------------------------------
-- Initialization                                                            --
-------------------------------------------------------------------------------

function ClosetGnomeMount:OnInitialize()
	if not CG then return end

	if type(ClosetGnomeMountPCDB) ~= "table" then
		ClosetGnomeMountPCDB = {}
	end

	options.args.about = nil
	CG.OnMenuRequest.args.mount = options
end

function ClosetGnomeMount:OnEnable()
	if not CG then return end

	self:RegisterBucketEvent("SpecialEvents_Mounted", 1)
	self:RegisterEvent("SpecialEvents_Dismounted")

	if playerClass == "DRUID" then
		self:RegisterEvent("SpecialEvents_PlayerBuffGained")
		self:RegisterEvent("SpecialEvents_PlayerBuffLost")
	end

	self:RegisterEvent("ClosetGnome_WearSet")
	self:RegisterEvent("PLAYER_LOGOUT")

	if not CG:HasSet(getMountSet()) and not ClosetGnomeMountPCDB.disabled then
		CG:Print(L["Could not find a set named %q. Please add one."]:format(getMountSet()))
	end

	if ClosetGnomeMountPCDB.mountedOnLogout then
		lastSetBeforeMounting = ClosetGnomeMountPCDB.mountedOnLogout
		ClosetGnomeMountPCDB.mountedOnLogout = nil
	end
end

-------------------------------------------------------------------------------
-- Events                                                                    --
-------------------------------------------------------------------------------

function ClosetGnomeMount:PLAYER_LOGOUT()
	if mounted then
		ClosetGnomeMountPCDB.mountedOnLogout = lastSetBeforeMounting
	end
end

function ClosetGnomeMount:ClosetGnome_WearSet(name)
	if name == getMountSet() or name == getFFSet() or name == getDismountSet() then return end
	lastSetBeforeMounting = name
end

local function mount(set)
	if not CG:HasSet(set) then
		CG:Print(L["Could not find a set named %q. Please add one."]:format(set))
		return
	end
	Wear(set)
	mounted = true
end

local function dismount(set)
	local spell, _, _, _, _, endTime = UnitCastingInfo("player")
	if spell then
		local dismountTime = (endTime / 1000 - GetTime()) + 0.3
		ClosetGnomeMount:ScheduleEvent("CGM-Dismount", dismount, dismountTime, set)
		return
	end
	if CG:HasSet(set) then
		Wear(set)
	elseif CG:HasSet(lastSetBeforeMounting) then
		Wear(lastSetBeforeMounting)
	end
	mounted = nil
end

function ClosetGnomeMount:SpecialEvents_Mounted(name)
	if isMountSwappingDisabled() then return end
	mount(getMountSet(name))
end

function ClosetGnomeMount:SpecialEvents_Dismounted()
	if isMountSwappingDisabled() then return end
	dismount(getDismountSet())
end

function ClosetGnomeMount:SpecialEvents_PlayerBuffGained(buff, i)
	if buff ~= L["Flight Form"] and buff ~= L["Swift Flight Form"] then return end
	if isMountSwappingDisabled() then return end
	mount(getFFSet())
end

function ClosetGnomeMount:SpecialEvents_PlayerBuffLost(buff)
	if buff ~= L["Flight Form"] and buff ~= L["Swift Flight Form"] then return end
	if isMountSwappingDisabled() then return end
	dismount(getDismountSet())
end
