﻿-- -----------------------------------------------------------------------------
-- ClosetGnome_HelmNCloak by kunda
-- -----------------------------------------------------------------------------
local L = AceLibrary("AceLocale-2.2"):new("ClosetGnome_HelmNCloak")
ClosetGnome_HelmNCloak = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0")
ClosetGnome_HelmNCloak:RegisterDB("ClosetGnome_HelmNCloakPCDB")
ClosetGnome_HelmNCloak:RegisterDefaults("char", {})

local iconhelm = "Interface\\AddOns\\ClosetGnome_HelmNCloak\\iconhelm.tga"
local iconcloak = "Interface\\AddOns\\ClosetGnome_HelmNCloak\\iconcloak.tga"
local iconboth = "Interface\\AddOns\\ClosetGnome_HelmNCloak\\iconboth.tga"
local icondisabled = "Interface\\AddOns\\ClosetGnome_HelmNCloak\\icondisabled.tga"

-- -----------------------------------------------------------------------------
-- Localization
-- -----------------------------------------------------------------------------
L:RegisterTranslations("enUS", function() return {
	["Helm and Cloak"] = true,
	["Define Helm and Cloak display.\n\nA newly added set inherits your current Helm/Cloak setting!\n\nThis Helm/Cloak setting is used when wearing a set!"] = true,
	["Enabled"] = true,
	["Enabled: Use Helm/Cloak display setting.\nDisabled: Do not change Helm/Cloak display when wearing this set."] = true,
	["Helm"] = true,
	["Toggle Helm display for this set."] = true,
	["Cloak"] = true,
	["Toggle Cloak display for this set."] = true,
	}
end)
L:RegisterTranslations("deDE", function() return {
	["Helm and Cloak"] = "Helm und Umhang",
	["Define Helm and Cloak display.\n\nA newly added set inherits your current Helm/Cloak setting!\n\nThis Helm/Cloak setting is used when wearing a set!"] = "Helm- und Umhanganzeige einstellen.\n\nEin neu hinzugefügtes Set erbt die momentane Helm-/Umhangeinstellung!\n\nDiese Helm- und Umhanganzeige wird beim Anlegen eines Sets benutzt!",
	["Enabled"] = "Aktiviert",
	["Enabled: Use Helm/Cloak display setting.\nDisabled: Do not change Helm/Cloak display when wearing this set."] = "Aktiviert: Benutze Helm- und Umhanganzeigeneinstellung.\nDeaktiviert: Helm- und Umhanganzeige nicht ändern beim Setwechsel.",
	["Helm"] = "Helm",
	["Toggle Helm display for this set."] = "Helmanzeige für dieses Set ein/ausschalten.",
	["Cloak"] = "Umhang",
	["Toggle Cloak display for this set."] = "Umhanganzeige für dieses Set ein/ausschalten.",
	}
end)
L:RegisterTranslations("esES", function() return {
	["Helm and Cloak"] = "Casco y Capa",
	["Define Helm and Cloak display.\n\nA newly added set inherits your current Helm/Cloak setting!\n\nThis Helm/Cloak setting is used when wearing a set!"] = "Define visualizaci\195\179n de Casco y Capa.\n\n\194\161Una nueva serie hereda su actual Casco/Capa establecida!\n\n.\194\161Este Casco/Capa es utilizado cuando vistes un conjunto!",
	["Enabled"] = "Activado",
	["Enabled: Use Helm/Cloak display setting.\nDisabled: Do not change Helm/Cloak display when wearing this set."] = "Activado: Usa opci\195\179n ver Casco/Capa.\nDesactivado: No cambia la visualizaci\195\179n de Casco/Capa cuando vistes este conjunto.",
	["Helm"] = "Casco",
	["Toggle Helm display for this set."] = "Ver Casco en este conjunto.",
	["Cloak"] = "Capa",
	["Toggle Cloak display for this set."] = "Ver Capa en este conjunto.",
	}
end)
-- -----------------------------------------------------------------------------

ClosetGnome_HelmNCloak.Opts = {
	type = "group",
	name = L["Helm and Cloak"],
	desc = L["Define Helm and Cloak display.\n\nA newly added set inherits your current Helm/Cloak setting!\n\nThis Helm/Cloak setting is used when wearing a set!"],
	order = 103.92,
	args = {},
}

function ClosetGnome_HelmNCloak:OnInitialize()
	local IsHelm = false
	local IsCloak = false
	if ShowingHelm() then IsHelm = true end
	if ShowingCloak() then IsCloak = true end
	for k, v in pairs(ClosetGnome.db.char.set) do
		if not ClosetGnome_HelmNCloak.db.char[k] then
			ClosetGnome_HelmNCloak.db.char[k] = {}
			ClosetGnome_HelmNCloak.db.char[k].activ = true
			ClosetGnome_HelmNCloak.db.char[k].helm = IsHelm
			ClosetGnome_HelmNCloak.db.char[k].cloak = IsCloak
		end
	end
	ClosetGnome.OnMenuRequest.args.HelmNCloak = ClosetGnome_HelmNCloak.Opts
	self:RegisterEvent("ClosetGnome_AddSet")
	self:RegisterEvent("ClosetGnome_DeleteSet")
	self:RegisterEvent("ClosetGnome_WearSet")
	self:Update()
end

function ClosetGnome_HelmNCloak:OnEnable()
	if not ClosetGnome then return end
end

function ClosetGnome_HelmNCloak:Update()
	local IsEmpty = true
	for k, v in pairs(ClosetGnome.db.char.set) do
		IsEmpty = false
		local t = ClosetGnome_HelmNCloak.db.char[k]
		local menuicon
		if not t.activ then
			menuicon = icondisabled
		else
			if t.helm then
				menuicon = iconhelm
			end
			if t.cloak then
				menuicon = iconcloak
			end
			if t.helm and t.cloak then
				menuicon = iconboth
			end
		end
		ClosetGnome_HelmNCloak.Opts.args[k] = {
			type = "group",
			name = k,
			desc = k,
			order = 110,
			icon = menuicon,
			args = {
				activ = {
					type = "toggle",
					name = L["Enabled"],
					desc = L["Enabled: Use Helm/Cloak display setting.\nDisabled: Do not change Helm/Cloak display when wearing this set."],
					order = 120,
					get = function() return t.activ end,
					set = function(v)
						t.activ = v
						self:Update()
					end,
				},
				helm = {
					type = "toggle",
					name = L["Helm"],
					desc = L["Toggle Helm display for this set."],
					order = 130,
					disabled = not t.activ,
					get = function() return t.helm end,
					set = function(v)
						t.helm = v
						if t.helm then
							if t.cloak then
								ClosetGnome_HelmNCloak.Opts.args[k].icon = iconboth
							else
								ClosetGnome_HelmNCloak.Opts.args[k].icon = iconhelm
							end
						else
							if t.cloak then
								ClosetGnome_HelmNCloak.Opts.args[k].icon = iconcloak
							else
								ClosetGnome_HelmNCloak.Opts.args[k].icon = nil
							end
						end
					end,
				},
				cloak = {
					type = "toggle",
					name = L["Cloak"],
					desc = L["Toggle Cloak display for this set."],
					order = 140,
					disabled = not t.activ,
					get = function() return t.cloak end,
					set = function(v)
						t.cloak = v
						if t.cloak then
							if t.helm then
								ClosetGnome_HelmNCloak.Opts.args[k].icon = iconboth
							else
								ClosetGnome_HelmNCloak.Opts.args[k].icon = iconcloak
							end
						else
							if t.helm then
								ClosetGnome_HelmNCloak.Opts.args[k].icon = iconhelm
							else
								ClosetGnome_HelmNCloak.Opts.args[k].icon = nil
							end
						end
					end,
				},
			},
		}
	end
	ClosetGnome_HelmNCloak.Opts.disabled = IsEmpty
end

function ClosetGnome_HelmNCloak:ClosetGnome_AddSet(name)
	ClosetGnome_HelmNCloak.db.char[name] = {}
	ClosetGnome_HelmNCloak.db.char[name].activ = true
	if ShowingHelm() then
		ClosetGnome_HelmNCloak.db.char[name].helm = true
	else
		ClosetGnome_HelmNCloak.db.char[name].helm = false
	end
	if ShowingCloak() then
		ClosetGnome_HelmNCloak.db.char[name].cloak = true
	else
		ClosetGnome_HelmNCloak.db.char[name].cloak = false
	end
	self:Update()
end

function ClosetGnome_HelmNCloak:ClosetGnome_DeleteSet(name)
	ClosetGnome_HelmNCloak.db.char[name] = nil
	ClosetGnome_HelmNCloak.Opts.args[name] = nil
	self:Update()
end

function ClosetGnome_HelmNCloak:ClosetGnome_WearSet(name)
	local t = ClosetGnome_HelmNCloak.db.char[name]
	if t.activ then
		local IsHelm = false
		local IsCloak = false
		if ShowingHelm() then IsHelm = true end
		if ShowingCloak() then IsCloak = true end
		if t.helm ~= IsHelm then
			ShowHelm(t.helm)
		end
		if t.cloak ~= IsCloak then
			ShowCloak(t.cloak)
		end
	end
end