-------------------------------------------------------------------------------
-- Locals                                                                    --
-------------------------------------------------------------------------------

local L = AceLibrary("AceLocale-2.2"):new("ClosetGnomeBigWigs")
local queuedSet = nil
local BB = nil

-------------------------------------------------------------------------------
-- Localization                                                              --
-------------------------------------------------------------------------------

L:RegisterTranslations("enUS", function() return {
	["BigWigs module %s enabled, equipping set %s."] = true,
	["ClosetGnome - BigWigs"] = true,
	["Makes your ClosetGnome aware of the various boss monsters in this dangerous world."] = true,

	["%s has been enabled. Do you want to equip %s?\n\nYou can disable this confirmation dialog to autoequip with /cgbw confirm."] = true,
	["Equip"] = true,
	["Cancel"] = true,

	["Alias"] = true,
	["Alias a BigWigs bossmod to an existing set, or reset an alias by not including the set parameter."] = true,
	["<boss> <set>"] = true,
	["ListAliases"] = true,
	["List aliases"] = true,
	["List the current aliases."] = true,
	["Registered aliases (uppercased module: set name):"] = true,
	["Alias %s removed."] = true,
	["Confirm"] = true,
	["Confirm Autoequip"] = true,
	["Open a confirmation dialog before autoequipping a boss set."] = true,
	["List modules"] = true,
	["ListModules"] = true,
	["List the loaded BigWigs modules that can be assigned to a set."] = true,
	["Available boss modules:"] = true,

	["%s aliased to %s."] = true,
	["%s: %s."] = true,
	["%d aliases registered."] = true,
} end)

L:RegisterTranslations("koKR", function() return {
	["BigWigs module %s enabled, equipping set %s."] = "빅윅 모듈 %s|1이;가 활성화 되었습니다. %s 세트를 착용합니다.",
	["ClosetGnome - BigWigs"] = "ClosetGnome - BigWigs",
	["Makes your ClosetGnome aware of the various boss monsters in this dangerous world."] = "던전이나 레이드 중에 각 몬스터에 맞게 장비세트를 자동으로 착용합니다.",

	["%s has been enabled. Do you want to equip %s?\n\nYou can disable this confirmation dialog to autoequip with /cgbw confirm."] = "%s가 활성화 되었습니다. %s 세트를 착용하시겠습니까?\n\n장비 세트 착용 확인 알림창을 /cgbw confirm를 입력하여 끌 수 있습니다.",
	["Equip"] = "장착",
	["Cancel"] = "취소",

	["Alias"] = "이름",
	["Alias a BigWigs bossmod to an existing set, or reset an alias by not including the set parameter."] = "기존의 세트에 빅윅 보스 모드의 이름을 설정합니다. 그렇지 않으면 세트 파라미터를 포함하지 않음으로 이름을 다시 설정합니다.",
	["<boss> <set>"] = "<보스> <세트>",
	["ListAliases"] = "세트리스트",
	["List aliases"] = "세트 리스트",
	["List the current aliases."] = "현재 저장한 세트 리스트를 봅니다.",
	["Registered aliases (uppercased module: set name):"] = "이름 등록 (어퍼 케이스 모듈: 세트 이름):",
	["Alias %s removed."] = "이름 %s 제거",
	["Confirm"] = "확인",
	["Confirm Autoequip"] = "자동 착용 확인",
	["Open a confirmation dialog before autoequipping a boss set."] = "보스전시에 자동 장착하기 전에 확인창을 엽니다.",
	["List modules"] = "모듈 리스트",
	["ListModules"] = "모듈리스트",
	["List the loaded BigWigs modules that can be assigned to a set."] = "빅윅 모듈에 맞는 세트 리스트를 불러옵니다.",
	["Available boss modules:"] = "가능한 보스 모듈:",

	["%s aliased to %s."] = "%s aliased to %s.",
	["%s: %s."] = "%s: %s.",
	["%d aliases registered."] = "%d 이름을 등록했습니다.",
} end)

L:RegisterTranslations("esES", function() return {
	["BigWigs module %s enabled, equipping set %s."] = "M\195\179dulo BigWigs %s activado, equipando el conjunto %s.",
	["ClosetGnome - BigWigs"] = "ClosetGnome - BigWigs",
	["Makes your ClosetGnome aware of the various boss monsters in this dangerous world."] = "Hace que tu ClosetGnome est\195\169 al tanto de los varios monstruos boss que hay en este peligroso mundo.",

	["%s has been enabled. Do you want to equip %s?\n\nYou can disable this confirmation dialog to autoequip with /cgbw confirm."] = "%s ha sido activado. \194\191Quieres equipar %s?\n\nPUedes desactivar esta ventana de confirmaci\195\179n para autoequiparte con /cgbw confirm.",
	["Equip"] = "Equipar",
	["Cancel"] = "Cancelar",

	["Alias"] = "Alias",
	["Alias a BigWigs bossmod to an existing set, or reset an alias by not including the set parameter."] = "Crea un alias de un BigWigs bossmod hacia un conjunto existente, o reinicia un alias al no incluir el par\195\161metro de conjunto",
	["<boss> <set>"] = "<boss> <conjunto>",
	["ListAliases"] = "ListarAlias",
	["List aliases"] = "Listar alias",
	["List the current aliases."] = "Muestra una lista con los alias actuales.",
	["Registered aliases (uppercased module: set name):"] = "Alias registrados (m\195\179dulo en may\195\186sculas: nombre del conjunto):",
	["Alias %s removed."] = "Alias %s eliminado.",
	["Confirm"] = "Confirmar",
	["Confirm Autoequip"] = "Confirmar Autoequipado",
	["Open a confirmation dialog before autoequipping a boss set."] = "Abre una ventana de confirmaci\195\179n antes de autoequiparte con un conjunto de boss.",
	["List modules"] = "Listar m\195\179dulos",
	["ListModules"] = "ListarModulos",
	["List the loaded BigWigs modules that can be assigned to a set."] = "Muestra una lista de los m\195\179dulos BigWigs cargados a los que puedes asignar un conjunto.",
	["Available boss modules:"] = "M\195\179dulos de boss disponibles:",

	["%s aliased to %s."] = "Creado alias de %s para %s",
	["%s: %s."] = "%s: %s.",
	["%d aliases registered."] = "%d alias registrados.",
} end)


-------------------------------------------------------------------------------
-- Addon declaration                                                         --
-------------------------------------------------------------------------------

ClosetGnomeBigWigs = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0")

-------------------------------------------------------------------------------
-- Initialization                                                            --
-------------------------------------------------------------------------------

function ClosetGnomeBigWigs:OnInitialize()
	if not ClosetGnome or not BigWigs then return end

	self:RegisterDB("ClosetGnomeBigWigsDB", "ClosetGnomeBigWigsPCDB")
	self:RegisterDefaults("profile", {
		enabled = true,
		confirmEquip = true,
	})
	self:RegisterDefaults("char", {
		alias = {},
		version = 1,
	})

	self:RegisterChatCommand("/cgbw", {
		type = "group",
		name = L["ClosetGnome - BigWigs"],
		desc = L["Makes your ClosetGnome aware of the various boss monsters in this dangerous world."],
		args = {
			[L["Alias"]] = {
				type = "text",
				name = L["Alias"],
				desc = L["Alias a BigWigs bossmod to an existing set, or reset an alias by not including the set parameter."],
				get = false,
				set = "AddAlias",
				validate = "ValidateAlias",
				usage = L["<boss> <set>"],
			},
			[L["ListAliases"]] = {
				type = "execute",
				name = L["List aliases"],
				desc = L["List the current aliases."],
				func = "ListAliases",
			},
			[L["ListModules"]] = {
				type = "execute",
				name = L["List modules"],
				desc = L["List the loaded BigWigs modules that can be assigned to a set."],
				func = "ListModules",
			},
			[L["Confirm"]] = {
				type = "toggle",
				name = L["Confirm Autoequip"],
				desc = L["Open a confirmation dialog before autoequipping a boss set."],
				get = function() return ClosetGnomeBigWigs.db.profile.confirmEquip end,
				set = function(v) ClosetGnomeBigWigs.db.profile.confirmEquip = v end,
			},
		},
	})
end

function ClosetGnomeBigWigs:OnEnable()
	if not ClosetGnome or not BigWigs then return end

	self:RegisterEvent("BigWigs_RecvSync")

	if not StaticPopupDialogs then StaticPopupDialogs = {} end
	if not StaticPopupDialogs["ClosetGnomeBigWigsConfirm"] then
		StaticPopupDialogs["ClosetGnomeBigWigsConfirm"] = {
			text = L["%s has been enabled. Do you want to equip %s?\n\nYou can disable this confirmation dialog to autoequip with /cgbw confirm."],
			button1 = L["Equip"],
			button2 = L["Cancel"],
			sound = "levelup2",
			whileDead = 0,
			hideOnEscape = 1,
			timeout = 0,
			OnAccept = function()
				ClosetGnome:WearSet(queuedSet)
			end,
		}
	end

	if self.db.char.version == 1 then
		for k, v in pairs(self.db.char.alias) do
			self.db.char.alias[k] = nil
			self.db.char.alias[k:upper()] = v
		end
		self.db.char.version = 2
	end
end

-------------------------------------------------------------------------------
-- Command handlers                                                          --
-------------------------------------------------------------------------------

function ClosetGnomeBigWigs:ListModules()
	if not BigWigs then return end
	local printTable = {}
	for name, module in BigWigs:IterateModules() do
		if module:IsBossModule() and module.zonename then
			local zone = module.zonename
			if type(module.zonename) == "table" then
				zone = module.zonename[1]
			end
			--self:Print("Zone: "..zone)
			if not printTable[zone] then printTable[zone] = {} end
			local name = module:ToString():gsub(" ", "")
			table.insert(printTable[zone], name)
		end
	end

	local frame = DEFAULT_CHAT_FRAME
	frame:AddMessage(L["Available boss modules:"])
	for k, v in pairs(printTable) do
		if #v > 0 then
			frame:AddMessage(L["%s: %s."]:format("|cff00ff00"..k.."|r", table.concat(v, ", ")))
		end
	end
end

function ClosetGnomeBigWigs:ListAliases()
	local frame = DEFAULT_CHAT_FRAME
	local counter = 0
	frame:AddMessage(L["Registered aliases (uppercased module: set name):"])
	for k, v in pairs(self.db.char.alias) do
		frame:AddMessage(L["%s: %s."]:format("|cff00ff00"..k.."|r", v))
		counter = counter + 1
	end
	frame:AddMessage(L["%d aliases registered."]:format(counter))
end

function ClosetGnomeBigWigs:ValidateAlias(input)
	if input:find("%s") then
		local boss, set = select(3, input:find("(.*)%s+(.*)"))
		return boss and set
	else
		return self.db.char.alias[input:upper()]
	end
end

function ClosetGnomeBigWigs:AddAlias(alias)
	if alias:find("%s") then
		local boss, set = select(3, alias:find("(.*) (.*)"))
		if boss and set then
			if boss:upper() == "ALL" then
				for name, module in BigWigs:IterateModules() do
					if module:IsBossModule() and module.zonename then
						local name = module:ToString():gsub(" ", "")
						self.db.char.alias[name:upper()] = set
					end
				end
				self:Print(L["%s aliased to %s."]:format("All", set))
			else
				self.db.char.alias[boss:upper()] = set
				self:Print(L["%s aliased to %s."]:format(boss, set))
			end
		end
	elseif self.db.char.alias[alias:upper()] then
		if alias:upper() == "ALL" then
			for name, module in BigWigs:IterateModules() do
				if module:IsBossModule() and module.zonename then
					local name = module:ToString():gsub(" ", "")
					self.db.char.alias[name:upper()] = nil
				end
			end
			self:Print(L["Alias %s removed."]:format("All"))
		else
			self:Print(L["Alias %s removed."]:format(alias:upper()))
			self.db.char.alias[alias:upper()] = nil
		end
	end
end

-------------------------------------------------------------------------------
-- Events                                                                    --
-------------------------------------------------------------------------------

function ClosetGnomeBigWigs:BigWigs_RecvSync(sync, rest, nick)
	if not BigWigs or sync ~= "EnableModule" or not rest or not self.db.profile.enabled then return end

	if not BB then BB = LibStub("LibBabble-Boss-3.0"):GetUnstrictLookupTable() end

	local translatedModuleName = BB[rest] or rest
	if not BigWigs:HasModule(translatedModuleName) then return end

	local m = BigWigs:GetModule(translatedModuleName)
	if not m or not m:IsBossModule() then return end

	local strippedBoss = m:ToString():gsub(" ", ""):upper()
	local setName = strippedBoss
	if self.db.char.alias[strippedBoss] then
		setName = self.db.char.alias[strippedBoss]
	end

	if ClosetGnome:HasSet(setName) and not ClosetGnome:IsSetFullyEquipped(setName) then
		if self.db.profile.confirmEquip then
			queuedSet = setName
			StaticPopup_Show("ClosetGnomeBigWigsConfirm", "|cffd9d919"..m:ToString().."|r", "|cffd9d919"..setName.."|r")
		else
			self:Print(L["BigWigs module %s enabled, equipping set %s."]:format(m:ToString(), setName))
			ClosetGnome:WearSet(setName)
		end
	end
end

