-- Initialize the Add-on.
CF2_FontPack = AceLibrary("AceAddon-2.0"):new()

-- Font path.
local FontPath = "Interface\\AddOns\\ClearFont2_FontPack\\Fonts\\"

--Black Chancery
local BlackChancery = {
	["name"]		= "Black Chancery",
	["normal"]		= FontPath.."BlackChancery\\BLKCHCRY.ttf",
	["bold"]		= FontPath.."BlackChancery\\BLKCHCRY.ttf",
	["italic"]		= FontPath.."BlackChancery\\BLKCHCRY.ttf",
	["bolditalic"]	= FontPath.."BlackChancery\\BLKCHCRY.ttf",
	["number"]		= FontPath.."BlackChancery\\BLKCHCRY.ttf",
}

-- Centaur
local Centaur = {
    ["name"]       = "Centaur",
    ["normal"]     = FontPath.."Centaur\\Centaur.ttf",
    ["bold"]       = FontPath.."Centaur\\Centaur.ttf",
    ["italic"]     = FontPath.."Centaur\\Centaur.ttf",
    ["bolditalic"] = FontPath.."Centaur\\Centaur.ttf",
    ["number"]     = FontPath.."Centaur\\Centaur.ttf",
}

-- Crimefighter
local Crimefighter = {
	["name"]       = "Crimefighter",	
	["normal"]     = FontPath.."Crimefighter\\CRIMFBRG.ttf",
	["bold"]       = FontPath.."Crimefighter\\CRIMFBB_.ttf",
	["italic"]     = FontPath.."Crimefighter\\CRIMFBRG.ttf",
	["bolditalic"] = FontPath.."Crimefighter\\CRIMFBB_.ttf", 
	["number"]     = FontPath.."Crimefighter\\CRIMFBB_.ttf",
}

--Daville
local Daville = {
	["name"]       = "Daville",	
	["normal"]     = FontPath.."Daville\\Daville.ttf",
	["bold"]       = FontPath.."Daville\\Daville.ttf",
	["italic"]     = FontPath.."Daville\\DavilleItalic.ttf",
	["bolditalic"] = FontPath.."Daville\\DavilleItalic.ttf", 
	["number"]     = FontPath.."Daville\\Daville.ttf",
}

-- Dumbledor
local Dumbledor = {
    ["name"]       = "Dumbledor",
    ["normal"]     = FontPath.."Dumbledor\\Dumbledor.ttf",
    ["bold"]       = FontPath.."Dumbledor\\Dumbledor_Wide.ttf",
    ["italic"]     = FontPath.."Dumbledor\\Dumbledor_Italic.ttf",
    ["bolditalic"] = FontPath.."Dumbledor\\Dumbledor_Wide.ttf",
    ["number"]     = FontPath.."Dumbledor\\Dumbledor_Thin.ttf",
}

-- Dustismo
local Dustismo = {
	["name"]       = "Dustismo",	
	["normal"]     = FontPath.."Dustismo3\\Dustismo.ttf",
	["bold"]       = FontPath.."Dustismo3\\dustismo_bold.ttf",
	["italic"]     = FontPath.."Dustismo3\\dustismo_italic.ttf",
	["bolditalic"] = FontPath.."Dustismo3\\dustismo_bold_italic.ttf", 
	["number"]     = FontPath.."Dustismo3\\dustismo_bold.ttf",
}

-- Effloresce
local Effloresce = {
	["name"]       = "Effloresce",	
	["normal"]     = FontPath.."Effloresce\\Effloresce.ttf",
	["bold"]       = FontPath.."Effloresce\\EffloresceBold.ttf",
	["italic"]     = FontPath.."Effloresce\\EffloresceItalic.ttf",
	["bolditalic"] = FontPath.."Effloresce\\EffloresceBoldItalic.ttf", 
	["number"]     = FontPath.."Effloresce\\EffloresceBold.ttf",
}

-- Enviro
local Enviro = {
	["name"]       = "Enviro",	
	["normal"]     = FontPath.."Enviro\\Enviro.ttf",
	["bold"]       = FontPath.."Enviro\\Enviro.ttf",
	["italic"]     = FontPath.."Enviro\\Enviro.ttf",
	["bolditalic"] = FontPath.."Enviro\\Enviro.ttf", 
	["number"]     = FontPath.."Enviro\\Enviro.ttf",
}

--GoodFish
local GoodFish = {
	["name"]		= "GoodFish",
	["normal"]		= FontPath.."GoodFish\\goodfish.ttf",
	["bold"]		= FontPath.."GoodFish\\goodfisb.ttf",
	["italic"]		= FontPath.."GoodFish\\goodfisi.ttf",
	["bolditalic"]	= FontPath.."GoodFish\\goodfisc.ttf",
	["number"]		= FontPath.."GoodFish\\goodfisb.ttf",
}

-- Insomniax
local Insomniax = {
    ["name"]       = "Insomniax",
    ["normal"]     = FontPath.."Insomniax\\Tw_Cen_MT.ttf",
    ["bold"]       = FontPath.."Insomniax\\Tw_Cen_MT_Bold.ttf",
    ["italic"]     = FontPath.."Insomniax\\Tw_Cen_MT_Bold_Italic.ttf",
    ["bolditalic"] = FontPath.."Insomniax\\Tw_Cen_MT_Bold_Italic.ttf",
    ["number"]     = FontPath.."Insomniax\\Tw_Cen_MT.ttf",
}

-- Kelmscot
local Kelmscot = {
	["name"]       = "Kelmscot",	
	["normal"]     = FontPath.."kelmscot\\KELMSCOT.ttf",
	["bold"]       = FontPath.."kelmscot\\KELMSCOT.ttf",
	["italic"]     = FontPath.."kelmscot\\KELMSCOT.ttf",
	["bolditalic"] = FontPath.."kelmscot\\KELMSCOT.ttf", 
	["number"]     = FontPath.."kelmscot\\KELMSCOT.ttf",
}

-- Libertine
local Libertine = {
	["name"]       = "Libertine",	
	["normal"]     = FontPath.."Libertine\\Libertine.ttf",
	["bold"]       = FontPath.."Libertine\\LibertineBold.ttf",
	["italic"]     = FontPath.."Libertine\\LibertineItalic.ttf",
	["bolditalic"] = FontPath.."Libertine\\LibertineBoldItalic.ttf", 
	["number"]     = FontPath.."Libertine\\LibertineBold.ttf",
}

-- Lido
local Lido = {
	["name"]       = "Lido",	
	["normal"]     = FontPath.."Lido\\Lido.ttf",
	["bold"]       = FontPath.."Lido\\LidoBold.ttf",
	["italic"]     = FontPath.."Lido\\LidoItalic.ttf",
	["bolditalic"] = FontPath.."Lido\\LidoBoldItalic.ttf", 
	["number"]     = FontPath.."Lido\\LidoBold.ttf",
}

-- SegoePrint
local SegoePrint = {
	["name"]       = "SegoePrint",	
	["normal"]     = FontPath.."SegoePrint\\SegoePrint.ttf",
	["bold"]       = FontPath.."SegoePrint\\SegoePrintB.ttf",
	["italic"]     = FontPath.."SegoePrint\\SegoePrintI.ttf",
	["bolditalic"] = FontPath.."SegoePrint\\SegoePrintBI.ttf", 
	["number"]     = FontPath.."SegoePrint\\SegoePrintB.ttf",
}

-- Teen
local Teen = {
	["name"]       = "Teen",	
	["normal"]     = FontPath.."Teen\\Teen.ttf",
	["bold"]       = FontPath.."Teen\\TeenB.ttf",
	["italic"]     = FontPath.."Teen\\TeenI.ttf",
	["bolditalic"] = FontPath.."Teen\\TeenBI.ttf", 
	["number"]     = FontPath.."Teen\\Teen.ttf",
}

-- Vera Sans Mono
local VeraSansMono = {
	["name"]       = "Vera Sans Mono",	
	["normal"]     = FontPath.."VeraSansMono\\Vera.ttf",
	["bold"]       = FontPath.."VeraSansMono\\VeraBold.ttf",
	["italic"]     = FontPath.."VeraSansMono\\VeraItalic.ttf",
	["bolditalic"] = FontPath.."VeraSansMono\\VeraItalic.ttf", 
	["number"]     = FontPath.."VeraSansMono\\Vera.ttf",
}

-- Update ClearFont2.
function CF2_FontPack:OnInitialize()

	table.insert(ClearFont.fonts, BlackChancery)
    table.insert(ClearFont.fonts, Centaur)
	table.insert(ClearFont.fonts, Crimefighter)
	table.insert(ClearFont.fonts, Daville)
    table.insert(ClearFont.fonts, Dumbledor)
	table.insert(ClearFont.fonts, Dustismo)
	table.insert(ClearFont.fonts, Effloresce)
	table.insert(ClearFont.fonts, Enviro)
	table.insert(ClearFont.fonts, GoodFish)
    table.insert(ClearFont.fonts, Insomniax)
	table.insert(ClearFont.fonts, Kelmscot)
	table.insert(ClearFont.fonts, Libertine)
	table.insert(ClearFont.fonts, Lido)
	table.insert(ClearFont.fonts, SegoePrint)
	table.insert(ClearFont.fonts, Teen)
	table.insert(ClearFont.fonts, VeraSansMono)

	ClearFont:UpdateFontList()

	-- Have to call this to force it to re-apply the right font. - Storm -
	ClearFont:ApplyFont()
	
	--Register fonts with SharedMediaLib
	local SML = AceLibrary:HasInstance("SharedMedia-1.0") and AceLibrary("SharedMedia-1.0") or nil
	if SML then
		SML:Register("font", "Black Chancery", FontPath.."BlackChancery\\BLKCHCRY.ttf")
        SML:Register("font", "Centaur",   FontPath.."Centaur\\Centaur.ttf")
		SML:Register("font", "Crimefighter", FontPath.."Crimefighter\\CRIMFBRG.ttf")
		SML:Register("font", "Daville", FontPath.."Daville\\Daville.ttf")
        SML:Register("font", "Dumbledor", FontPath.."Dumbledor\\Dumbledor.ttf")
		SML:Register("font", "Dustismo", FontPath.."Dustismo3\\Dustismo.ttf")
		SML:Register("font", "Effloresce", FontPath.."Effloresce\\Effloresce.ttf")
		SML:Register("font", "Enviro", FontPath.."Enviro\\Enviro.ttf")
		SML:Register("font", "GoodFish", FontPath.."GoodFish\\goodfish.ttf")
        SML:Register("font", "Insomniax", FontPath.."Insomniax\\Tw_Cen_MT.ttf")
		SML:Register("font", "Kelmscot", FontPath.."kelmscot\\KELMSCOT.ttf")
		SML:Register("font", "Libertine", FontPath.."Libertine\\Libertine.ttf")
		SML:Register("font", "Lido", FontPath.."Lido\\Lido.ttf")
		SML:Register("font", "SegoePrint", FontPath.."SegoePrint\\SegoePrint.ttf")
		SML:Register("font", "Teen", FontPath.."Teen\\Teen.ttf")
		SML:Register("font", "Vera Sans Mono", FontPath.."VeraSansMono\\Vera.ttf")
	end

	--Register fonts with SharedMediaLib-3.0
	local LSM = LibStub:GetLibrary("LibSharedMedia-3.0", true) or LibStub:GetLibrary("LibSharedMedia-2.0", true)
	if LSM then
		LSM:Register("font", "Black Chancery", FontPath.."BlackChancery\\BLKCHCRY.ttf")
        LSM:Register("font", "Centaur",   FontPath.."Centaur\\Centaur.ttf")
		LSM:Register("font", "Crimefighter", FontPath.."Crimefighter\\CRIMFBRG.ttf")
		LSM:Register("font", "Daville", FontPath.."Daville\\Daville.ttf")
        LSM:Register("font", "Dumbledor", FontPath.."Dumbledor\\Dumbledor.ttf")
		LSM:Register("font", "Dustismo", FontPath.."Dustismo3\\Dustismo.ttf")
		LSM:Register("font", "Effloresce", FontPath.."Effloresce\\Effloresce.ttf")
		LSM:Register("font", "Enviro", FontPath.."Enviro\\Enviro.ttf")
		LSM:Register("font", "GoodFish", FontPath.."GoodFish\\goodfish.ttf")
        LSM:Register("font", "Insomniax", FontPath.."Insomniax\\Tw_Cen_MT.ttf")
		LSM:Register("font", "Kelmscot", FontPath.."kelmscot\\KELMSCOT.ttf")
		LSM:Register("font", "Libertine", FontPath.."Libertine\\Libertine.ttf")
		LSM:Register("font", "Lido", FontPath.."Lido\\Lido.ttf")
		LSM:Register("font", "SegoePrint", FontPath.."SegoePrint\\SegoePrint.ttf")
		LSM:Register("font", "Teen", FontPath.."Teen\\Teen.ttf")
		LSM:Register("font", "Vera Sans Mono", FontPath.."VeraSansMono\\Vera.ttf")
	end
	
end
