local BC = LibStub("LibBabble-Class-3.0"):GetLookupTable()
local BTT = LibStub("LibBabble-TalentTree-3.0"):GetLookupTable()

local oneSpec = "%s (%s)"
local twoSpec = "%s (%s/%s)"

ClassLoot_Constants = {
	-- General Constants
	["Slash-Commands"] = { "classloot", "cl" },

	-- Classic Class Keys
	["WarriorTanking"] = oneSpec:format(BC["Warrior"], BTT["Protection"]),
	["WarriorDPS"] = twoSpec:format(BC["Warrior"], BTT["Arms"], BTT["Fury"]),
	["Rogue"] = BC["Rogue"],
	["Hunter"] = BC["Hunter"],
	["DruidFeral"] = oneSpec:format(BC["Druid"], BTT["Feral Combat"]),
	["DruidHealing"] = oneSpec:format(BC["Druid"], BTT["Restoration"]),
	["Mage"] = BC["Mage"],
	["Priest"] = BC["Priest"],
	["Warlock"] = BC["Warlock"],
	["PaladinDPS"] = oneSpec:format(BC["Paladin"], BTT["Retribution"]),
	["PaladinHealing"] = oneSpec:format(BC["Paladin"], BTT["Holy"]),
	["ShamanDPS"] = twoSpec:format(BC["Shaman"], BTT["Enhancement"], BTT["Elemental"]),
	["ShamanHealing"] = oneSpec:format(BC["Shaman"], BTT["Restoration"]),
	
	-- BC Class Keys
	["WarriorProt"] = oneSpec:format(BC["Warrior"], BTT["Protection"]),
	["WarriorArms"] = oneSpec:format(BC["Warrior"], BTT["Arms"]),
	["WarriorFury"] = oneSpec:format(BC["Warrior"], BTT["Fury"]),
	["PaladinHoly"] = oneSpec:format(BC["Paladin"], BTT["Holy"]),
	["PaladinProt"] = oneSpec:format(BC["Paladin"], BTT["Protection"]),
	["PaladinRet"] = oneSpec:format(BC["Paladin"], BTT["Retribution"]),
	["ShamanElemental"] = oneSpec:format(BC["Shaman"], BTT["Elemental"]),
	["ShamanEnhance"] = oneSpec:format(BC["Shaman"], BTT["Enhancement"]),
	["ShamanResto"] = oneSpec:format(BC["Shaman"], BTT["Restoration"]),
	["DruidBalance"] = oneSpec:format(BC["Druid"], BTT["Balance"]),
	["DruidResto"] = oneSpec:format(BC["Druid"], BTT["Restoration"]),
	["PriestDPS"] = oneSpec:format(BC["Priest"], BTT["Shadow"]),
	["PriestHeal"] = oneSpec:format(BC["Priest"], BTT["Holy"]),
	
	-- Bosses that aren't bosses!
	["Dust Covered Chest"] = "Chess Event",
	["Cache of the Firelord"] = "Majordomo Executus",
	["Four Horsemen Chest"] = "The Four Horsemen"
}
