
ClassColors = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0")
-- embedded libs
local dewdrop = AceLibrary("Dewdrop-2.0")

function ExtractColor(stColor)
	return stColor.r, stColor.g, stColor.b;
end	

function SetColor(stColor,r,g,b)
	stColor.r = r;
	stColor.g = g;
	stColor.b = b;
end

function ClassColors:OnInitialize()
	local defaults = {
		DruidColor = RAID_CLASS_COLORS["DRUID"],
		HunterColor = RAID_CLASS_COLORS["HUNTER"],
		MageColor = RAID_CLASS_COLORS["MAGE"],
		PaladinColor = RAID_CLASS_COLORS["PALADIN"],
		PriestColor = RAID_CLASS_COLORS["PRIEST"],
		RogueColor = RAID_CLASS_COLORS["ROGUE"],
		ShamanColor = RAID_CLASS_COLORS["SHAMAN"],
		WarlockColor = RAID_CLASS_COLORS["WARLOCK"],
		WarriorColor = RAID_CLASS_COLORS["WARRIOR"],
	}

	local MenuOptions = {
		type = "group",
		args = {
			Druid = {
				name = "Druid",
				desc = "Druid",
				type = "color",
				get = function() return ExtractColor(self.db.profile.DruidColor) end,
				set = function(r, g, b) SetColor(self.db.profile.DruidColor,r,g,b) end,
			},
			Hunter = {
				name = "Hunter",
				desc = "Hunter",
				type = "color",
				get = function() return ExtractColor(self.db.profile.HunterColor) end,
				set = function(r, g, b) SetColor(self.db.profile.HunterColor,r,g,b) end,
			},
			Mage = {
				name = "Mage",
				desc = "Mage",
				type = "color",
				get = function() return ExtractColor(self.db.profile.MageColor) end,
				set = function(r, g, b) SetColor(self.db.profile.MageColor,r,g,b) end,
			},
			Paladin = {
				name = "Paladin",
				desc = "Paladin",
				type = "color",
				get = function() return ExtractColor(self.db.profile.PaladinColor) end,
				set = function(r, g, b) SetColor(self.db.profile.PaladinColor,r,g,b) end,
			},
			Priest = {
				name = "Priest",
				desc = "Priest",
				type = "color",
				get = function() return ExtractColor(self.db.profile.PriestColor) end,
				set = function(r, g, b) SetColor(self.db.profile.PriestColor,r,g,b) end,
			},
			Rogue = {
				name = "Rogue",
				desc = "Rogue",
				type = "color",
				get = function() return ExtractColor(self.db.profile.RogueColor) end,
				set = function(r, g, b) SetColor(self.db.profile.RogueColor,r,g,b) end,
			},
			Shaman = {
				name = "Shaman",
				desc = "Shaman",
				type = "color",
				get = function() return ExtractColor(self.db.profile.ShamanColor) end,
				set = function(r, g, b) SetColor(self.db.profile.ShamanColor,r,g,b) end,
			},
			Warlock = {
				name = "Warlock",
				desc = "Warlock",
				type = "color",
				get = function() return ExtractColor(self.db.profile.WarlockColor) end,
				set = function(r, g, b) SetColor(self.db.profile.WarlockColor,r,g,b) end,
			},
			Warrior = {
				name = "Warrior",
				desc = "Warrior",
				type = "color",
				get = function() return ExtractColor(self.db.profile.WarriorColor) end,
				set = function(r, g, b) SetColor(self.db.profile.WarriorColor,r,g,b) end,
			},
		}
	}

	local options = {
		type = "group",
		args = { }
	}

	options.args.config = {
		name = "Config", desc="Show Configuration Menu", type = "execute", guiHidden = true,
		func =  function()
		dewdrop:Open(UIParent, 'children', function() dewdrop:FeedAceOptionsTable(MenuOptions) end,'cursorX', true, 'cursorY', true) end,
	}

	ClassColors:RegisterDB("ClassColorsDB")
	ClassColors:RegisterDefaults('profile', defaults)
	ClassColors:RegisterChatCommand({'/classcolors','/cc'}, options)
end

function ClassColors:OnEnable()
	RAID_CLASS_COLORS["DRUID"] = self.db.profile.DruidColor;
	RAID_CLASS_COLORS["HUNTER"] = self.db.profile.HunterColor;
	RAID_CLASS_COLORS["MAGE"] = self.db.profile.MageColor;
	RAID_CLASS_COLORS["PALADIN"] = self.db.profile.PaladinColor;
	RAID_CLASS_COLORS["PRIEST"] = self.db.profile.PriestColor;
	RAID_CLASS_COLORS["ROGUE"] = self.db.profile.RogueColor;
	RAID_CLASS_COLORS["SHAMAN"] = self.db.profile.ShamanColor;
	RAID_CLASS_COLORS["WARLOCK"] = self.db.profile.WarlockColor;
	RAID_CLASS_COLORS["WARRIOR"] = self.db.profile.WarriorColor;
end