local L = LibStub("AceLocale-3.0"):GetLocale("Chinon")
-- Un bouton servant aux soins

function SoinBouton_SetTexte(self, pos)
	self.prio:SetText(pos);
end

function SoinBouton_OnUpdate(self)
	local unit=self:GetAttribute("unit");
	local cfgBouton = self.cfgBouton;
	
	if (cfgBouton == nil) then
		return;
	end
	
	if (not UnitExists(unit) or UnitIsDeadOrGhost(unit)) then
		self.vie:Hide();
		self.barreSoin:Hide();
		self.barreDegats:Hide();
		for i,aPortee in pairs(self.aPortee) do
			aPortee:Hide();
		end
		
		for i,debuff in pairs(self.debuff) do		
			debuff:Hide();
		end
		self.aggro:Hide();
		return;
	end
	
	self.vie:Show();
	
	if (cfgBouton.vie and UnitHealthMax(unit) and UnitHealthMax(unit)>0) then
		local rapport=UnitHealth(unit)/UnitHealthMax(unit);
		if (rapport>0.9) then
			self.vie:SetTexture(0,0.5,0);
		elseif (rapport>0.5) then
			self.vie:SetTexture(0.5,0.75,0);
		elseif (rapport>0.1) then
			self.vie:SetTexture(0.5,0,0);
		else
			self.vie:SetTexture(1,0,0);
		end
		if (rapport>1) then
			rapport=1;
		end
		self.vie:SetWidth(rapport*self:GetWidth());

		if (self.soin>0) then
			local rapport = self.soin/UnitHealthMax(unit)
			if (rapport>1) then
				rapport=1
			end
			
			self.barreSoin:SetWidth(self:GetWidth()*rapport)
			self.barreSoin:Show()
		else
			self.barreSoin:Hide();
		end
		
		if (SoinFrame.totalDegats[unit] and SoinFrame.totalDegats[unit]>0) then
			local rapport = SoinFrame.totalDegats[unit]/UnitHealthMax(unit)
			if (rapport>1) then
				rapport=1
			end
			self.barreDegats:SetWidth(self:GetWidth()*rapport)
			self.barreDegats:Show()
		else
			self.barreDegats:Hide();
		end
	else
		self.vie:Hide();
		self.barreSoin:Hide();
		self.barreDegats:Hide()
	end

	if (cfgBouton.aggro) then
		if (UnitIsUnit(unit,unit.."targettarget")) then
			self.aggro:Show();
		else
			self.aggro:Hide()
		end
	else
		self.aggro:Hide();
	end

	-- portée
	
	for i, portee in pairs(self.aPortee) do
		portee:Hide();
	end
		
	for i, portee in pairs(cfgBouton.portee) do
		if (portee.sort and IsSpellInRange(GetSpellInfo(portee.sort),unit)==1) then
			self.aPortee[i]:Show();
		end
	end
	
	-- Buffs
	for i in ipairs(cfgBouton.buff) do
		self.buffStacks[i]:Hide()
		self.buff[i]:Hide()
	end
	
	local nbBuffs=0
	
	if (#cfgBouton.buff) then
		local i=1;
		while 1 do
			local name, rank, iconTexture, count, duration, timeLeft =  UnitBuff(unit, i, true);
			if (not name) then
				break;
			end
			if (cfgBouton.sortBuff[name] and timeLeft~=nil) then
				nbBuffs=nbBuffs+1
				self.buff[nbBuffs]:Show();
				self.buff[nbBuffs]:SetTexture(iconTexture);
				self.buffStacks[nbBuffs]:Show();
				if (count==0) then
					count=1
				end
				self.buffStacks[nbBuffs]:SetText(count);
				if (timeLeft<2) then
					self.buffStacks[nbBuffs]:SetTextColor(1,0,0);
				else
					self.buffStacks[nbBuffs]:SetTextColor(1,1,1);
				end
			end
			i=i+1;
		end
	end
	

	-- Debuffs	
	if (#cfgBouton.debuff) then
	--	for k,v in pairs(self.isDebuff) do
	--		self.isDebuff[k]=nil
	--	end
	--	for k,v in pairs(self.debufLevel) do
	--		self.debufLevel[k] = nil
	--	end
		
		for i, debuff in pairs(cfgBouton.debuff) do
			self.isDebuff[i] = false;
			self.debufLevel[i] = 0;
		end
		
		local i=1;
		while 1 do
			local debuffName, debuffRank, debuffTexture, debuffApplications, debuffType=UnitDebuff(unit,i);
			if (not debuffName) then
				break;
			end
			
			local typeDebuff = 0;
			
			if (cfgBouton.sortDebuff[debuffName]~= nil) then
				typeDebuff = cfgBouton.sortDebuff[debuffName];
				self.isDebuff[typeDebuff] = true;
			end
				
			if (cfgBouton.sortDebuff[debuffType]~= nil) then
				typeDebuff = cfgBouton.sortDebuff[debuffType];
				self.isDebuff[typeDebuff] = true;
			end

			if (typeDebuff>0) then
				if (Chinon.decurseLevel[debuffName] and Chinon.decurseLevel[debuffName]>self.debufLevel[typeDebuff]) then
					self.debufLevel[typeDebuff] = Chinon.decurseLevel[debuffName];
				end

				if (Chinon.decurseLevel[debuffType] and Chinon.decurseLevel[debuffType]>self.debufLevel[typeDebuff]) then
					self.debufLevel[typeDebuff] = Chinon.decurseLevel[debuffType];
				end
			end
			
			i=i+1;
		end

		for i, debuff in pairs(self.debuff) do
			debuff:Hide()
		end
		
		for i, debuff in pairs(cfgBouton.debuff) do
			if (self.isDebuff[i]) then
				if (cfgBouton.porteeDebuff[i] and IsSpellInRange(cfgBouton.porteeDebuff[i],unit)==1) then
					if (self.debufLevel[i]==2) then
						self.debuff[i]:SetTexture(1.0,0.0,0.0);
					elseif (self.debufLevel[i]==1) then
						self.debuff[i]:SetTexture(1.0,1.0,0.0);
					else
						self.debuff[i]:SetTexture(0.2,0.2,1.0);
					end
				else
					self.debuff[i]:SetTexture(0.2,0.2,0.2);
				end
				self.debuff[i]:Show();
			end
		end
	end
end

function SoinBouton_OnLoad(self)
end

function SoinBouton_Init(self)
	self.Configure = SoinBouton_Configure;
	self.OnUpdate = SoinBouton_OnUpdate;
	self.SetTexte = SoinBouton_SetTexte;
	self.AddSpell = SoinBouton_AddSort;
	self.OnEnter = SoinBouton_OnEnter;
	self.OnLeave = SoinBouton_OnLeave;
	self.isDebuff = {}
	self.debufLevel = {}
end

function SoinBouton_Configure(self, cfgBouton)
	self.cfgBouton = cfgBouton;
          	
	self:SetWidth(Chinon.apparence.largeurBouton);
	self:SetHeight(Chinon.apparence.hauteurBouton);
	self:RegisterForClicks("AnyUp");

	if (not self.vie) then
		self.vie = self:CreateTexture();
	end
	self.vie:SetDrawLayer("ARTWORK");
	self.vie:SetPoint("TOPLEFT");
	self.vie:SetHeight(self:GetHeight()/2);
	self.vie:SetTexture(1,0,0);
	
	if (not self.barreSoin) then
		self.barreSoin = self:CreateTexture();
	end
	self.barreSoin:SetDrawLayer("OVERLAY")
	self.barreSoin:SetPoint("TOPRIGHT")
	self.barreSoin:SetWidth(0)
	self.barreSoin:SetHeight(self:GetHeight()/4)
	self.barreSoin:SetTexture(0,0.2,0.8)
	self.soin = 0

	if (not self.barreDegats) then
		self.barreDegats = self:CreateTexture();
	end
	self.barreDegats:SetDrawLayer("OVERLAY")
	self.barreDegats:SetPoint("TOPLEFT",0,-self:GetHeight()/4)
	self.barreDegats:SetWidth(0)
	self.barreDegats:SetHeight(self:GetHeight()/6)
	self.barreDegats:SetTexture(1,0,0)
	
	if (not self.aggro) then
		self.aggro = self:CreateTexture();
	end
	self.aggro:SetPoint("TOPLEFT",self:GetWidth()/2-self:GetWidth()/8+2, -self:GetHeight()/2+self:GetHeight()/4-2);
	self.aggro:SetHeight(self:GetHeight()/2-4);
	self.aggro:SetWidth(self:GetWidth()/4-4);
	self.aggro:SetTexture(1,0,0);
	
	if (self.aPortee) then
		--for i, portee in pairs(self.aPortee) do
		--	portee:Hide();
		--end
	else
		self.aPortee = {};
	end		
	
	for i, portee in ipairs(cfgBouton.portee) do
		if (not self.aPortee[i]) then
			self.aPortee[i] = self:CreateTexture();
		end
		self.aPortee[i]:SetPoint("TOPLEFT",2+self:GetWidth()/4*(i-1),-self:GetHeight()/2-2);
		self.aPortee[i]:SetHeight(self:GetHeight()/2-4);
		self.aPortee[i]:SetWidth(self:GetWidth()/4-4);
		self.aPortee[i]:SetTexture(0,0,1);
	end
	
	--[[if (self.debuff) then
		for i, debuff in pairs(self.debuff) do
			self.debuff[i]:Hide();
		end
	else
		self.debuff = {};
	end]]
	if (not self.debuff) then
		self.debuff = {}
	end
	
	local largeurDebuff = Chinon.apparence.largeurBouton / #cfgBouton.debuff;
	for i, debuff in ipairs(cfgBouton.debuff) do
		if (not self.debuff[i]) then
			self.debuff[i] = self:CreateTexture();
		end
		self.debuff[i]:SetDrawLayer("BORDER");
		self.debuff[i]:SetPoint("TOPLEFT",largeurDebuff*(i-1),0);
		self.debuff[i]:SetHeight(self:GetHeight());
		self.debuff[i]:SetWidth(largeurDebuff);
		self.debuff[i]:SetTexture(0,0,0);
	end

	if (not self.prio) then
		self.prio = self:CreateFontString(nil, "OVERLAY");
	end
	self.prio:SetFontObject("GameFontNormal");
	self.prio:SetAllPoints(self);
	self.prio:SetText("");
	self.prio:SetTextColor(1,1,1);
	
	if (not self.buff) then
		self.buff = {}
	end
	
	local largeurBuff = Chinon.apparence.hauteurBouton / 2
		
	for i, buff in ipairs(cfgBouton.buff) do
		if (not self.buff[i]) then
			self.buff[i] = self:CreateTexture();
		end
		self.buff[i]:SetDrawLayer("BORDER");
		self.buff[i]:SetPoint("BOTTOMRIGHT",-largeurBuff*(i-1),0);
		self.buff[i]:SetHeight(largeurBuff);
		self.buff[i]:SetWidth(largeurBuff);
		self.buff[i]:SetAlpha(0.25);
	end
	
	if (not self.buffStacks) then
		self.buffStacks = {}
	end
	
	for i, buff  in ipairs(cfgBouton.buff) do
		if (not self.buffStacks[i]) then
			self.buffStacks[i] = self:CreateFontString(nil, "OVERLAY");
		end
		self.buffStacks[i]:SetFontObject("GameFontNormal");
		self.buffStacks[i]:SetPoint("BOTTOMRIGHT",-largeurBuff*(i-0.5),0);
		self.buffStacks[i]:SetText("");
		self.buffStacks[i]:SetTextColor(1,1,1);
		self.buffStacks[i]:Hide();
	end
	      
--     self:SetBackdrop({
  --      edgeFile = "Interface\\AddOns\\Chinon\\Texture\\SoinBouton", edgeSize = 16,
	--	insets = {left = 4, right = 4, top = 4, bottom = 4},
	--})
	
	if (not self.contour) then
		self.contour = CreateFrame("Frame", nil, self);
	end
	self.contour:SetAllPoints(self);
--	self.overlay:SetBackdrop({
  --      edgeFile = "Interface\\ChatFrame\\ChatFrameBackground", edgeSize = 1,
    --    insets = {left = 0, right = 0, top = 0, bottom = 0},
      --})
    self.contour:SetBackdrop({
		--bgFile = "Interface\\AddOns\\Chinon\\Texture\\SoinBoutonBg",
        edgeFile = "Interface\\AddOns\\Chinon\\Texture\\SoinBouton", edgeSize = 8,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
	})
       self.contour:SetWidth(Chinon.apparence.largeurBouton);
	self.contour:SetHeight(Chinon.apparence.hauteurBouton);                                  
	
  --  self.contour:SetBackdropBorderColor(1,1,1,0)
    self.contour:Show()
    
end

function SoinBouton_AddSort(self, sort, cible)
	
	if (sort~=nil and (sort.sort~=nil or sort.macro~=nil)) then
		local modifieur = "";
		if (sort.alt) then
			modifieur = modifieur.."alt-"
		end
		if (sort.ctrl) then
			modifieur = modifieur.."ctrl-"
		end
		if (sort.shift) then
			modifieur = modifieur.."shift-"
		end
		self:SetAttribute(modifieur.."type"..sort.bouton,"macro");
		local macro;
		if (sort.macro and sort.macro~="") then
			macro = sort.macro
		else
			local nom = GetSpellInfo(sort.sort);
			if (nom == nil) then
				DEFAULT_CHAT_FRAME:AddMessage("Impossible de trouver le sort "..sort.sort);
			end
			if (sort.rangInferieur and sort.rang) then
				nom = nom .. "(" .. sort.rang .. ")"		
			end
			macro = "/cast [target="..cible.."] "..nom;
		end
		self:SetAttribute(modifieur.."macrotext"..sort.bouton,macro);
	end
end

function SoinBouton_OnEnter(self)
	GameTooltip:SetOwner(this, "ANCHOR_LEFT");
	local cible=self:GetAttribute("unit")
	local nom=UnitName(cible);
	if (not nom) then
		nom="Unité inconnue";
	end
	local i=1;
	while 1 do
		local debuffName, debuffRank, debuffTexture, debuffApplications, 
				debuffType=UnitDebuff(cible,i);
		if (not debuffName) then
			break;
		end
		local warn=false;
		
		if (Chinon.decurseLevel[debuffName]==2) then
			warn=true;
		end
		nom=nom.."\n"
		if (warn) then
			nom=nom.."|cffff0000"..debuffName.."|cffffffff";
		else
			nom=nom..debuffName;
		end
		if (debuffType) then
			nom=nom.."("..debuffType..")";
		end
		if (debuffApplications>0) then
			nom=nom.." x"..debuffApplications;
		end
		i=i+1;
	end
	GameTooltip:SetText("|cffffffff"..nom);
end

function SoinBouton_OnLeave(self)
	GameTooltip:Hide();
end

