﻿local L = LibStub("AceLocale-3.0"):GetLocale("Chinon")
local CLASSE_NOM={"SHAMAN","HUNTER","WARLOCK","DRUID","WARRIOR","MAGE","PALADIN","PRIEST","ROGUE"};
local CLASSE_NUM={};
local CLASSE_ABR={"Cm","Cs","Dé","Dr","Gu","Ma","Pa","Pr","Vo"}
local plop={};
local ancienClassement={};
-- local attention={};
local maxX=0;
local maxY=0;
local nombreElements={};

local boutonMarge = 4;
local boutonEspace = 1;
local boutonTop = 20;

for i=1,9 do
	CLASSE_NUM[CLASSE_NOM[i]]=i;
end

--[[Ajoute un nouveau bouton
\param y La ligne à laquelle ajouter le bouton
\param cfgBouton La configuration du bouton]]
function SoinFrame:AjouterBouton(cible, y, cfgBouton)
	local nom = "bouton"..cible;
	
	nom = nom .. "_" .. cfgBouton.nom;
	
	local h=self.boutons[nom];
	if (not h) then
		h=CreateFrame("Button",nil,self,"SoinBouton");
		SoinBouton_Init(h)
		self.boutons[nom]=h;
	end
	
	for i, sort in pairs(cfgBouton.clic) do
		SoinBouton_AddSort(h, sort, cible);
	end
	
	h:Configure(cfgBouton);
	h:SetAttribute("unit",cible);

	
	local x = nombreElements[y]
	if (not x) then
		x=0
	end
	nombreElements[y] = x+1
		
	local left = x*(Chinon.apparence.largeurBouton+boutonEspace)+boutonMarge;
	local top = y*(Chinon.apparence.hauteurBouton+boutonEspace)+boutonTop;
	if (left>maxX) then
		maxX=left;
	end
	if (top>maxY) then
		maxY=top;
	end
	h:SetPoint("TOPLEFT", self, "TOPLEFT", left, -top);
	h:Show();
end

--[[A appeler pour initialiser la frame ]]
function SoinFrame:Load()
	if (Chinon.cfgBoutons == nil) then
		self:Hide();
		return;
	end

	self:SetBackdrop({
        edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
    })    
    
	self.degats = {}
	self.totalDegats = {}
	self.boutons = {}
	
	for sort,niveau in pairs(chinonCouleurDebuff) do
		local nom = GetSpellInfo(sort);
		Chinon.decurseLevel[nom] = niveau;
	end

	self.labelLigne={};
	
	for i=1,10 do
		self.labelLigne[i]=self:CreateFontString(nil);
		self.labelLigne[i]:SetFontObject("GameFontNormal");
		self.labelLigne[i]:SetPoint("TOPRIGHT",self,"TOPLEFT",0,
			i*-(boutonEspace+Chinon.apparence.hauteurBouton) -18);
		self.labelLigne[i]:SetText("");
		self.labelLigne[i]:SetTextColor(1,1,1);
		self.labelLigne[i]:Hide();
	end
	
	self:RegisterEvent("PARTY_MEMBERS_CHANGED");
	self:RegisterEvent("PARTY_MEMBER_ENABLE");
	self:RegisterEvent("PARTY_MEMBER_DISABLE");
	self:RegisterEvent("RAID_ROSTER_UPDATE");
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	self:RegisterEvent("UNIT_COMBAT");
	self:RegisterEvent("UNIT_PET");

	self:Update(self);
end

function SoinFrame:OnMouseDown(button)
	if ( not self.enCombat and button == "LeftButton") then
		self:StartMoving();
	end
end

function SoinFrame:OnMouseUp(button)
	if ( button == "LeftButton" ) then	
		self:StopMovingOrSizing();
	end
end

-- Recrée les boutons dans le cas d'un groupe
function SoinFrame:UpdateParty()
	for i=1,GetNumPartyMembers() do
		self.labelLigne[i]:Show();
		self.labelLigne[i]:SetText(UnitName("party"..i));
		for j, cfgBouton in ipairs(Chinon.cfgBoutons) do
			if (cfgBouton.groupe) then
				self:AjouterBouton("party"..i,i,cfgBouton);
			end
		end
		if (UnitExists("partypet"..i)) then
			local pet = i+GetNumPartyMembers()
			for j, cfgBouton in ipairs(Chinon.cfgBoutons) do
				if (cfgBouton.groupe) then
					self:AjouterBouton("partypet"..i,pet,cfgBouton);
					self.labelLigne[pet]:Show()
					self.labelLigne[pet]:SetText(UnitName("partypet"..i))
				end
			end
		end
	end
end

-- Recrée les boutons dans le cas d'un raid de
-- 5 joueurs ou moins (arène)
function SoinFrame:UpdateArena()
	for i=1,GetNumRaidMembers() do
		local raidId = "raid"..i;
		local raidPetId= "raidpet"..i;
		local name, rank, subgroup, level, class, fileName, zone, online, isDead = GetRaidRosterInfo(i);
		self.labelLigne[i]:Show();
		self.labelLigne[i]:SetText(name);
		for k, cfgBouton in ipairs(Chinon.cfgBoutons) do
			if (cfgBouton.arene) then
				self:AjouterBouton(raidId,i,cfgBouton);
			end
		end
		if (UnitExists(raidPetId)) then
			local j = i+GetNumRaidMembers();
			self.labelLigne[j]:Show();
			self.labelLigne[j]:SetText(UnitName(raidPetId));
			for k, cfgBouton in ipairs(Chinon.cfgBoutons) do
				if (cfgBouton.arene) then
					self:AjouterBouton(raidPetId,j,cfgBouton);
				end
			end
		end
	end
end

-- Recrée les boutons en raid
function SoinFrame:UpdateRaid()
	local sortClasse;
	if (Chinon.apparence.classerParGroupe) then
		sortClasse=false;
	else
		sortClasse=true;
	end

	for i=1,GetNumRaidMembers() do
		local name, rank, subgroup, level, class, fileName, zone, online, isDead = GetRaidRosterInfo(i);
		local ligne

		if (subgroup and fileName) then
			if (sortClasse) then
				ligne=CLASSE_NUM[fileName];
			else
				ligne = subgroup;
			end
			for k, cfgBouton in ipairs(Chinon.cfgBoutons) do
				if (cfgBouton.raid) then
					self:AjouterBouton("raid"..i, ligne, cfgBouton);
				end
			end
			if (UnitExists("raidpet"..i)) then
				for k, cfgBouton in ipairs(Chinon.cfgBoutons) do
					if (cfgBouton.raid) then
						self:AjouterBouton("raidpet"..i, 10, cfgBouton);
						break
					end
				end
			end
		end
	end
	if (sortClasse) then
		for i=1,10 do
			if (nombreElements[i] and nombreElements[i]>0) then
				if (i==10) then
					self.labelLigne[i]:SetText(L["Familier"]);
				else
					self.labelLigne[i]:SetText(L[CLASSE_ABR[i]]);
				end
				self.labelLigne[i]:Show();
			end
		end
	else
		for i=1,10 do
			if (nombreElements[i] and nombreElements[i]>0) then
				if (i==10) then
					self.labelLigne[i]:SetText(L["Familier"]);
				else
					self.labelLigne[i]:SetText(i);
				end
				self.labelLigne[i]:Show();
			end
		end
	end
end

-- Recrée les boutons
function SoinFrame:Update()
	local i=1;
	
	if (not self.boutons) then
		return;
	end

	for i, bouton in pairs(Chinon.cfgBoutons) do
		Chinon:UpdateDebuffsBouton(bouton);
		Chinon:UpdateBuffsBouton(bouton) 
	end
	
	for i, bouton in pairs(self.boutons) do
		bouton:Hide();
	end
	
	for i, label in pairs(self.labelLigne) do
		label:SetPoint("TOPRIGHT",self,"TOPLEFT",0,i*-(boutonEspace+Chinon.apparence.hauteurBouton) -18);
		label:Hide()
	end
	
	nombreElements={}
	
	maxX = 3*(Chinon.apparence.largeurBouton+boutonEspace)+boutonMarge;
	maxY = boutonTop;
	
	-- Quatre boutons de base
	if (Chinon.cfgBoutons[1]) then
		self:AjouterBouton("player",0,Chinon.cfgBoutons[1]);
		self:AjouterBouton("target",0,Chinon.cfgBoutons[1]);
		self:AjouterBouton("targettarget",0,Chinon.cfgBoutons[1]);
		self:AjouterBouton("focus",0,Chinon.cfgBoutons[1]);
	end

	if (GetNumRaidMembers()>5) then
		self:UpdateRaid();
	elseif (GetNumRaidMembers()>0) then
		self:UpdateArena();
	else
		self:UpdateParty();
	end
	
	-- On redimentionne le fond de la fenêtre pour
	-- englober tous les boutons
	self:SetWidth(maxX+boutonMarge+Chinon.apparence.largeurBouton);
	self:SetHeight(maxY+boutonMarge+Chinon.apparence.hauteurBouton);
end

function SoinFrame:OnEvent(event)
	if (event == "PLAYER_REGEN_DISABLED") then
		self.enCombat=true;
		self:StopMovingOrSizing();
	end
	if (event == "PLAYER_REGEN_ENABLED") then
		self.enCombat=false;
		self:Update();
	end 
	if (event == "PARTY_MEMBERS_CHANGED" or event == "PARTY_MEMBER_ENABLE"
		or event == "PARTY_MEMBER_DISABLE" or event == "RAID_ROSTER_UPDATE"
		or event=="UNIT_PET") then
		if (not self.enCombat) then
			self:Update();
		end	
	end

	if (event == "UNIT_COMBAT") then
		if (UnitIsFriend("player",arg1)) then
			if (not self.degats[arg1]) then
				self.degats[arg1]={};
			end
			local time=GetTime();
			local valeur;
			if (arg2 == "HEAL") then
				valeur=0
			else
				valeur=arg4;
			end
			
			if (not self.degats[arg1][time]) then
				self.degats[arg1][time]=valeur;
			else
				self.degats[arg1][time]=self.degats[arg1][time]+valeur;
			end
		end
	end
end

function SoinFrame:SetSoin(cible, combien)
	for i, bouton in pairs(self.boutons) do
		local target = bouton:GetAttribute("unit")
		local name, realm = UnitName(target)
		if (realm) then
			name = name..'-'..realm
		end
		if (name == cible) then
			bouton.soin = bouton.soin + combien
		end
	end
	
end

function SoinFrame:OnUpdate()
	local t=GetTime();
	
	if (not Chinon.cfgBoutons) then
		return;
	end
	
	-- local spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo("target");
	-- if (attention[spell]) then
	--	SoinFrame_Info:SetText(spell);
	-- else
	--	SoinFrame_Info:SetText("");
	-- end
	
	for cible,tab in pairs(self.degats) do
		local perdu=0;
		for temps,valeur in pairs(tab) do
			if (temps<t-4) then
				tab[temps]=nil;
			else
				perdu=perdu+valeur;
			end
		end
		self.totalDegats[cible] = perdu
	end
end

