local L = LibStub("AceLocale-3.0"):GetLocale("Chinon")

chinonOptionsInterface = 
{ 
    type='group',
    args = 
    {
		apparence =
		{
			type='group',
			name=L['Apparence'],
			args=
			{
				largeurBouton = 
				{
					type = 'range',
					name = L["Largeur bouttons"],
					desc = L["Change la largeur des boutons."],
					get = function(info) return Chinon.apparence.largeurBouton end,
					set = function(info,v) Chinon.apparence.largeurBouton = v; SoinFrame:Update() end,
					min = 16,
					max = 64,
					step = 1
				},
				hauteurBouton =
				{
					type = 'range',
					name = L["Hauteur bouttons"],
					desc = L["Change la hauteur des boutons."],
					get = function(info) return Chinon.apparence.hauteurBouton end,
					set = function(info,v) Chinon.apparence.hauteurBouton = v; SoinFrame:Update() end,
					min = 16,
					max = 64,
					step = 1
				},
				classerParGroupe =
				{
					type = 'toggle',
					name = L["Classer par groupe"],
					desc = L["En affichage de raid, classer les joueurs par groupe"],
					get = function(info) return Chinon.apparence.classerParGroupe end,
					set = function(info,v) Chinon.apparence.classerParGroupe=v;SoinFrame:Update() end
				}
			}
		},
		boutons =
		{
			type='group',
			name=L['Boutons'],
		}
	}
};

chinonDefautArgsBouton=
{
	nom =
	{
		order=  0,
		type = "input",
		name = L["Nom du bouton"],
		get = function(info) return Chinon.apparence.nomNouveauBouton end,
		set = function(info, v) Chinon.apparence.nomNouveauBouton = v end
	},
	ajouter =
	{
		order = 1,
		type = "execute",
		name = L["Ajouter"],
		func = function(input)
			if (Chinon.apparence.nomNouveauBouton and not chinonOptionsInterface.args.boutons.args[Chinon.apparence.nomNouveauBouton]) then
				local nouveauBouton = { nom = Chinon.apparence.nomNouveauBouton, arene=true, groupe=true, raid=true }
				Chinon.cfgBoutons[#Chinon.cfgBoutons+1] = nouveauBouton
				Chinon:AjouterOptionsBouton(nouveauBouton)
				SoinFrame:Update()
			end
		end
	}
}
