local L = LibStub("AceLocale-3.0"):GetLocale("Chinon")

Chinon = LibStub("AceAddon-3.0"):NewAddon("Chinon", "AceEvent-3.0", "AceConsole-3.0")
Chinon.decurseLevel = {}

function Chinon:CreerListeSorts()
	local sorts = {};
	local name, texture, offset, numSpells = GetSpellTabInfo(1);
	local i=numSpells+1;
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			break
		end
		-- DEFAULT_CHAT_FRAME:AddMessage(spellName);
		local nom = spellName;
		local a, b, numeroRang = string.find(spellRank, "(%d+)");
		if (not numeroRang or tonumber(numeroRang)==1) then
			sorts[nom] = nom;
		else
		end
		i = i+1;
	end
	-- TODO : ne pas remplacer
	self.sorts = sorts;
end

function GetSpellInfoOrNil(spell)
	if (spell) then
		return GetSpellInfo(spell)
	else
		return nil
	end
end

function Chinon:CreerListeDebuffs()
	self.debuffs = {}
	self.debuffs["Disease"] = L["Maladie"];
	self.debuffs["Poison"] = L["Poison"];
	self.debuffs["Magic"] = L["Magie"];
	self.debuffs["Curse"] = L["Malédiction"];
	self.debuffs["Lent"] = L["Ralentissement"];
	self.debuffs["Mortel"] = L["Réduction des soins"];
end

function Chinon:CreerListeRangs(nomSort)
	local listeRangs = {}
	local name, texture, offset, numSpells = GetSpellTabInfo(1);
	local i = numSpells +1;
	while true do
		local spellName, spellRank = GetSpellName(i, BOOKTYPE_SPELL)
		if not spellName then
			break
		end
		if (spellName == nomSort) then
			listeRangs[spellRank] = spellRank;
		end
		i = i+1;
	end
	return listeRangs;
end

function Chinon:CreerListeModifieurs()
	if (not self.listeModifieurs) then
		self.listeModifieurs = {}
		self.listeModifieurs["alt"] = L["Alt"]
		self.listeModifieurs["ctrl"] = L["Ctrl"]
		self.listeModifieurs["shift"] = L["Maj"]
	end
end

function Chinon:CreerListeVisibilites()
	self.listeVisibilite = {}
	self.listeVisibilite["groupe"] = L["Groupe"]
	self.listeVisibilite["arene"] = L["Arène"]
	self.listeVisibilite["raid"] = L["Raid"]
end

function Chinon:GetSpellIdByName(name)
	local link = GetSpellLink(name);
	if (not link) then
		DEFAULT_CHAT_FRAME:AddMessage(name.." introuvable");
		return name;
	end
	local a, b, spellId = string.find(link, "spell:(%d+)");
	return tonumber(spellId);
end

function DupliquerTable(table)
	local n = {}
	for k,v in pairs(table) do
		if (type(v)=="table") then
			n[k] = DupliquerTable(v)
		else
			n[k] = v
		end
	end
	return n
end

function Chinon:HandleProfileChanges()
	self.apparence = self.db.profile.apparence
	self.cfgBoutons = self.db.profile.cfgBoutons
	if (not self.cfgBoutons) then
		self.db.profile.cfgBoutons = DupliquerTable(self.defautBouton)
		self.cfgBoutons = self.db.profile.cfgBoutons
	end
	if (self.init) then
		self:ChargerOptions()
		SoinFrame:Update()
	end
end

function Chinon:OnInitialize()
	
	self.init = false;

	
	self.AceConfig = LibStub("AceConfig-3.0");
	self.AceConfigDialog = LibStub("AceConfigDialog-3.0");
	self.AceConfig:RegisterOptionsTable("Chinon", chinonOptionsInterface, "Chinon")

	self.db = LibStub("AceDB-3.0"):New("ChinonDB",
	{
		profile = 
		{
			apparence = chinonDefautApparence,
		}
	})
	self.db.RegisterCallback( self, "OnNewProfile", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileReset", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileChanged", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileCopied", "HandleProfileChanges" )
	
	
	self.optFrame = self.AceConfigDialog:AddToBlizOptions("Chinon", "Chinon")
	
	chinonOptionsInterface.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	
	self.HealComm = LibStub:GetLibrary("LibHealComm-3.0");
	
end

function Chinon:HealComm_DirectHealStart(event, healerName, healSize, endTime, ...)
    for i=1,select('#', ...) do
        local targetName = select(i, ...);
        SoinFrame:SetSoin(targetName, healSize);
    end
end

function Chinon:HealComm_DirectHealStop(event, healerName, healSize, endTime, ...)
    for i=1,select('#', ...) do
        local targetName = select(i, ...);
        SoinFrame:SetSoin(targetName, -healSize);
    end
end

function Chinon:FirstInit()
	local classe, classeEn = UnitClass("player");
	self.defautBouton = chinonDefautBoutons[classeEn]
	if (not self.defautBouton) then
		self.defautBouton={}
	end
	self.apparence = self.db.profile.apparence
	self.cfgBoutons = self.db.profile.cfgBoutons
	if (not self.cfgBoutons) then
		self.db.profile.self.cfgBoutons = DupliquerTable(self.defautBouton)
		self.cfgBoutons = self.db.profile.cfgBoutons
	end
	self:CreerListeDebuffs();
	self:CreerListeModifieurs();
	self:CreerListeVisibilites()
	self:CreerListeSorts();
	self:ChargerOptions();
	SoinFrame:Load()
	SoinFrame:Show()
	self.init = true
end

function Chinon:SPELLS_CHANGED()
	self:CreerListeSorts();
	self:ChargerOptions();
end

function Chinon:OnEnable()
	self:RegisterEvent( "SPELLS_CHANGED" )
	self.HealComm.RegisterCallback(self, "HealComm_DirectHealStart");
	self.HealComm.RegisterCallback(self, "HealComm_DirectHealStop")
	if (not self.init) then
		self:FirstInit()
	end
end

function Chinon:OnDisable()
	self:UnregisterEvent("SPELLS_CHANGED" )
	self.HealComm.UnregisterCallback(self, "HealComm_DirectHealStart");
	self.HealComm.UnregisterCallback(self, "HealComm_DirectHealStop")
	SoinFrame:Hide()
end

function Chinon:ValiderNomBouton(nom)
	for i, option in pairs(chinonOptionsInterface.args) do
		if (option.type == "group" and option.name == nom) then
			return false;
		end
	end
	return true;
end

function Chinon:UpdateDebuffsBouton(bouton)
	bouton.sortDebuff = {};
	bouton.porteeDebuff = {};
	for j, debuff in pairs(bouton.debuff) do
		local nom = GetSpellInfoOrNil(debuff.portee);
		bouton.porteeDebuff[j] = nom;
		for sort, actif in pairs(debuff.sorts) do
			if (actif) then
				if (sort == "Lent") then
					for l, spell in pairs(chinonSortsLent) do
						local nom = GetSpellInfo(spell);
						bouton.sortDebuff[nom] = j;
					end
				elseif (sort == "Mortel") then
					for l, spell in pairs(chinonSortsReductionSoin) do
						local nom = GetSpellInfo(spell);
						bouton.sortDebuff[nom] = j;
					end
				else
					bouton.sortDebuff[sort] = j;
				end
			end
		end
	end
end

function Chinon:UpdateBuffsBouton(bouton)
	bouton.sortBuff = {};
	for j, buff in pairs(bouton.buff) do
		local nom = GetSpellInfoOrNil(buff.sort);
		if (nom) then
			bouton.sortBuff[nom] = buff;
		end
	end
end

function Chinon:GetNomClic(config)
	local nomClic="";
	for key, nom in pairs(self.listeModifieurs) do
		if (config[key]) then
			nomClic = nomClic.. nom .." + ";
		end
	end
	nomClic = nomClic..L["bouton "]..config.bouton;
	return nomClic;
end

function Chinon:AjouterOptionsClic(node, i, cfgClic)
	local c;
	local nomClic = self:GetNomClic(cfgClic);
	
	c =
	{
		type = "group",
		name = nomClic,
		args =
		{
			sortilege =
			{
				order = 0,
				type = "select",
				name = L["Sort"],
				values = self.sorts,
				get = function(info) local ret = GetSpellInfoOrNil(cfgClic.sort); return ret end,
				set = function(info, v)
					local sort = Chinon:GetSpellIdByName(v);
					if (sort~=cfgClic.sort) then
						cfgClic.sort = sort;
						cfgClic.rangInferieur = false;
						c.args.rang.disabled = true;
						c.args.rang.values = Chinon:CreerListeRangs(v);
						SoinFrame:Update() 
					end
				end
			},
			rangMax =
			{
				order = 1,
				type = "toggle",
				name = L["Rang le plus élevé"],
				desc = L["Lance le sort du rang le plus élevé disponible"],
				get = function(info) return not cfgClic.rangInferieur end,
				set = function(info, v) 
					c.args.rang.disabled = v;
					cfgClic.rangInferieur = not v;
					SoinFrame:Update() 
				end
			},
			rang =
			{
				order = 2,
				type = "select",
				name = L["Rang du sort"],
				values = Chinon:CreerListeRangs(GetSpellInfoOrNil(cfgClic.sort)),
				get = function(info) return cfgClic.rang end,
				set = function(info, v) cfgClic.rang = v; SoinFrame:Update() end,
				disabled = not cfgClic.rangInferieur
			},
			macro =
			{
				order = 3,
				type = "input",
				name = L["Macro"],
				desc = L["Laissez vide si vous voulez lancer un sort simple"],
				multiline = 4,
				get = function(info) return cfgClic.macro end,
				set = function(info, v) cfgClic.macro = v; SoinFrame:Update() end
			}		
		}
	}
	node[""..i] = c;
end

function EnleverOption(node, i)
	local max=0
	for j, val in pairs(node) do
		if (tonumber(j)) then
			if (tonumber(j)>i) then
				local newName = ""..(tonumber(j)-1)
				node[newName]=val
				val.name = newName
			end
			if (tonumber(j)>max) then
				max = tonumber(j)
			end
		end
	end
	node[""..max]=nil
end

function Chinon:AjouterOptionsDebuff(node, i, cfgDebuff, cfgBouton)
	local c;
	
	c = 
	{
		type = "group",
		name = ""..i,
		args =
		{
			portee =
			{
				type = "select",
				name = L["Sort définissant la portée"],
				values = self.sorts,
				get = function(info) local ret = GetSpellInfoOrNil(cfgDebuff.portee); return ret end,
				set = function(info, v)
					cfgDebuff.portee = Chinon:GetSpellIdByName(v);
					SoinFrame:Update() 
				end
			},
			sorts = 
			{
				type = "multiselect",
				name = L["Affaiblissements"],
				values = self.debuffs,
				get = function(info, clef) return cfgDebuff.sorts[clef] end,
				set = function(info, clef, v) cfgDebuff.sorts[clef] = v; Chinon:UpdateDebuffsBouton(cfgBouton) end
			},
			supprimer =
			{
				type = "execute",
				name = L["Supprimer"],
				desc = L["Supprime l'affichage de cet affaiblissement"],
				func = function()
					table.remove(cfgBouton.debuff, i)
					EnleverOption(node, i)
					Chinon:UpdateDebuffsBouton(cfgBouton)
					SoinFrame:Update()
				end
			}
		}		
	}
	
	node[""..i] = c;
end

function Chinon:AjouterOptionsBuff(node, i, cfgBuff, cfgBouton)
	local c;
	
	c = 
	{
		type = "group",
		name = ""..i,
		args =
		{
			portee =
			{
				type = "select",
				name = L["Amélioration"],
				values = self.sorts,
				get = function(info) local ret = GetSpellInfoOrNil(cfgBuff.sort); return ret end,
				set = function(info, v)
					cfgBuff.sort = Chinon:GetSpellIdByName(v);
					Chinon:UpdateBuffsBouton(cfgBouton) 
				end
			},
			supprimer =
			{
				type = "execute",
				name = L["Supprimer"],
				desc = L["Supprime l'affichage de cette amélioration"],
				func = function()
					table.remove(cfgBouton.buff, i)
					EnleverOption(node, i)
					Chinon:UpdateBuffsBouton(cfgBouton)
					SoinFrame:Update()
				end
			}
		}		
	}
	
	node[""..i] = c;
end

function Chinon:AjouterOptionsPortee(node, i, cfgPortee, cfgBouton)
	local c;
	
	c = 
	{
		type = "group",
		name = ""..i,
		args =
		{
			portee =
			{
				type = "select",
				name = L["Sort"],
				values = self.sorts,
				get = function(info) local ret = GetSpellInfoOrNil(cfgPortee.sort); return ret end,
				set = function(info, v)
					cfgPortee.sort = Chinon:GetSpellIdByName(v);
				end
			},
			supprimer =
			{
				type = "execute",
				name = L["Supprimer"],
				desc = L["Supprime cet indicateur de portée"],
				func = function()
					table.remove(cfgBouton.portee, i)
					EnleverOption(node, i)
					SoinFrame:Update()
				end
			}
		}		
	}
	
	node[""..i] = c;
end

function Chinon:AjouterOptionsBouton(cfgBouton)
	local bt;
	local nouveauClic=
	{
		bouton = 1,
	};
	
	if (not cfgBouton.clic) then
		cfgBouton.clic = {}
	end
	
	if (not cfgBouton.buff) then
		cfgBouton.buff = {}
	end
	
	if (not cfgBouton.portee) then
		cfgBouton.portee = {}
	end
	
	if (not cfgBouton.debuff) then
		cfgBouton.debuff = {}
	end
	
	bt = 
	{
		type = "group",
		name = cfgBouton.nom,
		args =
		{
			nom = 
			{
				order = 0,
				type = 'input',
				name = L["Nom"],
				desc = L["Changer le nom du bouton de sort"],
				get = function(info) return bt.name end,
				set = function(info, v) bt.name=v; end,
				validate = function(info, v) 
					if (v==bt.name) then
						return true;
					else
						return Chinon:ValiderNomBouton(v); 
					end
				end
			},
			visible =
			{
				type = "multiselect",
				name = L["Visibilité"],
				values = self.listeVisibilite,
				get = function(info, key) return cfgBouton[key] end,
				set = function(info, key, v) cfgBouton[key] = v; SoinFrame:Update() end
			},
			vie =
			{
				type = 'toggle',
				name = L["Barre de vie"],
				desc = L["Afficher la barre de vie"],
				get = function(info) return cfgBouton.vie end,
				set = function(info, v) cfgBouton.vie = v end
			},
			aggro =
			{
				type = 'toggle',
				name = L["Aggro"],
				desc = L["Afficher l'indicateur d'aggro"],
				get = function(info) return cfgBouton.aggro end,
				set = function(info, v) cfgBouton.aggro = v end
			},
			clics =
			{
				type = 'group',
				name = L["Clics"],
				desc = L["Assignement des clics sur le bouton"],
				args = 
				{
					bouton =
					{
						order = 0,
						name = L["Bouton"],
						desc = L["Bouton de la souris à enfoncer"],
						type = "select",
						values = {"1","2","3","4","5"},
						get = function(info) return nouveauClic.bouton end,
						set = function(info, v) nouveauClic.bouton = v end
					},
					modifieur =
					{
						order = 1,
						name = L["Touche"],
						desc = L["Touche à enfoncer quand le bouton est pressé"],
						type = "multiselect",
						values = self.listeModifieurs,
						get = function(info, key) return nouveauClic[key] end,
						set = function(info, key, v) nouveauClic[key] = v end
					},					
					ajouter =
					{
						order = 2,
						type = "execute",
						name = L["Ajouter"],
						desc = L["Ajouter un clic de souris"],
						func = function()
							local nom = Chinon:GetNomClic(nouveauClic)
							if (not bt.args.clics.args[nom]) then
								cfgBouton.clic[#cfgBouton.clic+1] =
								{
									bouton = nouveauClic.bouton,
									alt = nouveauClic.alt,
									ctrl = nouveauClic.ctrl,
									shift = nouveauClic.shift
								}
								Chinon:AjouterOptionsClic(bt.args.clics.args, #cfgBouton.clic, 
									cfgBouton.clic[#cfgBouton.clic])
							end
						end
					}
				}
			},
			debuffs = 
			{
				type = 'group',
				name = L['Affaiblissements'],
				desc = L["Afficher des affaiblissement"],
				args = 
				{
					ajouter =
					{
						type = "execute",
						name = L["Ajouter"],
						desc = L["Ajouter l'affichage d'affaiblissements"],
						func = function()
							cfgBouton.debuff[#cfgBouton.debuff+1] = { sorts={} }
							Chinon:AjouterOptionsDebuff(bt.args.debuffs.args, #cfgBouton.debuff,
								cfgBouton.debuff[#cfgBouton.debuff], cfgBouton)
							SoinFrame:Update()
						end
					}
				}
			},
			buffs =
			{
				type = 'group',
				name = L['Améliorations'],
				desc = L['Afficher les amélioriations'],
				args = 
				{
					ajouter = 
					{
						type = "execute",
						name = L["Ajouter"],
						desc = L["Ajouter l'affichage d'une amélioration"],
						func = function()
							cfgBouton.buff[#cfgBouton.buff+1] = {}
							Chinon:AjouterOptionsBuff(bt.args.buffs.args, #cfgBouton.buff,
								cfgBouton.buff[#cfgBouton.buff], cfgBouton)
						end
					}
				}
			},
			portee =
			{
				type = 'group',
				name = L['Portée'],
				desc = L['Afficher un indicateur de portée'],
				args =
				{
					ajouter = 
					{
						type = "execute",
						name = L["Ajouter"],
						desc = L["Ajouter un indicateur de portée"],
						func = function()
							cfgBouton.portee[#cfgBouton.portee+1] = {}
							Chinon:AjouterOptionsPortee(bt.args.portee.args, #cfgBouton.portee,
								cfgBouton.portee[#cfgBouton.portee], cfgBouton)
							SoinFrame:Update()
						end
					}
				}
			}
		}
	};
	
	for i, clic in pairs(cfgBouton.clic) do
		Chinon:AjouterOptionsClic(bt.args.clics.args, i, clic);
	end
	
	for i, debuff in pairs(cfgBouton.debuff) do
		Chinon:AjouterOptionsDebuff(bt.args.debuffs.args, i, debuff, cfgBouton);
	end
	
	for i, cfgBuff in pairs(cfgBouton.buff) do
		Chinon:AjouterOptionsBuff(bt.args.buffs.args, i, cfgBuff, cfgBouton);
	end
	
	for i, portee in pairs(cfgBouton.portee) do
		Chinon:AjouterOptionsPortee(bt.args.portee.args, i, portee, cfgBouton);
	end
		
	chinonOptionsInterface.args.boutons.args[cfgBouton.nom]=bt;
end

function Chinon:ChargerOptions()
	chinonOptionsInterface.args.boutons.args = {}
	for i,j in pairs(chinonDefautArgsBouton) do
		chinonOptionsInterface.args.boutons.args[i]=j
	end
	
	for i, cfgBouton in pairs(self.cfgBoutons) do
		self:AjouterOptionsBouton(cfgBouton);
	end
end

function Chinon:AfficherConfig()
	self.AceConfigDialog:SetDefaultSize("Chinon", 500, 550)
	self.AceConfigDialog:Open("Chinon", configFrame)
end