local Chinchilla = Chinchilla
Chinchilla:ProvideVersion("$Revision: 62846 $", "$Date: 2008-02-25 03:59:18 -0500 (Mon, 25 Feb 2008) $")
Chinchilla:SetModuleDefaultState("RangeCircle", false)
local Chinchilla_RangeCircle = Chinchilla:NewModule("RangeCircle", "LibRockEvent-1.0", "LibRockHook-1.0")
local self = Chinchilla_RangeCircle
local L = Rock("LibRockLocale-1.0"):GetTranslationNamespace("Chinchilla")

Chinchilla_RangeCircle.desc = L["Show a circle on the minimap at a prefered range"]

local newDict, unpackDictAndDel = Rock:GetRecyclingFunctions("Chinchilla", "newDict", "unpackDictAndDel")


function Chinchilla_RangeCircle:OnInitialize()
	self.db = Chinchilla:GetDatabaseNamespace("RangeCircle")
	Chinchilla:SetDatabaseNamespaceDefaults("RangeCircle", "profile", {
		range = 90,
		color = { 1, 0.82, 0, 0.5 },
		style = "Solid",
		combatRange = 90,
		combatColor = { 1, 0.82, 0, 0.25 },
		combatStyle = "Solid",
	})
end

local styles = {
	Solid = {
		L["Solid"],
		[[Interface\AddOns\Chinchilla\RangeCircle\Solid]],
	},
	Outline = {
		L["Outline"],
		[[Interface\AddOns\Chinchilla\RangeCircle\Outline]],
	}
}

local minimapSize = { -- radius of minimap
	indoor = {
		[0] = 150,
		[1] = 120,
		[2] = 90,
		[3] = 60,
		[4] = 40,
		[5] = 25,
	},
	outdoor = {
		[0] = 233 + 1/3,
		[1] = 200,
		[2] = 166 + 2/3,
		[3] = 133 + 1/6,
		[4] = 100,
		[5] = 66 + 2/3,
	},
}

local texture
local indoors
local inCombat = not not InCombatLockdown()
function Chinchilla_RangeCircle:OnEnable()
	if not texture then
		texture = Minimap:CreateTexture("Chinchilla_RangeCircle_Circle", "OVERLAY")
		texture:SetPoint("CENTER")
	end
	texture:Show()
	
	self:AddEventListener("MINIMAP_UPDATE_ZOOM")
	self:AddEventListener("PLAYER_REGEN_ENABLED")
	self:AddEventListener("PLAYER_REGEN_DISABLED")
	self:Update()
	
	self:AddSecureHook(Minimap, "SetZoom", "Minimap_SetZoom")
end

function Chinchilla_RangeCircle:OnDisable()
	texture:Hide()
end

function Chinchilla_RangeCircle:PLAYER_REGEN_ENABLED()
	inCombat = false
	self:Update()
end

function Chinchilla_RangeCircle:PLAYER_REGEN_DISABLED()
	inCombat = true
	self:Update()
end

function Chinchilla_RangeCircle:MINIMAP_UPDATE_ZOOM()
	local zoom = Minimap:GetZoom()
	if GetCVar("minimapZoom") == GetCVar("minimapInsideZoom") then
		Minimap:SetZoom(zoom < 2 and zoom + 1 or zoom - 1)
	end
	indoors = GetCVar("minimapZoom")+0 ~= Minimap:GetZoom()
	Minimap:SetZoom(zoom)
	
	self:Update()
end

function Chinchilla_RangeCircle:Update()
	if not self:IsActive() then
		return
	end
	local style = styles[self.db.profile[inCombat and 'combatStyle' or 'style']] or styles.Solid
	local tex = style and style[2] or [[Interface\AddOns\Chinchilla\RangeCircle\Solid]]
	texture:SetTexture(tex)
	texture:SetVertexColor(unpack(self.db.profile[inCombat and 'combatColor' or 'color']))
	
	local radius = minimapSize[indoors and "indoor" or "outdoor"][Minimap:GetZoom()]
	local range = self.db.profile[inCombat and 'combatRange' or 'range']
	local minimapWidth = Minimap:GetWidth()
	local size = minimapWidth * range/radius
	if size > minimapWidth then
		local ratio = minimapWidth/size
		texture:SetTexCoord(0.5 - ratio/2, 0.5 + ratio/2, 0.5 - ratio/2, 0.5 + ratio/2)
		texture:SetWidth(minimapWidth)
		texture:SetHeight(minimapWidth)
	else
		texture:SetTexCoord(0, 1, 0, 1)
		texture:SetWidth(size)
		texture:SetHeight(size)
	end
end

function Chinchilla_RangeCircle:Minimap_SetZoom()
	self:Update()
end


Chinchilla_RangeCircle:AddChinchillaOption(function()
	local args = {
		range = {
			type = 'number',
			name = L["Radius"],
			desc = L["The radius in yards of how large the radius of the circle should be"],
			min = 5,
			max = 250,
			step = 1,
			bigStep = 5,
			get = function(combat)
				return self.db.profile[combat and 'combatRange' or 'range']
			end,
			set = function(combat, value)
				self.db.profile[combat and 'combatRange' or 'range'] = value
				if not combat == not inCombat then
					self:Update()
				end
			end
		},
		color = {
			type = 'color',
			name = L["Color"],
			desc = L["Color of the circle"],
			hasAlpha = true,
			get = function(combat)
				return unpack(self.db.profile[combat and 'combatColor' or 'color'])
			end,
			set = function(combat, r, g, b, a)
				local data = self.db.profile[combat and 'combatColor' or 'color']
				data[1] = r
				data[2] = g
				data[3] = b
				data[4] = a
				if not combat == not inCombat then
					self:Update()
				end
			end
		},
		style = {
			type = 'choice',
			name = L["Style"],
			desc = L["What texture style to use for the circle"],
			choices = function()
				local t = newDict()
				for k,v in pairs(styles) do
					t[k] = v[1]
				end
				return "@dict", unpackDictAndDel(t)
			end,
			get = function(combat)
				return self.db.profile[combat and 'combatStyle' or 'style']
			end,
			set = function(combat, value)
				self.db.profile[combat and 'combatStyle' or 'style'] = value
				if not combat == not inCombat then
					self:Update()
				end
			end
		}
	}
	
	return {
		name = L["Range circle"],
		desc = Chinchilla_RangeCircle.desc,
		type = 'group',
		args = {
			outCombat = {
				type = 'group',
				groupType = 'inline',
				name = L["Out of combat"],
				desc = L["These settings apply when out of combat"],
				args = args,
				child_passValue = false,
				order = 2,
			},
			inCombat = {
				type = 'group',
				groupType = 'inline',
				name = L["In combat"],
				desc = L["These settings apply when in combat"],
				args = args,
				child_passValue = true,
				order = 3,
			}
		}
	}
end)