-- ChatToggle 2.4.01

local CT_Ver="2.401 Beta"
local CTTag="|c00FFFF66Chattoggle "..CT_Ver.."|r: "
local CTstateOnMsg = "Automatically hiding chat windows when in combat"
local CTstateOffMsg = "Automatic chat window hiding is disabled"
local hidden = false
local CTg = getfenv(0)

local ORIG_ChatFrame_OnUpdate = ChatFrame_OnUpdate;
function ChatFrame_OnUpdate()
	if (hidden) then
		this:Hide()
	else
		ORIG_ChatFrame_OnUpdate()
	end
end


--  local constants
local HIDE = true
local SHOW = false

local function ChatMsg(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg)
end

local function CToggle(action)
	if (action == SHOW) then
		for i = 1,7 do
			if (CTChatWindows[i]) then
				CTg["ChatFrame"..i]:Show()
				CTg["ChatFrame"..i.."Tab"]:Show()
				CTg["ChatFrame"..i.."TabDockRegion"]:Show()
			end
		end
	elseif (action == HIDE) then
		for i = 1,7 do
			local cframe = CTg["ChatFrame"..i]
			if(cframe:IsShown()) then
				CTg["ChatFrame"..i]:Hide()
				CTg["ChatFrame"..i.."Tab"]:Hide()
				CTg["ChatFrame"..i.."TabDockRegion"]:Hide()
				CTChatWindows[i] = true
			else
				CTChatWindows[i] = false
			end
		end
	end
end

local function SetState(state)
	if (state) then
		CTChatWindows["auto"] = true
		ChatMsg(CTTag..CTstateOnMsg)
	else
		CTChatWindows["auto"] = false
		CToggle(SHOW)
		ChatMsg(CTTag..CTstateOffMsg)
	end
end

function CTOnLoad()
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("PLAYER_REGEN_DISABLED")
	this:RegisterEvent("PLAYER_REGEN_ENABLED")

	-- define slash command handler
	SlashCmdList["CHATTOGGLE"] = function(cmd)
		local msg
		if (cmd == "on") then
			SetState(true)
			msg = CTTag..CTstateOnMsg
		elseif (cmd == "off") then
			SetState(false)
			msg = CTTag..CTstateOffMsg
		else
			ChatMsg(CTTag.."use|c0066FF66  /chattogle (or /ct) <arg>:")
			ChatMsg("|c0066FF66  <arg> = on       - |rauto hide chat windows in combat")
			ChatMsg("|c0066FF66  <arg> = off   - |rdisable |c0033CC99ChatToggle|r")
			if(CTChatWindows["auto"]) then
				msg = "|c0066FFFFcurrent setting: "..CTstateOnMsg
			else
				msg = "|c0066FFFFcurrent setting: "..CTstateOffMsg
			end
		end
		ChatMsg(msg)
	end
	SLASH_CHATTOGGLE1 = "/chattoggle"
	SLASH_CHATTOGGLE2 = "/ct"
end

function CTOnEvent()
	if (event == "PLAYER_ENTERING_WORLD") then
		if( not CTChatWindows) then
			-- initialize table
			CTChatWindows = {}
			CTChatWindows["auto"] = true
			for i = 1,7 do
				local cframe = CTg["ChatFrame"..i]
				if (cframe:IsShown()) then
					CTChatWindows[i] = true
				else
					CTChatWindows[i] = false
				end
			end
		end
		CToggle(SHOW)
		hidden = false

		if(CTChatWindows["auto"]) then
			ChatMsg(CTTag.."loaded: "..CTstateOnMsg)
		else
			ChatMsg(CTTag.."loaded: "..CTstateOffMsg)
		end
	elseif (CTChatWindows["auto"]) then
		if (event == "PLAYER_REGEN_DISABLED") then
			hidden = true
			CToggle(HIDE)
		elseif (event == "PLAYER_REGEN_ENABLED") then
			hidden = false
			CToggle(SHOW)
		end
	end
end
