
LibStub("tekKonfig-AboutPanel").new(nil, "ChatSettingsFix")

local mypatch, mybuild = "2.4.1", "8125"
local version, build = GetBuildInfo()
if version ~= mypatch or build ~= mybuild then
	ChatFrame1:AddMessage("|cFF33FF99ChatSettingsFix|r: This addon is only designed to work with patch "..mypatch.." build "..mybuild..".  If the chat bug is not fixed, please check for an updated version.")
	return
end


local f = CreateFrame("Frame")
f:RegisterEvent("PLAYER_LOGIN")
f:SetScript("OnEvent", function(self, event)
	if not ChatSettingsFixDB then
		ChatSettingsFixDB = {ChatFrame1 = {}, ChatFrame2 = {}}
		for framename,channels in pairs(ChatSettingsFixDB) do
			for i,v in pairs(_G[framename].messageTypeList) do channels[v] = true end
		end
	end

	local allchannels = {}
	for i,set in pairs{CHAT_CONFIG_CHAT_LEFT, CHAT_CONFIG_CHAT_RIGHT, CHAT_CONFIG_CHAT_CREATURE_LEFT, CHAT_CONFIG_OTHER_COMBAT, CHAT_CONFIG_OTHER_PVP, CHAT_CONFIG_OTHER_SYSTEM} do
		for i,v in pairs(set) do allchannels[v.type] = true end
	end

	for framename,channels in pairs(ChatSettingsFixDB) do
		local frame = _G[framename]
		for channel in pairs(allchannels) do
			if channels[channel] then ChatFrame_AddMessageGroup(frame, channel) else ChatFrame_RemoveMessageGroup(frame, channel) end
		end
	end

	local origadd, origrem = ChatFrame_AddMessageGroup, ChatFrame_RemoveMessageGroup
	ChatFrame_AddMessageGroup = function(frame, channel, ...)
		if frame == ChatFrame1 then ChatSettingsFixDB.ChatFrame1[channel] = true
		elseif frame == ChatFrame2 then ChatSettingsFixDB.ChatFrame2[channel] = true end
		return origadd(frame, channel, ...)
	end
	ChatFrame_RemoveMessageGroup = function(frame, channel, ...)
		if frame == ChatFrame1 then ChatSettingsFixDB.ChatFrame1[channel] = nil
		elseif frame == ChatFrame2 then ChatSettingsFixDB.ChatFrame2[channel] = nil end
		return origrem(frame, channel, ...)
	end

	f:SetScript("OnEvent", nil)
	f:UnregisterAllEvents()
end)
