if not Chaman2 then
  Chaman2 = {};
end

--[[
  package Chaman2

  class Temporisateur
    static nil sortLance(s,r,c)
    -> Informe les temporisateurs que le sort `s de rang `r a ete lance sur la cible `c
    static nil demandeRafraichir()
    -> Rafraichie l'affichage de tous les temporisateurs
    static formaterTemporisateur(tab)
    -> ...

]]

Chaman2.Temporisateur = {}; -- la classe
Chaman2.Temporisateur.instances = {}; -- les objets
Chaman2.Temporisateur.methodes = {}; -- les methodes
Chaman2.Temporisateur.methodes.class = Chaman2.Temporisateur; -- permet de lie la classe a l'objet

-- appelle la methode demarrer sur les temporisateurs qui ecoutent le sort
function Chaman2.Temporisateur:sortLance(s,r,c)
  local class = self;
  self = nil;
  for _,v in ipairs(class.instances) do
    v:sortLance(s,r,c);
  end
end

function Chaman2.Temporisateur:joueurMort()
  local class = self;
  self = nil;
  for _,v in ipairs(class.instances) do
    v:joueurMort();
  end
end

function Chaman2.Temporisateur:joueurZone()
  local class = self;
  self = nil;
  for _,v in ipairs(class.instances) do
    v:joueurZone();
  end
end

-- une methode statique
function Chaman2.Temporisateur:demandeRafraichir()
  local class = self;
  self = nil;
  for _,v in ipairs(class.instances) do
    v:demandeRafraichir();
  end
end

-- donne la duree pour chaque rang
-- renvoie un tableau de temporisateur

-- genre 1 --> modifie au lancement d'un des sorts du tableau
-- genre 2 --> modifie quand l'attente du sort est modifie (fortement lie : ankh)

-- condition d'annulation ? gere de facon externe (modif d'arme, totem touche, dispell [bouclier])

-- qui contiennent un tableau de sorts (mm pr les items) [GetSpellItem]
-- ou sorts (duree -1) qui correspond aux temps donne par des Attente

function Chaman2.Temporisateur:formaterTemporisateur(tab)
  local class = self;
  self = nil;
  local res = {};
  -- ne prend que les sorts connus
  if tab.sorts then
    local z, n, r = 1, "", 1;
    while n do
      n, r = GetSpellName(z, BOOKTYPE_SPELL);
      if tab.sorts[n] and tab.sorts[n].temporisateurs then -- le sort nous interesse et on sait ou le mettre
        local nr = n.."("..r..")";
        local rang = Chaman2.premierEntierChaine(r); -- le rang en nombre
        for _,temporisateur in ipairs(tab.sorts[n].temporisateurs) do
          local nomTemporisateur = temporisateur.nom;
          if not res[nomTemporisateur] then -- si le temporisateur n'existe pas on le creer
            res[nomTemporisateur] = {}; -- nouveau temporisateur
            res[nomTemporisateur].sorts = {}; -- avec au moins un sort
          end
          if not res[nomTemporisateur].sorts[nr] then
            res[nomTemporisateur].sorts[nr] = {};
          end
          local spec = {};
          spec.frequenceTic = temporisateur.frequenceTic or 0;
          spec.decalageTic = temporisateur.decalageTic or 0;
          if type(temporisateur.duree)=="table" then
            spec.duree = temporisateur.duree[rang];
          elseif type(temporisateur.duree)=="number" then
            spec.duree = temporisateur.duree;
          elseif type(temporisateur.duree)=="function" then
            spec.duree = temporisateur.duree(rang);
          end
          spec.idSort = z; -- pour les sorts qui ont besoin de leurs id tres pratique
          -- (juste une astuce, devrait etre passer en parametre de rafraichir en utilisation normale)
          spec.texture = GetSpellTexture(z,BOOKTYPE_SPELL);
          spec.mode = temporisateur.mode;
          spec.changement = temporisateur.changement;
          spec.parametresChangement = temporisateur.parametresChangement;
          spec.rafraichir = temporisateur.rafraichir;
          spec.termine = temporisateur.termine;
          spec.parametresRafraichir = temporisateur.parametresRafraichir;
          spec.cibleValides = temporisateur.cible;
          table.insert(res[nomTemporisateur].sorts[nr],{["specification"] = spec,["cibleValide"] = temporisateur.cibleValide,});
          if temporisateur.specifie then -- specification de depart (si plusieurs -> ecrasement, fallais pas)
            res[nomTemporisateur].specifie = {nr,table.getn(res[nomTemporisateur].sorts[nr])};
          end
        end
      end
      z = z + 1;
    end
  end
  -- passe aux objets : ne prend que les objets dans le cache (remarque si qq1 l'a link on le connais sans l'avoir pas terrible)
  if tab.objets then
    for n,v in pairs(tab.objets) do
      if GetItemInfo(n)~=nil then
        if v.temporisateurs then -- le sort nous interesse
          local s,r = GetItemSpell(n);
          if s then -- si on a le bijou
            local nr = s.."("..r..")";
            for _,temporisateur in ipairs(v.temporisateurs) do
              local nomTemporisateur = temporisateur.nom;
              if not res[nomTemporisateur] then
                res[nomTemporisateur] = {}; -- nouveau relanceur
                res[nomTemporisateur].sorts = {}; -- avec au moins un sort (celui de l'objet)
              end
              if not res[nomTemporisateur].sorts[nr] then
                res[nomTemporisateur].sorts[nr] = {};
              end
              local spec = {};
              spec.frequenceTic = temporisateur.frequenceTic or 0;
              spec.decalageTic = temporisateur.decalageTic or 0;
              if type(temporisateur.duree)=="table" then
                spec.duree = temporisateur.duree[rang];
              elseif type(temporisateur.duree)=="number" then
                spec.duree = temporisateur.duree;
              elseif type(temporisateur.duree)=="function" then
                spec.duree = temporisateur.duree(rang);
              end
              -- spec.idSort = z; -- pour les sorts qui ont besoin de leurs id tres pratique
              _,_,_,_,_,_,_,_,_,spec.texture = GetItemInfo(n);
              spec.mode = temporisateur.mode;
              spec.changement = temporisateur.changement;
              spec.parametresChangement = temporisateur.parametresChangement;
              spec.rafraichir = temporisateur.rafraichir;
              spec.termine = temporisateur.termine;
              spec.parametresRafraichir = temporisateur.parametresRafraichir;
              spec.cibleValides = temporisateur.cible;
              table.insert(res[nomTemporisateur].sorts[nr],{["specification"] = spec,["cibleValide"] = temporisateur.cibleValide,});
              if temporisateur.specifie then -- specification de depart (si plusieurs -> ecrasement, fallais pas)
                res[nomTemporisateur].specifie = {nr,table.getn(res[nomTemporisateur].sorts[nr])};
              end
            end
          end
        end
      end
    end
  end
  return res;
end


function Chaman2.Temporisateur:cacherTermine()
  local class = self;
  self = nil;
  if donneesChaman2.peutBouger then
    return false;
  else
    return true;
  end
end

-- rajouter mode bouton ?
-- si c'est un temporisateur passif c marque dans tab (et dans ce cas ne contient pas de tableau de sorts)

function Chaman2.Temporisateur:creer(parent,x,y,tab,sauvegarde,enleverMort,enleverZone,sortEnlevant)
  local class = self;
  self = {};
  setmetatable(self,{__index = class.methodes});
  table.insert(class.instances,self);

  self.enleverMort = enleverMort;
  self.enleverZone = enleverZone;
  self.sortEnlevant = sortEnlevant;
  self.sauvegarde = sauvegarde; -- permet de conserver une spec apres une deconnexion
  self.sorts = tab.sorts;
  self.duree = 1;
  self.frequenceTic = 0;
  self.decalageTic = 0;
  self.tpsRestant = 0;
  self.date = GetTime();

  self.frame = CreateFrame("Frame",chaman2BaseFrame..chaman2Increment,parent);
  chaman2Increment = chaman2Increment+1;
  self.frame:SetPoint("TOPLEFT",parent,"TOPLEFT",x,-y);
  self.frame:SetWidth(100);
  self.frame:SetHeight(30);
  if self.class.cacherTermine() then
    self.frame:Hide();
  end

  local bckd = {};
  bckd.bgFile = "Interface/Tooltips/UI-Tooltip-Background";
  bckd.edgeFile = "Interface/Tooltips/UI-Tooltip-Border";
  bckd.tile = true;
  bckd.tileSize = 16;
  bckd.edgeSize = 16;
  bckd.insets = {};
  bckd.insets.left = 4;
  bckd.insets.right = 4;
  bckd.insets.top = 4;
  bckd.insets.bottom = 4;

  self.frame:SetBackdrop(bckd);
  self.frame:SetBackdropColor(0,0,0,1);
  self.frame:SetBackdropBorderColor(.3,.3,.3,1);

  self.texture = self.frame:CreateTexture();
  self.texture:SetPoint("LEFT",self.frame,"LEFT",5,0);
  self.texture:SetWidth(20);
  self.texture:SetHeight(20);

  self.tics = self.frame:CreateFontString(nil,"ARTWORK","NumberFontNormal");
  self.tics:SetAllPoints(self.texture);

  self.ticstatus = CreateFrame("StatusBar", chaman2BaseFrame..chaman2Increment, self.frame);
  chaman2Increment = chaman2Increment+1;
  self.ticstatus:SetPoint("TOPLEFT",self.frame,"TOPLEFT",25,-5);

  self.ticstatus:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar");
  self.ticstatus:SetStatusBarColor(0,1,0);
  self.ticstatus:SetMinMaxValues(0,1);
  self.ticstatus:SetOrientation("VERTICAL");
  self.ticstatus:SetValue(1);
  self.ticstatus:SetWidth(5);
  self.ticstatus:SetHeight(20);
  
  self.framestatus = CreateFrame("StatusBar", chaman2BaseFrame..chaman2Increment, self.frame);
  chaman2Increment = chaman2Increment+1;
  self.framestatus:SetPoint("TOPLEFT",self.frame,"TOPLEFT",30,-5); -- 25,-5

  self.framestatus:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar");
  self.framestatus:SetStatusBarColor(.5,.5,.5);
  self.framestatus:SetMinMaxValues(0,1);
  self.framestatus:SetValue(0);
  self.framestatus:SetWidth(100-5*2-20-5);
  self.framestatus:SetHeight(20);

  self.frameTexte = self.framestatus:CreateFontString(nil,"ARTWORK","GameFontNormalSmall");
  self.frameTexte:SetAllPoints();
  if tab.specifie then
    self:specifier(self.sorts[tab.specifie[1]][tab.specifie[2]].specification);
    self:enlever(); -- commence le temps a expire, si semi actif ou passif alors il sera capable de reprendre au bon endroit
  end
  if self.sauvegarde and self.sauvegarde.specifie then -- la sauvegarde est prioritaire 
    -- (remarque la sauvegarde relance le sort car incapable de sauvegarder toute la spec)
    self:sortLance(self.sauvegarde.specifie[1],self.sauvegarde.specifie[2],self.sauvegarde.specifie[3]);
    -- fin recopie
    self:enlever(); -- commence le temps a expire, si semi actif ou passif alors il sera capable de reprendre au bon endroit
  end
  return self;
end


function Chaman2.Temporisateur.methodes:fixerPosition(parent,x,y)
  self.parent = parent;
  self.x = x;
  self.y = y;
  self.frame:SetPoint("TOPLEFT",parent,"TOPLEFT",x,-y);
end


function Chaman2.Temporisateur.methodes:arreter(b) -- on conserve l'ecoulement du temps
  -- affiche en rouge
  if b then
    self.framestatus:SetStatusBarColor(.5,.1,.1);
  else
    self.framestatus:SetStatusBarColor(.5,.5,.5);
  end
end

function Chaman2.Temporisateur.methodes:sortLance(s,r,c)
  if self.sortEnlevant(s,r,c) then
    self:enlever();
  end
  local tab = self.sorts[s.."("..r..")"];
  if not tab then
    return;
  end
  for _,info in ipairs(tab) do
    if forcerValide or (not info.cibleValide) or info.cibleValide(c) then
      if self.sauvegarde then
        self.sauvegarde.specifie = {s,r,c};
      end
      self:specifier(info.specification);
    end
  end
end

function Chaman2.Temporisateur.methodes:joueurMort()
  if self.enleverMort then
    self:enlever();
  end
end

function Chaman2.Temporisateur.methodes:joueurZone()
  if self.enleverZone then
    self:enlever();
  end
end

-- temps n'est utile que si passif ou semi actif (dans le cas semi le tps peut etre mis a -1)
function Chaman2.Temporisateur.methodes:demandeRafraichir()
  local tics,demandeArret = -1,false;
  -- en mode 0 rafraichir peut etre oublie (tempo qui ne peut pas etre interrompu + sans tics)
  -- en mode 1 rafraichir doit etre definie (sinon comment savoir a quel moment on interrompt et comment savoir le tps restant)
  --         2 rafraichir doit etre definie (savoir le tps restant)
  if self.mode==0 then
    -- on essaye de recuperer les tics et on actualise le tpsRestant
    if type(self.rafraichir)=="function" then
      tics,demandeArret = self.rafraichir(self.parametresRafraichir,self.idSort);
    end
    if self.tpsRestant>0 then -- si il restait du temps la fois d'avant -> on ecoule
      local ad = self.date; -- precedante maj
      self.date = GetTime(); -- date de derniere maj
      self.tpsRestant = max(0,self.tpsRestant-self.date+ad);
      if self.tpsRestant==0 and type(self.termine)=="function" then
        self.termine();
      end
    end
  elseif self.mode==1 then
    local ntics,ndemandeArret,ntpsRestant = self.rafraichir(self.parametresRafraichir,self.idSort);
    if ntpsRestant<0 then
      -- mode actif (a perdu son moyen de recuperer le temps restant)
      local ad = self.date; -- precedante maj
      self.date = GetTime(); -- date de derniere maj
      self.tpsRestant = max(0,self.tpsRestant-self.date+ad);
    else
      -- mode passif
      self.date = GetTime(); -- donne la date pour la transition en mode actif
      self.tpsRestant = ntpsRestant;
    end
    tics = ntics;
    demandeArret = ndemandeArret;
  elseif self.mode==2 then
    -- mode completement passif, aucun soucis de transitions
    local ntics,ndemandeArret,ntpsRestant = self.rafraichir(self.parametresRafraichir,self.idSort)
    tics = ntics;
    demandeArret = ndemandeArret;
    self.tpsRestant = max(0,ntpsRestant);
  end

  self:arreter(demandeArret); -- couleur rouge ou grise

  if tics==nil or tics==-1 then -- n'affiche rien
    self.tics:SetText("");
  else
    self.tics:SetText(tics);
  end

  if self.tpsRestant==0 then
    self:enlever(); 
  else
    self.frame:Show();
  end

  self.frameTexte:SetText(Chaman2.formaterDuree(self.tpsRestant));
  self.framestatus:SetValue(self.tpsRestant);
  if self.tpsRestant<=0 then
    self.ticstatus:SetValue(0);
  else
    if self.frequenceTic~=0 then
      self.ticstatus:SetValue(1-((self.duree-self.tpsRestant-self.decalageTic)%self.frequenceTic)/self.frequenceTic);
    else
      self.ticstatus:SetValue(1);
    end
  end
end

function Chaman2.Temporisateur.methodes:enlever()
  -- fait disparaitre la barre de temps (garde la specification)
  -- correspond a un ecoulement ultra rapide du temps
  if self.mode==0 and self.tpsRestant>0 and type(self.termine)=="function" then
    self.termine();
  end
  self.date = GetTime();
  self.tpsRestant = 0;
  self.framestatus:SetStatusBarColor(.5,.5,.5);
  if self.class:cacherTermine() then
    self.frame:Hide();
  else
    self.frame:Show();
  end
end

-- rafraichir renvoie 0,tics si pas passif 
-- si rafraichir renvoie -1,tics alors arret du Temporisateur
function Chaman2.Temporisateur.methodes:specifier(spec)
  if spec.changement then
    spec.changement(spec.parametresChangement,spec.idSort);
  end
  if spec.duree<=0 then
    return;
  end
  self.frame:Show();
  self.framestatus:SetStatusBarColor(.5,.5,.5);

  self.mode = spec.mode;
  self.duree = spec.duree;
  self.frequenceTic = spec.frequenceTic;
  self.decalageTic = spec.decalageTic;
  self.tpsRestant = spec.duree;
  self.rafraichir = spec.rafraichir;
  self.termine = spec.termine;
  self.parametresRafraichir = spec.parametresRafraichir;
  self.idSort = spec.idSort;
  self.tics:SetText(""); -- notamment si rafraichir est nil
  self.date = GetTime();
  self.framestatus:SetMinMaxValues(0,self.duree);
  self.texture:SetTexture(spec.texture);
end

function Chaman2.Temporisateur.methodes:modifierSens(versGauche)

end

