if not Chaman2 then
  Chaman2 = {};
end

Chaman2.MenuAction = {}; -- la classe
Chaman2.MenuAction.instances = {}; -- les objets
Chaman2.MenuAction.methodes = {}; -- les methodes
Chaman2.MenuAction.methodes.class = Chaman2.MenuAction; -- permet de lie la classe a l'objet
Chaman2.MenuAction.numeroRaccourci = 0;

function Chaman2.MenuAction:afficheInfoBulle()
  local class = self;
  self = nil;
  if donneesChaman2.afficheInfoBulle then
    return true;
  else
    return false;
  end
end

function Chaman2.MenuAction:actualiserAssociation()
  local class = self;
  self = nil;
  for _,v in ipairs(class.instances) do
    v:actualiserAssociation();
  end
end

function Chaman2.MenuAction:modifierAttente()
  local class = self;
  self = nil;
  for _,v in ipairs(class.instances) do
    local deb,dur = 0,0;
    local e = v.etatRelance;
    if e.genre==1 then
      deb, dur = GetSpellCooldown(class.idSortSelonRang[e.sort][e.rang], BOOKTYPE_SPELL);
    elseif e.genre==2 then
      deb, dur = GetItemCooldown(e.lienObjet);
    else
      e.genre = 0; -- si pas deja mis c pas bien
    end
    if e.genre~=0 then
      CooldownFrame_SetTimer(e.boutonAttente, deb, dur, 1);
    end
    for _,e in ipairs(v.etatsSort) do
      if e.genre==1 then
        deb, dur = GetSpellCooldown(class.idSortSelonRang[e.sort][e.rang], BOOKTYPE_SPELL);
      elseif e.genre==2 then
        deb, dur = GetItemCooldown(e.lienObjet);
      else
        e.genre = 0; -- si pas deja mis c pas bien
      end
      if e.genre~=0 then
        CooldownFrame_SetTimer(e.boutonAttente, deb, dur, 1);
      end
    end
  end
end

-- si ancienneSauvegarde est nulle alors choisi un ordre au hasard (sort puis objets)
function Chaman2.MenuAction:ordonner(tab,ancienneSauvegarde)
  local class = self;
  self = nil;
  local ordre = {};

  local nouvelleSauvegarde = {};
  nouvelleSauvegarde.genreNoms = {};
  nouvelleSauvegarde.places = {};
  nouvelleSauvegarde.etats = {};
  nouvelleSauvegarde.colle = 0;
  nouvelleSauvegarde.selection = 0; -- pas de selection (si le sort a disparu alors ca retourne dans cet etat)
  local nomGenreAncienneSelection = "";

  local placeSelonGenreNom = {};
  if ancienneSauvegarde then
    if ancienneSauvegarde.selection~=0 then
      nomGenreAncienneSelection = ancienneSauvegarde.genreNoms[ancienneSauvegarde.selection];
    end  
    for num,genreNom in ipairs(ancienneSauvegarde.genreNoms) do
      placeSelonGenreNom[genreNom] = ancienneSauvegarde.places[num];
    end
  end

  -- d'abord les sorts ?
  if tab.sorts then
    for s,v in pairs(tab.sorts) do
      local p = {};
      p.genre = 1; -- genre 1 -> spell
      p.sort = v.sort;
      p.rangMinimum = v.rangMinimum;
      p.rangMaximum = v.rangMaximum;
      p.cible = v.cible;
      p.texte = v.texte;
      p.texture = GetSpellTexture(class.idSortSelonRang[v.sort][v.rangMaximum],BOOKTYPE_SPELL);
      -- ajoute
      table.insert(nouvelleSauvegarde.genreNoms,"1"..s);
      if nomGenreAncienneSelection == "1"..s then
        nouvelleSauvegarde.selection = table.getn(nouvelleSauvegarde.genreNoms);
      end
      table.insert(nouvelleSauvegarde.places,placeSelonGenreNom["1"..s] or -1); -- la place est l'ancienne ou -1
      table.insert(ordre,p);
    end
  end
  -- apres les objets
  if tab.objets then
    for n,v in pairs(tab.objets) do -- pas d'info necessaires
      local _,l,_,_,_,_,_,_,_,t = GetItemInfo(v.objet);
      local p = {};
      p.genre = 2; -- genre 2 -> item
      p.nomObjet = v.objet; -- pr lancer
      p.lienObjet = l;
      p.texture = t;
      p.cible = v.cible;
      p.texte = v.texte;
      -- ajoute
      table.insert(nouvelleSauvegarde.genreNoms,"2"..n);
      if nomGenreAncienneSelection == "2"..n then
        nouvelleSauvegarde.selection = table.getn(nouvelleSauvegarde.genreNoms);
      end
      table.insert(nouvelleSauvegarde.places,placeSelonGenreNom["2"..n] or -1); -- la place est l'ancienne ou -1
      table.insert(ordre,p);
    end
  end


  local function formaterOrdre(ordreavctrous,limitecolle) -- modifie ordreavctrous.places et ordreavctrous.colle
    ordreavctrous.colle = 0;
    local ordreordre = {};
    local nbp = table.getn(ordreavctrous.places);
    for pl=1,nbp do
      table.insert(ordreordre,pl);
    end
    for pl=1,nbp do -- n'optimise plus avec nbp-1 car sinon un colle de moins
      local plmini = pl; -- 1er pas connu a priori mini
      local mini = ordreavctrous.places[ordreordre[plmini]];
      for j=pl+1,nbp do
        local v = ordreavctrous.places[ordreordre[j]];
        if v~=-1 then
          if mini==-1 or v<=mini then
            mini = v;
            plmini = j;
          end
        end
      end
      if mini~=-1 and mini<=limitecolle then -- mini correspond a un valeur anciennement colle
        ordreavctrous.colle = ordreavctrous.colle+1; -- on en ajoute une
      end
      local sav = ordreordre[pl];
      ordreordre[pl] = ordreordre[plmini];
      ordreordre[plmini] = sav;
    end

    for i,v in ipairs(ordreordre) do
      ordreavctrous.places[v] = i; -- donne l'ordre sous la forme 1,2,3 ... sans trous
    end
    -- le v ieme bouton aura le i eme sort
  end



  -- renseigne les vraies places et le vrai nombre de 'colle'
  -- d'abord oublie les sorts desappris


  if ancienneSauvegarde and ancienneSauvegarde.etats then
    formaterOrdre(nouvelleSauvegarde,ancienneSauvegarde.colle);

    local ancienGenreNomRenverse = {};
    for i,genreNom in ipairs(ancienneSauvegarde.genreNoms) do
      ancienGenreNomRenverse[genreNom] = i;
    end

    local nouveauGenreNomRenverse = {};
    for i,genreNom in ipairs(nouvelleSauvegarde.genreNoms) do
      nouveauGenreNomRenverse[genreNom] = i;
    end
 -- ancienneSauvegarde.genreNoms

    for es,val in pairs(ancienneSauvegarde.etats) do
      nouvelleSauvegarde.etats[es] = {};
      nouvelleSauvegarde.etats[es].places = {};
      nouvelleSauvegarde.etats[es].selection = nouveauGenreNomRenverse[ancienneSauvegarde.genreNoms[val.selection]] or 0; -- pas de selection si sort disparu
      -- le nom de l'ancienne selection compose avec le nouveau numero du nom
      for _,nom in ipairs(nouvelleSauvegarde.genreNoms) do -- pour chaque nouveau sorts
        -- le nouveau sort 'nom' correspond a l'etat i du nouvel automate
        -- la place de l'ancien i
        local ancnum = ancienGenreNomRenverse[nom]; -- recupere l'ancien numero du sort
        if ancnum then -- si le sort etait deja connu avant
          -- cherche son ancienne place
          table.insert(nouvelleSauvegarde.etats[es].places,val.places[ancnum]);
        else
          table.insert(nouvelleSauvegarde.etats[es].places,-1);
        end
      end
      formaterOrdre(nouvelleSauvegarde.etats[es],val.colle);
    end
  else
    formaterOrdre(nouvelleSauvegarde,0);
  end

  return ordre,nouvelleSauvegarde;
end





function Chaman2.MenuAction:actualiserIdSort()
  local class = self;
  self = nil;

  for n,_ in pairs(class.idSortSelonRang) do -- reinitialise tous les id (pour detecter la disparition de sort)
    class.idSortSelonRang[n] = {};
  end
  
  local z, n, r = 1, "", 1;
  while n do
    n, r = GetSpellName(z, BOOKTYPE_SPELL);
    if class.idSortSelonRang[n] then -- le sort etait deja connu
      class.idSortSelonRang[n][r] = z;
    end
    z = z + 1;
  end
end



-- la methode statique utile
-- entree un tableau de nom de sort (vide ou sans les champ rangMinimum rangMaximum)
-- sortie un tableau de nom de sort connu ainsi que le rang minimum et maximum connu

--[[
  Entree : un tableau qui contient un tableau Sort et un tableau Objet
  Dans le tableau sort il y a des sort qui contiennent un champ lanceur qui contient une chaine [nom]
  exprimant ou il faut mettre le resultat

  renvoie un tableau tel que toute les chaines sont repesentees
]]

function Chaman2.MenuAction:formaterLanceur(tab)
  local class = self;
  self = nil;
  class.idSortSelonRang = {};
  local res = {};
  -- ne prend que les sorts connus
  if tab.sorts then
    local z, n, r = 1, "", 1;
    while n do
      n, r = GetSpellName(z, BOOKTYPE_SPELL);
      if tab.sorts[n] and tab.sorts[n].lanceurs then -- le sort nous interesse et on sait ou le mettre
        local rang = Chaman2.premierEntierChaine(r); -- le rang en nombre
        if class.idSortSelonRang[n]==nil then
          class.idSortSelonRang[n] = {};
        end
        class.idSortSelonRang[n][r] = z;
        for _,lanceur in ipairs(tab.sorts[n].lanceurs) do
          local nomLanceur = lanceur.nom;
          if not res[nomLanceur] then
            res[nomLanceur] = {}; -- nouveau relanceur
            res[nomLanceur].sorts = {}; -- avec au moins un sort
          end
          local sc = n.."["..(lanceur.cible or "").."]"; -- cette chaine est utile a la sauvegarde des positions
          if not res[nomLanceur].sorts[sc] then
            res[nomLanceur].sorts[sc] = {};
            res[nomLanceur].sorts[sc].sort = n;
            res[nomLanceur].sorts[sc].rangMinimum = r;
            res[nomLanceur].sorts[sc].rangMaximum = r;
            res[nomLanceur].sorts[sc].cible = lanceur.cible;
            res[nomLanceur].sorts[sc].texte = lanceur.texte;
          else
            if rang>Chaman2.premierEntierChaine(res[nomLanceur].sorts[sc].rangMaximum) then
              res[nomLanceur].sorts[sc].rangMaximum = r;
            elseif rang<Chaman2.premierEntierChaine(res[nomLanceur].sorts[sc].rangMinimum) then
              res[nomLanceur].sorts[sc].rangMaximum = r;
            end
          end
        end
      end
      z = z + 1;
    end
  end
  -- passe aux objets : ne prend que les objets dans le cache (remarque si qq1 l'a link on le connais sans l'avoir pas terrible)
  if tab.objets then
    for n,v in pairs(tab.objets) do
      if GetItemInfo(n)~=nil then
        if v.lanceurs then -- le sort nous interesse et on sait ou le mettre
          for _,lanceur in ipairs(v.lanceurs) do
            local nomLanceur = lanceur.nom;
            if not res[nomLanceur] then
              res[nomLanceur] = {}; -- nouveau relanceur
              res[nomLanceur].objets = {}; -- avec au moins un objet
            else
              if not res[nomLanceur].objets then
                res[nomLanceur].objets = {};
              end
            end
            local sc = n.."["..(lanceur.cible or "").."]";
            if not res[nomLanceur].objets[sc] then -- sinon c que 2 fois la mm cible mm tempo
              res[nomLanceur].objets[sc] = { ["texte"] = lanceur.texte, ["cible"] = lanceur.cible, ["objet"] = n, };
            end
          end
        end
      end
    end
  end
  return res;
end


--[[
function Chaman2.MenuAction:changerFacteur(ch,cv)
  local coteBouton = 30;
  for i=1,self.nb do
    self.etats[i]:SetPoint("TOPLEFT",parent,"TOPLEFT",self.x+i*coteBouton*ch,-self.y-i*coteBouton*cv);
  end
end
]]

-- passer un tableau de nom de sorts (sans le rang)
-- maj clique lancera le rang 1, clique le rang max
-- tiens compte de sauvegarde.places pour l'etat et actualise sauvegarde.place au cours du temps
-- tiens compte de sauvegarde.colle et l'actualise aussi
-- actualise 
function Chaman2.MenuAction:creer(parent,x,y,tab,ch,cv,sauvegarde,associer,cmp) -- ch = coeff hori, cv coeff ver E {-1,0,1}
  local class = self;
  self = {};
  setmetatable(self,{__index = class.methodes});
  table.insert(class.instances,self);
  local nb = table.getn(tab);
  self.nb = nb; -- le sauvegarde
  self.parent = parent;
  self.x = x;
  self.y = y;
  self.associer = associer;

  self.coteBouton = 30;
  self.ch = ch;
  self.cv = cv;

  if not cmp then 
    cmp = 4;
  end
  -- boutons attaches a l'etatRelance
  self.boutonLancerChanger = {}; -- lance le sort et le selectionne
  self.boutonLancer = {}; -- lance le sort
  self.boutonChanger = {}; -- selectionne

  -- creer les etats (visibilite des boutons)
  -- bouton attache a la visibilite du bouton
  self.etats = {};
  self.boutons = {}; -- les boutons visibles
  self.boutonsAttente = {};
  self.boutonsToutAffiche = {}; -- lie avec le suivant (on doit appeler sur le premier pr un bon fonctionnement)
  self.boutonsCacher = {}; -- idem
  self.boutonsCacherLancer = {}; 
  self.boutonsDemarrerCacherLancerChanger = {};
  self.boutonsDemarrerCacherChanger = {};
  self.boutonsAjouter = {}; -- la liaison avec le suivant n'existe que si on est visible
  self.boutonsRetirer = {}; -- idem

  -- creer les etats (sorts des boutons)
  -- boutons attaches au sort du bouton
  self.etatsSort = {};
  self.boutonsSortLancerChanger = {};
  self.boutonsSortLancer = {};
  self.boutonsSortChanger = {};

  self.demarrerEchange = {};
  self.echangeSuivant = {}; -- lies 2 a 2 (faire Avance sur le n ne bougera que lui meme et le n+1)
  self.fixer = {}; -- change juste l'etat n'appele pas avance (siselfn recursivite) seul avance devrait 

  self.restaureEtatsSort = {};
  self.restaureEtats = {};

  -- d'abord la creation
  self.etatRelance = CreateFrame("Frame", chaman2BaseFrame..chaman2Increment, parent, "SecureStateHeaderTemplate");
  chaman2Increment = chaman2Increment+1;
  self.restaureEtatRelance = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatRelance , "SecureUnitButtonTemplate");
  chaman2Increment = chaman2Increment+1;
  self.boutonRelance = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatRelance, "SecureUnitButtonTemplate");
  chaman2Increment = chaman2Increment+1;
  self.boutonRaccourci = CreateFrame("Button", "MenuActionRaccourci"..self.class.numeroRaccourci, self.etatRelance, "SecureUnitButtonTemplate");
  self.class.numeroRaccourci = self.class.numeroRaccourci+1;
  self.boutonRelanceAttente = CreateFrame("Cooldown", chaman2BaseFrame..chaman2Increment, self.boutonRelance, "CooldownFrameTemplate");
  chaman2Increment = chaman2Increment+1;
  for i=1,nb do
    self.boutonLancerChanger[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatRelance , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonLancer[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatRelance , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonChanger[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatRelance , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.etats[i] = CreateFrame("Frame", chaman2BaseFrame..chaman2Increment, parent, "SecureStateHeaderTemplate");
    chaman2Increment = chaman2Increment+1;
    self.restaureEtats[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutons[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsAttente[i] = CreateFrame("Cooldown", chaman2BaseFrame..chaman2Increment, self.boutons[i], "CooldownFrameTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsToutAffiche[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsCacher[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsDemarrerCacherLancerChanger[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsDemarrerCacherChanger[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsCacherLancer[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsAjouter[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsRetirer[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etats[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.etatsSort[i] = CreateFrame("Frame", chaman2BaseFrame..chaman2Increment, parent, "SecureStateHeaderTemplate");
    chaman2Increment = chaman2Increment+1;
    self.restaureEtatsSort[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatsSort[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;

    self.boutonsSortLancerChanger[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatsSort[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsSortLancer[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatsSort[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.boutonsSortChanger[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatsSort[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.demarrerEchange[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatsSort[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.echangeSuivant[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatsSort[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    self.fixer[i] = CreateFrame("Button", chaman2BaseFrame..chaman2Increment, self.etatsSort[i] , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
  end

  -- des chaines,tableaux preconstruits
  local sortSelonEtat,sortMinimumSelonEtat = "","";
  for z=0,nb do -- 0 pas de sort
    sortSelonEtat = sortSelonEtat..z..":S"..z..";";
    sortMinimumSelonEtat = sortMinimumSelonEtat..z..":SM"..z..";";
  end

  local textureSelonEtat = {}; -- sert aux boutons visibles
  local texteSelonEtat = {}; -- sert aux boutons visibles
  local rangSortMaximumOuLienObjetSelonEtat = {}; -- sert aux cooldown
  local genreSelonEtat = {};
  for z=1,nb do
    table.insert(texteSelonEtat,tab[z].texte or "");
    table.insert(textureSelonEtat,tab[z].texture);
    table.insert(genreSelonEtat,tab[z].genre);
    if tab[z].genre==1 then
      local sortEtRang = {};
      sortEtRang["sort"] = tab[z].sort;
      sortEtRang["rang"] = tab[z].rangMaximum;
      table.insert(rangSortMaximumOuLienObjetSelonEtat,sortEtRang);
    elseif tab[z].genre==2 then 
      table.insert(rangSortMaximumOuLienObjetSelonEtat,tab[z].lienObjet);
    else
      table.insert(rangSortMaximumOuLienObjetSelonEtat,-1); -- connais pas
    end
  end


  -- ensuite les liaisons
  self.restaureEtatRelance:SetAttribute("type","click");
  self.etatRelance:SetAttribute("addchild", self.restaureEtatRelance);

  for i=1,nb do
    self.etats[i]:SetAttribute("addchild",self.restaureEtats[i]);
    self.restaureEtats[i]:SetAttribute("type","click");
    self.etatsSort[i]:SetAttribute("addchild",self.restaureEtatsSort[i]);
    self.restaureEtatsSort[i]:SetAttribute("type","click");
  end

  --self.restaureEtatsSort[i]:;
  --self.restaureEtats = {};


  --

  -- l'etat qui gere le sort et la visibilite du bouton de relance
  self.etatRelance:SetPoint("TOPLEFT",parent,"TOPLEFT",x,-y);
  self.etatRelance:SetWidth(30);
  self.etatRelance:SetHeight(30);
  -- le bouton de relance (et raccourci)
  self.etatRelance:SetAttribute("addchild", self.boutonRelance);
  self.etatRelance:SetAttribute("addchild", self.boutonRaccourci);

  self.boutonRelance:SetAllPoints();
  self.boutonRelance:RegisterForClicks("LeftButtonUp","RightButtonUp");


  self.boutonRaccourci:SetAttribute("statebutton*",sortSelonEtat);
  self.boutonRaccourci:SetAttribute("type","click");


  self.boutonRelance:SetAttribute("statebutton1",sortSelonEtat);
  self.boutonRelance:SetAttribute("shift-statebutton1",sortMinimumSelonEtat);

  self.boutonRelance:SetAttribute("statebutton2","*:S;"); -- etat S equiv droit
  self.boutonRelance:SetAttribute("newstate-S","0"); -- pr le bouton droit apres
  self.boutonRelance:SetAttribute("alt-statebutton1","*:A;"); -- alt click (gauche) -> etat A
  self.boutonRelance:SetAttribute("alt-shift-statebutton1","*:R;"); -- alt click (gauche) -> etat R
  self.boutonRelance:SetAttribute("type","click");
  self.boutonRelance:SetAttribute("*clickbutton-A",self.boutonsAjouter[1]);
  self.boutonRelance:SetAttribute("*clickbutton-R",self.boutonsRetirer[nb]);
  self.boutonRelance:SetAttribute("clickbutton-S",self.boutonsToutAffiche[1]);
  self.boutonRelance:SetAttribute("hidestates", "0");
  for l=1,nb do
    self.boutonRelance:SetAttribute("*clickbutton-S"..l,self.boutonLancer[l]);
    self.boutonRelance:SetAttribute("*clickbutton-SM"..l,self.boutonLancer[l]);

    self.boutonRaccourci:SetAttribute("*clickbutton-S"..l,self.boutonLancer[l]);
  end

  self.etatRelance.genre = 0; -- genre inconnu

  local es = self.etatRelance;
  es.textureSelonEtat = textureSelonEtat;
  es.texteSelonEtat = texteSelonEtat;
  es.genreSelonEtat = genreSelonEtat;
  es.rangSortMaximumOuLienObjetSelonEtat = rangSortMaximumOuLienObjetSelonEtat;
  es.bouton = self.boutonRelance;
  es.texte = es.bouton:CreateFontString(nil,"ARTWORK","NumberFontNormal");
  es.texte:SetAllPoints();
  es.boutonAttente = self.boutonRelanceAttente;
  es.sauvegarde = sauvegarde;

  function es:StateChanged(e)
    e = tonumber(e);
    if e~=0 then -- si e==0 c cache donc pas grave si mauvaise attente
      self.genre = self.genreSelonEtat[e];
      local deb,dur = 0,0;
      if self.genre==1 then
        self.sort = self.rangSortMaximumOuLienObjetSelonEtat[e]["sort"];
        self.rang = self.rangSortMaximumOuLienObjetSelonEtat[e]["rang"];
        local idSortMaximum = Chaman2.MenuAction.idSortSelonRang[self.sort][self.rang];
        deb, dur = GetSpellCooldown(idSortMaximum, BOOKTYPE_SPELL);
      elseif self.genre==2 then
        self.lienObjet = self.rangSortMaximumOuLienObjetSelonEtat[e];
        deb, dur = GetItemCooldown(self.lienObjet);
      end
      CooldownFrame_SetTimer(self.boutonAttente, deb, dur, 1);
      self.bouton:SetNormalTexture(self.textureSelonEtat[e]);
      self.texte:SetText(self.texteSelonEtat[e]);
    end 
    self.sauvegarde.selection = e; -- on sauvegarde meme 0
  end

  self.etatRelance:SetAttribute("state", sauvegarde.selection);

  self.boutonRelance.etat = self.etatRelance;
  self.boutonRelance.instance = self;
  self.boutonRelance:SetScript("OnEnter",function (self)
    if self.instance.class.afficheInfoBulle() then
      ChamanTooltip2:SetOwner(self,"ANCHOR_RIGHT");
      if self.etat.genre==1 then
        local sp = Chaman2.MenuAction.idSortSelonRang[self.etat.sort][self.etat.rang];
        if sp~=nil then
          ChamanTooltip2:SetSpell(sp,BOOKTYPE_SPELL);
        else
         ChamanTooltip2:ClearLines();
         ChamanTooltip2:SetText("No Spell",1,1,1);
        end
      elseif self.etat.genre==2 then
       ChamanTooltip2:SetHyperlink(self.etat.lienObjet);
      end
    end
  end);

  self.boutonRelance:SetScript("OnLeave",function ()
    ChamanTooltip2:Hide();
  end);




  for i=1,nb do
    if tab[i].genre==1 then
      self.etatRelance:SetAttribute("addchild",self.boutonLancerChanger[i]);
      self.boutonLancerChanger[i]:SetAttribute("type","spell");
      self.boutonLancerChanger[i]:SetAttribute("unit",tab[i].cible);
      self.boutonLancerChanger[i]:SetAttribute("newstate","*:"..i);
      self.boutonLancerChanger[i]:SetAttribute("spell-S"..i,tab[i].sort.."("..tab[i].rangMaximum..")");
      self.boutonLancerChanger[i]:SetAttribute("*spell-SM"..i,tab[i].sort.."("..tab[i].rangMinimum..")");

      self.etatRelance:SetAttribute("addchild",self.boutonLancer[i]);
      self.boutonLancer[i]:SetAttribute("type","spell");
      self.boutonLancer[i]:SetAttribute("unit",tab[i].cible);
      self.boutonLancer[i]:SetAttribute("spell-S"..i,tab[i].sort.."("..tab[i].rangMaximum..")");
      self.boutonLancer[i]:SetAttribute("*spell-SM"..i,tab[i].sort.."("..tab[i].rangMinimum..")");
    elseif tab[i].genre==2 then
      self.etatRelance:SetAttribute("addchild",self.boutonLancerChanger[i]);
      self.boutonLancerChanger[i]:SetAttribute("type","item");
      self.boutonLancerChanger[i]:SetAttribute("unit",tab[i].cible);
      self.boutonLancerChanger[i]:SetAttribute("newstate","*:"..i);
      self.boutonLancerChanger[i]:SetAttribute("item-S"..i,tab[i].nomObjet);
      self.boutonLancerChanger[i]:SetAttribute("*item-SM"..i,tab[i].nomObjet);

      self.etatRelance:SetAttribute("addchild",self.boutonLancer[i]);
      self.boutonLancer[i]:SetAttribute("type","item");
      self.boutonLancer[i]:SetAttribute("unit",tab[i].cible);
      self.boutonLancer[i]:SetAttribute("item-S"..i,tab[i].nomObjet);
      self.boutonLancer[i]:SetAttribute("*item-SM"..i,tab[i].nomObjet);
    end

    self.etatRelance:SetAttribute("addchild",self.boutonChanger[i]);
    self.boutonChanger[i]:SetAttribute("newstate","*:"..i);

    self.etats[i]:SetPoint("TOPLEFT",parent,"TOPLEFT",x+i*self.coteBouton*ch,-y-i*self.coteBouton*cv);
    self.etats[i]:SetWidth(30);
    self.etats[i]:SetHeight(30);

    if sauvegarde.selection~=0 then --
      if i<=sauvegarde.colle then
        self.etats[i]:SetAttribute("state", "3"); -- colle donc visible
      else
        self.etats[i]:SetAttribute("state", "2");
      end
    else -- mode visible tous les boutons
      if i<=sauvegarde.colle then
        self.etats[i]:SetAttribute("state", "1");
      else
        self.etats[i]:SetAttribute("state", "0");
      end
    end

    self.boutons[i]:SetAllPoints();
    self.boutons[i]:SetAttribute("hidestates", "2");
    self.boutons[i]:RegisterForClicks("LeftButtonUp","RightButtonUp");
    self.boutons[i]:SetAttribute("type","click");
    self.boutons[i]:SetAttribute("statebutton1","0,1:S0;3:S1");
    self.boutons[i]:SetAttribute("shift-statebutton1","0,1:S0;3:S1");
    self.boutons[i]:SetAttribute("statebutton2","0,1:S2;*:S"); -- etat 0 qqchose les autres rien

    -- S1 bouton gauche protege 'colle' (comportement commun) 
    self.boutons[i]:SetAttribute("*clickbutton-S1",self.boutonsSortLancer[i]);

    if cmp==1 then
      self.boutons[i]:SetAttribute("*clickbutton-S0",self.boutonsDemarrerCacherChanger[i]);
      self.boutons[i]:SetAttribute("*clickbutton-S2",self.boutonsSortLancer[i]);
    elseif cmp==2 then
      self.boutons[i]:SetAttribute("*clickbutton-S0",self.boutonsSortLancer[i]);
      self.boutons[i]:SetAttribute("*clickbutton-S2",self.boutonsDemarrerCacherChanger[i]);
    elseif cmp==3 then
      DEFAULT_CHAT_FRAME:AddMessage("Desactived behavior 3");
      -- self.boutons[i]:SetAttribute("clickbutton-S0",self.boutonsSortLancer[i]);
      -- self.boutons[i]:SetAttribute("clickbutton-S2",self.boutonsSortChanger[i]); -- change mais ne cache pas
      -- pas tout a fait l'ancienne methode (2 fois = cache)
    elseif cmp==4 then
      self.boutons[i]:SetAttribute("*clickbutton-S0",self.boutonsDemarrerCacherLancerChanger[i]);
      self.boutons[i]:SetAttribute("*clickbutton-S2",self.boutonsDemarrerCacherChanger[i]);
    end

    self.boutons[i]:SetAttribute("ctrl-clickbutton1",self.demarrerEchange[i]);
    self.boutons[i]:SetAttribute("ctrl-shift-clickbutton1",self.demarrerEchange[i+1]);
    -- avec le droit met directement aux extremites
    -- self.boutons[i]:SetAttribute("ctrl-clickbutton2",self.demarrerEchangeExtreme[i]);
    -- self.boutons[i]:SetAttribute("ctrl-shift-clickbutton2",self.demarrerEchangeExtreme[i+1]);

    
    -- demarrage diff selon etatsSort ne modifie pas directement l'etat


    self.boutons[i].etat = self.etatsSort[i];
    self.boutons[i].instance = self;
    self.boutons[i]:SetScript("OnEnter",function (self)
      if self.instance.class.afficheInfoBulle() then
        ChamanTooltip2:SetOwner(self,"ANCHOR_RIGHT");
        if self.etat.genre==1 then
          local sp = Chaman2.MenuAction.idSortSelonRang[self.etat.sort][self.etat.rang];
          if sp~=nil then
            ChamanTooltip2:SetSpell(sp,BOOKTYPE_SPELL);
          else
           ChamanTooltip2:ClearLines();
           ChamanTooltip2:SetText("No Spell",1,1,1);
          end
        elseif self.etat.genre==2 then
         ChamanTooltip2:SetHyperlink(self.etat.lienObjet);
        end
      end
    end);

    self.boutons[i]:SetScript("OnLeave",function ()
      ChamanTooltip2:Hide();
    end);





    local es = self.etatsSort[i];
    es.textureSelonEtat = textureSelonEtat;
    es.texteSelonEtat = texteSelonEtat;
    es.genreSelonEtat = genreSelonEtat;
    es.rangSortMaximumOuLienObjetSelonEtat = rangSortMaximumOuLienObjetSelonEtat;
    es.bouton = self.boutons[i];
    es.texte = es.bouton:CreateFontString(nil,"ARTWORK","NumberFontNormal");
    es.texte:SetAllPoints();
    es.boutonAttente = self.boutonsAttente[i];
    es.places = sauvegarde.places;
    es.placeEtat = i;

    function es:StateChanged(e) -- devrait aussi changer le tooltip (+ tard)
      e = tonumber(e);
      if e~=0 then -- si e==0 c cache donc pas grave si mauvaise attente
        self.genre = self.genreSelonEtat[e];
        local deb,dur = 0,0;
        if self.genre==1 then
          self.sort = self.rangSortMaximumOuLienObjetSelonEtat[e]["sort"];
          self.rang = self.rangSortMaximumOuLienObjetSelonEtat[e]["rang"];
          local idSortMaximum = Chaman2.MenuAction.idSortSelonRang[self.sort][self.rang];
          deb, dur = GetSpellCooldown(idSortMaximum, BOOKTYPE_SPELL);
        elseif self.genre==2 then
          self.lienObjet = self.rangSortMaximumOuLienObjetSelonEtat[e];
          deb, dur = GetItemCooldown(self.lienObjet);
        end
        CooldownFrame_SetTimer(self.boutonAttente, deb, dur, 1);
        self.bouton:SetNormalTexture(self.textureSelonEtat[e]);
        self.texte:SetText(self.texteSelonEtat[e]);
        self.places[self.placeEtat] = e;
      end
    end


    self.etatsSort[i]:SetAttribute("state", sauvegarde.places[i]);
    self.etatsSort[i]:SetAttribute("addchild",self.boutonsSortLancerChanger[i]);
    self.boutonsSortLancerChanger[i]:SetAttribute("type","click");
    self.boutonsSortLancerChanger[i]:SetAttribute("statebutton*",sortSelonEtat);
    self.boutonsSortLancerChanger[i]:SetAttribute("shift-statebutton*",sortMinimumSelonEtat);
    for l=1,nb do
      self.boutonsSortLancerChanger[i]:SetAttribute("clickbutton-S"..l,self.boutonLancerChanger[l]);
      self.boutonsSortLancerChanger[i]:SetAttribute("*clickbutton-SM"..l,self.boutonLancerChanger[l]);
    end

    self.etatsSort[i]:SetAttribute("addchild",self.boutonsSortLancer[i]);
    self.boutonsSortLancer[i]:SetAttribute("type","click");
    self.boutonsSortLancer[i]:SetAttribute("statebutton*",sortSelonEtat);
    self.boutonsSortLancer[i]:SetAttribute("shift-statebutton*",sortMinimumSelonEtat);
    for l=1,nb do
      self.boutonsSortLancer[i]:SetAttribute("clickbutton-S"..l,self.boutonLancer[l]);
      self.boutonsSortLancer[i]:SetAttribute("*clickbutton-SM"..l,self.boutonLancer[l]);
    end

    self.etatsSort[i]:SetAttribute("addchild",self.boutonsSortChanger[i]);
    self.boutonsSortChanger[i]:SetAttribute("type","click");
    self.boutonsSortChanger[i]:SetAttribute("statebutton",sortSelonEtat);
    for l=1,nb do
      self.boutonsSortChanger[i]:SetAttribute("clickbutton-S"..l,self.boutonChanger[l]);
    end

    -- demarrage echange
    self.etatsSort[i]:SetAttribute("addchild",self.demarrerEchange[i]);
    self.demarrerEchange[i]:SetAttribute("type","click");
    local cs = "";
    for l=1,nb do
      cs = cs..l..":E"..l..";";
    end
    self.demarrerEchange[i]:SetAttribute("statebutton",cs);
    self.demarrerEchange[i]:SetAttribute("clickbutton",self.echangeSuivant[i-1]);

    -- echange suivant
    self.etatsSort[i]:SetAttribute("addchild",self.echangeSuivant[i]);
    self.echangeSuivant[i]:SetAttribute("type","click");

    for z=1,nb do
      local cs = "";
      for l=1,nb do
        cs = cs..l..":E"..z.."V"..l..";";
        self.echangeSuivant[i]:SetAttribute("*newstate-E"..z.."V"..l,"*:"..z);
      end
      self.echangeSuivant[i]:SetAttribute("*statebutton-E"..z,cs);
    end
    self.echangeSuivant[i]:SetAttribute("*clickbutton*",self.fixer[i+1]);
    
    -- termine echange
    self.etatsSort[i]:SetAttribute("addchild", self.fixer[i]);
    for z=1,nb do
      for l=1,nb do
        self.fixer[i]:SetAttribute("*newstate-E"..z.."V"..l,"*:"..l);
      end
    end

    -- positionne .... et fixe la taille a faire
    self.etats[i]:SetAttribute("addchild", self.boutons[i]);


    -- tout affiche entraine soit etat 2 soit 3 (de plus le bouton appelle le suivant)
    self.boutonsToutAffiche[i]:SetAttribute("newstate", "2:0;3:1");
    self.boutonsToutAffiche[i]:SetAttribute("type","click");
    self.boutonsToutAffiche[i]:SetAttribute("clickbutton",self.boutonsToutAffiche[i+1]);
    self.etats[i]:SetAttribute("addchild", self.boutonsToutAffiche[i]);

    -- cache (pourrait etre mis avec cache et lance [lance S0 -> pas de sort]
    self.etats[i]:SetAttribute("addchild", self.boutonsCacher[i]);
    self.boutonsCacher[i]:SetAttribute("newstate", "0:2;1:3");
    self.boutonsCacher[i]:SetAttribute("type","click");
    self.boutonsCacher[i]:SetAttribute("clickbutton",self.boutonsCacher[i+1]);


    -- donne le nom du sort en bouton avant de cacher
    self.etats[i]:SetAttribute("addchild", self.boutonsDemarrerCacherLancerChanger[i]);
    self.boutonsDemarrerCacherLancerChanger[i]:SetAttribute("statebutton","*:LC"..i);
    self.boutonsDemarrerCacherLancerChanger[i]:SetAttribute("type","click");
    self.boutonsDemarrerCacherLancerChanger[i]:SetAttribute("*clickbutton-LC"..i,self.boutonsCacherLancer[1]);

    self.etats[i]:SetAttribute("addchild", self.boutonsDemarrerCacherChanger[i]);
    self.boutonsDemarrerCacherChanger[i]:SetAttribute("statebutton","*:C"..i);
    self.boutonsDemarrerCacherChanger[i]:SetAttribute("type","click");
    self.boutonsDemarrerCacherChanger[i]:SetAttribute("*clickbutton-C"..i,self.boutonsCacherLancer[1]);


    -- cache et lance S
    self.etats[i]:SetAttribute("addchild", self.boutonsCacherLancer[i]);

    self.boutonsCacherLancer[i]:SetAttribute("newstate", "0:2;1:3"); -- sert a cacher
    self.boutonsCacherLancer[i]:SetAttribute("type","click");

    if i==nb then
      for z=1,nb do
        self.boutonsCacherLancer[i]:SetAttribute("*clickbutton-LC"..z,self.boutonsSortLancerChanger[z]);
        self.boutonsCacherLancer[i]:SetAttribute("*clickbutton-C"..z,self.boutonsSortChanger[z]);
      end
    else
      self.boutonsCacherLancer[i]:SetAttribute("*clickbutton*",self.boutonsCacherLancer[i+1]);
    end
    -- clickbutton reviens et click sur le sort la deuxieme fois



    -- ajouter
    self.boutonsAjouter[i].sauvegarde = sauvegarde;
    self.boutonsAjouter[i].position = i;
    self.boutonsAjouter[i]:SetScript("PreClick",function (self)
      self.sauvegarde.colle = self.position;
    end);

    self.boutonsAjouter[i]:SetAttribute("newstate", "0:1;2:3");
    self.boutonsAjouter[i]:SetAttribute("statebutton","1,3:S0;0,2:S1;");
    self.boutonsAjouter[i]:SetAttribute("type","click");
    self.boutonsAjouter[i]:SetAttribute("*clickbutton-S0",self.boutonsAjouter[i+1]);
    self.etats[i]:SetAttribute("addchild", self.boutonsAjouter[i]);

    -- retirer
    self.boutonsRetirer[i].sauvegarde = sauvegarde;
    self.boutonsRetirer[i].position = i;
    self.boutonsRetirer[i]:SetScript("PreClick",function (self)
      self.sauvegarde.colle = self.position - 1;
    end);
    self.boutonsRetirer[i]:SetAttribute("newstate", "1:0;3:2");
    self.boutonsRetirer[i]:SetAttribute("statebutton","0,2:S0;1,3:S1;");
    self.boutonsRetirer[i]:SetAttribute("type","click");
    self.boutonsRetirer[i]:SetAttribute("*clickbutton-S0",self.boutonsRetirer[i-1]);
    self.etats[i]:SetAttribute("addchild", self.boutonsRetirer[i]);

    
  end

  for nom,val in pairs(sauvegarde.etats) do
    self.restaureEtatRelance:SetAttribute("clickbutton-"..nom,self.restaureEtats[1]);
    local er = val.selection;
    self.restaureEtatRelance:SetAttribute("newstate-"..nom,er);

    -- 0 et 2 : etat pas colle [0 ouvert, 2 ferme]
    -- 1 et 3 : etats colle [1 ouvert,3 ferme]
    for i=1,self.nb do
      local ev;
      if val.selection==0 then -- ouvert
        if i<=val.colle then -- colle
          ev = 1;
        else
          ev = 0;
        end
      else -- ferme
        if i<=val.colle then 
          ev = 3;
        else
          ev = 2;
        end
      end
      self.restaureEtats[i]:SetAttribute("clickbutton-"..nom,self.restaureEtatsSort[i]);
      self.restaureEtats[i]:SetAttribute("newstate-"..nom,ev);
      local es = val.places[i];
      if i~=self.nb then
        self.restaureEtatsSort[i]:SetAttribute("clickbutton-"..nom,self.restaureEtats[i+1]);
      end
      self.restaureEtatsSort[i]:SetAttribute("newstate-"..nom,es);
    end
  end



  self.sauvegarde = sauvegarde;
  
  return self;
end

function Chaman2.MenuAction.methodes:actualiserAssociation()
  if self.associer~=nil then
    raccourci1,raccourci2 = GetBindingKey(self.associer);
    Chaman2.associerBouton(self:raccourci(),raccourci1,raccourci2);
  end
end

function Chaman2.MenuAction.methodes:lierSauvegardeA(nom,suiv) -- ceci n'est pas conserve (du a la nature de la liaison)
  self.restaureEtatsSort[self.nb]:SetAttribute("clickbutton-"..nom,suiv);
  return self.restaureEtatRelance;
end

function Chaman2.MenuAction.methodes:detruireEtat(nom)
  self.restaureEtatRelance:SetAttribute("clickbutton-"..nom,nil);
  self.restaureEtatRelance:SetAttribute("newstate-"..nom,nil);
  self.sauvegarde.etats[nom] = nil;
end

function Chaman2.MenuAction.methodes:sauvegarderEtat(nom) -- la sauvegarde devra etre 
  self.restaureEtatRelance:SetAttribute("clickbutton-"..nom,self.restaureEtats[1]);
  local er = tonumber(self.etatRelance:GetAttribute("state"));
  self.restaureEtatRelance:SetAttribute("newstate-"..nom,er);

  self.sauvegarde.etats[nom] = {["selection"] = er, ["places"]={}, ["colle"] = 0,};

  for i=1,self.nb do
    local ev = tonumber(self.etats[i]:GetAttribute("state"));
    if ev==1 or ev==3 then -- 1 ou 3 = etat colle
      self.sauvegarde.etats[nom].colle = self.sauvegarde.etats[nom].colle+1;
    end
    self.restaureEtats[i]:SetAttribute("clickbutton-"..nom,self.restaureEtatsSort[i]);
    self.restaureEtats[i]:SetAttribute("newstate-"..nom,ev);
    local es = tonumber(self.etatsSort[i]:GetAttribute("state"));
    table.insert(self.sauvegarde.etats[nom].places,es);
    if i~=self.nb then
      self.restaureEtatsSort[i]:SetAttribute("clickbutton-"..nom,self.restaureEtats[i+1]);
    end
    self.restaureEtatsSort[i]:SetAttribute("newstate-"..nom,es);
  end
end

function Chaman2.MenuAction.methodes:raccourci()
  return self.boutonRaccourci;
end

function Chaman2.MenuAction.methodes:fixerPosition(parent,x,y)
  self.parent = parent;
  self.x = x;
  self.y = y;
  self.etatRelance:SetPoint("TOPLEFT",parent,"TOPLEFT",x,-y);
  for i,v in ipairs(self.etats) do
    v:SetPoint("TOPLEFT",parent,"TOPLEFT",x+i*self.coteBouton*self.ch,-y-i*self.coteBouton*self.cv);
  end
end


function Chaman2.MenuAction.methodes:modifierSens(versGauche)
  self.cv = 0;
  if versGauche then
    self.ch = 1;
  else
    self.ch = -1;
  end
  for i=1,self.nb do
    self.etats[i]:SetPoint("TOPLEFT",self.parent,"TOPLEFT",self.x+i*self.coteBouton*self.ch,-self.y-i*self.coteBouton*self.cv);
  end
end

