if not Chaman2 then
  Chaman2 = {};
end

Chaman2.InterfaceUtilisateur = {};


function Chaman2.InterfaceUtilisateur:addCheckedOption(f,oncli,texte,check,pos)
  local fcheckbutton = CreateFrame("CheckButton",nil,f);
  fcheckbutton:SetNormalTexture("Interface\\Buttons\\UI-CheckBox-Up");
  fcheckbutton:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check");
  fcheckbutton:SetWidth(30);
  fcheckbutton:SetHeight(30);
  fcheckbutton:SetPoint("TOPLEFT",f,"TOPLEFT",20,-30-pos*30);
  fcheckbutton:SetChecked(check);
  fcheckbutton:SetScript("OnClick", oncli);
  local ft = fcheckbutton:CreateFontString(nil,"ARTWORK","GameFontNormalSmall");
  ft:SetText(texte);
  ft:SetPoint("LEFT",fcheckbutton,"RIGHT",0,0);
  ft:SetTextHeight(10);
end


function Chaman2.InterfaceUtilisateur:construireFrame()
  local class = self;
  self = nil;

  local f = CreateFrame("Frame","ConfigurationChaman2",UIParent);
  f:SetFrameStrata("DIALOG");
  f:SetPoint("CENTER",UIParent,"CENTER");
  f:SetWidth(400);
  f:SetHeight(200);
  f:EnableMouse(true);
  f:SetMovable(true);
  f:RegisterForDrag("LeftButton");
  f:SetScript("OnDragStop",function (self)
    self:StopMovingOrSizing();
  end);
  f:SetScript("OnDragStart",function (self)
    self:StartMoving();
  end);
  f:Hide();

  local bckd = {};
  bckd.bgFile = "Interface/DialogFrame/UI-DialogBox-Background";
  bckd.edgeFile = "Interface/DialogFrame/UI-DialogBox-Border";
  bckd.tile = true;
  bckd.tileSize = 32;
  bckd.edgeSize = 32;
  bckd.insets = {};
  bckd.insets.left = 11;
  bckd.insets.right = 12;
  bckd.insets.top = 12;
  bckd.insets.bottom = 11;
  f:SetBackdrop(bckd);
  f:SetBackdropColor(0,0,0,1);
  f:SetBackdropBorderColor(.8,.8,.8,1);

  local tx = f:CreateTexture();
  tx:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Header");
  tx:SetTexCoord(.2, .8, 0, 0.6);
  tx:SetWidth(160);
  tx:SetHeight(32);
  tx:SetPoint("TOP",f,"TOP",0,5);
  
  local ft = f:CreateFontString(nil,"ARTWORK","GameFontNormalSmall");
  ft:SetText("Chaman2");
  ft:SetPoint("TOP",f,"TOP",0,-6);
  ft:SetTextHeight(10);

  local fferme = CreateFrame("Button",nil,f);
  fferme:SetText("close");
  fferme:SetWidth(72);
  fferme:SetHeight(19);
  fferme:SetPoint("BOTTOMRIGHT",f,"BOTTOMRIGHT",-15,15);
  local tx1 = fferme:CreateTexture();
  tx1:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up");
  tx1:SetAllPoints(fferme);
  tx1:SetTexCoord(0, .625, 0, 0.6875);
  local tx2 = fferme:CreateTexture();
  tx2:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down");
  tx2:SetAllPoints(fferme);
  tx2:SetTexCoord(0, .625, 0, 0.6875);
  fferme:SetTextFontObject("GameFontNormalSmall");
  fferme:SetNormalTexture(tx1);
  fferme:SetPushedTexture(tx2);
  fferme:SetScript("OnClick", function(self) ConfigurationChaman2:Hide(); end);

  Chaman2.InterfaceUtilisateur:addCheckedOption(f,
    function() 
    if not donneesChaman2.peutBouger then
      for nf,_ in pairs(Chaman2.boites) do
        getglobal(nf):EnableMouse(true);
      end
      donneesChaman2.peutBouger = true;
    else
      for nf,_ in pairs(Chaman2.boites) do
        getglobal(nf):EnableMouse(false);
      end
      donneesChaman2.peutBouger = false;
    end
   end,"Check to lock positions of all frames",not donneesChaman2.peutBouger,0);
   
  Chaman2.InterfaceUtilisateur:addCheckedOption(f,
    function() 
      if donneesChaman2.afficheInfoBulle then
        donneesChaman2.afficheInfoBulle = false;
      else
        donneesChaman2.afficheInfoBulle = true;
      end
   end,"Check to display tooltips",donneesChaman2.afficheInfoBulle,1);



  Chaman2.frameSelectionnee = "Totems";

  local fslider = CreateFrame("Frame","ploufplif",f,"UIDropDownMenuTemplate");

  fslider:SetPoint("TOPLEFT",f,"TOPLEFT",100,-30-2*30);
  UIDropDownMenu_Initialize(fslider, function ()
    
    info = {};
    info.text = "Totem";
    info.func = function() 
      Chaman2.frameSelectionnee = "Totems";
      UIDropDownMenu_SetSelectedName(getglobal("ploufplif"), "Totem", false);
    end;
    UIDropDownMenu_AddButton(info);
    info = {};
    info.text = "Shield & Weapon";
    info.func = function()
      Chaman2.frameSelectionnee = "ArmeBouclier";
      UIDropDownMenu_SetSelectedName(getglobal("ploufplif"), "Shield & Weapon", false); 
    end;
    UIDropDownMenu_AddButton(info);
    info = {};
    info.text = "Earth shield";
    info.func = function()
      local nomSelonNum = {"Totems","ArmeBouclier","Terre","Ankh","BoutonsDeClasse","Vague"};
      Chaman2.frameSelectionnee = "Terre";
      UIDropDownMenu_SetSelectedName(getglobal("ploufplif"), "Earth shield", false); 
    end;
    UIDropDownMenu_AddButton(info);
    info = {};
    info.text = "Ankh";
    info.func = function() 
        Chaman2.frameSelectionnee = "Ankh";
        UIDropDownMenu_SetSelectedName(getglobal("ploufplif"), "Ankh", false); 
    end;
    UIDropDownMenu_AddButton(info);
    info = {};
    info.text = "Class";
    info.func = function() 
      Chaman2.frameSelectionnee = "BoutonsDeClasse";
      UIDropDownMenu_SetSelectedName(getglobal("ploufplif"), "Class", false); 
    end;
    UIDropDownMenu_AddButton(info);
    info = {};
    info.text = "Healing way";
    info.func = function()
      Chaman2.frameSelectionnee = "Vague";
      UIDropDownMenu_SetSelectedName(getglobal("ploufplif"), "Healing way", false); 
    end;
    UIDropDownMenu_AddButton(info);
    
  end);
  UIDropDownMenu_SetSelectedID(fslider, 1, false); 


  local fhide = CreateFrame("Button",nil,f);
  fhide:SetText("hide");
  fhide:SetWidth(72);
  fhide:SetHeight(19);
  fhide:SetPoint("TOPLEFT",f,"TOPLEFT",20,-30-3.5*30);
  local tx1 = fhide:CreateTexture();
  tx1:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up");
  tx1:SetAllPoints(fhide);
  tx1:SetTexCoord(0, .625, 0, 0.6875);
  local tx2 = fhide:CreateTexture();
  tx2:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down");
  tx2:SetAllPoints(fhide);
  tx2:SetTexCoord(0, .625, 0, 0.6875);
  fhide:SetTextFontObject("GameFontNormalSmall");
  fhide:SetNormalTexture(tx1);
  fhide:SetPushedTexture(tx2);
  fhide:SetScript("OnClick", function(self) 
    donneesChaman2.frames[Chaman2.frameSelectionnee].visible = false;
    local f = getglobal(Chaman2.frameSelectionnee);
    if f then 
      f:Hide();
    end
  end);


  local fhide = CreateFrame("Button",nil,f);
  fhide:SetText("show");
  fhide:SetWidth(72);
  fhide:SetHeight(19);
  fhide:SetPoint("TOPLEFT",f,"TOPLEFT",100,-30-3.5*30);
  local tx1 = fhide:CreateTexture();
  tx1:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up");
  tx1:SetAllPoints(fhide);
  tx1:SetTexCoord(0, .625, 0, 0.6875);
  local tx2 = fhide:CreateTexture();
  tx2:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down");
  tx2:SetAllPoints(fhide);
  tx2:SetTexCoord(0, .625, 0, 0.6875);
  fhide:SetTextFontObject("GameFontNormalSmall");
  fhide:SetNormalTexture(tx1);
  fhide:SetPushedTexture(tx2);
  fhide:SetScript("OnClick", function(self) 
    donneesChaman2.frames[Chaman2.frameSelectionnee].visible = true;
    local f = getglobal(Chaman2.frameSelectionnee);
    if f then 
      f:Show();
    end
  end);

  local fhide = CreateFrame("Button",nil,f);
  fhide:SetText("leftmode");
  fhide:SetWidth(72);
  fhide:SetHeight(19);
  fhide:SetPoint("TOPLEFT",f,"TOPLEFT",180,-30-3.5*30);
  local tx1 = fhide:CreateTexture();
  tx1:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up");
  tx1:SetAllPoints(fhide);
  tx1:SetTexCoord(0, .625, 0, 0.6875);
  local tx2 = fhide:CreateTexture();
  tx2:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down");
  tx2:SetAllPoints(fhide);
  tx2:SetTexCoord(0, .625, 0, 0.6875);
  fhide:SetTextFontObject("GameFontNormalSmall");
  fhide:SetNormalTexture(tx1);
  fhide:SetPushedTexture(tx2);
  fhide:SetScript("OnClick", function(self) 
    local boite = Chaman2.Boite:obtenirParNom(Chaman2.frameSelectionnee);
    if boite then -- barre de classe
      boite:modifierSens(true);
    end
    donneesChaman2.frames[Chaman2.frameSelectionnee].mode = 0;
  end);

  local fhide = CreateFrame("Button",nil,f);
  fhide:SetText("rightmode");
  fhide:SetWidth(72);
  fhide:SetHeight(19);
  fhide:SetPoint("TOPLEFT",f,"TOPLEFT",260,-30-3.5*30);
  local tx1 = fhide:CreateTexture();
  tx1:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up");
  tx1:SetAllPoints(fhide);
  tx1:SetTexCoord(0, .625, 0, 0.6875);
  local tx2 = fhide:CreateTexture();
  tx2:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down");
  tx2:SetAllPoints(fhide);
  tx2:SetTexCoord(0, .625, 0, 0.6875);
  fhide:SetTextFontObject("GameFontNormalSmall");
  fhide:SetNormalTexture(tx1);
  fhide:SetPushedTexture(tx2);
  fhide:SetScript("OnClick", function(self) 
    local boite = Chaman2.Boite:obtenirParNom(Chaman2.frameSelectionnee);
    if boite then -- barre de classe
      boite:modifierSens(false);
    end
    donneesChaman2.frames[Chaman2.frameSelectionnee].mode = 1;
  end);

end


function Chaman2.InterfaceUtilisateur:commandeLigne(msg)
  if msg=="lock" then
    for nf,_ in pairs(Chaman2.boites) do
      getglobal(nf):EnableMouse(false);
    end
    donneesChaman2.peutBouger = false;
    DEFAULT_CHAT_FRAME:AddMessage("Chaman2 : frames locked");
  elseif msg=="unlock" then
    for nf,_ in pairs(Chaman2.boites) do
      getglobal(nf):EnableMouse(true);
    end
    donneesChaman2.peutBouger = true;
    DEFAULT_CHAT_FRAME:AddMessage("Chaman2 : frames unlocked");
  elseif msg=="tooltip" then
    if donneesChaman2.afficheInfoBulle then
      donneesChaman2.afficheInfoBulle = false;
      DEFAULT_CHAT_FRAME:AddMessage("Chaman2 : tooltips hidden");
    else
      donneesChaman2.afficheInfoBulle = true;
      DEFAULT_CHAT_FRAME:AddMessage("Chaman2 : tooltips shown");
    end
  elseif string.find(msg,"select",1,true)==1 then
    local nb = Chaman2.premierEntierChaine(msg);
    if nb>=1 and nb<=6 then
      local nomSelonNum = {"Totems","ArmeBouclier","Terre","Ankh","BoutonsDeClasse","Vague"};
      Chaman2.frameSelectionnee = nomSelonNum[nb];
    else
      DEFAULT_CHAT_FRAME:AddMessage("Chaman2 : list of frames");
      DEFAULT_CHAT_FRAME:AddMessage("1 -> totems frame");
      DEFAULT_CHAT_FRAME:AddMessage("2 -> weapons buff and elemental shield frame");
      DEFAULT_CHAT_FRAME:AddMessage("3 -> earth shield frame");
      DEFAULT_CHAT_FRAME:AddMessage("4 -> ankh frame");
      DEFAULT_CHAT_FRAME:AddMessage("5 -> class set frame");
      DEFAULT_CHAT_FRAME:AddMessage("6 -> flot soins frame");
    end
  elseif msg=="hide" then
    if Chaman2.frameSelectionnee==nil then
      DEFAULT_CHAT_FRAME:AddMessage("please select a frame first");
    else
      donneesChaman2.frames[Chaman2.frameSelectionnee].visible = false;
      local f = getglobal(Chaman2.frameSelectionnee);
      if f then 
        f:Hide();
      end
    end
  elseif msg=="show" then
    if Chaman2.frameSelectionnee==nil then
      DEFAULT_CHAT_FRAME:AddMessage("please select a frame first");
    else
      donneesChaman2.frames[Chaman2.frameSelectionnee].visible = true;
      local f = getglobal(Chaman2.frameSelectionnee);
      if f then 
        f:Show();
      end
    end
  elseif msg=="rightmode" then
    if Chaman2.frameSelectionnee==nil then
      DEFAULT_CHAT_FRAME:AddMessage("please select a frame first");
    else
      local boite = Chaman2.Boite:obtenirParNom(Chaman2.frameSelectionnee);
      if boite then -- barre de classe
        boite:modifierSens(false);
      end
      donneesChaman2.frames[Chaman2.frameSelectionnee].mode = 1;
    end
  elseif msg=="leftmode" then
    if Chaman2.frameSelectionnee==nil then
      DEFAULT_CHAT_FRAME:AddMessage("please select a frame first");
    else
      local boite = Chaman2.Boite:obtenirParNom(Chaman2.frameSelectionnee);
      if boite then -- barre de classe
        boite:modifierSens(true);
      end
      donneesChaman2.frames[Chaman2.frameSelectionnee].mode = 0;
    end
  elseif msg=="a" then
    donneesChaman2.frames:changerFacteur(-1,-1);
  elseif msg=="" then
    ConfigurationChaman2:Show();
  else 
    if msg~="?" and msg~="help" then 
      DEFAULT_CHAT_FRAME:AddMessage("Command unknown : "..msg);
    end
    DEFAULT_CHAT_FRAME:AddMessage("-------------------------");
    DEFAULT_CHAT_FRAME:AddMessage("Chaman2 version "..donneesChaman2.version);
    DEFAULT_CHAT_FRAME:AddMessage("unlock");
    DEFAULT_CHAT_FRAME:AddMessage("lock");
    DEFAULT_CHAT_FRAME:AddMessage("tooltip");
    DEFAULT_CHAT_FRAME:AddMessage("select [n]");
    DEFAULT_CHAT_FRAME:AddMessage("hide");
    DEFAULT_CHAT_FRAME:AddMessage("show");
    DEFAULT_CHAT_FRAME:AddMessage("rightmode");
    DEFAULT_CHAT_FRAME:AddMessage("leftmode");
    DEFAULT_CHAT_FRAME:AddMessage("-------------------------");
  end
end


