if not Chaman2 then
  Chaman2 = {};
end

if Chaman2.traduction then

  Chaman2.cibleFlots = {"","",""};

  -- le nom de la cible est pas suffisant
  -- il faudrait un raccourci pr obtenir les tics

  -- comment faire la despec ?
  function Chaman2.flotTicsDetruitTemps(param)
    local chemin,trouve = Chaman2.trouverChemin(Chaman2.cibleFlots[param]);
    if not trouve then
      return "?",false;
    end
    local n,_,_,tics = Chaman2.infosBuff(chemin,Chaman2.traduction.flotsDeSoins);
    if n then
      return tics,false;
    else
      return 0,true;
    end
  end

  -- juste actif (si sur soi ignore [ou plutot enlever])
  function Chaman2.bouclierTerreTicsDetruit(ame)
    if donneesChaman2.cibleBouclierDeTerre==nil then -- si il est sur le joueur n'affiche pas le temps
      return 0,false;
    end
    if Chaman2.NomAvcRoyaume(donneesChaman2.cheminCibleBouclierDeTerre)~=donneesChaman2.cibleBouclierDeTerre then
      -- essaye de trouver (sauf si c target -> dans ce cas reessaye a un changement de groupe)
      -- pr le moment tjs
      local trouve = false;
      donneesChaman2.cheminCibleBouclierDeTerre,trouve = Chaman2.trouverChemin(donneesChaman2.cibleBouclierDeTerre);
      if not trouve then
        -- on ne sais rien de l'amelioration
        return "?",false;
      end
    end

    local n,_,_,tics = Chaman2.infosBuff(donneesChaman2.cheminCibleBouclierDeTerre,ame);
    if n then
      return tics,false;
    else
      return 0,true;
    end
  end


  -- remarque si l'amelioration reapparait le tempo redevient actif (ca gere)
  function Chaman2.bouclierTicsDetruitTemps(ame)
    local id = -1;
    for i=0,31 do
      id,_ = GetPlayerBuff(i,"HELPFUL"); -- pas les debuffs ou les passifs
      if id < 0 then
        return 0,true,-1;
      elseif GetPlayerBuffName(id)==ame then
        return GetPlayerBuffApplications(id),false,GetPlayerBuffTimeLeft(id); -- nb tics, en gris, tps passif
      end
    end
    return 0,true,-1; -- plus de tics, en rouge, tps actif
  end



  function Chaman2.remplaceCible(cible,num)
    if Chaman2.pointDansTalent(Chaman2.traduction.talentFlotsDeSoins,3)~=3 then
      -- si pas 3 points desactive
      return false;
    end
    local max=3;
    -- si on a encore la cible alors on la garde (remise a zero timer)
    if Chaman2.cibleFlots[num]==cible then
      return true;
    end
    -- un 4e qui recoit un flot que se passe t'il ? --> celui qui a recu le flot le plus lointain est remplace
    -- savoir qui l'a recu en premier n'est pas genial

    -- si il y a une place libre avant on preferera la place libre avant
    -- de meme si qq1 l'a deja specifie on le preferera
    for i=1,num-1 do
      if Chaman2.cibleFlots[i]=="" or Chaman2.cibleFlots[i]==cible then
        return false;
      end
    end
    -- si apres qq1 l'a spec on abandonne
    for i=num+1,max do
      if Chaman2.cibleFlots[i]==cible then
        return false;
      end
    end

    -- si on est libre on autorise a prendre la place
    if Chaman2.cibleFlots[num]=="" then
      Chaman2.cibleFlots[num] = cible;
      return true;
    end

    -- cas restants : personne ne l'a specifie et on est pas libre
    -- pour le moment on refuse mais on pourrais accepter de respec dans le cas ou notre timer date du plus longtps


    -- pour le moment on ignore les flots sur la derniere cible (bcp plus simple il suffit de refuser la spec)
    return false;
  end

  -- parent = UIParent
  Chaman2.boites = {
    ["Ankh"] = {
      ["temporisateurs"] = {"TemporisateurAnkh"},
    },
    ["ArmeBouclier"] = { 
      ["temporisateurs"] = {"TemporisateurArme","TemporisateurBouclier"},
      ["lanceurs"] = {"LanceurArme","LanceurBouclier"},
    },
    ["Terre"] = {
      ["temporisateurs"] = {"TemporisateurBouclierTerre"},
      ["lanceurs"] = {"LanceurBouclierTerre"},
    },
    ["Totems"] = {
      ["temporisateurs"] = {"TemporisateurAir","TemporisateurEau","TemporisateurFeu","TemporisateurTerre"},
      ["lanceurs"] = {"LanceurAir","LanceurEau","LanceurFeu","LanceurTerre"},
      ["chaine"] = { "CHAMAN2RELANCE" , "CHAMAN2PASSE", "CHAMAN2APPEL" }, -- lancer, passer, lancer precedant
    },
    ["Vague"] = {
      ["temporisateurs"] = {"TemporisateurVague1","TemporisateurVague2","TemporisateurVague3"},
    },
  };


  -- default reste tout le tout
  Chaman2.proprieteTemporisateur = {
    ["TemporisateurBouclier"] = {
      ["enleverMort"] = true;
      ["enleverZone"] = true; -- entree d'une instance
    },
    ["TemporisateurAir"] = {
      ["enleverMort"] = true;
      ["enleverZone"] = true;
      ["sortEnlevant"] = function (s,r,c)
        if s==Chaman2.traduction.appelTotemique then
          return true;
        end
        return false;
      end;
    },
    ["TemporisateurEau"] = {
      ["enleverMort"] = true;
      ["enleverZone"] = true; 
      ["sortEnlevant"] = function (s,r,c)
        if s==Chaman2.traduction.appelTotemique then
          return true;
        end
        return false;
      end;
    },
    ["TemporisateurFeu"] = {
      ["enleverMort"] = true;
      ["enleverZone"] = true; 
      ["sortEnlevant"] = function (s,r,c)
        if s==Chaman2.traduction.appelTotemique then
          return true;
        end
        return false;
      end;
    },
    ["TemporisateurTerre"] = {
      ["enleverMort"] = true;
      ["enleverZone"] = true;
      ["sortEnlevant"] = function (s,r,c)
        if s==Chaman2.traduction.appelTotemique then
          return true;
        end
        return false;
      end;
    },
    ["TemporisateurBouclierTerre"] = {
      ["sortEnlevant"] = function (s,r,c)
        if s==Chaman2.traduction.bouclierDeTerre and c==UnitName("player") then
          return true;
        end
        return false;
      end;
    },
    -- la vague de soins n'est pas forcement sur nous
    -- le bouclier de terre n'est pas sur nous
  };


  Chaman2.proprieteLanceur = {
    ["LanceurArme"] = {
      ["associer"] = "CHAMAN2ARME",
    },
    ["LanceurBouclier"] = {
      ["associer"] = "CHAMAN2BOUCLIER",
    },
    ["LanceurBouclierTerre"] = {
      ["associer"] = "CHAMAN2BOUCLIERTERRE",
    },
    ["LanceurAir"] = {
      ["associer"] = "CHAMAN2AIR",
    },
    ["LanceurEau"] = {
      ["associer"] = "CHAMAN2EAU",
    },
    ["LanceurFeu"] = {
      ["associer"] = "CHAMAN2FEU",
    },
    ["LanceurTerre"] = {
      ["associer"] = "CHAMAN2TERRE",
    },
  };

  -- la configuration passe d'abord par un parcourt qui cherche les totems et qui renseigne les valeurs par
  -- defaut.
  Chaman2.configuration = {
    ["sorts"] = {
      -- remarque : tous les totems ont des temporisateurs actifs (mode 0) regle par defaut avec une duree de 2 minutes
      -- amelioration
      [Chaman2.traduction.totemFurieDesVents] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["frequenceTic"] = 5,
          ["genre"] = "Air",
        },
      },
      [Chaman2.traduction.totemLangueDeFeu] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["frequenceTic"] = 5,
          ["genre"] = "Feu",
        },
      },
      [Chaman2.traduction.totemSentinelle] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = 300,
          ["genre"] = "Air",
        },
      },
      [Chaman2.traduction.totemDeForceDeLaTerre] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Terre",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeForceDeLaTerre,
        },
      },
      [Chaman2.traduction.totemDeGlebe] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = 45,
          ["genre"] = "Air",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeGlebe,
        },
      },
      [Chaman2.traduction.totemDeGraceAerienne] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Air",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeGraceAerienne,
        },
      },
      [Chaman2.traduction.totemDeMurDesVents] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Air",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeMurDesVents,
        },
      },
      [Chaman2.traduction.totemDePeauDePierre] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Terre",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDePeauDePierre,
        },
      },
      [Chaman2.traduction.totemDeResistanceAuFeu] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Eau",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeResistanceAuFeu,
        },
      },
      [Chaman2.traduction.totemDeResistanceAuGivre] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Feu",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeResistanceAuGivre,
        },
      },
      [Chaman2.traduction.totemDeResistanceALaNature] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Air",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeResistanceALaNature,
        },
      },
      [Chaman2.traduction.totemDeCourrouxDeLAir] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Air",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeCourrouxDeLAir,
        },
      },
      [Chaman2.traduction.totemDElementaireDeTerre] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Terre",
        },
      },
      -- elementaire
      [Chaman2.traduction.totemNovaDeFeu] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = function ()
            local pc = Chaman2.pointDansTalent(Chaman2.traduction.talentTotemsDeFeuAmeliores,1);
            return (5-pc);
          end,
          ["genre"] = "Feu",
        },
      },
      [Chaman2.traduction.totemDeGriffesDePierre] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = 15,
          ["frequenceTic"] = 2,
          ["genre"] = "Terre",
          ["pointVie"] = function (rang)
            rang = tonumber(rang);
            local niv = UnitLevel("player");
            local base = 0;
            if rang==1 then base = 26;
            elseif rang==2 then base = 96;
            elseif rang==3 then base = 136;
            elseif rang==4 then base = 166;
            elseif rang==5 then base = 246;
            elseif rang==6 then base = 306;
            elseif rang==7 then base = 1114;
            end
            local pc = Chaman2.pointDansTalent(Chaman2.traduction.talentEmpriseDeLaTerre,1);
            return (base+3*niv)*(4+pc)/4;
          end
        },
      },
      [Chaman2.traduction.totemDeMagma] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = 20,
          ["frequenceTic"] = 2,
          ["genre"] = "Feu",
        },
      },
      [Chaman2.traduction.totemDeLienTerrestre] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = 45,
          ["frequenceTic"] = 3,
          ["decalageTic"] = .2,
          ["genre"] = "Terre",
        },
      },
      [Chaman2.traduction.totemIncendiaire] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = function (rang)
            return (25+5*rang);
          end,
          ["genre"] = "Feu",
        },
      },
      [Chaman2.traduction.totemDeCourroux] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Feu",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeCourroux,
        },
      },
      [Chaman2.traduction.totemDElementaireDeFeu] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Feu",
        },
      },
      -- restauration
      [Chaman2.traduction.totemFontaineDeMana] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Eau",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemFontaineDeMana,
        },
      },
      [Chaman2.traduction.totemDePurificationDesMaladies] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Eau",
          ["frequenceTic"] = 5,
        },
      },
      [Chaman2.traduction.totemDePurificationDuPoison] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Eau",
          ["frequenceTic"] = 5,
        },
      },
      [Chaman2.traduction.totemDeSeisme] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Terre",
          ["frequenceTic"] = 3,
        },
      },
      [Chaman2.traduction.totemDeTranquilliteDeLAir] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Air",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemDeTranquilliteDeLAir,
        },
      },
      [Chaman2.traduction.totemDeVagueDeMana] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = 12,
          ["frequenceTic"] = 3,
          ["genre"] = "Eau",
        },
      },
      [Chaman2.traduction.totemGuerisseur] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["genre"] = "Eau",
          ["amelioration"] = Chaman2.traduction.ameliorationTotemGuerisseur,
        },
      },
      [Chaman2.traduction.vagueDeSoins] = {
        ["temporisateurs"] = {
          {
            ["nom"] = "TemporisateurVague1",
            ["duree"] = 15,
            ["rafraichir"] = Chaman2.flotTicsDetruitTemps, -- rajoute la notion de numero de cible et enleve le nom de buff
            ["parametresRafraichir"] = 1,
            ["mode"] = 0, -- actif (duree non recuperable)
            ["termine"] = function ()
              Chaman2.cibleFlots[1] = "";
            end,
            ["cibleValide"] = function (cible)
              return Chaman2.remplaceCible(cible,1);
            end, -- oblige que la cible soit le joueur (pour ce temporisateur)
          },
          {
            ["nom"] = "TemporisateurVague2",
            ["duree"] = 15,
            ["rafraichir"] = Chaman2.flotTicsDetruitTemps, -- rajoute la notion de numero de cible et enleve le nom de buff
            ["parametresRafraichir"] = 2,
            ["mode"] = 0, -- actif (duree non recuperable)
            ["termine"] = function ()
              Chaman2.cibleFlots[2] = "";
            end,
            ["cibleValide"] = function (cible)
              return Chaman2.remplaceCible(cible,2);
            end, -- oblige que la cible soit le joueur (pour ce temporisateur)
          },
          {
            ["nom"] = "TemporisateurVague3",
            ["duree"] = 15,
            ["rafraichir"] = Chaman2.flotTicsDetruitTemps, -- rajoute la notion de numero de cible et enleve le nom de buff
            ["parametresRafraichir"] = 3,
            ["mode"] = 0, -- actif (duree non recuperable) appel a termine une fois le timer expirer
            ["termine"] = function ()
              Chaman2.cibleFlots[3] = "";
            end,
            ["cibleValide"] = function (cible)
              return Chaman2.remplaceCible(cible,3);
            end, -- oblige que la cible soit le joueur (pour ce temporisateur)
          },

        },
      },
      -- ankh
      [Chaman2.traduction.reincarnation] = {
        ["temporisateurs"] = {
          {
            ["nom"] = "TemporisateurAnkh",
            ["duree"] = function ()
              local base = 3600;
              local pc = Chaman2.pointDansTalent(Chaman2.traduction.talentReincarnationAmelioree,3);
              if pc==1 then
                base = 3000;
              elseif pc==2 then
                base = 1800;
              end
              return base;
            end,
            ["specifie"] = true, -- demande a etre specifie a la creation directement (valeur par defaut)
            ["mode"] = 2, -- completement passif (tps doit etre renseigne a tout moment)
            ["rafraichir"] = Chaman2.ankhTicsDetruitTemps,
          },
        },
      },
      -- le nom comme une fonction pour les armes ? TemporisateurArme1 ou TemporisateurArme2 [pas suffisant detection de chgmt d'arme galere]
      [Chaman2.traduction.armeDeGivre] = {
        ["temporisateurs"] = {
          {
            ["nom"] = "TemporisateurArme",
            ["duree"] = 1800,
            ["mode"] = 0, -- actif (ne fait aucune verif) rafraichir renvoie nil tjs
          },
        },
        ["lanceurs"] = {
          {
            ["nom"] = "LanceurArme",
          },
        },
      },
      [Chaman2.traduction.armeLangueDeFeu] = {
        ["temporisateurs"] = {
          {
            ["nom"] = "TemporisateurArme",
            ["duree"] = 1800,
            ["mode"] = 0,
          },
        },
        ["lanceurs"] = {
          {
            ["nom"] = "LanceurArme",
          },
        },
      },
      [Chaman2.traduction.armeCroqueRoc] = {
        ["temporisateurs"] = {
          {
            ["nom"] = "TemporisateurArme",
            ["duree"] = 1800,
            ["mode"] = 0,
          },
        },
        ["lanceurs"] = {
          {
            ["nom"] = "LanceurArme",
          },
        },
      },
      [Chaman2.traduction.armeFurieDesVents] = {
        ["temporisateurs"] = {
          {
            ["nom"] = "TemporisateurArme",
            ["duree"] = 1800,
            ["mode"] = 0,
          },
        },
        ["lanceurs"] = {
          {
            ["nom"] = "LanceurArme",
          },
        },
      },
      [Chaman2.traduction.bouclierDEau] = {
        ["temporisateurs"] = {
          {
            ["nom"] = "TemporisateurBouclier",
            ["duree"] = 600,
            ["rafraichir"] = Chaman2.bouclierTicsDetruitTemps,
            ["parametresRafraichir"] = Chaman2.traduction.bouclierDEau, -- amelioration identique au sort
            ["mode"] = 1, -- semi actif (passe actif quand le bouclier a disparu)
          },
        },
        ["lanceurs"] = {
          {
            ["nom"] = "LanceurBouclier",
          },
        },
      },
      [Chaman2.traduction.bouclierDeFoudre] = {
        ["temporisateurs"] = {
          {
            ["nom"] = "TemporisateurBouclier",
            ["duree"] = 600,
            ["rafraichir"] = Chaman2.bouclierTicsDetruitTemps,
            ["parametresRafraichir"] = Chaman2.traduction.bouclierDeFoudre, -- amelioration identique au sort
            ["mode"] = 1,
          },
        },
        ["lanceurs"] = {
          {
            ["nom"] = "LanceurBouclier",
          },
        },
      },
      [Chaman2.traduction.bouclierDeTerre] = {
        ["temporisateurs"] = {
          -- pq une liste -> pouvoir differencier la methode rafraichir,changement,le mode et la duree selon la cible par exemple
          {
            ["nom"] = "TemporisateurBouclier",
            ["duree"] = 600,
            ["rafraichir"] = Chaman2.bouclierTicsDetruitTemps,
            ["parametresRafraichir"] = Chaman2.traduction.bouclierDeTerre, -- amelioration identique au sort
            ["mode"] = 1,
            ["cibleValide"] = function (cible)
              if cible==UnitName("player") then
                return true;
              else
                return false;
              end
            end, -- oblige que la cible soit le joueur (pour ce temporisateur)
            -- (si cible renseigne alors le temporisateur n'est respecifie que si le nom de la cible correspond
            -- plusieurs cibles valide => augmenter la liste
            -- cible invalide ? (champs saufcible ?)
          },
          {
            ["nom"] = "TemporisateurBouclierTerre",
            ["duree"] = 600,
            ["rafraichir"] = Chaman2.bouclierTerreTicsDetruit, -- a changer (buff sur une autre personne)
            ["parametresRafraichir"] = Chaman2.traduction.bouclierDeTerre, -- amelioration identique au sort
            ["mode"] = 0, -- passif
            ["cibleValide"] = function (cible)
              if cible==UnitName("player") then
                return false;
              else
                return true;
              end
            end, -- oblige que la cible ne soit pas le joueur (pour ce temporisateur)
          },
        },
        ["lanceurs"] = {
          {
            ["nom"] = "LanceurBouclier",
            ["cible"] = "player",
          },
          {
            ["nom"] = "LanceurBouclierTerre",
            ["cible"] = "targettarget",
            ["texte"] = "A",
          },
          {
            ["nom"] = "LanceurBouclierTerre",
            ["cible"] = "target",
            ["texte"] = "T",
          },
          {
            ["nom"] = "LanceurBouclierTerre",
            ["cible"] = "focus",
            ["texte"] = "F",
          },
        },
      },
      -- fin des sorts
    },
    ["objets"] = {
      [Chaman2.traduction.totemEspritDeLEauAmoureux] = {
        ["temporisateurs"] = {},
        ["lanceurs"] = {},
        ["totem"] = {
          ["duree"] = 24,
          ["genre"] = "Eau",
          ["nom"] = Chaman2.traduction.nomTotemEspritDeLEauAmoureux,
          ["amelioration"] = Chaman2.traduction.ameliorationTotemEspritDeLEauAmoureux,
        },
      },
      -- fin objets
    },
  };
else
  DEFAULT_CHAT_FRAME:AddMessage("No translation found");
end

