if not Chaman2 then
  Chaman2 = {};
end

donneesChaman2 = nil;
chaman2BaseFrame = GetTime().."Chaman2";
chaman2Increment = 0;

function Chaman2.rafraichir()
  -- rafraichi les temporisateurs
  Chaman2.Temporisateur:demandeRafraichir();
  -- pis c'est tout pour le moment
end

function Chaman2.ankhTicsDetruitTemps(param,idSort)
  local deb, dur = GetSpellCooldown(idSort, BOOKTYPE_SPELL);
  local nbankh = GetItemCount(Chaman2.traduction.ankh);
  -- si plus d'ankh il triche en indiquant le temps maximum
  if nbankh==0 then
    return nbankh,true,Chaman2.configuration.sorts[Chaman2.traduction.reincarnation].temporisateurs[1].duree();
  else
    return nbankh,false,(dur-GetTime()+deb); -- jms de tics, jms en rouge
  end
end

function Chaman2.totemPose(genreNomPointVie,idSort)
  local genre,nom,pointVie = genreNomPointVie[1],genreNomPointVie[2],genreNomPointVie[3];
  -- debug(genreNomPointVie);
  if type(pointVie)=="function" then
    _,r = GetSpellName(idSort, BOOKTYPE_SPELL);
    pointVie = pointVie(Chaman2.premierEntierChaine(r));
  end
  Chaman2.nomEtVieDuTotem[genre] = { nom, pointVie };
end

function Chaman2.totemTicsDetruit(ameGenre)
  local ame,genre = ameGenre[1],ameGenre[2];
  local tics = -1;
  if ame then
    if Chaman2.infosBuff("player",ame) then
      tics = 1;
    else
      tics = 0;
    end
    for i=1,4 do
      if Chaman2.infosBuff("party"..i,ame) then
        tics = tics+1;
      end
    end
  end
  -- cherche le nombre de personne du groupe ayant l'amelioration ame
  -- tmp tjs egal a 0 sauf si pointVie(totem)<=0
  return tics,Chaman2.nomEtVieDuTotem[genre][2]<=0;
end


-- GetCheckedTexture():SetBlendMode("ADD")



function Chaman2.construireFramePrincipale()
  Chaman2.Boite:initialiser();
  local fc = CreateFrame("Frame","BoutonsDeClasse",UIParent,"SecureStateHeaderTemplate");
  fc:SetFrameStrata("LOW");
  fc:SetPoint("BOTTOM", UIParent,"BOTTOM",0,120);
  fc:SetMovable(true);
  fc:SetWidth(1);
  fc:SetHeight(1);
end

function Chaman2.gestionnaire(frame,e,u,s,r,c,m,n,o)
  if e=="UNIT_SPELLCAST_SENT" then
    if u=="player" then
      Chaman2.sortCourant = {s,(r or ""),c};  -- on ne s'interesse que a nous
      -- sort,rang,cible
    end
  elseif e=="UNIT_SPELLCAST_STOP" then
    if u=="player" then -- on ne s'interesse que a nous
      Chaman2.sortCourant = nil;
    end 
  elseif e=="UNIT_SPELLCAST_SUCCEEDED" then
    if u=="player" and Chaman2.sortCourant then -- on ne s'interesse que a nous
      local s,r,c = Chaman2.sortCourant[1],Chaman2.sortCourant[2],Chaman2.sortCourant[3];
      if s==Chaman2.traduction.bouclierDeTerre then
        donneesChaman2.cheminCibleBouclierDeTerre = Chaman2.trouverChemin(c);
        if donneesChaman2.cheminCibleBouclierDeTerre=="player" then
          donneesChaman2.cibleBouclierDeTerre = nil;
        else
          donneesChaman2.cibleBouclierDeTerre = c;
        end
        Chaman2.cibleBouclierDeTerre:SetText(donneesChaman2.cibleBouclierDeTerre);
      end
      Chaman2.Temporisateur:sortLance(s,r,c);
    end

  elseif e=="SPELLS_CHANGED" then
    Chaman2.MenuAction:actualiserIdSort();
  elseif e=="PLAYER_DEAD" then
    Chaman2.Temporisateur:joueurMort();
  elseif e=="PLAYER_ENTERING_WORLD" then
    Chaman2.Temporisateur:joueurZone();
  elseif e=="PLAYER_TARGET_CHANGED" then
    local _, cl = UnitClass("target");
    if Chaman2.derniereClasse then
      Chaman2.boutonSelonClasse[Chaman2.derniereClasse]:SetBackdropColor(0,0,0,1);
    end
    if cl and Chaman2.boutonSelonClasse[cl] then
      Chaman2.boutonSelonClasse[cl]:SetBackdropColor(1,0,0,1);
      Chaman2.derniereClasse = cl;
    end
  elseif e=="ADDON_LOADED" then
    if u=="Chaman2" then -- si c'est le bon add on
      local _, nomClasse = UnitClass("player");
      if nomClasse=="SHAMAN" then
        Chaman2.construireFramePrincipale(); -- les frames qui seront automatiquement repositionnes
        if GetNumTalentTabs()~=3 then 
          frame:RegisterEvent("PLAYER_ALIVE"); -- attend livre de sort, placement des frames et livre talents dispo pour activer
        else
          Chaman2.activer(frame);
        end
      end
      frame:UnregisterEvent("ADDON_LOADED"); 
    end
  elseif e=="COMBAT_LOG_EVENT" then
    -- inutile (pourrait qd mm servir a detecter les pvs restants d'un totem

    -- CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE est surement inutile et produit des bugs
    local degats = Chaman2.premierEntierChaine(u); -- le premier entier forcement les degats
    -- DEFAULT_CHAT_FRAME:AddMessage("degats "..degats.." chaine -> "..u);
    if degats and degats~=0 then
      -- chercher si c un des 4 totems courrants
      -- nomTotem = nomSort .. chiffreRomain(premierEntierChaine(rangSort))
      -- il manque des evenements a degats (il en manquait contre un guerrier)
      for _,nomVie in pairs(Chaman2.nomEtVieDuTotem) do
        -- pour chaque prefixe
        local npd,nc,degatsInfliges = table.getn(Chaman2.traduction.totemEstTouche),1,false;
        while(nc<=npd) and not degatsInfliges do
          if string.find(u,Chaman2.traduction.totemEstTouche[nc]..nomVie[1],1,true) then -- recherche plain
            nomVie[2] = nomVie[2]-degats;
            degatsInfliges = true;
          end
          nc = nc+1;
        end
      end
    end
  elseif e=="PLAYER_TOTEM_UPDATE" then
    local slotParElement = {"Feu", "Terre", "Eau", "Air"};
    for slot=1, MAX_TOTEMS do
    local _, _, _, duree = GetTotemInfo(slot);
      if duree<=0 then
        Chaman2.nomEtVieDuTotem[slotParElement[slot]][2] = -1;
      end
    end
  elseif e=="SPELL_UPDATE_COOLDOWN" then
    Chaman2.MenuAction:modifierAttente();
  elseif e=="UPDATE_BINDINGS" then
    Chaman2.actualiserAssociation();
  elseif e=="PLAYER_ALIVE" then -- inclus SPELLS_CHANGED (mais rajoute les talents)
    Chaman2.activer(frame);
    frame:UnregisterEvent("PLAYER_ALIVE");
  end -- fin du chargement
end


function Chaman2.chargement(frame)
  frame:SetScript("OnEvent", Chaman2.gestionnaire);
  frame:RegisterEvent("ADDON_LOADED");  
end

function Chaman2.formaterPourTotem()
  for _,tab in pairs(Chaman2.configuration) do
    for s,v in pairs(tab) do
      if v.totem then
        if v.lanceurs then
          table.insert(v.lanceurs,{
            ["nom"] = "Lanceur"..v.totem.genre, -- pas de cible, pas de texte
          });
        end
        if v.temporisateurs then
          table.insert(v.temporisateurs,{
            ["nom"] = "Temporisateur"..v.totem.genre,
            ["duree"] = v.totem.duree or 120,
            ["frequenceTic"] = v.totem.frequenceTic;
            ["decalageTic"] = v.totem.decalageTic or 0.43;
            ["changement"] = Chaman2.totemPose,
            ["parametresChangement"] = {v.totem.genre,v.totem.nom or s,v.totem.pointVie or 5}, -- v.totem.nom [manque le rang en chiffre romains]
            ["rafraichir"] = Chaman2.totemTicsDetruit,
            ["parametresRafraichir"] = {v.totem.amelioration,v.totem.genre},
            ["mode"] = 0, -- mode actif
          });
        end
      end
    end
  end
end


function Chaman2.activer(frame)
--[[
  local mmb = CreateFrame("Button","boutonminimap");
  mmb:SetPoint("CENTER", "Minimap", "CENTER", -80, 0);
  mmb:SetWidth(30);
  mmb:SetHeight(30);
  mmb:RegisterForClicks("LeftButtonUp","RightButtonUp");
  local t = mmb:CreateTexture();
  mmb:SetBackdrop(bckd);
  mmb:SetBackdropColor(0,0,0,1);
  mmb:SetBackdropBorderColor(0,0,0,0);
  t:SetTexCoord(0.25, 0.49609375, 0.25, 0.5);
  t:SetTexture("Interface\\WorldStateFrame\\Icons-Classes");
  t:SetAllPoints();
-- ]]

  if not donneesChaman2 then
    donneesChaman2 = {};
    donneesChaman2.version = 27;
    donneesChaman2.peutBouger = false;
    donneesChaman2.temporisateurs = {};
    donneesChaman2.lanceurs = {};
    donneesChaman2.modeAffichage = 1;
    donneesChaman2.afficheInfoBulle = true;
    -- + d'autres infos d'affichage etc
    donneesChaman2.frames = {};
    local nomSelonNum = {"Totems","ArmeBouclier","Terre","Ankh","BoutonsDeClasse","Vague"};
    for _,nom in ipairs(nomSelonNum) do
      donneesChaman2.frames[nom] = {["visible"]=true, ["mode"] = 0,};
    end
  end
  if donneesChaman2.version < 27 then
    if donneesChaman2.version<=22 then -- passage en 23
      donneesChaman2.frames = {};
      local nomSelonNum = {"Totems","ArmeBouclier","Terre","Ankh","BoutonsDeClasse","Vague"};
      for _,nom in ipairs(nomSelonNum) do
        donneesChaman2.frames[nom] = {["visible"]=true, ["mode"] = 0,};
      end
      donneesChaman2.version = 23;
    end
    if donneesChaman2.version<=24 then -- inverse 0 et 1 dans le passage en 25
      for _,v in ipairs(donneesChaman2.frames) do
        if v.mode==0 then
          v.mode = 1;
        else
          v.mode = 0;
        end
      end
      donneesChaman2.version = 25;
    end
    -- les versions 25, 26 et 27 sont compatibles
    donneesChaman2.version = 27;
  end

  for nf,info in pairs(donneesChaman2.frames) do
    local f = getglobal(nf);
    if f then
      if info.visible then
        f:Show();
      else
        f:Hide();
      end
    end
  end

  if not donneesChaman2.peutBouger then
    for nf,_ in pairs(Chaman2.boites) do
      getglobal(nf):EnableMouse(false);
    end
  end 


  local fb = getglobal("Terre");
  if fb then
    Chaman2.cibleBouclierDeTerre = fb:CreateFontString(nil,"ARTWORK","GameFontNormalSmall");
    Chaman2.cibleBouclierDeTerre:SetPoint("TOP",fb,"BOTTOM",0,5);
    Chaman2.cibleBouclierDeTerre:SetWidth(150);
    Chaman2.cibleBouclierDeTerre:SetHeight(12);
    Chaman2.cibleBouclierDeTerre:SetText(donneesChaman2.cibleBouclierDeTerre);
  end

  Chaman2.nomEtVieDuTotem = {};
  Chaman2.formaterPourTotem();

  Chaman2.Boite:activer();


  -- creer le bouton pr lancer l'appel totemique
  local amacro = CreateFrame("Button", "AppelTotemique2" ,nil, "SecureUnitButtonTemplate");
  amacro:SetAttribute("type","spell");
  amacro:SetAttribute("spell",Chaman2.traduction.appelTotemique);


  -- boutons pour set de classe


  local coordonneesClasse = {
    ["WARRIOR"] = {0, 0.25, 0, 0.25},
    ["MAGE"] = {0.25, 0.49609375, 0, 0.25},
    ["ROGUE"] = {0.49609375, 0.7421875, 0, 0.25},
    ["DRUID"] = {0.7421875, 0.98828125, 0, 0.25},
    ["HUNTER"] = {0, 0.25, 0.25, 0.5},
    ["SHAMAN"] = {0.25, 0.49609375, 0.25, 0.5},
    ["PRIEST"] = {0.49609375, 0.7421875, 0.25, 0.5},
    ["WARLOCK"] = {0.7421875, 0.98828125, 0.25, 0.5},
    ["PALADIN"] = {0, 0.25, 0.5, 0.75},
  };


  local bckd = {};
  bckd.bgFile = "Interface/Tooltips/UI-Tooltip-Background";
  bckd.edgeFile = "Interface/Tooltips/UI-Tooltip-Border";
  bckd.tile = true;
  bckd.tileSize = 16;
  bckd.edgeSize = 16;
  bckd.insets = {};
  bckd.insets.left = 0;
  bckd.insets.right = 0;
  bckd.insets.top = 0;
  bckd.insets.bottom = 0;

  Chaman2.boutonSelonClasse = {};


  local i = 0;
  local fc = getglobal("BoutonsDeClasse");

  for c,v in pairs(coordonneesClasse) do
    local dernierlie = Chaman2.Boite:obtenirParNom("Totems"):lierSauvegardeA("SEC"..i);

    local b = CreateFrame("Button",chaman2BaseFrame..chaman2Increment, fc , "SecureUnitButtonTemplate");
    chaman2Increment = chaman2Increment+1;
    b:SetPoint("CENTER", fc,"CENTER",i*30-30*4,0);
    b:SetWidth(30);
    b:SetHeight(30);

    b:RegisterForClicks("LeftButtonUp","RightButtonUp");
    b:SetAttribute("type","click");
    b:SetAttribute("statebutton1","*:SEC"..i);
    b:SetAttribute("clickbutton-SEC"..i,dernierlie);
    fc:SetAttribute("addchild", b);

    b.bouton = "SEC"..i;

    b:SetScript("PreClick",function (self,bout)
      if bout=="RightButton" then
          if not InCombatLockdown() then
          --[[
          local liaisons = {"LanceurAir","LanceurEau","LanceurFeu","LanceurTerre"};
          -- effectue la liaison (si les lanceurs existent)
          for _,v in ipairs(liaisons) do
            if donneesChaman2.lanceurs[v] then
              donneesChaman2.lanceurs[v]:sauvegarderEtat(self.bouton);
            end
          end
          -- ]]
          Chaman2.Boite:obtenirParNom("Totems"):sauvegarderEtat(self.bouton);
          DEFAULT_CHAT_FRAME:AddMessage("Set saved");
        else
          DEFAULT_CHAT_FRAME:AddMessage("You can not save a set while in combat");
        end
      end
    end);

    b:RegisterForDrag("LeftButton");
    b:SetScript("OnDragStop",function (self)
      self:GetParent():StopMovingOrSizing();
      ValidateFramePosition(self);
    end);
    b:SetScript("OnDragStart",function (self)
      if donneesChaman2.peutBouger then
        self:GetParent():StartMoving();
      end
    end);

    local t = b:CreateTexture();

    b:SetBackdrop(bckd);
    b:SetBackdropColor(0,0,0,1);
    b:SetBackdropBorderColor(0,0,0,0);

    t:SetTexCoord(v[1], v[2], v[3], v[4]);
    t:SetTexture("Interface\\WorldStateFrame\\Icons-Classes");
    t:SetAllPoints();
    Chaman2.boutonSelonClasse[c] = b;
    i=i+1;
  end

  Chaman2.actualiserAssociation();

  frame:RegisterEvent("PLAYER_ENTERING_WORLD");
  frame:RegisterEvent("PLAYER_DEAD");
  frame:RegisterEvent("SPELLS_CHANGED");
  frame:RegisterEvent("UNIT_SPELLCAST_STOP");
  frame:RegisterEvent("UNIT_SPELLCAST_SENT");
  frame:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
  frame:RegisterEvent("RAID_ROSTER_UPDATE"); -- pr reactu les membres hors raid
  frame:RegisterEvent("PARTY_MEMBERS_CHANGED"); -- idem hors groupe (et hors raid si hors du raid)
  frame:RegisterEvent("SPELL_UPDATE_COOLDOWN");
  -- frame:RegisterEvent("COMBAT_LOG_EVENT");
  frame:RegisterEvent("PLAYER_TOTEM_UPDATE");
  frame:RegisterEvent("PLAYER_TARGET_CHANGED");
  frame:RegisterEvent("UPDATE_BINDINGS");
  
  Chaman2.InterfaceUtilisateur:construireFrame();

  frame:SetScript("OnUpdate", Chaman2.rafraichir);
  SLASH_CHAMAN21 = "/chaman2";
  SLASH_CHAMAN22 = "/c2";
  SlashCmdList["CHAMAN2"] = function (msg) Chaman2.InterfaceUtilisateur:commandeLigne(msg) end;
  frame:Show(); -- lance la methode update
end

