if not Chaman2 then
  Chaman2 = {};
end

--[[
  package Chaman2

  class Temporisateur
    static nil sortLance(s,r,c)
    -> Informe les temporisateurs que le sort `s de rang `r a ete lance sur la cible `c
    static nil demandeRafraichir()
    -> Rafraichie l'affichage de tous les temporisateurs
    static formaterTemporisateur(tab)
    -> ...

]]

Chaman2.Boite = {}; -- la classe
Chaman2.Boite.instances = {}; -- les objets
Chaman2.Boite.methodes = {}; -- les methodes
Chaman2.Boite.methodes.class = Chaman2.Boite; -- permet de lie la classe a l'objet

Chaman2.Boite.position = 120+40;

-- appelle la methode demarrer sur les temporisateurs qui ecoutent le sort
function Chaman2.Boite:initialiser()
  local class = self;
  self = nil;

  for nf,info in pairs(Chaman2.boites) do
    Chaman2.Boite:creer(nf,info);
  end
end

function Chaman2.Boite:activer()
  local class = self;
  self = nil;

  -- Donne les configuration par tempo/lanceur
  local temporisateurConfig = Chaman2.Temporisateur:formaterTemporisateur(Chaman2.configuration);
  local lanceurConfig = Chaman2.MenuAction:formaterLanceur(Chaman2.configuration);

  for _,v in ipairs(class.instances) do
    v:activer(temporisateurConfig,lanceurConfig); -- chaque  Boite saura prendre les infos qui les interesse 
  end
end

function Chaman2.Boite.methodes:activer(tempConf,lancConf) -- on conserve l'ecoulement du temps
  for num,nom in ipairs(self.nomTemporisateurs) do
    if tempConf[nom] then
      local sau = donneesChaman2.temporisateurs[nom];
      if not sau then
        sau = {};
        donneesChaman2.temporisateurs[nom] = sau;
      end
      local prop = Chaman2.proprieteTemporisateur[nom];
      if not prop then prop = {}; end
      if not prop["enleverMort"] then prop["enleverMort"] = false; end
      if not prop["enleverZone"] then prop["enleverZone"] = false; end
      if not prop["sortEnlevant"] then prop["sortEnlevant"] = function () return false; end end

      if donneesChaman2.frames[self.nf].mode==0 then -- si mode a gauche
        table.insert(self.temporisateurs,Chaman2.Temporisateur:creer(self.frame,5,5+(num-1)*35,tempConf[nom],sau,prop["enleverMort"],prop["enleverZone"],prop["sortEnlevant"]));
      else
        table.insert(self.temporisateurs,Chaman2.Temporisateur:creer(self.frame,40,5+(num-1)*35,tempConf[nom],sau,prop["enleverMort"],prop["enleverZone"],prop["sortEnlevant"]));
      end
    end
  end
  
  for num,nom in ipairs(self.nomLanceurs) do
    if lancConf[nom] then
      local prop = Chaman2.proprieteLanceur[nom];
      local ordre,nouvelleSauvegarde = Chaman2.MenuAction:ordonner(lancConf[nom],donneesChaman2.lanceurs[nom]);
      donneesChaman2.lanceurs[nom] = nouvelleSauvegarde;
      if donneesChaman2.frames[self.nf].mode==0 then
        table.insert(self.lanceurs,Chaman2.MenuAction:creer(self.frame,110, 5+(num-1)*35 ,ordre,1,0,nouvelleSauvegarde,prop["associer"]));
      else
        table.insert(self.lanceurs,Chaman2.MenuAction:creer(self.frame,5, 5+(num-1)*35 ,ordre,-1,0,nouvelleSauvegarde,prop["associer"]));
      end
    end
  end

  self.frb = {};

  if self.chaine then
    local selections = {};
    for i=1,table.getn(self.nomLanceurs) do
      local fto = self.frame;
      local frb = CreateFrame("Frame",self.nf.."Relance"..(i-1).."Bordure",fto);
      self.frb[i] = frb;
      frb:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
                              edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                              tile = true, tileSize = 8,
                              edgeSize = 8,
                              insets = { left = 0, right = 0, top = 0, bottom = 0 }});
      frb:SetBackdropColor(0,1,0,1);
      frb:SetBackdropBorderColor(0,0,0,0);
      if donneesChaman2.frames["Totems"].mode==0 then
        frb:SetPoint("TOPLEFT",fto,"TOPLEFT",110,-(i*35));
      else
        frb:SetPoint("TOPLEFT",fto,"TOPLEFT",5,-(i*35));
      end
      frb:SetWidth(30);
      frb:SetHeight(3);
      frb:Hide();
      -- frb:Show();
      frb:SetAlpha(1);
      table.insert(selections,frb);
    end

    local far = CreateFrame("Frame", chaman2BaseFrame..chaman2Increment, FrameRelance, "SecureStateHeaderTemplate");
    chaman2Increment=chaman2Increment+1;
    far.selections = selections;
    far:SetAttribute("state", "0");
    function far:StateChanged(nv)
      nv = tonumber(nv);
      local anc = nv-1;
      if anc==-1 then 
        anc=3;
      end
      self.selections[anc+1]:Hide();
      self.selections[nv+1]:Show();
    end

    -- 0 air 1 eau 2 feu 3 terre  

    local rmacro = CreateFrame("Button", "RelanceSuivant2" ,far, "SecureUnitButtonTemplate");
    rmacro:SetAttribute("newstate", "0-3");
    rmacro:SetAttribute("statebutton","0:S0;1:S1;2:S2;3:S3;");
    rmacro:SetAttribute("type","click");
    for i=0,3 do
     local l = self.lanceurs[i+1];
      if l then
        rmacro:SetAttribute("*clickbutton-S"..i,l:raccourci());
      end
    end
    far:SetAttribute("addchild", rmacro);

    local pmacro = CreateFrame("Button", "RelancePrecedant2" ,far, "SecureUnitButtonTemplate");
    pmacro:SetAttribute("statebutton","0:S3;1:S0;2:S1;3:S2;");
    pmacro:SetAttribute("type","click");
    for i=0,3 do
      local l = self.lanceurs[i+1];
      if l then
        pmacro:SetAttribute("*clickbutton-S"..i,l:raccourci());
      end
    end
    far:SetAttribute("addchild", pmacro);


    local nmacro = CreateFrame("Button", "PasseSuivant2" ,far, "SecureUnitButtonTemplate");
    nmacro:SetAttribute("newstate", "0-3");
    far:SetAttribute("addchild", nmacro);



  end


end


function Chaman2.Boite:obtenirParNom(nf)
  local class = self;
  self = nil;
  for _,v in ipairs(class.instances) do
    if v.nf == nf then
      return v;
    end
  end
  return nil;
end

function Chaman2.Boite:modifierTooltip() -- appele a chaque 
  local class = self;
  self = nil;
  for _,v in ipairs(class.instances) do
    -- v:sortLance(s,r,c);
  end
end



-- rajouter mode bouton ?
-- si c'est un temporisateur passif c marque dans tab (et dans ce cas ne contient pas de tableau de sorts)

function Chaman2.Boite:creer(nf,info)
  local class = self;
  self = {};
  setmetatable(self,{__index = class.methodes});
  table.insert(class.instances,self);

  self.nf = nf;

  local hau = max(table.getn(info.temporisateurs or {}),table.getn(info.lanceurs or {}))*35+5;

  self.frame = CreateFrame("Frame",nf,UIParent);
  self.frame:SetFrameStrata("LOW");
  self.frame:SetPoint("BOTTOM",UIParent,"BOTTOM",0,class.position);
  class.position = class.position+hau+10;

  self.frame:SetWidth(5+100+5+30+5);
  self.frame:SetHeight(hau);
  self.frame:EnableMouse(true);
  self.frame:SetMovable(true);
  self.frame:SetToplevel(true);

  self.frame:RegisterForDrag("LeftButton");
  self.frame:SetScript("OnDragStop",function (self)
    self:StopMovingOrSizing();
    ValidateFramePosition(self);
  end);
  self.frame:SetScript("OnDragStart",function (self)
    self:StartMoving();
  end);


    --[[
    local f = self.frame;
    local bckd = {};
    bckd.bgFile = "Interface/Tooltips/UI-Tooltip-Background";
    bckd.edgeFile = "Interface/Tooltips/UI-Tooltip-Border";
    bckd.tile = true;
    bckd.tileSize = 16;
    bckd.edgeSize = 16;
    bckd.insets = {};
    bckd.insets.left = 4;
    bckd.insets.right = 4;
    bckd.insets.top = 4;
    bckd.insets.bottom = 4;

    f:SetBackdrop(bckd);
    f:SetBackdropColor(0,0,0,1);
    f:SetBackdropBorderColor(.3,.3,.3,1);
    -- ]]


  self.nomTemporisateurs = (info.temporisateurs or {});
  self.nomLanceurs = (info.lanceurs or {});
  self.chaine = info.chaine;
  self.temporisateurs = {};
  self.lanceurs = {};
  return self;
end



function Chaman2.Boite.methodes:toutEnlever()
  for _,v in pairs(self.temporisateurs) do
    v:enlever();
  end
end

function Chaman2.Boite.methodes:modifierSens(versGauche)
  if versGauche then -- mode gauche
    for i,frb in ipairs(self.frb) do
      frb:SetPoint("TOPLEFT",self.frame,"TOPLEFT",110,-(i*35));    
    end
    for num,v in pairs(self.temporisateurs) do
      v:modifierSens(true);
      v:fixerPosition(self.frame,5,5+(num-1)*35);
    end
    for num,v in pairs(self.lanceurs) do
      v:modifierSens(true);
      v:fixerPosition(self.frame,110, 5+(num-1)*35);
    end
  else -- mode droite
    for i,frb in ipairs(self.frb) do
      frb:SetPoint("TOPLEFT",self.frame,"TOPLEFT",5,-(i*35));
    end
    for num,v in pairs(self.temporisateurs) do
      v:modifierSens(false);
      v:fixerPosition(self.frame,40,5+(num-1)*35);
    end
    for num,v in pairs(self.lanceurs) do
      v:modifierSens(false);
      v:fixerPosition(self.frame,5, 5+(num-1)*35);
    end
  end
end

function Chaman2.Boite.methodes:detacherMenuAction(separe) -- on conserve l'ecoulement du temps
  -- separe les temporisateurs des 
  if separe then
  else
  end
end

function Chaman2.Boite.methodes:sauvegarderEtat(bouton)
  for _,lanceur in ipairs(self.lanceurs) do
    lanceur:sauvegarderEtat(bouton);
  end
end

function Chaman2.Boite.methodes:lierSauvegardeA(nom)
  local dernierlie = nil;
  for _,v in ipairs(self.lanceurs) do
    dernierlie = v:lierSauvegardeA(nom,dernierlie);
  end
  return dernierlie;
end

